# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""A DICOM library"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _gdcmswig
else:
    import _gdcmswig

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_SwigPyIterator

    def value(self):
        return _gdcmswig.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _gdcmswig.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _gdcmswig.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _gdcmswig.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _gdcmswig.SwigPyIterator_equal(self, x)

    def copy(self):
        return _gdcmswig.SwigPyIterator_copy(self)

    def next(self):
        return _gdcmswig.SwigPyIterator_next(self)

    def __next__(self):
        return _gdcmswig.SwigPyIterator___next__(self)

    def previous(self):
        return _gdcmswig.SwigPyIterator_previous(self)

    def advance(self, n):
        return _gdcmswig.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _gdcmswig.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _gdcmswig.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _gdcmswig.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _gdcmswig.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _gdcmswig.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _gdcmswig.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _gdcmswig:
_gdcmswig.SwigPyIterator_swigregister(SwigPyIterator)
PUB_DICT_PATH = _gdcmswig.PUB_DICT_PATH
GDCM_SOURCE_DIR = _gdcmswig.GDCM_SOURCE_DIR
GDCM_EXECUTABLE_OUTPUT_PATH = _gdcmswig.GDCM_EXECUTABLE_OUTPUT_PATH
GDCM_LIBRARY_OUTPUT_PATH = _gdcmswig.GDCM_LIBRARY_OUTPUT_PATH
GDCM_CMAKE_INSTALL_PREFIX = _gdcmswig.GDCM_CMAKE_INSTALL_PREFIX
GDCM_INSTALL_INCLUDE_DIR = _gdcmswig.GDCM_INSTALL_INCLUDE_DIR
GDCM_INSTALL_DATA_DIR = _gdcmswig.GDCM_INSTALL_DATA_DIR
GDCM_PVRG_JPEG_EXECUTABLE = _gdcmswig.GDCM_PVRG_JPEG_EXECUTABLE
GDCM_KAKADU_EXPAND_EXECUTABLE = _gdcmswig.GDCM_KAKADU_EXPAND_EXECUTABLE
GDCM_MAJOR_VERSION = _gdcmswig.GDCM_MAJOR_VERSION
GDCM_MINOR_VERSION = _gdcmswig.GDCM_MINOR_VERSION
GDCM_BUILD_VERSION = _gdcmswig.GDCM_BUILD_VERSION
GDCM_VERSION = _gdcmswig.GDCM_VERSION
GDCM_API_VERSION = _gdcmswig.GDCM_API_VERSION
class SwapCode(object):
    r"""


    SwapCode representation.

    C++ includes: gdcmSwapCode.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Unknown = _gdcmswig.SwapCode_Unknown
    LittleEndian = _gdcmswig.SwapCode_LittleEndian
    BigEndian = _gdcmswig.SwapCode_BigEndian
    BadLittleEndian = _gdcmswig.SwapCode_BadLittleEndian
    BadBigEndian = _gdcmswig.SwapCode_BadBigEndian

    def __init__(self, *args):
        r"""gdcm::SwapCode::SwapCode(SwapCodeType sc=Unknown)"""
        _gdcmswig.SwapCode_swiginit(self, _gdcmswig.new_SwapCode(*args))

    @staticmethod
    def GetSwapCodeString(sc):
        return _gdcmswig.SwapCode_GetSwapCodeString(sc)
    __swig_destroy__ = _gdcmswig.delete_SwapCode

# Register SwapCode in _gdcmswig:
_gdcmswig.SwapCode_swigregister(SwapCode)
class Event(object):
    r"""


    superclass for callback/observer methods

    See:   Command Subject

    C++ includes: gdcmEvent.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_Event

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.Event_MakeObject(self)

    def Print(self, os):
        r"""
        virtual void
        gdcm::Event::Print(std::ostream &os) const

        Print Event information. This method can be overridden by specific
        Event subtypes. The default is to print out the type of the event. 
        """
        return _gdcmswig.Event_Print(self, os)

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.Event_GetEventName(self)

    def CheckEvent(self, arg2):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.Event_CheckEvent(self, arg2)

# Register Event in _gdcmswig:
_gdcmswig.Event_swigregister(Event)
class NoEvent(Event):
    r"""


    Define some common GDCM events

    C++ includes: gdcmEvent.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_NoEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.NoEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.NoEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.NoEvent_MakeObject(self)

# Register NoEvent in _gdcmswig:
_gdcmswig.NoEvent_swigregister(NoEvent)
class AnyEvent(Event):
    r"""C++ includes: gdcmEvent.h"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_AnyEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.AnyEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.AnyEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.AnyEvent_MakeObject(self)

# Register AnyEvent in _gdcmswig:
_gdcmswig.AnyEvent_swigregister(AnyEvent)
class StartEvent(AnyEvent):
    r"""C++ includes: gdcmEvent.h"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_StartEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.StartEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.StartEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.StartEvent_MakeObject(self)

# Register StartEvent in _gdcmswig:
_gdcmswig.StartEvent_swigregister(StartEvent)
class EndEvent(AnyEvent):
    r"""C++ includes: gdcmEvent.h"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_EndEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.EndEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.EndEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.EndEvent_MakeObject(self)

# Register EndEvent in _gdcmswig:
_gdcmswig.EndEvent_swigregister(EndEvent)
class ExitEvent(AnyEvent):
    r"""C++ includes: gdcmEvent.h"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_ExitEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.ExitEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.ExitEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.ExitEvent_MakeObject(self)

# Register ExitEvent in _gdcmswig:
_gdcmswig.ExitEvent_swigregister(ExitEvent)
class AbortEvent(AnyEvent):
    r"""C++ includes: gdcmEvent.h"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_AbortEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.AbortEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.AbortEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.AbortEvent_MakeObject(self)

# Register AbortEvent in _gdcmswig:
_gdcmswig.AbortEvent_swigregister(AbortEvent)
class ModifiedEvent(AnyEvent):
    r"""
    C++ includes: gdcmEvent.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_ModifiedEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.ModifiedEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.ModifiedEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.ModifiedEvent_MakeObject(self)

# Register ModifiedEvent in _gdcmswig:
_gdcmswig.ModifiedEvent_swigregister(ModifiedEvent)
class InitializeEvent(AnyEvent):
    r"""
    C++ includes:
    gdcmEvent.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_InitializeEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.InitializeEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.InitializeEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.InitializeEvent_MakeObject(self)

# Register InitializeEvent in _gdcmswig:
_gdcmswig.InitializeEvent_swigregister(InitializeEvent)
class IterationEvent(AnyEvent):
    r"""
    C++ includes: gdcmEvent.h

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_IterationEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.IterationEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.IterationEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.IterationEvent_MakeObject(self)

# Register IterationEvent in _gdcmswig:
_gdcmswig.IterationEvent_swigregister(IterationEvent)
class UserEvent(AnyEvent):
    r"""C++ includes: gdcmEvent.h"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_UserEvent

    def GetEventName(self):
        r"""
        virtual const char*
        gdcm::Event::GetEventName() const =0

        Return the StringName associated with the event. 
        """
        return _gdcmswig.UserEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        virtual bool
        gdcm::Event::CheckEvent(const Event *) const =0

        Check if given event matches or derives from this event. 
        """
        return _gdcmswig.UserEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        virtual Event*
        gdcm::Event::MakeObject() const =0

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.UserEvent_MakeObject(self)

# Register UserEvent in _gdcmswig:
_gdcmswig.UserEvent_swigregister(UserEvent)
class PixelFormat(object):
    r"""


    PixelFormat.

    By default the Pixel Type will be instantiated with the following
    parameters: SamplesPerPixel : 1

    BitsAllocated : 8

    BitsStored : 8

    HighBit : 7

    PixelRepresentation : 0

    Fundamentally PixelFormat is very close to what DICOM allows. It will
    be very hard to extend this class for the upcoming DICOM standard
    where Floating 32 and 64bits will be allowed.

    It is also very hard for this class to fully support 64bits integer
    type (see GetMin / GetMax signature restricted to 64bits signed).

    C++ includes: gdcmPixelFormat.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    UINT8 = _gdcmswig.PixelFormat_UINT8
    INT8 = _gdcmswig.PixelFormat_INT8
    UINT12 = _gdcmswig.PixelFormat_UINT12
    INT12 = _gdcmswig.PixelFormat_INT12
    UINT16 = _gdcmswig.PixelFormat_UINT16
    INT16 = _gdcmswig.PixelFormat_INT16
    UINT32 = _gdcmswig.PixelFormat_UINT32
    INT32 = _gdcmswig.PixelFormat_INT32
    UINT64 = _gdcmswig.PixelFormat_UINT64
    INT64 = _gdcmswig.PixelFormat_INT64
    FLOAT16 = _gdcmswig.PixelFormat_FLOAT16
    FLOAT32 = _gdcmswig.PixelFormat_FLOAT32
    FLOAT64 = _gdcmswig.PixelFormat_FLOAT64
    SINGLEBIT = _gdcmswig.PixelFormat_SINGLEBIT
    UNKNOWN = _gdcmswig.PixelFormat_UNKNOWN

    def __init__(self, *args):
        r"""
        gdcm::PixelFormat::PixelFormat(unsigned short samplesperpixel,
        unsigned short bitsallocated=8, unsigned short bitsstored=8, unsigned
        short highbit=7, unsigned short pixelrepresentation=0) 
        """
        _gdcmswig.PixelFormat_swiginit(self, _gdcmswig.new_PixelFormat(*args))

    def GetSamplesPerPixel(self):
        r"""
        unsigned short gdcm::PixelFormat::GetSamplesPerPixel() const

        Samples Per Pixel see (0028,0002) US Samples Per Pixel DICOM - only
        allows 1, 3 and 4 as valid value. Other value are undefined behavior.

        """
        return _gdcmswig.PixelFormat_GetSamplesPerPixel(self)

    def SetSamplesPerPixel(self, spp):
        r"""
        void
        gdcm::PixelFormat::SetSamplesPerPixel(unsigned short spp) 
        """
        return _gdcmswig.PixelFormat_SetSamplesPerPixel(self, spp)

    def GetBitsAllocated(self):
        r"""
        unsigned
        short gdcm::PixelFormat::GetBitsAllocated() const

        BitsAllocated see Tag (0028,0100) US Bits Allocated. 
        """
        return _gdcmswig.PixelFormat_GetBitsAllocated(self)

    def SetBitsAllocated(self, ba):
        r"""
        void
        gdcm::PixelFormat::SetBitsAllocated(unsigned short ba) 
        """
        return _gdcmswig.PixelFormat_SetBitsAllocated(self, ba)

    def GetBitsStored(self):
        r"""
        unsigned
        short gdcm::PixelFormat::GetBitsStored() const

        BitsStored see Tag (0028,0101) US Bits Stored. 
        """
        return _gdcmswig.PixelFormat_GetBitsStored(self)

    def SetBitsStored(self, bs):
        r"""
        void
        gdcm::PixelFormat::SetBitsStored(unsigned short bs) 
        """
        return _gdcmswig.PixelFormat_SetBitsStored(self, bs)

    def GetHighBit(self):
        r"""
        unsigned short
        gdcm::PixelFormat::GetHighBit() const

        HighBit see Tag (0028,0102) US High Bit. 
        """
        return _gdcmswig.PixelFormat_GetHighBit(self)

    def SetHighBit(self, hb):
        r"""
        void
        gdcm::PixelFormat::SetHighBit(unsigned short hb) 
        """
        return _gdcmswig.PixelFormat_SetHighBit(self, hb)

    def GetPixelRepresentation(self):
        r"""
        unsigned short gdcm::PixelFormat::GetPixelRepresentation() const

        PixelRepresentation: 0 or 1, see Tag (0028,0103) US Pixel
        Representation. 
        """
        return _gdcmswig.PixelFormat_GetPixelRepresentation(self)

    def SetPixelRepresentation(self, pr):
        r"""void gdcm::PixelFormat::SetPixelRepresentation(unsigned short pr)"""
        return _gdcmswig.PixelFormat_SetPixelRepresentation(self, pr)

    def GetScalarType(self):
        r"""
        ScalarType
        gdcm::PixelFormat::GetScalarType() const

        ScalarType does not take into account the sample per pixel. 
        """
        return _gdcmswig.PixelFormat_GetScalarType(self)

    def SetScalarType(self, st):
        r"""
        void
        gdcm::PixelFormat::SetScalarType(ScalarType st)

        Set PixelFormat based only on the ScalarType WARNING:  : You need to
        call SetScalarType before SetSamplesPerPixel 
        """
        return _gdcmswig.PixelFormat_SetScalarType(self, st)

    def GetScalarTypeAsString(self):
        r"""const char* gdcm::PixelFormat::GetScalarTypeAsString() const"""
        return _gdcmswig.PixelFormat_GetScalarTypeAsString(self)

    def GetPixelSize(self):
        r"""
        uint8_t
        gdcm::PixelFormat::GetPixelSize() const

        return the size of the pixel This is the number of words it would take
        to store one pixel WARNING:  the return value takes into account the
        SamplesPerPixel

        WARNING:  in the rare case when BitsAllocated == 12, the function
        assume word padding and value returned will be identical as if
        BitsAllocated == 16 
        """
        return _gdcmswig.PixelFormat_GetPixelSize(self)

    def Print(self, os):
        r"""
        void
        gdcm::PixelFormat::Print(std::ostream &os) const

        Print. 
        """
        return _gdcmswig.PixelFormat_Print(self, os)

    def GetMin(self):
        r"""
        int64_t
        gdcm::PixelFormat::GetMin() const

        return the min possible of the pixel 
        """
        return _gdcmswig.PixelFormat_GetMin(self)

    def GetMax(self):
        r"""
        int64_t
        gdcm::PixelFormat::GetMax() const

        return the max possible of the pixel 
        """
        return _gdcmswig.PixelFormat_GetMax(self)

    def IsValid(self):
        r"""
        bool
        gdcm::PixelFormat::IsValid() const

        return IsValid 
        """
        return _gdcmswig.PixelFormat_IsValid(self)

    def __eq__(self, *args):
        return _gdcmswig.PixelFormat___eq__(self, *args)

    def __ne__(self, *args):
        return _gdcmswig.PixelFormat___ne__(self, *args)

    def IsCompatible(self, ts):
        r"""
        bool
        gdcm::PixelFormat::IsCompatible(const TransferSyntax &ts) const 
        """
        return _gdcmswig.PixelFormat_IsCompatible(self, ts)

    def __str__(self):
        return _gdcmswig.PixelFormat___str__(self)
    __swig_destroy__ = _gdcmswig.delete_PixelFormat

# Register PixelFormat in _gdcmswig:
_gdcmswig.PixelFormat_swigregister(PixelFormat)
class MediaStorage(object):
    r"""


    MediaStorage.

    FIXME There should not be any notion of Image and/or PDF at that point
    Only the codec can answer yes I support this Media Storage or not...
    For instance an ImageCodec will answer yes to most of them while a
    PDFCodec will answer only for the Encapsulated PDF

    See:   UIDs

    C++ includes: gdcmMediaStorage.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    MediaStorageDirectoryStorage = _gdcmswig.MediaStorage_MediaStorageDirectoryStorage
    ComputedRadiographyImageStorage = _gdcmswig.MediaStorage_ComputedRadiographyImageStorage
    DigitalXRayImageStorageForPresentation = _gdcmswig.MediaStorage_DigitalXRayImageStorageForPresentation
    DigitalXRayImageStorageForProcessing = _gdcmswig.MediaStorage_DigitalXRayImageStorageForProcessing
    DigitalMammographyImageStorageForPresentation = _gdcmswig.MediaStorage_DigitalMammographyImageStorageForPresentation
    DigitalMammographyImageStorageForProcessing = _gdcmswig.MediaStorage_DigitalMammographyImageStorageForProcessing
    DigitalIntraoralXrayImageStorageForPresentation = _gdcmswig.MediaStorage_DigitalIntraoralXrayImageStorageForPresentation
    DigitalIntraoralXRayImageStorageForProcessing = _gdcmswig.MediaStorage_DigitalIntraoralXRayImageStorageForProcessing
    CTImageStorage = _gdcmswig.MediaStorage_CTImageStorage
    EnhancedCTImageStorage = _gdcmswig.MediaStorage_EnhancedCTImageStorage
    UltrasoundImageStorageRetired = _gdcmswig.MediaStorage_UltrasoundImageStorageRetired
    UltrasoundImageStorage = _gdcmswig.MediaStorage_UltrasoundImageStorage
    UltrasoundMultiFrameImageStorageRetired = _gdcmswig.MediaStorage_UltrasoundMultiFrameImageStorageRetired
    UltrasoundMultiFrameImageStorage = _gdcmswig.MediaStorage_UltrasoundMultiFrameImageStorage
    MRImageStorage = _gdcmswig.MediaStorage_MRImageStorage
    EnhancedMRImageStorage = _gdcmswig.MediaStorage_EnhancedMRImageStorage
    MRSpectroscopyStorage = _gdcmswig.MediaStorage_MRSpectroscopyStorage
    NuclearMedicineImageStorageRetired = _gdcmswig.MediaStorage_NuclearMedicineImageStorageRetired
    SecondaryCaptureImageStorage = _gdcmswig.MediaStorage_SecondaryCaptureImageStorage
    MultiframeSingleBitSecondaryCaptureImageStorage = _gdcmswig.MediaStorage_MultiframeSingleBitSecondaryCaptureImageStorage
    MultiframeGrayscaleByteSecondaryCaptureImageStorage = _gdcmswig.MediaStorage_MultiframeGrayscaleByteSecondaryCaptureImageStorage
    MultiframeGrayscaleWordSecondaryCaptureImageStorage = _gdcmswig.MediaStorage_MultiframeGrayscaleWordSecondaryCaptureImageStorage
    MultiframeTrueColorSecondaryCaptureImageStorage = _gdcmswig.MediaStorage_MultiframeTrueColorSecondaryCaptureImageStorage
    StandaloneOverlayStorage = _gdcmswig.MediaStorage_StandaloneOverlayStorage
    StandaloneCurveStorage = _gdcmswig.MediaStorage_StandaloneCurveStorage
    LeadECGWaveformStorage = _gdcmswig.MediaStorage_LeadECGWaveformStorage
    GeneralECGWaveformStorage = _gdcmswig.MediaStorage_GeneralECGWaveformStorage
    AmbulatoryECGWaveformStorage = _gdcmswig.MediaStorage_AmbulatoryECGWaveformStorage
    HemodynamicWaveformStorage = _gdcmswig.MediaStorage_HemodynamicWaveformStorage
    CardiacElectrophysiologyWaveformStorage = _gdcmswig.MediaStorage_CardiacElectrophysiologyWaveformStorage
    BasicVoiceAudioWaveformStorage = _gdcmswig.MediaStorage_BasicVoiceAudioWaveformStorage
    StandaloneModalityLUTStorage = _gdcmswig.MediaStorage_StandaloneModalityLUTStorage
    StandaloneVOILUTStorage = _gdcmswig.MediaStorage_StandaloneVOILUTStorage
    GrayscaleSoftcopyPresentationStateStorageSOPClass = _gdcmswig.MediaStorage_GrayscaleSoftcopyPresentationStateStorageSOPClass
    XRayAngiographicImageStorage = _gdcmswig.MediaStorage_XRayAngiographicImageStorage
    XRayRadiofluoroscopingImageStorage = _gdcmswig.MediaStorage_XRayRadiofluoroscopingImageStorage
    XRayAngiographicBiPlaneImageStorageRetired = _gdcmswig.MediaStorage_XRayAngiographicBiPlaneImageStorageRetired
    NuclearMedicineImageStorage = _gdcmswig.MediaStorage_NuclearMedicineImageStorage
    RawDataStorage = _gdcmswig.MediaStorage_RawDataStorage
    SpacialRegistrationStorage = _gdcmswig.MediaStorage_SpacialRegistrationStorage
    SpacialFiducialsStorage = _gdcmswig.MediaStorage_SpacialFiducialsStorage
    PETImageStorage = _gdcmswig.MediaStorage_PETImageStorage
    RTImageStorage = _gdcmswig.MediaStorage_RTImageStorage
    RTDoseStorage = _gdcmswig.MediaStorage_RTDoseStorage
    RTStructureSetStorage = _gdcmswig.MediaStorage_RTStructureSetStorage
    RTPlanStorage = _gdcmswig.MediaStorage_RTPlanStorage
    CSANonImageStorage = _gdcmswig.MediaStorage_CSANonImageStorage
    Philips3D = _gdcmswig.MediaStorage_Philips3D
    EnhancedSR = _gdcmswig.MediaStorage_EnhancedSR
    BasicTextSR = _gdcmswig.MediaStorage_BasicTextSR
    HardcopyGrayscaleImageStorage = _gdcmswig.MediaStorage_HardcopyGrayscaleImageStorage
    ComprehensiveSR = _gdcmswig.MediaStorage_ComprehensiveSR
    DetachedStudyManagementSOPClass = _gdcmswig.MediaStorage_DetachedStudyManagementSOPClass
    EncapsulatedPDFStorage = _gdcmswig.MediaStorage_EncapsulatedPDFStorage
    EncapsulatedCDAStorage = _gdcmswig.MediaStorage_EncapsulatedCDAStorage
    StudyComponentManagementSOPClass = _gdcmswig.MediaStorage_StudyComponentManagementSOPClass
    DetachedVisitManagementSOPClass = _gdcmswig.MediaStorage_DetachedVisitManagementSOPClass
    DetachedPatientManagementSOPClass = _gdcmswig.MediaStorage_DetachedPatientManagementSOPClass
    VideoEndoscopicImageStorage = _gdcmswig.MediaStorage_VideoEndoscopicImageStorage
    GeneralElectricMagneticResonanceImageStorage = _gdcmswig.MediaStorage_GeneralElectricMagneticResonanceImageStorage
    GEPrivate3DModelStorage = _gdcmswig.MediaStorage_GEPrivate3DModelStorage
    ToshibaPrivateDataStorage = _gdcmswig.MediaStorage_ToshibaPrivateDataStorage
    MammographyCADSR = _gdcmswig.MediaStorage_MammographyCADSR
    KeyObjectSelectionDocument = _gdcmswig.MediaStorage_KeyObjectSelectionDocument
    HangingProtocolStorage = _gdcmswig.MediaStorage_HangingProtocolStorage
    ModalityPerformedProcedureStepSOPClass = _gdcmswig.MediaStorage_ModalityPerformedProcedureStepSOPClass
    PhilipsPrivateMRSyntheticImageStorage = _gdcmswig.MediaStorage_PhilipsPrivateMRSyntheticImageStorage
    VLPhotographicImageStorage = _gdcmswig.MediaStorage_VLPhotographicImageStorage
    SegmentationStorage = _gdcmswig.MediaStorage_SegmentationStorage
    RTIonPlanStorage = _gdcmswig.MediaStorage_RTIonPlanStorage
    XRay3DAngiographicImageStorage = _gdcmswig.MediaStorage_XRay3DAngiographicImageStorage
    EnhancedXAImageStorage = _gdcmswig.MediaStorage_EnhancedXAImageStorage
    RTIonBeamsTreatmentRecordStorage = _gdcmswig.MediaStorage_RTIonBeamsTreatmentRecordStorage
    SurfaceSegmentationStorage = _gdcmswig.MediaStorage_SurfaceSegmentationStorage
    VLWholeSlideMicroscopyImageStorage = _gdcmswig.MediaStorage_VLWholeSlideMicroscopyImageStorage
    RTTreatmentSummaryRecordStorage = _gdcmswig.MediaStorage_RTTreatmentSummaryRecordStorage
    EnhancedUSVolumeStorage = _gdcmswig.MediaStorage_EnhancedUSVolumeStorage
    XRayRadiationDoseSR = _gdcmswig.MediaStorage_XRayRadiationDoseSR
    VLEndoscopicImageStorage = _gdcmswig.MediaStorage_VLEndoscopicImageStorage
    BreastTomosynthesisImageStorage = _gdcmswig.MediaStorage_BreastTomosynthesisImageStorage
    FujiPrivateCRImageStorage = _gdcmswig.MediaStorage_FujiPrivateCRImageStorage
    OphthalmicPhotography8BitImageStorage = _gdcmswig.MediaStorage_OphthalmicPhotography8BitImageStorage
    OphthalmicTomographyImageStorage = _gdcmswig.MediaStorage_OphthalmicTomographyImageStorage
    VLMicroscopicImageStorage = _gdcmswig.MediaStorage_VLMicroscopicImageStorage
    EnhancedPETImageStorage = _gdcmswig.MediaStorage_EnhancedPETImageStorage
    VideoPhotographicImageStorage = _gdcmswig.MediaStorage_VideoPhotographicImageStorage
    XRay3DCraniofacialImageStorage = _gdcmswig.MediaStorage_XRay3DCraniofacialImageStorage
    IVOCTForPresentation = _gdcmswig.MediaStorage_IVOCTForPresentation
    IVOCTForProcessing = _gdcmswig.MediaStorage_IVOCTForProcessing
    LegacyConvertedEnhancedCTImageStorage = _gdcmswig.MediaStorage_LegacyConvertedEnhancedCTImageStorage
    LegacyConvertedEnhancedMRImageStorage = _gdcmswig.MediaStorage_LegacyConvertedEnhancedMRImageStorage
    LegacyConvertedEnhancedPETImageStorage = _gdcmswig.MediaStorage_LegacyConvertedEnhancedPETImageStorage
    BreastProjectionXRayImageStorageForPresentation = _gdcmswig.MediaStorage_BreastProjectionXRayImageStorageForPresentation
    BreastProjectionXRayImageStorageForProcessing = _gdcmswig.MediaStorage_BreastProjectionXRayImageStorageForProcessing
    HardcopyColorImageStorage = _gdcmswig.MediaStorage_HardcopyColorImageStorage
    EnhancedMRColorImageStorage = _gdcmswig.MediaStorage_EnhancedMRColorImageStorage
    FujiPrivateMammoCRImageStorage = _gdcmswig.MediaStorage_FujiPrivateMammoCRImageStorage
    OphthalmicPhotography16BitImageStorage = _gdcmswig.MediaStorage_OphthalmicPhotography16BitImageStorage
    VideoMicroscopicImageStorage = _gdcmswig.MediaStorage_VideoMicroscopicImageStorage
    MS_END = _gdcmswig.MediaStorage_MS_END
    NoObject = _gdcmswig.MediaStorage_NoObject
    Video = _gdcmswig.MediaStorage_Video
    Waveform = _gdcmswig.MediaStorage_Waveform
    Audio = _gdcmswig.MediaStorage_Audio
    PDF = _gdcmswig.MediaStorage_PDF
    URI = _gdcmswig.MediaStorage_URI
    Segmentation = _gdcmswig.MediaStorage_Segmentation
    ObjectEnd = _gdcmswig.MediaStorage_ObjectEnd

    @staticmethod
    def GetMSString(ts):
        return _gdcmswig.MediaStorage_GetMSString(ts)

    def GetString(self):
        r"""
        const char*
        gdcm::MediaStorage::GetString() const

        Return the Media String of the object. 
        """
        return _gdcmswig.MediaStorage_GetString(self)

    @staticmethod
    def GetMSType(str):
        return _gdcmswig.MediaStorage_GetMSType(str)

    def __init__(self, *args):
        r"""gdcm::MediaStorage::MediaStorage(MSType type=MS_END)"""
        _gdcmswig.MediaStorage_swiginit(self, _gdcmswig.new_MediaStorage(*args))

    @staticmethod
    def IsImage(ts):
        return _gdcmswig.MediaStorage_IsImage(ts)

    def GetModality(self):
        r"""
        const char*
        gdcm::MediaStorage::GetModality() const 
        """
        return _gdcmswig.MediaStorage_GetModality(self)

    def GetModalityDimension(self):
        r"""unsigned int gdcm::MediaStorage::GetModalityDimension() const"""
        return _gdcmswig.MediaStorage_GetModalityDimension(self)

    @staticmethod
    def GetNumberOfMSType():
        return _gdcmswig.MediaStorage_GetNumberOfMSType()

    @staticmethod
    def GetNumberOfMSString():
        return _gdcmswig.MediaStorage_GetNumberOfMSString()

    @staticmethod
    def GetNumberOfModality():
        return _gdcmswig.MediaStorage_GetNumberOfModality()

    def SetFromFile(self, file):
        r"""
        bool
        gdcm::MediaStorage::SetFromFile(File const &file)

        Attempt to set the MediaStorage from a file: WARNING: When no
        MediaStorage & Modality are found BUT a PixelData element is found
        then MediaStorage is set to the default SecondaryCaptureImageStorage
        (return value is false in this case) 
        """
        return _gdcmswig.MediaStorage_SetFromFile(self, file)

    def SetFromDataSet(self, ds):
        r"""
        bool
        gdcm::MediaStorage::SetFromDataSet(DataSet const &ds)

        Advanced user only (functions should be protected level...) Those
        function are lower level than SetFromFile 
        """
        return _gdcmswig.MediaStorage_SetFromDataSet(self, ds)

    def SetFromHeader(self, fmi):
        r"""
        bool
        gdcm::MediaStorage::SetFromHeader(FileMetaInformation const &fmi) 
        """
        return _gdcmswig.MediaStorage_SetFromHeader(self, fmi)

    def SetFromModality(self, ds):
        r"""
        bool
        gdcm::MediaStorage::SetFromModality(DataSet const &ds) 
        """
        return _gdcmswig.MediaStorage_SetFromModality(self, ds)

    def GuessFromModality(self, modality, dimension=2):
        r"""
        void
        gdcm::MediaStorage::GuessFromModality(const char *modality, unsigned
        int dimension=2) 
        """
        return _gdcmswig.MediaStorage_GuessFromModality(self, modality, dimension)

    def IsUndefined(self):
        r"""
        bool
        gdcm::MediaStorage::IsUndefined() const 
        """
        return _gdcmswig.MediaStorage_IsUndefined(self)

    def __str__(self):
        return _gdcmswig.MediaStorage___str__(self)
    __swig_destroy__ = _gdcmswig.delete_MediaStorage

# Register MediaStorage in _gdcmswig:
_gdcmswig.MediaStorage_swigregister(MediaStorage)
class Tag(object):
    r"""


    Class to represent a DICOM Data Element ( Attribute) Tag (Group,
    Element).

    Basically an uint32_t which can also be expressed as two uint16_t
    (group and element) DATA ELEMENT TAG: A unique identifier for a Data
    Element composed of an ordered pair of numbers (a Group Number
    followed by an Element Number). GROUP NUMBER: The first number in the
    ordered pair of numbers that makes up a Data Element Tag. ELEMENT
    NUMBER: The second number in the ordered pair of numbers that makes up
    a Data Element Tag.

    C++ includes: gdcmTag.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def GetGroup(self):
        r"""
        uint16_t
        gdcm::Tag::GetGroup() const

        Returns the 'Group number' of the given Tag. 
        """
        return _gdcmswig.Tag_GetGroup(self)

    def GetElement(self):
        r"""
        uint16_t
        gdcm::Tag::GetElement() const

        Returns the ' Element number' of the given Tag. 
        """
        return _gdcmswig.Tag_GetElement(self)

    def SetGroup(self, group):
        r"""
        void
        gdcm::Tag::SetGroup(uint16_t group)

        Sets the 'Group number' of the given Tag. 
        """
        return _gdcmswig.Tag_SetGroup(self, group)

    def SetElement(self, element):
        r"""
        void
        gdcm::Tag::SetElement(uint16_t element)

        Sets the ' Element number' of the given Tag. 
        """
        return _gdcmswig.Tag_SetElement(self, element)

    def GetElementTag(self):
        r"""
        uint32_t
        gdcm::Tag::GetElementTag() const

        Returns the full tag value of the given Tag. 
        """
        return _gdcmswig.Tag_GetElementTag(self)

    def SetElementTag(self, *args):
        r"""
        void
        gdcm::Tag::SetElementTag(uint32_t tag)

        Sets the full tag value of the given Tag. 
        """
        return _gdcmswig.Tag_SetElementTag(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.Tag___getitem__(self, *args)

    def __eq__(self, _val):
        return _gdcmswig.Tag___eq__(self, _val)

    def __ne__(self, _val):
        return _gdcmswig.Tag___ne__(self, _val)

    def __lt__(self, _val):
        return _gdcmswig.Tag___lt__(self, _val)

    def __le__(self, t2):
        return _gdcmswig.Tag___le__(self, t2)

    def __init__(self, *args):
        r"""
        gdcm::Tag::Tag(uint32_t tag=0)

        Constructor with 1*uint32_t Prefer the cstor that takes two uint16_t.

        """
        _gdcmswig.Tag_swiginit(self, _gdcmswig.new_Tag(*args))

    def GetLength(self):
        r"""
        uint32_t
        gdcm::Tag::GetLength() const

        return the length of tag (read: size on disk) 
        """
        return _gdcmswig.Tag_GetLength(self)

    def IsPublic(self):
        r"""
        bool
        gdcm::Tag::IsPublic() const

        STANDARD DATA ELEMENT: A Data Element defined in the DICOM Standard,
        and therefore listed in the DICOM Data Element Dictionary in PS 3.6.
        Is the Tag from the Public dict...well the implementation is buggy it
        does not prove the element is indeed in the dict... 
        """
        return _gdcmswig.Tag_IsPublic(self)

    def IsPrivate(self):
        r"""
        bool
        gdcm::Tag::IsPrivate() const

        PRIVATE DATA ELEMENT: Additional Data Element, defined by an
        implementor, to communicate information that is not contained in
        Standard Data Elements. Private Data elements have odd Group Numbers.

        """
        return _gdcmswig.Tag_IsPrivate(self)

    def GetPrivateCreator(self):
        r"""
        Tag
        gdcm::Tag::GetPrivateCreator() const

        Return the Private Creator Data Element tag of a private data element.

        """
        return _gdcmswig.Tag_GetPrivateCreator(self)

    def SetPrivateCreator(self, t):
        r"""
        void
        gdcm::Tag::SetPrivateCreator(Tag const &t)

        Set private creator: 
        """
        return _gdcmswig.Tag_SetPrivateCreator(self, t)

    def IsPrivateCreator(self):
        r"""
        bool
        gdcm::Tag::IsPrivateCreator() const

        Returns if tag is a Private Creator (xxxx,00yy), where xxxx is odd
        number and yy in [0x10,0xFF] 
        """
        return _gdcmswig.Tag_IsPrivateCreator(self)

    def IsIllegal(self):
        r"""
        bool
        gdcm::Tag::IsIllegal() const

        return if the tag is considered to be an illegal tag 
        """
        return _gdcmswig.Tag_IsIllegal(self)

    def IsGroupLength(self):
        r"""
        bool
        gdcm::Tag::IsGroupLength() const

        return whether the tag correspond to a group length tag: 
        """
        return _gdcmswig.Tag_IsGroupLength(self)

    def IsGroupXX(self, t):
        r"""
        bool
        gdcm::Tag::IsGroupXX(const Tag &t) const

        e.g 6002,3000 belong to groupXX: 6000,3000 
        """
        return _gdcmswig.Tag_IsGroupXX(self, t)

    def ReadFromCommaSeparatedString(self, str):
        r"""
        bool
        gdcm::Tag::ReadFromCommaSeparatedString(const char *str)

        Read from a comma separated string. This is a highly user oriented
        function, the string should be formatted as: 1234,5678 to specify the
        tag (0x1234,0x5678) The notation comes from the DICOM standard, and is
        handy to use from a command line program 
        """
        return _gdcmswig.Tag_ReadFromCommaSeparatedString(self, str)

    def ReadFromContinuousString(self, str):
        r"""
        bool
        gdcm::Tag::ReadFromContinuousString(const char *str)

        Read From XML formatted tag value eg. tag = "12345678" It comes in
        useful when reading tag values from XML file(in NativeDICOMModel) 
        """
        return _gdcmswig.Tag_ReadFromContinuousString(self, str)

    def PrintAsContinuousString(self):
        r"""
        std::string gdcm::Tag::PrintAsContinuousString() const

        Print tag value with no separating comma: eg. tag = "12345678" It
        comes in useful when reading tag values from XML file(in
        NativeDICOMModel) 
        """
        return _gdcmswig.Tag_PrintAsContinuousString(self)

    def PrintAsContinuousUpperCaseString(self):
        r"""
        std::string gdcm::Tag::PrintAsContinuousUpperCaseString() const

        Same as PrintAsContinuousString, but hexadecimal [a-f] are printed
        using upper case. 
        """
        return _gdcmswig.Tag_PrintAsContinuousUpperCaseString(self)

    def ReadFromPipeSeparatedString(self, str):
        r"""
        bool
        gdcm::Tag::ReadFromPipeSeparatedString(const char *str)

        Read from a pipe separated string (GDCM 1.x compat only). Do not use
        in newer code See:   ReadFromCommaSeparatedString 
        """
        return _gdcmswig.Tag_ReadFromPipeSeparatedString(self, str)

    def PrintAsPipeSeparatedString(self):
        r"""
        std::string gdcm::Tag::PrintAsPipeSeparatedString() const

        Print as a pipe separated string (GDCM 1.x compat only). Do not use in
        newer code See:   ReadFromPipeSeparatedString 
        """
        return _gdcmswig.Tag_PrintAsPipeSeparatedString(self)

    def __str__(self):
        return _gdcmswig.Tag___str__(self)
    __swig_destroy__ = _gdcmswig.delete_Tag

# Register Tag in _gdcmswig:
_gdcmswig.Tag_swigregister(Tag)

def __rshift__(_is, _val):
    return _gdcmswig.__rshift__(_is, _val)

class PrivateTag(Tag):
    r"""


    Class to represent a Private DICOM Data Element ( Attribute) Tag
    (Group, Element, Owner)

    private tag have element value in: [0x10,0xff], for instance
    0x0009,0x0000 is NOT a private tag

    C++ includes: gdcmPrivateTag.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::PrivateTag::PrivateTag(uint16_t group=0, uint16_t element=0,
        const char *owner="") 
        """
        _gdcmswig.PrivateTag_swiginit(self, _gdcmswig.new_PrivateTag(*args))

    def GetOwner(self):
        r"""
        const char*
        gdcm::PrivateTag::GetOwner() const 
        """
        return _gdcmswig.PrivateTag_GetOwner(self)

    def SetOwner(self, owner):
        r"""
        void
        gdcm::PrivateTag::SetOwner(const char *owner) 
        """
        return _gdcmswig.PrivateTag_SetOwner(self, owner)

    def __eq__(self, *args):
        return _gdcmswig.PrivateTag___eq__(self, *args)

    def __ne__(self, *args):
        return _gdcmswig.PrivateTag___ne__(self, *args)

    def __lt__(self, _val):
        return _gdcmswig.PrivateTag___lt__(self, _val)

    def ReadFromCommaSeparatedString(self, str):
        r"""
        bool gdcm::PrivateTag::ReadFromCommaSeparatedString(const char *str)

        Read PrivateTag from a string. Element number will be truncated to
        8bits. Eg: "1234,5678,GDCM" is private tag: (1234,78,"GDCM") 
        """
        return _gdcmswig.PrivateTag_ReadFromCommaSeparatedString(self, str)

    def GetAsDataElement(self):
        r"""DataElement gdcm::PrivateTag::GetAsDataElement() const"""
        return _gdcmswig.PrivateTag_GetAsDataElement(self)

    def __str__(self):
        return _gdcmswig.PrivateTag___str__(self)
    __swig_destroy__ = _gdcmswig.delete_PrivateTag

# Register PrivateTag in _gdcmswig:
_gdcmswig.PrivateTag_swigregister(PrivateTag)
class ProgressEvent(AnyEvent):
    r"""


    ProgressEvent.

    Special type of event triggered during

    See:   AnyEvent

    C++ includes: gdcmProgressEvent.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_ProgressEvent

    def GetEventName(self):
        r"""
        const char*
        gdcm::ProgressEvent::GetEventName() const override

        Return the StringName associated with the event. 
        """
        return _gdcmswig.ProgressEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        bool
        gdcm::ProgressEvent::CheckEvent(const ::gdcm::Event *e) const override

        """
        return _gdcmswig.ProgressEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        ::gdcm::Event* gdcm::ProgressEvent::MakeObject() const override

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.ProgressEvent_MakeObject(self)

    def SetProgress(self, p):
        r"""
        void
        gdcm::ProgressEvent::SetProgress(double p) 
        """
        return _gdcmswig.ProgressEvent_SetProgress(self, p)

    def GetProgress(self):
        r"""
        double
        gdcm::ProgressEvent::GetProgress() const 
        """
        return _gdcmswig.ProgressEvent_GetProgress(self)

    @staticmethod
    def Cast(event):
        return _gdcmswig.ProgressEvent_Cast(event)

# Register ProgressEvent in _gdcmswig:
_gdcmswig.ProgressEvent_swigregister(ProgressEvent)
class AnonymizeEvent(AnyEvent):
    r"""


    AnonymizeEvent.

    Special type of event triggered during the Anonymization process

    See:   Anonymizer

    C++ includes: gdcmAnonymizeEvent.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_AnonymizeEvent

    def GetEventName(self):
        r"""
        const
        char* gdcm::AnonymizeEvent::GetEventName() const override

        Return the StringName associated with the event. 
        """
        return _gdcmswig.AnonymizeEvent_GetEventName(self)

    def CheckEvent(self, e):
        r"""
        bool
        gdcm::AnonymizeEvent::CheckEvent(const ::gdcm::Event *e) const
        override 
        """
        return _gdcmswig.AnonymizeEvent_CheckEvent(self, e)

    def MakeObject(self):
        r"""
        ::gdcm::Event* gdcm::AnonymizeEvent::MakeObject() const override

        Create an Event of this type This method work as a Factory for
        creating events of each particular type. 
        """
        return _gdcmswig.AnonymizeEvent_MakeObject(self)

    def SetTag(self, t):
        r"""
        void
        gdcm::AnonymizeEvent::SetTag(const Tag &t) 
        """
        return _gdcmswig.AnonymizeEvent_SetTag(self, t)

    def GetTag(self):
        r"""
        Tag const&
        gdcm::AnonymizeEvent::GetTag() const 
        """
        return _gdcmswig.AnonymizeEvent_GetTag(self)

    @staticmethod
    def Cast(event):
        return _gdcmswig.AnonymizeEvent_Cast(event)

# Register AnonymizeEvent in _gdcmswig:
_gdcmswig.AnonymizeEvent_swigregister(AnonymizeEvent)
class VL(object):
    r"""


    Value Length.

    WARNING:  this is a 4bytes value ! Do not try to use it for 2bytes
    value length

    C++ includes: gdcmVL.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, vl=0):
        r"""gdcm::VL::VL(uint32_t vl=0)"""
        _gdcmswig.VL_swiginit(self, _gdcmswig.new_VL(vl))

    @staticmethod
    def GetVL32Max():
        return _gdcmswig.VL_GetVL32Max()

    @staticmethod
    def GetVL16Max():
        return _gdcmswig.VL_GetVL16Max()

    def IsUndefined(self):
        r"""
        bool
        gdcm::VL::IsUndefined() const 
        """
        return _gdcmswig.VL_IsUndefined(self)

    def SetToUndefined(self):
        r"""
        void
        gdcm::VL::SetToUndefined() 
        """
        return _gdcmswig.VL_SetToUndefined(self)

    def IsOdd(self):
        r"""
        bool gdcm::VL::IsOdd() const

        Return whether or not the VL is odd or not. 
        """
        return _gdcmswig.VL_IsOdd(self)

    def __add__(self, vl):
        return _gdcmswig.VL___add__(self, vl)

    def GetLength(self):
        r"""
        VL gdcm::VL::GetLength()
        const 
        """
        return _gdcmswig.VL_GetLength(self)

    def __str__(self):
        return _gdcmswig.VL___str__(self)
    __swig_destroy__ = _gdcmswig.delete_VL

# Register VL in _gdcmswig:
_gdcmswig.VL_swigregister(VL)
class VR(object):
    r"""


    VR class.

    This is adapted from DICOM standard The biggest difference is the
    INVALID VR and the composite one that differ from standard (more like
    an addition) This allow us to represent all the possible case express
    in the DICOMV3 dict VALUE REPRESENTATION ( VR) Specifies the data type
    and format of the Value(s) contained in the Value Field of a Data
    Element. VALUE REPRESENTATION FIELD: The field where the Value
    Representation of a Data Element is stored in the encoding of a Data
    Element structure with explicit VR.

    C++ includes: gdcmVR.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    INVALID = _gdcmswig.VR_INVALID
    AE = _gdcmswig.VR_AE
    AS = _gdcmswig.VR_AS
    AT = _gdcmswig.VR_AT
    CS = _gdcmswig.VR_CS
    DA = _gdcmswig.VR_DA
    DS = _gdcmswig.VR_DS
    DT = _gdcmswig.VR_DT
    FD = _gdcmswig.VR_FD
    FL = _gdcmswig.VR_FL
    IS = _gdcmswig.VR_IS
    LO = _gdcmswig.VR_LO
    LT = _gdcmswig.VR_LT
    OB = _gdcmswig.VR_OB
    OD = _gdcmswig.VR_OD
    OF = _gdcmswig.VR_OF
    OL = _gdcmswig.VR_OL
    OV = _gdcmswig.VR_OV
    OW = _gdcmswig.VR_OW
    PN = _gdcmswig.VR_PN
    SH = _gdcmswig.VR_SH
    SL = _gdcmswig.VR_SL
    SQ = _gdcmswig.VR_SQ
    SS = _gdcmswig.VR_SS
    ST = _gdcmswig.VR_ST
    SV = _gdcmswig.VR_SV
    TM = _gdcmswig.VR_TM
    UC = _gdcmswig.VR_UC
    UI = _gdcmswig.VR_UI
    UL = _gdcmswig.VR_UL
    UN = _gdcmswig.VR_UN
    UR = _gdcmswig.VR_UR
    US = _gdcmswig.VR_US
    UT = _gdcmswig.VR_UT
    UV = _gdcmswig.VR_UV
    OB_OW = _gdcmswig.VR_OB_OW
    US_SS = _gdcmswig.VR_US_SS
    US_SS_OW = _gdcmswig.VR_US_SS_OW
    US_OW = _gdcmswig.VR_US_OW
    VL16 = _gdcmswig.VR_VL16
    VL32 = _gdcmswig.VR_VL32
    VRASCII = _gdcmswig.VR_VRASCII
    VRBINARY = _gdcmswig.VR_VRBINARY
    VR_VM1 = _gdcmswig.VR_VR_VM1
    VRALL = _gdcmswig.VR_VRALL
    VR_END = _gdcmswig.VR_VR_END

    @staticmethod
    def GetVRString(vr):
        return _gdcmswig.VR_GetVRString(vr)

    @staticmethod
    def GetVRTypeFromFile(vr):
        return _gdcmswig.VR_GetVRTypeFromFile(vr)

    @staticmethod
    def GetVRType(vr):
        return _gdcmswig.VR_GetVRType(vr)

    @staticmethod
    def GetVRStringFromFile(vr):
        return _gdcmswig.VR_GetVRStringFromFile(vr)

    @staticmethod
    def IsValid(*args):
        return _gdcmswig.VR_IsValid(*args)

    @staticmethod
    def IsSwap(vr):
        return _gdcmswig.VR_IsSwap(vr)

    def GetSizeof(self):
        r"""
        unsigned int
        gdcm::VR::GetSizeof() const 
        """
        return _gdcmswig.VR_GetSizeof(self)

    @staticmethod
    def GetLength(*args):
        r"""
        int gdcm::VR::GetLength()
        const 
        """
        return _gdcmswig.VR_GetLength(*args)

    @staticmethod
    def IsBinary(vr):
        return _gdcmswig.VR_IsBinary(vr)

    @staticmethod
    def IsASCII(vr):
        return _gdcmswig.VR_IsASCII(vr)

    @staticmethod
    def CanDisplay(vr):
        return _gdcmswig.VR_CanDisplay(vr)

    @staticmethod
    def IsBinary2(vr):
        return _gdcmswig.VR_IsBinary2(vr)

    @staticmethod
    def IsASCII2(vr):
        return _gdcmswig.VR_IsASCII2(vr)

    def __init__(self, *args):
        r"""
        gdcm::VR::VR(VRType vr=INVALID)

        """
        _gdcmswig.VR_swiginit(self, _gdcmswig.new_VR(*args))

    def Read(self, _is):
        r"""
        std::istream&
        gdcm::VR::Read(std::istream &is) 
        """
        return _gdcmswig.VR_Read(self, _is)

    def Write(self, os):
        r"""
        const std::ostream&
        gdcm::VR::Write(std::ostream &os) const 
        """
        return _gdcmswig.VR_Write(self, os)

    def GetSize(self):
        r"""
        unsigned int
        gdcm::VR::GetSize() const 
        """
        return _gdcmswig.VR_GetSize(self)

    def Compatible(self, vr):
        r"""
        bool
        gdcm::VR::Compatible(VR const &vr) const 
        """
        return _gdcmswig.VR_Compatible(self, vr)

    def IsVRFile(self):
        r"""
        bool gdcm::VR::IsVRFile()
        const 
        """
        return _gdcmswig.VR_IsVRFile(self)

    def IsDual(self):
        r"""
        bool gdcm::VR::IsDual()
        const 
        """
        return _gdcmswig.VR_IsDual(self)

    def __str__(self):
        return _gdcmswig.VR___str__(self)
    __swig_destroy__ = _gdcmswig.delete_VR

# Register VR in _gdcmswig:
_gdcmswig.VR_swigregister(VR)
class VM(object):
    r"""


    Value Multiplicity Looking at the DICOMV3 dict only there is very few
    cases: 1 2 3 4 5 6 8 16 24 1-2 1-3 1-8 1-32 1-99 1-n 2-2n 2-n 3-3n
    3-n.

    Some private dict define some more: 4-4n 1-4 1-5 256 9 3-4

    even more:

    7-7n 10 18 12 35 47_47n 30_30n 28

    6-6n

    C++ includes: gdcmVM.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    VM0 = _gdcmswig.VM_VM0
    VM1 = _gdcmswig.VM_VM1
    VM2 = _gdcmswig.VM_VM2
    VM3 = _gdcmswig.VM_VM3
    VM4 = _gdcmswig.VM_VM4
    VM5 = _gdcmswig.VM_VM5
    VM6 = _gdcmswig.VM_VM6
    VM8 = _gdcmswig.VM_VM8
    VM9 = _gdcmswig.VM_VM9
    VM10 = _gdcmswig.VM_VM10
    VM12 = _gdcmswig.VM_VM12
    VM16 = _gdcmswig.VM_VM16
    VM18 = _gdcmswig.VM_VM18
    VM24 = _gdcmswig.VM_VM24
    VM28 = _gdcmswig.VM_VM28
    VM32 = _gdcmswig.VM_VM32
    VM35 = _gdcmswig.VM_VM35
    VM99 = _gdcmswig.VM_VM99
    VM256 = _gdcmswig.VM_VM256
    VM1_2 = _gdcmswig.VM_VM1_2
    VM1_3 = _gdcmswig.VM_VM1_3
    VM1_4 = _gdcmswig.VM_VM1_4
    VM1_5 = _gdcmswig.VM_VM1_5
    VM1_8 = _gdcmswig.VM_VM1_8
    VM1_32 = _gdcmswig.VM_VM1_32
    VM1_99 = _gdcmswig.VM_VM1_99
    VM1_n = _gdcmswig.VM_VM1_n
    VM2_2n = _gdcmswig.VM_VM2_2n
    VM2_n = _gdcmswig.VM_VM2_n
    VM3_4 = _gdcmswig.VM_VM3_4
    VM3_3n = _gdcmswig.VM_VM3_3n
    VM3_n = _gdcmswig.VM_VM3_n
    VM4_4n = _gdcmswig.VM_VM4_4n
    VM6_6n = _gdcmswig.VM_VM6_6n
    VM6_n = _gdcmswig.VM_VM6_n
    VM7_7n = _gdcmswig.VM_VM7_7n
    VM30_30n = _gdcmswig.VM_VM30_30n
    VM47_47n = _gdcmswig.VM_VM47_47n
    VM_END = _gdcmswig.VM_VM_END

    @staticmethod
    def GetVMString(vm):
        return _gdcmswig.VM_GetVMString(vm)

    @staticmethod
    def GetVMType(vm):
        return _gdcmswig.VM_GetVMType(vm)

    @staticmethod
    def IsValid(vm1, vm2):
        return _gdcmswig.VM_IsValid(vm1, vm2)

    def Compatible(self, vm):
        r"""
        bool
        gdcm::VM::Compatible(VM const &vm) const

        WARNING: Implementation deficiency The Compatible function is poorly
        implemented, the reference vm should be coming from the dictionary,
        while the passed in value is the value guess from the file. 
        """
        return _gdcmswig.VM_Compatible(self, vm)

    @staticmethod
    def GetVMTypeFromLength(length, size):
        return _gdcmswig.VM_GetVMTypeFromLength(length, size)

    @staticmethod
    def GetNumberOfElementsFromArray(array, length):
        return _gdcmswig.VM_GetNumberOfElementsFromArray(array, length)

    def __init__(self, *args):
        r"""gdcm::VM::VM(VMType type=VM0)"""
        _gdcmswig.VM_swiginit(self, _gdcmswig.new_VM(*args))

    def GetLength(self):
        r"""
        unsigned int
        gdcm::VM::GetLength() const 
        """
        return _gdcmswig.VM_GetLength(self)

    def __str__(self):
        return _gdcmswig.VM___str__(self)
    __swig_destroy__ = _gdcmswig.delete_VM

# Register VM in _gdcmswig:
_gdcmswig.VM_swigregister(VM)
class FilenamesType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.FilenamesType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.FilenamesType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.FilenamesType___bool__(self)

    def __len__(self):
        return _gdcmswig.FilenamesType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.FilenamesType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.FilenamesType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.FilenamesType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.FilenamesType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.FilenamesType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.FilenamesType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.FilenamesType_pop(self)

    def append(self, x):
        return _gdcmswig.FilenamesType_append(self, x)

    def empty(self):
        return _gdcmswig.FilenamesType_empty(self)

    def size(self):
        return _gdcmswig.FilenamesType_size(self)

    def swap(self, v):
        return _gdcmswig.FilenamesType_swap(self, v)

    def begin(self):
        return _gdcmswig.FilenamesType_begin(self)

    def end(self):
        return _gdcmswig.FilenamesType_end(self)

    def rbegin(self):
        return _gdcmswig.FilenamesType_rbegin(self)

    def rend(self):
        return _gdcmswig.FilenamesType_rend(self)

    def clear(self):
        return _gdcmswig.FilenamesType_clear(self)

    def get_allocator(self):
        return _gdcmswig.FilenamesType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.FilenamesType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.FilenamesType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.FilenamesType_swiginit(self, _gdcmswig.new_FilenamesType(*args))

    def push_back(self, x):
        return _gdcmswig.FilenamesType_push_back(self, x)

    def front(self):
        return _gdcmswig.FilenamesType_front(self)

    def back(self):
        return _gdcmswig.FilenamesType_back(self)

    def assign(self, n, x):
        return _gdcmswig.FilenamesType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.FilenamesType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.FilenamesType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.FilenamesType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.FilenamesType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_FilenamesType

# Register FilenamesType in _gdcmswig:
_gdcmswig.FilenamesType_swigregister(FilenamesType)
class Directory(object):
    r"""


    Class for manipulation directories.

    This implementation provide a cross platform implementation for
    manipulating directories: basically traversing directories and
    harvesting files

    will not take into account unix type hidden file recursive option will
    not look into UNIX type hidden directory (those starting with a '.')

    Since python or C# provide there own equivalent implementation, in
    which case gdcm::Directory does not make much sense.

    C++ includes: gdcmDirectory.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Directory::Directory()=default"""
        _gdcmswig.Directory_swiginit(self, _gdcmswig.new_Directory())
    __swig_destroy__ = _gdcmswig.delete_Directory

    def Print(self, *args):
        r"""
        void
        gdcm::Directory::Print(std::ostream &os=std::cout) const

        Print. 
        """
        return _gdcmswig.Directory_Print(self, *args)

    def GetToplevel(self):
        r"""
        FilenameType
        const& gdcm::Directory::GetToplevel() const

        Get the name of the toplevel directory. 
        """
        return _gdcmswig.Directory_GetToplevel(self)

    def GetFilenames(self):
        r"""
        FilenamesType
        const& gdcm::Directory::GetFilenames() const

        Set/Get the file names within the directory. 
        """
        return _gdcmswig.Directory_GetFilenames(self)

    def GetDirectories(self):
        r"""
        FilenamesType
        const& gdcm::Directory::GetDirectories() const

        Return the Directories traversed. 
        """
        return _gdcmswig.Directory_GetDirectories(self)

    def Load(self, name, recursive=False):
        r"""
        unsigned int
        gdcm::Directory::Load(FilenameType const &name, bool recursive=false)

        construct a list of filenames and subdirectory beneath directory: name
        WARNING:  : hidden file and hidden directory are not loaded. 
        """
        return _gdcmswig.Directory_Load(self, name, recursive)

    def __str__(self):
        return _gdcmswig.Directory___str__(self)

# Register Directory in _gdcmswig:
_gdcmswig.Directory_swigregister(Directory)
class Object(object):
    r"""


    Object.

    main superclass for object that want to use SmartPointer invasive ref
    counting system

    See:   SmartPointer

    C++ includes: gdcmObject.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_Object

    def __init__(self, *args):
        r"""
        gdcm::Object::Object(const Object &)

        Special requirement for copy/cstor, assignment operator. 
        """
        _gdcmswig.Object_swiginit(self, _gdcmswig.new_Object(*args))

    def Print(self, arg2):
        r"""
        virtual void
        gdcm::Object::Print(std::ostream &) const 
        """
        return _gdcmswig.Object_Print(self, arg2)

# Register Object in _gdcmswig:
_gdcmswig.Object_swigregister(Object)
class Value(Object):
    r"""


    Class to represent the value of a Data Element.

    VALUE: A component of a Value Field. A Value Field may consist of one
    or more of these components.

    C++ includes: gdcmValue.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_Value

    def GetLength(self):
        r"""
        virtual VL
        gdcm::Value::GetLength() const =0 
        """
        return _gdcmswig.Value_GetLength(self)

    def SetLength(self, l):
        r"""
        virtual void
        gdcm::Value::SetLength(VL l)=0 
        """
        return _gdcmswig.Value_SetLength(self, l)

    def Clear(self):
        r"""
        virtual void
        gdcm::Value::Clear()=0 
        """
        return _gdcmswig.Value_Clear(self)

    def __eq__(self, val):
        return _gdcmswig.Value___eq__(self, val)

    def __str__(self):
        return _gdcmswig.Value___str__(self)

# Register Value in _gdcmswig:
_gdcmswig.Value_swigregister(Value)
class ByteValue(Value):
    r"""


    Class to represent binary value (array of bytes)

    C++ includes: gdcmByteValue.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::ByteValue::ByteValue(std::vector< char > &v)

        WARNING:  casting to uint32_t 
        """
        _gdcmswig.ByteValue_swiginit(self, _gdcmswig.new_ByteValue(*args))
    __swig_destroy__ = _gdcmswig.delete_ByteValue

    def PrintASCII(self, os, maxlength):
        r"""
        void
        gdcm::ByteValue::PrintASCII(std::ostream &os, VL maxlength) const 
        """
        return _gdcmswig.ByteValue_PrintASCII(self, os, maxlength)

    def PrintHex(self, os, maxlength):
        r"""
        void
        gdcm::ByteValue::PrintHex(std::ostream &os, VL maxlength) const 
        """
        return _gdcmswig.ByteValue_PrintHex(self, os, maxlength)

    def PrintGroupLength(self, os):
        r"""
        void
        gdcm::ByteValue::PrintGroupLength(std::ostream &os) 
        """
        return _gdcmswig.ByteValue_PrintGroupLength(self, os)

    def IsEmpty(self):
        r"""
        bool
        gdcm::ByteValue::IsEmpty() const 
        """
        return _gdcmswig.ByteValue_IsEmpty(self)

    def GetLength(self):
        r"""
        VL
        gdcm::ByteValue::GetLength() const override 
        """
        return _gdcmswig.ByteValue_GetLength(self)

    def ComputeLength(self):
        r"""
        VL
        gdcm::ByteValue::ComputeLength() const 
        """
        return _gdcmswig.ByteValue_ComputeLength(self)

    def SetLength(self, vl):
        r"""
        void
        gdcm::ByteValue::SetLength(VL vl) override 
        """
        return _gdcmswig.ByteValue_SetLength(self, vl)

    def __eq__(self, *args):
        return _gdcmswig.ByteValue___eq__(self, *args)

    def Append(self, bv):
        r"""
        void
        gdcm::ByteValue::Append(ByteValue const &bv) 
        """
        return _gdcmswig.ByteValue_Append(self, bv)

    def Clear(self):
        r"""
        void
        gdcm::ByteValue::Clear() override 
        """
        return _gdcmswig.ByteValue_Clear(self)

    def GetVoidPointer(self, *args):
        r"""
        const void*
        gdcm::ByteValue::GetVoidPointer() const 
        """
        return _gdcmswig.ByteValue_GetVoidPointer(self, *args)

    def Fill(self, c):
        r"""
        void
        gdcm::ByteValue::Fill(char c) 
        """
        return _gdcmswig.ByteValue_Fill(self, c)

    def IsPrintable(self, length):
        r"""
        bool
        gdcm::ByteValue::IsPrintable(VL length) const

        Checks whether a ' ByteValue' is printable or not (in order to avoid
        corrupting the terminal of invocation when printing) I don't think
        this function is working since it does not handle UNICODE or character
        set... 
        """
        return _gdcmswig.ByteValue_IsPrintable(self, length)

    def PrintPNXML(self, os):
        r"""
        void
        gdcm::ByteValue::PrintPNXML(std::ostream &os) const

        To Print Values in Native DICOM format 
        """
        return _gdcmswig.ByteValue_PrintPNXML(self, os)

    def PrintASCIIXML(self, os):
        r"""
        void
        gdcm::ByteValue::PrintASCIIXML(std::ostream &os) const 
        """
        return _gdcmswig.ByteValue_PrintASCIIXML(self, os)

    def PrintHexXML(self, os):
        r"""
        void
        gdcm::ByteValue::PrintHexXML(std::ostream &os) const 
        """
        return _gdcmswig.ByteValue_PrintHexXML(self, os)

    def __str__(self):
        return _gdcmswig.ByteValue___str__(self)

    def WriteBuffer(self):
        r"""
        bool
        gdcm::ByteValue::WriteBuffer(std::ostream &os) const 
        """
        return _gdcmswig.ByteValue_WriteBuffer(self)

    def GetBuffer(self, *args):
        r"""
        bool
        gdcm::ByteValue::GetBuffer(char *buffer, unsigned long length) const

        """
        return _gdcmswig.ByteValue_GetBuffer(self, *args)

# Register ByteValue in _gdcmswig:
_gdcmswig.ByteValue_swigregister(ByteValue)
class ASN1(object):
    r"""


    Class for ASN1.

    C++ includes: gdcmASN1.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::ASN1::ASN1(const ASN1
        &)=delete 
        """
        _gdcmswig.ASN1_swiginit(self, _gdcmswig.new_ASN1())
    __swig_destroy__ = _gdcmswig.delete_ASN1

    @staticmethod
    def ParseDumpFile(filename):
        return _gdcmswig.ASN1_ParseDumpFile(filename)

    @staticmethod
    def ParseDump(array, length):
        return _gdcmswig.ASN1_ParseDump(array, length)

# Register ASN1 in _gdcmswig:
_gdcmswig.ASN1_swigregister(ASN1)
class SmartPtrSQ(object):
    r"""


    Class for Smart Pointer.

    Will only work for subclass of gdcm::Object See tr1/shared_ptr for a
    more general approach (not invasive) #include <tr1/memory> {
    shared_ptr<Bla> b(new Bla); } Class partly based on post by Bill
    Hubauer:http://groups.google.com/group/comp.lang.c++/msg/173ddc38a827a930

    See:  http://www.davethehat.com/articles/smartp.htm  and
    itk::SmartPointer

    C++ includes: gdcmSmartPointer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::SmartPointer< ObjectType >::SmartPointer(ObjectType const &p)"""
        _gdcmswig.SmartPtrSQ_swiginit(self, _gdcmswig.new_SmartPtrSQ(*args))
    __swig_destroy__ = _gdcmswig.delete_SmartPtrSQ

    def __deref__(self):
        return _gdcmswig.SmartPtrSQ___deref__(self)

    def __ref__(self):
        return _gdcmswig.SmartPtrSQ___ref__(self)

    def GetPointer(self):
        r"""
        ObjectType*
        gdcm::SmartPointer< ObjectType >::GetPointer() const

        Explicit function to retrieve the pointer. 
        """
        return _gdcmswig.SmartPtrSQ_GetPointer(self)

    def Begin(self, *args):
        r"""
        ConstIterator
        gdcm::SequenceOfItems::Begin() const 
        """
        return _gdcmswig.SmartPtrSQ_Begin(self, *args)

    def End(self, *args):
        r"""
        ConstIterator
        gdcm::SequenceOfItems::End() const 
        """
        return _gdcmswig.SmartPtrSQ_End(self, *args)

    def GetLength(self):
        r"""
        VL
        gdcm::SequenceOfItems::GetLength() const override

        Returns the SQ length, as read from disk. 
        """
        return _gdcmswig.SmartPtrSQ_GetLength(self)

    def SetLength(self, length):
        r"""
        void
        gdcm::SequenceOfItems::SetLength(VL length) override

        Sets the actual SQ length. 
        """
        return _gdcmswig.SmartPtrSQ_SetLength(self, length)

    def SetLengthToUndefined(self):
        r"""
        void gdcm::SequenceOfItems::SetLengthToUndefined()

        Properly set the Sequence of Item to be undefined length. 
        """
        return _gdcmswig.SmartPtrSQ_SetLengthToUndefined(self)

    def IsUndefinedLength(self):
        r"""
        bool
        gdcm::SequenceOfItems::IsUndefinedLength() const

        return if Value Length if of undefined length 
        """
        return _gdcmswig.SmartPtrSQ_IsUndefinedLength(self)

    def Clear(self):
        r"""
        void
        gdcm::SequenceOfItems::Clear() override

        remove all items within the sequence 
        """
        return _gdcmswig.SmartPtrSQ_Clear(self)

    def AddItem(self, item):
        r"""
        void
        gdcm::SequenceOfItems::AddItem(Item const &item)

        Appends an Item to the already added ones. 
        """
        return _gdcmswig.SmartPtrSQ_AddItem(self, item)

    def AddNewUndefinedLengthItem(self):
        r"""
        Item&
        gdcm::SequenceOfItems::AddNewUndefinedLengthItem()

        Appends an Item to the already added ones. 
        """
        return _gdcmswig.SmartPtrSQ_AddNewUndefinedLengthItem(self)

    def RemoveItemByIndex(self, index):
        r"""
        bool
        gdcm::SequenceOfItems::RemoveItemByIndex(const SizeType index)

        Remove an Item as specified by its index, if index > size, false is
        returned Index starts at 1 not 0 
        """
        return _gdcmswig.SmartPtrSQ_RemoveItemByIndex(self, index)

    def IsEmpty(self):
        r"""
        bool
        gdcm::SequenceOfItems::IsEmpty() const 
        """
        return _gdcmswig.SmartPtrSQ_IsEmpty(self)

    def GetNumberOfItems(self):
        r"""SizeType gdcm::SequenceOfItems::GetNumberOfItems() const"""
        return _gdcmswig.SmartPtrSQ_GetNumberOfItems(self)

    def SetNumberOfItems(self, n):
        r"""
        void
        gdcm::SequenceOfItems::SetNumberOfItems(SizeType n) 
        """
        return _gdcmswig.SmartPtrSQ_SetNumberOfItems(self, n)

    def GetItem(self, *args):
        r"""
        const Item&
        gdcm::SequenceOfItems::GetItem(SizeType position) const 
        """
        return _gdcmswig.SmartPtrSQ_GetItem(self, *args)

    def Print(self, os):
        r"""
        void
        gdcm::SequenceOfItems::Print(std::ostream &os) const override 
        """
        return _gdcmswig.SmartPtrSQ_Print(self, os)

    def New(self):
        return _gdcmswig.SmartPtrSQ_New(self)

    def FindDataElement(self, t):
        r"""
        bool
        gdcm::SequenceOfItems::FindDataElement(const Tag &t) const 
        """
        return _gdcmswig.SmartPtrSQ_FindDataElement(self, t)

    def __eq__(self, val):
        return _gdcmswig.SmartPtrSQ___eq__(self, val)
    SequenceLengthField = property(_gdcmswig.SmartPtrSQ_SequenceLengthField_get, _gdcmswig.SmartPtrSQ_SequenceLengthField_set)
    Items = property(_gdcmswig.SmartPtrSQ_Items_get, _gdcmswig.SmartPtrSQ_Items_set)

    def __str__(self):
        return _gdcmswig.SmartPtrSQ___str__(self)

# Register SmartPtrSQ in _gdcmswig:
_gdcmswig.SmartPtrSQ_swigregister(SmartPtrSQ)
class SmartPtrFrag(object):
    r"""


    Class for Smart Pointer.

    Will only work for subclass of gdcm::Object See tr1/shared_ptr for a
    more general approach (not invasive) #include <tr1/memory> {
    shared_ptr<Bla> b(new Bla); } Class partly based on post by Bill
    Hubauer:http://groups.google.com/group/comp.lang.c++/msg/173ddc38a827a930

    See:  http://www.davethehat.com/articles/smartp.htm  and
    itk::SmartPointer

    C++ includes: gdcmSmartPointer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::SmartPointer< ObjectType >::SmartPointer(ObjectType const &p)"""
        _gdcmswig.SmartPtrFrag_swiginit(self, _gdcmswig.new_SmartPtrFrag(*args))
    __swig_destroy__ = _gdcmswig.delete_SmartPtrFrag

    def __deref__(self):
        return _gdcmswig.SmartPtrFrag___deref__(self)

    def __ref__(self):
        return _gdcmswig.SmartPtrFrag___ref__(self)

    def GetPointer(self):
        r"""
        ObjectType*
        gdcm::SmartPointer< ObjectType >::GetPointer() const

        Explicit function to retrieve the pointer. 
        """
        return _gdcmswig.SmartPtrFrag_GetPointer(self)

    def Begin(self, *args):
        r"""ConstIterator gdcm::SequenceOfFragments::Begin() const"""
        return _gdcmswig.SmartPtrFrag_Begin(self, *args)

    def End(self, *args):
        r"""
        ConstIterator
        gdcm::SequenceOfFragments::End() const 
        """
        return _gdcmswig.SmartPtrFrag_End(self, *args)

    def GetLength(self):
        r"""
        VL
        gdcm::SequenceOfFragments::GetLength() const override

        Returns the SQ length, as read from disk. 
        """
        return _gdcmswig.SmartPtrFrag_GetLength(self)

    def SetLength(self, length):
        r"""
        void
        gdcm::SequenceOfFragments::SetLength(VL length) override

        Sets the actual SQ length. 
        """
        return _gdcmswig.SmartPtrFrag_SetLength(self, length)

    def Clear(self):
        r"""
        void
        gdcm::SequenceOfFragments::Clear() override

        Clear. 
        """
        return _gdcmswig.SmartPtrFrag_Clear(self)

    def AddFragment(self, item):
        r"""
        void
        gdcm::SequenceOfFragments::AddFragment(Fragment const &item)

        Appends a Fragment to the already added ones. 
        """
        return _gdcmswig.SmartPtrFrag_AddFragment(self, item)

    def ComputeByteLength(self):
        r"""unsigned long gdcm::SequenceOfFragments::ComputeByteLength() const"""
        return _gdcmswig.SmartPtrFrag_ComputeByteLength(self)

    def ComputeLength(self):
        r"""
        VL
        gdcm::SequenceOfFragments::ComputeLength() const 
        """
        return _gdcmswig.SmartPtrFrag_ComputeLength(self)

    def GetBuffer(self, buffer, length):
        r"""
        bool
        gdcm::SequenceOfFragments::GetBuffer(char *buffer, unsigned long
        length) const 
        """
        return _gdcmswig.SmartPtrFrag_GetBuffer(self, buffer, length)

    def GetFragBuffer(self, fragNb, buffer, length):
        r"""
        bool
        gdcm::SequenceOfFragments::GetFragBuffer(unsigned int fragNb, char
        *buffer, unsigned long &length) const 
        """
        return _gdcmswig.SmartPtrFrag_GetFragBuffer(self, fragNb, buffer, length)

    def GetNumberOfFragments(self):
        r"""SizeType gdcm::SequenceOfFragments::GetNumberOfFragments() const"""
        return _gdcmswig.SmartPtrFrag_GetNumberOfFragments(self)

    def GetFragment(self, num):
        r"""
        const
        Fragment& gdcm::SequenceOfFragments::GetFragment(SizeType num) const

        """
        return _gdcmswig.SmartPtrFrag_GetFragment(self, num)

    def WriteBuffer(self, os):
        r"""
        bool
        gdcm::SequenceOfFragments::WriteBuffer(std::ostream &os) const 
        """
        return _gdcmswig.SmartPtrFrag_WriteBuffer(self, os)

    def GetTable(self, *args):
        r"""
        const
        BasicOffsetTable& gdcm::SequenceOfFragments::GetTable() const 
        """
        return _gdcmswig.SmartPtrFrag_GetTable(self, *args)

    def New(self):
        return _gdcmswig.SmartPtrFrag_New(self)

    def Print(self, os):
        r"""
        void
        gdcm::SequenceOfFragments::Print(std::ostream &os) const override 
        """
        return _gdcmswig.SmartPtrFrag_Print(self, os)

    def __eq__(self, val):
        return _gdcmswig.SmartPtrFrag___eq__(self, val)

    def __str__(self):
        return _gdcmswig.SmartPtrFrag___str__(self)

# Register SmartPtrFrag in _gdcmswig:
_gdcmswig.SmartPtrFrag_swigregister(SmartPtrFrag)
class DataElement(object):
    r"""


    Class to represent a Data Element either Implicit or Explicit.

    DATA ELEMENT: A unit of information as defined by a single entry in
    the data dictionary. An encoded Information Object Definition ( IOD)
    Attribute that is composed of, at a minimum, three fields: a Data
    Element Tag, a Value Length, and a Value Field. For some specific
    Transfer Syntaxes, a Data Element also contains a VR Field where the
    Value Representation of that Data Element is specified explicitly.

    Design: A DataElement in GDCM always store VL ( Value Length) on a 32
    bits integer even when VL is 16 bits

    A DataElement always store the VR even for Implicit TS, in which case
    VR is defaulted to VR::INVALID

    For Item start/end (See 0xfffe tags), Value is NULL

    See:   ExplicitDataElement ImplicitDataElement

    C++ includes: gdcmDataElement.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def GetTag(self, *args):
        r"""
        const Tag&
        gdcm::DataElement::GetTag() const

        Get Tag. 
        """
        return _gdcmswig.DataElement_GetTag(self, *args)

    def SetTag(self, t):
        r"""
        void
        gdcm::DataElement::SetTag(const Tag &t)

        Set Tag Use with cautious (need to match Part 6) 
        """
        return _gdcmswig.DataElement_SetTag(self, t)

    def GetVL(self, *args):
        r"""
        const VL&
        gdcm::DataElement::GetVL() const

        Get VL. 
        """
        return _gdcmswig.DataElement_GetVL(self, *args)

    def SetVL(self, vl):
        r"""
        void
        gdcm::DataElement::SetVL(const VL &vl)

        Set VL Use with cautious (need to match Part 6), advanced user only
        See:   SetByteValue 
        """
        return _gdcmswig.DataElement_SetVL(self, vl)

    def SetVLToUndefined(self):
        r"""
        void
        gdcm::DataElement::SetVLToUndefined() 
        """
        return _gdcmswig.DataElement_SetVLToUndefined(self)

    def GetVR(self):
        r"""
        VR const&
        gdcm::DataElement::GetVR() const

        Get VR do not set VR::SQ on bytevalue data element 
        """
        return _gdcmswig.DataElement_GetVR(self)

    def SetVR(self, vr):
        r"""
        void
        gdcm::DataElement::SetVR(VR const &vr)

        Set VR Use with cautious (need to match Part 6), advanced user only vr
        is a VR::VRALL (not a dual one such as OB_OW) 
        """
        return _gdcmswig.DataElement_SetVR(self, vr)

    def GetValue(self, *args):
        r"""
        Value const&
        gdcm::DataElement::GetValue() const

        Set/Get Value (bytes array, SQ of items, SQ of fragments): 
        """
        return _gdcmswig.DataElement_GetValue(self, *args)

    def SetValue(self, vl):
        r"""
        void
        gdcm::DataElement::SetValue(Value const &vl)

        WARNING:  you need to set the ValueLengthField explicitly 
        """
        return _gdcmswig.DataElement_SetValue(self, vl)

    def IsEmpty(self):
        r"""
        bool
        gdcm::DataElement::IsEmpty() const

        Check if Data Element is empty. 
        """
        return _gdcmswig.DataElement_IsEmpty(self)

    def Empty(self):
        r"""
        void
        gdcm::DataElement::Empty()

        Make Data Element empty (no Value) 
        """
        return _gdcmswig.DataElement_Empty(self)

    def Clear(self):
        r"""
        void
        gdcm::DataElement::Clear()

        Clear Data Element (make Value empty and invalidate Tag & VR) 
        """
        return _gdcmswig.DataElement_Clear(self)

    def SetByteValue(self, array, length):
        r"""
        void
        gdcm::DataElement::SetByteValue(const char *array, VL length)

        Set the byte value WARNING:  user need to read DICOM standard for an
        understanding of: even padding

        \\0 vs space padding By default even padding is achieved using \\0
        regardless of the of VR 
        """
        return _gdcmswig.DataElement_SetByteValue(self, array, length)

    def GetByteValue(self):
        r"""
        const
        ByteValue* gdcm::DataElement::GetByteValue() const

        Return the Value of DataElement as a ByteValue (if possible) WARNING:
        : You need to check for NULL return value 
        """
        return _gdcmswig.DataElement_GetByteValue(self)

    def GetValueAsSQ(self):
        r"""
        SmartPointer<SequenceOfItems> gdcm::DataElement::GetValueAsSQ() const

        Interpret the Value stored in the DataElement. This is more robust
        (but also more expensive) to call this function rather than the
        simplest form: GetSequenceOfItems() It also return NULL when the Value
        is NOT of type SequenceOfItems WARNING:  in case GetSequenceOfItems()
        succeed the function return this value, otherwise it creates a new
        SequenceOfItems, you should handle that in your case, for instance:
        SmartPointer<SequenceOfItems> sqi = de.GetValueAsSQ(); 
        """
        return _gdcmswig.DataElement_GetValueAsSQ(self)

    def GetSequenceOfFragments(self, *args):
        r"""
        const SequenceOfFragments* gdcm::DataElement::GetSequenceOfFragments()
        const

        Return the Value of DataElement as a Sequence Of Fragments (if
        possible) WARNING:  : You need to check for NULL return value 
        """
        return _gdcmswig.DataElement_GetSequenceOfFragments(self, *args)

    def IsUndefinedLength(self):
        r"""
        bool
        gdcm::DataElement::IsUndefinedLength() const

        return if Value Length if of undefined length 
        """
        return _gdcmswig.DataElement_IsUndefinedLength(self)

    def __init__(self, *args):
        r"""
        gdcm::DataElement::DataElement(const Tag &t=Tag(0), const VL &vl=0,
        const VR &vr=VR::INVALID) 
        """
        _gdcmswig.DataElement_swiginit(self, _gdcmswig.new_DataElement(*args))

    def __lt__(self, de):
        return _gdcmswig.DataElement___lt__(self, de)

    def __eq__(self, de):
        return _gdcmswig.DataElement___eq__(self, de)

    def SetByteStringValue(self, array):
        return _gdcmswig.DataElement_SetByteStringValue(self, array)

    def __str__(self):
        return _gdcmswig.DataElement___str__(self)
    __swig_destroy__ = _gdcmswig.delete_DataElement

# Register DataElement in _gdcmswig:
_gdcmswig.DataElement_swigregister(DataElement)

def __ne__(lhs, rhs):
    return _gdcmswig.__ne__(lhs, rhs)
class Item(DataElement):
    r"""


    Class to represent an Item.

    A component of the value of a Data Element that is of Value
    Representation Sequence of Items. An Item contains a Data Set . See PS
    3.5 7.5.1 Item Encoding Rules Each Item of a Data Element of VR SQ
    shall be encoded as a DICOM Standard Data Element with a specific Data
    Element Tag of Value (FFFE,E000). The Item Tag is followed by a 4 byte
    Item Length field encoded in one of the following two ways Explicit/
    Implicit ITEM: A component of the Value of a Data Element that is of
    Value Representation Sequence of Items. An Item contains a Data Set.

    C++ includes: gdcmItem.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def Clear(self):
        r"""void gdcm::Item::Clear()"""
        return _gdcmswig.Item_Clear(self)

    def InsertDataElement(self, de):
        r"""
        void
        gdcm::Item::InsertDataElement(const DataElement &de) 
        """
        return _gdcmswig.Item_InsertDataElement(self, de)

    def GetDataElement(self, t):
        r"""
        const DataElement&
        gdcm::Item::GetDataElement(const Tag &t) const 
        """
        return _gdcmswig.Item_GetDataElement(self, t)

    def SetNestedDataSet(self, nested):
        r"""
        void
        gdcm::Item::SetNestedDataSet(const DataSet &nested) 
        """
        return _gdcmswig.Item_SetNestedDataSet(self, nested)

    def GetNestedDataSet(self, *args):
        r"""
        const DataSet&
        gdcm::Item::GetNestedDataSet() const 
        """
        return _gdcmswig.Item_GetNestedDataSet(self, *args)

    def __init__(self, *args):
        r"""
        gdcm::Item::Item(Item const
        &val) 
        """
        _gdcmswig.Item_swiginit(self, _gdcmswig.new_Item(*args))

    def FindDataElement(self, t):
        r"""
        bool
        gdcm::Item::FindDataElement(const Tag &t) const 
        """
        return _gdcmswig.Item_FindDataElement(self, t)

    def __str__(self):
        return _gdcmswig.Item___str__(self)
    __swig_destroy__ = _gdcmswig.delete_Item

# Register Item in _gdcmswig:
_gdcmswig.Item_swigregister(Item)
class SequenceOfItems(Value):
    r"""


    Class to represent a Sequence Of Items.

    (value representation : SQ) a Value Representation for Data Elements
    that contains a sequence of Data Sets.

    Sequence of Item allows for Nested Data Sets

    See PS 3.5, 7.4.6 Data Element Type Within a Sequence SEQUENCE OF
    ITEMS (VALUE REPRESENTATION SQ) A Value Representation for Data
    Elements that contain a sequence of Data Sets. Sequence of Items
    allows for Nested Data Sets.

    C++ includes: gdcmSequenceOfItems.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def Begin(self, *args):
        r"""
        ConstIterator
        gdcm::SequenceOfItems::Begin() const 
        """
        return _gdcmswig.SequenceOfItems_Begin(self, *args)

    def End(self, *args):
        r"""
        ConstIterator
        gdcm::SequenceOfItems::End() const 
        """
        return _gdcmswig.SequenceOfItems_End(self, *args)

    def __init__(self):
        r"""
        gdcm::SequenceOfItems::SequenceOfItems()

        constructor (UndefinedLength by default) 
        """
        _gdcmswig.SequenceOfItems_swiginit(self, _gdcmswig.new_SequenceOfItems())

    def GetLength(self):
        r"""
        VL
        gdcm::SequenceOfItems::GetLength() const override

        Returns the SQ length, as read from disk. 
        """
        return _gdcmswig.SequenceOfItems_GetLength(self)

    def SetLength(self, length):
        r"""
        void
        gdcm::SequenceOfItems::SetLength(VL length) override

        Sets the actual SQ length. 
        """
        return _gdcmswig.SequenceOfItems_SetLength(self, length)

    def SetLengthToUndefined(self):
        r"""
        void gdcm::SequenceOfItems::SetLengthToUndefined()

        Properly set the Sequence of Item to be undefined length. 
        """
        return _gdcmswig.SequenceOfItems_SetLengthToUndefined(self)

    def IsUndefinedLength(self):
        r"""
        bool
        gdcm::SequenceOfItems::IsUndefinedLength() const

        return if Value Length if of undefined length 
        """
        return _gdcmswig.SequenceOfItems_IsUndefinedLength(self)

    def Clear(self):
        r"""
        void
        gdcm::SequenceOfItems::Clear() override

        remove all items within the sequence 
        """
        return _gdcmswig.SequenceOfItems_Clear(self)

    def AddItem(self, item):
        r"""
        void
        gdcm::SequenceOfItems::AddItem(Item const &item)

        Appends an Item to the already added ones. 
        """
        return _gdcmswig.SequenceOfItems_AddItem(self, item)

    def AddNewUndefinedLengthItem(self):
        r"""
        Item&
        gdcm::SequenceOfItems::AddNewUndefinedLengthItem()

        Appends an Item to the already added ones. 
        """
        return _gdcmswig.SequenceOfItems_AddNewUndefinedLengthItem(self)

    def RemoveItemByIndex(self, index):
        r"""
        bool
        gdcm::SequenceOfItems::RemoveItemByIndex(const SizeType index)

        Remove an Item as specified by its index, if index > size, false is
        returned Index starts at 1 not 0 
        """
        return _gdcmswig.SequenceOfItems_RemoveItemByIndex(self, index)

    def IsEmpty(self):
        r"""
        bool
        gdcm::SequenceOfItems::IsEmpty() const 
        """
        return _gdcmswig.SequenceOfItems_IsEmpty(self)

    def GetNumberOfItems(self):
        r"""SizeType gdcm::SequenceOfItems::GetNumberOfItems() const"""
        return _gdcmswig.SequenceOfItems_GetNumberOfItems(self)

    def SetNumberOfItems(self, n):
        r"""
        void
        gdcm::SequenceOfItems::SetNumberOfItems(SizeType n) 
        """
        return _gdcmswig.SequenceOfItems_SetNumberOfItems(self, n)

    def GetItem(self, *args):
        r"""
        const Item&
        gdcm::SequenceOfItems::GetItem(SizeType position) const 
        """
        return _gdcmswig.SequenceOfItems_GetItem(self, *args)

    def Print(self, os):
        r"""
        void
        gdcm::SequenceOfItems::Print(std::ostream &os) const override 
        """
        return _gdcmswig.SequenceOfItems_Print(self, os)

    @staticmethod
    def New():
        return _gdcmswig.SequenceOfItems_New()

    def FindDataElement(self, t):
        r"""
        bool
        gdcm::SequenceOfItems::FindDataElement(const Tag &t) const 
        """
        return _gdcmswig.SequenceOfItems_FindDataElement(self, t)

    def __eq__(self, val):
        return _gdcmswig.SequenceOfItems___eq__(self, val)
    SequenceLengthField = property(_gdcmswig.SequenceOfItems_SequenceLengthField_get, _gdcmswig.SequenceOfItems_SequenceLengthField_set)
    Items = property(_gdcmswig.SequenceOfItems_Items_get, _gdcmswig.SequenceOfItems_Items_set)

    def __str__(self):
        return _gdcmswig.SequenceOfItems___str__(self)
    __swig_destroy__ = _gdcmswig.delete_SequenceOfItems

# Register SequenceOfItems in _gdcmswig:
_gdcmswig.SequenceOfItems_swigregister(SequenceOfItems)
class DataElementException(object):
    r"""
    C++ includes:
    gdcmDataSet.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _gdcmswig.DataElementException_swiginit(self, _gdcmswig.new_DataElementException())
    __swig_destroy__ = _gdcmswig.delete_DataElementException

# Register DataElementException in _gdcmswig:
_gdcmswig.DataElementException_swigregister(DataElementException)
class DataSet(object):
    r"""


    Class to represent a Data Set (which contains Data Elements)

    A Data Set represents an instance of a real world Information Object
    DATA SET: Exchanged information consisting of a structured set of
    Attribute values directly or indirectly related to Information
    Objects. The value of each Attribute in a Data Set is expressed as a
    Data Element. A collection of Data Elements ordered by increasing Data
    Element Tag number that is an encoding of the values of Attributes of
    a real world object.

    Implementation note. If one do: DataSet ds; ds.SetLength(0);
    ds.Read(is); setting length to 0 actually means try to read is as if
    it was a root DataSet. Other value are undefined (nested dataset with
    undefined length) or defined length (different from 0) means nested
    dataset with defined length.

    WARNING:  a DataSet does not have a Transfer Syntax type, only a File
    does.

    C++ includes: gdcmDataSet.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def Begin(self, *args):
        r"""
        ConstIterator
        gdcm::DataSet::Begin() const 
        """
        return _gdcmswig.DataSet_Begin(self, *args)

    def End(self, *args):
        r"""
        ConstIterator
        gdcm::DataSet::End() const 
        """
        return _gdcmswig.DataSet_End(self, *args)

    def GetDES(self, *args):
        r"""
        const DataElementSet&
        gdcm::DataSet::GetDES() const 
        """
        return _gdcmswig.DataSet_GetDES(self, *args)

    def Clear(self):
        r"""
        void
        gdcm::DataSet::Clear() 
        """
        return _gdcmswig.DataSet_Clear(self)

    def Size(self):
        r"""
        SizeType
        gdcm::DataSet::Size() const 
        """
        return _gdcmswig.DataSet_Size(self)

    def Print(self, *args):
        r"""
        void
        gdcm::DataSet::Print(std::ostream &os, std::string const &indent="")
        const 
        """
        return _gdcmswig.DataSet_Print(self, *args)

    def Insert(self, de):
        r"""
        void
        gdcm::DataSet::Insert(const DataElement &de)

        Insert a DataElement in the DataSet. WARNING:  : Tag need to be >= 0x8
        to be considered valid data element 
        """
        return _gdcmswig.DataSet_Insert(self, de)

    def Replace(self, de):
        r"""
        void
        gdcm::DataSet::Replace(const DataElement &de)

        Replace a dataelement with another one. 
        """
        return _gdcmswig.DataSet_Replace(self, de)

    def ReplaceEmpty(self, de):
        r"""
        void
        gdcm::DataSet::ReplaceEmpty(const DataElement &de)

        Only replace a DICOM attribute when it is missing or empty. 
        """
        return _gdcmswig.DataSet_ReplaceEmpty(self, de)

    def Remove(self, tag):
        r"""
        SizeType
        gdcm::DataSet::Remove(const Tag &tag)

        Completely remove a dataelement from the dataset. 
        """
        return _gdcmswig.DataSet_Remove(self, tag)

    def __call__(self, group, element):
        return _gdcmswig.DataSet___call__(self, group, element)

    def GetPrivateCreator(self, t):
        r"""
        std::string
        gdcm::DataSet::GetPrivateCreator(const Tag &t) const

        Return the private creator of the private tag 't': or an empty string
        when not found 
        """
        return _gdcmswig.DataSet_GetPrivateCreator(self, t)

    def GetPrivateTag(self, t):
        r"""
        PrivateTag
        gdcm::DataSet::GetPrivateTag(const Tag &t) const

        Return the private tag of the private tag 't', private creator will be
        set to empty if not found. 
        """
        return _gdcmswig.DataSet_GetPrivateTag(self, t)

    def GetDataElement(self, *args):
        r"""
        const
        DataElement& gdcm::DataSet::GetDataElement(const Tag &t) const

        Return the DataElement with Tag 't' WARNING:  : This only search at
        the 'root level' of the DataSet 
        """
        return _gdcmswig.DataSet_GetDataElement(self, *args)

    def FindDataElement(self, *args):
        r"""
        bool
        gdcm::DataSet::FindDataElement(const Tag &t) const 
        """
        return _gdcmswig.DataSet_FindDataElement(self, *args)

    def FindNextDataElement(self, t):
        r"""
        const
        DataElement& gdcm::DataSet::FindNextDataElement(const Tag &t) const 
        """
        return _gdcmswig.DataSet_FindNextDataElement(self, t)

    def IsEmpty(self):
        r"""
        bool
        gdcm::DataSet::IsEmpty() const

        Returns if the dataset is empty. 
        """
        return _gdcmswig.DataSet_IsEmpty(self)

    def GetMediaStorage(self):
        r"""
        MediaStorage
        gdcm::DataSet::GetMediaStorage() const 
        """
        return _gdcmswig.DataSet_GetMediaStorage(self)

    def __str__(self):
        return _gdcmswig.DataSet___str__(self)

    def __init__(self):
        _gdcmswig.DataSet_swiginit(self, _gdcmswig.new_DataSet())
    __swig_destroy__ = _gdcmswig.delete_DataSet

# Register DataSet in _gdcmswig:
_gdcmswig.DataSet_swigregister(DataSet)
class PythonDataSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, des):
        _gdcmswig.PythonDataSet_swiginit(self, _gdcmswig.new_PythonDataSet(des))

    def GetCurrent(self):
        return _gdcmswig.PythonDataSet_GetCurrent(self)

    def Start(self):
        return _gdcmswig.PythonDataSet_Start(self)

    def IsAtEnd(self):
        return _gdcmswig.PythonDataSet_IsAtEnd(self)

    def Next(self):
        return _gdcmswig.PythonDataSet_Next(self)
    __swig_destroy__ = _gdcmswig.delete_PythonDataSet

# Register PythonDataSet in _gdcmswig:
_gdcmswig.PythonDataSet_swigregister(PythonDataSet)
class PhotometricInterpretation(object):
    r"""


    Class to represent an PhotometricInterpretation.

    C++ includes: gdcmPhotometricInterpretation.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    UNKNOWN = _gdcmswig.PhotometricInterpretation_UNKNOWN
    MONOCHROME1 = _gdcmswig.PhotometricInterpretation_MONOCHROME1
    MONOCHROME2 = _gdcmswig.PhotometricInterpretation_MONOCHROME2
    PALETTE_COLOR = _gdcmswig.PhotometricInterpretation_PALETTE_COLOR
    RGB = _gdcmswig.PhotometricInterpretation_RGB
    HSV = _gdcmswig.PhotometricInterpretation_HSV
    ARGB = _gdcmswig.PhotometricInterpretation_ARGB
    CMYK = _gdcmswig.PhotometricInterpretation_CMYK
    YBR_FULL = _gdcmswig.PhotometricInterpretation_YBR_FULL
    YBR_FULL_422 = _gdcmswig.PhotometricInterpretation_YBR_FULL_422
    YBR_PARTIAL_422 = _gdcmswig.PhotometricInterpretation_YBR_PARTIAL_422
    YBR_PARTIAL_420 = _gdcmswig.PhotometricInterpretation_YBR_PARTIAL_420
    YBR_ICT = _gdcmswig.PhotometricInterpretation_YBR_ICT
    YBR_RCT = _gdcmswig.PhotometricInterpretation_YBR_RCT
    PI_END = _gdcmswig.PhotometricInterpretation_PI_END

    def __init__(self, *args):
        r"""
        gdcm::PhotometricInterpretation::PhotometricInterpretation(PIType
        pi=UNKNOWN) 
        """
        _gdcmswig.PhotometricInterpretation_swiginit(self, _gdcmswig.new_PhotometricInterpretation(*args))

    @staticmethod
    def GetPIString(pi):
        return _gdcmswig.PhotometricInterpretation_GetPIString(pi)

    def GetString(self):
        r"""const char* gdcm::PhotometricInterpretation::GetString() const"""
        return _gdcmswig.PhotometricInterpretation_GetString(self)

    @staticmethod
    def GetPIType(pi):
        return _gdcmswig.PhotometricInterpretation_GetPIType(pi)

    @staticmethod
    def IsRetired(pi):
        return _gdcmswig.PhotometricInterpretation_IsRetired(pi)

    def IsLossy(self):
        r"""
        bool
        gdcm::PhotometricInterpretation::IsLossy() const 
        """
        return _gdcmswig.PhotometricInterpretation_IsLossy(self)

    def IsLossless(self):
        r"""bool gdcm::PhotometricInterpretation::IsLossless() const"""
        return _gdcmswig.PhotometricInterpretation_IsLossless(self)

    def GetSamplesPerPixel(self):
        r"""
        unsigned short
        gdcm::PhotometricInterpretation::GetSamplesPerPixel() const

        return the value for Sample Per Pixel associated with a particular
        Photometric Interpretation 
        """
        return _gdcmswig.PhotometricInterpretation_GetSamplesPerPixel(self)

    def GetType(self):
        r"""PIType gdcm::PhotometricInterpretation::GetType() const"""
        return _gdcmswig.PhotometricInterpretation_GetType(self)

    def IsSameColorSpace(self, pi):
        r"""
        bool
        gdcm::PhotometricInterpretation::IsSameColorSpace(PhotometricInterpretation
        const &pi) const 
        """
        return _gdcmswig.PhotometricInterpretation_IsSameColorSpace(self, pi)

    def __str__(self):
        return _gdcmswig.PhotometricInterpretation___str__(self)
    __swig_destroy__ = _gdcmswig.delete_PhotometricInterpretation

# Register PhotometricInterpretation in _gdcmswig:
_gdcmswig.PhotometricInterpretation_swigregister(PhotometricInterpretation)
class LookupTable(Object):
    r"""


    LookupTable class.

    C++ includes: gdcmLookupTable.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    RED = _gdcmswig.LookupTable_RED
    GREEN = _gdcmswig.LookupTable_GREEN
    BLUE = _gdcmswig.LookupTable_BLUE
    GRAY = _gdcmswig.LookupTable_GRAY
    UNKNOWN = _gdcmswig.LookupTable_UNKNOWN
    __swig_destroy__ = _gdcmswig.delete_LookupTable

    def Print(self, arg2):
        r"""
        void
        gdcm::LookupTable::Print(std::ostream &) const override 
        """
        return _gdcmswig.LookupTable_Print(self, arg2)

    def Allocate(self, bitsample=8):
        r"""
        void
        gdcm::LookupTable::Allocate(unsigned short bitsample=8)

        Allocate the LUT. 
        """
        return _gdcmswig.LookupTable_Allocate(self, bitsample)

    def InitializeLUT(self, type, length, subscript, bitsize):
        r"""
        void
        gdcm::LookupTable::InitializeLUT(LookupTableType type, unsigned short
        length, unsigned short subscript, unsigned short bitsize)

        Generic interface: 
        """
        return _gdcmswig.LookupTable_InitializeLUT(self, type, length, subscript, bitsize)

    def GetLUTLength(self, type):
        r"""
        unsigned int
        gdcm::LookupTable::GetLUTLength(LookupTableType type) const 
        """
        return _gdcmswig.LookupTable_GetLUTLength(self, type)

    def SetLUT(self, type, array, length):
        r"""
        virtual void
        gdcm::LookupTable::SetLUT(LookupTableType type, const unsigned char
        *array, unsigned int length) 
        """
        return _gdcmswig.LookupTable_SetLUT(self, type, array, length)

    def GetLUT(self, type, array, length):
        r"""
        void
        gdcm::LookupTable::GetLUT(LookupTableType type, unsigned char *array,
        unsigned int &length) const 
        """
        return _gdcmswig.LookupTable_GetLUT(self, type, array, length)

    def GetLUTDescriptor(self, type, length, subscript, bitsize):
        r"""
        void
        gdcm::LookupTable::GetLUTDescriptor(LookupTableType type, unsigned
        short &length, unsigned short &subscript, unsigned short &bitsize)
        const 
        """
        return _gdcmswig.LookupTable_GetLUTDescriptor(self, type, length, subscript, bitsize)

    def InitializeRedLUT(self, length, subscript, bitsize):
        r"""
        void
        gdcm::LookupTable::InitializeRedLUT(unsigned short length, unsigned
        short subscript, unsigned short bitsize)

        RED / GREEN / BLUE specific: 
        """
        return _gdcmswig.LookupTable_InitializeRedLUT(self, length, subscript, bitsize)

    def SetRedLUT(self, red, length):
        r"""
        void
        gdcm::LookupTable::SetRedLUT(const unsigned char *red, unsigned int
        length) 
        """
        return _gdcmswig.LookupTable_SetRedLUT(self, red, length)

    def InitializeGreenLUT(self, length, subscript, bitsize):
        r"""
        void
        gdcm::LookupTable::InitializeGreenLUT(unsigned short length, unsigned
        short subscript, unsigned short bitsize) 
        """
        return _gdcmswig.LookupTable_InitializeGreenLUT(self, length, subscript, bitsize)

    def SetGreenLUT(self, green, length):
        r"""
        void
        gdcm::LookupTable::SetGreenLUT(const unsigned char *green, unsigned
        int length) 
        """
        return _gdcmswig.LookupTable_SetGreenLUT(self, green, length)

    def InitializeBlueLUT(self, length, subscript, bitsize):
        r"""
        void
        gdcm::LookupTable::InitializeBlueLUT(unsigned short length, unsigned
        short subscript, unsigned short bitsize) 
        """
        return _gdcmswig.LookupTable_InitializeBlueLUT(self, length, subscript, bitsize)

    def SetBlueLUT(self, blue, length):
        r"""
        void
        gdcm::LookupTable::SetBlueLUT(const unsigned char *blue, unsigned int
        length) 
        """
        return _gdcmswig.LookupTable_SetBlueLUT(self, blue, length)

    def Clear(self):
        r"""
        void
        gdcm::LookupTable::Clear()

        Clear the LUT. 
        """
        return _gdcmswig.LookupTable_Clear(self)

    def Decode(self, *args):
        r"""
        void
        gdcm::LookupTable::Decode(std::istream &is, std::ostream &os) const

        Decode the LUT. 
        """
        return _gdcmswig.LookupTable_Decode(self, *args)

    def IsRGB8(self):
        r"""
        bool
        gdcm::LookupTable::IsRGB8() const

        Return whether 16 bits LUT is in RGB 8 bits space. 
        """
        return _gdcmswig.LookupTable_IsRGB8(self)

    def Decode8(self, outputbuffer, outlen, inputbuffer, inlen):
        r"""
        bool
        gdcm::LookupTable::Decode8(char *outputbuffer, size_t outlen, const
        char *inputbuffer, size_t inlen) const

        Decode into RGB 8 bits space. 
        """
        return _gdcmswig.LookupTable_Decode8(self, outputbuffer, outlen, inputbuffer, inlen)

    def __init__(self, *args):
        r"""gdcm::LookupTable::LookupTable(LookupTable const &lut)"""
        _gdcmswig.LookupTable_swiginit(self, _gdcmswig.new_LookupTable(*args))

    def GetBufferAsRGBA(self, rgba):
        r"""
        bool
        gdcm::LookupTable::GetBufferAsRGBA(unsigned char *rgba) const

        return the LUT as RGBA buffer 
        """
        return _gdcmswig.LookupTable_GetBufferAsRGBA(self, rgba)

    def GetPointer(self):
        r"""
        const unsigned
        char* gdcm::LookupTable::GetPointer() const

        return a raw pointer to the LUT 
        """
        return _gdcmswig.LookupTable_GetPointer(self)

    def WriteBufferAsRGBA(self, rgba):
        r"""
        bool
        gdcm::LookupTable::WriteBufferAsRGBA(const unsigned char *rgba)

        Write the LUT as RGBA. 
        """
        return _gdcmswig.LookupTable_WriteBufferAsRGBA(self, rgba)

    def GetBitSample(self):
        r"""
        unsigned
        short gdcm::LookupTable::GetBitSample() const

        return the bit sample 
        """
        return _gdcmswig.LookupTable_GetBitSample(self)

    def Initialized(self):
        r"""
        bool
        gdcm::LookupTable::Initialized() const

        return whether the LUT has been initialized 
        """
        return _gdcmswig.LookupTable_Initialized(self)

    def __str__(self):
        return _gdcmswig.LookupTable___str__(self)

# Register LookupTable in _gdcmswig:
_gdcmswig.LookupTable_swigregister(LookupTable)
class Overlay(Object):
    r"""


    Overlay class.

    see AreOverlaysInPixelData Todo Is there actually any way to recognize
    an overlay ? On images with multiple overlay I do not see any way to
    differentiate them (other than the group tag).

    Example:

    C++ includes: gdcmOverlay.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_Overlay

    def Print(self, arg2):
        r"""
        void
        gdcm::Overlay::Print(std::ostream &) const override

        Print. 
        """
        return _gdcmswig.Overlay_Print(self, arg2)

    def Update(self, de):
        r"""
        void
        gdcm::Overlay::Update(const DataElement &de)

        Update overlay from data element de: 
        """
        return _gdcmswig.Overlay_Update(self, de)

    def SetGroup(self, group):
        r"""
        void
        gdcm::Overlay::SetGroup(unsigned short group)

        Set Group number. 
        """
        return _gdcmswig.Overlay_SetGroup(self, group)

    def GetGroup(self):
        r"""
        unsigned short
        gdcm::Overlay::GetGroup() const

        Get Group number. 
        """
        return _gdcmswig.Overlay_GetGroup(self)

    def SetRows(self, rows):
        r"""
        void
        gdcm::Overlay::SetRows(unsigned short rows)

        set rows 
        """
        return _gdcmswig.Overlay_SetRows(self, rows)

    def GetRows(self):
        r"""
        unsigned short
        gdcm::Overlay::GetRows() const

        get rows 
        """
        return _gdcmswig.Overlay_GetRows(self)

    def SetColumns(self, columns):
        r"""
        void
        gdcm::Overlay::SetColumns(unsigned short columns)

        set columns 
        """
        return _gdcmswig.Overlay_SetColumns(self, columns)

    def GetColumns(self):
        r"""
        unsigned short
        gdcm::Overlay::GetColumns() const

        get columns 
        """
        return _gdcmswig.Overlay_GetColumns(self)

    def SetNumberOfFrames(self, numberofframes):
        r"""
        void
        gdcm::Overlay::SetNumberOfFrames(unsigned int numberofframes)

        set number of frames 
        """
        return _gdcmswig.Overlay_SetNumberOfFrames(self, numberofframes)

    def SetDescription(self, description):
        r"""
        void
        gdcm::Overlay::SetDescription(const char *description)

        set description 
        """
        return _gdcmswig.Overlay_SetDescription(self, description)

    def GetDescription(self):
        r"""
        const char*
        gdcm::Overlay::GetDescription() const

        get description 
        """
        return _gdcmswig.Overlay_GetDescription(self)
    Invalid = _gdcmswig.Overlay_Invalid
    Graphics = _gdcmswig.Overlay_Graphics
    ROI = _gdcmswig.Overlay_ROI

    def SetType(self, type):
        r"""
        void
        gdcm::Overlay::SetType(const char *type)

        set type 
        """
        return _gdcmswig.Overlay_SetType(self, type)

    def GetType(self):
        r"""
        const char*
        gdcm::Overlay::GetType() const

        get type 
        """
        return _gdcmswig.Overlay_GetType(self)

    def GetTypeAsEnum(self):
        r"""
        OverlayType
        gdcm::Overlay::GetTypeAsEnum() const 
        """
        return _gdcmswig.Overlay_GetTypeAsEnum(self)

    @staticmethod
    def GetOverlayTypeAsString(ot):
        return _gdcmswig.Overlay_GetOverlayTypeAsString(ot)

    @staticmethod
    def GetOverlayTypeFromString(arg1):
        return _gdcmswig.Overlay_GetOverlayTypeFromString(arg1)

    def SetOrigin(self, origin):
        r"""
        void
        gdcm::Overlay::SetOrigin(const signed short origin[2])

        set origin 
        """
        return _gdcmswig.Overlay_SetOrigin(self, origin)

    def GetOrigin(self):
        r"""
        const signed short*
        gdcm::Overlay::GetOrigin() const

        get origin 
        """
        return _gdcmswig.Overlay_GetOrigin(self)

    def SetFrameOrigin(self, frameorigin):
        r"""
        void
        gdcm::Overlay::SetFrameOrigin(unsigned short frameorigin)

        set frame origin 
        """
        return _gdcmswig.Overlay_SetFrameOrigin(self, frameorigin)

    def SetBitsAllocated(self, bitsallocated):
        r"""
        void
        gdcm::Overlay::SetBitsAllocated(unsigned short bitsallocated)

        set bits allocated 
        """
        return _gdcmswig.Overlay_SetBitsAllocated(self, bitsallocated)

    def GetBitsAllocated(self):
        r"""
        unsigned
        short gdcm::Overlay::GetBitsAllocated() const

        return bits allocated 
        """
        return _gdcmswig.Overlay_GetBitsAllocated(self)

    def SetBitPosition(self, bitposition):
        r"""
        void
        gdcm::Overlay::SetBitPosition(unsigned short bitposition)

        set bit position 
        """
        return _gdcmswig.Overlay_SetBitPosition(self, bitposition)

    def GetBitPosition(self):
        r"""
        unsigned short
        gdcm::Overlay::GetBitPosition() const

        return bit position 
        """
        return _gdcmswig.Overlay_GetBitPosition(self)

    def SetOverlay(self, array, length):
        r"""
        void
        gdcm::Overlay::SetOverlay(const char *array, size_t length)

        set overlay from byte array + length 
        """
        return _gdcmswig.Overlay_SetOverlay(self, array, length)

    def GrabOverlayFromPixelData(self, ds):
        r"""
        bool
        gdcm::Overlay::GrabOverlayFromPixelData(DataSet const &ds) 
        """
        return _gdcmswig.Overlay_GrabOverlayFromPixelData(self, ds)

    def GetOverlayData(self):
        r"""
        const
        ByteValue& gdcm::Overlay::GetOverlayData() const

        Return the Overlay Data as ByteValue: Not thread safe 
        """
        return _gdcmswig.Overlay_GetOverlayData(self)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Overlay::IsEmpty() const

        Return whether or not the Overlay is empty: 
        """
        return _gdcmswig.Overlay_IsEmpty(self)

    def IsZero(self):
        r"""
        bool
        gdcm::Overlay::IsZero() const

        return true if all bits are set to 0 
        """
        return _gdcmswig.Overlay_IsZero(self)

    def IsInPixelData(self, *args):
        r"""
        void
        gdcm::Overlay::IsInPixelData(bool b)

        Set whether or no the OverlayData is in the Pixel Data: 
        """
        return _gdcmswig.Overlay_IsInPixelData(self, *args)

    def Decompress(self, os):
        r"""
        void
        gdcm::Overlay::Decompress(std::ostream &os) const

        Decode the internal OverlayData (packed bits) into unpacked
        representation. 
        """
        return _gdcmswig.Overlay_Decompress(self, os)

    def GetUnpackBufferLength(self):
        r"""
        size_t
        gdcm::Overlay::GetUnpackBufferLength() const

        Retrieve the size of the buffer needed to hold the Overlay as
        specified by Col & Row parameters 
        """
        return _gdcmswig.Overlay_GetUnpackBufferLength(self)

    def GetUnpackBuffer(self, buffer, len):
        r"""
        bool
        gdcm::Overlay::GetUnpackBuffer(char *buffer, size_t len) const

        Retrieve the unpack buffer for Overlay. This is an error if the size
        if below GetUnpackBufferLength() 
        """
        return _gdcmswig.Overlay_GetUnpackBuffer(self, buffer, len)

    def __init__(self, *args):
        r"""gdcm::Overlay::Overlay(Overlay const &ov)"""
        _gdcmswig.Overlay_swiginit(self, _gdcmswig.new_Overlay(*args))

    def __str__(self):
        return _gdcmswig.Overlay___str__(self)

# Register Overlay in _gdcmswig:
_gdcmswig.Overlay_swigregister(Overlay)
class DataElementSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.DataElementSet_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.DataElementSet___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.DataElementSet___bool__(self)

    def __len__(self):
        return _gdcmswig.DataElementSet___len__(self)

    def append(self, x):
        return _gdcmswig.DataElementSet_append(self, x)

    def __contains__(self, x):
        return _gdcmswig.DataElementSet___contains__(self, x)

    def __getitem__(self, i):
        return _gdcmswig.DataElementSet___getitem__(self, i)

    def add(self, x):
        return _gdcmswig.DataElementSet_add(self, x)

    def discard(self, x):
        return _gdcmswig.DataElementSet_discard(self, x)

    def __init__(self, *args):
        _gdcmswig.DataElementSet_swiginit(self, _gdcmswig.new_DataElementSet(*args))

    def empty(self):
        return _gdcmswig.DataElementSet_empty(self)

    def size(self):
        return _gdcmswig.DataElementSet_size(self)

    def clear(self):
        return _gdcmswig.DataElementSet_clear(self)

    def swap(self, v):
        return _gdcmswig.DataElementSet_swap(self, v)

    def count(self, x):
        return _gdcmswig.DataElementSet_count(self, x)

    def begin(self):
        return _gdcmswig.DataElementSet_begin(self)

    def end(self):
        return _gdcmswig.DataElementSet_end(self)

    def rbegin(self):
        return _gdcmswig.DataElementSet_rbegin(self)

    def rend(self):
        return _gdcmswig.DataElementSet_rend(self)

    def erase(self, *args):
        return _gdcmswig.DataElementSet_erase(self, *args)

    def find(self, x):
        return _gdcmswig.DataElementSet_find(self, x)

    def lower_bound(self, x):
        return _gdcmswig.DataElementSet_lower_bound(self, x)

    def upper_bound(self, x):
        return _gdcmswig.DataElementSet_upper_bound(self, x)

    def equal_range(self, x):
        return _gdcmswig.DataElementSet_equal_range(self, x)

    def insert(self, __x):
        return _gdcmswig.DataElementSet_insert(self, __x)
    __swig_destroy__ = _gdcmswig.delete_DataElementSet

# Register DataElementSet in _gdcmswig:
_gdcmswig.DataElementSet_swigregister(DataElementSet)
class Preamble(object):
    r"""


    DICOM Preamble (Part 10)

    C++ includes: gdcmPreamble.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_Preamble

    def Clear(self):
        r"""
        void
        gdcm::Preamble::Clear()

        Clear. 
        """
        return _gdcmswig.Preamble_Clear(self)

    def Valid(self):
        r"""
        void
        gdcm::Preamble::Valid()

        Set Preamble to the default one. 
        """
        return _gdcmswig.Preamble_Valid(self)

    def Create(self):
        r"""
        void
        gdcm::Preamble::Create() 
        """
        return _gdcmswig.Preamble_Create(self)

    def Remove(self):
        r"""
        void
        gdcm::Preamble::Remove() 
        """
        return _gdcmswig.Preamble_Remove(self)

    def Read(self, _is):
        r"""
        std::istream&
        gdcm::Preamble::Read(std::istream &is)

        Read Preamble. 
        """
        return _gdcmswig.Preamble_Read(self, _is)

    def Write(self, os):
        r"""
        std::ostream const&
        gdcm::Preamble::Write(std::ostream &os) const

        Write Preamble. 
        """
        return _gdcmswig.Preamble_Write(self, os)

    def Print(self, os):
        r"""
        void
        gdcm::Preamble::Print(std::ostream &os) const

        Print Preamble. 
        """
        return _gdcmswig.Preamble_Print(self, os)

    def GetInternal(self):
        r"""
        const char*
        gdcm::Preamble::GetInternal() const

        Get internal pointer to preamble. 
        """
        return _gdcmswig.Preamble_GetInternal(self)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Preamble::IsEmpty() const

        Check if Preamble is empty. 
        """
        return _gdcmswig.Preamble_IsEmpty(self)

    def GetLength(self):
        r"""
        VL
        gdcm::Preamble::GetLength() const

        Return size of Preamble. 
        """
        return _gdcmswig.Preamble_GetLength(self)

    def __init__(self, *args):
        r"""gdcm::Preamble::Preamble(Preamble const &)"""
        _gdcmswig.Preamble_swiginit(self, _gdcmswig.new_Preamble(*args))

    def __str__(self):
        return _gdcmswig.Preamble___str__(self)

# Register Preamble in _gdcmswig:
_gdcmswig.Preamble_swigregister(Preamble)
class TransferSyntax(object):
    r"""


    Class to manipulate Transfer Syntax.

    TRANSFER SYNTAX (Standard and Private): A set of encoding rules that
    allow Application Entities to unambiguously negotiate the encoding
    techniques (e.g., Data Element structure, byte ordering, compression)
    they are able to support, thereby allowing these Application Entities
    to communicate. Todo : The implementation is completely retarded ->
    see gdcm::UIDs for a replacement We need: IsSupported We need
    preprocess of raw/xml file We need GetFullName()

    Need a notion of Private Syntax. As defined in PS 3.5. Section 9.2

    See:   UIDs

    C++ includes: gdcmTransferSyntax.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Unknown = _gdcmswig.TransferSyntax_Unknown
    Explicit = _gdcmswig.TransferSyntax_Explicit
    Implicit = _gdcmswig.TransferSyntax_Implicit
    ImplicitVRLittleEndian = _gdcmswig.TransferSyntax_ImplicitVRLittleEndian
    ImplicitVRBigEndianPrivateGE = _gdcmswig.TransferSyntax_ImplicitVRBigEndianPrivateGE
    ExplicitVRLittleEndian = _gdcmswig.TransferSyntax_ExplicitVRLittleEndian
    DeflatedExplicitVRLittleEndian = _gdcmswig.TransferSyntax_DeflatedExplicitVRLittleEndian
    ExplicitVRBigEndian = _gdcmswig.TransferSyntax_ExplicitVRBigEndian
    JPEGBaselineProcess1 = _gdcmswig.TransferSyntax_JPEGBaselineProcess1
    JPEGExtendedProcess2_4 = _gdcmswig.TransferSyntax_JPEGExtendedProcess2_4
    JPEGExtendedProcess3_5 = _gdcmswig.TransferSyntax_JPEGExtendedProcess3_5
    JPEGSpectralSelectionProcess6_8 = _gdcmswig.TransferSyntax_JPEGSpectralSelectionProcess6_8
    JPEGFullProgressionProcess10_12 = _gdcmswig.TransferSyntax_JPEGFullProgressionProcess10_12
    JPEGLosslessProcess14 = _gdcmswig.TransferSyntax_JPEGLosslessProcess14
    JPEGLosslessProcess14_1 = _gdcmswig.TransferSyntax_JPEGLosslessProcess14_1
    JPEGLSLossless = _gdcmswig.TransferSyntax_JPEGLSLossless
    JPEGLSNearLossless = _gdcmswig.TransferSyntax_JPEGLSNearLossless
    JPEG2000Lossless = _gdcmswig.TransferSyntax_JPEG2000Lossless
    JPEG2000 = _gdcmswig.TransferSyntax_JPEG2000
    JPEG2000Part2Lossless = _gdcmswig.TransferSyntax_JPEG2000Part2Lossless
    JPEG2000Part2 = _gdcmswig.TransferSyntax_JPEG2000Part2
    RLELossless = _gdcmswig.TransferSyntax_RLELossless
    MPEG2MainProfile = _gdcmswig.TransferSyntax_MPEG2MainProfile
    ImplicitVRBigEndianACRNEMA = _gdcmswig.TransferSyntax_ImplicitVRBigEndianACRNEMA
    WeirdPapryus = _gdcmswig.TransferSyntax_WeirdPapryus
    CT_private_ELE = _gdcmswig.TransferSyntax_CT_private_ELE
    JPIPReferenced = _gdcmswig.TransferSyntax_JPIPReferenced
    MPEG2MainProfileHighLevel = _gdcmswig.TransferSyntax_MPEG2MainProfileHighLevel
    MPEG4AVCH264HighProfileLevel4_1 = _gdcmswig.TransferSyntax_MPEG4AVCH264HighProfileLevel4_1
    MPEG4AVCH264BDcompatibleHighProfileLevel4_1 = _gdcmswig.TransferSyntax_MPEG4AVCH264BDcompatibleHighProfileLevel4_1
    HTJ2KLossless = _gdcmswig.TransferSyntax_HTJ2KLossless
    HTJ2KRPCLLossless = _gdcmswig.TransferSyntax_HTJ2KRPCLLossless
    HTJ2K = _gdcmswig.TransferSyntax_HTJ2K
    TS_END = _gdcmswig.TransferSyntax_TS_END

    @staticmethod
    def GetTSString(ts):
        return _gdcmswig.TransferSyntax_GetTSString(ts)

    @staticmethod
    def GetTSType(str):
        return _gdcmswig.TransferSyntax_GetTSType(str)

    def GetNegociatedType(self):
        r"""NegociatedType gdcm::TransferSyntax::GetNegociatedType() const"""
        return _gdcmswig.TransferSyntax_GetNegociatedType(self)

    def GetSwapCode(self):
        r"""
        SwapCode
        gdcm::TransferSyntax::GetSwapCode() const

        Deprecated Return the SwapCode associated with the Transfer Syntax. Be
        careful with the special GE private syntax the DataSet is written in
        little endian but the Pixel Data is in Big Endian. 
        """
        return _gdcmswig.TransferSyntax_GetSwapCode(self)

    def IsValid(self):
        r"""
        bool
        gdcm::TransferSyntax::IsValid() const 
        """
        return _gdcmswig.TransferSyntax_IsValid(self)

    def __init__(self, *args):
        r"""
        gdcm::TransferSyntax::TransferSyntax(TSType
        type=ImplicitVRLittleEndian) 
        """
        _gdcmswig.TransferSyntax_swiginit(self, _gdcmswig.new_TransferSyntax(*args))

    def IsEncoded(self):
        r"""
        bool
        gdcm::TransferSyntax::IsEncoded() const 
        """
        return _gdcmswig.TransferSyntax_IsEncoded(self)

    def IsImplicit(self):
        r"""
        bool
        gdcm::TransferSyntax::IsImplicit() const 
        """
        return _gdcmswig.TransferSyntax_IsImplicit(self)

    def IsExplicit(self):
        r"""
        bool
        gdcm::TransferSyntax::IsExplicit() const 
        """
        return _gdcmswig.TransferSyntax_IsExplicit(self)

    def IsEncapsulated(self):
        r"""
        bool
        gdcm::TransferSyntax::IsEncapsulated() const 
        """
        return _gdcmswig.TransferSyntax_IsEncapsulated(self)

    def IsLossy(self):
        r"""
        bool
        gdcm::TransferSyntax::IsLossy() const

        Return true if the transfer syntax algorithm is a lossy algorithm 
        """
        return _gdcmswig.TransferSyntax_IsLossy(self)

    def IsLossless(self):
        r"""
        bool
        gdcm::TransferSyntax::IsLossless() const

        Return true if the transfer syntax algorithm is a lossless algorithm

        """
        return _gdcmswig.TransferSyntax_IsLossless(self)

    def CanStoreLossy(self):
        r"""
        bool
        gdcm::TransferSyntax::CanStoreLossy() const

        return true if TransFer Syntax Allow storing of Lossy Pixel Data 
        """
        return _gdcmswig.TransferSyntax_CanStoreLossy(self)

    def GetString(self):
        r"""
        const char*
        gdcm::TransferSyntax::GetString() const 
        """
        return _gdcmswig.TransferSyntax_GetString(self)

    def __str__(self):
        return _gdcmswig.TransferSyntax___str__(self)
    __swig_destroy__ = _gdcmswig.delete_TransferSyntax

# Register TransferSyntax in _gdcmswig:
_gdcmswig.TransferSyntax_swigregister(TransferSyntax)
class FileMetaInformation(DataSet):
    r"""


    Class to represent a File Meta Information.

    FileMetaInformation is a Explicit Structured Set. Whenever the file
    contains an ImplicitDataElement DataSet, a conversion will take place.

    Definition: The File Meta Information includes identifying information
    on the encapsulated Data Set. This header consists of a 128 byte File
    Preamble, followed by a 4 byte DICOM prefix, followed by the File Meta
    Elements shown in Table 7.1-1. This header shall be present in every
    DICOM file.

    See:   Writer Reader

    C++ includes: gdcmFileMetaInformation.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_FileMetaInformation

    def IsValid(self):
        r"""
        bool
        gdcm::FileMetaInformation::IsValid() const 
        """
        return _gdcmswig.FileMetaInformation_IsValid(self)

    def GetMetaInformationTS(self):
        r"""
        TransferSyntax::NegociatedType
        gdcm::FileMetaInformation::GetMetaInformationTS() const 
        """
        return _gdcmswig.FileMetaInformation_GetMetaInformationTS(self)

    def SetDataSetTransferSyntax(self, ts):
        r"""
        void
        gdcm::FileMetaInformation::SetDataSetTransferSyntax(const
        TransferSyntax &ts) 
        """
        return _gdcmswig.FileMetaInformation_SetDataSetTransferSyntax(self, ts)

    def GetDataSetTransferSyntax(self):
        r"""
        const
        TransferSyntax& gdcm::FileMetaInformation::GetDataSetTransferSyntax()
        const 
        """
        return _gdcmswig.FileMetaInformation_GetDataSetTransferSyntax(self)

    def GetMediaStorage(self):
        r"""MediaStorage gdcm::FileMetaInformation::GetMediaStorage() const"""
        return _gdcmswig.FileMetaInformation_GetMediaStorage(self)

    def GetMediaStorageAsString(self):
        r"""
        std::string
        gdcm::FileMetaInformation::GetMediaStorageAsString() const 
        """
        return _gdcmswig.FileMetaInformation_GetMediaStorageAsString(self)

    def Insert(self, de):
        r"""
        void
        gdcm::FileMetaInformation::Insert(const DataElement &de) 
        """
        return _gdcmswig.FileMetaInformation_Insert(self, de)

    def Replace(self, de):
        r"""
        void
        gdcm::FileMetaInformation::Replace(const DataElement &de) 
        """
        return _gdcmswig.FileMetaInformation_Replace(self, de)

    def Read(self, _is):
        r"""
        std::istream&
        gdcm::FileMetaInformation::Read(std::istream &is)

        Read. 
        """
        return _gdcmswig.FileMetaInformation_Read(self, _is)

    def ReadCompat(self, _is):
        r"""
        std::istream& gdcm::FileMetaInformation::ReadCompat(std::istream &is)

        """
        return _gdcmswig.FileMetaInformation_ReadCompat(self, _is)

    def Write(self, os):
        r"""
        std::ostream& gdcm::FileMetaInformation::Write(std::ostream &os) const

        Write. 
        """
        return _gdcmswig.FileMetaInformation_Write(self, os)

    def FillFromDataSet(self, ds):
        r"""
        void gdcm::FileMetaInformation::FillFromDataSet(DataSet const &ds)

        Construct a FileMetaInformation from an already existing DataSet: 
        """
        return _gdcmswig.FileMetaInformation_FillFromDataSet(self, ds)

    def GetPreamble(self, *args):
        r"""
        const
        Preamble& gdcm::FileMetaInformation::GetPreamble() const

        Get Preamble. 
        """
        return _gdcmswig.FileMetaInformation_GetPreamble(self, *args)

    def SetPreamble(self, p):
        r"""
        void
        gdcm::FileMetaInformation::SetPreamble(const Preamble &p) 
        """
        return _gdcmswig.FileMetaInformation_SetPreamble(self, p)

    @staticmethod
    def SetImplementationClassUID(imp):
        return _gdcmswig.FileMetaInformation_SetImplementationClassUID(imp)

    @staticmethod
    def AppendImplementationClassUID(imp):
        return _gdcmswig.FileMetaInformation_AppendImplementationClassUID(imp)

    @staticmethod
    def GetImplementationClassUID():
        return _gdcmswig.FileMetaInformation_GetImplementationClassUID()

    @staticmethod
    def SetImplementationVersionName(version):
        return _gdcmswig.FileMetaInformation_SetImplementationVersionName(version)

    @staticmethod
    def GetImplementationVersionName():
        return _gdcmswig.FileMetaInformation_GetImplementationVersionName()

    @staticmethod
    def SetSourceApplicationEntityTitle(title):
        return _gdcmswig.FileMetaInformation_SetSourceApplicationEntityTitle(title)

    @staticmethod
    def GetSourceApplicationEntityTitle():
        return _gdcmswig.FileMetaInformation_GetSourceApplicationEntityTitle()

    def __init__(self, *args):
        r"""
        gdcm::FileMetaInformation::FileMetaInformation(FileMetaInformation
        const &fmi) 
        """
        _gdcmswig.FileMetaInformation_swiginit(self, _gdcmswig.new_FileMetaInformation(*args))

    def GetFullLength(self):
        r"""
        VL
        gdcm::FileMetaInformation::GetFullLength() const 
        """
        return _gdcmswig.FileMetaInformation_GetFullLength(self)

    def __str__(self):
        return _gdcmswig.FileMetaInformation___str__(self)

# Register FileMetaInformation in _gdcmswig:
_gdcmswig.FileMetaInformation_swigregister(FileMetaInformation)
class File(Object):
    r"""


    a DICOM File

    See PS 3.10 File: A File is an ordered string of zero or more bytes,
    where the first byte is at the beginning of the file and the last byte
    at the end of the File. Files are identified by a unique File ID and
    may by written, read and/or deleted.

    See:   Reader Writer

    C++ includes: gdcmFile.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::File::File()"""
        _gdcmswig.File_swiginit(self, _gdcmswig.new_File())
    __swig_destroy__ = _gdcmswig.delete_File

    def Read(self, _is):
        r"""
        std::istream&
        gdcm::File::Read(std::istream &is)

        Read. 
        """
        return _gdcmswig.File_Read(self, _is)

    def Write(self, os):
        r"""
        std::ostream const&
        gdcm::File::Write(std::ostream &os) const

        Write. 
        """
        return _gdcmswig.File_Write(self, os)

    def GetHeader(self, *args):
        r"""
        const
        FileMetaInformation& gdcm::File::GetHeader() const

        Get File Meta Information. 
        """
        return _gdcmswig.File_GetHeader(self, *args)

    def SetHeader(self, fmi):
        r"""
        void
        gdcm::File::SetHeader(const FileMetaInformation &fmi)

        Set File Meta Information. 
        """
        return _gdcmswig.File_SetHeader(self, fmi)

    def GetDataSet(self, *args):
        r"""
        const DataSet&
        gdcm::File::GetDataSet() const

        Get Data Set. 
        """
        return _gdcmswig.File_GetDataSet(self, *args)

    def SetDataSet(self, ds):
        r"""
        void
        gdcm::File::SetDataSet(const DataSet &ds)

        Set Data Set. 
        """
        return _gdcmswig.File_SetDataSet(self, ds)

    def __str__(self):
        return _gdcmswig.File___str__(self)

# Register File in _gdcmswig:
_gdcmswig.File_swigregister(File)
class Bitmap(Object):
    r"""


    Bitmap class.

    A bitmap based image. Used as parent for both IconImage and the main
    Pixel Data Image It does not contains any World Space information
    (IPP, IOP)

    C++ includes: gdcmBitmap.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Bitmap::Bitmap()

        """
        _gdcmswig.Bitmap_swiginit(self, _gdcmswig.new_Bitmap())
    __swig_destroy__ = _gdcmswig.delete_Bitmap

    def Print(self, arg2):
        r"""
        void
        gdcm::Bitmap::Print(std::ostream &) const override 
        """
        return _gdcmswig.Bitmap_Print(self, arg2)

    def AreOverlaysInPixelData(self):
        r"""
        virtual
        bool gdcm::Bitmap::AreOverlaysInPixelData() const 
        """
        return _gdcmswig.Bitmap_AreOverlaysInPixelData(self)

    def UnusedBitsPresentInPixelData(self):
        r"""virtual bool gdcm::Bitmap::UnusedBitsPresentInPixelData() const"""
        return _gdcmswig.Bitmap_UnusedBitsPresentInPixelData(self)

    def GetNumberOfDimensions(self):
        r"""
        unsigned
        int gdcm::Bitmap::GetNumberOfDimensions() const

        Return the number of dimension of the pixel data bytes; for example 2
        for a 2D matrices of values. 
        """
        return _gdcmswig.Bitmap_GetNumberOfDimensions(self)

    def SetNumberOfDimensions(self, dim):
        r"""
        void
        gdcm::Bitmap::SetNumberOfDimensions(unsigned int dim) 
        """
        return _gdcmswig.Bitmap_SetNumberOfDimensions(self, dim)

    def GetPlanarConfiguration(self):
        r"""
        unsigned
        int gdcm::Bitmap::GetPlanarConfiguration() const

        return the planar configuration 
        """
        return _gdcmswig.Bitmap_GetPlanarConfiguration(self)

    def SetPlanarConfiguration(self, pc):
        r"""
        void
        gdcm::Bitmap::SetPlanarConfiguration(unsigned int pc)

        WARNING:  you need to call SetPixelFormat first (before
        SetPlanarConfiguration) for consistency checking 
        """
        return _gdcmswig.Bitmap_SetPlanarConfiguration(self, pc)

    def GetNeedByteSwap(self):
        r"""
        bool
        gdcm::Bitmap::GetNeedByteSwap() const

        INTERNAL do not use. 
        """
        return _gdcmswig.Bitmap_GetNeedByteSwap(self)

    def SetNeedByteSwap(self, b):
        r"""
        void
        gdcm::Bitmap::SetNeedByteSwap(bool b) 
        """
        return _gdcmswig.Bitmap_SetNeedByteSwap(self, b)

    def SetTransferSyntax(self, ts):
        r"""
        void
        gdcm::Bitmap::SetTransferSyntax(TransferSyntax const &ts)

        Transfer syntax. 
        """
        return _gdcmswig.Bitmap_SetTransferSyntax(self, ts)

    def GetTransferSyntax(self):
        r"""
        const
        TransferSyntax& gdcm::Bitmap::GetTransferSyntax() const 
        """
        return _gdcmswig.Bitmap_GetTransferSyntax(self)

    def IsTransferSyntaxCompatible(self, ts):
        r"""
        bool
        gdcm::Bitmap::IsTransferSyntaxCompatible(TransferSyntax const &ts)
        const 
        """
        return _gdcmswig.Bitmap_IsTransferSyntaxCompatible(self, ts)

    def SetDataElement(self, de):
        r"""
        void
        gdcm::Bitmap::SetDataElement(DataElement const &de) 
        """
        return _gdcmswig.Bitmap_SetDataElement(self, de)

    def GetDataElement(self, *args):
        r"""
        const
        DataElement& gdcm::Bitmap::GetDataElement() const 
        """
        return _gdcmswig.Bitmap_GetDataElement(self, *args)

    def SetLUT(self, lut):
        r"""
        void
        gdcm::Bitmap::SetLUT(LookupTable const &lut)

        Set/Get LUT. 
        """
        return _gdcmswig.Bitmap_SetLUT(self, lut)

    def GetLUT(self, *args):
        r"""
        const LookupTable&
        gdcm::Bitmap::GetLUT() const 
        """
        return _gdcmswig.Bitmap_GetLUT(self, *args)

    def GetDimensions(self):
        r"""
        const unsigned
        int* gdcm::Bitmap::GetDimensions() const

        Return the dimension of the pixel data, first dimension (x), then 2nd
        (y), then 3rd (z)... 
        """
        return _gdcmswig.Bitmap_GetDimensions(self)

    def GetDimension(self, idx):
        r"""
        unsigned int
        gdcm::Bitmap::GetDimension(unsigned int idx) const 
        """
        return _gdcmswig.Bitmap_GetDimension(self, idx)

    def SetColumns(self, col):
        r"""
        void
        gdcm::Bitmap::SetColumns(unsigned int col) 
        """
        return _gdcmswig.Bitmap_SetColumns(self, col)

    def GetColumns(self):
        r"""
        unsigned int
        gdcm::Bitmap::GetColumns() const 
        """
        return _gdcmswig.Bitmap_GetColumns(self)

    def SetRows(self, rows):
        r"""
        void
        gdcm::Bitmap::SetRows(unsigned int rows) 
        """
        return _gdcmswig.Bitmap_SetRows(self, rows)

    def GetRows(self):
        r"""
        unsigned int
        gdcm::Bitmap::GetRows() const 
        """
        return _gdcmswig.Bitmap_GetRows(self)

    def SetDimensions(self, dims):
        r"""
        void
        gdcm::Bitmap::SetDimensions(const unsigned int dims[3]) 
        """
        return _gdcmswig.Bitmap_SetDimensions(self, dims)

    def SetDimension(self, idx, dim):
        r"""
        void
        gdcm::Bitmap::SetDimension(unsigned int idx, unsigned int dim) 
        """
        return _gdcmswig.Bitmap_SetDimension(self, idx, dim)

    def GetPixelFormat(self, *args):
        r"""
        const
        PixelFormat& gdcm::Bitmap::GetPixelFormat() const

        Get/Set PixelFormat. 
        """
        return _gdcmswig.Bitmap_GetPixelFormat(self, *args)

    def SetPixelFormat(self, pf):
        r"""
        void
        gdcm::Bitmap::SetPixelFormat(PixelFormat const &pf) 
        """
        return _gdcmswig.Bitmap_SetPixelFormat(self, pf)

    def GetPhotometricInterpretation(self):
        r"""
        const PhotometricInterpretation&
        gdcm::Bitmap::GetPhotometricInterpretation() const

        return the photometric interpretation 
        """
        return _gdcmswig.Bitmap_GetPhotometricInterpretation(self)

    def SetPhotometricInterpretation(self, pi):
        r"""
        void
        gdcm::Bitmap::SetPhotometricInterpretation(PhotometricInterpretation
        const &pi) 
        """
        return _gdcmswig.Bitmap_SetPhotometricInterpretation(self, pi)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Bitmap::IsEmpty() const 
        """
        return _gdcmswig.Bitmap_IsEmpty(self)

    def Clear(self):
        r"""
        void
        gdcm::Bitmap::Clear() 
        """
        return _gdcmswig.Bitmap_Clear(self)

    def GetBufferLength(self):
        r"""
        unsigned long
        gdcm::Bitmap::GetBufferLength() const

        Return the length of the image after decompression WARNING for palette
        color: It will NOT take into account the Palette Color thus you need
        to multiply this length by 3 if computing the size of equivalent RGB
        image 
        """
        return _gdcmswig.Bitmap_GetBufferLength(self)

    def IsLossy(self):
        r"""
        bool
        gdcm::Bitmap::IsLossy() const

        Return whether or not the image was compressed using a lossy
        compressor or not. 
        """
        return _gdcmswig.Bitmap_IsLossy(self)

    def SetLossyFlag(self, f):
        r"""
        void
        gdcm::Bitmap::SetLossyFlag(bool f)

        Specifically set that the image was compressed using a lossy
        compression mechanism. 
        """
        return _gdcmswig.Bitmap_SetLossyFlag(self, f)

    def __str__(self):
        return _gdcmswig.Bitmap___str__(self)

    def GetBuffer(self):
        r"""
        bool
        gdcm::Bitmap::GetBuffer(char *buffer) const

        Access the raw data. 
        """
        return _gdcmswig.Bitmap_GetBuffer(self)

# Register Bitmap in _gdcmswig:
_gdcmswig.Bitmap_swigregister(Bitmap)
class Pixmap(Bitmap):
    r"""


    Pixmap class.

    A bitmap based image. Used as parent for both IconImage and the main
    Pixel Data Image It does not contains any World Space information
    (IPP, IOP)

    See:   PixmapReader

    C++ includes: gdcmPixmap.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Pixmap::Pixmap()

        """
        _gdcmswig.Pixmap_swiginit(self, _gdcmswig.new_Pixmap())
    __swig_destroy__ = _gdcmswig.delete_Pixmap

    def Print(self, arg2):
        r"""
        void
        gdcm::Pixmap::Print(std::ostream &) const override 
        """
        return _gdcmswig.Pixmap_Print(self, arg2)

    def AreOverlaysInPixelData(self):
        r"""
        bool
        gdcm::Pixmap::AreOverlaysInPixelData() const override

        returns if Overlays are stored in the unused bit of the pixel data: 
        """
        return _gdcmswig.Pixmap_AreOverlaysInPixelData(self)

    def UnusedBitsPresentInPixelData(self):
        r"""
        bool gdcm::Pixmap::UnusedBitsPresentInPixelData() const override

        returns if there are unused bits in the pixel data 
        """
        return _gdcmswig.Pixmap_UnusedBitsPresentInPixelData(self)

    def GetCurve(self, *args):
        r"""
        const Curve&
        gdcm::Pixmap::GetCurve(size_t i=0) const 
        """
        return _gdcmswig.Pixmap_GetCurve(self, *args)

    def GetNumberOfCurves(self):
        r"""
        size_t
        gdcm::Pixmap::GetNumberOfCurves() const 
        """
        return _gdcmswig.Pixmap_GetNumberOfCurves(self)

    def SetNumberOfCurves(self, n):
        r"""
        void
        gdcm::Pixmap::SetNumberOfCurves(size_t n) 
        """
        return _gdcmswig.Pixmap_SetNumberOfCurves(self, n)

    def GetOverlay(self, *args):
        r"""
        const Overlay&
        gdcm::Pixmap::GetOverlay(size_t i=0) const 
        """
        return _gdcmswig.Pixmap_GetOverlay(self, *args)

    def GetNumberOfOverlays(self):
        r"""
        size_t
        gdcm::Pixmap::GetNumberOfOverlays() const 
        """
        return _gdcmswig.Pixmap_GetNumberOfOverlays(self)

    def SetNumberOfOverlays(self, n):
        r"""
        void
        gdcm::Pixmap::SetNumberOfOverlays(size_t n) 
        """
        return _gdcmswig.Pixmap_SetNumberOfOverlays(self, n)

    def RemoveOverlay(self, i):
        r"""
        void
        gdcm::Pixmap::RemoveOverlay(size_t i) 
        """
        return _gdcmswig.Pixmap_RemoveOverlay(self, i)

    def GetIconImage(self, *args):
        r"""
        const IconImage&
        gdcm::Pixmap::GetIconImage() const

        Set/Get Icon Image. 
        """
        return _gdcmswig.Pixmap_GetIconImage(self, *args)

    def SetIconImage(self, ii):
        r"""
        void
        gdcm::Pixmap::SetIconImage(IconImage const &ii) 
        """
        return _gdcmswig.Pixmap_SetIconImage(self, ii)

    def __str__(self):
        return _gdcmswig.Pixmap___str__(self)

# Register Pixmap in _gdcmswig:
_gdcmswig.Pixmap_swigregister(Pixmap)
class Image(Pixmap):
    r"""


    Image.

    This is the container for an Image in the general sense. From this
    container you should be able to request information like: Origin

    Dimension

    PixelFormat ... But also to retrieve the image as a raw buffer (char
    *) Since we have to deal with both RAW data and JPEG stream (which
    internally encode all the above information) this API might seems
    redundant. One way to solve that would be to subclass Image with
    JPEGImage which would from the stream extract the header info and fill
    it to please Image...well except origin for instance

    Basically you can see it as a storage for the Pixel Data element
    (7fe0,0010).

    WARNING:  This class does some heuristics to guess the Spacing but is
    not compatible with DICOM CP-586. In case of doubt use PixmapReader
    instead

    See:   ImageReader PixmapReader

    C++ includes: gdcmImage.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Image::Image()"""
        _gdcmswig.Image_swiginit(self, _gdcmswig.new_Image())
    __swig_destroy__ = _gdcmswig.delete_Image

    def GetSpacing(self, *args):
        r"""
        double
        gdcm::Image::GetSpacing(unsigned int idx) const 
        """
        return _gdcmswig.Image_GetSpacing(self, *args)

    def SetSpacing(self, *args):
        r"""
        void
        gdcm::Image::SetSpacing(unsigned int idx, double spacing) 
        """
        return _gdcmswig.Image_SetSpacing(self, *args)

    def GetOrigin(self, *args):
        r"""
        double
        gdcm::Image::GetOrigin(unsigned int idx) const 
        """
        return _gdcmswig.Image_GetOrigin(self, *args)

    def SetOrigin(self, *args):
        r"""
        void
        gdcm::Image::SetOrigin(unsigned int idx, double ori) 
        """
        return _gdcmswig.Image_SetOrigin(self, *args)

    def GetDirectionCosines(self, *args):
        r"""
        double
        gdcm::Image::GetDirectionCosines(unsigned int idx) const 
        """
        return _gdcmswig.Image_GetDirectionCosines(self, *args)

    def SetDirectionCosines(self, *args):
        r"""
        void
        gdcm::Image::SetDirectionCosines(unsigned int idx, double dircos) 
        """
        return _gdcmswig.Image_SetDirectionCosines(self, *args)

    def Print(self, os):
        r"""
        void
        gdcm::Image::Print(std::ostream &os) const override

        print 
        """
        return _gdcmswig.Image_Print(self, os)

    def SetIntercept(self, intercept):
        r"""
        void
        gdcm::Image::SetIntercept(double intercept)

        intercept 
        """
        return _gdcmswig.Image_SetIntercept(self, intercept)

    def GetIntercept(self):
        r"""
        double
        gdcm::Image::GetIntercept() const 
        """
        return _gdcmswig.Image_GetIntercept(self)

    def SetSlope(self, slope):
        r"""
        void
        gdcm::Image::SetSlope(double slope)

        slope 
        """
        return _gdcmswig.Image_SetSlope(self, slope)

    def GetSlope(self):
        r"""
        double
        gdcm::Image::GetSlope() const 
        """
        return _gdcmswig.Image_GetSlope(self)

    def __str__(self):
        return _gdcmswig.Image___str__(self)

# Register Image in _gdcmswig:
_gdcmswig.Image_swigregister(Image)
class Fragment(DataElement):
    r"""


    Class to represent a Fragment.

    C++ includes: gdcmFragment.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Fragment::Fragment()"""
        _gdcmswig.Fragment_swiginit(self, _gdcmswig.new_Fragment())

    def GetLength(self):
        r"""
        VL
        gdcm::Fragment::GetLength() const 
        """
        return _gdcmswig.Fragment_GetLength(self)

    def ComputeLength(self):
        r"""
        VL
        gdcm::Fragment::ComputeLength() const 
        """
        return _gdcmswig.Fragment_ComputeLength(self)

    def __str__(self):
        return _gdcmswig.Fragment___str__(self)
    __swig_destroy__ = _gdcmswig.delete_Fragment

# Register Fragment in _gdcmswig:
_gdcmswig.Fragment_swigregister(Fragment)
class fragmentVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.fragmentVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.fragmentVector___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.fragmentVector___bool__(self)

    def __len__(self):
        return _gdcmswig.fragmentVector___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.fragmentVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.fragmentVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.fragmentVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.fragmentVector___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.fragmentVector___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.fragmentVector___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.fragmentVector_pop(self)

    def append(self, x):
        return _gdcmswig.fragmentVector_append(self, x)

    def empty(self):
        return _gdcmswig.fragmentVector_empty(self)

    def size(self):
        return _gdcmswig.fragmentVector_size(self)

    def swap(self, v):
        return _gdcmswig.fragmentVector_swap(self, v)

    def begin(self):
        return _gdcmswig.fragmentVector_begin(self)

    def end(self):
        return _gdcmswig.fragmentVector_end(self)

    def rbegin(self):
        return _gdcmswig.fragmentVector_rbegin(self)

    def rend(self):
        return _gdcmswig.fragmentVector_rend(self)

    def clear(self):
        return _gdcmswig.fragmentVector_clear(self)

    def get_allocator(self):
        return _gdcmswig.fragmentVector_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.fragmentVector_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.fragmentVector_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.fragmentVector_swiginit(self, _gdcmswig.new_fragmentVector(*args))

    def push_back(self, x):
        return _gdcmswig.fragmentVector_push_back(self, x)

    def front(self):
        return _gdcmswig.fragmentVector_front(self)

    def back(self):
        return _gdcmswig.fragmentVector_back(self)

    def assign(self, n, x):
        return _gdcmswig.fragmentVector_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.fragmentVector_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.fragmentVector_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.fragmentVector_reserve(self, n)

    def capacity(self):
        return _gdcmswig.fragmentVector_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_fragmentVector

# Register fragmentVector in _gdcmswig:
_gdcmswig.fragmentVector_swigregister(fragmentVector)
class PDBElement(object):
    r"""


    Class to represent a PDB Element.

    See:   PDBHeader

    C++ includes: gdcmPDBElement.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PDBElement::PDBElement()=default"""
        _gdcmswig.PDBElement_swiginit(self, _gdcmswig.new_PDBElement())

    def GetName(self):
        r"""
        const char*
        gdcm::PDBElement::GetName() const

        Set/Get Name. 
        """
        return _gdcmswig.PDBElement_GetName(self)

    def SetName(self, name):
        r"""
        void
        gdcm::PDBElement::SetName(const char *name) 
        """
        return _gdcmswig.PDBElement_SetName(self, name)

    def GetValue(self):
        r"""
        const char*
        gdcm::PDBElement::GetValue() const

        Set/Get Value. 
        """
        return _gdcmswig.PDBElement_GetValue(self)

    def SetValue(self, value):
        r"""
        void
        gdcm::PDBElement::SetValue(const char *value) 
        """
        return _gdcmswig.PDBElement_SetValue(self, value)

    def __eq__(self, de):
        return _gdcmswig.PDBElement___eq__(self, de)

    def __str__(self):
        return _gdcmswig.PDBElement___str__(self)
    __swig_destroy__ = _gdcmswig.delete_PDBElement

# Register PDBElement in _gdcmswig:
_gdcmswig.PDBElement_swigregister(PDBElement)
class PDBHeader(object):
    r"""


    Class for PDBHeader.

    GEMS MR Image have an Attribute (0025,1b,GEMS_SERS_01) which store the
    Acquisition parameter of the MR Image. It is compressed and can
    therefore not be used as is. This class de- encapsulated the Protocol
    Data Block and allow users to query element by name.

    WARNING:  Everything you do with this code is at your own risk, since
    decoding process was not written from specification documents.

    WARNING:  : the API of this class might change.

    WARNING:  : SEDESC is not always pure ASCII it can contains latin1

    See:   CSAHeader

    C++ includes: gdcmPDBHeader.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PDBHeader::PDBHeader()=default"""
        _gdcmswig.PDBHeader_swiginit(self, _gdcmswig.new_PDBHeader())
    __swig_destroy__ = _gdcmswig.delete_PDBHeader

    def LoadFromDataElement(self, de):
        r"""
        bool
        gdcm::PDBHeader::LoadFromDataElement(DataElement const &de)

        Load the PDB Header from a DataElement of a DataSet. 
        """
        return _gdcmswig.PDBHeader_LoadFromDataElement(self, de)

    def Print(self, os):
        r"""
        void
        gdcm::PDBHeader::Print(std::ostream &os) const

        Print. 
        """
        return _gdcmswig.PDBHeader_Print(self, os)

    @staticmethod
    def GetPDBInfoTag():
        return _gdcmswig.PDBHeader_GetPDBInfoTag()

    def GetPDBElementByName(self, name):
        r"""
        const
        PDBElement& gdcm::PDBHeader::GetPDBElementByName(const char *name)

        Lookup in the PDB header if a PDB element match the name 'name':
        WARNING:  Case Sensitive 
        """
        return _gdcmswig.PDBHeader_GetPDBElementByName(self, name)

    def FindPDBElementByName(self, name):
        r"""
        bool
        gdcm::PDBHeader::FindPDBElementByName(const char *name)

        Return true if the PDB element matching name is found or not. 
        """
        return _gdcmswig.PDBHeader_FindPDBElementByName(self, name)

    def __str__(self):
        return _gdcmswig.PDBHeader___str__(self)

# Register PDBHeader in _gdcmswig:
_gdcmswig.PDBHeader_swigregister(PDBHeader)
class MrProtocol(object):
    r"""


    Class for MrProtocol.

    C++ includes: gdcmMrProtocol.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::MrProtocol::MrProtocol()"""
        _gdcmswig.MrProtocol_swiginit(self, _gdcmswig.new_MrProtocol())
    __swig_destroy__ = _gdcmswig.delete_MrProtocol

    def Load(self, bv, str, version):
        r"""
        bool
        gdcm::MrProtocol::Load(const ByteValue *bv, const char *str, int
        version) 
        """
        return _gdcmswig.MrProtocol_Load(self, bv, str, version)

    def Print(self, os):
        r"""
        void
        gdcm::MrProtocol::Print(std::ostream &os) const 
        """
        return _gdcmswig.MrProtocol_Print(self, os)

    def GetVersion(self):
        r"""
        int
        gdcm::MrProtocol::GetVersion() const 
        """
        return _gdcmswig.MrProtocol_GetVersion(self)

    def GetMrProtocolByName(self, name):
        r"""
        const
        char* gdcm::MrProtocol::GetMrProtocolByName(const char *name) const 
        """
        return _gdcmswig.MrProtocol_GetMrProtocolByName(self, name)

    def FindMrProtocolByName(self, name):
        r"""
        bool
        gdcm::MrProtocol::FindMrProtocolByName(const char *name) const 
        """
        return _gdcmswig.MrProtocol_FindMrProtocolByName(self, name)

    def GetSliceArray(self, sa):
        r"""
        bool
        gdcm::MrProtocol::GetSliceArray(MrProtocol::SliceArray &sa) const 
        """
        return _gdcmswig.MrProtocol_GetSliceArray(self, sa)

    def __str__(self):
        return _gdcmswig.MrProtocol___str__(self)

# Register MrProtocol in _gdcmswig:
_gdcmswig.MrProtocol_swigregister(MrProtocol)
class CSAElement(object):
    r"""


    Class to represent a CSA Element.

    See:   CSAHeader

    C++ includes: gdcmCSAElement.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def GetKey(self):
        r"""
        unsigned int
        gdcm::CSAElement::GetKey() const

        Set/Get Key. 
        """
        return _gdcmswig.CSAElement_GetKey(self)

    def SetKey(self, key):
        r"""
        void
        gdcm::CSAElement::SetKey(unsigned int key) 
        """
        return _gdcmswig.CSAElement_SetKey(self, key)

    def GetName(self):
        r"""
        const char*
        gdcm::CSAElement::GetName() const

        Set/Get Name. 
        """
        return _gdcmswig.CSAElement_GetName(self)

    def SetName(self, name):
        r"""
        void
        gdcm::CSAElement::SetName(const char *name) 
        """
        return _gdcmswig.CSAElement_SetName(self, name)

    def GetVM(self):
        r"""
        const VM&
        gdcm::CSAElement::GetVM() const

        Set/Get VM. 
        """
        return _gdcmswig.CSAElement_GetVM(self)

    def SetVM(self, vm):
        r"""
        void
        gdcm::CSAElement::SetVM(const VM &vm) 
        """
        return _gdcmswig.CSAElement_SetVM(self, vm)

    def GetVR(self):
        r"""
        VR const&
        gdcm::CSAElement::GetVR() const

        Set/Get VR. 
        """
        return _gdcmswig.CSAElement_GetVR(self)

    def SetVR(self, vr):
        r"""
        void
        gdcm::CSAElement::SetVR(VR const &vr) 
        """
        return _gdcmswig.CSAElement_SetVR(self, vr)

    def GetSyngoDT(self):
        r"""
        unsigned int
        gdcm::CSAElement::GetSyngoDT() const

        Set/Get SyngoDT. 
        """
        return _gdcmswig.CSAElement_GetSyngoDT(self)

    def SetSyngoDT(self, syngodt):
        r"""
        void
        gdcm::CSAElement::SetSyngoDT(unsigned int syngodt) 
        """
        return _gdcmswig.CSAElement_SetSyngoDT(self, syngodt)

    def GetNoOfItems(self):
        r"""
        unsigned int
        gdcm::CSAElement::GetNoOfItems() const

        Set/Get NoOfItems. 
        """
        return _gdcmswig.CSAElement_GetNoOfItems(self)

    def SetNoOfItems(self, items):
        r"""
        void
        gdcm::CSAElement::SetNoOfItems(unsigned int items) 
        """
        return _gdcmswig.CSAElement_SetNoOfItems(self, items)

    def GetValue(self, *args):
        r"""
        Value const&
        gdcm::CSAElement::GetValue() const

        Set/Get Value (bytes array, SQ of items, SQ of fragments): 
        """
        return _gdcmswig.CSAElement_GetValue(self, *args)

    def SetValue(self, vl):
        r"""
        void
        gdcm::CSAElement::SetValue(Value const &vl) 
        """
        return _gdcmswig.CSAElement_SetValue(self, vl)

    def IsEmpty(self):
        r"""
        bool
        gdcm::CSAElement::IsEmpty() const

        Check if CSA Element is empty. 
        """
        return _gdcmswig.CSAElement_IsEmpty(self)

    def SetByteValue(self, array, length):
        r"""
        void
        gdcm::CSAElement::SetByteValue(const char *array, VL length)

        Set. 
        """
        return _gdcmswig.CSAElement_SetByteValue(self, array, length)

    def GetByteValue(self):
        r"""
        const
        ByteValue* gdcm::CSAElement::GetByteValue() const

        Return the Value of CSAElement as a ByteValue (if possible) WARNING:
        : You need to check for NULL return value 
        """
        return _gdcmswig.CSAElement_GetByteValue(self)

    def __init__(self, *args):
        r"""gdcm::CSAElement::CSAElement(unsigned int kf=0)"""
        _gdcmswig.CSAElement_swiginit(self, _gdcmswig.new_CSAElement(*args))

    def __lt__(self, de):
        return _gdcmswig.CSAElement___lt__(self, de)

    def __eq__(self, de):
        return _gdcmswig.CSAElement___eq__(self, de)

    def __str__(self):
        return _gdcmswig.CSAElement___str__(self)

    def SetByteStringValue(self, array):
        return _gdcmswig.CSAElement_SetByteStringValue(self, array)
    __swig_destroy__ = _gdcmswig.delete_CSAElement

# Register CSAElement in _gdcmswig:
_gdcmswig.CSAElement_swigregister(CSAElement)
class CSAHeader(object):
    r"""


    Class for CSAHeader.

    SIEMENS store private information in tag (0x0029,0x10,"SIEMENS CSA
    HEADER") this class is meant for user wishing to access values stored
    within this private attribute. There are basically two main 'format'
    for this attribute : SV10/NOMAGIC and DATASET_FORMAT SV10 and NOMAGIC
    are from a user prospective identical, see CSAHeader.xml for possible
    name / value stored in this format. DATASET_FORMAT is in fact simply
    just another DICOM dataset (implicit) with -currently unknown- value.
    This can be only be printed for now.

    WARNING:  Everything you do with this code is at your own risk, since
    decoding process was not written from specification documents.

    WARNING:  the API of this class might change. Todo MrEvaProtocol in
    29,1020 contains ^M that would be nice to get rid of on UNIX system...

    See:   PDBHeader  External references: 5.1.3.2.4.1 MEDCOM History
    Information and 5.1.4.3 CSA Non-Image Module
    inhttp://tamsinfo.toshiba.com/docrequest/pdf/E.Soft_v2.0.pdf

    C++ includes: gdcmCSAHeader.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::CSAHeader::CSAHeader()"""
        _gdcmswig.CSAHeader_swiginit(self, _gdcmswig.new_CSAHeader())
    __swig_destroy__ = _gdcmswig.delete_CSAHeader
    UNKNOWN = _gdcmswig.CSAHeader_UNKNOWN
    SV10 = _gdcmswig.CSAHeader_SV10
    NOMAGIC = _gdcmswig.CSAHeader_NOMAGIC
    DATASET_FORMAT = _gdcmswig.CSAHeader_DATASET_FORMAT
    INTERFILE = _gdcmswig.CSAHeader_INTERFILE
    ZEROED_OUT = _gdcmswig.CSAHeader_ZEROED_OUT

    def LoadFromDataElement(self, de):
        r"""
        bool
        gdcm::CSAHeader::LoadFromDataElement(DataElement const &de)

        Decode the CSAHeader from element 'de'. 
        """
        return _gdcmswig.CSAHeader_LoadFromDataElement(self, de)

    def Print(self, os):
        r"""
        void
        gdcm::CSAHeader::Print(std::ostream &os) const

        Print the CSAHeader (use only if Format == SV10 or NOMAGIC) 
        """
        return _gdcmswig.CSAHeader_Print(self, os)

    def GetDataSet(self):
        r"""
        const DataSet&
        gdcm::CSAHeader::GetDataSet() const

        Return the DataSet output (use only if Format == DATASET_FORMAT ) 
        """
        return _gdcmswig.CSAHeader_GetDataSet(self)

    def GetInterfile(self):
        r"""
        const char*
        gdcm::CSAHeader::GetInterfile() const

        Return the string output (use only if Format == Interfile) 
        """
        return _gdcmswig.CSAHeader_GetInterfile(self)

    def GetFormat(self):
        r"""
        CSAHeaderType
        gdcm::CSAHeader::GetFormat() const

        return the format of the CSAHeader SV10 and NOMAGIC are equivalent. 
        """
        return _gdcmswig.CSAHeader_GetFormat(self)

    @staticmethod
    def GetCSAImageHeaderInfoTag():
        return _gdcmswig.CSAHeader_GetCSAImageHeaderInfoTag()

    @staticmethod
    def GetCSASeriesHeaderInfoTag():
        return _gdcmswig.CSAHeader_GetCSASeriesHeaderInfoTag()

    @staticmethod
    def GetCSADataInfo():
        return _gdcmswig.CSAHeader_GetCSADataInfo()

    def GetCSAElementByName(self, name):
        r"""
        const
        CSAElement& gdcm::CSAHeader::GetCSAElementByName(const char *name)

        Return the CSAElement corresponding to name 'name' WARNING:  Case
        Sensitive 
        """
        return _gdcmswig.CSAHeader_GetCSAElementByName(self, name)

    def FindCSAElementByName(self, name):
        r"""
        bool
        gdcm::CSAHeader::FindCSAElementByName(const char *name)

        Return true if the CSA element matching 'name' is found or not
        WARNING:  Case Sensitive 
        """
        return _gdcmswig.CSAHeader_FindCSAElementByName(self, name)

    def GetMrProtocol(self, ds, mrProtocol):
        r"""
        bool
        gdcm::CSAHeader::GetMrProtocol(const DataSet &ds, MrProtocol
        &mrProtocol)

        Retrieve the ASCII portion stored within the
        MrProtocol/MrPhoenixProtocol: 
        """
        return _gdcmswig.CSAHeader_GetMrProtocol(self, ds, mrProtocol)

    def __str__(self):
        return _gdcmswig.CSAHeader___str__(self)

# Register CSAHeader in _gdcmswig:
_gdcmswig.CSAHeader_swigregister(CSAHeader)
class SequenceOfFragments(Value):
    r"""


    Class to represent a Sequence Of Fragments.

    Todo I do not enforce that Sequence of Fragments ends with a SQ end
    del

    C++ includes: gdcmSequenceOfFragments.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def Begin(self, *args):
        r"""ConstIterator gdcm::SequenceOfFragments::Begin() const"""
        return _gdcmswig.SequenceOfFragments_Begin(self, *args)

    def End(self, *args):
        r"""
        ConstIterator
        gdcm::SequenceOfFragments::End() const 
        """
        return _gdcmswig.SequenceOfFragments_End(self, *args)

    def __init__(self):
        r"""
        gdcm::SequenceOfFragments::SequenceOfFragments()

        constructor (UndefinedLength by default) 
        """
        _gdcmswig.SequenceOfFragments_swiginit(self, _gdcmswig.new_SequenceOfFragments())

    def GetLength(self):
        r"""
        VL
        gdcm::SequenceOfFragments::GetLength() const override

        Returns the SQ length, as read from disk. 
        """
        return _gdcmswig.SequenceOfFragments_GetLength(self)

    def SetLength(self, length):
        r"""
        void
        gdcm::SequenceOfFragments::SetLength(VL length) override

        Sets the actual SQ length. 
        """
        return _gdcmswig.SequenceOfFragments_SetLength(self, length)

    def Clear(self):
        r"""
        void
        gdcm::SequenceOfFragments::Clear() override

        Clear. 
        """
        return _gdcmswig.SequenceOfFragments_Clear(self)

    def AddFragment(self, item):
        r"""
        void
        gdcm::SequenceOfFragments::AddFragment(Fragment const &item)

        Appends a Fragment to the already added ones. 
        """
        return _gdcmswig.SequenceOfFragments_AddFragment(self, item)

    def ComputeByteLength(self):
        r"""unsigned long gdcm::SequenceOfFragments::ComputeByteLength() const"""
        return _gdcmswig.SequenceOfFragments_ComputeByteLength(self)

    def ComputeLength(self):
        r"""
        VL
        gdcm::SequenceOfFragments::ComputeLength() const 
        """
        return _gdcmswig.SequenceOfFragments_ComputeLength(self)

    def GetBuffer(self, buffer, length):
        r"""
        bool
        gdcm::SequenceOfFragments::GetBuffer(char *buffer, unsigned long
        length) const 
        """
        return _gdcmswig.SequenceOfFragments_GetBuffer(self, buffer, length)

    def GetFragBuffer(self, fragNb, buffer, length):
        r"""
        bool
        gdcm::SequenceOfFragments::GetFragBuffer(unsigned int fragNb, char
        *buffer, unsigned long &length) const 
        """
        return _gdcmswig.SequenceOfFragments_GetFragBuffer(self, fragNb, buffer, length)

    def GetNumberOfFragments(self):
        r"""SizeType gdcm::SequenceOfFragments::GetNumberOfFragments() const"""
        return _gdcmswig.SequenceOfFragments_GetNumberOfFragments(self)

    def GetFragment(self, num):
        r"""
        const
        Fragment& gdcm::SequenceOfFragments::GetFragment(SizeType num) const

        """
        return _gdcmswig.SequenceOfFragments_GetFragment(self, num)

    def WriteBuffer(self, os):
        r"""
        bool
        gdcm::SequenceOfFragments::WriteBuffer(std::ostream &os) const 
        """
        return _gdcmswig.SequenceOfFragments_WriteBuffer(self, os)

    def GetTable(self, *args):
        r"""
        const
        BasicOffsetTable& gdcm::SequenceOfFragments::GetTable() const 
        """
        return _gdcmswig.SequenceOfFragments_GetTable(self, *args)

    @staticmethod
    def New():
        return _gdcmswig.SequenceOfFragments_New()

    def Print(self, os):
        r"""
        void
        gdcm::SequenceOfFragments::Print(std::ostream &os) const override 
        """
        return _gdcmswig.SequenceOfFragments_Print(self, os)

    def __eq__(self, val):
        return _gdcmswig.SequenceOfFragments___eq__(self, val)

    def __str__(self):
        return _gdcmswig.SequenceOfFragments___str__(self)
    __swig_destroy__ = _gdcmswig.delete_SequenceOfFragments

# Register SequenceOfFragments in _gdcmswig:
_gdcmswig.SequenceOfFragments_swigregister(SequenceOfFragments)
class BasicOffsetTable(Fragment):
    r"""


    Class to represent a BasicOffsetTable.

    C++ includes: gdcmBasicOffsetTable.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::BasicOffsetTable::BasicOffsetTable()"""
        _gdcmswig.BasicOffsetTable_swiginit(self, _gdcmswig.new_BasicOffsetTable())

    def __str__(self):
        return _gdcmswig.BasicOffsetTable___str__(self)
    __swig_destroy__ = _gdcmswig.delete_BasicOffsetTable

# Register BasicOffsetTable in _gdcmswig:
_gdcmswig.BasicOffsetTable_swigregister(BasicOffsetTable)
class FileSet(object):
    r"""


    File-set: A File-set is a collection of DICOM Files (and possibly non-
    DICOM Files) that share a common naming space within which File IDs
    are unique.

    C++ includes: gdcmFileSet.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::FileSet::FileSet()"""
        _gdcmswig.FileSet_swiginit(self, _gdcmswig.new_FileSet())

    def AddFile(self, *args):
        r"""
        void
        gdcm::FileSet::AddFile(File const &)

        Deprecated . Does nothing 
        """
        return _gdcmswig.FileSet_AddFile(self, *args)

    def SetFiles(self, files):
        r"""
        void
        gdcm::FileSet::SetFiles(FilesType const &files) 
        """
        return _gdcmswig.FileSet_SetFiles(self, files)

    def GetFiles(self):
        r"""
        FilesType const&
        gdcm::FileSet::GetFiles() const 
        """
        return _gdcmswig.FileSet_GetFiles(self)

    def __str__(self):
        return _gdcmswig.FileSet___str__(self)
    __swig_destroy__ = _gdcmswig.delete_FileSet

# Register FileSet in _gdcmswig:
_gdcmswig.FileSet_swigregister(FileSet)
class Global(object):
    r"""


    Global.

    Global should be included in any translation unit that will use Dict
    or that implements the singleton pattern. It makes sure that the Dict
    singleton is created before and destroyed after all other singletons
    in GDCM.

    C++ includes: gdcmGlobal.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Global::Global(const Global &_val)=delete"""
        _gdcmswig.Global_swiginit(self, _gdcmswig.new_Global())
    __swig_destroy__ = _gdcmswig.delete_Global

    def GetDicts(self, *args):
        r"""
        Dicts const&
        gdcm::Global::GetDicts() const

        retrieve the default/internal dicts (Part 6) This dict is filled up at
        load time 
        """
        return _gdcmswig.Global_GetDicts(self, *args)

    def GetDefs(self):
        r"""
        Defs const&
        gdcm::Global::GetDefs() const

        retrieve the default/internal (Part 3) You need to explicitly call
        LoadResourcesFiles before 
        """
        return _gdcmswig.Global_GetDefs(self)

    @staticmethod
    def GetInstance():
        return _gdcmswig.Global_GetInstance()

    def LoadResourcesFiles(self):
        r"""
        bool
        gdcm::Global::LoadResourcesFiles()

        Load all internal XML files, resource path need to have been set
        before calling this member function (see Append/Prepend members func)
        WARNING:  not thread safe ! 
        """
        return _gdcmswig.Global_LoadResourcesFiles(self)

    def Append(self, path):
        r"""
        bool
        gdcm::Global::Append(const char *path)

        Append path at the end of the path list WARNING:  not thread safe ! 
        """
        return _gdcmswig.Global_Append(self, path)

    def Prepend(self, path):
        r"""
        bool
        gdcm::Global::Prepend(const char *path)

        Prepend path at the beginning of the path list WARNING:  not thread
        safe ! 
        """
        return _gdcmswig.Global_Prepend(self, path)

    def __str__(self):
        return _gdcmswig.Global___str__(self)

# Register Global in _gdcmswig:
_gdcmswig.Global_swigregister(Global)
class DictEntry(object):
    r"""


    Class to represent an Entry in the Dict.

    Does not really exist within the DICOM definition, just a way to
    minimize storage and have a mapping from gdcm::Tag to the needed
    information bla TODO FIXME: Need a PublicDictEntry...indeed DictEntry
    has a notion of retired which does not exist in PrivateDictEntry...

    See:   gdcm::Dict

    C++ includes: gdcmDictEntry.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::DictEntry::DictEntry(const char *name="", const char
        *keyword="", VR const &vr=VR::INVALID, VM const &vm=VM::VM0, bool
        ret=false) 
        """
        _gdcmswig.DictEntry_swiginit(self, _gdcmswig.new_DictEntry(*args))

    def GetVR(self):
        r"""
        const VR&
        gdcm::DictEntry::GetVR() const

        Set/Get VR. 
        """
        return _gdcmswig.DictEntry_GetVR(self)

    def SetVR(self, vr):
        r"""
        void
        gdcm::DictEntry::SetVR(const VR &vr) 
        """
        return _gdcmswig.DictEntry_SetVR(self, vr)

    def GetVM(self):
        r"""
        const VM&
        gdcm::DictEntry::GetVM() const

        Set/Get VM. 
        """
        return _gdcmswig.DictEntry_GetVM(self)

    def SetVM(self, vm):
        r"""
        void
        gdcm::DictEntry::SetVM(VM const &vm) 
        """
        return _gdcmswig.DictEntry_SetVM(self, vm)

    def GetName(self):
        r"""
        const char*
        gdcm::DictEntry::GetName() const

        Set/Get Name. 
        """
        return _gdcmswig.DictEntry_GetName(self)

    def SetName(self, name):
        r"""
        void
        gdcm::DictEntry::SetName(const char *name) 
        """
        return _gdcmswig.DictEntry_SetName(self, name)

    def GetKeyword(self):
        r"""
        const char*
        gdcm::DictEntry::GetKeyword() const

        same as GetName but without spaces... 
        """
        return _gdcmswig.DictEntry_GetKeyword(self)

    def SetKeyword(self, keyword):
        r"""
        void
        gdcm::DictEntry::SetKeyword(const char *keyword) 
        """
        return _gdcmswig.DictEntry_SetKeyword(self, keyword)

    def GetRetired(self):
        r"""
        bool
        gdcm::DictEntry::GetRetired() const

        Set/Get Retired flag. 
        """
        return _gdcmswig.DictEntry_GetRetired(self)

    def SetRetired(self, retired):
        r"""
        void
        gdcm::DictEntry::SetRetired(bool retired) 
        """
        return _gdcmswig.DictEntry_SetRetired(self, retired)

    def SetGroupXX(self, v):
        r"""
        void
        gdcm::DictEntry::SetGroupXX(bool v)

        Set whether element is shared in multiple groups (Curve/Overlay
        typically) 
        """
        return _gdcmswig.DictEntry_SetGroupXX(self, v)

    def SetElementXX(self, v):
        r"""
        void
        gdcm::DictEntry::SetElementXX(bool v)

        Set whether element is shared in multiple elements (Source Image IDs
        typically) 
        """
        return _gdcmswig.DictEntry_SetElementXX(self, v)

    def IsUnique(self):
        r"""
        bool
        gdcm::DictEntry::IsUnique() const

        Return whether the name of the DataElement can be considered to be
        unique. As of 2008 all elements name were unique (except the
        expclitely 'XX' ones) 
        """
        return _gdcmswig.DictEntry_IsUnique(self)

    def __str__(self):
        return _gdcmswig.DictEntry___str__(self)
    __swig_destroy__ = _gdcmswig.delete_DictEntry

# Register DictEntry in _gdcmswig:
_gdcmswig.DictEntry_swigregister(DictEntry)
cvar = _gdcmswig.cvar
GlobalInstance = cvar.GlobalInstance

class CSAHeaderDictEntry(object):
    r"""


    Class to represent an Entry in the Dict.

    Does not really exist within the DICOM definition, just a way to
    minimize storage and have a mapping from gdcm::Tag to the needed
    information bla TODO FIXME: Need a PublicCSAHeaderDictEntry...indeed
    CSAHeaderDictEntry has a notion of retired which does not exist in
    PrivateCSAHeaderDictEntry...

    See:   gdcm::Dict

    C++ includes: gdcmCSAHeaderDictEntry.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::CSAHeaderDictEntry::CSAHeaderDictEntry(const char *name="", VR
        const &vr=VR::INVALID, VM const &vm=VM::VM0, const char *desc="") 
        """
        _gdcmswig.CSAHeaderDictEntry_swiginit(self, _gdcmswig.new_CSAHeaderDictEntry(*args))

    def GetVR(self):
        r"""
        const VR&
        gdcm::CSAHeaderDictEntry::GetVR() const

        Set/Get VR. 
        """
        return _gdcmswig.CSAHeaderDictEntry_GetVR(self)

    def SetVR(self, vr):
        r"""
        void
        gdcm::CSAHeaderDictEntry::SetVR(const VR &vr) 
        """
        return _gdcmswig.CSAHeaderDictEntry_SetVR(self, vr)

    def GetVM(self):
        r"""
        const VM&
        gdcm::CSAHeaderDictEntry::GetVM() const

        Set/Get VM. 
        """
        return _gdcmswig.CSAHeaderDictEntry_GetVM(self)

    def SetVM(self, vm):
        r"""
        void
        gdcm::CSAHeaderDictEntry::SetVM(VM const &vm) 
        """
        return _gdcmswig.CSAHeaderDictEntry_SetVM(self, vm)

    def GetName(self):
        r"""
        const char*
        gdcm::CSAHeaderDictEntry::GetName() const

        Set/Get Name. 
        """
        return _gdcmswig.CSAHeaderDictEntry_GetName(self)

    def SetName(self, name):
        r"""
        void
        gdcm::CSAHeaderDictEntry::SetName(const char *name) 
        """
        return _gdcmswig.CSAHeaderDictEntry_SetName(self, name)

    def GetDescription(self):
        r"""
        const char* gdcm::CSAHeaderDictEntry::GetDescription() const

        Set/Get Description. 
        """
        return _gdcmswig.CSAHeaderDictEntry_GetDescription(self)

    def SetDescription(self, desc):
        r"""
        void
        gdcm::CSAHeaderDictEntry::SetDescription(const char *desc) 
        """
        return _gdcmswig.CSAHeaderDictEntry_SetDescription(self, desc)

    def __lt__(self, entry):
        return _gdcmswig.CSAHeaderDictEntry___lt__(self, entry)

    def __str__(self):
        return _gdcmswig.CSAHeaderDictEntry___str__(self)
    __swig_destroy__ = _gdcmswig.delete_CSAHeaderDictEntry

# Register CSAHeaderDictEntry in _gdcmswig:
_gdcmswig.CSAHeaderDictEntry_swigregister(CSAHeaderDictEntry)
class DictEntryTagPairType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _gdcmswig.DictEntryTagPairType_swiginit(self, _gdcmswig.new_DictEntryTagPairType(*args))
    first = property(_gdcmswig.DictEntryTagPairType_first_get, _gdcmswig.DictEntryTagPairType_first_set)
    second = property(_gdcmswig.DictEntryTagPairType_second_get, _gdcmswig.DictEntryTagPairType_second_set)
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _gdcmswig.delete_DictEntryTagPairType

# Register DictEntryTagPairType in _gdcmswig:
_gdcmswig.DictEntryTagPairType_swigregister(DictEntryTagPairType)
class Dict(object):
    r"""


    Class to represent a map of DictEntry.

    bla TODO FIXME: For Element == 0x0 need to return Name = Group Length
    ValueRepresentation = UL ValueMultiplicity = 1

    C++ includes: gdcmDict.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Dict::Dict(const Dict
        &_val)=delete 
        """
        _gdcmswig.Dict_swiginit(self, _gdcmswig.new_Dict())

    def Begin(self):
        r"""
        ConstIterator
        gdcm::Dict::Begin() const 
        """
        return _gdcmswig.Dict_Begin(self)

    def End(self):
        r"""
        ConstIterator
        gdcm::Dict::End() const 
        """
        return _gdcmswig.Dict_End(self)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Dict::IsEmpty() const 
        """
        return _gdcmswig.Dict_IsEmpty(self)

    def AddDictEntry(self, tag, de):
        r"""
        void
        gdcm::Dict::AddDictEntry(const Tag &tag, const DictEntry &de) 
        """
        return _gdcmswig.Dict_AddDictEntry(self, tag, de)

    def GetDictEntry(self, tag):
        r"""
        const DictEntry&
        gdcm::Dict::GetDictEntry(const Tag &tag) const 
        """
        return _gdcmswig.Dict_GetDictEntry(self, tag)

    def GetKeywordFromTag(self, tag):
        r"""
        const char*
        gdcm::Dict::GetKeywordFromTag(Tag const &tag) const

        Function to return the Keyword from a Tag. 
        """
        return _gdcmswig.Dict_GetKeywordFromTag(self, tag)

    def GetDictEntryByName(self, name, tag):
        r"""
        const
        DictEntry& gdcm::Dict::GetDictEntryByName(const char *name, Tag &tag)
        const

        Inefficient way of looking up tag by name. Technically DICOM does not
        guarantee uniqueness (and Curve / Overlay are there to prove it). But
        most of the time name is in fact uniq and can be uniquely link to a
        tag 
        """
        return _gdcmswig.Dict_GetDictEntryByName(self, name, tag)

    def __str__(self):
        return _gdcmswig.Dict___str__(self)

    def GetDictEntryByKeyword(self, *args):
        r"""
        const
        DictEntry& gdcm::Dict::GetDictEntryByKeyword(const char *keyword, Tag
        &tag) const

        Lookup DictEntry by keyword. Even if DICOM standard defines keyword as
        being unique. The lookup table is built on Tag. Therefore looking up a
        DictEntry by Keyword is more inefficient than looking up by Tag. 
        """
        return _gdcmswig.Dict_GetDictEntryByKeyword(self, *args)
    __swig_destroy__ = _gdcmswig.delete_Dict

# Register Dict in _gdcmswig:
_gdcmswig.Dict_swigregister(Dict)
class PrivateDict(object):
    r"""


    Private Dict.

    C++ includes: gdcmDict.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PrivateDict::PrivateDict()=default"""
        _gdcmswig.PrivateDict_swiginit(self, _gdcmswig.new_PrivateDict())
    __swig_destroy__ = _gdcmswig.delete_PrivateDict

    def AddDictEntry(self, tag, de):
        r"""
        void
        gdcm::PrivateDict::AddDictEntry(const PrivateTag &tag, const DictEntry
        &de) 
        """
        return _gdcmswig.PrivateDict_AddDictEntry(self, tag, de)

    def RemoveDictEntry(self, tag):
        r"""
        bool
        gdcm::PrivateDict::RemoveDictEntry(const PrivateTag &tag)

        Remove entry 'tag'. Return true on success (element was found and
        remove). return false if element was not found. 
        """
        return _gdcmswig.PrivateDict_RemoveDictEntry(self, tag)

    def FindDictEntry(self, tag):
        r"""
        bool
        gdcm::PrivateDict::FindDictEntry(const PrivateTag &tag) const 
        """
        return _gdcmswig.PrivateDict_FindDictEntry(self, tag)

    def GetDictEntry(self, tag):
        r"""
        const
        DictEntry& gdcm::PrivateDict::GetDictEntry(const PrivateTag &tag)
        const 
        """
        return _gdcmswig.PrivateDict_GetDictEntry(self, tag)

    def PrintXML(self):
        r"""
        void
        gdcm::PrivateDict::PrintXML() const 
        """
        return _gdcmswig.PrivateDict_PrintXML(self)

    def IsEmpty(self):
        r"""
        bool
        gdcm::PrivateDict::IsEmpty() const 
        """
        return _gdcmswig.PrivateDict_IsEmpty(self)

# Register PrivateDict in _gdcmswig:
_gdcmswig.PrivateDict_swigregister(PrivateDict)
class CSAHeaderDictException(object):
    r"""
    C++ includes:
    gdcmCSAHeaderDict.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _gdcmswig.CSAHeaderDictException_swiginit(self, _gdcmswig.new_CSAHeaderDictException())
    __swig_destroy__ = _gdcmswig.delete_CSAHeaderDictException

# Register CSAHeaderDictException in _gdcmswig:
_gdcmswig.CSAHeaderDictException_swigregister(CSAHeaderDictException)
class CSAHeaderDict(object):
    r"""


    Class to represent a map of CSAHeaderDictEntry.

    C++ includes: gdcmCSAHeaderDict.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::CSAHeaderDict::CSAHeaderDict(const CSAHeaderDict &_val)=delete

        """
        _gdcmswig.CSAHeaderDict_swiginit(self, _gdcmswig.new_CSAHeaderDict())

    def Begin(self):
        r"""
        ConstIterator
        gdcm::CSAHeaderDict::Begin() const 
        """
        return _gdcmswig.CSAHeaderDict_Begin(self)

    def End(self):
        r"""
        ConstIterator
        gdcm::CSAHeaderDict::End() const 
        """
        return _gdcmswig.CSAHeaderDict_End(self)

    def IsEmpty(self):
        r"""
        bool
        gdcm::CSAHeaderDict::IsEmpty() const 
        """
        return _gdcmswig.CSAHeaderDict_IsEmpty(self)

    def AddCSAHeaderDictEntry(self, de):
        r"""
        void gdcm::CSAHeaderDict::AddCSAHeaderDictEntry(const
        CSAHeaderDictEntry &de) 
        """
        return _gdcmswig.CSAHeaderDict_AddCSAHeaderDictEntry(self, de)

    def GetCSAHeaderDictEntry(self, name):
        r"""
        const CSAHeaderDictEntry&
        gdcm::CSAHeaderDict::GetCSAHeaderDictEntry(const char *name) const 
        """
        return _gdcmswig.CSAHeaderDict_GetCSAHeaderDictEntry(self, name)
    __swig_destroy__ = _gdcmswig.delete_CSAHeaderDict

# Register CSAHeaderDict in _gdcmswig:
_gdcmswig.CSAHeaderDict_swigregister(CSAHeaderDict)
class Dicts(object):
    r"""


    Class to manipulate the sum of knowledge (all the dict user load)

    bla

    C++ includes: gdcmDicts.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Dicts::Dicts(const
        Dicts &_val)=delete 
        """
        _gdcmswig.Dicts_swiginit(self, _gdcmswig.new_Dicts())
    __swig_destroy__ = _gdcmswig.delete_Dicts

    def GetDictEntry(self, *args):
        r"""
        const DictEntry&
        gdcm::Dicts::GetDictEntry(const Tag &tag, const char *owner=nullptr)
        const

        THREAD SAFE.

        works for both public and private dicts: owner is null for public dict
        WARNING:  owner need to be set to appropriate owner for call to work.
        see 
        """
        return _gdcmswig.Dicts_GetDictEntry(self, *args)

    def GetPublicDict(self):
        r"""
        const Dict&
        gdcm::Dicts::GetPublicDict() const 
        """
        return _gdcmswig.Dicts_GetPublicDict(self)

    def GetPrivateDict(self, *args):
        r"""
        const
        PrivateDict& gdcm::Dicts::GetPrivateDict() const 
        """
        return _gdcmswig.Dicts_GetPrivateDict(self, *args)

    def GetCSAHeaderDict(self):
        r"""
        const
        CSAHeaderDict& gdcm::Dicts::GetCSAHeaderDict() const 
        """
        return _gdcmswig.Dicts_GetCSAHeaderDict(self)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Dicts::IsEmpty() const 
        """
        return _gdcmswig.Dicts_IsEmpty(self)

    def __str__(self):
        return _gdcmswig.Dicts___str__(self)

# Register Dicts in _gdcmswig:
_gdcmswig.Dicts_swigregister(Dicts)
class TagSetType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.TagSetType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.TagSetType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.TagSetType___bool__(self)

    def __len__(self):
        return _gdcmswig.TagSetType___len__(self)

    def append(self, x):
        return _gdcmswig.TagSetType_append(self, x)

    def __contains__(self, x):
        return _gdcmswig.TagSetType___contains__(self, x)

    def __getitem__(self, i):
        return _gdcmswig.TagSetType___getitem__(self, i)

    def add(self, x):
        return _gdcmswig.TagSetType_add(self, x)

    def discard(self, x):
        return _gdcmswig.TagSetType_discard(self, x)

    def __init__(self, *args):
        _gdcmswig.TagSetType_swiginit(self, _gdcmswig.new_TagSetType(*args))

    def empty(self):
        return _gdcmswig.TagSetType_empty(self)

    def size(self):
        return _gdcmswig.TagSetType_size(self)

    def clear(self):
        return _gdcmswig.TagSetType_clear(self)

    def swap(self, v):
        return _gdcmswig.TagSetType_swap(self, v)

    def count(self, x):
        return _gdcmswig.TagSetType_count(self, x)

    def begin(self):
        return _gdcmswig.TagSetType_begin(self)

    def end(self):
        return _gdcmswig.TagSetType_end(self)

    def rbegin(self):
        return _gdcmswig.TagSetType_rbegin(self)

    def rend(self):
        return _gdcmswig.TagSetType_rend(self)

    def erase(self, *args):
        return _gdcmswig.TagSetType_erase(self, *args)

    def find(self, x):
        return _gdcmswig.TagSetType_find(self, x)

    def lower_bound(self, x):
        return _gdcmswig.TagSetType_lower_bound(self, x)

    def upper_bound(self, x):
        return _gdcmswig.TagSetType_upper_bound(self, x)

    def equal_range(self, x):
        return _gdcmswig.TagSetType_equal_range(self, x)

    def insert(self, __x):
        return _gdcmswig.TagSetType_insert(self, __x)
    __swig_destroy__ = _gdcmswig.delete_TagSetType

# Register TagSetType in _gdcmswig:
_gdcmswig.TagSetType_swigregister(TagSetType)
class Reader(object):
    r"""


    Reader ala DOM (Document Object Model)

    This class is a non-validating reader, it will only performs well-
    formedness check only, and to some extent catch known error (non well-
    formed document).

    Detailed description here

    A DataSet DOES NOT contains group 0x0002 (see FileMetaInformation)

    This is really a DataSet reader. This will not make sure the dataset
    conform to any IOD at all. This is a completely different step. The
    reasoning was that user could control the IOD there lib would handle
    and thus we would not be able to read a DataSet if the IOD was not
    found Instead we separate the reading from the validation.

    From GDCM1.x. Users will realize that one feature is missing from this
    DOM implementation. In GDCM 1.x user used to be able to control the
    size of the Value to be read. By default it was 0xfff. The main author
    of GDCM2 thought this was too dangerous and harmful and therefore this
    feature did not make it into GDCM2

    WARNING:  GDCM will not produce warning for unorder (non-alphabetical
    order).

    See:   Writer FileMetaInformation DataSet File

    C++ includes: gdcmReader.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Reader::Reader()

        """
        _gdcmswig.Reader_swiginit(self, _gdcmswig.new_Reader())
    __swig_destroy__ = _gdcmswig.delete_Reader

    def Read(self):
        r"""
        virtual bool
        gdcm::Reader::Read()

        Main function to read a file. 
        """
        return _gdcmswig.Reader_Read(self)

    def SetFileName(self, filename_native):
        r"""
        void
        gdcm::Reader::SetFileName(const char *filename_native)

        Set the filename to open. This will create a std::ifstream internally
        See SetStream if you are dealing with different std::istream object 
        """
        return _gdcmswig.Reader_SetFileName(self, filename_native)

    def GetFile(self, *args):
        r"""
        const File&
        gdcm::Reader::GetFile() const

        Set/Get File. 
        """
        return _gdcmswig.Reader_GetFile(self, *args)

    def SetFile(self, file):
        r"""
        void
        gdcm::Reader::SetFile(File &file)

        Set/Get File. 
        """
        return _gdcmswig.Reader_SetFile(self, file)

    def ReadUpToTag(self, *args):
        r"""
        bool
        gdcm::Reader::ReadUpToTag(const Tag &tag, std::set< Tag > const
        &skiptags=std::set< Tag >())

        Will read only up to Tag

        Parameters:
        -----------

        tag:  and skipping any tag specified in

        skiptags:  
        """
        return _gdcmswig.Reader_ReadUpToTag(self, *args)

    def ReadSelectedTags(self, tags, readvalues=True):
        r"""
        bool
        gdcm::Reader::ReadSelectedTags(std::set< Tag > const &tags, bool
        readvalues=true)

        Will only read the specified selected tags. 
        """
        return _gdcmswig.Reader_ReadSelectedTags(self, tags, readvalues)

    def ReadSelectedPrivateTags(self, ptags, readvalues=True):
        r"""
        bool
        gdcm::Reader::ReadSelectedPrivateTags(std::set< PrivateTag > const
        &ptags, bool readvalues=true)

        Will only read the specified selected private tags. 
        """
        return _gdcmswig.Reader_ReadSelectedPrivateTags(self, ptags, readvalues)

    def CanRead(self):
        r"""
        bool
        gdcm::Reader::CanRead() const

        Test whether this is a DICOM file WARNING:  need to call either
        SetFileName or SetStream first 
        """
        return _gdcmswig.Reader_CanRead(self)

    def GetStreamCurrentPosition(self):
        r"""
        size_t
        gdcm::Reader::GetStreamCurrentPosition() const

        For wrapped language. return type is compatible with System::FileSize
        return type Use native std::streampos / std::streamoff directly from
        the stream from C++ 
        """
        return _gdcmswig.Reader_GetStreamCurrentPosition(self)

# Register Reader in _gdcmswig:
_gdcmswig.Reader_swigregister(Reader)
class PixmapReader(Reader):
    r"""


    PixmapReader.

    its role is to convert the DICOM DataSet into a Pixmap representation
    By default it is also loading the lookup table and overlay when found
    as they impact the rendering or the image  See PS 3.3-2008, Table
    C.7-11b IMAGE PIXEL MACRO ATTRIBUTES for the list of attribute that
    belong to what gdcm calls a ' Pixmap'

    WARNING:  the API ReadUpToTag and ReadSelectedTag

    See:   Pixmap

    C++ includes: gdcmPixmapReader.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PixmapReader::PixmapReader()"""
        _gdcmswig.PixmapReader_swiginit(self, _gdcmswig.new_PixmapReader())
    __swig_destroy__ = _gdcmswig.delete_PixmapReader

    def Read(self):
        r"""
        bool
        gdcm::PixmapReader::Read() override

        Read the DICOM image. There are two reason for failure: The input
        filename is not DICOM

        The input DICOM file does not contains an Pixmap. 
        """
        return _gdcmswig.PixmapReader_Read(self)

    def GetPixmap(self, *args):
        r"""
        const Pixmap&
        gdcm::PixmapReader::GetPixmap() const

        Return the read image (need to call Read() first) 
        """
        return _gdcmswig.PixmapReader_GetPixmap(self, *args)

# Register PixmapReader in _gdcmswig:
_gdcmswig.PixmapReader_swigregister(PixmapReader)
class ImageReader(PixmapReader):
    r"""


    ImageReader.

    its role is to convert the DICOM DataSet into a Image representation
    Image is different from Pixmap has it has a position and a direction
    in Space.

    See:   Image

    C++ includes: gdcmImageReader.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::ImageReader::ImageReader()"""
        _gdcmswig.ImageReader_swiginit(self, _gdcmswig.new_ImageReader())
    __swig_destroy__ = _gdcmswig.delete_ImageReader

    def Read(self):
        r"""
        bool
        gdcm::ImageReader::Read() override

        Read the DICOM image. There are two reason for failure: The input
        filename is not DICOM

        The input DICOM file does not contains an Image. 
        """
        return _gdcmswig.ImageReader_Read(self)

    def GetImage(self, *args):
        r"""
        const Image&
        gdcm::ImageReader::GetImage() const

        Return the read image. 
        """
        return _gdcmswig.ImageReader_GetImage(self, *args)

# Register ImageReader in _gdcmswig:
_gdcmswig.ImageReader_swigregister(ImageReader)
class Writer(object):
    r"""


    Writer ala DOM (Document Object Model)

    This class is a non-validating writer, it will only performs well-
    formedness check only.

    Detailed description here To avoid GDCM being yet another broken DICOM
    lib we try to be user level and avoid writing illegal stuff (odd
    length, non-zero value for Item start/end length ...) Therefore you
    cannot (well unless you are really smart) write DICOM with even length
    tag. All the checks are consider basics: Correct Meta Information
    Header (see gdcm::FileMetaInformation)

    Zero value for Item Length (0xfffe, 0xe00d/0xe0dd)

    Even length for any elements

    Alphabetical order for elements (guaranteed by design of internals)

    32bits VR will be rewritten with 00

    WARNING:   gdcm::Writer cannot write a DataSet if no SOP Instance UID
    (0008,0018) is found, unless a DICOMDIR is being written out

    See:   Reader DataSet File

    C++ includes: gdcmWriter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Writer::Writer()

        """
        _gdcmswig.Writer_swiginit(self, _gdcmswig.new_Writer())
    __swig_destroy__ = _gdcmswig.delete_Writer

    def Write(self):
        r"""
        virtual bool
        gdcm::Writer::Write()

        Main function to tell the writer to write. 
        """
        return _gdcmswig.Writer_Write(self)

    def SetFileName(self, filename_native):
        r"""
        void
        gdcm::Writer::SetFileName(const char *filename_native)

        Set the filename of DICOM file to write: 
        """
        return _gdcmswig.Writer_SetFileName(self, filename_native)

    def SetStream(self, output_stream):
        r"""
        void
        gdcm::Writer::SetStream(std::ostream &output_stream)

        Set user ostream buffer. 
        """
        return _gdcmswig.Writer_SetStream(self, output_stream)

    def SetFile(self, f):
        r"""
        void
        gdcm::Writer::SetFile(const File &f)

        Set/Get the DICOM file ( DataSet + Header) 
        """
        return _gdcmswig.Writer_SetFile(self, f)

    def GetFile(self):
        r"""
        File&
        gdcm::Writer::GetFile() 
        """
        return _gdcmswig.Writer_GetFile(self)

    def SetCheckFileMetaInformation(self, b):
        r"""
        void gdcm::Writer::SetCheckFileMetaInformation(bool b)

        Undocumented function, do not use (= leave default) 
        """
        return _gdcmswig.Writer_SetCheckFileMetaInformation(self, b)

    def CheckFileMetaInformationOff(self):
        r"""void gdcm::Writer::CheckFileMetaInformationOff()"""
        return _gdcmswig.Writer_CheckFileMetaInformationOff(self)

    def CheckFileMetaInformationOn(self):
        r"""
        void
        gdcm::Writer::CheckFileMetaInformationOn() 
        """
        return _gdcmswig.Writer_CheckFileMetaInformationOn(self)

# Register Writer in _gdcmswig:
_gdcmswig.Writer_swigregister(Writer)
class PixmapWriter(Writer):
    r"""


    PixmapWriter.

    This class will takes two inputs: The DICOM DataSet

    The Image input It will override any info from the Image over the
    DataSet.

    For instance when one read in a lossy compressed image and write out
    as unencapsulated (ie implicitly lossless) then some attribute are
    definitely needed to mark this dataset as Lossy (typically 0028,2114)

    C++ includes: gdcmPixmapWriter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PixmapWriter::PixmapWriter()"""
        _gdcmswig.PixmapWriter_swiginit(self, _gdcmswig.new_PixmapWriter())
    __swig_destroy__ = _gdcmswig.delete_PixmapWriter

    def GetPixmap(self, *args):
        r"""
        const Pixmap&
        gdcm::PixmapWriter::GetPixmap() const 
        """
        return _gdcmswig.PixmapWriter_GetPixmap(self, *args)

    def SetPixmap(self, img):
        r"""
        void
        gdcm::PixmapWriter::SetPixmap(Pixmap const &img) 
        """
        return _gdcmswig.PixmapWriter_SetPixmap(self, img)

    def GetImage(self, *args):
        r"""
        virtual const
        Pixmap& gdcm::PixmapWriter::GetImage() const

        Set/Get Pixmap to be written It will overwrite anything Pixmap infos
        found in DataSet (see parent class to see how to pass dataset) 
        """
        return _gdcmswig.PixmapWriter_GetImage(self, *args)

    def SetImage(self, img):
        r"""
        virtual void
        gdcm::PixmapWriter::SetImage(Pixmap const &img) 
        """
        return _gdcmswig.PixmapWriter_SetImage(self, img)

    def Write(self):
        r"""
        bool
        gdcm::PixmapWriter::Write() override

        Write. 
        """
        return _gdcmswig.PixmapWriter_Write(self)

# Register PixmapWriter in _gdcmswig:
_gdcmswig.PixmapWriter_swigregister(PixmapWriter)
class ImageWriter(PixmapWriter):
    r"""


    ImageWriter.

    This is an extended version of the PixmapWriter. Pay attention that:
    It will populate missing attribute for Secondary Capture Image Storage
    instances,

    It may also change an input MR Image Storage instance into a pseudo
    Enhanced MR Image Storage instance whenever Modality LUT is required.

    Some DataElement related to gdcm::Image may be slightly altered.

    C++ includes: gdcmImageWriter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::ImageWriter::ImageWriter()"""
        _gdcmswig.ImageWriter_swiginit(self, _gdcmswig.new_ImageWriter())
    __swig_destroy__ = _gdcmswig.delete_ImageWriter

    def GetImage(self, *args):
        r"""
        Image&
        gdcm::ImageWriter::GetImage() override 
        """
        return _gdcmswig.ImageWriter_GetImage(self, *args)

    def Write(self):
        r"""
        bool
        gdcm::ImageWriter::Write() override

        Write. 
        """
        return _gdcmswig.ImageWriter_Write(self)

    def ComputeTargetMediaStorage(self):
        r"""
        MediaStorage gdcm::ImageWriter::ComputeTargetMediaStorage()

        internal function used to compute a target MediaStorage the most
        appropriate User may want to call this function ahead of time (before
        Write) 
        """
        return _gdcmswig.ImageWriter_ComputeTargetMediaStorage(self)

# Register ImageWriter in _gdcmswig:
_gdcmswig.ImageWriter_swigregister(ImageWriter)
class PairString(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _gdcmswig.PairString_swiginit(self, _gdcmswig.new_PairString(*args))
    first = property(_gdcmswig.PairString_first_get, _gdcmswig.PairString_first_set)
    second = property(_gdcmswig.PairString_second_get, _gdcmswig.PairString_second_set)
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _gdcmswig.delete_PairString

# Register PairString in _gdcmswig:
_gdcmswig.PairString_swigregister(PairString)
class StringFilter(object):
    r"""


    StringFilter.

    StringFilter is the class that make gdcm2.x looks more like gdcm1 and
    transform the binary blob contained in a DataElement into a string,
    typically this is a nice feature to have for wrapped language

    C++ includes: gdcmStringFilter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::StringFilter::StringFilter()"""
        _gdcmswig.StringFilter_swiginit(self, _gdcmswig.new_StringFilter())
    __swig_destroy__ = _gdcmswig.delete_StringFilter

    def UseDictAlways(self, arg2):
        r"""
        void
        gdcm::StringFilter::UseDictAlways(bool) 
        """
        return _gdcmswig.StringFilter_UseDictAlways(self, arg2)

    def SetDicts(self, dicts):
        r"""
        void
        gdcm::StringFilter::SetDicts(const Dicts &dicts)

        Allow user to pass in there own dicts. 
        """
        return _gdcmswig.StringFilter_SetDicts(self, dicts)

    def ToString(self, *args):
        r"""
        std::string
        gdcm::StringFilter::ToString(const Tag &t) const

        Directly from a Tag: 
        """
        return _gdcmswig.StringFilter_ToString(self, *args)

    def ToStringPair(self, *args):
        r"""
        std::pair<std::string, std::string>
        gdcm::StringFilter::ToStringPair(const Tag &t) const

        Directly from a Tag: 
        """
        return _gdcmswig.StringFilter_ToStringPair(self, *args)

    def FromString(self, t, value, len):
        r"""
        std::string
        gdcm::StringFilter::FromString(const Tag &t, const char *value, size_t
        len)

        Convert to string the char array defined by the pair (value,len) 
        """
        return _gdcmswig.StringFilter_FromString(self, t, value, len)

    def SetFile(self, f):
        r"""
        void
        gdcm::StringFilter::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.StringFilter_SetFile(self, f)

    def GetFile(self, *args):
        r"""
        const File&
        gdcm::StringFilter::GetFile() const 
        """
        return _gdcmswig.StringFilter_GetFile(self, *args)

    def ExecuteQuery(self, query, value):
        r"""
        bool
        gdcm::StringFilter::ExecuteQuery(std::string const &query, std::string
        &value) const

        Execute the XPATH query to find a value (as string) return false when
        attribute is not found (or an error in the XPATH query) You need to
        make sure that your XPATH query is syntactically correct 
        """
        return _gdcmswig.StringFilter_ExecuteQuery(self, query, value)

# Register StringFilter in _gdcmswig:
_gdcmswig.StringFilter_swigregister(StringFilter)
class UIDGenerator(object):
    r"""


    Class for generating unique UID.

    bla Usage: When constructing a Series or Study UID, user has to keep
    around the UID, otherwise the UID Generator will simply forget the
    value and create a new UID.

    C++ includes: gdcmUIDGenerator.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::UIDGenerator::UIDGenerator()

        By default the root of a UID is a GDCM Root... 
        """
        _gdcmswig.UIDGenerator_swiginit(self, _gdcmswig.new_UIDGenerator())

    @staticmethod
    def SetRoot(root):
        return _gdcmswig.UIDGenerator_SetRoot(root)

    @staticmethod
    def GetRoot():
        return _gdcmswig.UIDGenerator_GetRoot()

    def Generate(self):
        r"""
        const char*
        gdcm::UIDGenerator::Generate()

        Internally uses a std::string, so two calls have the same pointer !
        save into a std::string In summary do not write code like that: const
        char *uid1 = uid.Generate(); const char *uid2 = uid.Generate(); since
        uid1 == uid2 
        """
        return _gdcmswig.UIDGenerator_Generate(self)

    @staticmethod
    def IsValid(uid):
        return _gdcmswig.UIDGenerator_IsValid(uid)

    @staticmethod
    def GetGDCMUID():
        return _gdcmswig.UIDGenerator_GetGDCMUID()
    __swig_destroy__ = _gdcmswig.delete_UIDGenerator

# Register UIDGenerator in _gdcmswig:
_gdcmswig.UIDGenerator_swigregister(UIDGenerator)
class UUIDGenerator(object):
    r"""


    Class for generating unique UUID.

    generate DCE 1.1 uid

    C++ includes: gdcmUUIDGenerator.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def Generate(self):
        r"""
        const char*
        gdcm::UUIDGenerator::Generate()

        Return the generated uuid NOT THREAD SAFE 
        """
        return _gdcmswig.UUIDGenerator_Generate(self)

    @staticmethod
    def IsValid(uid):
        return _gdcmswig.UUIDGenerator_IsValid(uid)

    def __init__(self):
        _gdcmswig.UUIDGenerator_swiginit(self, _gdcmswig.new_UUIDGenerator())
    __swig_destroy__ = _gdcmswig.delete_UUIDGenerator

# Register UUIDGenerator in _gdcmswig:
_gdcmswig.UUIDGenerator_swigregister(UUIDGenerator)
class ValuesType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.ValuesType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.ValuesType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.ValuesType___bool__(self)

    def __len__(self):
        return _gdcmswig.ValuesType___len__(self)

    def append(self, x):
        return _gdcmswig.ValuesType_append(self, x)

    def __contains__(self, x):
        return _gdcmswig.ValuesType___contains__(self, x)

    def __getitem__(self, i):
        return _gdcmswig.ValuesType___getitem__(self, i)

    def add(self, x):
        return _gdcmswig.ValuesType_add(self, x)

    def discard(self, x):
        return _gdcmswig.ValuesType_discard(self, x)

    def __init__(self, *args):
        _gdcmswig.ValuesType_swiginit(self, _gdcmswig.new_ValuesType(*args))

    def empty(self):
        return _gdcmswig.ValuesType_empty(self)

    def size(self):
        return _gdcmswig.ValuesType_size(self)

    def clear(self):
        return _gdcmswig.ValuesType_clear(self)

    def swap(self, v):
        return _gdcmswig.ValuesType_swap(self, v)

    def count(self, x):
        return _gdcmswig.ValuesType_count(self, x)

    def begin(self):
        return _gdcmswig.ValuesType_begin(self)

    def end(self):
        return _gdcmswig.ValuesType_end(self)

    def rbegin(self):
        return _gdcmswig.ValuesType_rbegin(self)

    def rend(self):
        return _gdcmswig.ValuesType_rend(self)

    def erase(self, *args):
        return _gdcmswig.ValuesType_erase(self, *args)

    def find(self, x):
        return _gdcmswig.ValuesType_find(self, x)

    def lower_bound(self, x):
        return _gdcmswig.ValuesType_lower_bound(self, x)

    def upper_bound(self, x):
        return _gdcmswig.ValuesType_upper_bound(self, x)

    def equal_range(self, x):
        return _gdcmswig.ValuesType_equal_range(self, x)

    def insert(self, __x):
        return _gdcmswig.ValuesType_insert(self, __x)
    __swig_destroy__ = _gdcmswig.delete_ValuesType

# Register ValuesType in _gdcmswig:
_gdcmswig.ValuesType_swigregister(ValuesType)
class Subject(Object):
    r"""


    Subject.

    See:   Command Event

    C++ includes: gdcmSubject.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Subject::Subject()"""
        _gdcmswig.Subject_swiginit(self, _gdcmswig.new_Subject())
    __swig_destroy__ = _gdcmswig.delete_Subject

    def AddObserver(self, *args):
        r"""
        unsigned long
        gdcm::Subject::AddObserver(const Event &event, Command *) const 
        """
        return _gdcmswig.Subject_AddObserver(self, *args)

    def GetCommand(self, tag):
        r"""
        Command*
        gdcm::Subject::GetCommand(unsigned long tag)

        Get the command associated with the given tag. NOTE: This returns a
        pointer to a Command, but it is safe to assign this to a
        Command::Pointer. Since Command inherits from LightObject, at this
        point in the code, only a pointer or a reference to the Command can be
        used. 
        """
        return _gdcmswig.Subject_GetCommand(self, tag)

    def InvokeEvent(self, *args):
        r"""
        void
        gdcm::Subject::InvokeEvent(const Event &) const

        Call Execute on all the Commands observing this event id. The actions
        triggered by this call doesn't modify this object. 
        """
        return _gdcmswig.Subject_InvokeEvent(self, *args)

    def RemoveObserver(self, tag):
        r"""
        void
        gdcm::Subject::RemoveObserver(unsigned long tag)

        Remove the observer with this tag value. 
        """
        return _gdcmswig.Subject_RemoveObserver(self, tag)

    def RemoveAllObservers(self):
        r"""
        void
        gdcm::Subject::RemoveAllObservers()

        Remove all observers . 
        """
        return _gdcmswig.Subject_RemoveAllObservers(self)

    def HasObserver(self, event):
        r"""
        bool
        gdcm::Subject::HasObserver(const Event &event) const

        Return true if an observer is registered for this event. 
        """
        return _gdcmswig.Subject_HasObserver(self, event)

# Register Subject in _gdcmswig:
_gdcmswig.Subject_swigregister(Subject)
class Command(Subject):
    r"""


    Command superclass for callback/observer methods.

    See:   Subject

    C++ includes: gdcmCommand.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Execute(self, *args):
        r"""
        virtual void
        gdcm::Command::Execute(Subject *caller, const Event &event)=0

        Abstract method that defines the action to be taken by the command. 
        """
        return _gdcmswig.Command_Execute(self, *args)

# Register Command in _gdcmswig:
_gdcmswig.Command_swigregister(Command)
class SmartPtrScan(object):
    r"""


    Class for Smart Pointer.

    Will only work for subclass of gdcm::Object See tr1/shared_ptr for a
    more general approach (not invasive) #include <tr1/memory> {
    shared_ptr<Bla> b(new Bla); } Class partly based on post by Bill
    Hubauer:http://groups.google.com/group/comp.lang.c++/msg/173ddc38a827a930

    See:  http://www.davethehat.com/articles/smartp.htm  and
    itk::SmartPointer

    C++ includes: gdcmSmartPointer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::SmartPointer< ObjectType >::SmartPointer(ObjectType const &p)"""
        _gdcmswig.SmartPtrScan_swiginit(self, _gdcmswig.new_SmartPtrScan(*args))
    __swig_destroy__ = _gdcmswig.delete_SmartPtrScan

    def __deref__(self):
        return _gdcmswig.SmartPtrScan___deref__(self)

    def __ref__(self):
        return _gdcmswig.SmartPtrScan___ref__(self)

    def GetPointer(self):
        r"""
        ObjectType*
        gdcm::SmartPointer< ObjectType >::GetPointer() const

        Explicit function to retrieve the pointer. 
        """
        return _gdcmswig.SmartPtrScan_GetPointer(self)

    def AddTag(self, t):
        r"""
        void
        gdcm::Scanner::AddTag(Tag const &t)

        Add a tag that will need to be read. Those are root level tags. 
        """
        return _gdcmswig.SmartPtrScan_AddTag(self, t)

    def ClearTags(self):
        r"""
        void
        gdcm::Scanner::ClearTags() 
        """
        return _gdcmswig.SmartPtrScan_ClearTags(self)

    def AddPrivateTag(self, t):
        r"""
        void
        gdcm::Scanner::AddPrivateTag(PrivateTag const &t) 
        """
        return _gdcmswig.SmartPtrScan_AddPrivateTag(self, t)

    def AddSkipTag(self, t):
        r"""
        void
        gdcm::Scanner::AddSkipTag(Tag const &t)

        Add a tag that will need to be skipped. Those are root level skip
        tags. 
        """
        return _gdcmswig.SmartPtrScan_AddSkipTag(self, t)

    def ClearSkipTags(self):
        r"""
        void
        gdcm::Scanner::ClearSkipTags() 
        """
        return _gdcmswig.SmartPtrScan_ClearSkipTags(self)

    def Scan(self, filenames):
        r"""
        bool
        gdcm::Scanner::Scan(Directory::FilenamesType const &filenames)

        Start the scan ! 
        """
        return _gdcmswig.SmartPtrScan_Scan(self, filenames)

    def GetFilenames(self):
        r"""Directory::FilenamesType const& gdcm::Scanner::GetFilenames() const"""
        return _gdcmswig.SmartPtrScan_GetFilenames(self)

    def Print(self, os):
        r"""
        void
        gdcm::Scanner::Print(std::ostream &os) const override

        Print result. 
        """
        return _gdcmswig.SmartPtrScan_Print(self, os)

    def PrintTable(self, os):
        r"""
        void
        gdcm::Scanner::PrintTable(std::ostream &os) const 
        """
        return _gdcmswig.SmartPtrScan_PrintTable(self, os)

    def IsKey(self, filename):
        r"""
        bool
        gdcm::Scanner::IsKey(const char *filename) const

        Check if filename is a key in the Mapping table. returns true only of
        file can be found, which means the file was indeed a DICOM file that
        could be processed 
        """
        return _gdcmswig.SmartPtrScan_IsKey(self, filename)

    def GetKeys(self):
        r"""
        Directory::FilenamesType gdcm::Scanner::GetKeys() const

        Return the list of filename that are key in the internal map, which
        means those filename were properly parsed 
        """
        return _gdcmswig.SmartPtrScan_GetKeys(self)

    def GetValues(self, *args):
        r"""
        ValuesType
        gdcm::Scanner::GetValues(Tag const &t) const

        Get all the values found (in lexicographic order) associated with Tag
        't'. 
        """
        return _gdcmswig.SmartPtrScan_GetValues(self, *args)

    def GetOrderedValues(self, t):
        r"""
        Directory::FilenamesType gdcm::Scanner::GetOrderedValues(Tag const &t)
        const

        Get all the values found (in a vector) associated with Tag 't' This
        function is identical to GetValues, but is accessible from the wrapped
        layer (python, C#, java) 
        """
        return _gdcmswig.SmartPtrScan_GetOrderedValues(self, t)

    def Begin(self):
        r"""
        ConstIterator
        gdcm::Scanner::Begin() const 
        """
        return _gdcmswig.SmartPtrScan_Begin(self)

    def End(self):
        r"""
        ConstIterator
        gdcm::Scanner::End() const 
        """
        return _gdcmswig.SmartPtrScan_End(self)

    def GetMappings(self):
        r"""
        MappingType const&
        gdcm::Scanner::GetMappings() const

        Mappings are the mapping from a particular tag to the map, mapping
        filename to value: 
        """
        return _gdcmswig.SmartPtrScan_GetMappings(self)

    def GetMapping(self, filename):
        r"""
        TagToValue const&
        gdcm::Scanner::GetMapping(const char *filename) const

        Get the std::map mapping filenames to value for file 'filename'. 
        """
        return _gdcmswig.SmartPtrScan_GetMapping(self, filename)

    def GetFilenameFromTagToValue(self, t, valueref):
        r"""
        const char* gdcm::Scanner::GetFilenameFromTagToValue(Tag const &t,
        const char *valueref) const

        Will loop over all files and return the first file where value match
        the reference value 'valueref' 
        """
        return _gdcmswig.SmartPtrScan_GetFilenameFromTagToValue(self, t, valueref)

    def GetAllFilenamesFromTagToValue(self, t, valueref):
        r"""
        Directory::FilenamesType
        gdcm::Scanner::GetAllFilenamesFromTagToValue(Tag const &t, const char
        *valueref) const

        Will loop over all files and return a vector of std::strings of
        filenames where value match the reference value 'valueref' 
        """
        return _gdcmswig.SmartPtrScan_GetAllFilenamesFromTagToValue(self, t, valueref)

    def GetMappingFromTagToValue(self, t, value):
        r"""
        TagToValue const& gdcm::Scanner::GetMappingFromTagToValue(Tag const
        &t, const char *value) const

        See GetFilenameFromTagToValue(). This is simply
        GetFilenameFromTagToValue followed. 
        """
        return _gdcmswig.SmartPtrScan_GetMappingFromTagToValue(self, t, value)

    def GetValue(self, filename, t):
        r"""
        const char*
        gdcm::Scanner::GetValue(const char *filename, Tag const &t) const

        Retrieve the value found for tag: t associated with file: filename
        This is meant for a single short call. If multiple calls (multiple
        tags) should be done, prefer the GetMapping function, and then reuse
        the TagToValue hash table. WARNING:   Tag 't' should have been added
        via AddTag() prior to the Scan() call ! 
        """
        return _gdcmswig.SmartPtrScan_GetValue(self, filename, t)

    def New(self):
        return _gdcmswig.SmartPtrScan_New(self)

    def __str__(self):
        return _gdcmswig.SmartPtrScan___str__(self)

    def AddObserver(self, *args):
        r"""
        unsigned long
        gdcm::Subject::AddObserver(const Event &event, Command *) const 
        """
        return _gdcmswig.SmartPtrScan_AddObserver(self, *args)

    def GetCommand(self, tag):
        r"""
        Command*
        gdcm::Subject::GetCommand(unsigned long tag)

        Get the command associated with the given tag. NOTE: This returns a
        pointer to a Command, but it is safe to assign this to a
        Command::Pointer. Since Command inherits from LightObject, at this
        point in the code, only a pointer or a reference to the Command can be
        used. 
        """
        return _gdcmswig.SmartPtrScan_GetCommand(self, tag)

    def InvokeEvent(self, *args):
        r"""
        void
        gdcm::Subject::InvokeEvent(const Event &) const

        Call Execute on all the Commands observing this event id. The actions
        triggered by this call doesn't modify this object. 
        """
        return _gdcmswig.SmartPtrScan_InvokeEvent(self, *args)

    def RemoveObserver(self, tag):
        r"""
        void
        gdcm::Subject::RemoveObserver(unsigned long tag)

        Remove the observer with this tag value. 
        """
        return _gdcmswig.SmartPtrScan_RemoveObserver(self, tag)

    def RemoveAllObservers(self):
        r"""
        void
        gdcm::Subject::RemoveAllObservers()

        Remove all observers . 
        """
        return _gdcmswig.SmartPtrScan_RemoveAllObservers(self)

    def HasObserver(self, event):
        r"""
        bool
        gdcm::Subject::HasObserver(const Event &event) const

        Return true if an observer is registered for this event. 
        """
        return _gdcmswig.SmartPtrScan_HasObserver(self, event)

# Register SmartPtrScan in _gdcmswig:
_gdcmswig.SmartPtrScan_swigregister(SmartPtrScan)
class Scanner(Subject):
    r"""


    Scanner.

    This filter is meant for quickly browsing a FileSet (a set of files on
    disk). Special consideration are taken so as to read the minimum
    amount of information in each file in order to retrieve the user
    specified set of DICOM Attribute.

    This filter is dealing with both VRASCII and VRBINARY element, thanks
    to the help of StringFilter

    WARNING:  IMPORTANT In case of file where tags are not ordered
    (illegal as per DICOM specification), the output will be missing
    information

    implementation details. All values are stored in a std::set of
    std::string. Then the address of the cstring underlying the
    std::string is used in the std::map.  This class implement the
    Subject/Observer pattern trigger the following events:  ProgressEvent

    StartEvent

    EndEvent

    C++ includes: gdcmScanner.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Scanner::Scanner()"""
        _gdcmswig.Scanner_swiginit(self, _gdcmswig.new_Scanner())
    __swig_destroy__ = _gdcmswig.delete_Scanner

    def AddTag(self, t):
        r"""
        void
        gdcm::Scanner::AddTag(Tag const &t)

        Add a tag that will need to be read. Those are root level tags. 
        """
        return _gdcmswig.Scanner_AddTag(self, t)

    def ClearTags(self):
        r"""
        void
        gdcm::Scanner::ClearTags() 
        """
        return _gdcmswig.Scanner_ClearTags(self)

    def AddPrivateTag(self, t):
        r"""
        void
        gdcm::Scanner::AddPrivateTag(PrivateTag const &t) 
        """
        return _gdcmswig.Scanner_AddPrivateTag(self, t)

    def AddSkipTag(self, t):
        r"""
        void
        gdcm::Scanner::AddSkipTag(Tag const &t)

        Add a tag that will need to be skipped. Those are root level skip
        tags. 
        """
        return _gdcmswig.Scanner_AddSkipTag(self, t)

    def ClearSkipTags(self):
        r"""
        void
        gdcm::Scanner::ClearSkipTags() 
        """
        return _gdcmswig.Scanner_ClearSkipTags(self)

    def Scan(self, filenames):
        r"""
        bool
        gdcm::Scanner::Scan(Directory::FilenamesType const &filenames)

        Start the scan ! 
        """
        return _gdcmswig.Scanner_Scan(self, filenames)

    def GetFilenames(self):
        r"""Directory::FilenamesType const& gdcm::Scanner::GetFilenames() const"""
        return _gdcmswig.Scanner_GetFilenames(self)

    def Print(self, os):
        r"""
        void
        gdcm::Scanner::Print(std::ostream &os) const override

        Print result. 
        """
        return _gdcmswig.Scanner_Print(self, os)

    def PrintTable(self, os):
        r"""
        void
        gdcm::Scanner::PrintTable(std::ostream &os) const 
        """
        return _gdcmswig.Scanner_PrintTable(self, os)

    def IsKey(self, filename):
        r"""
        bool
        gdcm::Scanner::IsKey(const char *filename) const

        Check if filename is a key in the Mapping table. returns true only of
        file can be found, which means the file was indeed a DICOM file that
        could be processed 
        """
        return _gdcmswig.Scanner_IsKey(self, filename)

    def GetKeys(self):
        r"""
        Directory::FilenamesType gdcm::Scanner::GetKeys() const

        Return the list of filename that are key in the internal map, which
        means those filename were properly parsed 
        """
        return _gdcmswig.Scanner_GetKeys(self)

    def GetValues(self, *args):
        r"""
        ValuesType
        gdcm::Scanner::GetValues(Tag const &t) const

        Get all the values found (in lexicographic order) associated with Tag
        't'. 
        """
        return _gdcmswig.Scanner_GetValues(self, *args)

    def GetOrderedValues(self, t):
        r"""
        Directory::FilenamesType gdcm::Scanner::GetOrderedValues(Tag const &t)
        const

        Get all the values found (in a vector) associated with Tag 't' This
        function is identical to GetValues, but is accessible from the wrapped
        layer (python, C#, java) 
        """
        return _gdcmswig.Scanner_GetOrderedValues(self, t)

    def Begin(self):
        r"""
        ConstIterator
        gdcm::Scanner::Begin() const 
        """
        return _gdcmswig.Scanner_Begin(self)

    def End(self):
        r"""
        ConstIterator
        gdcm::Scanner::End() const 
        """
        return _gdcmswig.Scanner_End(self)

    def GetMappings(self):
        r"""
        MappingType const&
        gdcm::Scanner::GetMappings() const

        Mappings are the mapping from a particular tag to the map, mapping
        filename to value: 
        """
        return _gdcmswig.Scanner_GetMappings(self)

    def GetMapping(self, filename):
        r"""
        TagToValue const&
        gdcm::Scanner::GetMapping(const char *filename) const

        Get the std::map mapping filenames to value for file 'filename'. 
        """
        return _gdcmswig.Scanner_GetMapping(self, filename)

    def GetFilenameFromTagToValue(self, t, valueref):
        r"""
        const char* gdcm::Scanner::GetFilenameFromTagToValue(Tag const &t,
        const char *valueref) const

        Will loop over all files and return the first file where value match
        the reference value 'valueref' 
        """
        return _gdcmswig.Scanner_GetFilenameFromTagToValue(self, t, valueref)

    def GetAllFilenamesFromTagToValue(self, t, valueref):
        r"""
        Directory::FilenamesType
        gdcm::Scanner::GetAllFilenamesFromTagToValue(Tag const &t, const char
        *valueref) const

        Will loop over all files and return a vector of std::strings of
        filenames where value match the reference value 'valueref' 
        """
        return _gdcmswig.Scanner_GetAllFilenamesFromTagToValue(self, t, valueref)

    def GetMappingFromTagToValue(self, t, value):
        r"""
        TagToValue const& gdcm::Scanner::GetMappingFromTagToValue(Tag const
        &t, const char *value) const

        See GetFilenameFromTagToValue(). This is simply
        GetFilenameFromTagToValue followed. 
        """
        return _gdcmswig.Scanner_GetMappingFromTagToValue(self, t, value)

    def GetValue(self, filename, t):
        r"""
        const char*
        gdcm::Scanner::GetValue(const char *filename, Tag const &t) const

        Retrieve the value found for tag: t associated with file: filename
        This is meant for a single short call. If multiple calls (multiple
        tags) should be done, prefer the GetMapping function, and then reuse
        the TagToValue hash table. WARNING:   Tag 't' should have been added
        via AddTag() prior to the Scan() call ! 
        """
        return _gdcmswig.Scanner_GetValue(self, filename, t)

    @staticmethod
    def New():
        return _gdcmswig.Scanner_New()

    def __str__(self):
        return _gdcmswig.Scanner___str__(self)

# Register Scanner in _gdcmswig:
_gdcmswig.Scanner_swigregister(Scanner)
class PythonTagToValue(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, t2v):
        _gdcmswig.PythonTagToValue_swiginit(self, _gdcmswig.new_PythonTagToValue(t2v))

    def GetCurrent(self):
        return _gdcmswig.PythonTagToValue_GetCurrent(self)

    def GetCurrentTag(self):
        return _gdcmswig.PythonTagToValue_GetCurrentTag(self)

    def GetCurrentValue(self):
        return _gdcmswig.PythonTagToValue_GetCurrentValue(self)

    def Start(self):
        return _gdcmswig.PythonTagToValue_Start(self)

    def IsAtEnd(self):
        return _gdcmswig.PythonTagToValue_IsAtEnd(self)

    def Next(self):
        return _gdcmswig.PythonTagToValue_Next(self)
    __swig_destroy__ = _gdcmswig.delete_PythonTagToValue

# Register PythonTagToValue in _gdcmswig:
_gdcmswig.PythonTagToValue_swigregister(PythonTagToValue)
class SmartPtrStrictScan(object):
    r"""


    Class for Smart Pointer.

    Will only work for subclass of gdcm::Object See tr1/shared_ptr for a
    more general approach (not invasive) #include <tr1/memory> {
    shared_ptr<Bla> b(new Bla); } Class partly based on post by Bill
    Hubauer:http://groups.google.com/group/comp.lang.c++/msg/173ddc38a827a930

    See:  http://www.davethehat.com/articles/smartp.htm  and
    itk::SmartPointer

    C++ includes: gdcmSmartPointer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::SmartPointer< ObjectType >::SmartPointer(ObjectType const &p)"""
        _gdcmswig.SmartPtrStrictScan_swiginit(self, _gdcmswig.new_SmartPtrStrictScan(*args))
    __swig_destroy__ = _gdcmswig.delete_SmartPtrStrictScan

    def __deref__(self):
        return _gdcmswig.SmartPtrStrictScan___deref__(self)

    def __ref__(self):
        return _gdcmswig.SmartPtrStrictScan___ref__(self)

    def GetPointer(self):
        r"""
        ObjectType*
        gdcm::SmartPointer< ObjectType >::GetPointer() const

        Explicit function to retrieve the pointer. 
        """
        return _gdcmswig.SmartPtrStrictScan_GetPointer(self)

    def AddTag(self, t):
        r"""
        void
        gdcm::StrictScanner::AddTag(Tag const &t)

        Add a tag that will need to be read. Those are root level skip tags.

        """
        return _gdcmswig.SmartPtrStrictScan_AddTag(self, t)

    def ClearTags(self):
        r"""
        void
        gdcm::StrictScanner::ClearTags() 
        """
        return _gdcmswig.SmartPtrStrictScan_ClearTags(self)

    def AddPrivateTag(self, t):
        r"""
        void
        gdcm::StrictScanner::AddPrivateTag(PrivateTag const &t) 
        """
        return _gdcmswig.SmartPtrStrictScan_AddPrivateTag(self, t)

    def AddSkipTag(self, t):
        r"""
        void
        gdcm::StrictScanner::AddSkipTag(Tag const &t)

        Add a tag that will need to be skipped. Those are root level skip
        tags. 
        """
        return _gdcmswig.SmartPtrStrictScan_AddSkipTag(self, t)

    def ClearSkipTags(self):
        r"""
        void
        gdcm::StrictScanner::ClearSkipTags() 
        """
        return _gdcmswig.SmartPtrStrictScan_ClearSkipTags(self)

    def Scan(self, filenames):
        r"""
        bool
        gdcm::StrictScanner::Scan(Directory::FilenamesType const &filenames)

        Start the scan ! 
        """
        return _gdcmswig.SmartPtrStrictScan_Scan(self, filenames)

    def GetFilenames(self):
        r"""
        Directory::FilenamesType const& gdcm::StrictScanner::GetFilenames()
        const 
        """
        return _gdcmswig.SmartPtrStrictScan_GetFilenames(self)

    def Print(self, os):
        r"""
        void
        gdcm::StrictScanner::Print(std::ostream &os) const override

        Print result. 
        """
        return _gdcmswig.SmartPtrStrictScan_Print(self, os)

    def PrintTable(self, os):
        r"""
        void
        gdcm::StrictScanner::PrintTable(std::ostream &os) const 
        """
        return _gdcmswig.SmartPtrStrictScan_PrintTable(self, os)

    def IsKey(self, filename):
        r"""
        bool
        gdcm::StrictScanner::IsKey(const char *filename) const

        Check if filename is a key in the Mapping table. returns true only of
        file can be found, which means the file was indeed a DICOM file that
        could be processed 
        """
        return _gdcmswig.SmartPtrStrictScan_IsKey(self, filename)

    def GetKeys(self):
        r"""
        Directory::FilenamesType gdcm::StrictScanner::GetKeys() const

        Return the list of filename that are key in the internal map, which
        means those filename were properly parsed 
        """
        return _gdcmswig.SmartPtrStrictScan_GetKeys(self)

    def GetValues(self, *args):
        r"""
        ValuesType
        gdcm::StrictScanner::GetValues(Tag const &t) const

        Get all the values found (in lexicographic order) associated with Tag
        't'. 
        """
        return _gdcmswig.SmartPtrStrictScan_GetValues(self, *args)

    def GetOrderedValues(self, t):
        r"""
        Directory::FilenamesType gdcm::StrictScanner::GetOrderedValues(Tag
        const &t) const

        Get all the values found (in a vector) associated with Tag 't' This
        function is identical to GetValues, but is accessible from the wrapped
        layer (python, C#, java) 
        """
        return _gdcmswig.SmartPtrStrictScan_GetOrderedValues(self, t)

    def Begin(self):
        r"""
        ConstIterator
        gdcm::StrictScanner::Begin() const 
        """
        return _gdcmswig.SmartPtrStrictScan_Begin(self)

    def End(self):
        r"""
        ConstIterator
        gdcm::StrictScanner::End() const 
        """
        return _gdcmswig.SmartPtrStrictScan_End(self)

    def GetMappings(self):
        r"""
        MappingType
        const& gdcm::StrictScanner::GetMappings() const

        Mappings are the mapping from a particular tag to the map, mapping
        filename to value: 
        """
        return _gdcmswig.SmartPtrStrictScan_GetMappings(self)

    def GetMapping(self, filename):
        r"""
        TagToValue
        const& gdcm::StrictScanner::GetMapping(const char *filename) const

        Get the std::map mapping filenames to value for file 'filename'. 
        """
        return _gdcmswig.SmartPtrStrictScan_GetMapping(self, filename)

    def GetFilenameFromTagToValue(self, t, valueref):
        r"""
        const char* gdcm::StrictScanner::GetFilenameFromTagToValue(Tag const
        &t, const char *valueref) const

        Will loop over all files and return the first file where value match
        the reference value 'valueref' 
        """
        return _gdcmswig.SmartPtrStrictScan_GetFilenameFromTagToValue(self, t, valueref)

    def GetAllFilenamesFromTagToValue(self, t, valueref):
        r"""
        Directory::FilenamesType
        gdcm::StrictScanner::GetAllFilenamesFromTagToValue(Tag const &t, const
        char *valueref) const

        Will loop over all files and return a vector of std::strings of
        filenames where value match the reference value 'valueref' 
        """
        return _gdcmswig.SmartPtrStrictScan_GetAllFilenamesFromTagToValue(self, t, valueref)

    def GetMappingFromTagToValue(self, t, value):
        r"""
        TagToValue const& gdcm::StrictScanner::GetMappingFromTagToValue(Tag
        const &t, const char *value) const

        See GetFilenameFromTagToValue(). This is simply
        GetFilenameFromTagToValue followed. 
        """
        return _gdcmswig.SmartPtrStrictScan_GetMappingFromTagToValue(self, t, value)

    def GetValue(self, filename, t):
        r"""
        const char*
        gdcm::StrictScanner::GetValue(const char *filename, Tag const &t)
        const

        Retrieve the value found for tag: t associated with file: filename
        This is meant for a single short call. If multiple calls (multiple
        tags) should be done, prefer the GetMapping function, and then reuse
        the TagToValue hash table. WARNING:   Tag 't' should have been added
        via AddTag() prior to the Scan() call ! 
        """
        return _gdcmswig.SmartPtrStrictScan_GetValue(self, filename, t)

    def New(self):
        return _gdcmswig.SmartPtrStrictScan_New(self)

    def __str__(self):
        return _gdcmswig.SmartPtrStrictScan___str__(self)

    def AddObserver(self, *args):
        r"""
        unsigned long
        gdcm::Subject::AddObserver(const Event &event, Command *) const 
        """
        return _gdcmswig.SmartPtrStrictScan_AddObserver(self, *args)

    def GetCommand(self, tag):
        r"""
        Command*
        gdcm::Subject::GetCommand(unsigned long tag)

        Get the command associated with the given tag. NOTE: This returns a
        pointer to a Command, but it is safe to assign this to a
        Command::Pointer. Since Command inherits from LightObject, at this
        point in the code, only a pointer or a reference to the Command can be
        used. 
        """
        return _gdcmswig.SmartPtrStrictScan_GetCommand(self, tag)

    def InvokeEvent(self, *args):
        r"""
        void
        gdcm::Subject::InvokeEvent(const Event &) const

        Call Execute on all the Commands observing this event id. The actions
        triggered by this call doesn't modify this object. 
        """
        return _gdcmswig.SmartPtrStrictScan_InvokeEvent(self, *args)

    def RemoveObserver(self, tag):
        r"""
        void
        gdcm::Subject::RemoveObserver(unsigned long tag)

        Remove the observer with this tag value. 
        """
        return _gdcmswig.SmartPtrStrictScan_RemoveObserver(self, tag)

    def RemoveAllObservers(self):
        r"""
        void
        gdcm::Subject::RemoveAllObservers()

        Remove all observers . 
        """
        return _gdcmswig.SmartPtrStrictScan_RemoveAllObservers(self)

    def HasObserver(self, event):
        r"""
        bool
        gdcm::Subject::HasObserver(const Event &event) const

        Return true if an observer is registered for this event. 
        """
        return _gdcmswig.SmartPtrStrictScan_HasObserver(self, event)

# Register SmartPtrStrictScan in _gdcmswig:
_gdcmswig.SmartPtrStrictScan_swigregister(SmartPtrStrictScan)
class StrictScanner(Subject):
    r"""


    StrictScanner.

    This filter is meant for quickly browsing a FileSet (a set of files on
    disk). Special consideration are taken so as to read the minimum
    amount of information in each file in order to retrieve the user
    specified set of DICOM Attribute.

    This filter is dealing with both VRASCII and VRBINARY element, thanks
    to the help of StringFilter

    WARNING:  IMPORTANT In case of file where tags are not ordered
    (illegal as per DICOM specification), the output will be missing
    information

    implementation details. All values are stored in a std::set of
    std::string. Then the address of the cstring underlying the
    std::string is used in the std::map.  This class implement the
    Subject/Observer pattern trigger the following events:  ProgressEvent

    StartEvent

    EndEvent

    C++ includes: gdcmStrictScanner.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::StrictScanner::StrictScanner()"""
        _gdcmswig.StrictScanner_swiginit(self, _gdcmswig.new_StrictScanner())
    __swig_destroy__ = _gdcmswig.delete_StrictScanner

    def AddTag(self, t):
        r"""
        void
        gdcm::StrictScanner::AddTag(Tag const &t)

        Add a tag that will need to be read. Those are root level skip tags.

        """
        return _gdcmswig.StrictScanner_AddTag(self, t)

    def ClearTags(self):
        r"""
        void
        gdcm::StrictScanner::ClearTags() 
        """
        return _gdcmswig.StrictScanner_ClearTags(self)

    def AddPrivateTag(self, t):
        r"""
        void
        gdcm::StrictScanner::AddPrivateTag(PrivateTag const &t) 
        """
        return _gdcmswig.StrictScanner_AddPrivateTag(self, t)

    def AddSkipTag(self, t):
        r"""
        void
        gdcm::StrictScanner::AddSkipTag(Tag const &t)

        Add a tag that will need to be skipped. Those are root level skip
        tags. 
        """
        return _gdcmswig.StrictScanner_AddSkipTag(self, t)

    def ClearSkipTags(self):
        r"""
        void
        gdcm::StrictScanner::ClearSkipTags() 
        """
        return _gdcmswig.StrictScanner_ClearSkipTags(self)

    def Scan(self, filenames):
        r"""
        bool
        gdcm::StrictScanner::Scan(Directory::FilenamesType const &filenames)

        Start the scan ! 
        """
        return _gdcmswig.StrictScanner_Scan(self, filenames)

    def GetFilenames(self):
        r"""
        Directory::FilenamesType const& gdcm::StrictScanner::GetFilenames()
        const 
        """
        return _gdcmswig.StrictScanner_GetFilenames(self)

    def Print(self, os):
        r"""
        void
        gdcm::StrictScanner::Print(std::ostream &os) const override

        Print result. 
        """
        return _gdcmswig.StrictScanner_Print(self, os)

    def PrintTable(self, os):
        r"""
        void
        gdcm::StrictScanner::PrintTable(std::ostream &os) const 
        """
        return _gdcmswig.StrictScanner_PrintTable(self, os)

    def IsKey(self, filename):
        r"""
        bool
        gdcm::StrictScanner::IsKey(const char *filename) const

        Check if filename is a key in the Mapping table. returns true only of
        file can be found, which means the file was indeed a DICOM file that
        could be processed 
        """
        return _gdcmswig.StrictScanner_IsKey(self, filename)

    def GetKeys(self):
        r"""
        Directory::FilenamesType gdcm::StrictScanner::GetKeys() const

        Return the list of filename that are key in the internal map, which
        means those filename were properly parsed 
        """
        return _gdcmswig.StrictScanner_GetKeys(self)

    def GetValues(self, *args):
        r"""
        ValuesType
        gdcm::StrictScanner::GetValues(Tag const &t) const

        Get all the values found (in lexicographic order) associated with Tag
        't'. 
        """
        return _gdcmswig.StrictScanner_GetValues(self, *args)

    def GetOrderedValues(self, t):
        r"""
        Directory::FilenamesType gdcm::StrictScanner::GetOrderedValues(Tag
        const &t) const

        Get all the values found (in a vector) associated with Tag 't' This
        function is identical to GetValues, but is accessible from the wrapped
        layer (python, C#, java) 
        """
        return _gdcmswig.StrictScanner_GetOrderedValues(self, t)

    def Begin(self):
        r"""
        ConstIterator
        gdcm::StrictScanner::Begin() const 
        """
        return _gdcmswig.StrictScanner_Begin(self)

    def End(self):
        r"""
        ConstIterator
        gdcm::StrictScanner::End() const 
        """
        return _gdcmswig.StrictScanner_End(self)

    def GetMappings(self):
        r"""
        MappingType
        const& gdcm::StrictScanner::GetMappings() const

        Mappings are the mapping from a particular tag to the map, mapping
        filename to value: 
        """
        return _gdcmswig.StrictScanner_GetMappings(self)

    def GetMapping(self, filename):
        r"""
        TagToValue
        const& gdcm::StrictScanner::GetMapping(const char *filename) const

        Get the std::map mapping filenames to value for file 'filename'. 
        """
        return _gdcmswig.StrictScanner_GetMapping(self, filename)

    def GetFilenameFromTagToValue(self, t, valueref):
        r"""
        const char* gdcm::StrictScanner::GetFilenameFromTagToValue(Tag const
        &t, const char *valueref) const

        Will loop over all files and return the first file where value match
        the reference value 'valueref' 
        """
        return _gdcmswig.StrictScanner_GetFilenameFromTagToValue(self, t, valueref)

    def GetAllFilenamesFromTagToValue(self, t, valueref):
        r"""
        Directory::FilenamesType
        gdcm::StrictScanner::GetAllFilenamesFromTagToValue(Tag const &t, const
        char *valueref) const

        Will loop over all files and return a vector of std::strings of
        filenames where value match the reference value 'valueref' 
        """
        return _gdcmswig.StrictScanner_GetAllFilenamesFromTagToValue(self, t, valueref)

    def GetMappingFromTagToValue(self, t, value):
        r"""
        TagToValue const& gdcm::StrictScanner::GetMappingFromTagToValue(Tag
        const &t, const char *value) const

        See GetFilenameFromTagToValue(). This is simply
        GetFilenameFromTagToValue followed. 
        """
        return _gdcmswig.StrictScanner_GetMappingFromTagToValue(self, t, value)

    def GetValue(self, filename, t):
        r"""
        const char*
        gdcm::StrictScanner::GetValue(const char *filename, Tag const &t)
        const

        Retrieve the value found for tag: t associated with file: filename
        This is meant for a single short call. If multiple calls (multiple
        tags) should be done, prefer the GetMapping function, and then reuse
        the TagToValue hash table. WARNING:   Tag 't' should have been added
        via AddTag() prior to the Scan() call ! 
        """
        return _gdcmswig.StrictScanner_GetValue(self, filename, t)

    @staticmethod
    def New():
        return _gdcmswig.StrictScanner_New()

    def __str__(self):
        return _gdcmswig.StrictScanner___str__(self)

# Register StrictScanner in _gdcmswig:
_gdcmswig.StrictScanner_swigregister(StrictScanner)
class SmartPtrAno(object):
    r"""


    Class for Smart Pointer.

    Will only work for subclass of gdcm::Object See tr1/shared_ptr for a
    more general approach (not invasive) #include <tr1/memory> {
    shared_ptr<Bla> b(new Bla); } Class partly based on post by Bill
    Hubauer:http://groups.google.com/group/comp.lang.c++/msg/173ddc38a827a930

    See:  http://www.davethehat.com/articles/smartp.htm  and
    itk::SmartPointer

    C++ includes: gdcmSmartPointer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::SmartPointer< ObjectType >::SmartPointer(ObjectType const &p)"""
        _gdcmswig.SmartPtrAno_swiginit(self, _gdcmswig.new_SmartPtrAno(*args))
    __swig_destroy__ = _gdcmswig.delete_SmartPtrAno

    def __deref__(self):
        return _gdcmswig.SmartPtrAno___deref__(self)

    def __ref__(self):
        return _gdcmswig.SmartPtrAno___ref__(self)

    def GetPointer(self):
        r"""
        ObjectType*
        gdcm::SmartPointer< ObjectType >::GetPointer() const

        Explicit function to retrieve the pointer. 
        """
        return _gdcmswig.SmartPtrAno_GetPointer(self)

    def Empty(self, *args):
        r"""
        bool
        gdcm::Anonymizer::Empty(Tag const &t)

        Make Tag t empty (if not found tag will be created) 
        """
        return _gdcmswig.SmartPtrAno_Empty(self, *args)

    def Clear(self, *args):
        r"""
        bool
        gdcm::Anonymizer::Clear(Tag const &t)

        Identical to 'Empty' except no action is done when tag is not present.

        """
        return _gdcmswig.SmartPtrAno_Clear(self, *args)

    def Remove(self, *args):
        r"""
        bool
        gdcm::Anonymizer::Remove(Tag const &t)

        remove a tag (even a SQ can be removed) 
        """
        return _gdcmswig.SmartPtrAno_Remove(self, *args)

    def Replace(self, *args):
        r"""
        bool
        gdcm::Anonymizer::Replace(Tag const &t, const char *value, VL const
        &vl)

        when the value contains \\0, it is a good idea to specify the
        length. This function is required when dealing with VRBINARY tag 
        """
        return _gdcmswig.SmartPtrAno_Replace(self, *args)

    def RemovePrivateTags(self):
        r"""
        bool
        gdcm::Anonymizer::RemovePrivateTags()

        Main function that loop over all elements and remove private tags. 
        """
        return _gdcmswig.SmartPtrAno_RemovePrivateTags(self)

    def RemoveGroupLength(self):
        r"""
        bool
        gdcm::Anonymizer::RemoveGroupLength()

        Main function that loop over all elements and remove group length. 
        """
        return _gdcmswig.SmartPtrAno_RemoveGroupLength(self)

    def RemoveRetired(self):
        r"""
        bool
        gdcm::Anonymizer::RemoveRetired()

        Main function that loop over all elements and remove retired element.

        """
        return _gdcmswig.SmartPtrAno_RemoveRetired(self)

    def SetFile(self, f):
        r"""
        void
        gdcm::Anonymizer::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.SmartPtrAno_SetFile(self, f)

    def GetFile(self):
        r"""
        File&
        gdcm::Anonymizer::GetFile() 
        """
        return _gdcmswig.SmartPtrAno_GetFile(self)

    def BasicApplicationLevelConfidentialityProfile(self, deidentify=True):
        r"""
        bool
        gdcm::Anonymizer::BasicApplicationLevelConfidentialityProfile(bool
        deidentify=true)

        PS 3.15 / E.1.1 De-Identifier An Application may claim conformance to
        the Basic Application Level Confidentiality Profile as a deidentifier
        if it protects all Attributes that might be used by unauthorized
        entities to identify the patient. NOT THREAD SAFE 
        """
        return _gdcmswig.SmartPtrAno_BasicApplicationLevelConfidentialityProfile(self, deidentify)

    def SetCryptographicMessageSyntax(self, cms):
        r"""
        void
        gdcm::Anonymizer::SetCryptographicMessageSyntax(CryptographicMessageSyntax
        *cms)

        Set/Get CMS key that will be used to encrypt the dataset within
        BasicApplicationLevelConfidentialityProfile. 
        """
        return _gdcmswig.SmartPtrAno_SetCryptographicMessageSyntax(self, cms)

    def GetCryptographicMessageSyntax(self):
        r"""
        const CryptographicMessageSyntax*
        gdcm::Anonymizer::GetCryptographicMessageSyntax() const 
        """
        return _gdcmswig.SmartPtrAno_GetCryptographicMessageSyntax(self)

    def New(self):
        return _gdcmswig.SmartPtrAno_New(self)

    def GetBasicApplicationLevelConfidentialityProfileAttributes(self):
        return _gdcmswig.SmartPtrAno_GetBasicApplicationLevelConfidentialityProfileAttributes(self)

    def ClearInternalUIDs(self):
        return _gdcmswig.SmartPtrAno_ClearInternalUIDs(self)

    def AddObserver(self, *args):
        r"""
        unsigned long
        gdcm::Subject::AddObserver(const Event &event, Command *) const 
        """
        return _gdcmswig.SmartPtrAno_AddObserver(self, *args)

    def GetCommand(self, tag):
        r"""
        Command*
        gdcm::Subject::GetCommand(unsigned long tag)

        Get the command associated with the given tag. NOTE: This returns a
        pointer to a Command, but it is safe to assign this to a
        Command::Pointer. Since Command inherits from LightObject, at this
        point in the code, only a pointer or a reference to the Command can be
        used. 
        """
        return _gdcmswig.SmartPtrAno_GetCommand(self, tag)

    def InvokeEvent(self, *args):
        r"""
        void
        gdcm::Subject::InvokeEvent(const Event &) const

        Call Execute on all the Commands observing this event id. The actions
        triggered by this call doesn't modify this object. 
        """
        return _gdcmswig.SmartPtrAno_InvokeEvent(self, *args)

    def RemoveObserver(self, tag):
        r"""
        void
        gdcm::Subject::RemoveObserver(unsigned long tag)

        Remove the observer with this tag value. 
        """
        return _gdcmswig.SmartPtrAno_RemoveObserver(self, tag)

    def RemoveAllObservers(self):
        r"""
        void
        gdcm::Subject::RemoveAllObservers()

        Remove all observers . 
        """
        return _gdcmswig.SmartPtrAno_RemoveAllObservers(self)

    def HasObserver(self, event):
        r"""
        bool
        gdcm::Subject::HasObserver(const Event &event) const

        Return true if an observer is registered for this event. 
        """
        return _gdcmswig.SmartPtrAno_HasObserver(self, event)

    def Print(self, arg2):
        r"""
        virtual void
        gdcm::Object::Print(std::ostream &) const 
        """
        return _gdcmswig.SmartPtrAno_Print(self, arg2)

# Register SmartPtrAno in _gdcmswig:
_gdcmswig.SmartPtrAno_swigregister(SmartPtrAno)
class SmartPtrCleaner(object):
    r"""


    Class for Smart Pointer.

    Will only work for subclass of gdcm::Object See tr1/shared_ptr for a
    more general approach (not invasive) #include <tr1/memory> {
    shared_ptr<Bla> b(new Bla); } Class partly based on post by Bill
    Hubauer:http://groups.google.com/group/comp.lang.c++/msg/173ddc38a827a930

    See:  http://www.davethehat.com/articles/smartp.htm  and
    itk::SmartPointer

    C++ includes: gdcmSmartPointer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::SmartPointer< ObjectType >::SmartPointer(ObjectType const &p)"""
        _gdcmswig.SmartPtrCleaner_swiginit(self, _gdcmswig.new_SmartPtrCleaner(*args))
    __swig_destroy__ = _gdcmswig.delete_SmartPtrCleaner

    def __deref__(self):
        return _gdcmswig.SmartPtrCleaner___deref__(self)

    def __ref__(self):
        return _gdcmswig.SmartPtrCleaner___ref__(self)

    def GetPointer(self):
        r"""
        ObjectType*
        gdcm::SmartPointer< ObjectType >::GetPointer() const

        Explicit function to retrieve the pointer. 
        """
        return _gdcmswig.SmartPtrCleaner_GetPointer(self)

    def Empty(self, *args):
        r"""
        bool
        gdcm::Cleaner::Empty(VR const &vr) 
        """
        return _gdcmswig.SmartPtrCleaner_Empty(self, *args)

    def Remove(self, *args):
        r"""
        bool
        gdcm::Cleaner::Remove(VR const &vr) 
        """
        return _gdcmswig.SmartPtrCleaner_Remove(self, *args)

    def Scrub(self, *args):
        r"""
        bool
        gdcm::Cleaner::Scrub(VR const &vr) 
        """
        return _gdcmswig.SmartPtrCleaner_Scrub(self, *args)

    def ReplaceCodeMeaning(self, ced):
        return _gdcmswig.SmartPtrCleaner_ReplaceCodeMeaning(self, ced)

    def Preserve(self, dpath):
        r"""
        bool
        gdcm::Cleaner::Preserve(DPath const &dpath) 
        """
        return _gdcmswig.SmartPtrCleaner_Preserve(self, dpath)

    def RemoveAllMissingPrivateCreator(self, remove):
        r"""
        void gdcm::Cleaner::RemoveAllMissingPrivateCreator(bool remove)

        Should I remove all private tag for which no private creator is found.
        Default: true 
        """
        return _gdcmswig.SmartPtrCleaner_RemoveAllMissingPrivateCreator(self, remove)

    def RemoveMissingPrivateCreator(self, t):
        r"""
        bool gdcm::Cleaner::RemoveMissingPrivateCreator(Tag const &t)

        Specify a private tag (odd number) without a private creator (root
        level only for now): 
        """
        return _gdcmswig.SmartPtrCleaner_RemoveMissingPrivateCreator(self, t)

    def RemoveAllGroupLength(self, remove):
        r"""
        void
        gdcm::Cleaner::RemoveAllGroupLength(bool remove)

        Should I remove all group length (deprecated). Default: true. 
        """
        return _gdcmswig.SmartPtrCleaner_RemoveAllGroupLength(self, remove)

    def RemoveAllIllegal(self, remove):
        r"""
        void
        gdcm::Cleaner::RemoveAllIllegal(bool remove)

        Should I remove all illegal attribute. Default: true. 
        """
        return _gdcmswig.SmartPtrCleaner_RemoveAllIllegal(self, remove)

    def EmptyWhenScrubFails(self, empty):
        return _gdcmswig.SmartPtrCleaner_EmptyWhenScrubFails(self, empty)

    def Clean(self):
        r"""
        bool
        gdcm::Cleaner::Clean()

        main loop 
        """
        return _gdcmswig.SmartPtrCleaner_Clean(self)

    def SetFile(self, f):
        r"""
        void
        gdcm::Cleaner::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.SmartPtrCleaner_SetFile(self, f)

    def GetFile(self):
        r"""
        File&
        gdcm::Cleaner::GetFile() 
        """
        return _gdcmswig.SmartPtrCleaner_GetFile(self)

    def New(self):
        return _gdcmswig.SmartPtrCleaner_New(self)

    def AddObserver(self, *args):
        r"""
        unsigned long
        gdcm::Subject::AddObserver(const Event &event, Command *) const 
        """
        return _gdcmswig.SmartPtrCleaner_AddObserver(self, *args)

    def GetCommand(self, tag):
        r"""
        Command*
        gdcm::Subject::GetCommand(unsigned long tag)

        Get the command associated with the given tag. NOTE: This returns a
        pointer to a Command, but it is safe to assign this to a
        Command::Pointer. Since Command inherits from LightObject, at this
        point in the code, only a pointer or a reference to the Command can be
        used. 
        """
        return _gdcmswig.SmartPtrCleaner_GetCommand(self, tag)

    def InvokeEvent(self, *args):
        r"""
        void
        gdcm::Subject::InvokeEvent(const Event &) const

        Call Execute on all the Commands observing this event id. The actions
        triggered by this call doesn't modify this object. 
        """
        return _gdcmswig.SmartPtrCleaner_InvokeEvent(self, *args)

    def RemoveObserver(self, tag):
        r"""
        void
        gdcm::Subject::RemoveObserver(unsigned long tag)

        Remove the observer with this tag value. 
        """
        return _gdcmswig.SmartPtrCleaner_RemoveObserver(self, tag)

    def RemoveAllObservers(self):
        r"""
        void
        gdcm::Subject::RemoveAllObservers()

        Remove all observers . 
        """
        return _gdcmswig.SmartPtrCleaner_RemoveAllObservers(self)

    def HasObserver(self, event):
        r"""
        bool
        gdcm::Subject::HasObserver(const Event &event) const

        Return true if an observer is registered for this event. 
        """
        return _gdcmswig.SmartPtrCleaner_HasObserver(self, event)

    def Print(self, arg2):
        r"""
        virtual void
        gdcm::Object::Print(std::ostream &) const 
        """
        return _gdcmswig.SmartPtrCleaner_Print(self, arg2)

# Register SmartPtrCleaner in _gdcmswig:
_gdcmswig.SmartPtrCleaner_swigregister(SmartPtrCleaner)
class Anonymizer(Subject):
    r"""


    Anonymizer.

    This class is a multi purpose anonymizer. It can work in 2 mode: Full
    (irreversible) anonymizer (aka dumb mode)

    reversible de-identifier/re-identifier (aka smart mode). This
    implements the Basic Application Level Confidentiality Profile, DICOM
    PS 3.15-2009

    dumb mode This is a dumb anonymizer implementation. All it allows user
    is simple operation such as:

    Tag based functions: complete removal of DICOM attribute (Remove)

    make a tag empty, ie make it's length 0 (Empty)

    replace with another string-based value (Replace)

    DataSet based functions: Remove all group length attribute from a
    DICOM dataset (Group Length element are deprecated, DICOM 2008)

    Remove all private attributes

    Remove all retired attributes

    All function calls actually execute the user specified request.
    Previous implementation were calling a general Anonymize function but
    traversing a std::set is O(n) operation, while a simple user specified
    request is O(log(n)) operation. So 'm' user interaction is O(m*log(n))
    which is < O(n) complexity.

    smart mode this mode implements the Basic Application Level
    Confidentiality Profile (DICOM PS 3.15-2008) In this case, it is
    extremely important to use the same Anonymizer class when anonymizing
    a FileSet. Once the Anonymizer is destroyed its memory of known
    (already processed) UIDs will be lost. which will make the anonymizer
    behaves incorrectly for attributes such as Series UID Study UID where
    user want some consistency. When attribute is Type 1 / Type 1C, a
    dummy generator will take in the existing value and produce a dummy
    value (a sha1 representation). sha1 algorithm is considered to be
    cryptographically strong (compared to md5sum) so that we meet the
    following two conditions: Produce the same dummy value for the same
    input value

    do not provide an easy way to retrieve the original value from the
    sha1 generated value

    This class implement the Subject/Observer pattern trigger the
    following event:  AnonymizeEvent

    IterationEvent

    StartEvent

    EndEvent

    See:   CryptographicMessageSyntax

    C++ includes: gdcmAnonymizer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Anonymizer::Anonymizer()"""
        _gdcmswig.Anonymizer_swiginit(self, _gdcmswig.new_Anonymizer())
    __swig_destroy__ = _gdcmswig.delete_Anonymizer

    def Empty(self, *args):
        r"""
        bool
        gdcm::Anonymizer::Empty(Tag const &t)

        Make Tag t empty (if not found tag will be created) 
        """
        return _gdcmswig.Anonymizer_Empty(self, *args)

    def Clear(self, *args):
        r"""
        bool
        gdcm::Anonymizer::Clear(Tag const &t)

        Identical to 'Empty' except no action is done when tag is not present.

        """
        return _gdcmswig.Anonymizer_Clear(self, *args)

    def Remove(self, *args):
        r"""
        bool
        gdcm::Anonymizer::Remove(Tag const &t)

        remove a tag (even a SQ can be removed) 
        """
        return _gdcmswig.Anonymizer_Remove(self, *args)

    def Replace(self, *args):
        r"""
        bool
        gdcm::Anonymizer::Replace(Tag const &t, const char *value, VL const
        &vl)

        when the value contains \\0, it is a good idea to specify the
        length. This function is required when dealing with VRBINARY tag 
        """
        return _gdcmswig.Anonymizer_Replace(self, *args)

    def RemovePrivateTags(self):
        r"""
        bool
        gdcm::Anonymizer::RemovePrivateTags()

        Main function that loop over all elements and remove private tags. 
        """
        return _gdcmswig.Anonymizer_RemovePrivateTags(self)

    def RemoveGroupLength(self):
        r"""
        bool
        gdcm::Anonymizer::RemoveGroupLength()

        Main function that loop over all elements and remove group length. 
        """
        return _gdcmswig.Anonymizer_RemoveGroupLength(self)

    def RemoveRetired(self):
        r"""
        bool
        gdcm::Anonymizer::RemoveRetired()

        Main function that loop over all elements and remove retired element.

        """
        return _gdcmswig.Anonymizer_RemoveRetired(self)

    def SetFile(self, f):
        r"""
        void
        gdcm::Anonymizer::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.Anonymizer_SetFile(self, f)

    def GetFile(self):
        r"""
        File&
        gdcm::Anonymizer::GetFile() 
        """
        return _gdcmswig.Anonymizer_GetFile(self)

    def BasicApplicationLevelConfidentialityProfile(self, deidentify=True):
        r"""
        bool
        gdcm::Anonymizer::BasicApplicationLevelConfidentialityProfile(bool
        deidentify=true)

        PS 3.15 / E.1.1 De-Identifier An Application may claim conformance to
        the Basic Application Level Confidentiality Profile as a deidentifier
        if it protects all Attributes that might be used by unauthorized
        entities to identify the patient. NOT THREAD SAFE 
        """
        return _gdcmswig.Anonymizer_BasicApplicationLevelConfidentialityProfile(self, deidentify)

    def SetCryptographicMessageSyntax(self, cms):
        r"""
        void
        gdcm::Anonymizer::SetCryptographicMessageSyntax(CryptographicMessageSyntax
        *cms)

        Set/Get CMS key that will be used to encrypt the dataset within
        BasicApplicationLevelConfidentialityProfile. 
        """
        return _gdcmswig.Anonymizer_SetCryptographicMessageSyntax(self, cms)

    def GetCryptographicMessageSyntax(self):
        r"""
        const CryptographicMessageSyntax*
        gdcm::Anonymizer::GetCryptographicMessageSyntax() const 
        """
        return _gdcmswig.Anonymizer_GetCryptographicMessageSyntax(self)

    @staticmethod
    def New():
        return _gdcmswig.Anonymizer_New()

    @staticmethod
    def GetBasicApplicationLevelConfidentialityProfileAttributes():
        return _gdcmswig.Anonymizer_GetBasicApplicationLevelConfidentialityProfileAttributes()

    @staticmethod
    def ClearInternalUIDs():
        return _gdcmswig.Anonymizer_ClearInternalUIDs()

# Register Anonymizer in _gdcmswig:
_gdcmswig.Anonymizer_swigregister(Anonymizer)
class DPath(object):
    r"""


    class to handle a DICOM path While supp 118 did introduced a notion of
    XPath for XML Native model this convention is too XML-centric. Instead
    prefer DCMTK style
    notationhttps://groups.google.com/g/comp.protocols.dicom/c/IyIH0IOBMPA

    C++ includes: gdcmDPath.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::DPath::DPath()"""
        _gdcmswig.DPath_swiginit(self, _gdcmswig.new_DPath())
    __swig_destroy__ = _gdcmswig.delete_DPath

    def Print(self, arg2):
        r"""
        void
        gdcm::DPath::Print(std::ostream &) const 
        """
        return _gdcmswig.DPath_Print(self, arg2)

    def __lt__(self, rhs):
        return _gdcmswig.DPath___lt__(self, rhs)

    def ConstructFromString(self, path):
        r"""
        bool
        gdcm::DPath::ConstructFromString(const char *path) 
        """
        return _gdcmswig.DPath_ConstructFromString(self, path)

    def Match(self, other):
        r"""
        bool
        gdcm::DPath::Match(DPath const &other) const

        Return whether or not 'other' match the template DPath. 
        """
        return _gdcmswig.DPath_Match(self, other)

    @staticmethod
    def IsValid(path):
        return _gdcmswig.DPath_IsValid(path)

# Register DPath in _gdcmswig:
_gdcmswig.DPath_swigregister(DPath)
class Cleaner(Subject):
    r"""


    Cleaner.

    This class implement the Subject/Observer pattern trigger the
    following event:  AnonymizeEvent

    IterationEvent

    StartEvent

    EndEvent

    C++ includes: gdcmCleaner.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Cleaner::Cleaner()"""
        _gdcmswig.Cleaner_swiginit(self, _gdcmswig.new_Cleaner())
    __swig_destroy__ = _gdcmswig.delete_Cleaner

    def Empty(self, *args):
        r"""
        bool
        gdcm::Cleaner::Empty(VR const &vr) 
        """
        return _gdcmswig.Cleaner_Empty(self, *args)

    def Remove(self, *args):
        r"""
        bool
        gdcm::Cleaner::Remove(VR const &vr) 
        """
        return _gdcmswig.Cleaner_Remove(self, *args)

    def Scrub(self, *args):
        r"""
        bool
        gdcm::Cleaner::Scrub(VR const &vr) 
        """
        return _gdcmswig.Cleaner_Scrub(self, *args)

    def ReplaceCodeMeaning(self, ced):
        return _gdcmswig.Cleaner_ReplaceCodeMeaning(self, ced)

    def Preserve(self, dpath):
        r"""
        bool
        gdcm::Cleaner::Preserve(DPath const &dpath) 
        """
        return _gdcmswig.Cleaner_Preserve(self, dpath)

    def RemoveAllMissingPrivateCreator(self, remove):
        r"""
        void gdcm::Cleaner::RemoveAllMissingPrivateCreator(bool remove)

        Should I remove all private tag for which no private creator is found.
        Default: true 
        """
        return _gdcmswig.Cleaner_RemoveAllMissingPrivateCreator(self, remove)

    def RemoveMissingPrivateCreator(self, t):
        r"""
        bool gdcm::Cleaner::RemoveMissingPrivateCreator(Tag const &t)

        Specify a private tag (odd number) without a private creator (root
        level only for now): 
        """
        return _gdcmswig.Cleaner_RemoveMissingPrivateCreator(self, t)

    def RemoveAllGroupLength(self, remove):
        r"""
        void
        gdcm::Cleaner::RemoveAllGroupLength(bool remove)

        Should I remove all group length (deprecated). Default: true. 
        """
        return _gdcmswig.Cleaner_RemoveAllGroupLength(self, remove)

    def RemoveAllIllegal(self, remove):
        r"""
        void
        gdcm::Cleaner::RemoveAllIllegal(bool remove)

        Should I remove all illegal attribute. Default: true. 
        """
        return _gdcmswig.Cleaner_RemoveAllIllegal(self, remove)

    def EmptyWhenScrubFails(self, empty):
        return _gdcmswig.Cleaner_EmptyWhenScrubFails(self, empty)

    def Clean(self):
        r"""
        bool
        gdcm::Cleaner::Clean()

        main loop 
        """
        return _gdcmswig.Cleaner_Clean(self)

    def SetFile(self, f):
        r"""
        void
        gdcm::Cleaner::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.Cleaner_SetFile(self, f)

    def GetFile(self):
        r"""
        File&
        gdcm::Cleaner::GetFile() 
        """
        return _gdcmswig.Cleaner_GetFile(self)

    @staticmethod
    def New():
        return _gdcmswig.Cleaner_New()

# Register Cleaner in _gdcmswig:
_gdcmswig.Cleaner_swigregister(Cleaner)
class FileAnonymizer(Subject):
    r"""


    FileAnonymizer.

    This Anonymizer is a file-based Anonymizer. It requires a valid DICOM
    file and will use the Value Length to skip over any information.

    It will not load the DICOM dataset taken from SetInputFileName() into
    memory and should consume much less memory than Anonymizer.

    WARNING:  : Each time you call Replace() with a value. This value will
    copied, and stored in memory. The behavior is not ideal for extremely
    large data (larger than memory size). This class is really meant to
    take a large DICOM input file and then only changed some small
    attribute.  caveats: This class will NOT work with unordered
    attributes in a DICOM File,

    This class does neither recompute nor update the Group Length element,

    This class currently does not update the File Meta Information header.

    Only strict inplace Replace operation is supported when input and
    output file are the same.

    C++ includes: gdcmFileAnonymizer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::FileAnonymizer::FileAnonymizer()"""
        _gdcmswig.FileAnonymizer_swiginit(self, _gdcmswig.new_FileAnonymizer())
    __swig_destroy__ = _gdcmswig.delete_FileAnonymizer

    def Empty(self, t):
        r"""
        void
        gdcm::FileAnonymizer::Empty(Tag const &t)

        Make Tag t empty Warning: does not handle SQ element 
        """
        return _gdcmswig.FileAnonymizer_Empty(self, t)

    def Remove(self, t):
        r"""
        void
        gdcm::FileAnonymizer::Remove(Tag const &t)

        remove a tag (even a SQ can be removed) 
        """
        return _gdcmswig.FileAnonymizer_Remove(self, t)

    def Replace(self, *args):
        r"""
        void
        gdcm::FileAnonymizer::Replace(Tag const &t, const char *value_str)

        Replace tag with another value, if tag is not found it will be
        created: WARNING: this function can only execute if tag is a VRASCII
        WARNING: Do not ever try to write a value in a SQ Data Element ! 
        """
        return _gdcmswig.FileAnonymizer_Replace(self, *args)

    def SetInputFileName(self, filename_native):
        r"""
        void
        gdcm::FileAnonymizer::SetInputFileName(const char *filename_native)

        Set input filename. 
        """
        return _gdcmswig.FileAnonymizer_SetInputFileName(self, filename_native)

    def SetOutputFileName(self, filename_native):
        r"""
        void
        gdcm::FileAnonymizer::SetOutputFileName(const char *filename_native)

        Set output filename. 
        """
        return _gdcmswig.FileAnonymizer_SetOutputFileName(self, filename_native)

    def Write(self):
        r"""
        bool
        gdcm::FileAnonymizer::Write()

        Write the output file. 
        """
        return _gdcmswig.FileAnonymizer_Write(self)

# Register FileAnonymizer in _gdcmswig:
_gdcmswig.FileAnonymizer_swigregister(FileAnonymizer)
class SmartPtrFStreamer(object):
    r"""


    Class for Smart Pointer.

    Will only work for subclass of gdcm::Object See tr1/shared_ptr for a
    more general approach (not invasive) #include <tr1/memory> {
    shared_ptr<Bla> b(new Bla); } Class partly based on post by Bill
    Hubauer:http://groups.google.com/group/comp.lang.c++/msg/173ddc38a827a930

    See:  http://www.davethehat.com/articles/smartp.htm  and
    itk::SmartPointer

    C++ includes: gdcmSmartPointer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::SmartPointer< ObjectType >::SmartPointer(ObjectType const &p)"""
        _gdcmswig.SmartPtrFStreamer_swiginit(self, _gdcmswig.new_SmartPtrFStreamer(*args))
    __swig_destroy__ = _gdcmswig.delete_SmartPtrFStreamer

    def __deref__(self):
        return _gdcmswig.SmartPtrFStreamer___deref__(self)

    def __ref__(self):
        return _gdcmswig.SmartPtrFStreamer___ref__(self)

    def GetPointer(self):
        r"""
        ObjectType*
        gdcm::SmartPointer< ObjectType >::GetPointer() const

        Explicit function to retrieve the pointer. 
        """
        return _gdcmswig.SmartPtrFStreamer_GetPointer(self)

    def SetTemplateFileName(self, filename_native):
        r"""
        void
        gdcm::FileStreamer::SetTemplateFileName(const char *filename_native)

        Set input DICOM template filename. 
        """
        return _gdcmswig.SmartPtrFStreamer_SetTemplateFileName(self, filename_native)

    def CheckTemplateFileName(self, check):
        r"""
        void gdcm::FileStreamer::CheckTemplateFileName(bool check)

        Instead of simply blindly copying the input DICOM Template file, GDCM
        will be used to check the input file, and correct any issues
        recognized within the file. Only use if you do not have control over
        the input template file. 
        """
        return _gdcmswig.SmartPtrFStreamer_CheckTemplateFileName(self, check)

    def SetOutputFileName(self, filename_native):
        r"""
        void
        gdcm::FileStreamer::SetOutputFileName(const char *filename_native)

        Set output filename (target file) 
        """
        return _gdcmswig.SmartPtrFStreamer_SetOutputFileName(self, filename_native)

    def CheckDataElement(self, t):
        r"""
        bool
        gdcm::FileStreamer::CheckDataElement(const Tag &t)

        Decide to check the Data Element to be written (default: off) The
        implementation has default strategy for checking validity of
        DataElement. Currently it only support checking for the following
        tags: (7fe0,0010) Pixel Data 
        """
        return _gdcmswig.SmartPtrFStreamer_CheckDataElement(self, t)

    def StartDataElement(self, t):
        r"""
        bool
        gdcm::FileStreamer::StartDataElement(const Tag &t)

        Start Single Data Element Operation This will delete any existing Tag
        t. Need to call it only once. 
        """
        return _gdcmswig.SmartPtrFStreamer_StartDataElement(self, t)

    def AppendToDataElement(self, t, array, len):
        r"""
        bool
        gdcm::FileStreamer::AppendToDataElement(const Tag &t, const char
        *array, size_t len)

        Append to previously started Tag t. 
        """
        return _gdcmswig.SmartPtrFStreamer_AppendToDataElement(self, t, array, len)

    def StopDataElement(self, t):
        r"""
        bool
        gdcm::FileStreamer::StopDataElement(const Tag &t)

        Stop appending to tag t. This will compute the proper attribute
        length. 
        """
        return _gdcmswig.SmartPtrFStreamer_StopDataElement(self, t)

    def ReserveDataElement(self, len):
        r"""
        bool
        gdcm::FileStreamer::ReserveDataElement(size_t len)

        Add a hint on the final size of the dataelement. When optimally
        chosen, this reduce the number of file in-place copying. Should be
        called before StartDataElement 
        """
        return _gdcmswig.SmartPtrFStreamer_ReserveDataElement(self, len)

    def StartGroupDataElement(self, pt, maxsizede=0, startoffset=0):
        r"""
        bool gdcm::FileStreamer::StartGroupDataElement(const PrivateTag &pt,
        size_t maxsizede=0, uint8_t startoffset=0)

        Start Private Group (multiple DataElement) Operation. Each newly added
        DataElement will have a length lower than

        Parameters:
        -----------

        maxsizede:  . When not specified, maxsizede is set to maximum size
        allowed by DICOM (= 2^32). startoffset can be used to specify the very
        first element you want to start with (instead of the first possible).
        Value should be in [0x0, 0xff] This will find the first available
        private creator.

        Bug maxsizede should be a value lower than the actual total size of
        the buffer to be copied 
        """
        return _gdcmswig.SmartPtrFStreamer_StartGroupDataElement(self, pt, maxsizede, startoffset)

    def AppendToGroupDataElement(self, pt, array, len):
        r"""
        bool gdcm::FileStreamer::AppendToGroupDataElement(const PrivateTag
        &pt, const char *array, size_t len)

        Append to previously started private creator. 
        """
        return _gdcmswig.SmartPtrFStreamer_AppendToGroupDataElement(self, pt, array, len)

    def StopGroupDataElement(self, pt):
        r"""
        bool
        gdcm::FileStreamer::StopGroupDataElement(const PrivateTag &pt)

        Stop appending to private creator. 
        """
        return _gdcmswig.SmartPtrFStreamer_StopGroupDataElement(self, pt)

    def ReserveGroupDataElement(self, ndataelement):
        r"""
        bool gdcm::FileStreamer::ReserveGroupDataElement(unsigned short
        ndataelement)

        Optimisation: pre-allocate the number of dataelement within the
        private group (ndataelement <= 256). Should be called before
        StartGroupDataElement 
        """
        return _gdcmswig.SmartPtrFStreamer_ReserveGroupDataElement(self, ndataelement)

    def New(self):
        return _gdcmswig.SmartPtrFStreamer_New(self)

    def AddObserver(self, *args):
        r"""
        unsigned long
        gdcm::Subject::AddObserver(const Event &event, Command *) const 
        """
        return _gdcmswig.SmartPtrFStreamer_AddObserver(self, *args)

    def GetCommand(self, tag):
        r"""
        Command*
        gdcm::Subject::GetCommand(unsigned long tag)

        Get the command associated with the given tag. NOTE: This returns a
        pointer to a Command, but it is safe to assign this to a
        Command::Pointer. Since Command inherits from LightObject, at this
        point in the code, only a pointer or a reference to the Command can be
        used. 
        """
        return _gdcmswig.SmartPtrFStreamer_GetCommand(self, tag)

    def InvokeEvent(self, *args):
        r"""
        void
        gdcm::Subject::InvokeEvent(const Event &) const

        Call Execute on all the Commands observing this event id. The actions
        triggered by this call doesn't modify this object. 
        """
        return _gdcmswig.SmartPtrFStreamer_InvokeEvent(self, *args)

    def RemoveObserver(self, tag):
        r"""
        void
        gdcm::Subject::RemoveObserver(unsigned long tag)

        Remove the observer with this tag value. 
        """
        return _gdcmswig.SmartPtrFStreamer_RemoveObserver(self, tag)

    def RemoveAllObservers(self):
        r"""
        void
        gdcm::Subject::RemoveAllObservers()

        Remove all observers . 
        """
        return _gdcmswig.SmartPtrFStreamer_RemoveAllObservers(self)

    def HasObserver(self, event):
        r"""
        bool
        gdcm::Subject::HasObserver(const Event &event) const

        Return true if an observer is registered for this event. 
        """
        return _gdcmswig.SmartPtrFStreamer_HasObserver(self, event)

    def Print(self, arg2):
        r"""
        virtual void
        gdcm::Object::Print(std::ostream &) const 
        """
        return _gdcmswig.SmartPtrFStreamer_Print(self, arg2)

# Register SmartPtrFStreamer in _gdcmswig:
_gdcmswig.SmartPtrFStreamer_swigregister(SmartPtrFStreamer)
class FileStreamer(Subject):
    r"""


    FileStreamer.

    This class let a user create a massive DICOM DataSet from a template
    DICOM file, by appending chunks of data.

    This class support two mode of operation: Creating a single
    DataElement by appending chunk after chunk of data.

    Creating a set of DataElement within the same group, using a private
    creator for start. New DataElement are added any time the user defined
    maximum size for data element is reached.

    WARNING:  any existing DataElement is removed, pick carefully which
    DataElement to add.

    C++ includes: gdcmFileStreamer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::FileStreamer::FileStreamer()"""
        _gdcmswig.FileStreamer_swiginit(self, _gdcmswig.new_FileStreamer())
    __swig_destroy__ = _gdcmswig.delete_FileStreamer

    def SetTemplateFileName(self, filename_native):
        r"""
        void
        gdcm::FileStreamer::SetTemplateFileName(const char *filename_native)

        Set input DICOM template filename. 
        """
        return _gdcmswig.FileStreamer_SetTemplateFileName(self, filename_native)

    def CheckTemplateFileName(self, check):
        r"""
        void gdcm::FileStreamer::CheckTemplateFileName(bool check)

        Instead of simply blindly copying the input DICOM Template file, GDCM
        will be used to check the input file, and correct any issues
        recognized within the file. Only use if you do not have control over
        the input template file. 
        """
        return _gdcmswig.FileStreamer_CheckTemplateFileName(self, check)

    def SetOutputFileName(self, filename_native):
        r"""
        void
        gdcm::FileStreamer::SetOutputFileName(const char *filename_native)

        Set output filename (target file) 
        """
        return _gdcmswig.FileStreamer_SetOutputFileName(self, filename_native)

    def CheckDataElement(self, t):
        r"""
        bool
        gdcm::FileStreamer::CheckDataElement(const Tag &t)

        Decide to check the Data Element to be written (default: off) The
        implementation has default strategy for checking validity of
        DataElement. Currently it only support checking for the following
        tags: (7fe0,0010) Pixel Data 
        """
        return _gdcmswig.FileStreamer_CheckDataElement(self, t)

    def StartDataElement(self, t):
        r"""
        bool
        gdcm::FileStreamer::StartDataElement(const Tag &t)

        Start Single Data Element Operation This will delete any existing Tag
        t. Need to call it only once. 
        """
        return _gdcmswig.FileStreamer_StartDataElement(self, t)

    def AppendToDataElement(self, t, array, len):
        r"""
        bool
        gdcm::FileStreamer::AppendToDataElement(const Tag &t, const char
        *array, size_t len)

        Append to previously started Tag t. 
        """
        return _gdcmswig.FileStreamer_AppendToDataElement(self, t, array, len)

    def StopDataElement(self, t):
        r"""
        bool
        gdcm::FileStreamer::StopDataElement(const Tag &t)

        Stop appending to tag t. This will compute the proper attribute
        length. 
        """
        return _gdcmswig.FileStreamer_StopDataElement(self, t)

    def ReserveDataElement(self, len):
        r"""
        bool
        gdcm::FileStreamer::ReserveDataElement(size_t len)

        Add a hint on the final size of the dataelement. When optimally
        chosen, this reduce the number of file in-place copying. Should be
        called before StartDataElement 
        """
        return _gdcmswig.FileStreamer_ReserveDataElement(self, len)

    def StartGroupDataElement(self, pt, maxsizede=0, startoffset=0):
        r"""
        bool gdcm::FileStreamer::StartGroupDataElement(const PrivateTag &pt,
        size_t maxsizede=0, uint8_t startoffset=0)

        Start Private Group (multiple DataElement) Operation. Each newly added
        DataElement will have a length lower than

        Parameters:
        -----------

        maxsizede:  . When not specified, maxsizede is set to maximum size
        allowed by DICOM (= 2^32). startoffset can be used to specify the very
        first element you want to start with (instead of the first possible).
        Value should be in [0x0, 0xff] This will find the first available
        private creator.

        Bug maxsizede should be a value lower than the actual total size of
        the buffer to be copied 
        """
        return _gdcmswig.FileStreamer_StartGroupDataElement(self, pt, maxsizede, startoffset)

    def AppendToGroupDataElement(self, pt, array, len):
        r"""
        bool gdcm::FileStreamer::AppendToGroupDataElement(const PrivateTag
        &pt, const char *array, size_t len)

        Append to previously started private creator. 
        """
        return _gdcmswig.FileStreamer_AppendToGroupDataElement(self, pt, array, len)

    def StopGroupDataElement(self, pt):
        r"""
        bool
        gdcm::FileStreamer::StopGroupDataElement(const PrivateTag &pt)

        Stop appending to private creator. 
        """
        return _gdcmswig.FileStreamer_StopGroupDataElement(self, pt)

    def ReserveGroupDataElement(self, ndataelement):
        r"""
        bool gdcm::FileStreamer::ReserveGroupDataElement(unsigned short
        ndataelement)

        Optimisation: pre-allocate the number of dataelement within the
        private group (ndataelement <= 256). Should be called before
        StartGroupDataElement 
        """
        return _gdcmswig.FileStreamer_ReserveGroupDataElement(self, ndataelement)

    @staticmethod
    def New():
        return _gdcmswig.FileStreamer_New()

# Register FileStreamer in _gdcmswig:
_gdcmswig.FileStreamer_swigregister(FileStreamer)
class System(object):
    r"""


    Class to do system operation.

    OS independent functionalities

    C++ includes: gdcmSystem.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def MakeDirectory(path):
        return _gdcmswig.System_MakeDirectory(path)

    @staticmethod
    def FileExists(filename):
        return _gdcmswig.System_FileExists(filename)

    @staticmethod
    def FileIsDirectory(name):
        return _gdcmswig.System_FileIsDirectory(name)

    @staticmethod
    def FileIsSymlink(name):
        return _gdcmswig.System_FileIsSymlink(name)

    @staticmethod
    def RemoveFile(source):
        return _gdcmswig.System_RemoveFile(source)

    @staticmethod
    def DeleteDirectory(source):
        return _gdcmswig.System_DeleteDirectory(source)

    @staticmethod
    def ConvertToUNC(utf8path):
        return _gdcmswig.System_ConvertToUNC(utf8path)

    @staticmethod
    def GetLastSystemError():
        return _gdcmswig.System_GetLastSystemError()

    @staticmethod
    def FileSize(filename):
        return _gdcmswig.System_FileSize(filename)

    @staticmethod
    def FileTime(filename):
        return _gdcmswig.System_FileTime(filename)

    @staticmethod
    def GetCurrentProcessFileName():
        return _gdcmswig.System_GetCurrentProcessFileName()

    @staticmethod
    def GetCurrentModuleFileName():
        return _gdcmswig.System_GetCurrentModuleFileName()

    @staticmethod
    def GetCurrentResourcesDirectory():
        return _gdcmswig.System_GetCurrentResourcesDirectory()

    @staticmethod
    def GetHostName(hostname):
        return _gdcmswig.System_GetHostName(hostname)

    @staticmethod
    def GetCurrentDateTime(date):
        return _gdcmswig.System_GetCurrentDateTime(date)

    @staticmethod
    def FormatDateTime(date, t, milliseconds=0):
        return _gdcmswig.System_FormatDateTime(date, t, milliseconds)

    @staticmethod
    def ParseDateTime(*args):
        return _gdcmswig.System_ParseDateTime(*args)

    @staticmethod
    def GetTimezoneOffsetFromUTC():
        return _gdcmswig.System_GetTimezoneOffsetFromUTC()

    @staticmethod
    def EncodeBytes(out, data, size):
        return _gdcmswig.System_EncodeBytes(out, data, size)

    @staticmethod
    def StrCaseCmp(s1, s2):
        return _gdcmswig.System_StrCaseCmp(s1, s2)

    @staticmethod
    def StrNCaseCmp(s1, s2, n):
        return _gdcmswig.System_StrNCaseCmp(s1, s2, n)

    @staticmethod
    def GetCWD():
        return _gdcmswig.System_GetCWD()

    @staticmethod
    def StrTokR(ptr, sep, end):
        return _gdcmswig.System_StrTokR(ptr, sep, end)

    @staticmethod
    def StrSep(stringp, delim):
        return _gdcmswig.System_StrSep(stringp, delim)

    @staticmethod
    def GetLocaleCharset():
        return _gdcmswig.System_GetLocaleCharset()

    def __init__(self):
        _gdcmswig.System_swiginit(self, _gdcmswig.new_System())
    __swig_destroy__ = _gdcmswig.delete_System

# Register System in _gdcmswig:
_gdcmswig.System_swigregister(System)
class Trace(object):
    r"""


    Trace.

    Debug / Warning and Error are encapsulated in this class by default
    the Trace class will redirect any debug/warning/error to std::cerr.
    Unless SetStream was specified with another (open) stream or
    SetStreamToFile was specified to a writable file on the system.

    WARNING:  All string messages are removed during compilation time when
    compiled with CMAKE_BUILD_TYPE being set to either: Release

    MinSizeRel It is recommended to compile with RelWithDebInfo and/or
    Debug during prototyping of applications.

    C++ includes: gdcmTrace.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Trace::Trace()"""
        _gdcmswig.Trace_swiginit(self, _gdcmswig.new_Trace())
    __swig_destroy__ = _gdcmswig.delete_Trace

    @staticmethod
    def SetStream(os):
        return _gdcmswig.Trace_SetStream(os)

    @staticmethod
    def GetStream():
        return _gdcmswig.Trace_GetStream()

    @staticmethod
    def SetDebugStream(os):
        return _gdcmswig.Trace_SetDebugStream(os)

    @staticmethod
    def GetDebugStream():
        return _gdcmswig.Trace_GetDebugStream()

    @staticmethod
    def SetWarningStream(os):
        return _gdcmswig.Trace_SetWarningStream(os)

    @staticmethod
    def GetWarningStream():
        return _gdcmswig.Trace_GetWarningStream()

    @staticmethod
    def SetErrorStream(os):
        return _gdcmswig.Trace_SetErrorStream(os)

    @staticmethod
    def GetErrorStream():
        return _gdcmswig.Trace_GetErrorStream()

    @staticmethod
    def SetStreamToFile(filename):
        return _gdcmswig.Trace_SetStreamToFile(filename)

    @staticmethod
    def SetDebug(debug):
        return _gdcmswig.Trace_SetDebug(debug)

    @staticmethod
    def DebugOn():
        return _gdcmswig.Trace_DebugOn()

    @staticmethod
    def DebugOff():
        return _gdcmswig.Trace_DebugOff()

    @staticmethod
    def GetDebugFlag():
        return _gdcmswig.Trace_GetDebugFlag()

    @staticmethod
    def SetWarning(debug):
        return _gdcmswig.Trace_SetWarning(debug)

    @staticmethod
    def WarningOn():
        return _gdcmswig.Trace_WarningOn()

    @staticmethod
    def WarningOff():
        return _gdcmswig.Trace_WarningOff()

    @staticmethod
    def GetWarningFlag():
        return _gdcmswig.Trace_GetWarningFlag()

    @staticmethod
    def SetError(debug):
        return _gdcmswig.Trace_SetError(debug)

    @staticmethod
    def ErrorOn():
        return _gdcmswig.Trace_ErrorOn()

    @staticmethod
    def ErrorOff():
        return _gdcmswig.Trace_ErrorOff()

    @staticmethod
    def GetErrorFlag():
        return _gdcmswig.Trace_GetErrorFlag()

# Register Trace in _gdcmswig:
_gdcmswig.Trace_swigregister(Trace)
class UIDs(object):
    r"""


    all known uids

    C++ includes: gdcmUIDs.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    uid_1_2_840_10008_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_1
    uid_1_2_840_10008_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2
    uid_1_2_840_10008_1_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_1
    uid_1_2_840_10008_1_2_1_99 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_1_99
    uid_1_2_840_10008_1_2_2 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_2
    uid_1_2_840_10008_1_2_4_50 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_50
    uid_1_2_840_10008_1_2_4_51 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_51
    uid_1_2_840_10008_1_2_4_52 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_52
    uid_1_2_840_10008_1_2_4_53 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_53
    uid_1_2_840_10008_1_2_4_54 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_54
    uid_1_2_840_10008_1_2_4_55 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_55
    uid_1_2_840_10008_1_2_4_56 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_56
    uid_1_2_840_10008_1_2_4_57 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_57
    uid_1_2_840_10008_1_2_4_58 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_58
    uid_1_2_840_10008_1_2_4_59 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_59
    uid_1_2_840_10008_1_2_4_60 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_60
    uid_1_2_840_10008_1_2_4_61 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_61
    uid_1_2_840_10008_1_2_4_62 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_62
    uid_1_2_840_10008_1_2_4_63 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_63
    uid_1_2_840_10008_1_2_4_64 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_64
    uid_1_2_840_10008_1_2_4_65 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_65
    uid_1_2_840_10008_1_2_4_66 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_66
    uid_1_2_840_10008_1_2_4_70 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_70
    uid_1_2_840_10008_1_2_4_80 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_80
    uid_1_2_840_10008_1_2_4_81 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_81
    uid_1_2_840_10008_1_2_4_90 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_90
    uid_1_2_840_10008_1_2_4_91 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_91
    uid_1_2_840_10008_1_2_4_92 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_92
    uid_1_2_840_10008_1_2_4_93 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_93
    uid_1_2_840_10008_1_2_4_94 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_94
    uid_1_2_840_10008_1_2_4_95 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_95
    uid_1_2_840_10008_1_2_4_100 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_100
    uid_1_2_840_10008_1_2_5 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_5
    uid_1_2_840_10008_1_2_6_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_6_1
    uid_1_2_840_10008_1_2_6_2 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_6_2
    uid_1_2_840_10008_1_3_10 = _gdcmswig.UIDs_uid_1_2_840_10008_1_3_10
    uid_1_2_840_10008_1_4_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_1
    uid_1_2_840_10008_1_4_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_2
    uid_1_2_840_10008_1_4_1_3 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_3
    uid_1_2_840_10008_1_4_1_4 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_4
    uid_1_2_840_10008_1_4_1_5 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_5
    uid_1_2_840_10008_1_4_1_6 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_6
    uid_1_2_840_10008_1_4_1_7 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_7
    uid_1_2_840_10008_1_4_1_8 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_8
    uid_1_2_840_10008_1_4_1_9 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_9
    uid_1_2_840_10008_1_4_1_10 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_10
    uid_1_2_840_10008_1_4_1_11 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_11
    uid_1_2_840_10008_1_4_1_12 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_12
    uid_1_2_840_10008_1_4_1_13 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_13
    uid_1_2_840_10008_1_4_1_14 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_14
    uid_1_2_840_10008_1_4_1_15 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_15
    uid_1_2_840_10008_1_4_1_16 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_16
    uid_1_2_840_10008_1_4_1_17 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_17
    uid_1_2_840_10008_1_4_1_18 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_1_18
    uid_1_2_840_10008_1_4_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_2_1
    uid_1_2_840_10008_1_4_2_2 = _gdcmswig.UIDs_uid_1_2_840_10008_1_4_2_2
    uid_1_2_840_10008_1_9 = _gdcmswig.UIDs_uid_1_2_840_10008_1_9
    uid_1_2_840_10008_1_20_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_20_1
    uid_1_2_840_10008_1_20_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_20_1_1
    uid_1_2_840_10008_1_20_2 = _gdcmswig.UIDs_uid_1_2_840_10008_1_20_2
    uid_1_2_840_10008_1_20_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_20_2_1
    uid_1_2_840_10008_1_40 = _gdcmswig.UIDs_uid_1_2_840_10008_1_40
    uid_1_2_840_10008_1_40_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_40_1
    uid_1_2_840_10008_1_42 = _gdcmswig.UIDs_uid_1_2_840_10008_1_42
    uid_1_2_840_10008_1_42_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_42_1
    uid_1_2_840_10008_2_6_1 = _gdcmswig.UIDs_uid_1_2_840_10008_2_6_1
    uid_1_2_840_10008_2_16_4 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_4
    uid_1_2_840_10008_3_1_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_1_1
    uid_1_2_840_10008_3_1_2_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_1_1
    uid_1_2_840_10008_3_1_2_1_4 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_1_4
    uid_1_2_840_10008_3_1_2_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_2_1
    uid_1_2_840_10008_3_1_2_3_1 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_3_1
    uid_1_2_840_10008_3_1_2_3_2 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_3_2
    uid_1_2_840_10008_3_1_2_3_3 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_3_3
    uid_1_2_840_10008_3_1_2_3_4 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_3_4
    uid_1_2_840_10008_3_1_2_3_5 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_3_5
    uid_1_2_840_10008_3_1_2_5_1 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_5_1
    uid_1_2_840_10008_3_1_2_5_4 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_5_4
    uid_1_2_840_10008_3_1_2_5_5 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_5_5
    uid_1_2_840_10008_3_1_2_6_1 = _gdcmswig.UIDs_uid_1_2_840_10008_3_1_2_6_1
    uid_1_2_840_10008_4_2 = _gdcmswig.UIDs_uid_1_2_840_10008_4_2
    uid_1_2_840_10008_5_1_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_1
    uid_1_2_840_10008_5_1_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_2
    uid_1_2_840_10008_5_1_1_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_4
    uid_1_2_840_10008_5_1_1_4_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_4_1
    uid_1_2_840_10008_5_1_1_4_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_4_2
    uid_1_2_840_10008_5_1_1_9 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_9
    uid_1_2_840_10008_5_1_1_9_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_9_1
    uid_1_2_840_10008_5_1_1_14 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_14
    uid_1_2_840_10008_5_1_1_15 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_15
    uid_1_2_840_10008_5_1_1_16 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_16
    uid_1_2_840_10008_5_1_1_16_376 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_16_376
    uid_1_2_840_10008_5_1_1_17 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_17
    uid_1_2_840_10008_5_1_1_17_376 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_17_376
    uid_1_2_840_10008_5_1_1_18 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_18
    uid_1_2_840_10008_5_1_1_18_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_18_1
    uid_1_2_840_10008_5_1_1_22 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_22
    uid_1_2_840_10008_5_1_1_23 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_23
    uid_1_2_840_10008_5_1_1_24 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_24
    uid_1_2_840_10008_5_1_1_24_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_24_1
    uid_1_2_840_10008_5_1_1_25 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_25
    uid_1_2_840_10008_5_1_1_26 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_26
    uid_1_2_840_10008_5_1_1_27 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_27
    uid_1_2_840_10008_5_1_1_29 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_29
    uid_1_2_840_10008_5_1_1_30 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_30
    uid_1_2_840_10008_5_1_1_31 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_31
    uid_1_2_840_10008_5_1_1_32 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_32
    uid_1_2_840_10008_5_1_1_33 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_33
    uid_1_2_840_10008_5_1_4_1_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_1
    uid_1_2_840_10008_5_1_4_1_1_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_1_1
    uid_1_2_840_10008_5_1_4_1_1_1_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_1_1_1
    uid_1_2_840_10008_5_1_4_1_1_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_1_2
    uid_1_2_840_10008_5_1_4_1_1_1_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_1_2_1
    uid_1_2_840_10008_5_1_4_1_1_1_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_1_3
    uid_1_2_840_10008_5_1_4_1_1_1_3_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_1_3_1
    uid_1_2_840_10008_5_1_4_1_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_2
    uid_1_2_840_10008_5_1_4_1_1_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_2_1
    uid_1_2_840_10008_5_1_4_1_1_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_3
    uid_1_2_840_10008_5_1_4_1_1_3_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_3_1
    uid_1_2_840_10008_5_1_4_1_1_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_4
    uid_1_2_840_10008_5_1_4_1_1_4_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_4_1
    uid_1_2_840_10008_5_1_4_1_1_4_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_4_2
    uid_1_2_840_10008_5_1_4_1_1_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_5
    uid_1_2_840_10008_5_1_4_1_1_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_6
    uid_1_2_840_10008_5_1_4_1_1_6_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_6_1
    uid_1_2_840_10008_5_1_4_1_1_7 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_7
    uid_1_2_840_10008_5_1_4_1_1_7_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_7_1
    uid_1_2_840_10008_5_1_4_1_1_7_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_7_2
    uid_1_2_840_10008_5_1_4_1_1_7_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_7_3
    uid_1_2_840_10008_5_1_4_1_1_7_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_7_4
    uid_1_2_840_10008_5_1_4_1_1_8 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_8
    uid_1_2_840_10008_5_1_4_1_1_9 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9
    uid_1_2_840_10008_5_1_4_1_1_9_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_1
    uid_1_2_840_10008_5_1_4_1_1_9_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_1_1
    uid_1_2_840_10008_5_1_4_1_1_9_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_1_2
    uid_1_2_840_10008_5_1_4_1_1_9_1_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_1_3
    uid_1_2_840_10008_5_1_4_1_1_9_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_2_1
    uid_1_2_840_10008_5_1_4_1_1_9_3_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_3_1
    uid_1_2_840_10008_5_1_4_1_1_9_4_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_4_1
    uid_1_2_840_10008_5_1_4_1_1_10 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_10
    uid_1_2_840_10008_5_1_4_1_1_11 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11
    uid_1_2_840_10008_5_1_4_1_1_11_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_1
    uid_1_2_840_10008_5_1_4_1_1_11_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_2
    uid_1_2_840_10008_5_1_4_1_1_11_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_3
    uid_1_2_840_10008_5_1_4_1_1_11_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_4
    uid_1_2_840_10008_5_1_4_1_1_12_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_12_1
    uid_1_2_840_10008_5_1_4_1_1_12_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_12_1_1
    uid_1_2_840_10008_5_1_4_1_1_12_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_12_2
    uid_1_2_840_10008_5_1_4_1_1_12_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_12_2_1
    uid_1_2_840_10008_5_1_4_1_1_13_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_13_1_1
    uid_1_2_840_10008_5_1_4_1_1_13_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_13_1_2
    uid_1_2_840_10008_5_1_4_1_1_12_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_12_3
    uid_1_2_840_10008_5_1_4_1_1_20 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_20
    uid_1_2_840_10008_5_1_4_1_1_66 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_66
    uid_1_2_840_10008_5_1_4_1_1_66_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_66_1
    uid_1_2_840_10008_5_1_4_1_1_66_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_66_2
    uid_1_2_840_10008_5_1_4_1_1_66_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_66_3
    uid_1_2_840_10008_5_1_4_1_1_66_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_66_4
    uid_1_2_840_10008_5_1_4_1_1_67 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_67
    uid_1_2_840_10008_5_1_4_1_1_77_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1
    uid_1_2_840_10008_5_1_4_1_1_77_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_2
    uid_1_2_840_10008_5_1_4_1_1_77_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_1
    uid_1_2_840_10008_5_1_4_1_1_77_1_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_1_1
    uid_1_2_840_10008_5_1_4_1_1_77_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_2
    uid_1_2_840_10008_5_1_4_1_1_77_1_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_2_1
    uid_1_2_840_10008_5_1_4_1_1_77_1_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_3
    uid_1_2_840_10008_5_1_4_1_1_77_1_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_4
    uid_1_2_840_10008_5_1_4_1_1_77_1_4_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_4_1
    uid_1_2_840_10008_5_1_4_1_1_77_1_5_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_5_1
    uid_1_2_840_10008_5_1_4_1_1_77_1_5_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_5_2
    uid_1_2_840_10008_5_1_4_1_1_77_1_5_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_5_3
    uid_1_2_840_10008_5_1_4_1_1_77_1_5_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_5_4
    uid_1_2_840_10008_5_1_4_1_1_88_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_1
    uid_1_2_840_10008_5_1_4_1_1_88_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_2
    uid_1_2_840_10008_5_1_4_1_1_88_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_3
    uid_1_2_840_10008_5_1_4_1_1_88_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_4
    uid_1_2_840_10008_5_1_4_1_1_88_11 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_11
    uid_1_2_840_10008_5_1_4_1_1_88_22 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_22
    uid_1_2_840_10008_5_1_4_1_1_88_33 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_33
    uid_1_2_840_10008_5_1_4_1_1_88_40 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_40
    uid_1_2_840_10008_5_1_4_1_1_88_50 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_50
    uid_1_2_840_10008_5_1_4_1_1_88_59 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_59
    uid_1_2_840_10008_5_1_4_1_1_88_65 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_65
    uid_1_2_840_10008_5_1_4_1_1_88_67 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_67
    uid_1_2_840_10008_5_1_4_1_1_104_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_104_1
    uid_1_2_840_10008_5_1_4_1_1_104_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_104_2
    uid_1_2_840_10008_5_1_4_1_1_128 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_128
    uid_1_2_840_10008_5_1_4_1_1_129 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_129
    uid_1_2_840_10008_5_1_4_1_1_481_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_1
    uid_1_2_840_10008_5_1_4_1_1_481_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_2
    uid_1_2_840_10008_5_1_4_1_1_481_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_3
    uid_1_2_840_10008_5_1_4_1_1_481_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_4
    uid_1_2_840_10008_5_1_4_1_1_481_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_5
    uid_1_2_840_10008_5_1_4_1_1_481_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_6
    uid_1_2_840_10008_5_1_4_1_1_481_7 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_7
    uid_1_2_840_10008_5_1_4_1_1_481_8 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_8
    uid_1_2_840_10008_5_1_4_1_1_481_9 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_9
    uid_1_2_840_10008_5_1_4_1_2_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_1_1
    uid_1_2_840_10008_5_1_4_1_2_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_1_2
    uid_1_2_840_10008_5_1_4_1_2_1_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_1_3
    uid_1_2_840_10008_5_1_4_1_2_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_2_1
    uid_1_2_840_10008_5_1_4_1_2_2_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_2_2
    uid_1_2_840_10008_5_1_4_1_2_2_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_2_3
    uid_1_2_840_10008_5_1_4_1_2_3_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_3_1
    uid_1_2_840_10008_5_1_4_1_2_3_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_3_2
    uid_1_2_840_10008_5_1_4_1_2_3_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_3_3
    uid_1_2_840_10008_5_1_4_31 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_31
    uid_1_2_840_10008_5_1_4_32_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_32_1
    uid_1_2_840_10008_5_1_4_32_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_32_2
    uid_1_2_840_10008_5_1_4_32_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_32_3
    uid_1_2_840_10008_5_1_4_32 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_32
    uid_1_2_840_10008_5_1_4_33 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_33
    uid_1_2_840_10008_5_1_4_34_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_1
    uid_1_2_840_10008_5_1_4_34_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_2
    uid_1_2_840_10008_5_1_4_34_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_3
    uid_1_2_840_10008_5_1_4_34_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_4
    uid_1_2_840_10008_5_1_4_34_4_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_4_1
    uid_1_2_840_10008_5_1_4_34_4_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_4_2
    uid_1_2_840_10008_5_1_4_34_4_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_4_3
    uid_1_2_840_10008_5_1_4_34_4_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_4_4
    uid_1_2_840_10008_5_1_4_34_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_5
    uid_1_2_840_10008_5_1_4_37_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_37_1
    uid_1_2_840_10008_5_1_4_37_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_37_2
    uid_1_2_840_10008_5_1_4_37_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_37_3
    uid_1_2_840_10008_5_1_4_38_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_38_1
    uid_1_2_840_10008_5_1_4_38_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_38_2
    uid_1_2_840_10008_5_1_4_38_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_38_3
    uid_1_2_840_10008_5_1_4_41 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_41
    uid_1_2_840_10008_5_1_4_42 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_42
    uid_1_2_840_10008_15_0_3_1 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_1
    uid_1_2_840_10008_15_0_3_2 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_2
    uid_1_2_840_10008_15_0_3_3 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_3
    uid_1_2_840_10008_15_0_3_4 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_4
    uid_1_2_840_10008_15_0_3_5 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_5
    uid_1_2_840_10008_15_0_3_6 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_6
    uid_1_2_840_10008_15_0_3_7 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_7
    uid_1_2_840_10008_15_0_3_8 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_8
    uid_1_2_840_10008_15_0_3_9 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_9
    uid_1_2_840_10008_15_0_3_10 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_10
    uid_1_2_840_10008_15_0_3_11 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_11
    uid_1_2_840_10008_15_0_3_12 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_12
    uid_1_2_840_10008_15_0_3_13 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_13
    uid_1_2_840_10008_15_0_3_14 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_14
    uid_1_2_840_10008_15_0_3_15 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_15
    uid_1_2_840_10008_15_0_3_16 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_16
    uid_1_2_840_10008_15_0_3_17 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_17
    uid_1_2_840_10008_15_0_3_18 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_18
    uid_1_2_840_10008_15_0_3_19 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_19
    uid_1_2_840_10008_15_0_3_20 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_20
    uid_1_2_840_10008_15_0_3_21 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_21
    uid_1_2_840_10008_15_0_3_22 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_22
    uid_1_2_840_10008_15_0_3_23 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_23
    uid_1_2_840_10008_15_0_3_24 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_24
    uid_1_2_840_10008_15_0_3_25 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_25
    uid_1_2_840_10008_15_0_3_26 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_26
    uid_1_2_840_10008_15_0_3_27 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_27
    uid_1_2_840_10008_15_0_3_28 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_28
    uid_1_2_840_10008_15_0_3_29 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_29
    uid_1_2_840_10008_15_0_3_30 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_30
    uid_1_2_840_10008_15_0_3_31 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_3_31
    uid_1_2_840_10008_15_0_4_1 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_4_1
    uid_1_2_840_10008_15_0_4_2 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_4_2
    uid_1_2_840_10008_15_0_4_3 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_4_3
    uid_1_2_840_10008_15_0_4_4 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_4_4
    uid_1_2_840_10008_15_0_4_5 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_4_5
    uid_1_2_840_10008_15_0_4_6 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_4_6
    uid_1_2_840_10008_15_0_4_7 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_4_7
    uid_1_2_840_10008_15_0_4_8 = _gdcmswig.UIDs_uid_1_2_840_10008_15_0_4_8
    uid_1_2_840_10008_5_1_4_1_1_77_1_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_6
    uid_1_2_840_10008_5_1_4_1_1_6_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_6_2
    uid_1_2_840_10008_5_1_4_1_1_66_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_66_5
    uid_1_2_840_10008_5_1_4_1_1_13_1_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_13_1_3
    uid_1_2_840_10008_5_1_4_1_1_2_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_2_2
    uid_1_2_840_10008_5_1_4_1_1_4_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_4_4
    uid_1_2_840_10008_5_1_4_1_1_128_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_128_1
    uid_1_2_840_10008_1_2_4_101 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_101
    uid_1_2_840_10008_1_2_4_102 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_102
    uid_1_2_840_10008_1_2_4_103 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_103
    uid_1_2_840_10008_1_5_2 = _gdcmswig.UIDs_uid_1_2_840_10008_1_5_2
    uid_1_2_840_10008_1_5_3 = _gdcmswig.UIDs_uid_1_2_840_10008_1_5_3
    uid_1_2_840_10008_1_5_4 = _gdcmswig.UIDs_uid_1_2_840_10008_1_5_4
    uid_1_2_840_10008_1_5_5 = _gdcmswig.UIDs_uid_1_2_840_10008_1_5_5
    uid_1_2_840_10008_1_5_6 = _gdcmswig.UIDs_uid_1_2_840_10008_1_5_6
    uid_1_2_840_10008_1_5_7 = _gdcmswig.UIDs_uid_1_2_840_10008_1_5_7
    uid_1_2_840_10008_1_5_8 = _gdcmswig.UIDs_uid_1_2_840_10008_1_5_8
    uid_1_2_840_10008_1_20 = _gdcmswig.UIDs_uid_1_2_840_10008_1_20
    uid_1_2_840_10008_2_16_5 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_5
    uid_1_2_840_10008_2_16_6 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_6
    uid_1_2_840_10008_2_16_7 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_7
    uid_1_2_840_10008_2_16_8 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_8
    uid_1_2_840_10008_2_16_9 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_9
    uid_1_2_840_10008_2_16_10 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_10
    uid_1_2_840_10008_2_16_11 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_11
    uid_1_2_840_10008_2_16_12 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_12
    uid_1_2_840_10008_2_16_13 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_13
    uid_1_2_840_10008_2_16_14 = _gdcmswig.UIDs_uid_1_2_840_10008_2_16_14
    uid_1_2_840_10008_5_1_1_40 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_40
    uid_1_2_840_10008_5_1_1_40_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_1_40_1
    uid_1_2_840_10008_5_1_4_1_1_9_4_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_4_2
    uid_1_2_840_10008_5_1_4_1_1_9_5_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_5_1
    uid_1_2_840_10008_5_1_4_1_1_9_6_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_9_6_1
    uid_1_2_840_10008_5_1_4_1_1_11_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_5
    uid_1_2_840_10008_5_1_4_1_1_11_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_6
    uid_1_2_840_10008_1_2_4_104 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_104
    uid_1_2_840_10008_1_2_4_105 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_105
    uid_1_2_840_10008_1_2_4_106 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_106
    uid_1_2_840_10008_1_2_4_107 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_107
    uid_1_2_840_10008_1_2_4_108 = _gdcmswig.UIDs_uid_1_2_840_10008_1_2_4_108
    uid_1_2_840_10008_1_5_1 = _gdcmswig.UIDs_uid_1_2_840_10008_1_5_1
    uid_1_2_840_10008_5_1_4_1_1_11_7 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_7
    uid_1_2_840_10008_5_1_4_1_1_11_8 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_8
    uid_1_2_840_10008_5_1_4_1_1_11_9 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_9
    uid_1_2_840_10008_5_1_4_1_1_11_10 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_10
    uid_1_2_840_10008_5_1_4_1_1_11_11 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_11_11
    uid_1_2_840_10008_5_1_4_1_1_12_77 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_12_77
    uid_1_2_840_10008_5_1_4_1_1_13_1_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_13_1_4
    uid_1_2_840_10008_5_1_4_1_1_13_1_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_13_1_5
    uid_1_2_840_10008_5_1_4_1_1_14_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_14_1
    uid_1_2_840_10008_5_1_4_1_1_14_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_14_2
    uid_1_2_840_10008_5_1_4_1_1_30 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_30
    uid_1_2_840_10008_5_1_4_1_1_40 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_40
    uid_1_2_840_10008_5_1_4_1_1_66_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_66_6
    uid_1_2_840_10008_5_1_4_1_1_68_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_68_1
    uid_1_2_840_10008_5_1_4_1_1_68_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_68_2
    uid_1_2_840_10008_5_1_4_1_1_77_1_5_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_5_5
    uid_1_2_840_10008_5_1_4_1_1_77_1_5_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_5_6
    uid_1_2_840_10008_5_1_4_1_1_77_1_5_7 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_5_7
    uid_1_2_840_10008_5_1_4_1_1_77_1_5_8 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_77_1_5_8
    uid_1_2_840_10008_5_1_4_1_1_78_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_78_1
    uid_1_2_840_10008_5_1_4_1_1_78_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_78_2
    uid_1_2_840_10008_5_1_4_1_1_78_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_78_3
    uid_1_2_840_10008_5_1_4_1_1_78_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_78_4
    uid_1_2_840_10008_5_1_4_1_1_78_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_78_5
    uid_1_2_840_10008_5_1_4_1_1_78_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_78_6
    uid_1_2_840_10008_5_1_4_1_1_78_7 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_78_7
    uid_1_2_840_10008_5_1_4_1_1_78_8 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_78_8
    uid_1_2_840_10008_5_1_4_1_1_79_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_79_1
    uid_1_2_840_10008_5_1_4_1_1_80_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_80_1
    uid_1_2_840_10008_5_1_4_1_1_81_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_81_1
    uid_1_2_840_10008_5_1_4_1_1_82_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_82_1
    uid_1_2_840_10008_5_1_4_1_1_88_34 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_34
    uid_1_2_840_10008_5_1_4_1_1_88_35 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_35
    uid_1_2_840_10008_5_1_4_1_1_88_68 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_68
    uid_1_2_840_10008_5_1_4_1_1_88_69 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_69
    uid_1_2_840_10008_5_1_4_1_1_88_70 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_70
    uid_1_2_840_10008_5_1_4_1_1_88_71 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_71
    uid_1_2_840_10008_5_1_4_1_1_88_72 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_72
    uid_1_2_840_10008_5_1_4_1_1_88_73 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_73
    uid_1_2_840_10008_5_1_4_1_1_88_74 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_74
    uid_1_2_840_10008_5_1_4_1_1_88_75 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_88_75
    uid_1_2_840_10008_5_1_4_1_1_90_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_90_1
    uid_1_2_840_10008_5_1_4_1_1_104_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_104_3
    uid_1_2_840_10008_5_1_4_1_1_130 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_130
    uid_1_2_840_10008_5_1_4_1_1_131 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_131
    uid_1_2_840_10008_5_1_4_1_1_200_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_200_1
    uid_1_2_840_10008_5_1_4_1_1_200_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_200_2
    uid_1_2_840_10008_5_1_4_1_1_200_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_200_3
    uid_1_2_840_10008_5_1_4_1_1_200_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_200_4
    uid_1_2_840_10008_5_1_4_1_1_200_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_200_5
    uid_1_2_840_10008_5_1_4_1_1_200_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_200_6
    uid_1_2_840_10008_5_1_4_1_1_481_10 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_10
    uid_1_2_840_10008_5_1_4_1_1_481_11 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_481_11
    uid_1_2_840_10008_5_1_4_1_1_501_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_501_1
    uid_1_2_840_10008_5_1_4_1_1_501_2_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_501_2_1
    uid_1_2_840_10008_5_1_4_1_1_501_2_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_501_2_2
    uid_1_2_840_10008_5_1_4_1_1_501_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_501_3
    uid_1_2_840_10008_5_1_4_1_1_501_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_501_4
    uid_1_2_840_10008_5_1_4_1_1_501_5 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_501_5
    uid_1_2_840_10008_5_1_4_1_1_501_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_501_6
    uid_1_2_840_10008_5_1_4_1_1_601_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_601_1
    uid_1_2_840_10008_5_1_4_1_1_601_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_601_2
    uid_1_2_840_10008_5_1_4_1_2_4_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_4_2
    uid_1_2_840_10008_5_1_4_1_2_4_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_4_3
    uid_1_2_840_10008_5_1_4_1_2_5_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_2_5_3
    uid_1_2_840_10008_5_1_4_20_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_20_1
    uid_1_2_840_10008_5_1_4_20_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_20_2
    uid_1_2_840_10008_5_1_4_20_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_20_3
    uid_1_2_840_10008_5_1_4_34_5_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_5_1
    uid_1_2_840_10008_5_1_4_34_6 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_6
    uid_1_2_840_10008_5_1_4_34_6_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_6_1
    uid_1_2_840_10008_5_1_4_34_6_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_6_2
    uid_1_2_840_10008_5_1_4_34_6_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_6_3
    uid_1_2_840_10008_5_1_4_34_6_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_6_4
    uid_1_2_840_10008_5_1_4_34_7 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_7
    uid_1_2_840_10008_5_1_4_34_8 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_8
    uid_1_2_840_10008_5_1_4_34_9 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_9
    uid_1_2_840_10008_5_1_4_34_10 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_34_10
    uid_1_2_840_10008_5_1_4_38_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_38_4
    uid_1_2_840_10008_5_1_4_39_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_39_1
    uid_1_2_840_10008_5_1_4_39_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_39_2
    uid_1_2_840_10008_5_1_4_39_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_39_3
    uid_1_2_840_10008_5_1_4_39_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_39_4
    uid_1_2_840_10008_5_1_4_43_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_43_1
    uid_1_2_840_10008_5_1_4_43_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_43_2
    uid_1_2_840_10008_5_1_4_43_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_43_3
    uid_1_2_840_10008_5_1_4_43_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_43_4
    uid_1_2_840_10008_5_1_4_44_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_44_1
    uid_1_2_840_10008_5_1_4_44_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_44_2
    uid_1_2_840_10008_5_1_4_44_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_44_3
    uid_1_2_840_10008_5_1_4_44_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_44_4
    uid_1_2_840_10008_5_1_4_45_1 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_45_1
    uid_1_2_840_10008_5_1_4_45_2 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_45_2
    uid_1_2_840_10008_5_1_4_45_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_45_3
    uid_1_2_840_10008_5_1_4_45_4 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_45_4
    uid_1_2_840_10008_7_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_7_1_1
    uid_1_2_840_10008_7_1_2 = _gdcmswig.UIDs_uid_1_2_840_10008_7_1_2
    uid_1_2_840_10008_8_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_8_1_1
    uid_1_2_840_10008_5_1_4_1_1_4_3 = _gdcmswig.UIDs_uid_1_2_840_10008_5_1_4_1_1_4_3
    uid_1_2_840_10008_15_1_1 = _gdcmswig.UIDs_uid_1_2_840_10008_15_1_1
    VerificationSOPClass = _gdcmswig.UIDs_VerificationSOPClass
    ImplicitVRLittleEndianDefaultTransferSyntaxforDICOM = _gdcmswig.UIDs_ImplicitVRLittleEndianDefaultTransferSyntaxforDICOM
    ExplicitVRLittleEndian = _gdcmswig.UIDs_ExplicitVRLittleEndian
    DeflatedExplicitVRLittleEndian = _gdcmswig.UIDs_DeflatedExplicitVRLittleEndian
    ExplicitVRBigEndian = _gdcmswig.UIDs_ExplicitVRBigEndian
    JPEGBaselineProcess1DefaultTransferSyntaxforLossyJPEG8BitImageCompression = _gdcmswig.UIDs_JPEGBaselineProcess1DefaultTransferSyntaxforLossyJPEG8BitImageCompression
    JPEGExtendedProcess24DefaultTransferSyntaxforLossyJPEG12BitImageCompressionProcess4only = _gdcmswig.UIDs_JPEGExtendedProcess24DefaultTransferSyntaxforLossyJPEG12BitImageCompressionProcess4only
    JPEGExtendedProcess35Retired = _gdcmswig.UIDs_JPEGExtendedProcess35Retired
    JPEGSpectralSelectionNonHierarchicalProcess68Retired = _gdcmswig.UIDs_JPEGSpectralSelectionNonHierarchicalProcess68Retired
    JPEGSpectralSelectionNonHierarchicalProcess79Retired = _gdcmswig.UIDs_JPEGSpectralSelectionNonHierarchicalProcess79Retired
    JPEGFullProgressionNonHierarchicalProcess1012Retired = _gdcmswig.UIDs_JPEGFullProgressionNonHierarchicalProcess1012Retired
    JPEGFullProgressionNonHierarchicalProcess1113Retired = _gdcmswig.UIDs_JPEGFullProgressionNonHierarchicalProcess1113Retired
    JPEGLosslessNonHierarchicalProcess14 = _gdcmswig.UIDs_JPEGLosslessNonHierarchicalProcess14
    JPEGLosslessNonHierarchicalProcess15Retired = _gdcmswig.UIDs_JPEGLosslessNonHierarchicalProcess15Retired
    JPEGExtendedHierarchicalProcess1618Retired = _gdcmswig.UIDs_JPEGExtendedHierarchicalProcess1618Retired
    JPEGExtendedHierarchicalProcess1719Retired = _gdcmswig.UIDs_JPEGExtendedHierarchicalProcess1719Retired
    JPEGSpectralSelectionHierarchicalProcess2022Retired = _gdcmswig.UIDs_JPEGSpectralSelectionHierarchicalProcess2022Retired
    JPEGSpectralSelectionHierarchicalProcess2123Retired = _gdcmswig.UIDs_JPEGSpectralSelectionHierarchicalProcess2123Retired
    JPEGFullProgressionHierarchicalProcess2426Retired = _gdcmswig.UIDs_JPEGFullProgressionHierarchicalProcess2426Retired
    JPEGFullProgressionHierarchicalProcess2527Retired = _gdcmswig.UIDs_JPEGFullProgressionHierarchicalProcess2527Retired
    JPEGLosslessHierarchicalProcess28Retired = _gdcmswig.UIDs_JPEGLosslessHierarchicalProcess28Retired
    JPEGLosslessHierarchicalProcess29Retired = _gdcmswig.UIDs_JPEGLosslessHierarchicalProcess29Retired
    JPEGLosslessNonHierarchicalFirstOrderPredictionProcess14SelectionValue1DefaultTransferSyntaxforLosslessJPEGImageCompression = _gdcmswig.UIDs_JPEGLosslessNonHierarchicalFirstOrderPredictionProcess14SelectionValue1DefaultTransferSyntaxforLosslessJPEGImageCompression
    JPEGLSLosslessImageCompression = _gdcmswig.UIDs_JPEGLSLosslessImageCompression
    JPEGLSLossyNearLosslessImageCompression = _gdcmswig.UIDs_JPEGLSLossyNearLosslessImageCompression
    JPEG2000ImageCompressionLosslessOnly = _gdcmswig.UIDs_JPEG2000ImageCompressionLosslessOnly
    JPEG2000ImageCompression = _gdcmswig.UIDs_JPEG2000ImageCompression
    JPEG2000Part2MulticomponentImageCompressionLosslessOnly = _gdcmswig.UIDs_JPEG2000Part2MulticomponentImageCompressionLosslessOnly
    JPEG2000Part2MulticomponentImageCompression = _gdcmswig.UIDs_JPEG2000Part2MulticomponentImageCompression
    JPIPReferenced = _gdcmswig.UIDs_JPIPReferenced
    JPIPReferencedDeflate = _gdcmswig.UIDs_JPIPReferencedDeflate
    MPEG2MainProfileMainLevel = _gdcmswig.UIDs_MPEG2MainProfileMainLevel
    RLELossless = _gdcmswig.UIDs_RLELossless
    RFC2557MIMEencapsulation = _gdcmswig.UIDs_RFC2557MIMEencapsulation
    XMLEncoding = _gdcmswig.UIDs_XMLEncoding
    MediaStorageDirectoryStorage = _gdcmswig.UIDs_MediaStorageDirectoryStorage
    TalairachBrainAtlasFrameofReference = _gdcmswig.UIDs_TalairachBrainAtlasFrameofReference
    SPM2T1FrameofReference = _gdcmswig.UIDs_SPM2T1FrameofReference
    SPM2T2FrameofReference = _gdcmswig.UIDs_SPM2T2FrameofReference
    SPM2PDFrameofReference = _gdcmswig.UIDs_SPM2PDFrameofReference
    SPM2EPIFrameofReference = _gdcmswig.UIDs_SPM2EPIFrameofReference
    SPM2FILT1FrameofReference = _gdcmswig.UIDs_SPM2FILT1FrameofReference
    SPM2PETFrameofReference = _gdcmswig.UIDs_SPM2PETFrameofReference
    SPM2TRANSMFrameofReference = _gdcmswig.UIDs_SPM2TRANSMFrameofReference
    SPM2SPECTFrameofReference = _gdcmswig.UIDs_SPM2SPECTFrameofReference
    SPM2GRAYFrameofReference = _gdcmswig.UIDs_SPM2GRAYFrameofReference
    SPM2WHITEFrameofReference = _gdcmswig.UIDs_SPM2WHITEFrameofReference
    SPM2CSFFrameofReference = _gdcmswig.UIDs_SPM2CSFFrameofReference
    SPM2BRAINMASKFrameofReference = _gdcmswig.UIDs_SPM2BRAINMASKFrameofReference
    SPM2AVG305T1FrameofReference = _gdcmswig.UIDs_SPM2AVG305T1FrameofReference
    SPM2AVG152T1FrameofReference = _gdcmswig.UIDs_SPM2AVG152T1FrameofReference
    SPM2AVG152T2FrameofReference = _gdcmswig.UIDs_SPM2AVG152T2FrameofReference
    SPM2AVG152PDFrameofReference = _gdcmswig.UIDs_SPM2AVG152PDFrameofReference
    SPM2SINGLESUBJT1FrameofReference = _gdcmswig.UIDs_SPM2SINGLESUBJT1FrameofReference
    ICBM452T1FrameofReference = _gdcmswig.UIDs_ICBM452T1FrameofReference
    ICBMSingleSubjectMRIFrameofReference = _gdcmswig.UIDs_ICBMSingleSubjectMRIFrameofReference
    BasicStudyContentNotificationSOPClassRetired = _gdcmswig.UIDs_BasicStudyContentNotificationSOPClassRetired
    StorageCommitmentPushModelSOPClass = _gdcmswig.UIDs_StorageCommitmentPushModelSOPClass
    StorageCommitmentPushModelSOPInstance = _gdcmswig.UIDs_StorageCommitmentPushModelSOPInstance
    StorageCommitmentPullModelSOPClassRetired = _gdcmswig.UIDs_StorageCommitmentPullModelSOPClassRetired
    StorageCommitmentPullModelSOPInstanceRetired = _gdcmswig.UIDs_StorageCommitmentPullModelSOPInstanceRetired
    ProceduralEventLoggingSOPClass = _gdcmswig.UIDs_ProceduralEventLoggingSOPClass
    ProceduralEventLoggingSOPInstance = _gdcmswig.UIDs_ProceduralEventLoggingSOPInstance
    SubstanceAdministrationLoggingSOPClass = _gdcmswig.UIDs_SubstanceAdministrationLoggingSOPClass
    SubstanceAdministrationLoggingSOPInstance = _gdcmswig.UIDs_SubstanceAdministrationLoggingSOPInstance
    DICOMUIDRegistry = _gdcmswig.UIDs_DICOMUIDRegistry
    DICOMControlledTerminology = _gdcmswig.UIDs_DICOMControlledTerminology
    DICOMApplicationContextName = _gdcmswig.UIDs_DICOMApplicationContextName
    DetachedPatientManagementSOPClassRetired = _gdcmswig.UIDs_DetachedPatientManagementSOPClassRetired
    DetachedPatientManagementMetaSOPClassRetired = _gdcmswig.UIDs_DetachedPatientManagementMetaSOPClassRetired
    DetachedVisitManagementSOPClassRetired = _gdcmswig.UIDs_DetachedVisitManagementSOPClassRetired
    DetachedStudyManagementSOPClassRetired = _gdcmswig.UIDs_DetachedStudyManagementSOPClassRetired
    StudyComponentManagementSOPClassRetired = _gdcmswig.UIDs_StudyComponentManagementSOPClassRetired
    ModalityPerformedProcedureStepSOPClass = _gdcmswig.UIDs_ModalityPerformedProcedureStepSOPClass
    ModalityPerformedProcedureStepRetrieveSOPClass = _gdcmswig.UIDs_ModalityPerformedProcedureStepRetrieveSOPClass
    ModalityPerformedProcedureStepNotificationSOPClass = _gdcmswig.UIDs_ModalityPerformedProcedureStepNotificationSOPClass
    DetachedResultsManagementSOPClassRetired = _gdcmswig.UIDs_DetachedResultsManagementSOPClassRetired
    DetachedResultsManagementMetaSOPClassRetired = _gdcmswig.UIDs_DetachedResultsManagementMetaSOPClassRetired
    DetachedStudyManagementMetaSOPClassRetired = _gdcmswig.UIDs_DetachedStudyManagementMetaSOPClassRetired
    DetachedInterpretationManagementSOPClassRetired = _gdcmswig.UIDs_DetachedInterpretationManagementSOPClassRetired
    StorageServiceClass = _gdcmswig.UIDs_StorageServiceClass
    BasicFilmSessionSOPClass = _gdcmswig.UIDs_BasicFilmSessionSOPClass
    BasicFilmBoxSOPClass = _gdcmswig.UIDs_BasicFilmBoxSOPClass
    BasicGrayscaleImageBoxSOPClass = _gdcmswig.UIDs_BasicGrayscaleImageBoxSOPClass
    BasicColorImageBoxSOPClass = _gdcmswig.UIDs_BasicColorImageBoxSOPClass
    ReferencedImageBoxSOPClassRetired = _gdcmswig.UIDs_ReferencedImageBoxSOPClassRetired
    BasicGrayscalePrintManagementMetaSOPClass = _gdcmswig.UIDs_BasicGrayscalePrintManagementMetaSOPClass
    ReferencedGrayscalePrintManagementMetaSOPClassRetired = _gdcmswig.UIDs_ReferencedGrayscalePrintManagementMetaSOPClassRetired
    PrintJobSOPClass = _gdcmswig.UIDs_PrintJobSOPClass
    BasicAnnotationBoxSOPClass = _gdcmswig.UIDs_BasicAnnotationBoxSOPClass
    PrinterSOPClass = _gdcmswig.UIDs_PrinterSOPClass
    PrinterConfigurationRetrievalSOPClass = _gdcmswig.UIDs_PrinterConfigurationRetrievalSOPClass
    PrinterSOPInstance = _gdcmswig.UIDs_PrinterSOPInstance
    PrinterConfigurationRetrievalSOPInstance = _gdcmswig.UIDs_PrinterConfigurationRetrievalSOPInstance
    BasicColorPrintManagementMetaSOPClass = _gdcmswig.UIDs_BasicColorPrintManagementMetaSOPClass
    ReferencedColorPrintManagementMetaSOPClassRetired = _gdcmswig.UIDs_ReferencedColorPrintManagementMetaSOPClassRetired
    VOILUTBoxSOPClass = _gdcmswig.UIDs_VOILUTBoxSOPClass
    PresentationLUTSOPClass = _gdcmswig.UIDs_PresentationLUTSOPClass
    ImageOverlayBoxSOPClassRetired = _gdcmswig.UIDs_ImageOverlayBoxSOPClassRetired
    BasicPrintImageOverlayBoxSOPClassRetired = _gdcmswig.UIDs_BasicPrintImageOverlayBoxSOPClassRetired
    PrintQueueSOPInstanceRetired = _gdcmswig.UIDs_PrintQueueSOPInstanceRetired
    PrintQueueManagementSOPClassRetired = _gdcmswig.UIDs_PrintQueueManagementSOPClassRetired
    StoredPrintStorageSOPClassRetired = _gdcmswig.UIDs_StoredPrintStorageSOPClassRetired
    HardcopyGrayscaleImageStorageSOPClassRetired = _gdcmswig.UIDs_HardcopyGrayscaleImageStorageSOPClassRetired
    HardcopyColorImageStorageSOPClassRetired = _gdcmswig.UIDs_HardcopyColorImageStorageSOPClassRetired
    PullPrintRequestSOPClassRetired = _gdcmswig.UIDs_PullPrintRequestSOPClassRetired
    PullStoredPrintManagementMetaSOPClassRetired = _gdcmswig.UIDs_PullStoredPrintManagementMetaSOPClassRetired
    MediaCreationManagementSOPClassUID = _gdcmswig.UIDs_MediaCreationManagementSOPClassUID
    ComputedRadiographyImageStorage = _gdcmswig.UIDs_ComputedRadiographyImageStorage
    DigitalXRayImageStorageForPresentation = _gdcmswig.UIDs_DigitalXRayImageStorageForPresentation
    DigitalXRayImageStorageForProcessing = _gdcmswig.UIDs_DigitalXRayImageStorageForProcessing
    DigitalMammographyXRayImageStorageForPresentation = _gdcmswig.UIDs_DigitalMammographyXRayImageStorageForPresentation
    DigitalMammographyXRayImageStorageForProcessing = _gdcmswig.UIDs_DigitalMammographyXRayImageStorageForProcessing
    DigitalIntraoralXRayImageStorageForPresentation = _gdcmswig.UIDs_DigitalIntraoralXRayImageStorageForPresentation
    DigitalIntraoralXRayImageStorageForProcessing = _gdcmswig.UIDs_DigitalIntraoralXRayImageStorageForProcessing
    CTImageStorage = _gdcmswig.UIDs_CTImageStorage
    EnhancedCTImageStorage = _gdcmswig.UIDs_EnhancedCTImageStorage
    UltrasoundMultiframeImageStorageRetired = _gdcmswig.UIDs_UltrasoundMultiframeImageStorageRetired
    UltrasoundMultiframeImageStorage = _gdcmswig.UIDs_UltrasoundMultiframeImageStorage
    MRImageStorage = _gdcmswig.UIDs_MRImageStorage
    EnhancedMRImageStorage = _gdcmswig.UIDs_EnhancedMRImageStorage
    MRSpectroscopyStorage = _gdcmswig.UIDs_MRSpectroscopyStorage
    NuclearMedicineImageStorageRetired = _gdcmswig.UIDs_NuclearMedicineImageStorageRetired
    UltrasoundImageStorageRetired = _gdcmswig.UIDs_UltrasoundImageStorageRetired
    UltrasoundImageStorage = _gdcmswig.UIDs_UltrasoundImageStorage
    SecondaryCaptureImageStorage = _gdcmswig.UIDs_SecondaryCaptureImageStorage
    MultiframeSingleBitSecondaryCaptureImageStorage = _gdcmswig.UIDs_MultiframeSingleBitSecondaryCaptureImageStorage
    MultiframeGrayscaleByteSecondaryCaptureImageStorage = _gdcmswig.UIDs_MultiframeGrayscaleByteSecondaryCaptureImageStorage
    MultiframeGrayscaleWordSecondaryCaptureImageStorage = _gdcmswig.UIDs_MultiframeGrayscaleWordSecondaryCaptureImageStorage
    MultiframeTrueColorSecondaryCaptureImageStorage = _gdcmswig.UIDs_MultiframeTrueColorSecondaryCaptureImageStorage
    StandaloneOverlayStorageRetired = _gdcmswig.UIDs_StandaloneOverlayStorageRetired
    StandaloneCurveStorageRetired = _gdcmswig.UIDs_StandaloneCurveStorageRetired
    WaveformStorageTrialRetired = _gdcmswig.UIDs_WaveformStorageTrialRetired
    ECG12leadWaveformStorage = _gdcmswig.UIDs_ECG12leadWaveformStorage
    GeneralECGWaveformStorage = _gdcmswig.UIDs_GeneralECGWaveformStorage
    AmbulatoryECGWaveformStorage = _gdcmswig.UIDs_AmbulatoryECGWaveformStorage
    HemodynamicWaveformStorage = _gdcmswig.UIDs_HemodynamicWaveformStorage
    CardiacElectrophysiologyWaveformStorage = _gdcmswig.UIDs_CardiacElectrophysiologyWaveformStorage
    BasicVoiceAudioWaveformStorage = _gdcmswig.UIDs_BasicVoiceAudioWaveformStorage
    StandaloneModalityLUTStorageRetired = _gdcmswig.UIDs_StandaloneModalityLUTStorageRetired
    StandaloneVOILUTStorageRetired = _gdcmswig.UIDs_StandaloneVOILUTStorageRetired
    GrayscaleSoftcopyPresentationStateStorageSOPClass = _gdcmswig.UIDs_GrayscaleSoftcopyPresentationStateStorageSOPClass
    ColorSoftcopyPresentationStateStorageSOPClass = _gdcmswig.UIDs_ColorSoftcopyPresentationStateStorageSOPClass
    PseudoColorSoftcopyPresentationStateStorageSOPClass = _gdcmswig.UIDs_PseudoColorSoftcopyPresentationStateStorageSOPClass
    BlendingSoftcopyPresentationStateStorageSOPClass = _gdcmswig.UIDs_BlendingSoftcopyPresentationStateStorageSOPClass
    XRayAngiographicImageStorage = _gdcmswig.UIDs_XRayAngiographicImageStorage
    EnhancedXAImageStorage = _gdcmswig.UIDs_EnhancedXAImageStorage
    XRayRadiofluoroscopicImageStorage = _gdcmswig.UIDs_XRayRadiofluoroscopicImageStorage
    EnhancedXRFImageStorage = _gdcmswig.UIDs_EnhancedXRFImageStorage
    XRay3DAngiographicImageStorage = _gdcmswig.UIDs_XRay3DAngiographicImageStorage
    XRay3DCraniofacialImageStorage = _gdcmswig.UIDs_XRay3DCraniofacialImageStorage
    XRayAngiographicBiPlaneImageStorageRetired = _gdcmswig.UIDs_XRayAngiographicBiPlaneImageStorageRetired
    NuclearMedicineImageStorage = _gdcmswig.UIDs_NuclearMedicineImageStorage
    RawDataStorage = _gdcmswig.UIDs_RawDataStorage
    SpatialRegistrationStorage = _gdcmswig.UIDs_SpatialRegistrationStorage
    SpatialFiducialsStorage = _gdcmswig.UIDs_SpatialFiducialsStorage
    DeformableSpatialRegistrationStorage = _gdcmswig.UIDs_DeformableSpatialRegistrationStorage
    SegmentationStorage = _gdcmswig.UIDs_SegmentationStorage
    RealWorldValueMappingStorage = _gdcmswig.UIDs_RealWorldValueMappingStorage
    VLImageStorageTrialRetired = _gdcmswig.UIDs_VLImageStorageTrialRetired
    VLMultiframeImageStorageTrialRetired = _gdcmswig.UIDs_VLMultiframeImageStorageTrialRetired
    VLEndoscopicImageStorage = _gdcmswig.UIDs_VLEndoscopicImageStorage
    VideoEndoscopicImageStorage = _gdcmswig.UIDs_VideoEndoscopicImageStorage
    VLMicroscopicImageStorage = _gdcmswig.UIDs_VLMicroscopicImageStorage
    VideoMicroscopicImageStorage = _gdcmswig.UIDs_VideoMicroscopicImageStorage
    VLSlideCoordinatesMicroscopicImageStorage = _gdcmswig.UIDs_VLSlideCoordinatesMicroscopicImageStorage
    VLPhotographicImageStorage = _gdcmswig.UIDs_VLPhotographicImageStorage
    VideoPhotographicImageStorage = _gdcmswig.UIDs_VideoPhotographicImageStorage
    OphthalmicPhotography8BitImageStorage = _gdcmswig.UIDs_OphthalmicPhotography8BitImageStorage
    OphthalmicPhotography16BitImageStorage = _gdcmswig.UIDs_OphthalmicPhotography16BitImageStorage
    StereometricRelationshipStorage = _gdcmswig.UIDs_StereometricRelationshipStorage
    OphthalmicTomographyImageStorage = _gdcmswig.UIDs_OphthalmicTomographyImageStorage
    TextSRStorageTrialRetired = _gdcmswig.UIDs_TextSRStorageTrialRetired
    AudioSRStorageTrialRetired = _gdcmswig.UIDs_AudioSRStorageTrialRetired
    DetailSRStorageTrialRetired = _gdcmswig.UIDs_DetailSRStorageTrialRetired
    ComprehensiveSRStorageTrialRetired = _gdcmswig.UIDs_ComprehensiveSRStorageTrialRetired
    BasicTextSRStorage = _gdcmswig.UIDs_BasicTextSRStorage
    EnhancedSRStorage = _gdcmswig.UIDs_EnhancedSRStorage
    ComprehensiveSRStorage = _gdcmswig.UIDs_ComprehensiveSRStorage
    ProcedureLogStorage = _gdcmswig.UIDs_ProcedureLogStorage
    MammographyCADSRStorage = _gdcmswig.UIDs_MammographyCADSRStorage
    KeyObjectSelectionDocumentStorage = _gdcmswig.UIDs_KeyObjectSelectionDocumentStorage
    ChestCADSRStorage = _gdcmswig.UIDs_ChestCADSRStorage
    XRayRadiationDoseSRStorage = _gdcmswig.UIDs_XRayRadiationDoseSRStorage
    EncapsulatedPDFStorage = _gdcmswig.UIDs_EncapsulatedPDFStorage
    EncapsulatedCDAStorage = _gdcmswig.UIDs_EncapsulatedCDAStorage
    PositronEmissionTomographyImageStorage = _gdcmswig.UIDs_PositronEmissionTomographyImageStorage
    StandalonePETCurveStorageRetired = _gdcmswig.UIDs_StandalonePETCurveStorageRetired
    RTImageStorage = _gdcmswig.UIDs_RTImageStorage
    RTDoseStorage = _gdcmswig.UIDs_RTDoseStorage
    RTStructureSetStorage = _gdcmswig.UIDs_RTStructureSetStorage
    RTBeamsTreatmentRecordStorage = _gdcmswig.UIDs_RTBeamsTreatmentRecordStorage
    RTPlanStorage = _gdcmswig.UIDs_RTPlanStorage
    RTBrachyTreatmentRecordStorage = _gdcmswig.UIDs_RTBrachyTreatmentRecordStorage
    RTTreatmentSummaryRecordStorage = _gdcmswig.UIDs_RTTreatmentSummaryRecordStorage
    RTIonPlanStorage = _gdcmswig.UIDs_RTIonPlanStorage
    RTIonBeamsTreatmentRecordStorage = _gdcmswig.UIDs_RTIonBeamsTreatmentRecordStorage
    PatientRootQueryRetrieveInformationModelFIND = _gdcmswig.UIDs_PatientRootQueryRetrieveInformationModelFIND
    PatientRootQueryRetrieveInformationModelMOVE = _gdcmswig.UIDs_PatientRootQueryRetrieveInformationModelMOVE
    PatientRootQueryRetrieveInformationModelGET = _gdcmswig.UIDs_PatientRootQueryRetrieveInformationModelGET
    StudyRootQueryRetrieveInformationModelFIND = _gdcmswig.UIDs_StudyRootQueryRetrieveInformationModelFIND
    StudyRootQueryRetrieveInformationModelMOVE = _gdcmswig.UIDs_StudyRootQueryRetrieveInformationModelMOVE
    StudyRootQueryRetrieveInformationModelGET = _gdcmswig.UIDs_StudyRootQueryRetrieveInformationModelGET
    PatientStudyOnlyQueryRetrieveInformationModelFINDRetired = _gdcmswig.UIDs_PatientStudyOnlyQueryRetrieveInformationModelFINDRetired
    PatientStudyOnlyQueryRetrieveInformationModelMOVERetired = _gdcmswig.UIDs_PatientStudyOnlyQueryRetrieveInformationModelMOVERetired
    PatientStudyOnlyQueryRetrieveInformationModelGETRetired = _gdcmswig.UIDs_PatientStudyOnlyQueryRetrieveInformationModelGETRetired
    ModalityWorklistInformationModelFIND = _gdcmswig.UIDs_ModalityWorklistInformationModelFIND
    GeneralPurposeWorklistInformationModelFIND = _gdcmswig.UIDs_GeneralPurposeWorklistInformationModelFIND
    GeneralPurposeScheduledProcedureStepSOPClass = _gdcmswig.UIDs_GeneralPurposeScheduledProcedureStepSOPClass
    GeneralPurposePerformedProcedureStepSOPClass = _gdcmswig.UIDs_GeneralPurposePerformedProcedureStepSOPClass
    GeneralPurposeWorklistManagementMetaSOPClass = _gdcmswig.UIDs_GeneralPurposeWorklistManagementMetaSOPClass
    InstanceAvailabilityNotificationSOPClass = _gdcmswig.UIDs_InstanceAvailabilityNotificationSOPClass
    RTBeamsDeliveryInstructionStorageSupplement74FrozenDraft = _gdcmswig.UIDs_RTBeamsDeliveryInstructionStorageSupplement74FrozenDraft
    RTConventionalMachineVerificationSupplement74FrozenDraft = _gdcmswig.UIDs_RTConventionalMachineVerificationSupplement74FrozenDraft
    RTIonMachineVerificationSupplement74FrozenDraft = _gdcmswig.UIDs_RTIonMachineVerificationSupplement74FrozenDraft
    UnifiedWorklistandProcedureStepServiceClass = _gdcmswig.UIDs_UnifiedWorklistandProcedureStepServiceClass
    UnifiedProcedureStepPushSOPClass = _gdcmswig.UIDs_UnifiedProcedureStepPushSOPClass
    UnifiedProcedureStepWatchSOPClass = _gdcmswig.UIDs_UnifiedProcedureStepWatchSOPClass
    UnifiedProcedureStepPullSOPClass = _gdcmswig.UIDs_UnifiedProcedureStepPullSOPClass
    UnifiedProcedureStepEventSOPClass = _gdcmswig.UIDs_UnifiedProcedureStepEventSOPClass
    UnifiedWorklistandProcedureStepSOPInstance = _gdcmswig.UIDs_UnifiedWorklistandProcedureStepSOPInstance
    GeneralRelevantPatientInformationQuery = _gdcmswig.UIDs_GeneralRelevantPatientInformationQuery
    BreastImagingRelevantPatientInformationQuery = _gdcmswig.UIDs_BreastImagingRelevantPatientInformationQuery
    CardiacRelevantPatientInformationQuery = _gdcmswig.UIDs_CardiacRelevantPatientInformationQuery
    HangingProtocolStorage = _gdcmswig.UIDs_HangingProtocolStorage
    HangingProtocolInformationModelFIND = _gdcmswig.UIDs_HangingProtocolInformationModelFIND
    HangingProtocolInformationModelMOVE = _gdcmswig.UIDs_HangingProtocolInformationModelMOVE
    ProductCharacteristicsQuerySOPClass = _gdcmswig.UIDs_ProductCharacteristicsQuerySOPClass
    SubstanceApprovalQuerySOPClass = _gdcmswig.UIDs_SubstanceApprovalQuerySOPClass
    dicomDeviceName = _gdcmswig.UIDs_dicomDeviceName
    dicomDescription = _gdcmswig.UIDs_dicomDescription
    dicomManufacturer = _gdcmswig.UIDs_dicomManufacturer
    dicomManufacturerModelName = _gdcmswig.UIDs_dicomManufacturerModelName
    dicomSoftwareVersion = _gdcmswig.UIDs_dicomSoftwareVersion
    dicomVendorData = _gdcmswig.UIDs_dicomVendorData
    dicomAETitle = _gdcmswig.UIDs_dicomAETitle
    dicomNetworkConnectionReference = _gdcmswig.UIDs_dicomNetworkConnectionReference
    dicomApplicationCluster = _gdcmswig.UIDs_dicomApplicationCluster
    dicomAssociationInitiator = _gdcmswig.UIDs_dicomAssociationInitiator
    dicomAssociationAcceptor = _gdcmswig.UIDs_dicomAssociationAcceptor
    dicomHostname = _gdcmswig.UIDs_dicomHostname
    dicomPort = _gdcmswig.UIDs_dicomPort
    dicomSOPClass = _gdcmswig.UIDs_dicomSOPClass
    dicomTransferRole = _gdcmswig.UIDs_dicomTransferRole
    dicomTransferSyntax = _gdcmswig.UIDs_dicomTransferSyntax
    dicomPrimaryDeviceType = _gdcmswig.UIDs_dicomPrimaryDeviceType
    dicomRelatedDeviceReference = _gdcmswig.UIDs_dicomRelatedDeviceReference
    dicomPreferredCalledAETitle = _gdcmswig.UIDs_dicomPreferredCalledAETitle
    dicomTLSCyphersuite = _gdcmswig.UIDs_dicomTLSCyphersuite
    dicomAuthorizedNodeCertificateReference = _gdcmswig.UIDs_dicomAuthorizedNodeCertificateReference
    dicomThisNodeCertificateReference = _gdcmswig.UIDs_dicomThisNodeCertificateReference
    dicomInstalled = _gdcmswig.UIDs_dicomInstalled
    dicomStationName = _gdcmswig.UIDs_dicomStationName
    dicomDeviceSerialNumber = _gdcmswig.UIDs_dicomDeviceSerialNumber
    dicomInstitutionName = _gdcmswig.UIDs_dicomInstitutionName
    dicomInstitutionAddress = _gdcmswig.UIDs_dicomInstitutionAddress
    dicomInstitutionDepartmentName = _gdcmswig.UIDs_dicomInstitutionDepartmentName
    dicomIssuerOfPatientID = _gdcmswig.UIDs_dicomIssuerOfPatientID
    dicomPreferredCallingAETitle = _gdcmswig.UIDs_dicomPreferredCallingAETitle
    dicomSupportedCharacterSet = _gdcmswig.UIDs_dicomSupportedCharacterSet
    dicomConfigurationRoot = _gdcmswig.UIDs_dicomConfigurationRoot
    dicomDevicesRoot = _gdcmswig.UIDs_dicomDevicesRoot
    dicomUniqueAETitlesRegistryRoot = _gdcmswig.UIDs_dicomUniqueAETitlesRegistryRoot
    dicomDevice = _gdcmswig.UIDs_dicomDevice
    dicomNetworkAE = _gdcmswig.UIDs_dicomNetworkAE
    dicomNetworkConnection = _gdcmswig.UIDs_dicomNetworkConnection
    dicomUniqueAETitle = _gdcmswig.UIDs_dicomUniqueAETitle
    dicomTransferCapability = _gdcmswig.UIDs_dicomTransferCapability
    VLWholeSlideMicroscopyImageStorage = _gdcmswig.UIDs_VLWholeSlideMicroscopyImageStorage
    EnhancedUSVolumeStorage = _gdcmswig.UIDs_EnhancedUSVolumeStorage
    SurfaceSegmentationStorage = _gdcmswig.UIDs_SurfaceSegmentationStorage
    BreastTomosynthesisImageStorage = _gdcmswig.UIDs_BreastTomosynthesisImageStorage
    LegacyConvertedEnhancedCTImageStorage = _gdcmswig.UIDs_LegacyConvertedEnhancedCTImageStorage
    LegacyConvertedEnhancedMRImageStorage = _gdcmswig.UIDs_LegacyConvertedEnhancedMRImageStorage
    LegacyConvertedEnhancedPETImageStorage = _gdcmswig.UIDs_LegacyConvertedEnhancedPETImageStorage
    MPEG2MainProfileHighLevel = _gdcmswig.UIDs_MPEG2MainProfileHighLevel
    MPEG4AVCH_264HighProfileLevel4_1 = _gdcmswig.UIDs_MPEG4AVCH_264HighProfileLevel4_1
    MPEG4AVCH_264BDcompatibleHighProfileLevel4_1 = _gdcmswig.UIDs_MPEG4AVCH_264BDcompatibleHighProfileLevel4_1
    PETColorPaletteSOPInstance = _gdcmswig.UIDs_PETColorPaletteSOPInstance
    HotMetalBlueColorPaletteSOPInstance = _gdcmswig.UIDs_HotMetalBlueColorPaletteSOPInstance
    PET20StepColorPaletteSOPInstance = _gdcmswig.UIDs_PET20StepColorPaletteSOPInstance
    SpringColorPaletteSOPInstance = _gdcmswig.UIDs_SpringColorPaletteSOPInstance
    SummerColorPaletteSOPInstance = _gdcmswig.UIDs_SummerColorPaletteSOPInstance
    FallColorPaletteSOPInstance = _gdcmswig.UIDs_FallColorPaletteSOPInstance
    WinterColorPaletteSOPInstance = _gdcmswig.UIDs_WinterColorPaletteSOPInstance
    Papyrus3ImplicitVRLittleEndian = _gdcmswig.UIDs_Papyrus3ImplicitVRLittleEndian
    AdultMouseAnatomyOntology = _gdcmswig.UIDs_AdultMouseAnatomyOntology
    UberonOntology = _gdcmswig.UIDs_UberonOntology
    IntegratedTaxonomicInformationSystemITISTaxonomicSerialNumberTSN = _gdcmswig.UIDs_IntegratedTaxonomicInformationSystemITISTaxonomicSerialNumberTSN
    MouseGenomeInitiativeMGI = _gdcmswig.UIDs_MouseGenomeInitiativeMGI
    PubChemCompoundCID = _gdcmswig.UIDs_PubChemCompoundCID
    ICD11 = _gdcmswig.UIDs_ICD11
    NewYorkUniversityMelanomaClinicalCooperativeGroup = _gdcmswig.UIDs_NewYorkUniversityMelanomaClinicalCooperativeGroup
    MayoClinicNonradiologicalImagesSBSAnatomicalSurfaceRegionGuide = _gdcmswig.UIDs_MayoClinicNonradiologicalImagesSBSAnatomicalSurfaceRegionGuide
    ImageBiomarkerStandardisationInitiative = _gdcmswig.UIDs_ImageBiomarkerStandardisationInitiative
    RadiomicsOntology = _gdcmswig.UIDs_RadiomicsOntology
    DisplaySystemSOPClass = _gdcmswig.UIDs_DisplaySystemSOPClass
    DisplaySystemSOPInstance = _gdcmswig.UIDs_DisplaySystemSOPInstance
    GeneralAudioWaveformStorage = _gdcmswig.UIDs_GeneralAudioWaveformStorage
    ArterialPulseWaveformStorage = _gdcmswig.UIDs_ArterialPulseWaveformStorage
    RespiratoryWaveformStorage = _gdcmswig.UIDs_RespiratoryWaveformStorage
    XAXRFGrayscaleSoftcopyPresentationStateStorage = _gdcmswig.UIDs_XAXRFGrayscaleSoftcopyPresentationStateStorage
    GrayscalePlanarMPRVolumetricPresentationStateStorage = _gdcmswig.UIDs_GrayscalePlanarMPRVolumetricPresentationStateStorage
    MPEG4AVCH_264HighProfileLevel4_2For2DVideo = _gdcmswig.UIDs_MPEG4AVCH_264HighProfileLevel4_2For2DVideo
    MPEG4AVCH_264HighProfileLevel4_2For3DVideo = _gdcmswig.UIDs_MPEG4AVCH_264HighProfileLevel4_2For3DVideo
    MPEG4AVCH_264StereoHighProfileLevel4_2 = _gdcmswig.UIDs_MPEG4AVCH_264StereoHighProfileLevel4_2
    HEVCH_265MainProfileLevel5_1 = _gdcmswig.UIDs_HEVCH_265MainProfileLevel5_1
    HEVCH_265Main10ProfileLevel5_1 = _gdcmswig.UIDs_HEVCH_265Main10ProfileLevel5_1
    HotIronColorPaletteSOPInstance = _gdcmswig.UIDs_HotIronColorPaletteSOPInstance
    CompositingPlanarMPRVolumetricPresentationStateStorage = _gdcmswig.UIDs_CompositingPlanarMPRVolumetricPresentationStateStorage
    AdvancedBlendingPresentationStateStorage = _gdcmswig.UIDs_AdvancedBlendingPresentationStateStorage
    VolumeRenderingVolumetricPresentationStateStorage = _gdcmswig.UIDs_VolumeRenderingVolumetricPresentationStateStorage
    SegmentedVolumeRenderingVolumetricPresentationStateStorage = _gdcmswig.UIDs_SegmentedVolumeRenderingVolumetricPresentationStateStorage
    MultipleVolumeRenderingVolumetricPresentationStateStorage = _gdcmswig.UIDs_MultipleVolumeRenderingVolumetricPresentationStateStorage
    Null0 = _gdcmswig.UIDs_Null0
    BreastProjectionXRayImageStorageForPresentation = _gdcmswig.UIDs_BreastProjectionXRayImageStorageForPresentation
    BreastProjectionXRayImageStorageForProcessing = _gdcmswig.UIDs_BreastProjectionXRayImageStorageForProcessing
    IntravascularOpticalCoherenceTomographyImageStorageForPresentation = _gdcmswig.UIDs_IntravascularOpticalCoherenceTomographyImageStorageForPresentation
    IntravascularOpticalCoherenceTomographyImageStorageForProcessing = _gdcmswig.UIDs_IntravascularOpticalCoherenceTomographyImageStorageForProcessing
    ParametricMapStorage = _gdcmswig.UIDs_ParametricMapStorage
    Null1 = _gdcmswig.UIDs_Null1
    TractographyResultsStorage = _gdcmswig.UIDs_TractographyResultsStorage
    SurfaceScanMeshStorage = _gdcmswig.UIDs_SurfaceScanMeshStorage
    SurfaceScanPointCloudStorage = _gdcmswig.UIDs_SurfaceScanPointCloudStorage
    WideFieldOphthalmicPhotographyStereographicProjectionImageStorage = _gdcmswig.UIDs_WideFieldOphthalmicPhotographyStereographicProjectionImageStorage
    WideFieldOphthalmicPhotography3DCoordinatesImageStorage = _gdcmswig.UIDs_WideFieldOphthalmicPhotography3DCoordinatesImageStorage
    OphthalmicOpticalCoherenceTomographyEnFaceImageStorage = _gdcmswig.UIDs_OphthalmicOpticalCoherenceTomographyEnFaceImageStorage
    OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage = _gdcmswig.UIDs_OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage
    LensometryMeasurementsStorage = _gdcmswig.UIDs_LensometryMeasurementsStorage
    AutorefractionMeasurementsStorage = _gdcmswig.UIDs_AutorefractionMeasurementsStorage
    KeratometryMeasurementsStorage = _gdcmswig.UIDs_KeratometryMeasurementsStorage
    SubjectiveRefractionMeasurementsStorage = _gdcmswig.UIDs_SubjectiveRefractionMeasurementsStorage
    VisualAcuityMeasurementsStorage = _gdcmswig.UIDs_VisualAcuityMeasurementsStorage
    SpectaclePrescriptionReportStorage = _gdcmswig.UIDs_SpectaclePrescriptionReportStorage
    OphthalmicAxialMeasurementsStorage = _gdcmswig.UIDs_OphthalmicAxialMeasurementsStorage
    IntraocularLensCalculationsStorage = _gdcmswig.UIDs_IntraocularLensCalculationsStorage
    MacularGridThicknessandVolumeReportStorage = _gdcmswig.UIDs_MacularGridThicknessandVolumeReportStorage
    OphthalmicVisualFieldStaticPerimetryMeasurementsStorage = _gdcmswig.UIDs_OphthalmicVisualFieldStaticPerimetryMeasurementsStorage
    OphthalmicThicknessMapStorage = _gdcmswig.UIDs_OphthalmicThicknessMapStorage
    CornealTopographyMapStorage = _gdcmswig.UIDs_CornealTopographyMapStorage
    Comprehensive3DSRStorage = _gdcmswig.UIDs_Comprehensive3DSRStorage
    ExtensibleSRStorage = _gdcmswig.UIDs_ExtensibleSRStorage
    RadiopharmaceuticalRadiationDoseSRStorage = _gdcmswig.UIDs_RadiopharmaceuticalRadiationDoseSRStorage
    ColonCADSRStorage = _gdcmswig.UIDs_ColonCADSRStorage
    ImplantationPlanSRStorage = _gdcmswig.UIDs_ImplantationPlanSRStorage
    AcquisitionContextSRStorage = _gdcmswig.UIDs_AcquisitionContextSRStorage
    SimplifiedAdultEchoSRStorage = _gdcmswig.UIDs_SimplifiedAdultEchoSRStorage
    PatientRadiationDoseSRStorage = _gdcmswig.UIDs_PatientRadiationDoseSRStorage
    PlannedImagingAgentAdministrationSRStorage = _gdcmswig.UIDs_PlannedImagingAgentAdministrationSRStorage
    PerformedImagingAgentAdministrationSRStorage = _gdcmswig.UIDs_PerformedImagingAgentAdministrationSRStorage
    ContentAssessmentResultsStorage = _gdcmswig.UIDs_ContentAssessmentResultsStorage
    EncapsulatedSTLStorage = _gdcmswig.UIDs_EncapsulatedSTLStorage
    EnhancedPETImageStorage = _gdcmswig.UIDs_EnhancedPETImageStorage
    BasicStructuredDisplayStorage = _gdcmswig.UIDs_BasicStructuredDisplayStorage
    CTDefinedProcedureProtocolStorage = _gdcmswig.UIDs_CTDefinedProcedureProtocolStorage
    CTPerformedProcedureProtocolStorage = _gdcmswig.UIDs_CTPerformedProcedureProtocolStorage
    ProtocolApprovalStorage = _gdcmswig.UIDs_ProtocolApprovalStorage
    ProtocolApprovalInformationModelFIND = _gdcmswig.UIDs_ProtocolApprovalInformationModelFIND
    ProtocolApprovalInformationModelMOVE = _gdcmswig.UIDs_ProtocolApprovalInformationModelMOVE
    ProtocolApprovalInformationModelGET = _gdcmswig.UIDs_ProtocolApprovalInformationModelGET
    RTPhysicianIntentStorage = _gdcmswig.UIDs_RTPhysicianIntentStorage
    RTSegmentAnnotationStorage = _gdcmswig.UIDs_RTSegmentAnnotationStorage
    DICOSCTImageStorage = _gdcmswig.UIDs_DICOSCTImageStorage
    DICOSDigitalXRayImageStorageForPresentation = _gdcmswig.UIDs_DICOSDigitalXRayImageStorageForPresentation
    DICOSDigitalXRayImageStorageForProcessing = _gdcmswig.UIDs_DICOSDigitalXRayImageStorageForProcessing
    DICOSThreatDetectionReportStorage = _gdcmswig.UIDs_DICOSThreatDetectionReportStorage
    DICOS2DAITStorage = _gdcmswig.UIDs_DICOS2DAITStorage
    DICOS3DAITStorage = _gdcmswig.UIDs_DICOS3DAITStorage
    DICOSQuadrupoleResonanceQRStorage = _gdcmswig.UIDs_DICOSQuadrupoleResonanceQRStorage
    EddyCurrentImageStorage = _gdcmswig.UIDs_EddyCurrentImageStorage
    EddyCurrentMultiframeImageStorage = _gdcmswig.UIDs_EddyCurrentMultiframeImageStorage
    CompositeInstanceRootRetrieveMOVE = _gdcmswig.UIDs_CompositeInstanceRootRetrieveMOVE
    CompositeInstanceRootRetrieveGET = _gdcmswig.UIDs_CompositeInstanceRootRetrieveGET
    CompositeInstanceRetrieveWithoutBulkDataGET = _gdcmswig.UIDs_CompositeInstanceRetrieveWithoutBulkDataGET
    DefinedProcedureProtocolInformationModelFIND = _gdcmswig.UIDs_DefinedProcedureProtocolInformationModelFIND
    DefinedProcedureProtocolInformationModelMOVE = _gdcmswig.UIDs_DefinedProcedureProtocolInformationModelMOVE
    DefinedProcedureProtocolInformationModelGET = _gdcmswig.UIDs_DefinedProcedureProtocolInformationModelGET
    UPSFilteredGlobalSubscriptionSOPInstance = _gdcmswig.UIDs_UPSFilteredGlobalSubscriptionSOPInstance
    UnifiedWorklistandProcedureStepServiceClass1 = _gdcmswig.UIDs_UnifiedWorklistandProcedureStepServiceClass1
    UnifiedProcedureStepPushSOPClass1 = _gdcmswig.UIDs_UnifiedProcedureStepPushSOPClass1
    UnifiedProcedureStepWatchSOPClass1 = _gdcmswig.UIDs_UnifiedProcedureStepWatchSOPClass1
    UnifiedProcedureStepPullSOPClass1 = _gdcmswig.UIDs_UnifiedProcedureStepPullSOPClass1
    UnifiedProcedureStepEventSOPClass1 = _gdcmswig.UIDs_UnifiedProcedureStepEventSOPClass1
    RTBeamsDeliveryInstructionStorage = _gdcmswig.UIDs_RTBeamsDeliveryInstructionStorage
    RTConventionalMachineVerification = _gdcmswig.UIDs_RTConventionalMachineVerification
    RTIonMachineVerification = _gdcmswig.UIDs_RTIonMachineVerification
    RTBrachyApplicationSetupDeliveryInstructionStorage = _gdcmswig.UIDs_RTBrachyApplicationSetupDeliveryInstructionStorage
    HangingProtocolInformationModelGET = _gdcmswig.UIDs_HangingProtocolInformationModelGET
    ColorPaletteStorage = _gdcmswig.UIDs_ColorPaletteStorage
    ColorPaletteQueryRetrieveInformationModelFIND = _gdcmswig.UIDs_ColorPaletteQueryRetrieveInformationModelFIND
    ColorPaletteQueryRetrieveInformationModelMOVE = _gdcmswig.UIDs_ColorPaletteQueryRetrieveInformationModelMOVE
    ColorPaletteQueryRetrieveInformationModelGET = _gdcmswig.UIDs_ColorPaletteQueryRetrieveInformationModelGET
    GenericImplantTemplateStorage = _gdcmswig.UIDs_GenericImplantTemplateStorage
    GenericImplantTemplateInformationModelFIND = _gdcmswig.UIDs_GenericImplantTemplateInformationModelFIND
    GenericImplantTemplateInformationModelMOVE = _gdcmswig.UIDs_GenericImplantTemplateInformationModelMOVE
    GenericImplantTemplateInformationModelGET = _gdcmswig.UIDs_GenericImplantTemplateInformationModelGET
    ImplantAssemblyTemplateStorage = _gdcmswig.UIDs_ImplantAssemblyTemplateStorage
    ImplantAssemblyTemplateInformationModelFIND = _gdcmswig.UIDs_ImplantAssemblyTemplateInformationModelFIND
    ImplantAssemblyTemplateInformationModelMOVE = _gdcmswig.UIDs_ImplantAssemblyTemplateInformationModelMOVE
    ImplantAssemblyTemplateInformationModelGET = _gdcmswig.UIDs_ImplantAssemblyTemplateInformationModelGET
    ImplantTemplateGroupStorage = _gdcmswig.UIDs_ImplantTemplateGroupStorage
    ImplantTemplateGroupInformationModelFIND = _gdcmswig.UIDs_ImplantTemplateGroupInformationModelFIND
    ImplantTemplateGroupInformationModelMOVE = _gdcmswig.UIDs_ImplantTemplateGroupInformationModelMOVE
    ImplantTemplateGroupInformationModelGET = _gdcmswig.UIDs_ImplantTemplateGroupInformationModelGET
    NativeDICOMModel = _gdcmswig.UIDs_NativeDICOMModel
    AbstractMultiDimensionalImageModel = _gdcmswig.UIDs_AbstractMultiDimensionalImageModel
    DICOMContentMappingResource = _gdcmswig.UIDs_DICOMContentMappingResource
    EnhancedMRColorImageStorage = _gdcmswig.UIDs_EnhancedMRColorImageStorage
    UniversalCoordinatedTime = _gdcmswig.UIDs_UniversalCoordinatedTime

    @staticmethod
    def GetTransferSyntaxStrings():
        return _gdcmswig.UIDs_GetTransferSyntaxStrings()

    @staticmethod
    def GetTransferSyntaxString(ts):
        return _gdcmswig.UIDs_GetTransferSyntaxString(ts)

    @staticmethod
    def GetNumberOfTransferSyntaxStrings():
        return _gdcmswig.UIDs_GetNumberOfTransferSyntaxStrings()

    @staticmethod
    def GetUIDString(ts):
        return _gdcmswig.UIDs_GetUIDString(ts)

    @staticmethod
    def GetUIDName(ts):
        return _gdcmswig.UIDs_GetUIDName(ts)

    def SetFromUID(self, str):
        r"""
        bool
        gdcm::UIDs::SetFromUID(const char *str)

        Initialize object from a string (a uid number) return false on error,
        and internal state is set to 0 
        """
        return _gdcmswig.UIDs_SetFromUID(self, str)

    def GetName(self):
        r"""
        const char*
        gdcm::UIDs::GetName() const

        When object is Initialize function return the well known name
        associated with uid return NULL when not initialized 
        """
        return _gdcmswig.UIDs_GetName(self)

    def GetString(self):
        r"""
        const char*
        gdcm::UIDs::GetString() const

        When object is Initialize function return the uid return NULL when not
        initialized 
        """
        return _gdcmswig.UIDs_GetString(self)

    def __init__(self):
        _gdcmswig.UIDs_swiginit(self, _gdcmswig.new_UIDs())

    def __str__(self):
        return _gdcmswig.UIDs___str__(self)
    __swig_destroy__ = _gdcmswig.delete_UIDs

# Register UIDs in _gdcmswig:
_gdcmswig.UIDs_swigregister(UIDs)
class Sorter(object):
    r"""


    Sorter.

    General class to do sorting using a custom function You simply need to
    provide a function of type: Sorter::SortFunction

    WARNING:  implementation details. For now there is no cache mechanism.
    Which means that every time you call Sort, all files specified as
    input parameter are read

    See:   Scanner

    C++ includes: gdcmSorter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Sorter::Sorter()

        """
        _gdcmswig.Sorter_swiginit(self, _gdcmswig.new_Sorter())
    __swig_destroy__ = _gdcmswig.delete_Sorter

    def Sort(self, filenames):
        r"""
        virtual bool
        gdcm::Sorter::Sort(std::vector< std::string > const &filenames)

        Typically the output of Directory::GetFilenames() 
        """
        return _gdcmswig.Sorter_Sort(self, filenames)

    def GetFilenames(self):
        r"""
        const
        std::vector<std::string>& gdcm::Sorter::GetFilenames() const

        Return the list of filenames as sorted by the specific algorithm used.
        Empty by default (before Sort() is called) 
        """
        return _gdcmswig.Sorter_GetFilenames(self)

    def Print(self, os):
        r"""
        void
        gdcm::Sorter::Print(std::ostream &os) const

        Print. 
        """
        return _gdcmswig.Sorter_Print(self, os)

    def AddSelect(self, tag, value):
        r"""
        bool
        gdcm::Sorter::AddSelect(Tag const &tag, const char *value)

        UNSUPPORTED FOR NOW. 
        """
        return _gdcmswig.Sorter_AddSelect(self, tag, value)

    def SetTagsToRead(self, tags):
        r"""
        void
        gdcm::Sorter::SetTagsToRead(std::set< Tag > const &tags)

        Specify a set of tags to be read in during the sort procedure. By
        default this set is empty, in which case the entire image, including
        pixel data, is read in. 
        """
        return _gdcmswig.Sorter_SetTagsToRead(self, tags)

    def SetSortFunction(self, f):
        r"""
        void
        gdcm::Sorter::SetSortFunction(SortFunction f) 
        """
        return _gdcmswig.Sorter_SetSortFunction(self, f)

    def StableSort(self, filenames):
        r"""
        virtual bool
        gdcm::Sorter::StableSort(std::vector< std::string > const &filenames)

        """
        return _gdcmswig.Sorter_StableSort(self, filenames)

    def __str__(self):
        return _gdcmswig.Sorter___str__(self)

# Register Sorter in _gdcmswig:
_gdcmswig.Sorter_swigregister(Sorter)
class IPPSorter(Sorter):
    r"""


    IPPSorter.

    Implement a simple Image Position ( Patient) sorter, along the Image
    Orientation ( Patient) direction. This algorithm does NOT support
    duplicate and will FAIL in case of duplicate IPP. WARNING:  See
    special note for SetZSpacingTolerance when computing the ZSpacing from
    the IPP of each DICOM files (default tolerance for consistent spacing
    is: 1e-6mm)  For more information on Spacing, and how it is defined in
    DICOM, advanced users may refers to:

    http://gdcm.sourceforge.net/wiki/index.php/Imager_Pixel_Spacing

    Bug There are currently a couple of bugs in this implementation:

    Gantry Tilt is not considered (always an error)

    Application programmer should only sort valid DataSet (eg.
    MRImageStorage, CTImageStorage, PETImageStorage)

    C++ includes: gdcmIPPSorter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::IPPSorter::IPPSorter()"""
        _gdcmswig.IPPSorter_swiginit(self, _gdcmswig.new_IPPSorter())

    def Sort(self, filenames):
        r"""
        bool
        gdcm::IPPSorter::Sort(std::vector< std::string > const &filenames)
        override

        Main entry point to the sorter. It will execute the filter, option
        should be set before running this function (SetZSpacingTolerance, ...)
        Return value indicate if sorting could be achieved,. Warning this does
        NOT imply that spacing is consistent, it only means the file are
        sorted according to IPP You should check if ZSpacing is 0 or not to
        deduce if file are actually a 3D volume 
        """
        return _gdcmswig.IPPSorter_Sort(self, filenames)

    def SetComputeZSpacing(self, b):
        r"""
        void
        gdcm::IPPSorter::SetComputeZSpacing(bool b)

        Functions related to Z-Spacing computation Set to true when sort
        algorithm should also perform a regular Z-Spacing computation using
        the Image Position ( Patient) Potential reason for failure: ALL slices
        are taken into account, if one slice if missing then ZSpacing will be
        set to 0 since the spacing will not be found to be regular along the
        Series 
        """
        return _gdcmswig.IPPSorter_SetComputeZSpacing(self, b)

    def SetZSpacingTolerance(self, tol):
        r"""
        void
        gdcm::IPPSorter::SetZSpacingTolerance(double tol)

        Another reason for failure is that that Z-Spacing is only slightly
        changing (eg 1e-3) along the series, a human can determine that this
        is ok and change the tolerance from its default value: 1e-6 
        """
        return _gdcmswig.IPPSorter_SetZSpacingTolerance(self, tol)

    def GetZSpacingTolerance(self):
        r"""
        double
        gdcm::IPPSorter::GetZSpacingTolerance() const 
        """
        return _gdcmswig.IPPSorter_GetZSpacingTolerance(self)

    def SetDirectionCosinesTolerance(self, tol):
        r"""
        void gdcm::IPPSorter::SetDirectionCosinesTolerance(double tol)

        Sometimes IOP along a series is slightly changing for example:
        "0.999081\\\\0.0426953\\\\0.00369272\\\\-0.0419025\\\\0.955059\\\\0.293439",
        "0.999081\\\\0.0426953\\\\0.00369275\\\\-0.0419025\\\\0.955059\\\\0.293439",
        "0.999081\\\\0.0426952\\\\0.00369272\\\\-0.0419025\\\\0.955059\\\\0.293439",
        We need an API to define the tolerance which is allowed. Internally
        the cross vector of each direction cosines is computed. The tolerance
        then define the distance in between 1.0 to the dot product of those
        cross vectors. In a perfect world this dot product is of course 1.0
        which imply a DirectionCosines tolerance of exactly 0.0 (default). 
        """
        return _gdcmswig.IPPSorter_SetDirectionCosinesTolerance(self, tol)

    def GetDirectionCosinesTolerance(self):
        r"""double gdcm::IPPSorter::GetDirectionCosinesTolerance() const"""
        return _gdcmswig.IPPSorter_GetDirectionCosinesTolerance(self)

    def SetDropDuplicatePositions(self, b):
        r"""
        void gdcm::IPPSorter::SetDropDuplicatePositions(bool b)

        Makes the IPPSorter ignore multiple images located at the same
        position. Only the first occurrence will be kept.
        DropDuplicatePositions defaults to false. 
        """
        return _gdcmswig.IPPSorter_SetDropDuplicatePositions(self, b)

    def GetZSpacing(self):
        r"""
        double
        gdcm::IPPSorter::GetZSpacing() const

        Read-only function to provide access to the computed value for the
        Z-Spacing The ComputeZSpacing must have been set to true before
        execution of sort algorithm. Call this function after calling Sort();
        Z-Spacing will be 0 on 2 occasions: Sorting simply failed, potentially
        duplicate IPP => ZSpacing = 0

        ZSpacing could not be computed (Z-Spacing is not constant, or
        ZTolerance is too low) 
        """
        return _gdcmswig.IPPSorter_GetZSpacing(self)

    def __str__(self):
        return _gdcmswig.IPPSorter___str__(self)
    __swig_destroy__ = _gdcmswig.delete_IPPSorter

# Register IPPSorter in _gdcmswig:
_gdcmswig.IPPSorter_swigregister(IPPSorter)
class Spectroscopy(object):
    r"""


    Spectroscopy class.

    C++ includes: gdcmSpectroscopy.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Spectroscopy::Spectroscopy()=default"""
        _gdcmswig.Spectroscopy_swiginit(self, _gdcmswig.new_Spectroscopy())
    __swig_destroy__ = _gdcmswig.delete_Spectroscopy

# Register Spectroscopy in _gdcmswig:
_gdcmswig.Spectroscopy_swigregister(Spectroscopy)
class Printer(object):
    r"""


    Printer class.

    C++ includes: gdcmPrinter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Printer::Printer()"""
        _gdcmswig.Printer_swiginit(self, _gdcmswig.new_Printer())
    __swig_destroy__ = _gdcmswig.delete_Printer

    def SetFile(self, f):
        r"""
        void
        gdcm::Printer::SetFile(File const &f)

        Set file. 
        """
        return _gdcmswig.Printer_SetFile(self, f)

    def SetColor(self, c):
        r"""
        void
        gdcm::Printer::SetColor(bool c)

        Set color mode or not. 
        """
        return _gdcmswig.Printer_SetColor(self, c)
    VERBOSE_STYLE = _gdcmswig.Printer_VERBOSE_STYLE
    CONDENSED_STYLE = _gdcmswig.Printer_CONDENSED_STYLE
    XML = _gdcmswig.Printer_XML
    CXX = _gdcmswig.Printer_CXX

    def SetStyle(self, ps):
        r"""
        void
        gdcm::Printer::SetStyle(PrintStyles ps)

        Set PrintStyle value. 
        """
        return _gdcmswig.Printer_SetStyle(self, ps)

    def GetPrintStyle(self):
        r"""
        PrintStyles
        gdcm::Printer::GetPrintStyle() const

        Get PrintStyle value. 
        """
        return _gdcmswig.Printer_GetPrintStyle(self)

    def Print(self, os):
        r"""
        void
        gdcm::Printer::Print(std::ostream &os)

        Print. 
        """
        return _gdcmswig.Printer_Print(self, os)

    def PrintDataSet(self, *args):
        r"""
        void
        gdcm::Printer::PrintDataSet(const DataSet &ds, std::ostream &os, const
        std::string &s="")

        Print an individual dataset. 
        """
        return _gdcmswig.Printer_PrintDataSet(self, *args)

# Register Printer in _gdcmswig:
_gdcmswig.Printer_swigregister(Printer)
class XMLPrinter(object):
    r"""
    C++ includes:
    gdcmXMLPrinter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::XMLPrinter::XMLPrinter()"""
        _gdcmswig.XMLPrinter_swiginit(self, _gdcmswig.new_XMLPrinter())
    __swig_destroy__ = _gdcmswig.delete_XMLPrinter

    def SetFile(self, f):
        r"""
        void
        gdcm::XMLPrinter::SetFile(File const &f) 
        """
        return _gdcmswig.XMLPrinter_SetFile(self, f)
    OnlyUUID = _gdcmswig.XMLPrinter_OnlyUUID
    LOADBULKDATA = _gdcmswig.XMLPrinter_LOADBULKDATA

    def SetStyle(self, ps):
        r"""
        void
        gdcm::XMLPrinter::SetStyle(PrintStyles ps) 
        """
        return _gdcmswig.XMLPrinter_SetStyle(self, ps)

    def GetPrintStyle(self):
        r"""
        PrintStyles
        gdcm::XMLPrinter::GetPrintStyle() const 
        """
        return _gdcmswig.XMLPrinter_GetPrintStyle(self)

    def Print(self, os):
        r"""
        void
        gdcm::XMLPrinter::Print(std::ostream &os) 
        """
        return _gdcmswig.XMLPrinter_Print(self, os)

    def PrintDataSet(self, ds, ts, os):
        r"""
        void
        gdcm::XMLPrinter::PrintDataSet(const DataSet &ds, const TransferSyntax
        &ts, std::ostream &os) 
        """
        return _gdcmswig.XMLPrinter_PrintDataSet(self, ds, ts, os)

    def HandleBulkData(self, uuid, ts, bulkdata, bulklen):
        r"""
        virtual void
        gdcm::XMLPrinter::HandleBulkData(const char *uuid, const
        TransferSyntax &ts, const char *bulkdata, size_t bulklen)

        Virtual function mechanism to allow application programmer to override
        the default mechanism for BulkData handling. By default GDCM will
        simply discard the BulkData and only write the UUID 
        """
        return _gdcmswig.XMLPrinter_HandleBulkData(self, uuid, ts, bulkdata, bulklen)

# Register XMLPrinter in _gdcmswig:
_gdcmswig.XMLPrinter_swigregister(XMLPrinter)
class Dumper(Printer):
    r"""


    Codec class.

    Use it to simply dump value read from the file. No interpretation is
    done. But it is real fast ! Almost no overhead

    C++ includes: gdcmDumper.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Dumper::Dumper()

        """
        _gdcmswig.Dumper_swiginit(self, _gdcmswig.new_Dumper())
    __swig_destroy__ = _gdcmswig.delete_Dumper

# Register Dumper in _gdcmswig:
_gdcmswig.Dumper_swigregister(Dumper)
class Orientation(object):
    r"""


    class to handle Orientation

    C++ includes: gdcmOrientation.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Orientation::Orientation()"""
        _gdcmswig.Orientation_swiginit(self, _gdcmswig.new_Orientation())
    __swig_destroy__ = _gdcmswig.delete_Orientation

    def Print(self, arg2):
        r"""
        void
        gdcm::Orientation::Print(std::ostream &) const

        Print. 
        """
        return _gdcmswig.Orientation_Print(self, arg2)
    UNKNOWN = _gdcmswig.Orientation_UNKNOWN
    AXIAL = _gdcmswig.Orientation_AXIAL
    CORONAL = _gdcmswig.Orientation_CORONAL
    SAGITTAL = _gdcmswig.Orientation_SAGITTAL
    OBLIQUE = _gdcmswig.Orientation_OBLIQUE

    @staticmethod
    def GetType(dircos):
        return _gdcmswig.Orientation_GetType(dircos)

    @staticmethod
    def SetObliquityThresholdCosineValue(val):
        return _gdcmswig.Orientation_SetObliquityThresholdCosineValue(val)

    @staticmethod
    def GetObliquityThresholdCosineValue():
        return _gdcmswig.Orientation_GetObliquityThresholdCosineValue()

    @staticmethod
    def GetLabel(type):
        return _gdcmswig.Orientation_GetLabel(type)

    def __str__(self):
        return _gdcmswig.Orientation___str__(self)

# Register Orientation in _gdcmswig:
_gdcmswig.Orientation_swigregister(Orientation)
class DirectionCosines(object):
    r"""


    class to handle DirectionCosines

    C++ includes: gdcmDirectionCosines.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::DirectionCosines::DirectionCosines(const double dircos[6])"""
        _gdcmswig.DirectionCosines_swiginit(self, _gdcmswig.new_DirectionCosines(*args))
    __swig_destroy__ = _gdcmswig.delete_DirectionCosines

    def Print(self, arg2):
        r"""
        void
        gdcm::DirectionCosines::Print(std::ostream &) const

        Print. 
        """
        return _gdcmswig.DirectionCosines_Print(self, arg2)

    def Cross(self, z):
        r"""
        void
        gdcm::DirectionCosines::Cross(double z[3]) const

        Compute Cross product. 
        """
        return _gdcmswig.DirectionCosines_Cross(self, z)

    @staticmethod
    def Dot(*args):
        r"""
        double
        gdcm::DirectionCosines::Dot() const

        Compute Dot. 
        """
        return _gdcmswig.DirectionCosines_Dot(*args)

    @staticmethod
    def Normalize(*args):
        r"""
        void
        gdcm::DirectionCosines::Normalize()

        Normalize in-place. 
        """
        return _gdcmswig.DirectionCosines_Normalize(*args)

    @staticmethod
    def Norm(v):
        return _gdcmswig.DirectionCosines_Norm(v)

    def IsValid(self):
        r"""
        bool
        gdcm::DirectionCosines::IsValid() const

        Return whether or not this is a valid direction cosines. 
        """
        return _gdcmswig.DirectionCosines_IsValid(self)

    def SetFromString(self, str):
        r"""
        bool
        gdcm::DirectionCosines::SetFromString(const char *str)

        Initialize from string str. It requires 6 floating point separated by
        a backslash character. 
        """
        return _gdcmswig.DirectionCosines_SetFromString(self, str)

    def CrossDot(self, dc):
        r"""
        double
        gdcm::DirectionCosines::CrossDot(DirectionCosines const &dc) const

        Compute the Dot product of the two cross vector of both
        DirectionCosines object. 
        """
        return _gdcmswig.DirectionCosines_CrossDot(self, dc)

    def ComputeDistAlongNormal(self, ipp):
        r"""
        double gdcm::DirectionCosines::ComputeDistAlongNormal(const double
        ipp[3]) const

        Compute the distance along the normal. 
        """
        return _gdcmswig.DirectionCosines_ComputeDistAlongNormal(self, ipp)

    def __str__(self):
        return _gdcmswig.DirectionCosines___str__(self)

# Register DirectionCosines in _gdcmswig:
_gdcmswig.DirectionCosines_swigregister(DirectionCosines)
class Fiducials(object):
    r"""


    Fiducials.

    C++ includes: gdcmFiducials.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Fiducials::Fiducials()=default"""
        _gdcmswig.Fiducials_swiginit(self, _gdcmswig.new_Fiducials())
    __swig_destroy__ = _gdcmswig.delete_Fiducials

# Register Fiducials in _gdcmswig:
_gdcmswig.Fiducials_swigregister(Fiducials)
class Waveform(object):
    r"""


    Waveform class.

    C++ includes: gdcmWaveform.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Waveform::Waveform()=default"""
        _gdcmswig.Waveform_swiginit(self, _gdcmswig.new_Waveform())
    __swig_destroy__ = _gdcmswig.delete_Waveform

# Register Waveform in _gdcmswig:
_gdcmswig.Waveform_swigregister(Waveform)
class PersonName(object):
    r"""


    PersonName class.

    C++ includes: gdcmPersonName.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    MaxNumberOfComponents = _gdcmswig.PersonName_MaxNumberOfComponents
    MaxLength = _gdcmswig.PersonName_MaxLength
    Component = property(_gdcmswig.PersonName_Component_get, _gdcmswig.PersonName_Component_set)
    Separator = _gdcmswig.PersonName_Separator
    Padding = _gdcmswig.PersonName_Padding

    def GetNumberOfComponents(self):
        r"""unsigned int gdcm::PersonName::GetNumberOfComponents() const"""
        return _gdcmswig.PersonName_GetNumberOfComponents(self)

    def GetMaxLength(self):
        r"""
        unsigned int
        gdcm::PersonName::GetMaxLength() const 
        """
        return _gdcmswig.PersonName_GetMaxLength(self)

    def SetBlob(self, v):
        r"""
        void
        gdcm::PersonName::SetBlob(const std::vector< char > &v) 
        """
        return _gdcmswig.PersonName_SetBlob(self, v)

    def SetComponents(self, *args):
        r"""
        void
        gdcm::PersonName::SetComponents(const char *components[]) 
        """
        return _gdcmswig.PersonName_SetComponents(self, *args)

    def Print(self, os):
        r"""
        void
        gdcm::PersonName::Print(std::ostream &os) const 
        """
        return _gdcmswig.PersonName_Print(self, os)

    def __init__(self):
        _gdcmswig.PersonName_swiginit(self, _gdcmswig.new_PersonName())
    __swig_destroy__ = _gdcmswig.delete_PersonName

# Register PersonName in _gdcmswig:
_gdcmswig.PersonName_swigregister(PersonName)
class Curve(Object):
    r"""


    Curve class to handle element 50xx,3000 Curve Data.

    WARNING: This is deprecated and lastly defined in PS 3.3 - 2004

    Examples: GE_DLX-8-MONO2-Multiframe-Jpeg_Lossless.dcm

    GE_DLX-8-MONO2-Multiframe.dcm

    gdcmSampleData/Philips_Medical_Images/integris_HV_5000/xa_integris.dcm

    TOSHIBA-CurveData[1-3].dcm

    C++ includes: gdcmCurve.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_Curve

    def Print(self, arg2):
        r"""
        void
        gdcm::Curve::Print(std::ostream &) const override 
        """
        return _gdcmswig.Curve_Print(self, arg2)

    def GetAsPoints(self, array):
        r"""
        void
        gdcm::Curve::GetAsPoints(float *array) const 
        """
        return _gdcmswig.Curve_GetAsPoints(self, array)

    @staticmethod
    def GetNumberOfCurves(ds):
        return _gdcmswig.Curve_GetNumberOfCurves(ds)

    def Update(self, de):
        r"""
        void
        gdcm::Curve::Update(const DataElement &de) 
        """
        return _gdcmswig.Curve_Update(self, de)

    def SetGroup(self, group):
        r"""
        void
        gdcm::Curve::SetGroup(unsigned short group) 
        """
        return _gdcmswig.Curve_SetGroup(self, group)

    def GetGroup(self):
        r"""
        unsigned short
        gdcm::Curve::GetGroup() const 
        """
        return _gdcmswig.Curve_GetGroup(self)

    def SetDimensions(self, dimensions):
        r"""
        void
        gdcm::Curve::SetDimensions(unsigned short dimensions) 
        """
        return _gdcmswig.Curve_SetDimensions(self, dimensions)

    def GetDimensions(self):
        r"""
        unsigned short
        gdcm::Curve::GetDimensions() const 
        """
        return _gdcmswig.Curve_GetDimensions(self)

    def SetNumberOfPoints(self, numberofpoints):
        r"""
        void
        gdcm::Curve::SetNumberOfPoints(unsigned short numberofpoints) 
        """
        return _gdcmswig.Curve_SetNumberOfPoints(self, numberofpoints)

    def GetNumberOfPoints(self):
        r"""
        unsigned short
        gdcm::Curve::GetNumberOfPoints() const 
        """
        return _gdcmswig.Curve_GetNumberOfPoints(self)

    def SetTypeOfData(self, typeofdata):
        r"""
        void
        gdcm::Curve::SetTypeOfData(const char *typeofdata) 
        """
        return _gdcmswig.Curve_SetTypeOfData(self, typeofdata)

    def GetTypeOfData(self):
        r"""
        const char*
        gdcm::Curve::GetTypeOfData() const 
        """
        return _gdcmswig.Curve_GetTypeOfData(self)

    def GetTypeOfDataDescription(self):
        r"""
        const
        char* gdcm::Curve::GetTypeOfDataDescription() const 
        """
        return _gdcmswig.Curve_GetTypeOfDataDescription(self)

    def SetCurveDescription(self, curvedescription):
        r"""
        void
        gdcm::Curve::SetCurveDescription(const char *curvedescription) 
        """
        return _gdcmswig.Curve_SetCurveDescription(self, curvedescription)

    def SetDataValueRepresentation(self, datavaluerepresentation):
        r"""
        void
        gdcm::Curve::SetDataValueRepresentation(unsigned short
        datavaluerepresentation) 
        """
        return _gdcmswig.Curve_SetDataValueRepresentation(self, datavaluerepresentation)

    def GetDataValueRepresentation(self):
        r"""unsigned short gdcm::Curve::GetDataValueRepresentation() const"""
        return _gdcmswig.Curve_GetDataValueRepresentation(self)

    def SetCurveDataDescriptor(self, values, num):
        r"""
        void
        gdcm::Curve::SetCurveDataDescriptor(const uint16_t *values, size_t
        num) 
        """
        return _gdcmswig.Curve_SetCurveDataDescriptor(self, values, num)

    def GetCurveDataDescriptor(self):
        r"""
        std::vector<unsigned short> const&
        gdcm::Curve::GetCurveDataDescriptor() const 
        """
        return _gdcmswig.Curve_GetCurveDataDescriptor(self)

    def SetCoordinateStartValue(self, v):
        r"""
        void
        gdcm::Curve::SetCoordinateStartValue(unsigned short v) 
        """
        return _gdcmswig.Curve_SetCoordinateStartValue(self, v)

    def SetCoordinateStepValue(self, v):
        r"""
        void
        gdcm::Curve::SetCoordinateStepValue(unsigned short v) 
        """
        return _gdcmswig.Curve_SetCoordinateStepValue(self, v)

    def SetCurve(self, array, length):
        r"""
        void
        gdcm::Curve::SetCurve(const char *array, unsigned int length) 
        """
        return _gdcmswig.Curve_SetCurve(self, array, length)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Curve::IsEmpty() const 
        """
        return _gdcmswig.Curve_IsEmpty(self)

    def Decode(self, _is, os):
        r"""
        void
        gdcm::Curve::Decode(std::istream &is, std::ostream &os) 
        """
        return _gdcmswig.Curve_Decode(self, _is, os)

    def __init__(self, *args):
        r"""
        gdcm::Curve::Curve(Curve
        const &ov) 
        """
        _gdcmswig.Curve_swiginit(self, _gdcmswig.new_Curve(*args))

# Register Curve in _gdcmswig:
_gdcmswig.Curve_swigregister(Curve)
class DICOMDIR(object):
    r"""


    DICOMDIR class.

    Structured for handling DICOMDIR

    C++ includes: gdcmDICOMDIR.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::DICOMDIR::DICOMDIR(FileSet fs)"""
        _gdcmswig.DICOMDIR_swiginit(self, _gdcmswig.new_DICOMDIR(*args))
    __swig_destroy__ = _gdcmswig.delete_DICOMDIR

# Register DICOMDIR in _gdcmswig:
_gdcmswig.DICOMDIR_swigregister(DICOMDIR)
class Validate(object):
    r"""


    Validate class.

    C++ includes: gdcmValidate.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Validate::Validate()"""
        _gdcmswig.Validate_swiginit(self, _gdcmswig.new_Validate())
    __swig_destroy__ = _gdcmswig.delete_Validate

    def SetFile(self, f):
        r"""
        void
        gdcm::Validate::SetFile(File const &f) 
        """
        return _gdcmswig.Validate_SetFile(self, f)

    def GetValidatedFile(self):
        r"""
        const File&
        gdcm::Validate::GetValidatedFile() 
        """
        return _gdcmswig.Validate_GetValidatedFile(self)

    def Validation(self):
        r"""
        void
        gdcm::Validate::Validation() 
        """
        return _gdcmswig.Validate_Validation(self)

# Register Validate in _gdcmswig:
_gdcmswig.Validate_swigregister(Validate)
class ApplicationEntity(object):
    r"""


    ApplicationEntity.

    AE Application Entity

    A string of characters that identifies an Application Entity with
    leading and trailing spaces (20H) being non-significant. A value
    consisting solely of spaces shall not be used.

    Default Character Repertoire excluding character code 5CH (the
    BACKSLASH \\ in ISO-IR 6), and control characters LF, FF, CR and
    ESC.

    16 bytes maximum

    C++ includes: gdcmApplicationEntity.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    MaxNumberOfComponents = _gdcmswig.ApplicationEntity_MaxNumberOfComponents
    MaxLength = _gdcmswig.ApplicationEntity_MaxLength
    Internal = property(_gdcmswig.ApplicationEntity_Internal_get, _gdcmswig.ApplicationEntity_Internal_set)
    Separator = _gdcmswig.ApplicationEntity_Separator
    Padding = _gdcmswig.ApplicationEntity_Padding

    def IsValid(self):
        r"""
        bool
        gdcm::ApplicationEntity::IsValid() const 
        """
        return _gdcmswig.ApplicationEntity_IsValid(self)

    def Squeeze(self):
        r"""
        void
        gdcm::ApplicationEntity::Squeeze() 
        """
        return _gdcmswig.ApplicationEntity_Squeeze(self)

    def SetBlob(self, v):
        r"""
        void
        gdcm::ApplicationEntity::SetBlob(const std::vector< char > &v) 
        """
        return _gdcmswig.ApplicationEntity_SetBlob(self, v)

    def Print(self, os):
        r"""
        void
        gdcm::ApplicationEntity::Print(std::ostream &os) const 
        """
        return _gdcmswig.ApplicationEntity_Print(self, os)

    def __init__(self):
        _gdcmswig.ApplicationEntity_swiginit(self, _gdcmswig.new_ApplicationEntity())
    __swig_destroy__ = _gdcmswig.delete_ApplicationEntity

# Register ApplicationEntity in _gdcmswig:
_gdcmswig.ApplicationEntity_swigregister(ApplicationEntity)
class DictPrinter(Printer):
    r"""


    DictPrinter class.

    C++ includes: gdcmDictPrinter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::DictPrinter::DictPrinter()"""
        _gdcmswig.DictPrinter_swiginit(self, _gdcmswig.new_DictPrinter())
    __swig_destroy__ = _gdcmswig.delete_DictPrinter

    def Print(self, os):
        r"""
        void
        gdcm::DictPrinter::Print(std::ostream &os) 
        """
        return _gdcmswig.DictPrinter_Print(self, os)

# Register DictPrinter in _gdcmswig:
_gdcmswig.DictPrinter_swigregister(DictPrinter)
class FilenameGenerator(object):
    r"""


    FilenameGenerator.

    class to generate filenames based on a pattern (C-style)

    Output will be:

    for i = 0, number of filenames: outfilename[i] = prefix + (pattern %
    i)

    where pattern % i means C-style snprintf of Pattern using value 'i'

    C++ includes: gdcmFilenameGenerator.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::FilenameGenerator::FilenameGenerator()"""
        _gdcmswig.FilenameGenerator_swiginit(self, _gdcmswig.new_FilenameGenerator())
    __swig_destroy__ = _gdcmswig.delete_FilenameGenerator

    def SetPattern(self, pattern):
        r"""
        void
        gdcm::FilenameGenerator::SetPattern(const char *pattern)

        Set/Get pattern. 
        """
        return _gdcmswig.FilenameGenerator_SetPattern(self, pattern)

    def GetPattern(self):
        r"""
        const
        char* gdcm::FilenameGenerator::GetPattern() const 
        """
        return _gdcmswig.FilenameGenerator_GetPattern(self)

    def SetPrefix(self, prefix):
        r"""
        void
        gdcm::FilenameGenerator::SetPrefix(const char *prefix)

        Set/Get prefix. 
        """
        return _gdcmswig.FilenameGenerator_SetPrefix(self, prefix)

    def GetPrefix(self):
        r"""
        const
        char* gdcm::FilenameGenerator::GetPrefix() const 
        """
        return _gdcmswig.FilenameGenerator_GetPrefix(self)

    def Generate(self):
        r"""
        bool
        gdcm::FilenameGenerator::Generate()

        Generate (return success) 
        """
        return _gdcmswig.FilenameGenerator_Generate(self)

    def SetNumberOfFilenames(self, nfiles):
        r"""
        void gdcm::FilenameGenerator::SetNumberOfFilenames(SizeType nfiles)

        Set/Get the number of filenames to generate. 
        """
        return _gdcmswig.FilenameGenerator_SetNumberOfFilenames(self, nfiles)

    def GetNumberOfFilenames(self):
        r"""SizeType gdcm::FilenameGenerator::GetNumberOfFilenames() const"""
        return _gdcmswig.FilenameGenerator_GetNumberOfFilenames(self)

    def GetFilename(self, n):
        r"""
        const
        char* gdcm::FilenameGenerator::GetFilename(SizeType n) const

        Get a particular filename (call after Generate) 
        """
        return _gdcmswig.FilenameGenerator_GetFilename(self, n)

    def GetFilenames(self):
        r"""
        FilenamesType const& gdcm::FilenameGenerator::GetFilenames() const

        Return all filenames. 
        """
        return _gdcmswig.FilenameGenerator_GetFilenames(self)

# Register FilenameGenerator in _gdcmswig:
_gdcmswig.FilenameGenerator_swigregister(FilenameGenerator)
class Version(object):
    r"""


    major/minor and build version

    C++ includes: gdcmVersion.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def GetVersion():
        return _gdcmswig.Version_GetVersion()

    @staticmethod
    def GetMajorVersion():
        return _gdcmswig.Version_GetMajorVersion()

    @staticmethod
    def GetMinorVersion():
        return _gdcmswig.Version_GetMinorVersion()

    @staticmethod
    def GetBuildVersion():
        return _gdcmswig.Version_GetBuildVersion()

    def Print(self, *args):
        r"""
        void
        gdcm::Version::Print(std::ostream &os=std::cout) const 
        """
        return _gdcmswig.Version_Print(self, *args)

    def __init__(self):
        r"""gdcm::Version::Version()=default"""
        _gdcmswig.Version_swiginit(self, _gdcmswig.new_Version())
    __swig_destroy__ = _gdcmswig.delete_Version

    def __str__(self):
        return _gdcmswig.Version___str__(self)

# Register Version in _gdcmswig:
_gdcmswig.Version_swigregister(Version)
class Filename(object):
    r"""


    Class to manipulate file name's.

    OS independent representation of a filename (to query path, name and
    extension from a filename)

    C++ includes: gdcmFilename.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::Filename::Filename(const char *filename="")"""
        _gdcmswig.Filename_swiginit(self, _gdcmswig.new_Filename(*args))

    def GetFileName(self):
        r"""
        const char*
        gdcm::Filename::GetFileName() const

        Return the full filename. 
        """
        return _gdcmswig.Filename_GetFileName(self)

    def GetPath(self):
        r"""
        const char*
        gdcm::Filename::GetPath()

        Return only the path component of a filename. 
        """
        return _gdcmswig.Filename_GetPath(self)

    def GetName(self):
        r"""
        const char*
        gdcm::Filename::GetName()

        return only the name part of a filename 
        """
        return _gdcmswig.Filename_GetName(self)

    def GetExtension(self):
        r"""
        const char*
        gdcm::Filename::GetExtension()

        return only the extension part of a filename 
        """
        return _gdcmswig.Filename_GetExtension(self)

    def ToUnixSlashes(self):
        r"""
        const char*
        gdcm::Filename::ToUnixSlashes()

        Convert backslash (windows style) to UNIX style slash. 
        """
        return _gdcmswig.Filename_ToUnixSlashes(self)

    def ToWindowsSlashes(self):
        r"""
        const char*
        gdcm::Filename::ToWindowsSlashes()

        Convert forward slash (UNIX style) to windows style slash. 
        """
        return _gdcmswig.Filename_ToWindowsSlashes(self)

    @staticmethod
    def Join(path, filename):
        return _gdcmswig.Filename_Join(path, filename)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Filename::IsEmpty() const

        return whether the filename is empty 
        """
        return _gdcmswig.Filename_IsEmpty(self)

    def IsIdentical(self, fn):
        r"""
        bool
        gdcm::Filename::IsIdentical(Filename const &fn) const 
        """
        return _gdcmswig.Filename_IsIdentical(self, fn)

    def EndWith(self, ending):
        r"""
        bool
        gdcm::Filename::EndWith(const char ending[]) const

        Does the filename ends with a particular string ? 
        """
        return _gdcmswig.Filename_EndWith(self, ending)
    __swig_destroy__ = _gdcmswig.delete_Filename

# Register Filename in _gdcmswig:
_gdcmswig.Filename_swigregister(Filename)
class EnumeratedValues(object):
    r"""


    Element. A Data Element with Enumerated Values that does not have a
    Value equivalent to one of the Values specified in this standard has
    an invalid value within the scope of a specific Information Object/SOP
    Class definition. Note:

    Patient Sex (0010, 0040) is an example of a Data Element having
    Enumerated Values. It is defined to have a Value that is either "M",
    "F", or "O" (see PS 3.3). No other Value shall be given to this
    Data Element.

    Future modifications of this standard may add to the set of allowed
    values for Data Elements with Enumerated Values. Such additions by
    themselves may or may not require a change in SOP Class UIDs,
    depending on the semantics of the Data Element.

    C++ includes: gdcmEnumeratedValues.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::EnumeratedValues::EnumeratedValues()=default"""
        _gdcmswig.EnumeratedValues_swiginit(self, _gdcmswig.new_EnumeratedValues())
    __swig_destroy__ = _gdcmswig.delete_EnumeratedValues

# Register EnumeratedValues in _gdcmswig:
_gdcmswig.EnumeratedValues_swigregister(EnumeratedValues)
class Patient(object):
    r"""


    See PS 3.3 - 2007 DICOM MODEL OF THE REAL-WORLD, p 54.

    C++ includes: gdcmPatient.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Patient::Patient()=default"""
        _gdcmswig.Patient_swiginit(self, _gdcmswig.new_Patient())
    __swig_destroy__ = _gdcmswig.delete_Patient

# Register Patient in _gdcmswig:
_gdcmswig.Patient_swigregister(Patient)
class Study(object):
    r"""


    Study.

    C++ includes: gdcmStudy.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Study::Study()=default"""
        _gdcmswig.Study_swiginit(self, _gdcmswig.new_Study())
    __swig_destroy__ = _gdcmswig.delete_Study

# Register Study in _gdcmswig:
_gdcmswig.Study_swigregister(Study)
class Usage(object):
    r"""


    Usage.

    A.1.3 IOD Module Table and Functional Group Macro Table This Section
    of each IOD defines in a tabular form the Modules comprising the IOD.
    The following information must be specified for each Module in the
    table: The name of the Module or Functional Group

    A reference to the Section in Annex C which defines the Module or
    Functional Group

    The usage of the Module or Functional Group; whether it is:

    Mandatory (see A.1.3.1) , abbreviated M

    Conditional (see A.1.3.2) , abbreviated C

    User Option (see A.1.3.3) , abbreviated U The Modules referenced are
    defined in Annex C. A.1.3.1 MANDATORY MODULES For each IOD, Mandatory
    Modules shall be supported per the definitions, semantics and
    requirements defined in Annex C.

    A.1.3.2 CONDITIONAL MODULES Conditional Modules are Mandatory Modules
    if specific conditions are met. If the specified conditions are not
    met, this Module shall not be supported; that is, no information
    defined in that Module shall be sent. A.1.3.3 USER OPTION MODULES User
    Option Modules may or may not be supported. If an optional Module is
    supported, the Attribute Types specified in the Modules in Annex C
    shall be supported.

    C++ includes: gdcmUsage.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Mandatory = _gdcmswig.Usage_Mandatory
    Conditional = _gdcmswig.Usage_Conditional
    UserOption = _gdcmswig.Usage_UserOption
    Invalid = _gdcmswig.Usage_Invalid

    def __init__(self, *args):
        r"""gdcm::Usage::Usage(UsageType type=Invalid)"""
        _gdcmswig.Usage_swiginit(self, _gdcmswig.new_Usage(*args))

    @staticmethod
    def GetUsageString(type):
        return _gdcmswig.Usage_GetUsageString(type)

    @staticmethod
    def GetUsageType(type):
        return _gdcmswig.Usage_GetUsageType(type)
    __swig_destroy__ = _gdcmswig.delete_Usage

# Register Usage in _gdcmswig:
_gdcmswig.Usage_swigregister(Usage)
class ModuleEntry(object):
    r"""


    Class for representing a ModuleEntry.

    bla

    See:   DictEntry

    C++ includes: gdcmModuleEntry.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::ModuleEntry::ModuleEntry(const char *name="", const char
        *type="3", const char *description="") 
        """
        _gdcmswig.ModuleEntry_swiginit(self, _gdcmswig.new_ModuleEntry(*args))
    __swig_destroy__ = _gdcmswig.delete_ModuleEntry

    def SetName(self, name):
        r"""
        void
        gdcm::ModuleEntry::SetName(const char *name) 
        """
        return _gdcmswig.ModuleEntry_SetName(self, name)

    def GetName(self):
        r"""
        const char*
        gdcm::ModuleEntry::GetName() const 
        """
        return _gdcmswig.ModuleEntry_GetName(self)

    def SetType(self, type):
        r"""
        void
        gdcm::ModuleEntry::SetType(const Type &type) 
        """
        return _gdcmswig.ModuleEntry_SetType(self, type)

    def GetType(self):
        r"""
        const Type&
        gdcm::ModuleEntry::GetType() const 
        """
        return _gdcmswig.ModuleEntry_GetType(self)

    def SetDescription(self, d):
        r"""
        void
        gdcm::ModuleEntry::SetDescription(const char *d) 
        """
        return _gdcmswig.ModuleEntry_SetDescription(self, d)

    def GetDescription(self):
        r"""
        const
        Description& gdcm::ModuleEntry::GetDescription() const 
        """
        return _gdcmswig.ModuleEntry_GetDescription(self)

    def __str__(self):
        return _gdcmswig.ModuleEntry___str__(self)

# Register ModuleEntry in _gdcmswig:
_gdcmswig.ModuleEntry_swigregister(ModuleEntry)
class NestedModuleEntries(ModuleEntry):
    r"""


    Class for representing a NestedModuleEntries.

    bla

    See:   ModuleEntry

    C++ includes: gdcmNestedModuleEntries.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::NestedModuleEntries::NestedModuleEntries(const char
        *name="", const char *type="3", const char *description="") 
        """
        _gdcmswig.NestedModuleEntries_swiginit(self, _gdcmswig.new_NestedModuleEntries(*args))

    def GetNumberOfModuleEntries(self):
        r"""
        SizeType
        gdcm::NestedModuleEntries::GetNumberOfModuleEntries() 
        """
        return _gdcmswig.NestedModuleEntries_GetNumberOfModuleEntries(self)

    def GetModuleEntry(self, *args):
        r"""
        const ModuleEntry& gdcm::NestedModuleEntries::GetModuleEntry(SizeType
        idx) const 
        """
        return _gdcmswig.NestedModuleEntries_GetModuleEntry(self, *args)

    def AddModuleEntry(self, me):
        r"""
        void gdcm::NestedModuleEntries::AddModuleEntry(const ModuleEntry &me)

        """
        return _gdcmswig.NestedModuleEntries_AddModuleEntry(self, me)
    __swig_destroy__ = _gdcmswig.delete_NestedModuleEntries

# Register NestedModuleEntries in _gdcmswig:
_gdcmswig.NestedModuleEntries_swigregister(NestedModuleEntries)
class Macro(object):
    r"""


    Class for representing a Macro.

    Attribute Macro: a set of Attributes that are described in a single
    table that is referenced by multiple Module or other tables.

    See:   Module

    C++ includes: gdcmMacro.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Macro::Macro()=default"""
        _gdcmswig.Macro_swiginit(self, _gdcmswig.new_Macro())

    def Clear(self):
        r"""
        void gdcm::Macro::Clear()

        """
        return _gdcmswig.Macro_Clear(self)

    def AddMacroEntry(self, tag, module):
        r"""
        void
        gdcm::Macro::AddMacroEntry(const Tag &tag, const MacroEntry &module)

        Will add a ModuleEntry directly at root-level. See Macro for nested-
        included level. 
        """
        return _gdcmswig.Macro_AddMacroEntry(self, tag, module)

    def FindMacroEntry(self, tag):
        r"""
        bool
        gdcm::Macro::FindMacroEntry(const Tag &tag) const

        Find or Get a ModuleEntry. ModuleEntry are either search are root-
        level or within nested-macro included in module. 
        """
        return _gdcmswig.Macro_FindMacroEntry(self, tag)

    def GetMacroEntry(self, tag):
        r"""
        const MacroEntry&
        gdcm::Macro::GetMacroEntry(const Tag &tag) const 
        """
        return _gdcmswig.Macro_GetMacroEntry(self, tag)

    def SetName(self, name):
        r"""
        void
        gdcm::Macro::SetName(const char *name) 
        """
        return _gdcmswig.Macro_SetName(self, name)

    def GetName(self):
        r"""
        const char*
        gdcm::Macro::GetName() const 
        """
        return _gdcmswig.Macro_GetName(self)

    def Verify(self, ds, usage):
        r"""
        bool
        gdcm::Macro::Verify(const DataSet &ds, Usage const &usage) const 
        """
        return _gdcmswig.Macro_Verify(self, ds, usage)
    __swig_destroy__ = _gdcmswig.delete_Macro

# Register Macro in _gdcmswig:
_gdcmswig.Macro_swigregister(Macro)
class Macros(object):
    r"""


    Class for representing a Modules.

    bla

    See:   Module

    C++ includes: gdcmMacros.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Macros::Macros()=default"""
        _gdcmswig.Macros_swiginit(self, _gdcmswig.new_Macros())

    def Clear(self):
        r"""
        void
        gdcm::Macros::Clear() 
        """
        return _gdcmswig.Macros_Clear(self)

    def AddMacro(self, ref, module):
        r"""
        void
        gdcm::Macros::AddMacro(const char *ref, const Macro &module) 
        """
        return _gdcmswig.Macros_AddMacro(self, ref, module)

    def GetMacro(self, name):
        r"""
        const Macro&
        gdcm::Macros::GetMacro(const char *name) const 
        """
        return _gdcmswig.Macros_GetMacro(self, name)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Macros::IsEmpty() const 
        """
        return _gdcmswig.Macros_IsEmpty(self)
    __swig_destroy__ = _gdcmswig.delete_Macros

# Register Macros in _gdcmswig:
_gdcmswig.Macros_swigregister(Macros)
class Module(object):
    r"""


    Class for representing a Module.

    Module: A set of Attributes within an Information Entity or Normalized
    IOD which are logically related to each other.

    See:   Macro

    C++ includes: gdcmModule.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Module::Module()=default"""
        _gdcmswig.Module_swiginit(self, _gdcmswig.new_Module())

    def Clear(self):
        r"""
        void
        gdcm::Module::Clear() 
        """
        return _gdcmswig.Module_Clear(self)

    def AddModuleEntry(self, tag, module):
        r"""
        void
        gdcm::Module::AddModuleEntry(const Tag &tag, const ModuleEntry
        &module)

        Will add a ModuleEntry directly at root-level. See Macro for nested-
        included level. 
        """
        return _gdcmswig.Module_AddModuleEntry(self, tag, module)

    def AddMacro(self, include):
        r"""
        void
        gdcm::Module::AddMacro(const char *include) 
        """
        return _gdcmswig.Module_AddMacro(self, include)

    def FindModuleEntryInMacros(self, macros, tag):
        r"""
        bool
        gdcm::Module::FindModuleEntryInMacros(Macros const &macros, const Tag
        &tag) const

        Find or Get a ModuleEntry. ModuleEntry are either search are root-
        level or within nested-macro included in module. 
        """
        return _gdcmswig.Module_FindModuleEntryInMacros(self, macros, tag)

    def GetModuleEntryInMacros(self, macros, tag):
        r"""
        const
        ModuleEntry& gdcm::Module::GetModuleEntryInMacros(Macros const
        &macros, const Tag &tag) const 
        """
        return _gdcmswig.Module_GetModuleEntryInMacros(self, macros, tag)

    def SetName(self, name):
        r"""
        void
        gdcm::Module::SetName(const char *name) 
        """
        return _gdcmswig.Module_SetName(self, name)

    def GetName(self):
        r"""
        const char*
        gdcm::Module::GetName() const 
        """
        return _gdcmswig.Module_GetName(self)

    def Verify(self, ds, usage):
        r"""
        bool
        gdcm::Module::Verify(const DataSet &ds, Usage const &usage) const 
        """
        return _gdcmswig.Module_Verify(self, ds, usage)
    __swig_destroy__ = _gdcmswig.delete_Module

# Register Module in _gdcmswig:
_gdcmswig.Module_swigregister(Module)
class Modules(object):
    r"""


    Class for representing a Modules.

    bla

    See:   Module

    C++ includes: gdcmModules.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Modules::Modules()=default"""
        _gdcmswig.Modules_swiginit(self, _gdcmswig.new_Modules())

    def Clear(self):
        r"""
        void
        gdcm::Modules::Clear() 
        """
        return _gdcmswig.Modules_Clear(self)

    def AddModule(self, ref, module):
        r"""
        void
        gdcm::Modules::AddModule(const char *ref, const Module &module) 
        """
        return _gdcmswig.Modules_AddModule(self, ref, module)

    def GetModule(self, name):
        r"""
        const Module&
        gdcm::Modules::GetModule(const char *name) const 
        """
        return _gdcmswig.Modules_GetModule(self, name)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Modules::IsEmpty() const 
        """
        return _gdcmswig.Modules_IsEmpty(self)
    __swig_destroy__ = _gdcmswig.delete_Modules

# Register Modules in _gdcmswig:
_gdcmswig.Modules_swigregister(Modules)
class Defs(object):
    r"""


    FIXME I do not like the name ' Defs'.

    bla

    C++ includes: gdcmDefs.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::Defs::Defs(const Defs
        &val)=delete 
        """
        _gdcmswig.Defs_swiginit(self, _gdcmswig.new_Defs())
    __swig_destroy__ = _gdcmswig.delete_Defs

    def GetModules(self, *args):
        r"""
        const Modules&
        gdcm::Defs::GetModules() const 
        """
        return _gdcmswig.Defs_GetModules(self, *args)

    def GetMacros(self, *args):
        r"""
        const Macros&
        gdcm::Defs::GetMacros() const

        Users should not directly use Macro. Macro are simply a way for DICOM
        WG to re-use Tables. Macros are conveniently wrapped within Modules.
        See gdcm::Module API directly 
        """
        return _gdcmswig.Defs_GetMacros(self, *args)

    def GetIODs(self, *args):
        r"""
        const IODs&
        gdcm::Defs::GetIODs() const 
        """
        return _gdcmswig.Defs_GetIODs(self, *args)

    def IsEmpty(self):
        r"""
        bool
        gdcm::Defs::IsEmpty() const 
        """
        return _gdcmswig.Defs_IsEmpty(self)

    def Verify(self, *args):
        r"""
        bool
        gdcm::Defs::Verify(const File &file) const 
        """
        return _gdcmswig.Defs_Verify(self, *args)

    def GetTypeFromTag(self, file, tag):
        r"""
        Type
        gdcm::Defs::GetTypeFromTag(const File &file, const Tag &tag) const 
        """
        return _gdcmswig.Defs_GetTypeFromTag(self, file, tag)

    @staticmethod
    def GetIODNameFromMediaStorage(ms):
        return _gdcmswig.Defs_GetIODNameFromMediaStorage(ms)

    def GetIODFromFile(self, file):
        r"""
        const IOD&
        gdcm::Defs::GetIODFromFile(const File &file) const 
        """
        return _gdcmswig.Defs_GetIODFromFile(self, file)

# Register Defs in _gdcmswig:
_gdcmswig.Defs_swigregister(Defs)
class IOD(object):
    r"""


    Class for representing a IOD.

    bla

    See:   Dict

    C++ includes: gdcmIOD.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::IOD::IOD()=default"""
        _gdcmswig.IOD_swiginit(self, _gdcmswig.new_IOD())

    def Clear(self):
        r"""void gdcm::IOD::Clear()"""
        return _gdcmswig.IOD_Clear(self)

    def AddIODEntry(self, iode):
        r"""
        void
        gdcm::IOD::AddIODEntry(const IODEntry &iode) 
        """
        return _gdcmswig.IOD_AddIODEntry(self, iode)

    def GetNumberOfIODs(self):
        r"""
        SizeType
        gdcm::IOD::GetNumberOfIODs() const 
        """
        return _gdcmswig.IOD_GetNumberOfIODs(self)

    def GetIODEntry(self, idx):
        r"""
        const IODEntry&
        gdcm::IOD::GetIODEntry(SizeType idx) const 
        """
        return _gdcmswig.IOD_GetIODEntry(self, idx)

    def GetTypeFromTag(self, defs, tag):
        r"""
        Type
        gdcm::IOD::GetTypeFromTag(const Defs &defs, const Tag &tag) const 
        """
        return _gdcmswig.IOD_GetTypeFromTag(self, defs, tag)
    __swig_destroy__ = _gdcmswig.delete_IOD

# Register IOD in _gdcmswig:
_gdcmswig.IOD_swigregister(IOD)
class IODs(object):
    r"""


    Class for representing a IODs.

    bla

    See:   IOD

    C++ includes: gdcmIODs.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::IODs::IODs()=default

        """
        _gdcmswig.IODs_swiginit(self, _gdcmswig.new_IODs())

    def Clear(self):
        r"""void gdcm::IODs::Clear()"""
        return _gdcmswig.IODs_Clear(self)

    def AddIOD(self, name, module):
        r"""
        void
        gdcm::IODs::AddIOD(const char *name, const IOD &module) 
        """
        return _gdcmswig.IODs_AddIOD(self, name, module)

    def GetIOD(self, name):
        r"""
        const IOD&
        gdcm::IODs::GetIOD(const char *name) const 
        """
        return _gdcmswig.IODs_GetIOD(self, name)

    def Begin(self):
        r"""
        IODMapTypeConstIterator
        gdcm::IODs::Begin() const 
        """
        return _gdcmswig.IODs_Begin(self)

    def End(self):
        r"""
        IODMapTypeConstIterator
        gdcm::IODs::End() const 
        """
        return _gdcmswig.IODs_End(self)
    __swig_destroy__ = _gdcmswig.delete_IODs

# Register IODs in _gdcmswig:
_gdcmswig.IODs_swigregister(IODs)
class TableEntry(object):
    r"""


    TableEntry.

    C++ includes: gdcmTableEntry.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::TableEntry::TableEntry(const char *attribute=nullptr, Type const
        &type=Type(), const char *des=nullptr) 
        """
        _gdcmswig.TableEntry_swiginit(self, _gdcmswig.new_TableEntry(*args))
    __swig_destroy__ = _gdcmswig.delete_TableEntry

# Register TableEntry in _gdcmswig:
_gdcmswig.TableEntry_swigregister(TableEntry)
class DefinedTerms(object):
    r"""


    Defined Terms are used when the specified explicit Values may be
    extended by implementors to include additional new Values. These new
    Values shall be specified in the Conformance Statement (see PS 3.2)
    and shall not have the same meaning as currently defined Values in
    this standard. A Data Element with Defined Terms that does not contain
    a Value equivalent to one of the Values currently specified in this
    standard shall not be considered to have an invalid value. Note:
    Interpretation Type ID (4008,0210) is an example of a Data Element
    having Defined Terms. It is defined to have a Value that may be one of
    the set of standard Values; REPORT or AMENDMENT (see PS 3.3). Because
    this Data Element has Defined Terms other Interpretation Type IDs may
    be defined by the implementor.

    C++ includes: gdcmDefinedTerms.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::DefinedTerms::DefinedTerms()=default"""
        _gdcmswig.DefinedTerms_swiginit(self, _gdcmswig.new_DefinedTerms())
    __swig_destroy__ = _gdcmswig.delete_DefinedTerms

# Register DefinedTerms in _gdcmswig:
_gdcmswig.DefinedTerms_swigregister(DefinedTerms)
class Series(object):
    r"""


    Series.

    C++ includes: gdcmSeries.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Series::Series()=default"""
        _gdcmswig.Series_swiginit(self, _gdcmswig.new_Series())
    __swig_destroy__ = _gdcmswig.delete_Series

# Register Series in _gdcmswig:
_gdcmswig.Series_swigregister(Series)
class IODEntry(object):
    r"""


    Class for representing a IODEntry.

    A.1.3 IOD Module Table and Functional Group Macro Table This Section
    of each IOD defines in a tabular form the Modules comprising the IOD.
    The following information must be specified for each Module in the
    table: The name of the Module or Functional Group

    A reference to the Section in Annex C which defines the Module or
    Functional Group

    The usage of the Module or Functional Group; whether it is:

    Mandatory (see A.1.3.1) , abbreviated M

    Conditional (see A.1.3.2) , abbreviated C

    User Option (see A.1.3.3) , abbreviated U The Modules referenced are
    defined in Annex C. A.1.3.1 MANDATORY MODULES For each IOD, Mandatory
    Modules shall be supported per the definitions, semantics and
    requirements defined in Annex C. PS 3.3 - 2008 Page 96

    Standard - A.1.3.2 CONDITIONAL MODULES Conditional Modules are
    Mandatory Modules if specific conditions are met. If the specified
    conditions are not met, this Module shall not be supported; that is,
    no information defined in that Module shall be sent. A.1.3.3 USER
    OPTION MODULES User Option Modules may or may not be supported. If an
    optional Module is supported, the Attribute Types specified in the
    Modules in Annex C shall be supported.

    See:   DictEntry

    C++ includes: gdcmIODEntry.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::IODEntry::IODEntry(const char *name="", const char *ref="",
        const char *usage="") 
        """
        _gdcmswig.IODEntry_swiginit(self, _gdcmswig.new_IODEntry(*args))

    def SetIE(self, ie):
        r"""
        void
        gdcm::IODEntry::SetIE(const char *ie) 
        """
        return _gdcmswig.IODEntry_SetIE(self, ie)

    def GetIE(self):
        r"""
        const char*
        gdcm::IODEntry::GetIE() const 
        """
        return _gdcmswig.IODEntry_GetIE(self)

    def SetName(self, name):
        r"""
        void
        gdcm::IODEntry::SetName(const char *name) 
        """
        return _gdcmswig.IODEntry_SetName(self, name)

    def GetName(self):
        r"""
        const char*
        gdcm::IODEntry::GetName() const 
        """
        return _gdcmswig.IODEntry_GetName(self)

    def SetRef(self, ref):
        r"""
        void
        gdcm::IODEntry::SetRef(const char *ref) 
        """
        return _gdcmswig.IODEntry_SetRef(self, ref)

    def GetRef(self):
        r"""
        const char*
        gdcm::IODEntry::GetRef() const 
        """
        return _gdcmswig.IODEntry_GetRef(self)

    def SetUsage(self, inUsage):
        r"""
        void
        gdcm::IODEntry::SetUsage(const char *usage) 
        """
        return _gdcmswig.IODEntry_SetUsage(self, inUsage)

    def GetUsage(self):
        r"""
        const char*
        gdcm::IODEntry::GetUsage() const 
        """
        return _gdcmswig.IODEntry_GetUsage(self)

    def GetUsageType(self):
        r"""
        Usage::UsageType
        gdcm::IODEntry::GetUsageType() const 
        """
        return _gdcmswig.IODEntry_GetUsageType(self)
    __swig_destroy__ = _gdcmswig.delete_IODEntry

# Register IODEntry in _gdcmswig:
_gdcmswig.IODEntry_swigregister(IODEntry)
class Rescaler(object):
    r"""


    Rescale class.

    This class is meant to apply the linear transform of Stored Pixel
    Value to Real World Value. This is mostly found in CT or PET dataset,
    where the value are stored using one type, but need to be converted to
    another scale using a linear transform. There are basically two cases:
    In CT: the linear transform is generally integer based. E.g. the
    Stored Pixel Type is unsigned short 12bits, but to get Hounsfield
    unit, one need to apply the linear transform: \\[ RWV = 1. * SV -
    1024 \\] So the best scalar to store the Real World Value will be 16
    bits signed type.

    In PET: the linear transform is generally floating point based. Since
    the dynamic range can be quite high, the Rescale Slope / Rescale
    Intercept can be changing throughout the Series. So it is important to
    read all linear transform and deduce the best Pixel Type only at the
    end (when all the images to be read have been parsed).

    WARNING:  Internally any time a floating point value is found either
    in the Rescale Slope or the Rescale Intercept it is assumed that the
    best matching output pixel type is FLOAT64 (in previous implementation
    it was FLOAT32). Because VR:DS is closer to a 64bits floating point
    type FLOAT64 is thus a best matching pixel type for the floating point
    transformation.  Example: Let say input is FLOAT64, and we want UINT16
    as output, we would do:

    handle floating point transformation back and forth to integer
    properly (no loss)

    See:   Unpacker12Bits

    C++ includes: gdcmRescaler.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Rescaler::Rescaler()"""
        _gdcmswig.Rescaler_swiginit(self, _gdcmswig.new_Rescaler())
    __swig_destroy__ = _gdcmswig.delete_Rescaler

    def Rescale(self, out, _in, n):
        r"""
        bool
        gdcm::Rescaler::Rescale(char *out, const char *in, size_t n)

        Direct transform. 
        """
        return _gdcmswig.Rescaler_Rescale(self, out, _in, n)

    def InverseRescale(self, out, _in, n):
        r"""
        bool
        gdcm::Rescaler::InverseRescale(char *out, const char *in, size_t n)

        Inverse transform. 
        """
        return _gdcmswig.Rescaler_InverseRescale(self, out, _in, n)

    def SetIntercept(self, i):
        r"""
        void
        gdcm::Rescaler::SetIntercept(double i)

        Set Intercept: used for both direct&inverse transformation. 
        """
        return _gdcmswig.Rescaler_SetIntercept(self, i)

    def GetIntercept(self):
        r"""
        double
        gdcm::Rescaler::GetIntercept() const 
        """
        return _gdcmswig.Rescaler_GetIntercept(self)

    def SetSlope(self, s):
        r"""
        void
        gdcm::Rescaler::SetSlope(double s)

        Set Slope: user for both direct&inverse transformation. 
        """
        return _gdcmswig.Rescaler_SetSlope(self, s)

    def GetSlope(self):
        r"""
        double
        gdcm::Rescaler::GetSlope() const 
        """
        return _gdcmswig.Rescaler_GetSlope(self)

    def SetTargetPixelType(self, targetst):
        r"""
        void
        gdcm::Rescaler::SetTargetPixelType(PixelFormat const &targetst)

        By default (when UseTargetPixelType is false), a best matching Target
        Pixel Type is computed. However user can override this auto selection
        by switching UseTargetPixelType:true and also specifying the specific
        Target Pixel Type 
        """
        return _gdcmswig.Rescaler_SetTargetPixelType(self, targetst)

    def SetUseTargetPixelType(self, b):
        r"""
        void
        gdcm::Rescaler::SetUseTargetPixelType(bool b)

        Override default behavior of Rescale. 
        """
        return _gdcmswig.Rescaler_SetUseTargetPixelType(self, b)

    def SetPixelFormat(self, pf):
        r"""
        void
        gdcm::Rescaler::SetPixelFormat(PixelFormat const &pf)

        Set Pixel Format of input data. 
        """
        return _gdcmswig.Rescaler_SetPixelFormat(self, pf)

    def ComputeInterceptSlopePixelType(self):
        r"""
        PixelFormat::ScalarType
        gdcm::Rescaler::ComputeInterceptSlopePixelType()

        Compute the Pixel Format of the output data Used for direct
        transformation 
        """
        return _gdcmswig.Rescaler_ComputeInterceptSlopePixelType(self)

    def SetMinMaxForPixelType(self, min, max):
        r"""
        void
        gdcm::Rescaler::SetMinMaxForPixelType(double min, double max)

        Set target interval for output data. A best match will be computed (if
        possible) Used for inverse transformation 
        """
        return _gdcmswig.Rescaler_SetMinMaxForPixelType(self, min, max)

    def ComputePixelTypeFromMinMax(self):
        r"""
        PixelFormat gdcm::Rescaler::ComputePixelTypeFromMinMax()

        Compute the Pixel Format of the output data Used for inverse
        transformation 
        """
        return _gdcmswig.Rescaler_ComputePixelTypeFromMinMax(self)

# Register Rescaler in _gdcmswig:
_gdcmswig.Rescaler_swigregister(Rescaler)
class SegmentedPaletteColorLookupTable(LookupTable):
    r"""


    SegmentedPaletteColorLookupTable class.

    C++ includes: gdcmSegmentedPaletteColorLookupTable.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::SegmentedPaletteColorLookupTable::SegmentedPaletteColorLookupTable()

        """
        _gdcmswig.SegmentedPaletteColorLookupTable_swiginit(self, _gdcmswig.new_SegmentedPaletteColorLookupTable())
    __swig_destroy__ = _gdcmswig.delete_SegmentedPaletteColorLookupTable

    def Print(self, arg2):
        r"""
        void gdcm::SegmentedPaletteColorLookupTable::Print(std::ostream &)
        const override 
        """
        return _gdcmswig.SegmentedPaletteColorLookupTable_Print(self, arg2)

    def SetLUT(self, type, array, length):
        r"""
        void gdcm::SegmentedPaletteColorLookupTable::SetLUT(LookupTableType
        type, const unsigned char *array, unsigned int length) override

        Initialize a SegmentedPaletteColorLookupTable. 
        """
        return _gdcmswig.SegmentedPaletteColorLookupTable_SetLUT(self, type, array, length)

# Register SegmentedPaletteColorLookupTable in _gdcmswig:
_gdcmswig.SegmentedPaletteColorLookupTable_swigregister(SegmentedPaletteColorLookupTable)
class Unpacker12Bits(object):
    r"""


    Pack/Unpack 12 bits pixel into 16bits.

    You can only pack an even number of 16bits, which means a multiple of
    4 (expressed in bytes)

    You can only unpack a multiple of 3 bytes  This class has no purpose
    in general purpose DICOM implementation. However to be able to cope
    with some early ACR-NEMA file generated by a well-known private
    vendor, one would need to unpack 12bits Stored Pixel Value into a more
    standard 16bits Stored Pixel Value.

    See:   Rescaler

    C++ includes: gdcmUnpacker12Bits.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Pack(out, _in, n):
        return _gdcmswig.Unpacker12Bits_Pack(out, _in, n)

    @staticmethod
    def Unpack(out, _in, n):
        return _gdcmswig.Unpacker12Bits_Unpack(out, _in, n)

    def __init__(self):
        _gdcmswig.Unpacker12Bits_swiginit(self, _gdcmswig.new_Unpacker12Bits())
    __swig_destroy__ = _gdcmswig.delete_Unpacker12Bits

# Register Unpacker12Bits in _gdcmswig:
_gdcmswig.Unpacker12Bits_swigregister(Unpacker12Bits)
class Testing(object):
    r"""


    class for testing

    this class is used for the nightly regression system for GDCM It makes
    heavily use of md5 computation

    See:   gdcm::MD5 class for md5 computation

    C++ includes: gdcmTesting.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Testing::Testing()=default"""
        _gdcmswig.Testing_swiginit(self, _gdcmswig.new_Testing())
    __swig_destroy__ = _gdcmswig.delete_Testing

    @staticmethod
    def ComputeMD5(buffer, buf_len, digest_str):
        return _gdcmswig.Testing_ComputeMD5(buffer, buf_len, digest_str)

    def Print(self, *args):
        r"""
        void
        gdcm::Testing::Print(std::ostream &os=std::cout)

        Print. 
        """
        return _gdcmswig.Testing_Print(self, *args)

    @staticmethod
    def GetFileNames():
        return _gdcmswig.Testing_GetFileNames()

    @staticmethod
    def GetNumberOfFileNames():
        return _gdcmswig.Testing_GetNumberOfFileNames()

    @staticmethod
    def GetFileName(file):
        return _gdcmswig.Testing_GetFileName(file)

    @staticmethod
    def GetMediaStorageDataFiles():
        return _gdcmswig.Testing_GetMediaStorageDataFiles()

    @staticmethod
    def GetNumberOfMediaStorageDataFiles():
        return _gdcmswig.Testing_GetNumberOfMediaStorageDataFiles()

    @staticmethod
    def GetMediaStorageDataFile(file):
        return _gdcmswig.Testing_GetMediaStorageDataFile(file)

    @staticmethod
    def GetMediaStorageFromFile(filepath):
        return _gdcmswig.Testing_GetMediaStorageFromFile(filepath)

    @staticmethod
    def GetMD5DataImages():
        return _gdcmswig.Testing_GetMD5DataImages()

    @staticmethod
    def GetNumberOfMD5DataImages():
        return _gdcmswig.Testing_GetNumberOfMD5DataImages()

    @staticmethod
    def GetMD5DataImage(file):
        return _gdcmswig.Testing_GetMD5DataImage(file)

    @staticmethod
    def GetMD5FromFile(filepath):
        return _gdcmswig.Testing_GetMD5FromFile(filepath)

    @staticmethod
    def GetMD5FromBrokenFile(filepath):
        return _gdcmswig.Testing_GetMD5FromBrokenFile(filepath)

    @staticmethod
    def GetStreamOffsetFromFile(filepath):
        return _gdcmswig.Testing_GetStreamOffsetFromFile(filepath)

    @staticmethod
    def GetSelectedTagsOffsetFromFile(filepath):
        return _gdcmswig.Testing_GetSelectedTagsOffsetFromFile(filepath)

    @staticmethod
    def GetSelectedPrivateGroupOffsetFromFile(filepath):
        return _gdcmswig.Testing_GetSelectedPrivateGroupOffsetFromFile(filepath)

    @staticmethod
    def GetLossyFlagFromFile(filepath):
        return _gdcmswig.Testing_GetLossyFlagFromFile(filepath)

    @staticmethod
    def GetDataRoot():
        return _gdcmswig.Testing_GetDataRoot()

    @staticmethod
    def GetDataExtraRoot():
        return _gdcmswig.Testing_GetDataExtraRoot()

    @staticmethod
    def GetPixelSpacingDataRoot():
        return _gdcmswig.Testing_GetPixelSpacingDataRoot()

    @staticmethod
    def GetTempDirectory(subdir=None):
        return _gdcmswig.Testing_GetTempDirectory(subdir)

    @staticmethod
    def GetTempDirectoryW(subdir=None):
        return _gdcmswig.Testing_GetTempDirectoryW(subdir)

    @staticmethod
    def GetTempFilename(filename, subdir=None):
        return _gdcmswig.Testing_GetTempFilename(filename, subdir)

    @staticmethod
    def GetTempFilenameW(filename, subdir=None):
        return _gdcmswig.Testing_GetTempFilenameW(filename, subdir)

    @staticmethod
    def GetSourceDirectory():
        return _gdcmswig.Testing_GetSourceDirectory()

    @staticmethod
    def ComputeFileMD5(*args):
        return _gdcmswig.Testing_ComputeFileMD5(*args)

# Register Testing in _gdcmswig:
_gdcmswig.Testing_swigregister(Testing)
class PythonFilter(object):
    r"""


    PythonFilter PythonFilter is the class that make gdcm2.x looks more
    like gdcm1 and transform the binary blob contained in a DataElement
    into a string, typically this is a nice feature to have for wrapped
    language.

    C++ includes: gdcmPythonFilter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PythonFilter::PythonFilter()"""
        _gdcmswig.PythonFilter_swiginit(self, _gdcmswig.new_PythonFilter())
    __swig_destroy__ = _gdcmswig.delete_PythonFilter

    def UseDictAlways(self, arg2):
        r"""
        void
        gdcm::PythonFilter::UseDictAlways(bool) 
        """
        return _gdcmswig.PythonFilter_UseDictAlways(self, arg2)

    def SetDicts(self, dicts):
        r"""
        void
        gdcm::PythonFilter::SetDicts(const Dicts &dicts) 
        """
        return _gdcmswig.PythonFilter_SetDicts(self, dicts)

    def ToPyObject(self, t):
        r"""
        PyObject*
        gdcm::PythonFilter::ToPyObject(const Tag &t) const 
        """
        return _gdcmswig.PythonFilter_ToPyObject(self, t)

    def SetFile(self, f):
        r"""
        void
        gdcm::PythonFilter::SetFile(const File &f) 
        """
        return _gdcmswig.PythonFilter_SetFile(self, f)

    def GetFile(self, *args):
        r"""
        const File&
        gdcm::PythonFilter::GetFile() const 
        """
        return _gdcmswig.PythonFilter_GetFile(self, *args)

# Register PythonFilter in _gdcmswig:
_gdcmswig.PythonFilter_swigregister(PythonFilter)
class TagPath(object):
    r"""


    class to handle a path of tag.

    Any Resemblance to Existing XPath is Purely
    Coincidentalftp://medical.nema.org/medical/dicom/supps/sup118_pc.pdf

    C++ includes: gdcmTagPath.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::TagPath::TagPath()"""
        _gdcmswig.TagPath_swiginit(self, _gdcmswig.new_TagPath())
    __swig_destroy__ = _gdcmswig.delete_TagPath

    def Print(self, arg2):
        r"""
        void
        gdcm::TagPath::Print(std::ostream &) const 
        """
        return _gdcmswig.TagPath_Print(self, arg2)

    def ConstructFromString(self, path):
        r"""
        bool
        gdcm::TagPath::ConstructFromString(const char *path)

        "/0018,0018/"... No space allowed, comma is use to separate tag
        group from tag element and slash is used to separate tag return false
        if invalid 
        """
        return _gdcmswig.TagPath_ConstructFromString(self, path)

    @staticmethod
    def IsValid(path):
        return _gdcmswig.TagPath_IsValid(path)

    def ConstructFromTagList(self, l, n):
        r"""
        bool
        gdcm::TagPath::ConstructFromTagList(Tag const *l, unsigned int n)

        Construct from a list of tags. 
        """
        return _gdcmswig.TagPath_ConstructFromTagList(self, l, n)

    def Push(self, *args):
        r"""
        bool
        gdcm::TagPath::Push(unsigned int itemnum) 
        """
        return _gdcmswig.TagPath_Push(self, *args)

# Register TagPath in _gdcmswig:
_gdcmswig.TagPath_swigregister(TagPath)
class BitmapToBitmapFilter(object):
    r"""


    BitmapToBitmapFilter class.

    Super class for all filter taking an image and producing an output
    image

    C++ includes: gdcmBitmapToBitmapFilter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::BitmapToBitmapFilter::BitmapToBitmapFilter()"""
        _gdcmswig.BitmapToBitmapFilter_swiginit(self, _gdcmswig.new_BitmapToBitmapFilter())
    __swig_destroy__ = _gdcmswig.delete_BitmapToBitmapFilter

    def SetInput(self, image):
        r"""
        void
        gdcm::BitmapToBitmapFilter::SetInput(const Bitmap &image)

        Set input image. 
        """
        return _gdcmswig.BitmapToBitmapFilter_SetInput(self, image)

    def GetOutput(self):
        r"""
        const
        Bitmap& gdcm::BitmapToBitmapFilter::GetOutput() const

        Get Output image. 
        """
        return _gdcmswig.BitmapToBitmapFilter_GetOutput(self)

    def GetOutputAsBitmap(self):
        r"""const Bitmap& gdcm::BitmapToBitmapFilter::GetOutputAsBitmap() const"""
        return _gdcmswig.BitmapToBitmapFilter_GetOutputAsBitmap(self)

# Register BitmapToBitmapFilter in _gdcmswig:
_gdcmswig.BitmapToBitmapFilter_swigregister(BitmapToBitmapFilter)
class PixmapToPixmapFilter(BitmapToBitmapFilter):
    r"""


    PixmapToPixmapFilter class.

    Super class for all filter taking an image and producing an output
    image

    C++ includes: gdcmPixmapToPixmapFilter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PixmapToPixmapFilter::PixmapToPixmapFilter()"""
        _gdcmswig.PixmapToPixmapFilter_swiginit(self, _gdcmswig.new_PixmapToPixmapFilter())
    __swig_destroy__ = _gdcmswig.delete_PixmapToPixmapFilter

    def GetInput(self):
        r"""
        Pixmap&
        gdcm::PixmapToPixmapFilter::GetInput() 
        """
        return _gdcmswig.PixmapToPixmapFilter_GetInput(self)

    def GetOutput(self):
        r"""
        const
        Pixmap& gdcm::PixmapToPixmapFilter::GetOutput() const

        Get Output image. 
        """
        return _gdcmswig.PixmapToPixmapFilter_GetOutput(self)

    def GetOutputAsPixmap(self):
        r"""const Pixmap& gdcm::PixmapToPixmapFilter::GetOutputAsPixmap() const"""
        return _gdcmswig.PixmapToPixmapFilter_GetOutputAsPixmap(self)

# Register PixmapToPixmapFilter in _gdcmswig:
_gdcmswig.PixmapToPixmapFilter_swigregister(PixmapToPixmapFilter)
class ImageToImageFilter(PixmapToPixmapFilter):
    r"""


    ImageToImageFilter class.

    Super class for all filter taking an image and producing an output
    image

    C++ includes: gdcmImageToImageFilter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::ImageToImageFilter::ImageToImageFilter()"""
        _gdcmswig.ImageToImageFilter_swiginit(self, _gdcmswig.new_ImageToImageFilter())
    __swig_destroy__ = _gdcmswig.delete_ImageToImageFilter

    def GetInput(self):
        r"""
        Image&
        gdcm::ImageToImageFilter::GetInput() 
        """
        return _gdcmswig.ImageToImageFilter_GetInput(self)

    def GetOutput(self):
        r"""
        const
        Image& gdcm::ImageToImageFilter::GetOutput() const

        Get Output image. 
        """
        return _gdcmswig.ImageToImageFilter_GetOutput(self)

# Register ImageToImageFilter in _gdcmswig:
_gdcmswig.ImageToImageFilter_swigregister(ImageToImageFilter)
class SOPClassUIDToIOD(object):
    r"""


    Class convert a class SOP Class UID into IOD.

    Reference PS 3.4 Table B.5-1 STANDARD SOP CLASSES

    C++ includes: gdcmSOPClassUIDToIOD.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def GetIOD(uid):
        return _gdcmswig.SOPClassUIDToIOD_GetIOD(uid)

    @staticmethod
    def GetNumberOfSOPClassToIOD():
        return _gdcmswig.SOPClassUIDToIOD_GetNumberOfSOPClassToIOD()

    @staticmethod
    def GetSOPClassUIDToIODs():
        return _gdcmswig.SOPClassUIDToIOD_GetSOPClassUIDToIODs()

    @staticmethod
    def GetSOPClassUIDToIOD(i):
        return _gdcmswig.SOPClassUIDToIOD_GetSOPClassUIDToIOD(i)

    @staticmethod
    def GetSOPClassUIDFromIOD(iod):
        return _gdcmswig.SOPClassUIDToIOD_GetSOPClassUIDFromIOD(iod)

    @staticmethod
    def GetIODFromSOPClassUID(sopclassuid):
        return _gdcmswig.SOPClassUIDToIOD_GetIODFromSOPClassUID(sopclassuid)

    def __init__(self):
        _gdcmswig.SOPClassUIDToIOD_swiginit(self, _gdcmswig.new_SOPClassUIDToIOD())
    __swig_destroy__ = _gdcmswig.delete_SOPClassUIDToIOD

# Register SOPClassUIDToIOD in _gdcmswig:
_gdcmswig.SOPClassUIDToIOD_swigregister(SOPClassUIDToIOD)
class ImageCodec(object):
    r"""


    ImageCodec.

    Main codec, this is a central place for all implementation

    C++ includes: gdcmImageCodec.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::ImageCodec::ImageCodec()"""
        if self.__class__ == ImageCodec:
            _self = None
        else:
            _self = self
        _gdcmswig.ImageCodec_swiginit(self, _gdcmswig.new_ImageCodec(_self, ))
    __swig_destroy__ = _gdcmswig.delete_ImageCodec

    def CanCode(self, arg2):
        r"""
        bool
        gdcm::ImageCodec::CanCode(TransferSyntax const &) const override

        Return whether this coder support this transfer syntax (can code it)

        """
        return _gdcmswig.ImageCodec_CanCode(self, arg2)

    def CanDecode(self, arg2):
        r"""
        bool
        gdcm::ImageCodec::CanDecode(TransferSyntax const &) const override

        Return whether this decoder support this transfer syntax (can decode
        it) 
        """
        return _gdcmswig.ImageCodec_CanDecode(self, arg2)

    def Decode(self, is_, os):
        r"""
        bool
        gdcm::ImageCodec::Decode(DataElement const &is_, DataElement &os)
        override

        Decode. 
        """
        return _gdcmswig.ImageCodec_Decode(self, is_, os)

    def IsLossy(self):
        r"""
        bool
        gdcm::ImageCodec::IsLossy() const 
        """
        return _gdcmswig.ImageCodec_IsLossy(self)

    def SetLossyFlag(self, l):
        r"""
        void
        gdcm::ImageCodec::SetLossyFlag(bool l) 
        """
        return _gdcmswig.ImageCodec_SetLossyFlag(self, l)

    def GetLossyFlag(self):
        r"""
        bool
        gdcm::ImageCodec::GetLossyFlag() const 
        """
        return _gdcmswig.ImageCodec_GetLossyFlag(self)

    def GetHeaderInfo(self, is_, ts):
        r"""
        virtual bool
        gdcm::ImageCodec::GetHeaderInfo(std::istream &is_, TransferSyntax &ts)

        """
        return _gdcmswig.ImageCodec_GetHeaderInfo(self, is_, ts)

    def Clone(self):
        r"""
        virtual ImageCodec*
        gdcm::ImageCodec::Clone() const =0 
        """
        return _gdcmswig.ImageCodec_Clone(self)

    def IsValid(self, pi):
        return _gdcmswig.ImageCodec_IsValid(self, pi)

    def GetPlanarConfiguration(self):
        r"""unsigned int gdcm::ImageCodec::GetPlanarConfiguration() const"""
        return _gdcmswig.ImageCodec_GetPlanarConfiguration(self)

    def SetPlanarConfiguration(self, pc):
        r"""
        void
        gdcm::ImageCodec::SetPlanarConfiguration(unsigned int pc) 
        """
        return _gdcmswig.ImageCodec_SetPlanarConfiguration(self, pc)

    def GetPixelFormat(self, *args):
        r"""
        const
        PixelFormat& gdcm::ImageCodec::GetPixelFormat() const 
        """
        return _gdcmswig.ImageCodec_GetPixelFormat(self, *args)

    def SetPixelFormat(self, pf):
        r"""
        virtual void
        gdcm::ImageCodec::SetPixelFormat(PixelFormat const &pf) 
        """
        return _gdcmswig.ImageCodec_SetPixelFormat(self, pf)

    def GetPhotometricInterpretation(self):
        r"""
        const PhotometricInterpretation&
        gdcm::ImageCodec::GetPhotometricInterpretation() const 
        """
        return _gdcmswig.ImageCodec_GetPhotometricInterpretation(self)

    def SetPhotometricInterpretation(self, pi):
        r"""
        void
        gdcm::ImageCodec::SetPhotometricInterpretation(PhotometricInterpretation
        const &pi) 
        """
        return _gdcmswig.ImageCodec_SetPhotometricInterpretation(self, pi)

    def GetNeedByteSwap(self):
        r"""
        bool
        gdcm::ImageCodec::GetNeedByteSwap() const 
        """
        return _gdcmswig.ImageCodec_GetNeedByteSwap(self)

    def SetNeedByteSwap(self, b):
        r"""
        void
        gdcm::ImageCodec::SetNeedByteSwap(bool b) 
        """
        return _gdcmswig.ImageCodec_SetNeedByteSwap(self, b)

    def SetNeedOverlayCleanup(self, b):
        r"""
        void
        gdcm::ImageCodec::SetNeedOverlayCleanup(bool b) 
        """
        return _gdcmswig.ImageCodec_SetNeedOverlayCleanup(self, b)

    def SetLUT(self, lut):
        r"""
        void
        gdcm::ImageCodec::SetLUT(LookupTable const &lut) 
        """
        return _gdcmswig.ImageCodec_SetLUT(self, lut)

    def GetLUT(self):
        r"""
        const LookupTable&
        gdcm::ImageCodec::GetLUT() const 
        """
        return _gdcmswig.ImageCodec_GetLUT(self)

    def SetDimensions(self, d):
        r"""
        void
        gdcm::ImageCodec::SetDimensions(const unsigned int d[3]) 
        """
        return _gdcmswig.ImageCodec_SetDimensions(self, d)

    def GetDimensions(self):
        r"""
        const
        unsigned int* gdcm::ImageCodec::GetDimensions() const 
        """
        return _gdcmswig.ImageCodec_GetDimensions(self)

    def SetNumberOfDimensions(self, dim):
        r"""
        void
        gdcm::ImageCodec::SetNumberOfDimensions(unsigned int dim) 
        """
        return _gdcmswig.ImageCodec_SetNumberOfDimensions(self, dim)

    def GetNumberOfDimensions(self):
        r"""unsigned int gdcm::ImageCodec::GetNumberOfDimensions() const"""
        return _gdcmswig.ImageCodec_GetNumberOfDimensions(self)

    def CleanupUnusedBits(self, data, datalen):
        r"""
        bool
        gdcm::ImageCodec::CleanupUnusedBits(char *data, size_t datalen) 
        """
        return _gdcmswig.ImageCodec_CleanupUnusedBits(self, data, datalen)

    def StartEncode(self, os):
        return _gdcmswig.ImageCodec_StartEncode(self, os)

    def IsRowEncoder(self):
        return _gdcmswig.ImageCodec_IsRowEncoder(self)

    def IsFrameEncoder(self):
        return _gdcmswig.ImageCodec_IsFrameEncoder(self)

    def AppendRowEncode(self, out, data, datalen):
        return _gdcmswig.ImageCodec_AppendRowEncode(self, out, data, datalen)

    def AppendFrameEncode(self, out, data, datalen):
        return _gdcmswig.ImageCodec_AppendFrameEncode(self, out, data, datalen)

    def StopEncode(self, os):
        return _gdcmswig.ImageCodec_StopEncode(self, os)
    def __disown__(self):
        self.this.disown()
        _gdcmswig.disown_ImageCodec(self)
        return weakref.proxy(self)

# Register ImageCodec in _gdcmswig:
_gdcmswig.ImageCodec_swigregister(ImageCodec)
class RLECodec(ImageCodec):
    r"""


    Class to do RLE.

    ANSI X3.9 A.4.2 RLE Compression Annex G defines a RLE Compression
    Transfer Syntax. This transfer Syntax is identified by the UID value
    "1.2.840.10008.1.2.5". If the object allows multi-frame images in
    the pixel data field, then each frame shall be encoded separately.
    Each frame shall be encoded in one and only one Fragment (see PS
    3.5.8.2).

    C++ includes: gdcmRLECodec.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::RLECodec::RLECodec()"""
        _gdcmswig.RLECodec_swiginit(self, _gdcmswig.new_RLECodec())
    __swig_destroy__ = _gdcmswig.delete_RLECodec

    def CanCode(self, ts):
        r"""
        bool
        gdcm::RLECodec::CanCode(TransferSyntax const &ts) const override

        Return whether this coder support this transfer syntax (can code it)

        """
        return _gdcmswig.RLECodec_CanCode(self, ts)

    def CanDecode(self, ts):
        r"""
        bool
        gdcm::RLECodec::CanDecode(TransferSyntax const &ts) const override

        Return whether this decoder support this transfer syntax (can decode
        it) 
        """
        return _gdcmswig.RLECodec_CanDecode(self, ts)

    def Decode(self, _is, os):
        r"""
        bool
        gdcm::RLECodec::Decode(DataElement const &is, DataElement &os)
        override

        Decode. 
        """
        return _gdcmswig.RLECodec_Decode(self, _is, os)

    def GetBufferLength(self):
        r"""
        unsigned long
        gdcm::RLECodec::GetBufferLength() const 
        """
        return _gdcmswig.RLECodec_GetBufferLength(self)

    def SetBufferLength(self, l):
        r"""
        void
        gdcm::RLECodec::SetBufferLength(unsigned long l) 
        """
        return _gdcmswig.RLECodec_SetBufferLength(self, l)

    def Code(self, _in, out):
        r"""
        bool
        gdcm::RLECodec::Code(DataElement const &in, DataElement &out) override

        Code. 
        """
        return _gdcmswig.RLECodec_Code(self, _in, out)

    def GetHeaderInfo(self, _is, ts):
        r"""
        bool
        gdcm::RLECodec::GetHeaderInfo(std::istream &is, TransferSyntax &ts)
        override 
        """
        return _gdcmswig.RLECodec_GetHeaderInfo(self, _is, ts)

    def Clone(self):
        r"""
        ImageCodec*
        gdcm::RLECodec::Clone() const override 
        """
        return _gdcmswig.RLECodec_Clone(self)

    def SetLength(self, l):
        r"""
        void
        gdcm::RLECodec::SetLength(unsigned long l) 
        """
        return _gdcmswig.RLECodec_SetLength(self, l)

# Register RLECodec in _gdcmswig:
_gdcmswig.RLECodec_swigregister(RLECodec)
class JPEGCodec(ImageCodec):
    r"""


    JPEG codec.

    Class to do JPEG (8bits, 12bits, 16bits lossy & lossless). It
    redispatch in between the different codec implementation: JPEG8Codec,
    JPEG12Codec & JPEG16Codec It also support inconsistency in between
    DICOM header and JPEG compressed stream ImageCodec implementation for
    the JPEG case

    Things you should know if you ever want to dive into DICOM/JPEG world
    (among other):

    http://groups.google.com/group/comp.protocols.dicom/browse_thread/thread/625e46919f2080e1

    http://groups.google.com/group/comp.protocols.dicom/browse_thread/thread/75fdfccc65a6243

    http://groups.google.com/group/comp.protocols.dicom/browse_thread/thread/2d525ef6a2f093ed

    http://groups.google.com/group/comp.protocols.dicom/browse_thread/thread/6b93af410f8c921f

    C++ includes: gdcmJPEGCodec.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::JPEGCodec::JPEGCodec()"""
        _gdcmswig.JPEGCodec_swiginit(self, _gdcmswig.new_JPEGCodec())
    __swig_destroy__ = _gdcmswig.delete_JPEGCodec

    def CanDecode(self, ts):
        r"""
        bool
        gdcm::JPEGCodec::CanDecode(TransferSyntax const &ts) const override

        Return whether this decoder support this transfer syntax (can decode
        it) 
        """
        return _gdcmswig.JPEGCodec_CanDecode(self, ts)

    def CanCode(self, ts):
        r"""
        bool
        gdcm::JPEGCodec::CanCode(TransferSyntax const &ts) const override

        Return whether this coder support this transfer syntax (can code it)

        """
        return _gdcmswig.JPEGCodec_CanCode(self, ts)

    def Decode(self, _is, os):
        r"""
        bool
        gdcm::JPEGCodec::Decode(DataElement const &is, DataElement &os)
        override

        Decode. 
        """
        return _gdcmswig.JPEGCodec_Decode(self, _is, os)

    def SetPixelFormat(self, pf):
        r"""
        void
        gdcm::JPEGCodec::SetPixelFormat(PixelFormat const &pf) override 
        """
        return _gdcmswig.JPEGCodec_SetPixelFormat(self, pf)

    def ComputeOffsetTable(self, b):
        r"""
        void
        gdcm::JPEGCodec::ComputeOffsetTable(bool b)

        Compute the offset table: 
        """
        return _gdcmswig.JPEGCodec_ComputeOffsetTable(self, b)

    def Code(self, _in, out):
        r"""
        bool
        gdcm::JPEGCodec::Code(DataElement const &in, DataElement &out)
        override

        Compress into JPEG. 
        """
        return _gdcmswig.JPEGCodec_Code(self, _in, out)

    def GetHeaderInfo(self, _is, ts):
        r"""
        bool
        gdcm::JPEGCodec::GetHeaderInfo(std::istream &is, TransferSyntax &ts)
        override 
        """
        return _gdcmswig.JPEGCodec_GetHeaderInfo(self, _is, ts)

    def Clone(self):
        r"""
        ImageCodec*
        gdcm::JPEGCodec::Clone() const override 
        """
        return _gdcmswig.JPEGCodec_Clone(self)

    def SetQuality(self, q):
        r"""
        void
        gdcm::JPEGCodec::SetQuality(double q) 
        """
        return _gdcmswig.JPEGCodec_SetQuality(self, q)

    def GetQuality(self):
        r"""
        double
        gdcm::JPEGCodec::GetQuality() const 
        """
        return _gdcmswig.JPEGCodec_GetQuality(self)

    def SetLossless(self, l):
        r"""
        void
        gdcm::JPEGCodec::SetLossless(bool l) 
        """
        return _gdcmswig.JPEGCodec_SetLossless(self, l)

    def GetLossless(self):
        r"""
        bool
        gdcm::JPEGCodec::GetLossless() const 
        """
        return _gdcmswig.JPEGCodec_GetLossless(self)

    def EncodeBuffer(self, out, inbuffer, inlen):
        r"""
        virtual bool
        gdcm::JPEGCodec::EncodeBuffer(std::ostream &out, const char *inbuffer,
        size_t inlen) 
        """
        return _gdcmswig.JPEGCodec_EncodeBuffer(self, out, inbuffer, inlen)

# Register JPEGCodec in _gdcmswig:
_gdcmswig.JPEGCodec_swigregister(JPEGCodec)
class JPEGLSCodec(ImageCodec):
    r"""


    JPEG-LS.

    codec that implement the JPEG-LS compression this is an implementation
    of ImageCodec for JPEG-LS  It uses the CharLS JPEG-LS
    implementationhttps://github.com/team-charls/charls

    C++ includes: gdcmJPEGLSCodec.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::JPEGLSCodec::JPEGLSCodec()"""
        _gdcmswig.JPEGLSCodec_swiginit(self, _gdcmswig.new_JPEGLSCodec())
    __swig_destroy__ = _gdcmswig.delete_JPEGLSCodec

    def CanDecode(self, ts):
        r"""
        bool
        gdcm::JPEGLSCodec::CanDecode(TransferSyntax const &ts) const override

        Return whether this decoder support this transfer syntax (can decode
        it) 
        """
        return _gdcmswig.JPEGLSCodec_CanDecode(self, ts)

    def CanCode(self, ts):
        r"""
        bool
        gdcm::JPEGLSCodec::CanCode(TransferSyntax const &ts) const override

        Return whether this coder support this transfer syntax (can code it)

        """
        return _gdcmswig.JPEGLSCodec_CanCode(self, ts)

    def GetBufferLength(self):
        r"""
        unsigned
        long gdcm::JPEGLSCodec::GetBufferLength() const 
        """
        return _gdcmswig.JPEGLSCodec_GetBufferLength(self)

    def SetBufferLength(self, l):
        r"""
        void
        gdcm::JPEGLSCodec::SetBufferLength(unsigned long l) 
        """
        return _gdcmswig.JPEGLSCodec_SetBufferLength(self, l)

    def Decode(self, *args):
        r"""
        bool
        gdcm::JPEGLSCodec::Decode(DataElement const &is, DataElement &os)
        override

        Decode. 
        """
        return _gdcmswig.JPEGLSCodec_Decode(self, *args)

    def Code(self, _in, out):
        r"""
        bool
        gdcm::JPEGLSCodec::Code(DataElement const &in, DataElement &out)
        override

        Code. 
        """
        return _gdcmswig.JPEGLSCodec_Code(self, _in, out)

    def GetHeaderInfo(self, _is, ts):
        r"""
        bool
        gdcm::JPEGLSCodec::GetHeaderInfo(std::istream &is, TransferSyntax &ts)
        override 
        """
        return _gdcmswig.JPEGLSCodec_GetHeaderInfo(self, _is, ts)

    def Clone(self):
        r"""
        ImageCodec*
        gdcm::JPEGLSCodec::Clone() const override 
        """
        return _gdcmswig.JPEGLSCodec_Clone(self)

    def SetLossless(self, l):
        r"""
        void
        gdcm::JPEGLSCodec::SetLossless(bool l) 
        """
        return _gdcmswig.JPEGLSCodec_SetLossless(self, l)

    def GetLossless(self):
        r"""
        bool
        gdcm::JPEGLSCodec::GetLossless() const 
        """
        return _gdcmswig.JPEGLSCodec_GetLossless(self)

    def SetLossyError(self, error):
        r"""
        void
        gdcm::JPEGLSCodec::SetLossyError(int error)

        [0-3] generally 
        """
        return _gdcmswig.JPEGLSCodec_SetLossyError(self, error)

# Register JPEGLSCodec in _gdcmswig:
_gdcmswig.JPEGLSCodec_swigregister(JPEGLSCodec)
class JPEG2000Codec(ImageCodec):
    r"""


    Class to do JPEG 2000.

    the class will produce JPC (JPEG 2000 codestream), since some private
    implementor are using full jp2 file the decoder tolerate jp2 input
    this is an implementation of an ImageCodec

    C++ includes: gdcmJPEG2000Codec.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::JPEG2000Codec::JPEG2000Codec()"""
        _gdcmswig.JPEG2000Codec_swiginit(self, _gdcmswig.new_JPEG2000Codec())
    __swig_destroy__ = _gdcmswig.delete_JPEG2000Codec

    def CanDecode(self, ts):
        r"""
        bool
        gdcm::JPEG2000Codec::CanDecode(TransferSyntax const &ts) const
        override

        Return whether this decoder support this transfer syntax (can decode
        it) 
        """
        return _gdcmswig.JPEG2000Codec_CanDecode(self, ts)

    def CanCode(self, ts):
        r"""
        bool
        gdcm::JPEG2000Codec::CanCode(TransferSyntax const &ts) const override

        Return whether this coder support this transfer syntax (can code it)

        """
        return _gdcmswig.JPEG2000Codec_CanCode(self, ts)

    def Decode(self, _is, os):
        r"""
        bool
        gdcm::JPEG2000Codec::Decode(DataElement const &is, DataElement &os)
        override

        Decode. 
        """
        return _gdcmswig.JPEG2000Codec_Decode(self, _is, os)

    def Code(self, _in, out):
        r"""
        bool
        gdcm::JPEG2000Codec::Code(DataElement const &in, DataElement &out)
        override

        Code. 
        """
        return _gdcmswig.JPEG2000Codec_Code(self, _in, out)

    def GetHeaderInfo(self, _is, ts):
        r"""
        bool
        gdcm::JPEG2000Codec::GetHeaderInfo(std::istream &is, TransferSyntax
        &ts) override 
        """
        return _gdcmswig.JPEG2000Codec_GetHeaderInfo(self, _is, ts)

    def Clone(self):
        r"""
        ImageCodec*
        gdcm::JPEG2000Codec::Clone() const override 
        """
        return _gdcmswig.JPEG2000Codec_Clone(self)

    def SetRate(self, idx, rate):
        r"""
        void
        gdcm::JPEG2000Codec::SetRate(unsigned int idx, double rate) 
        """
        return _gdcmswig.JPEG2000Codec_SetRate(self, idx, rate)

    def GetRate(self, idx=0):
        r"""
        double
        gdcm::JPEG2000Codec::GetRate(unsigned int idx=0) const 
        """
        return _gdcmswig.JPEG2000Codec_GetRate(self, idx)

    def SetQuality(self, idx, q):
        r"""
        void
        gdcm::JPEG2000Codec::SetQuality(unsigned int idx, double q) 
        """
        return _gdcmswig.JPEG2000Codec_SetQuality(self, idx, q)

    def GetQuality(self, idx=0):
        r"""
        double
        gdcm::JPEG2000Codec::GetQuality(unsigned int idx=0) const 
        """
        return _gdcmswig.JPEG2000Codec_GetQuality(self, idx)

    def SetTileSize(self, tx, ty):
        r"""
        void
        gdcm::JPEG2000Codec::SetTileSize(unsigned int tx, unsigned int ty) 
        """
        return _gdcmswig.JPEG2000Codec_SetTileSize(self, tx, ty)

    def SetNumberOfResolutions(self, nres):
        r"""void gdcm::JPEG2000Codec::SetNumberOfResolutions(unsigned int nres)"""
        return _gdcmswig.JPEG2000Codec_SetNumberOfResolutions(self, nres)

    def SetNumberOfThreadsForDecompression(self, nThreads):
        r"""
        void
        gdcm::JPEG2000Codec::SetNumberOfThreadsForDecompression(int nThreads)

        Set Number of threads

        Parameters:
        -----------

        nThreads:  : number of threads for decompression codec, if 0 or 1
        decompression is done in current thread, if negative value is set
        determine how many virtual threads are available 
        """
        return _gdcmswig.JPEG2000Codec_SetNumberOfThreadsForDecompression(self, nThreads)

    def SetReversible(self, res):
        r"""
        void
        gdcm::JPEG2000Codec::SetReversible(bool res) 
        """
        return _gdcmswig.JPEG2000Codec_SetReversible(self, res)

    def SetMCT(self, mct):
        r"""
        void
        gdcm::JPEG2000Codec::SetMCT(unsigned int mct) 
        """
        return _gdcmswig.JPEG2000Codec_SetMCT(self, mct)

# Register JPEG2000Codec in _gdcmswig:
_gdcmswig.JPEG2000Codec_swigregister(JPEG2000Codec)
class PNMCodec(ImageCodec):
    r"""


    Class to do PNM.

    PNM is the Portable anymap file format. The main web page can be found
    at:http://netpbm.sourceforge.net/ Only support P5 & P6 PNM file
    (binary grayscale and binary rgb)

    C++ includes: gdcmPNMCodec.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PNMCodec::PNMCodec()"""
        _gdcmswig.PNMCodec_swiginit(self, _gdcmswig.new_PNMCodec())
    __swig_destroy__ = _gdcmswig.delete_PNMCodec

    def CanDecode(self, ts):
        r"""
        bool
        gdcm::PNMCodec::CanDecode(TransferSyntax const &ts) const override

        Return whether this decoder support this transfer syntax (can decode
        it) 
        """
        return _gdcmswig.PNMCodec_CanDecode(self, ts)

    def CanCode(self, ts):
        r"""
        bool
        gdcm::PNMCodec::CanCode(TransferSyntax const &ts) const override

        Return whether this coder support this transfer syntax (can code it)

        """
        return _gdcmswig.PNMCodec_CanCode(self, ts)

    def GetBufferLength(self):
        r"""
        unsigned long
        gdcm::PNMCodec::GetBufferLength() const 
        """
        return _gdcmswig.PNMCodec_GetBufferLength(self)

    def SetBufferLength(self, l):
        r"""
        void
        gdcm::PNMCodec::SetBufferLength(unsigned long l) 
        """
        return _gdcmswig.PNMCodec_SetBufferLength(self, l)

    def GetHeaderInfo(self, _is, ts):
        r"""
        bool
        gdcm::PNMCodec::GetHeaderInfo(std::istream &is, TransferSyntax &ts)
        override 
        """
        return _gdcmswig.PNMCodec_GetHeaderInfo(self, _is, ts)

    def Clone(self):
        r"""
        ImageCodec*
        gdcm::PNMCodec::Clone() const override 
        """
        return _gdcmswig.PNMCodec_Clone(self)

    def Read(self, filename, out):
        r"""
        bool
        gdcm::PNMCodec::Read(const char *filename, DataElement &out) const 
        """
        return _gdcmswig.PNMCodec_Read(self, filename, out)

    def Write(self, filename, out):
        r"""
        bool
        gdcm::PNMCodec::Write(const char *filename, const DataElement &out)
        const 
        """
        return _gdcmswig.PNMCodec_Write(self, filename, out)

# Register PNMCodec in _gdcmswig:
_gdcmswig.PNMCodec_swigregister(PNMCodec)
class ImageChangeTransferSyntax(ImageToImageFilter):
    r"""


    ImageChangeTransferSyntax class.

    Class to change the transfer syntax of an input DICOM

    If only Force param is set but no input TransferSyntax is set, it is
    assumed that user only wants to inspect encapsulated stream (advanced
    dev. option).

    When using UserCodec it is very important that the TransferSyntax (as
    set in SetTransferSyntax) is actually understood by UserCodec (ie.
    UserCodec->CanCode( TransferSyntax ) ). Otherwise the behavior is to
    use a default codec.

    See:   JPEGCodec JPEGLSCodec JPEG2000Codec

    C++ includes: gdcmImageChangeTransferSyntax.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::ImageChangeTransferSyntax::ImageChangeTransferSyntax()"""
        _gdcmswig.ImageChangeTransferSyntax_swiginit(self, _gdcmswig.new_ImageChangeTransferSyntax())
    __swig_destroy__ = _gdcmswig.delete_ImageChangeTransferSyntax

    def SetTransferSyntax(self, ts):
        r"""
        void
        gdcm::ImageChangeTransferSyntax::SetTransferSyntax(const
        TransferSyntax &ts)

        Set target Transfer Syntax. 
        """
        return _gdcmswig.ImageChangeTransferSyntax_SetTransferSyntax(self, ts)

    def GetTransferSyntax(self):
        r"""
        const
        TransferSyntax& gdcm::ImageChangeTransferSyntax::GetTransferSyntax()
        const

        Get Transfer Syntax. 
        """
        return _gdcmswig.ImageChangeTransferSyntax_GetTransferSyntax(self)

    def Change(self):
        r"""
        bool
        gdcm::ImageChangeTransferSyntax::Change()

        Change. 
        """
        return _gdcmswig.ImageChangeTransferSyntax_Change(self)

    def SetCompressIconImage(self, b):
        r"""
        void
        gdcm::ImageChangeTransferSyntax::SetCompressIconImage(bool b)

        Decide whether or not to also compress the Icon Image using the same
        Transfer Syntax. Default is to simply decompress icon image 
        """
        return _gdcmswig.ImageChangeTransferSyntax_SetCompressIconImage(self, b)

    def SetForce(self, f):
        r"""
        void gdcm::ImageChangeTransferSyntax::SetForce(bool f)

        When target Transfer Syntax is identical to input target syntax, no
        operation is actually done. This is an issue when someone wants to re-
        compress using GDCM internal implementation a JPEG (for example) image

        """
        return _gdcmswig.ImageChangeTransferSyntax_SetForce(self, f)

    def SetUserCodec(self, ic):
        r"""
        void gdcm::ImageChangeTransferSyntax::SetUserCodec(ImageCodec *ic)

        Allow user to specify exactly which codec to use. this is needed to
        specify special qualities or compression option. WARNING:  if the
        codec 'ic' is not compatible with the TransferSyntax requested, it
        will not be used. It is the user responsibility to check that
        UserCodec->CanCode( TransferSyntax ) 
        """
        return _gdcmswig.ImageChangeTransferSyntax_SetUserCodec(self, ic)

# Register ImageChangeTransferSyntax in _gdcmswig:
_gdcmswig.ImageChangeTransferSyntax_swigregister(ImageChangeTransferSyntax)
class SmartPtrFCTS(object):
    r"""


    Class for Smart Pointer.

    Will only work for subclass of gdcm::Object See tr1/shared_ptr for a
    more general approach (not invasive) #include <tr1/memory> {
    shared_ptr<Bla> b(new Bla); } Class partly based on post by Bill
    Hubauer:http://groups.google.com/group/comp.lang.c++/msg/173ddc38a827a930

    See:  http://www.davethehat.com/articles/smartp.htm  and
    itk::SmartPointer

    C++ includes: gdcmSmartPointer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""gdcm::SmartPointer< ObjectType >::SmartPointer(ObjectType const &p)"""
        _gdcmswig.SmartPtrFCTS_swiginit(self, _gdcmswig.new_SmartPtrFCTS(*args))
    __swig_destroy__ = _gdcmswig.delete_SmartPtrFCTS

    def __deref__(self):
        return _gdcmswig.SmartPtrFCTS___deref__(self)

    def __ref__(self):
        return _gdcmswig.SmartPtrFCTS___ref__(self)

    def GetPointer(self):
        r"""
        ObjectType*
        gdcm::SmartPointer< ObjectType >::GetPointer() const

        Explicit function to retrieve the pointer. 
        """
        return _gdcmswig.SmartPtrFCTS_GetPointer(self)

    def SetInputFileName(self, filename_native):
        r"""
        void
        gdcm::FileChangeTransferSyntax::SetInputFileName(const char
        *filename_native)

        Set input filename (raw DICOM) 
        """
        return _gdcmswig.SmartPtrFCTS_SetInputFileName(self, filename_native)

    def SetOutputFileName(self, filename_native):
        r"""
        void
        gdcm::FileChangeTransferSyntax::SetOutputFileName(const char
        *filename_native)

        Set output filename (target compressed DICOM) 
        """
        return _gdcmswig.SmartPtrFCTS_SetOutputFileName(self, filename_native)

    def Change(self):
        r"""
        bool
        gdcm::FileChangeTransferSyntax::Change()

        Change the transfer syntax. 
        """
        return _gdcmswig.SmartPtrFCTS_Change(self)

    def SetTransferSyntax(self, ts):
        r"""
        void
        gdcm::FileChangeTransferSyntax::SetTransferSyntax(TransferSyntax const
        &ts)

        Specify the Target Transfer Syntax. 
        """
        return _gdcmswig.SmartPtrFCTS_SetTransferSyntax(self, ts)

    def GetCodec(self):
        r"""
        ImageCodec* gdcm::FileChangeTransferSyntax::GetCodec()

        Retrieve the actual codec (valid after calling SetTransferSyntax) Only
        advanced users should call this function. 
        """
        return _gdcmswig.SmartPtrFCTS_GetCodec(self)

    def New(self):
        return _gdcmswig.SmartPtrFCTS_New(self)

    def AddObserver(self, *args):
        r"""
        unsigned long
        gdcm::Subject::AddObserver(const Event &event, Command *) const 
        """
        return _gdcmswig.SmartPtrFCTS_AddObserver(self, *args)

    def GetCommand(self, tag):
        r"""
        Command*
        gdcm::Subject::GetCommand(unsigned long tag)

        Get the command associated with the given tag. NOTE: This returns a
        pointer to a Command, but it is safe to assign this to a
        Command::Pointer. Since Command inherits from LightObject, at this
        point in the code, only a pointer or a reference to the Command can be
        used. 
        """
        return _gdcmswig.SmartPtrFCTS_GetCommand(self, tag)

    def InvokeEvent(self, *args):
        r"""
        void
        gdcm::Subject::InvokeEvent(const Event &) const

        Call Execute on all the Commands observing this event id. The actions
        triggered by this call doesn't modify this object. 
        """
        return _gdcmswig.SmartPtrFCTS_InvokeEvent(self, *args)

    def RemoveObserver(self, tag):
        r"""
        void
        gdcm::Subject::RemoveObserver(unsigned long tag)

        Remove the observer with this tag value. 
        """
        return _gdcmswig.SmartPtrFCTS_RemoveObserver(self, tag)

    def RemoveAllObservers(self):
        r"""
        void
        gdcm::Subject::RemoveAllObservers()

        Remove all observers . 
        """
        return _gdcmswig.SmartPtrFCTS_RemoveAllObservers(self)

    def HasObserver(self, event):
        r"""
        bool
        gdcm::Subject::HasObserver(const Event &event) const

        Return true if an observer is registered for this event. 
        """
        return _gdcmswig.SmartPtrFCTS_HasObserver(self, event)

    def Print(self, arg2):
        r"""
        virtual void
        gdcm::Object::Print(std::ostream &) const 
        """
        return _gdcmswig.SmartPtrFCTS_Print(self, arg2)

# Register SmartPtrFCTS in _gdcmswig:
_gdcmswig.SmartPtrFCTS_swigregister(SmartPtrFCTS)
class FileChangeTransferSyntax(Subject):
    r"""


    FileChangeTransferSyntax.

    This class is a file-based (limited) replacement of the in-memory
    ImageChangeTransferSyntax.

    This class provide a file-based compression-only mechanism. It will
    take in an uncompressed DICOM image file (Pixel Data element). Then
    produced as output a compressed DICOM file (Transfer Syntax will be
    updated).

    Currently it supports the following transfer syntax:
    JPEGLosslessProcess14_1

    C++ includes: gdcmFileChangeTransferSyntax.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::FileChangeTransferSyntax::FileChangeTransferSyntax()"""
        _gdcmswig.FileChangeTransferSyntax_swiginit(self, _gdcmswig.new_FileChangeTransferSyntax())
    __swig_destroy__ = _gdcmswig.delete_FileChangeTransferSyntax

    def SetInputFileName(self, filename_native):
        r"""
        void
        gdcm::FileChangeTransferSyntax::SetInputFileName(const char
        *filename_native)

        Set input filename (raw DICOM) 
        """
        return _gdcmswig.FileChangeTransferSyntax_SetInputFileName(self, filename_native)

    def SetOutputFileName(self, filename_native):
        r"""
        void
        gdcm::FileChangeTransferSyntax::SetOutputFileName(const char
        *filename_native)

        Set output filename (target compressed DICOM) 
        """
        return _gdcmswig.FileChangeTransferSyntax_SetOutputFileName(self, filename_native)

    def Change(self):
        r"""
        bool
        gdcm::FileChangeTransferSyntax::Change()

        Change the transfer syntax. 
        """
        return _gdcmswig.FileChangeTransferSyntax_Change(self)

    def SetTransferSyntax(self, ts):
        r"""
        void
        gdcm::FileChangeTransferSyntax::SetTransferSyntax(TransferSyntax const
        &ts)

        Specify the Target Transfer Syntax. 
        """
        return _gdcmswig.FileChangeTransferSyntax_SetTransferSyntax(self, ts)

    def GetCodec(self):
        r"""
        ImageCodec* gdcm::FileChangeTransferSyntax::GetCodec()

        Retrieve the actual codec (valid after calling SetTransferSyntax) Only
        advanced users should call this function. 
        """
        return _gdcmswig.FileChangeTransferSyntax_GetCodec(self)

    @staticmethod
    def New():
        return _gdcmswig.FileChangeTransferSyntax_New()

# Register FileChangeTransferSyntax in _gdcmswig:
_gdcmswig.FileChangeTransferSyntax_swigregister(FileChangeTransferSyntax)
class ImageApplyLookupTable(ImageToImageFilter):
    r"""


    ImageApplyLookupTable class.

    It applies the LUT the PixelData (only PALETTE_COLOR images) Output
    will be a PhotometricInterpretation=RGB image

    C++ includes: gdcmImageApplyLookupTable.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::ImageApplyLookupTable::ImageApplyLookupTable()"""
        _gdcmswig.ImageApplyLookupTable_swiginit(self, _gdcmswig.new_ImageApplyLookupTable())
    __swig_destroy__ = _gdcmswig.delete_ImageApplyLookupTable

    def Apply(self):
        r"""
        bool
        gdcm::ImageApplyLookupTable::Apply()

        Apply. 
        """
        return _gdcmswig.ImageApplyLookupTable_Apply(self)

    def SetRGB8(self, b):
        r"""
        void
        gdcm::ImageApplyLookupTable::SetRGB8(bool b)

        RGB8 ? 
        """
        return _gdcmswig.ImageApplyLookupTable_SetRGB8(self, b)

# Register ImageApplyLookupTable in _gdcmswig:
_gdcmswig.ImageApplyLookupTable_swigregister(ImageApplyLookupTable)
class SplitMosaicFilter(object):
    r"""


    SplitMosaicFilter class.

    Class to reshuffle bytes for a SIEMENS Mosaic image Siemens CSA Image
    Header CSA:= Common Siemens Architecture, sometimes also known as
    Common syngo Architecture

    WARNING:  when private attributes are not found, the acquisition
    matrix is used to compute the NumberOfImagesInMosaic. This means
    trailing black slices will be considered in the volume (instead of
    discarded). CSA 0029,1010 is needed for correct NumberOfImagesInMosaic
    CSA 0029,1020 is needed to compute the correct origin without above
    info default are taken (may not be accurate).

    C++ includes: gdcmSplitMosaicFilter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::SplitMosaicFilter::SplitMosaicFilter()"""
        _gdcmswig.SplitMosaicFilter_swiginit(self, _gdcmswig.new_SplitMosaicFilter())
    __swig_destroy__ = _gdcmswig.delete_SplitMosaicFilter

    def Split(self):
        r"""
        bool
        gdcm::SplitMosaicFilter::Split()

        Split the SIEMENS MOSAIC image. 
        """
        return _gdcmswig.SplitMosaicFilter_Split(self)

    def ComputeMOSAICDimensions(self, dims):
        r"""
        bool
        gdcm::SplitMosaicFilter::ComputeMOSAICDimensions(unsigned int dims[3])

        Compute the new dimensions according to private information stored in
        the MOSAIC header. 
        """
        return _gdcmswig.SplitMosaicFilter_ComputeMOSAICDimensions(self, dims)

    def ComputeMOSAICSliceNormal(self, dims, inverted):
        r"""
        bool
        gdcm::SplitMosaicFilter::ComputeMOSAICSliceNormal(double dims[3], bool
        &inverted)

        Extract the value for SliceNormalVector (CSA header) 
        """
        return _gdcmswig.SplitMosaicFilter_ComputeMOSAICSliceNormal(self, dims, inverted)

    def ComputeMOSAICSlicePosition(self, pos, inverted):
        r"""
        bool
        gdcm::SplitMosaicFilter::ComputeMOSAICSlicePosition(double pos[3],
        bool inverted)

        Extract the value for ImagePositionPatient (requires inverted flag) 
        """
        return _gdcmswig.SplitMosaicFilter_ComputeMOSAICSlicePosition(self, pos, inverted)

    def ComputeMOSAICImagePositionPatient(self, pos, ipp, dircos, pixelspacing, image_dims, mosaic_dims, inverted):
        return _gdcmswig.SplitMosaicFilter_ComputeMOSAICImagePositionPatient(self, pos, ipp, dircos, pixelspacing, image_dims, mosaic_dims, inverted)

    def SetImage(self, image):
        r"""
        void
        gdcm::SplitMosaicFilter::SetImage(const Image &image) 
        """
        return _gdcmswig.SplitMosaicFilter_SetImage(self, image)

    def GetImage(self, *args):
        r"""
        const
        Image& gdcm::SplitMosaicFilter::GetImage() const 
        """
        return _gdcmswig.SplitMosaicFilter_GetImage(self, *args)

    def SetFile(self, f):
        r"""
        void
        gdcm::SplitMosaicFilter::SetFile(const File &f) 
        """
        return _gdcmswig.SplitMosaicFilter_SetFile(self, f)

    def GetFile(self, *args):
        r"""
        const File&
        gdcm::SplitMosaicFilter::GetFile() const 
        """
        return _gdcmswig.SplitMosaicFilter_GetFile(self, *args)

    @staticmethod
    def GetAcquisitionSize(size, ds):
        return _gdcmswig.SplitMosaicFilter_GetAcquisitionSize(size, ds)

    @staticmethod
    def GetNumberOfImagesInMosaic(file):
        return _gdcmswig.SplitMosaicFilter_GetNumberOfImagesInMosaic(file)

    @staticmethod
    def ComputeCSAImageHeaderInfo(ds, handleMissingPrivateCreator=True):
        return _gdcmswig.SplitMosaicFilter_ComputeCSAImageHeaderInfo(ds, handleMissingPrivateCreator)

    @staticmethod
    def ComputeCSASeriesHeaderInfo(ds, handleMissingPrivateCreator=True):
        return _gdcmswig.SplitMosaicFilter_ComputeCSASeriesHeaderInfo(ds, handleMissingPrivateCreator)

# Register SplitMosaicFilter in _gdcmswig:
_gdcmswig.SplitMosaicFilter_swigregister(SplitMosaicFilter)
class ImageChangePhotometricInterpretation(ImageToImageFilter):
    r"""


    ImageChangePhotometricInterpretation class.

    Class to change the Photometric Interpretation of an input DICOM

    C++ includes: gdcmImageChangePhotometricInterpretation.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::ImageChangePhotometricInterpretation::ImageChangePhotometricInterpretation()

        """
        _gdcmswig.ImageChangePhotometricInterpretation_swiginit(self, _gdcmswig.new_ImageChangePhotometricInterpretation())
    __swig_destroy__ = _gdcmswig.delete_ImageChangePhotometricInterpretation

    def SetPhotometricInterpretation(self, pi):
        r"""
        void
        gdcm::ImageChangePhotometricInterpretation::SetPhotometricInterpretation(PhotometricInterpretation
        const &pi)

        Set/Get requested PhotometricInterpretation. 
        """
        return _gdcmswig.ImageChangePhotometricInterpretation_SetPhotometricInterpretation(self, pi)

    def GetPhotometricInterpretation(self):
        r"""
        const PhotometricInterpretation&
        gdcm::ImageChangePhotometricInterpretation::GetPhotometricInterpretation()
        const 
        """
        return _gdcmswig.ImageChangePhotometricInterpretation_GetPhotometricInterpretation(self)

    def Change(self):
        r"""
        bool
        gdcm::ImageChangePhotometricInterpretation::Change()

        Change. 
        """
        return _gdcmswig.ImageChangePhotometricInterpretation_Change(self)

# Register ImageChangePhotometricInterpretation in _gdcmswig:
_gdcmswig.ImageChangePhotometricInterpretation_swigregister(ImageChangePhotometricInterpretation)
class ImageChangePlanarConfiguration(ImageToImageFilter):
    r"""


    ImageChangePlanarConfiguration class.

    Class to change the Planar configuration of an input DICOM By default
    it will change into the more usual representation: PlanarConfiguration
    = 0

    C++ includes: gdcmImageChangePlanarConfiguration.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::ImageChangePlanarConfiguration::ImageChangePlanarConfiguration()

        """
        _gdcmswig.ImageChangePlanarConfiguration_swiginit(self, _gdcmswig.new_ImageChangePlanarConfiguration())
    __swig_destroy__ = _gdcmswig.delete_ImageChangePlanarConfiguration

    def SetPlanarConfiguration(self, pc):
        r"""
        void
        gdcm::ImageChangePlanarConfiguration::SetPlanarConfiguration(unsigned
        int pc)

        Set/Get requested PlanarConfigation. 
        """
        return _gdcmswig.ImageChangePlanarConfiguration_SetPlanarConfiguration(self, pc)

    def GetPlanarConfiguration(self):
        r"""
        unsigned int
        gdcm::ImageChangePlanarConfiguration::GetPlanarConfiguration() const

        """
        return _gdcmswig.ImageChangePlanarConfiguration_GetPlanarConfiguration(self)

    def Change(self):
        r"""
        bool gdcm::ImageChangePlanarConfiguration::Change()

        Change. 
        """
        return _gdcmswig.ImageChangePlanarConfiguration_Change(self)

# Register ImageChangePlanarConfiguration in _gdcmswig:
_gdcmswig.ImageChangePlanarConfiguration_swigregister(ImageChangePlanarConfiguration)
class ImageFragmentSplitter(ImageToImageFilter):
    r"""


    ImageFragmentSplitter class.

    For single frame image, DICOM standard allow splitting the frame into
    multiple fragments

    C++ includes: gdcmImageFragmentSplitter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::ImageFragmentSplitter::ImageFragmentSplitter()"""
        _gdcmswig.ImageFragmentSplitter_swiginit(self, _gdcmswig.new_ImageFragmentSplitter())
    __swig_destroy__ = _gdcmswig.delete_ImageFragmentSplitter

    def Split(self):
        r"""
        bool
        gdcm::ImageFragmentSplitter::Split()

        Split. 
        """
        return _gdcmswig.ImageFragmentSplitter_Split(self)

    def SetFragmentSizeMax(self, fragsize):
        r"""
        void gdcm::ImageFragmentSplitter::SetFragmentSizeMax(unsigned int
        fragsize)

        FragmentSizeMax needs to be an even number. 
        """
        return _gdcmswig.ImageFragmentSplitter_SetFragmentSizeMax(self, fragsize)

    def GetFragmentSizeMax(self):
        r"""
        unsigned int gdcm::ImageFragmentSplitter::GetFragmentSizeMax() const

        """
        return _gdcmswig.ImageFragmentSplitter_GetFragmentSizeMax(self)

    def SetForce(self, f):
        r"""
        void
        gdcm::ImageFragmentSplitter::SetForce(bool f)

        When file already has all it's segment < FragmentSizeMax there is not
        need to run the filter. Unless the user explicitly say 'force'
        recomputation ! 
        """
        return _gdcmswig.ImageFragmentSplitter_SetForce(self, f)

# Register ImageFragmentSplitter in _gdcmswig:
_gdcmswig.ImageFragmentSplitter_swigregister(ImageFragmentSplitter)
class DataSetHelper(object):
    r"""


    DataSetHelper (internal class, not intended for user level)

    C++ includes: gdcmDataSetHelper.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ComputeVR(file, ds, tag):
        return _gdcmswig.DataSetHelper_ComputeVR(file, ds, tag)

    def __init__(self):
        _gdcmswig.DataSetHelper_swiginit(self, _gdcmswig.new_DataSetHelper())
    __swig_destroy__ = _gdcmswig.delete_DataSetHelper

# Register DataSetHelper in _gdcmswig:
_gdcmswig.DataSetHelper_swigregister(DataSetHelper)
class FileExplicitFilter(object):
    r"""


    FileExplicitFilter class.

    After changing a file from Implicit to Explicit representation (see
    ImageChangeTransferSyntax) one operation is to make sure the VR of
    each DICOM attribute are accurate and do match the one from PS 3.6.
    Indeed when a file is written in Implicit representation, the VR is
    not stored directly in the file.

    WARNING:  changing an implicit dataset to an explicit dataset is NOT a
    trivial task of simply changing the VR to the dict one: One has to
    make sure SQ is properly set

    One has to recompute the explicit length SQ

    One has to make sure that VR is valid for the encoding

    One has to make sure that VR 16bits can store the original value
    length

    C++ includes: gdcmFileExplicitFilter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::FileExplicitFilter::FileExplicitFilter()"""
        _gdcmswig.FileExplicitFilter_swiginit(self, _gdcmswig.new_FileExplicitFilter())
    __swig_destroy__ = _gdcmswig.delete_FileExplicitFilter

    def SetChangePrivateTags(self, b):
        r"""
        void gdcm::FileExplicitFilter::SetChangePrivateTags(bool b)

        Decide whether or not to VR'ify private tags. 
        """
        return _gdcmswig.FileExplicitFilter_SetChangePrivateTags(self, b)

    def SetUseVRUN(self, b):
        r"""
        void
        gdcm::FileExplicitFilter::SetUseVRUN(bool b)

        When VR=16bits in explicit but Implicit has a 32bits length, use
        VR=UN. 
        """
        return _gdcmswig.FileExplicitFilter_SetUseVRUN(self, b)

    def SetRecomputeItemLength(self, b):
        r"""
        void
        gdcm::FileExplicitFilter::SetRecomputeItemLength(bool b)

        By default set Sequence & Item length to Undefined to avoid
        recomputing length: 
        """
        return _gdcmswig.FileExplicitFilter_SetRecomputeItemLength(self, b)

    def SetRecomputeSequenceLength(self, b):
        r"""
        void
        gdcm::FileExplicitFilter::SetRecomputeSequenceLength(bool b) 
        """
        return _gdcmswig.FileExplicitFilter_SetRecomputeSequenceLength(self, b)

    def Change(self):
        r"""
        bool
        gdcm::FileExplicitFilter::Change()

        Set FMI Transfer Syntax.

        Change 
        """
        return _gdcmswig.FileExplicitFilter_Change(self)

    def SetFile(self, f):
        r"""
        void
        gdcm::FileExplicitFilter::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.FileExplicitFilter_SetFile(self, f)

    def GetFile(self):
        r"""
        File&
        gdcm::FileExplicitFilter::GetFile() 
        """
        return _gdcmswig.FileExplicitFilter_GetFile(self)

# Register FileExplicitFilter in _gdcmswig:
_gdcmswig.FileExplicitFilter_swigregister(FileExplicitFilter)
class DoubleArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.DoubleArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.DoubleArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.DoubleArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.DoubleArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.DoubleArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.DoubleArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.DoubleArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.DoubleArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.DoubleArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.DoubleArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.DoubleArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.DoubleArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.DoubleArrayType_empty(self)

    def size(self):
        return _gdcmswig.DoubleArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.DoubleArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.DoubleArrayType_begin(self)

    def end(self):
        return _gdcmswig.DoubleArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.DoubleArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.DoubleArrayType_rend(self)

    def clear(self):
        return _gdcmswig.DoubleArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.DoubleArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.DoubleArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.DoubleArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.DoubleArrayType_swiginit(self, _gdcmswig.new_DoubleArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.DoubleArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.DoubleArrayType_front(self)

    def back(self):
        return _gdcmswig.DoubleArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.DoubleArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.DoubleArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.DoubleArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.DoubleArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.DoubleArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_DoubleArrayType

# Register DoubleArrayType in _gdcmswig:
_gdcmswig.DoubleArrayType_swigregister(DoubleArrayType)
class UShortArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.UShortArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.UShortArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.UShortArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.UShortArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.UShortArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.UShortArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.UShortArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.UShortArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.UShortArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.UShortArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.UShortArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.UShortArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.UShortArrayType_empty(self)

    def size(self):
        return _gdcmswig.UShortArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.UShortArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.UShortArrayType_begin(self)

    def end(self):
        return _gdcmswig.UShortArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.UShortArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.UShortArrayType_rend(self)

    def clear(self):
        return _gdcmswig.UShortArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.UShortArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.UShortArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.UShortArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.UShortArrayType_swiginit(self, _gdcmswig.new_UShortArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.UShortArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.UShortArrayType_front(self)

    def back(self):
        return _gdcmswig.UShortArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.UShortArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.UShortArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.UShortArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.UShortArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.UShortArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_UShortArrayType

# Register UShortArrayType in _gdcmswig:
_gdcmswig.UShortArrayType_swigregister(UShortArrayType)
class UIntArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.UIntArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.UIntArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.UIntArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.UIntArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.UIntArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.UIntArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.UIntArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.UIntArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.UIntArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.UIntArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.UIntArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.UIntArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.UIntArrayType_empty(self)

    def size(self):
        return _gdcmswig.UIntArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.UIntArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.UIntArrayType_begin(self)

    def end(self):
        return _gdcmswig.UIntArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.UIntArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.UIntArrayType_rend(self)

    def clear(self):
        return _gdcmswig.UIntArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.UIntArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.UIntArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.UIntArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.UIntArrayType_swiginit(self, _gdcmswig.new_UIntArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.UIntArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.UIntArrayType_front(self)

    def back(self):
        return _gdcmswig.UIntArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.UIntArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.UIntArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.UIntArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.UIntArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.UIntArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_UIntArrayType

# Register UIntArrayType in _gdcmswig:
_gdcmswig.UIntArrayType_swigregister(UIntArrayType)
class RealWorldValueMappingContent(object):
    r"""
    C++
    includes: gdcmImageHelper.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    RealWorldValueIntercept = property(_gdcmswig.RealWorldValueMappingContent_RealWorldValueIntercept_get, _gdcmswig.RealWorldValueMappingContent_RealWorldValueIntercept_set)
    RealWorldValueSlope = property(_gdcmswig.RealWorldValueMappingContent_RealWorldValueSlope_get, _gdcmswig.RealWorldValueMappingContent_RealWorldValueSlope_set)
    CodeValue = property(_gdcmswig.RealWorldValueMappingContent_CodeValue_get, _gdcmswig.RealWorldValueMappingContent_CodeValue_set)
    CodeMeaning = property(_gdcmswig.RealWorldValueMappingContent_CodeMeaning_get, _gdcmswig.RealWorldValueMappingContent_CodeMeaning_set)

    def __init__(self):
        _gdcmswig.RealWorldValueMappingContent_swiginit(self, _gdcmswig.new_RealWorldValueMappingContent())
    __swig_destroy__ = _gdcmswig.delete_RealWorldValueMappingContent

# Register RealWorldValueMappingContent in _gdcmswig:
_gdcmswig.RealWorldValueMappingContent_swigregister(RealWorldValueMappingContent)
class ImageHelper(object):
    r"""


    ImageHelper (internal class, not intended for user level)

    Helper for writing World images in DICOM. DICOM has a 'template'
    approach to image where MR Image Storage are distinct object from
    Enhanced MR Image Storage. For example the Pixel Spacing in one object
    is not at the same position (ie Tag) as in the other this class is the
    central (read: fragile) place where all the dispatching is done from a
    unified view of a world image (typically VTK or ITK point of view)
    down to the low level DICOM point of view.

    WARNING:  : do not expect the API of this class to be maintained at
    any point, since as Modalities are added the API might have to be
    augmented or behavior changed to cope with new modalities.

    C++ includes: gdcmImageHelper.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def SetForceRescaleInterceptSlope(arg1):
        return _gdcmswig.ImageHelper_SetForceRescaleInterceptSlope(arg1)

    @staticmethod
    def GetForceRescaleInterceptSlope():
        return _gdcmswig.ImageHelper_GetForceRescaleInterceptSlope()

    @staticmethod
    def SetPMSRescaleInterceptSlope(arg1):
        return _gdcmswig.ImageHelper_SetPMSRescaleInterceptSlope(arg1)

    @staticmethod
    def GetPMSRescaleInterceptSlope():
        return _gdcmswig.ImageHelper_GetPMSRescaleInterceptSlope()

    @staticmethod
    def SetForcePixelSpacing(arg1):
        return _gdcmswig.ImageHelper_SetForcePixelSpacing(arg1)

    @staticmethod
    def GetForcePixelSpacing():
        return _gdcmswig.ImageHelper_GetForcePixelSpacing()

    @staticmethod
    def SetSecondaryCaptureImagePlaneModule(arg1):
        return _gdcmswig.ImageHelper_SetSecondaryCaptureImagePlaneModule(arg1)

    @staticmethod
    def GetSecondaryCaptureImagePlaneModule():
        return _gdcmswig.ImageHelper_GetSecondaryCaptureImagePlaneModule()

    @staticmethod
    def GetDimensionsValue(f):
        return _gdcmswig.ImageHelper_GetDimensionsValue(f)

    @staticmethod
    def SetDimensionsValue(f, img):
        return _gdcmswig.ImageHelper_SetDimensionsValue(f, img)

    @staticmethod
    def GetPixelFormatValue(f):
        return _gdcmswig.ImageHelper_GetPixelFormatValue(f)

    @staticmethod
    def GetRescaleInterceptSlopeValue(f):
        return _gdcmswig.ImageHelper_GetRescaleInterceptSlopeValue(f)

    @staticmethod
    def SetRescaleInterceptSlopeValue(f, img):
        return _gdcmswig.ImageHelper_SetRescaleInterceptSlopeValue(f, img)

    @staticmethod
    def GetRealWorldValueMappingContent(f, rwvmc):
        return _gdcmswig.ImageHelper_GetRealWorldValueMappingContent(f, rwvmc)

    @staticmethod
    def GetOriginValue(f):
        return _gdcmswig.ImageHelper_GetOriginValue(f)

    @staticmethod
    def SetOriginValue(ds, img):
        return _gdcmswig.ImageHelper_SetOriginValue(ds, img)

    @staticmethod
    def GetDirectionCosinesValue(f):
        return _gdcmswig.ImageHelper_GetDirectionCosinesValue(f)

    @staticmethod
    def SetDirectionCosinesValue(ds, dircos):
        return _gdcmswig.ImageHelper_SetDirectionCosinesValue(ds, dircos)

    @staticmethod
    def GetSpacingValue(f):
        return _gdcmswig.ImageHelper_GetSpacingValue(f)

    @staticmethod
    def SetSpacingValue(ds, spacing):
        return _gdcmswig.ImageHelper_SetSpacingValue(ds, spacing)

    @staticmethod
    def ComputeSpacingFromImagePositionPatient(imageposition, spacing):
        return _gdcmswig.ImageHelper_ComputeSpacingFromImagePositionPatient(imageposition, spacing)

    @staticmethod
    def GetDirectionCosinesFromDataSet(ds, dircos):
        return _gdcmswig.ImageHelper_GetDirectionCosinesFromDataSet(ds, dircos)

    @staticmethod
    def GetPhotometricInterpretationValue(f):
        return _gdcmswig.ImageHelper_GetPhotometricInterpretationValue(f)

    @staticmethod
    def GetPlanarConfigurationValue(f):
        return _gdcmswig.ImageHelper_GetPlanarConfigurationValue(f)

    @staticmethod
    def GetLUT(f):
        return _gdcmswig.ImageHelper_GetLUT(f)

    @staticmethod
    def GetPointerFromElement(tag, f):
        return _gdcmswig.ImageHelper_GetPointerFromElement(tag, f)

    @staticmethod
    def ComputeMediaStorageFromModality(*args):
        return _gdcmswig.ImageHelper_ComputeMediaStorageFromModality(*args)

    def __init__(self):
        _gdcmswig.ImageHelper_swiginit(self, _gdcmswig.new_ImageHelper())
    __swig_destroy__ = _gdcmswig.delete_ImageHelper

# Register ImageHelper in _gdcmswig:
_gdcmswig.ImageHelper_swigregister(ImageHelper)
class MD5(object):
    r"""


    Class for MD5.

    WARNING:  this class is able to pick from two implementations:

    a lightweight md5 implementation (when GDCM_BUILD_TESTING is turned
    ON)

    the one from OpenSSL (when GDCM_USE_SYSTEM_OPENSSL is turned ON)

    In all other cases it will return an error

    C++ includes: gdcmMD5.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Compute(buffer, buf_len, digest_str):
        return _gdcmswig.MD5_Compute(buffer, buf_len, digest_str)

    @staticmethod
    def ComputeFile(filename, digest_str):
        return _gdcmswig.MD5_ComputeFile(filename, digest_str)

    def __init__(self):
        _gdcmswig.MD5_swiginit(self, _gdcmswig.new_MD5())
    __swig_destroy__ = _gdcmswig.delete_MD5

# Register MD5 in _gdcmswig:
_gdcmswig.MD5_swigregister(MD5)
class DummyValueGenerator(object):
    r"""


    Class for generating dummy value.

    See:   Anonymizer

    C++ includes: gdcmDummyValueGenerator.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Generate(input):
        return _gdcmswig.DummyValueGenerator_Generate(input)

    def __init__(self):
        _gdcmswig.DummyValueGenerator_swiginit(self, _gdcmswig.new_DummyValueGenerator())
    __swig_destroy__ = _gdcmswig.delete_DummyValueGenerator

# Register DummyValueGenerator in _gdcmswig:
_gdcmswig.DummyValueGenerator_swigregister(DummyValueGenerator)
class SHA1(object):
    r"""


    Class for SHA1.

    WARNING:  this class is able to pick from one implementation:

    the one from OpenSSL (when GDCM_USE_SYSTEM_OPENSSL is turned ON)

    In all other cases it will return an error

    C++ includes: gdcmSHA1.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::SHA1::SHA1(const SHA1
        &)=delete 
        """
        _gdcmswig.SHA1_swiginit(self, _gdcmswig.new_SHA1())
    __swig_destroy__ = _gdcmswig.delete_SHA1

    @staticmethod
    def Compute(buffer, buf_len, digest_str):
        return _gdcmswig.SHA1_Compute(buffer, buf_len, digest_str)

    @staticmethod
    def ComputeFile(filename, digest_str):
        return _gdcmswig.SHA1_ComputeFile(filename, digest_str)

# Register SHA1 in _gdcmswig:
_gdcmswig.SHA1_swigregister(SHA1)
class Base64(object):
    r"""


    Class for Base64.

    C++ includes: gdcmBase64.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def GetEncodeLength(src, srclen):
        return _gdcmswig.Base64_GetEncodeLength(src, srclen)

    @staticmethod
    def Encode(dst, dlen, src, slen):
        return _gdcmswig.Base64_Encode(dst, dlen, src, slen)

    @staticmethod
    def GetDecodeLength(src, len):
        return _gdcmswig.Base64_GetDecodeLength(src, len)

    @staticmethod
    def Decode(dst, dlen, src, slen):
        return _gdcmswig.Base64_Decode(dst, dlen, src, slen)
    __swig_destroy__ = _gdcmswig.delete_Base64

# Register Base64 in _gdcmswig:
_gdcmswig.Base64_swigregister(Base64)
class CryptographicMessageSyntax(object):
    r"""
    C++ includes:
    gdcmCryptographicMessageSyntax.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_CryptographicMessageSyntax
    DES3_CIPHER = _gdcmswig.CryptographicMessageSyntax_DES3_CIPHER
    AES128_CIPHER = _gdcmswig.CryptographicMessageSyntax_AES128_CIPHER
    AES192_CIPHER = _gdcmswig.CryptographicMessageSyntax_AES192_CIPHER
    AES256_CIPHER = _gdcmswig.CryptographicMessageSyntax_AES256_CIPHER

    def ParseCertificateFile(self, filename):
        r"""
        virtual bool
        gdcm::CryptographicMessageSyntax::ParseCertificateFile(const char
        *filename)=0 
        """
        return _gdcmswig.CryptographicMessageSyntax_ParseCertificateFile(self, filename)

    def ParseKeyFile(self, filename):
        r"""
        virtual bool gdcm::CryptographicMessageSyntax::ParseKeyFile(const
        char *filename)=0 
        """
        return _gdcmswig.CryptographicMessageSyntax_ParseKeyFile(self, filename)

    def SetPassword(self, _pass, passLen):
        r"""
        virtual bool gdcm::CryptographicMessageSyntax::SetPassword(const char
        *pass, size_t passLen)=0 
        """
        return _gdcmswig.CryptographicMessageSyntax_SetPassword(self, _pass, passLen)

    def Encrypt(self, output, outlen, array, len):
        r"""
        virtual bool gdcm::CryptographicMessageSyntax::Encrypt(char *output,
        size_t &outlen, const char *array, size_t len) const =0

        create a CMS envelopedData structure 
        """
        return _gdcmswig.CryptographicMessageSyntax_Encrypt(self, output, outlen, array, len)

    def Decrypt(self, output, outlen, array, len):
        r"""
        virtual bool gdcm::CryptographicMessageSyntax::Decrypt(char *output,
        size_t &outlen, const char *array, size_t len) const =0

        decrypt content from a CMS envelopedData structure 
        """
        return _gdcmswig.CryptographicMessageSyntax_Decrypt(self, output, outlen, array, len)

    def SetCipherType(self, type):
        r"""
        virtual void
        gdcm::CryptographicMessageSyntax::SetCipherType(CipherTypes type)=0 
        """
        return _gdcmswig.CryptographicMessageSyntax_SetCipherType(self, type)

    def GetCipherType(self):
        r"""
        virtual CipherTypes
        gdcm::CryptographicMessageSyntax::GetCipherType() const =0 
        """
        return _gdcmswig.CryptographicMessageSyntax_GetCipherType(self)

# Register CryptographicMessageSyntax in _gdcmswig:
_gdcmswig.CryptographicMessageSyntax_swigregister(CryptographicMessageSyntax)
class CryptoFactory(object):
    r"""


    Class to do handle the crypto factory.

    GDCM needs to access in a platform independent way the user specified
    crypto engine. It can be: CAPI (windows only)

    OPENSSL (portable)

    OPENSSLP7 (portable) By default the factory will try: CAPI if on
    windows OPENSSL if possible OPENSSLP7 when older OpenSSL is used.

    C++ includes: gdcmCryptoFactory.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    DEFAULT = _gdcmswig.CryptoFactory_DEFAULT
    OPENSSL = _gdcmswig.CryptoFactory_OPENSSL
    CAPI = _gdcmswig.CryptoFactory_CAPI
    OPENSSLP7 = _gdcmswig.CryptoFactory_OPENSSLP7

    def CreateCMSProvider(self):
        r"""
        virtual CryptographicMessageSyntax*
        gdcm::CryptoFactory::CreateCMSProvider()=0 
        """
        return _gdcmswig.CryptoFactory_CreateCMSProvider(self)

    @staticmethod
    def GetFactoryInstance(*args):
        return _gdcmswig.CryptoFactory_GetFactoryInstance(*args)

# Register CryptoFactory in _gdcmswig:
_gdcmswig.CryptoFactory_swigregister(CryptoFactory)
class Spacing(object):
    r"""


    Class for Spacing.

    It all began with a mail to WG6:

    Subject: Imager Pixel Spacing vs Pixel Spacing Body: [Apologies for
    the duplicate post, namely to David Clunie & OFFIS team]

    I have been trying to understand CP-586 in the following two cases:

    On the one hand: DISCIMG/IMAGES/CRIMAGE taken
    fromhttp://dclunie.com/images/pixelspacingtestimages.zip

    And on the other hand:
    http://gdcm.sourceforge.net/thingies/cr_pixelspacing.dcm

    If I understand correctly the CP, one is required to use Pixel Spacing
    for measurement ('true size' print) instead of Imager Pixel Spacing,
    since the two attributes are present and Pixel Spacing is different
    from Imager Pixel Spacing.

    If this is correct, then the test data DISCIMG/IMAGES/CRIMAGE is
    incorrect. If this is incorrect (ie. I need to use Imager Pixel
    Spacing), then the display of cr_pixelspacing.dcm for measurement will
    be incorrect.

    Could someone please let me know what am I missing here? I could not
    find any information in any header that would allow me to
    differentiate those.

    Thank you for your time,

    Ref:http://lists.nema.org/scripts/lyris.pl?sub=488573&id=400720477

    See PS 3.3-2008, Table C.7-11b IMAGE PIXEL MACRO ATTRIBUTES

    Ratio of the vertical size and horizontal size of the pixels in the
    image specified by a pair of integer values where the first value is
    the vertical pixel size, and the second value is the horizontal pixel
    size. Required if the aspect ratio values do not have a ratio of 1:1
    and the physical pixel spacing is not specified by Pixel Spacing
    (0028,0030), or Imager Pixel Spacing (0018,1164) or Nominal Scanned
    Pixel Spacing (0018,2010), either for the entire Image or per-frame in
    a Functional Group Macro. See C.7.6.3.1.7.

    PS 3.3-2008 10.7.1.3 Pixel Spacing Value Order and Valid Values All
    pixel spacing related attributes shall have non-zero values, except
    when there is only a single row or column or pixel of data present, in
    which case the corresponding value may be zero.

    Ref:http://gdcm.sourceforge.net/wiki/index.php/Imager_Pixel_Spacing

    C++ includes: gdcmSpacing.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::Spacing::Spacing()"""
        _gdcmswig.Spacing_swiginit(self, _gdcmswig.new_Spacing())
    __swig_destroy__ = _gdcmswig.delete_Spacing
    DETECTOR = _gdcmswig.Spacing_DETECTOR
    MAGNIFIED = _gdcmswig.Spacing_MAGNIFIED
    CALIBRATED = _gdcmswig.Spacing_CALIBRATED
    UNKNOWN = _gdcmswig.Spacing_UNKNOWN

    @staticmethod
    def ComputePixelAspectRatioFromPixelSpacing(pixelspacing):
        return _gdcmswig.Spacing_ComputePixelAspectRatioFromPixelSpacing(pixelspacing)

# Register Spacing in _gdcmswig:
_gdcmswig.Spacing_swigregister(Spacing)
class IconImageGenerator(object):
    r"""


    IconImageGenerator.

    This filter will generate a valid Icon from the Pixel Data element (an
    instance of Pixmap). To generate a valid Icon, one is only allowed the
    following Photometric Interpretation: MONOCHROME1

    MONOCHROME2

    PALETTE_COLOR

    The Pixel Bits Allocated is restricted to 8bits, therefore 16 bits
    image needs to be rescaled. By default the filter will use the full
    scalar range of 16bits image to rescale to unsigned 8bits. This may
    not be ideal for some situation, in which case the API SetPixelMinMax
    can be used to overwrite the default min,max interval used.

    See:   ImageReader

    C++ includes: gdcmIconImageGenerator.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::IconImageGenerator::IconImageGenerator()"""
        _gdcmswig.IconImageGenerator_swiginit(self, _gdcmswig.new_IconImageGenerator())
    __swig_destroy__ = _gdcmswig.delete_IconImageGenerator

    def SetPixmap(self, p):
        r"""
        void
        gdcm::IconImageGenerator::SetPixmap(const Pixmap &p)

        Set/Get File. 
        """
        return _gdcmswig.IconImageGenerator_SetPixmap(self, p)

    def GetPixmap(self, *args):
        r"""
        const
        Pixmap& gdcm::IconImageGenerator::GetPixmap() const 
        """
        return _gdcmswig.IconImageGenerator_GetPixmap(self, *args)

    def SetOutputDimensions(self, dims):
        r"""
        void gdcm::IconImageGenerator::SetOutputDimensions(const unsigned int
        dims[2])

        Set Target dimension of output Icon. 
        """
        return _gdcmswig.IconImageGenerator_SetOutputDimensions(self, dims)

    def SetPixelMinMax(self, min, max):
        r"""
        void
        gdcm::IconImageGenerator::SetPixelMinMax(double min, double max)

        Override default min/max to compute best rescale for 16bits -> 8bits
        downscale. Typically those value can be read from the
        SmallestImagePixelValue LargestImagePixelValue DICOM attribute. 
        """
        return _gdcmswig.IconImageGenerator_SetPixelMinMax(self, min, max)

    def AutoPixelMinMax(self, b):
        r"""
        void gdcm::IconImageGenerator::AutoPixelMinMax(bool b)

        Instead of explicitly specifying the min/max value for the rescale
        operation, let the internal mechanism compute the min/max of icon and
        rescale to best appropriate. 
        """
        return _gdcmswig.IconImageGenerator_AutoPixelMinMax(self, b)

    def ConvertRGBToPaletteColor(self, b):
        r"""
        void
        gdcm::IconImageGenerator::ConvertRGBToPaletteColor(bool b)

        Converting from RGB to PALETTE_COLOR can be a slow operation. However
        DICOM standard requires that color icon be described as palette. Set
        this boolean to false only if you understand the consequences. default
        value is true, false generates invalid Icon Image Sequence 
        """
        return _gdcmswig.IconImageGenerator_ConvertRGBToPaletteColor(self, b)

    def SetOutsideValuePixel(self, v):
        r"""
        void gdcm::IconImageGenerator::SetOutsideValuePixel(double v)

        Set a pixel value that should be discarded. This happen typically for
        CT image, where a pixel has been used to pad outside the image (see
        Pixel Padding Value). Requires AutoPixelMinMax(true) 
        """
        return _gdcmswig.IconImageGenerator_SetOutsideValuePixel(self, v)

    def Generate(self):
        r"""
        bool
        gdcm::IconImageGenerator::Generate()

        Generate Icon. 
        """
        return _gdcmswig.IconImageGenerator_Generate(self)

    def GetIconImage(self):
        r"""
        const
        IconImage& gdcm::IconImageGenerator::GetIconImage() const

        Retrieve generated Icon. 
        """
        return _gdcmswig.IconImageGenerator_GetIconImage(self)

# Register IconImageGenerator in _gdcmswig:
_gdcmswig.IconImageGenerator_swigregister(IconImageGenerator)
class IconImageFilter(object):
    r"""


    IconImageFilter.

    This filter will extract icons from a File This filter will loop over
    all known sequence (public and private) that may contains an IconImage
    and retrieve them. The filter will fails with a value of false if no
    icon can be found Since it handle both public and private icon type,
    one should not assume the icon is in uncompress form, some private
    vendor store private icon in JPEG8/JPEG12

    Implementation details: This filter supports the following Icons:
    (0088,0200) Icon Image Sequence

    (0009,10,GEIIS) GE IIS Thumbnail Sequence

    (6003,10,GEMS_Ultrasound_ImageGroup_001) GEMS Image Thumbnail Sequence

    (0055,30,VEPRO VIF 3.0 DATA) Icon Data

    (0055,30,VEPRO VIM 5.0 DATA) ICONDATA2

    WARNING:  the icon stored in those private attribute do not conform to
    definition of Icon Image Sequence (do not simply copy/paste). For
    example some private icon can be expressed as 12bits pixel, while the
    DICOM standard only allow 8bits icons.

    See:   ImageReader

    C++ includes: gdcmIconImageFilter.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::IconImageFilter::IconImageFilter()"""
        _gdcmswig.IconImageFilter_swiginit(self, _gdcmswig.new_IconImageFilter())
    __swig_destroy__ = _gdcmswig.delete_IconImageFilter

    def SetFile(self, f):
        r"""
        void
        gdcm::IconImageFilter::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.IconImageFilter_SetFile(self, f)

    def GetFile(self, *args):
        r"""
        const File&
        gdcm::IconImageFilter::GetFile() const 
        """
        return _gdcmswig.IconImageFilter_GetFile(self, *args)

    def Extract(self):
        r"""
        bool
        gdcm::IconImageFilter::Extract()

        Extract all Icon found in File. 
        """
        return _gdcmswig.IconImageFilter_Extract(self)

    def GetNumberOfIconImages(self):
        r"""
        unsigned int gdcm::IconImageFilter::GetNumberOfIconImages() const

        Retrieve extract IconImage (need to call Extract first) 
        """
        return _gdcmswig.IconImageFilter_GetNumberOfIconImages(self)

    def GetIconImage(self, i):
        r"""
        IconImage& gdcm::IconImageFilter::GetIconImage(unsigned int i) const

        """
        return _gdcmswig.IconImageFilter_GetIconImage(self, i)

# Register IconImageFilter in _gdcmswig:
_gdcmswig.IconImageFilter_swigregister(IconImageFilter)
class SimpleSubjectWatcher(object):
    r"""


    SimpleSubjectWatcher.

    This is a typical Subject Watcher class. It will observe all events.

    C++ includes: gdcmSimpleSubjectWatcher.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::SimpleSubjectWatcher::SimpleSubjectWatcher(Subject *s, const
        char *comment="") 
        """
        if self.__class__ == SimpleSubjectWatcher:
            _self = None
        else:
            _self = self
        _gdcmswig.SimpleSubjectWatcher_swiginit(self, _gdcmswig.new_SimpleSubjectWatcher(_self, *args))
    __swig_destroy__ = _gdcmswig.delete_SimpleSubjectWatcher

    def StartFilter(self):
        return _gdcmswig.SimpleSubjectWatcher_StartFilter(self)

    def EndFilter(self):
        return _gdcmswig.SimpleSubjectWatcher_EndFilter(self)

    def ShowProgress(self, caller, evt):
        return _gdcmswig.SimpleSubjectWatcher_ShowProgress(self, caller, evt)

    def ShowFileName(self, caller, evt):
        return _gdcmswig.SimpleSubjectWatcher_ShowFileName(self, caller, evt)

    def ShowIteration(self):
        return _gdcmswig.SimpleSubjectWatcher_ShowIteration(self)

    def ShowAnonymization(self, caller, evt):
        return _gdcmswig.SimpleSubjectWatcher_ShowAnonymization(self, caller, evt)

    def ShowDataSet(self, caller, evt):
        return _gdcmswig.SimpleSubjectWatcher_ShowDataSet(self, caller, evt)

    def ShowData(self, caller, evt):
        return _gdcmswig.SimpleSubjectWatcher_ShowData(self, caller, evt)

    def ShowAbort(self):
        return _gdcmswig.SimpleSubjectWatcher_ShowAbort(self)
    def __disown__(self):
        self.this.disown()
        _gdcmswig.disown_SimpleSubjectWatcher(self)
        return weakref.proxy(self)

# Register SimpleSubjectWatcher in _gdcmswig:
_gdcmswig.SimpleSubjectWatcher_swigregister(SimpleSubjectWatcher)
class DICOMDIRGenerator(object):
    r"""


    DICOMDIRGenerator class.

    This is a STD-GEN-CD DICOMDIR generator. ref: PS 3.11-2008 Annex D
    (Normative) - General Purpose CD-R and DVD Interchange Profiles

    PS 3.11 - 2008 / D.3.2 Physical Medium And Medium Format The STD-GEN-
    CD and STD-GEN-SEC-CD application profiles require the 120 mm CD-R
    physical medium with the ISO/IEC 9660 Media Format, as defined in
    PS3.12. See also PS 3.12 - 2008 / Annex F 120mm CD-R Medium
    (Normative) and PS 3.10 - 2008 / 8 DICOM File Service / 8.1 FILE-SET

    WARNING:  : PS 3.11 - 2008 / D.3.1 SOP Classes and Transfer Syntaxes
    Composite Image & Stand-alone Storage are required to be stored as
    Explicit VR Little Endian Uncompressed (1.2.840.10008.1.2.1). When a
    DICOM file is found using another Transfer Syntax the generator will
    simply stops.

    WARNING:

    Input files should be Explicit VR Little Endian

    filenames should be valid VR::CS value (16 bytes, upper case ...)

    Bug : There is a current limitation of not handling Referenced SOP
    Class UID / Referenced SOP Instance UID simply because the Scanner
    does not allow us See PS 3.11 / Table D.3-2 STD-GEN Additional
    DICOMDIR Keys

    C++ includes: gdcmDICOMDIRGenerator.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::DICOMDIRGenerator::DICOMDIRGenerator()"""
        _gdcmswig.DICOMDIRGenerator_swiginit(self, _gdcmswig.new_DICOMDIRGenerator())
    __swig_destroy__ = _gdcmswig.delete_DICOMDIRGenerator

    def SetFilenames(self, fns):
        r"""
        void
        gdcm::DICOMDIRGenerator::SetFilenames(FilenamesType const &fns)

        Set the list of filenames from which the DICOMDIR should be generated
        from. 
        """
        return _gdcmswig.DICOMDIRGenerator_SetFilenames(self, fns)

    def SetRootDirectory(self, root):
        r"""
        void gdcm::DICOMDIRGenerator::SetRootDirectory(FilenameType const
        &root)

        Set the root directory from which the filenames should be considered.

        """
        return _gdcmswig.DICOMDIRGenerator_SetRootDirectory(self, root)

    def SetDescriptor(self, d):
        r"""
        void
        gdcm::DICOMDIRGenerator::SetDescriptor(const char *d)

        Set the File Set ID. WARNING:  this need to be a valid VR::CS value 
        """
        return _gdcmswig.DICOMDIRGenerator_SetDescriptor(self, d)

    def Generate(self):
        r"""
        bool
        gdcm::DICOMDIRGenerator::Generate()

        Main function to generate the DICOMDIR. 
        """
        return _gdcmswig.DICOMDIRGenerator_Generate(self)

    def SetFile(self, f):
        r"""
        void
        gdcm::DICOMDIRGenerator::SetFile(const File &f)

        Set/Get file. The DICOMDIR file will be valid once a call to Generate
        has been done. 
        """
        return _gdcmswig.DICOMDIRGenerator_SetFile(self, f)

    def GetFile(self):
        r"""
        File&
        gdcm::DICOMDIRGenerator::GetFile() 
        """
        return _gdcmswig.DICOMDIRGenerator_GetFile(self)

# Register DICOMDIRGenerator in _gdcmswig:
_gdcmswig.DICOMDIRGenerator_swigregister(DICOMDIRGenerator)
class FileDerivation(object):
    r"""


    FileDerivation class.

    See PS 3.16 - 2008 For the list of Code Value that can be used for in
    Derivation Code Sequence

    URL:http://medical.nema.org/medical/dicom/2008/08_16pu.pdf

    DICOM Part 16 has two Context Groups CID 7202 and CID 7203 which
    contain a set of codes defining reason for a source image reference
    (ie. reason code for referenced image sequence) and a coded
    description of the deriation applied to the new image data from the
    original. Both these context groups are extensible.

    File Derivation is compulsory when creating a lossy derived image.

    C++ includes: gdcmFileDerivation.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::FileDerivation::FileDerivation()"""
        _gdcmswig.FileDerivation_swiginit(self, _gdcmswig.new_FileDerivation())
    __swig_destroy__ = _gdcmswig.delete_FileDerivation

    def AddReference(self, referencedsopclassuid, referencedsopinstanceuid):
        r"""
        bool
        gdcm::FileDerivation::AddReference(const char *referencedsopclassuid,
        const char *referencedsopinstanceuid)

        Create the proper reference. Need to pass the original SOP Class UID
        and the original SOP Instance UID, so that those value can be used as
        Reference. WARNING:  referencedsopclassuid and
        referencedsopinstanceuid needs to be \\0 padded. This is not
        compatible with how ByteValue->GetPointer works. 
        """
        return _gdcmswig.FileDerivation_AddReference(self, referencedsopclassuid, referencedsopinstanceuid)

    def SetPurposeOfReferenceCodeSequenceCodeValue(self, codevalue):
        r"""
        void
        gdcm::FileDerivation::SetPurposeOfReferenceCodeSequenceCodeValue(unsigned
        int codevalue)

        Specify the Purpose Of Reference Code Value. Eg. 121320. 
        """
        return _gdcmswig.FileDerivation_SetPurposeOfReferenceCodeSequenceCodeValue(self, codevalue)

    def SetDerivationCodeSequenceCodeValue(self, codevalue):
        r"""
        void
        gdcm::FileDerivation::SetDerivationCodeSequenceCodeValue(unsigned int
        codevalue)

        Specify the Derivation Code Sequence Code Value. Eg 113040. 
        """
        return _gdcmswig.FileDerivation_SetDerivationCodeSequenceCodeValue(self, codevalue)

    def SetDerivationDescription(self, dd):
        r"""
        void gdcm::FileDerivation::SetDerivationDescription(const char *dd)

        Specify the Derivation Description. Eg "lossy conversion". 
        """
        return _gdcmswig.FileDerivation_SetDerivationDescription(self, dd)

    def SetAppendDerivationHistory(self, b):
        r"""
        void
        gdcm::FileDerivation::SetAppendDerivationHistory(bool b)

        Specify if Derivation history should be appended (default false) When
        false, this is an error if input already has a derivation history When
        true, both Purpose of Reference Code Value and Derivation Code
        Sequence Code Value can have their history appended. 
        """
        return _gdcmswig.FileDerivation_SetAppendDerivationHistory(self, b)

    def Derive(self):
        r"""
        bool
        gdcm::FileDerivation::Derive()

        Change. 
        """
        return _gdcmswig.FileDerivation_Derive(self)

    def SetFile(self, f):
        r"""
        void
        gdcm::FileDerivation::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.FileDerivation_SetFile(self, f)

    def GetFile(self, *args):
        r"""
        const File&
        gdcm::FileDerivation::GetFile() const 
        """
        return _gdcmswig.FileDerivation_GetFile(self, *args)

# Register FileDerivation in _gdcmswig:
_gdcmswig.FileDerivation_swigregister(FileDerivation)
class DataSetArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.DataSetArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.DataSetArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.DataSetArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.DataSetArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.DataSetArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.DataSetArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.DataSetArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.DataSetArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.DataSetArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.DataSetArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.DataSetArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.DataSetArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.DataSetArrayType_empty(self)

    def size(self):
        return _gdcmswig.DataSetArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.DataSetArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.DataSetArrayType_begin(self)

    def end(self):
        return _gdcmswig.DataSetArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.DataSetArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.DataSetArrayType_rend(self)

    def clear(self):
        return _gdcmswig.DataSetArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.DataSetArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.DataSetArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.DataSetArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.DataSetArrayType_swiginit(self, _gdcmswig.new_DataSetArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.DataSetArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.DataSetArrayType_front(self)

    def back(self):
        return _gdcmswig.DataSetArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.DataSetArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.DataSetArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.DataSetArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.DataSetArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.DataSetArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_DataSetArrayType

# Register DataSetArrayType in _gdcmswig:
_gdcmswig.DataSetArrayType_swigregister(DataSetArrayType)
class FileArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.FileArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.FileArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.FileArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.FileArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.FileArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.FileArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.FileArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.FileArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.FileArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.FileArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.FileArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.FileArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.FileArrayType_empty(self)

    def size(self):
        return _gdcmswig.FileArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.FileArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.FileArrayType_begin(self)

    def end(self):
        return _gdcmswig.FileArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.FileArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.FileArrayType_rend(self)

    def clear(self):
        return _gdcmswig.FileArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.FileArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.FileArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.FileArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.FileArrayType_swiginit(self, _gdcmswig.new_FileArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.FileArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.FileArrayType_front(self)

    def back(self):
        return _gdcmswig.FileArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.FileArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.FileArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.FileArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.FileArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.FileArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_FileArrayType

# Register FileArrayType in _gdcmswig:
_gdcmswig.FileArrayType_swigregister(FileArrayType)
class PresentationContextArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.PresentationContextArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.PresentationContextArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.PresentationContextArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.PresentationContextArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.PresentationContextArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.PresentationContextArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.PresentationContextArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.PresentationContextArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.PresentationContextArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.PresentationContextArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.PresentationContextArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.PresentationContextArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.PresentationContextArrayType_empty(self)

    def size(self):
        return _gdcmswig.PresentationContextArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.PresentationContextArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.PresentationContextArrayType_begin(self)

    def end(self):
        return _gdcmswig.PresentationContextArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.PresentationContextArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.PresentationContextArrayType_rend(self)

    def clear(self):
        return _gdcmswig.PresentationContextArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.PresentationContextArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.PresentationContextArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.PresentationContextArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.PresentationContextArrayType_swiginit(self, _gdcmswig.new_PresentationContextArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.PresentationContextArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.PresentationContextArrayType_front(self)

    def back(self):
        return _gdcmswig.PresentationContextArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.PresentationContextArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.PresentationContextArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.PresentationContextArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.PresentationContextArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.PresentationContextArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_PresentationContextArrayType

# Register PresentationContextArrayType in _gdcmswig:
_gdcmswig.PresentationContextArrayType_swigregister(PresentationContextArrayType)
class KeyValuePairType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _gdcmswig.KeyValuePairType_swiginit(self, _gdcmswig.new_KeyValuePairType(*args))
    first = property(_gdcmswig.KeyValuePairType_first_get, _gdcmswig.KeyValuePairType_first_set)
    second = property(_gdcmswig.KeyValuePairType_second_get, _gdcmswig.KeyValuePairType_second_set)
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _gdcmswig.delete_KeyValuePairType

# Register KeyValuePairType in _gdcmswig:
_gdcmswig.KeyValuePairType_swigregister(KeyValuePairType)
class KeyValuePairArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.KeyValuePairArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.KeyValuePairArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.KeyValuePairArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.KeyValuePairArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.KeyValuePairArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.KeyValuePairArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.KeyValuePairArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.KeyValuePairArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.KeyValuePairArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.KeyValuePairArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.KeyValuePairArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.KeyValuePairArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.KeyValuePairArrayType_empty(self)

    def size(self):
        return _gdcmswig.KeyValuePairArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.KeyValuePairArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.KeyValuePairArrayType_begin(self)

    def end(self):
        return _gdcmswig.KeyValuePairArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.KeyValuePairArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.KeyValuePairArrayType_rend(self)

    def clear(self):
        return _gdcmswig.KeyValuePairArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.KeyValuePairArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.KeyValuePairArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.KeyValuePairArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.KeyValuePairArrayType_swiginit(self, _gdcmswig.new_KeyValuePairArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.KeyValuePairArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.KeyValuePairArrayType_front(self)

    def back(self):
        return _gdcmswig.KeyValuePairArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.KeyValuePairArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.KeyValuePairArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.KeyValuePairArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.KeyValuePairArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.KeyValuePairArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_KeyValuePairArrayType

# Register KeyValuePairArrayType in _gdcmswig:
_gdcmswig.KeyValuePairArrayType_swigregister(KeyValuePairArrayType)
class TagArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.TagArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.TagArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.TagArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.TagArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.TagArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.TagArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.TagArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.TagArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.TagArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.TagArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.TagArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.TagArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.TagArrayType_empty(self)

    def size(self):
        return _gdcmswig.TagArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.TagArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.TagArrayType_begin(self)

    def end(self):
        return _gdcmswig.TagArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.TagArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.TagArrayType_rend(self)

    def clear(self):
        return _gdcmswig.TagArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.TagArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.TagArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.TagArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.TagArrayType_swiginit(self, _gdcmswig.new_TagArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.TagArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.TagArrayType_front(self)

    def back(self):
        return _gdcmswig.TagArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.TagArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.TagArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.TagArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.TagArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.TagArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_TagArrayType

# Register TagArrayType in _gdcmswig:
_gdcmswig.TagArrayType_swigregister(TagArrayType)
ePatientRootType = _gdcmswig.ePatientRootType
eStudyRootType = _gdcmswig.eStudyRootType
class QueryBase(object):
    r"""


    QueryBase.

    contains: the base class for constructing a query dataset for a C-FIND
    and a C-MOVE

    There are four levels of C-FIND and C-MOVE query:  Patient

    Study

    Series

    Image  Each one has its own required and optional tags. This class
    provides an interface for getting those tags. This is an interface
    class.

    See 3.4 C 6.1 and 3.4 C 6.2 for the patient and study root query
    types. These sections define the tags allowed by a particular query.
    The caller must pass in which root type they want, patient or study. A
    third root type, Modality Worklist Query, isn't yet supported.

    This class (or rather it's derived classes) will be held in the
    RootQuery types. These query types actually make the dataset, and will
    use this dataset to list the required, unique, and optional tags for
    each type of query. This design is somewhat overly complicated, but is
    kept so that if we ever wanted to try to guess the query type from the
    given tags, we could do so.

    C++ includes: gdcmQueryBase.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_QueryBase

    def GetRequiredTags(self, inRootType):
        r"""
        virtual
        std::vector<Tag> gdcm::QueryBase::GetRequiredTags(const ERootType
        &inRootType) const =0 
        """
        return _gdcmswig.QueryBase_GetRequiredTags(self, inRootType)

    def GetUniqueTags(self, inRootType):
        r"""
        virtual
        std::vector<Tag> gdcm::QueryBase::GetUniqueTags(const ERootType
        &inRootType) const =0 
        """
        return _gdcmswig.QueryBase_GetUniqueTags(self, inRootType)

    def GetOptionalTags(self, inRootType):
        r"""
        virtual
        std::vector<Tag> gdcm::QueryBase::GetOptionalTags(const ERootType
        &inRootType) const =0 
        """
        return _gdcmswig.QueryBase_GetOptionalTags(self, inRootType)

    def GetHierachicalSearchTags(self, inRootType):
        r"""
        virtual std::vector<Tag>
        gdcm::QueryBase::GetHierachicalSearchTags(const ERootType &inRootType)
        const =0

        Return all Unique Key for a particular Query Root type (from the same
        level and above). 
        """
        return _gdcmswig.QueryBase_GetHierachicalSearchTags(self, inRootType)

    def GetAllTags(self, inRootType):
        r"""
        std::vector<Tag>
        gdcm::QueryBase::GetAllTags(const ERootType &inRootType) const

        In order to validate a query dataset, just check for the presence of a
        tag, not it's requirement level in the spec 
        """
        return _gdcmswig.QueryBase_GetAllTags(self, inRootType)

    def GetAllRequiredTags(self, inRootType):
        r"""
        std::vector<Tag> gdcm::QueryBase::GetAllRequiredTags(const ERootType
        &inRootType) const

        In order to validate a query dataset we need to check that there
        exists at least one required (or unique) key 
        """
        return _gdcmswig.QueryBase_GetAllRequiredTags(self, inRootType)

    def GetName(self):
        r"""
        virtual const char*
        gdcm::QueryBase::GetName() const =0 
        """
        return _gdcmswig.QueryBase_GetName(self)

    def GetQueryLevel(self):
        r"""
        virtual
        DataElement gdcm::QueryBase::GetQueryLevel() const =0 
        """
        return _gdcmswig.QueryBase_GetQueryLevel(self)

# Register QueryBase in _gdcmswig:
_gdcmswig.QueryBase_swigregister(QueryBase)
ePatient = _gdcmswig.ePatient
eStudy = _gdcmswig.eStudy
eSeries = _gdcmswig.eSeries
eImage = _gdcmswig.eImage
eFind = _gdcmswig.eFind
eMove = _gdcmswig.eMove
eWLMFind = _gdcmswig.eWLMFind
class BaseRootQuery(object):
    r"""


    BaseRootQuery.

    contains: a baseclass which will produce a dataset for c-find and
    c-move with patient/study root

    This class contains the functionality used in patient c-find and
    c-move queries. PatientRootQuery and StudyRootQuery derive from this
    class.

    Namely: 1) list all tags associated with a particular query type 2)
    produce a query dataset via tag association

    Eventually, it can be used to validate a particular dataset type.

    The dataset held by this object (or, really, one of its derivates)
    should be passed to a c-find or c-move query.

    C++ includes: gdcmBaseRootQuery.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_BaseRootQuery

    def GetTagListByLevel(self, inQueryLevel):
        r"""
        virtual std::vector<Tag> gdcm::BaseRootQuery::GetTagListByLevel(const
        EQueryLevel &inQueryLevel)=0

        this function will return all tags at a given query level, so that
        they maybe selected for searching. The boolean forFind is true if the
        query is a find query, or false for a move query. 
        """
        return _gdcmswig.BaseRootQuery_GetTagListByLevel(self, inQueryLevel)

    def InitializeDataSet(self, inQueryLevel):
        r"""
        virtual void gdcm::BaseRootQuery::InitializeDataSet(const EQueryLevel
        &inQueryLevel)=0

        this function sets tag 8,52 to the appropriate value based on query
        level also fills in the right unique tags, as per the standard's
        requirements should allow for connection with dcmtk 
        """
        return _gdcmswig.BaseRootQuery_InitializeDataSet(self, inQueryLevel)

    def ValidateQuery(self, inStrict=True):
        r"""
        bool
        gdcm::BaseRootQuery::ValidateQuery(bool inStrict=true) const
        override=0

        have to be able to ensure that 0x8,0x52 is set (which will be true if
        InitializeDataSet is called...) that the level is appropriate (ie, not
        setting PATIENT for a study query that the tags in the query match the
        right level (either required, unique, optional) by default, this
        function checks to see if the query is for finding, which is more
        permissive than for moving. For moving, only the unique tags are
        allowed. 10 Jan 2011: adding in the 'strict' mode. according to the
        standard (at least, how I've read it), only tags for a particular
        level should be allowed in a particular query (ie, just series level
        tags in a series level query). However, it seems that dcm4chee doesn't
        share that interpretation. So, if 'inStrict' is false, then tags from
        the current level and all higher levels are now considered valid. So,
        if you're doing a non-strict series-level query, tags from the patient
        and study level can be passed along as well. 
        """
        return _gdcmswig.BaseRootQuery_ValidateQuery(self, inStrict)

    @staticmethod
    def GetQueryLevelString(ql):
        return _gdcmswig.BaseRootQuery_GetQueryLevelString(ql)

    @staticmethod
    def GetQueryLevelFromString(str):
        return _gdcmswig.BaseRootQuery_GetQueryLevelFromString(str)

    @staticmethod
    def Construct(inRootType, qlevel):
        return _gdcmswig.BaseRootQuery_Construct(inRootType, qlevel)

    def GetQueryLevelFromQueryRoot(self, roottype):
        r"""
        EQueryLevel
        gdcm::BaseRootQuery::GetQueryLevelFromQueryRoot(ERootType roottype) 
        """
        return _gdcmswig.BaseRootQuery_GetQueryLevelFromQueryRoot(self, roottype)

# Register BaseRootQuery in _gdcmswig:
_gdcmswig.BaseRootQuery_swigregister(BaseRootQuery)
eLatin1 = _gdcmswig.eLatin1
eLatin2 = _gdcmswig.eLatin2
eLatin3 = _gdcmswig.eLatin3
eLatin4 = _gdcmswig.eLatin4
eCyrillic = _gdcmswig.eCyrillic
eArabic = _gdcmswig.eArabic
eGreek = _gdcmswig.eGreek
eHebrew = _gdcmswig.eHebrew
eLatin5 = _gdcmswig.eLatin5
eJapanese = _gdcmswig.eJapanese
eThai = _gdcmswig.eThai
eJapaneseKanjiMultibyte = _gdcmswig.eJapaneseKanjiMultibyte
eJapaneseSupplementaryKanjiMultibyte = _gdcmswig.eJapaneseSupplementaryKanjiMultibyte
eKoreanHangulHanjaMultibyte = _gdcmswig.eKoreanHangulHanjaMultibyte
eUTF8 = _gdcmswig.eUTF8
eGB18030 = _gdcmswig.eGB18030
class QueryFactory(object):
    r"""


    QueryFactory.h.

    contains: a class to produce a query based off of user-entered
    information

    Essentially, this class is used to construct a query based off of user
    input (typically from the command line; if in code directly, the query
    itself could just be instantiated)

    In theory, could also be used as the interface to validate incoming
    datasets as belonging to a particular query style

    C++ includes: gdcmQueryFactory.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ProduceQuery(*args):
        return _gdcmswig.QueryFactory_ProduceQuery(*args)

    @staticmethod
    def ProduceCharacterSetDataElement(inCharSetType):
        return _gdcmswig.QueryFactory_ProduceCharacterSetDataElement(inCharSetType)

    @staticmethod
    def GetCharacterFromCurrentLocale():
        return _gdcmswig.QueryFactory_GetCharacterFromCurrentLocale()

    @staticmethod
    def ListCharSets(os):
        return _gdcmswig.QueryFactory_ListCharSets(os)

    def __init__(self):
        _gdcmswig.QueryFactory_swiginit(self, _gdcmswig.new_QueryFactory())
    __swig_destroy__ = _gdcmswig.delete_QueryFactory

# Register QueryFactory in _gdcmswig:
_gdcmswig.QueryFactory_swigregister(QueryFactory)
class CharSetArrayType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _gdcmswig.CharSetArrayType_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _gdcmswig.CharSetArrayType___nonzero__(self)

    def __bool__(self):
        return _gdcmswig.CharSetArrayType___bool__(self)

    def __len__(self):
        return _gdcmswig.CharSetArrayType___len__(self)

    def __getslice__(self, i, j):
        return _gdcmswig.CharSetArrayType___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _gdcmswig.CharSetArrayType___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _gdcmswig.CharSetArrayType___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _gdcmswig.CharSetArrayType___delitem__(self, *args)

    def __getitem__(self, *args):
        return _gdcmswig.CharSetArrayType___getitem__(self, *args)

    def __setitem__(self, *args):
        return _gdcmswig.CharSetArrayType___setitem__(self, *args)

    def pop(self):
        return _gdcmswig.CharSetArrayType_pop(self)

    def append(self, x):
        return _gdcmswig.CharSetArrayType_append(self, x)

    def empty(self):
        return _gdcmswig.CharSetArrayType_empty(self)

    def size(self):
        return _gdcmswig.CharSetArrayType_size(self)

    def swap(self, v):
        return _gdcmswig.CharSetArrayType_swap(self, v)

    def begin(self):
        return _gdcmswig.CharSetArrayType_begin(self)

    def end(self):
        return _gdcmswig.CharSetArrayType_end(self)

    def rbegin(self):
        return _gdcmswig.CharSetArrayType_rbegin(self)

    def rend(self):
        return _gdcmswig.CharSetArrayType_rend(self)

    def clear(self):
        return _gdcmswig.CharSetArrayType_clear(self)

    def get_allocator(self):
        return _gdcmswig.CharSetArrayType_get_allocator(self)

    def pop_back(self):
        return _gdcmswig.CharSetArrayType_pop_back(self)

    def erase(self, *args):
        return _gdcmswig.CharSetArrayType_erase(self, *args)

    def __init__(self, *args):
        _gdcmswig.CharSetArrayType_swiginit(self, _gdcmswig.new_CharSetArrayType(*args))

    def push_back(self, x):
        return _gdcmswig.CharSetArrayType_push_back(self, x)

    def front(self):
        return _gdcmswig.CharSetArrayType_front(self)

    def back(self):
        return _gdcmswig.CharSetArrayType_back(self)

    def assign(self, n, x):
        return _gdcmswig.CharSetArrayType_assign(self, n, x)

    def resize(self, *args):
        return _gdcmswig.CharSetArrayType_resize(self, *args)

    def insert(self, *args):
        return _gdcmswig.CharSetArrayType_insert(self, *args)

    def reserve(self, n):
        return _gdcmswig.CharSetArrayType_reserve(self, n)

    def capacity(self):
        return _gdcmswig.CharSetArrayType_capacity(self)
    __swig_destroy__ = _gdcmswig.delete_CharSetArrayType

# Register CharSetArrayType in _gdcmswig:
_gdcmswig.CharSetArrayType_swigregister(CharSetArrayType)
class CompositeNetworkFunctions(object):
    r"""


    Composite Network Functions.

    These functions provide a generic API to the DICOM functions
    implemented in GDCM. Advanced users can use this code as a template
    for building their own versions of these functions (for instance, to
    provide progress bars or some other way of handling returned query
    information), but for most users, these functions should be sufficient
    to interface with a PACS to a local machine. Note that these functions
    are not contained within a static class or some other class-style
    interface, because multiple connections can be instantiated in the
    same program. The DICOM standard is much more function oriented rather
    than class oriented in this instance, so the design of this API
    reflects that functional approach. These functions implements the
    following SCU operations: C-ECHO SCU

    C-FIND SCU

    C-STORE SCU

    C-MOVE SCU (+internal C-STORE SCP)

    C++ includes: gdcmCompositeNetworkFunctions.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def CEcho(remote, portno, aetitle=None, call=None):
        return _gdcmswig.CompositeNetworkFunctions_CEcho(remote, portno, aetitle, call)

    @staticmethod
    def ConstructQuery(*args):
        return _gdcmswig.CompositeNetworkFunctions_ConstructQuery(*args)

    @staticmethod
    def CMove(remote, portno, query, portscp, aetitle=None, call=None, outputdir=None):
        return _gdcmswig.CompositeNetworkFunctions_CMove(remote, portno, query, portscp, aetitle, call, outputdir)

    @staticmethod
    def CFind(remote, portno, query, retDataSets, aetitle=None, call=None):
        return _gdcmswig.CompositeNetworkFunctions_CFind(remote, portno, query, retDataSets, aetitle, call)

    @staticmethod
    def CStore(remote, portno, filenames, aetitle=None, call=None):
        return _gdcmswig.CompositeNetworkFunctions_CStore(remote, portno, filenames, aetitle, call)

    def __init__(self):
        _gdcmswig.CompositeNetworkFunctions_swiginit(self, _gdcmswig.new_CompositeNetworkFunctions())
    __swig_destroy__ = _gdcmswig.delete_CompositeNetworkFunctions

# Register CompositeNetworkFunctions in _gdcmswig:
_gdcmswig.CompositeNetworkFunctions_swigregister(CompositeNetworkFunctions)
class PresentationContext(object):
    r"""


    PresentationContext.

    See:  PresentationContextAC PresentationContextRQ

    C++ includes: gdcmPresentationContext.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        gdcm::PresentationContext::PresentationContext(UIDs::TSName asname,
        UIDs::TSName
        tsname=UIDs::ImplicitVRLittleEndianDefaultTransferSyntaxforDICOM)

        Initialize Presentation Context with AbstractSyntax set to asname and
        with a single TransferSyntax set to tsname (default to Implicit VR
        LittleEndian when not specified ). 
        """
        _gdcmswig.PresentationContext_swiginit(self, _gdcmswig.new_PresentationContext(*args))

    def SetAbstractSyntax(self, absyn):
        r"""
        void gdcm::PresentationContext::SetAbstractSyntax(const char *absyn)

        """
        return _gdcmswig.PresentationContext_SetAbstractSyntax(self, absyn)

    def GetAbstractSyntax(self):
        r"""const char* gdcm::PresentationContext::GetAbstractSyntax() const"""
        return _gdcmswig.PresentationContext_GetAbstractSyntax(self)

    def AddTransferSyntax(self, tsstr):
        r"""
        void gdcm::PresentationContext::AddTransferSyntax(const char *tsstr)

        """
        return _gdcmswig.PresentationContext_AddTransferSyntax(self, tsstr)

    def GetTransferSyntax(self, i):
        r"""
        const char* gdcm::PresentationContext::GetTransferSyntax(SizeType i)
        const 
        """
        return _gdcmswig.PresentationContext_GetTransferSyntax(self, i)

    def GetNumberOfTransferSyntaxes(self):
        r"""
        SizeType
        gdcm::PresentationContext::GetNumberOfTransferSyntaxes() const 
        """
        return _gdcmswig.PresentationContext_GetNumberOfTransferSyntaxes(self)

    def SetPresentationContextID(self, id):
        r"""
        void
        gdcm::PresentationContext::SetPresentationContextID(uint8_t id) 
        """
        return _gdcmswig.PresentationContext_SetPresentationContextID(self, id)

    def GetPresentationContextID(self):
        r"""
        uint8_t
        gdcm::PresentationContext::GetPresentationContextID() const 
        """
        return _gdcmswig.PresentationContext_GetPresentationContextID(self)

    def Print(self, os):
        r"""
        void
        gdcm::PresentationContext::Print(std::ostream &os) const 
        """
        return _gdcmswig.PresentationContext_Print(self, os)

    def __eq__(self, pc):
        return _gdcmswig.PresentationContext___eq__(self, pc)
    __swig_destroy__ = _gdcmswig.delete_PresentationContext

# Register PresentationContext in _gdcmswig:
_gdcmswig.PresentationContext_swigregister(PresentationContext)
class PresentationContextGenerator(object):
    r"""


    PresentationContextGenerator.

    This class is responsible for generating the proper
    PresentationContext that will be used in subsequent operation during a
    DICOM Query/Retrieve association. The step of the association is very
    sensible as special care need to be taken to explicitly define what
    instance are going to be send and how they are encoded.

    For example a PresentationContext will express that negotiation
    requires that CT Image Storage are send using JPEG Lossless, while US
    Image Storage are sent using RLE Transfer Syntax.

    Two very different API are exposed one which will always default to
    little endian transfer syntax see GenerateFromUID() This API is used
    for C-ECHO, C-FIND and C-MOVE (SCU). Another API:
    GenerateFromFilenames() is used for C-STORE (SCU) as it will loop over
    all filenames argument to detect the actual encoding. and therefore
    find the proper encoding to be used.

    Two modes are available. The default mode
    (SetMergeModeToAbstractSyntax) append PresentationContext (one
    AbstractSyntax and one TransferSyntax), as long a they are different.
    Eg MR Image Storage/JPEG2000 and MR Image Storage/JPEGLossless would
    be considered different. the other mode SetMergeModeToTransferSyntax
    merge any new TransferSyntax to the already existing
    PresentationContext in order to re-use the same AbstractSyntax.

    See:   PresentationContext

    C++ includes: gdcmPresentationContextGenerator.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::PresentationContextGenerator::PresentationContextGenerator()"""
        _gdcmswig.PresentationContextGenerator_swiginit(self, _gdcmswig.new_PresentationContextGenerator())

    def SetMergeModeToAbstractSyntax(self):
        r"""
        void
        gdcm::PresentationContextGenerator::SetMergeModeToAbstractSyntax() 
        """
        return _gdcmswig.PresentationContextGenerator_SetMergeModeToAbstractSyntax(self)

    def SetMergeModeToTransferSyntax(self):
        r"""
        void
        gdcm::PresentationContextGenerator::SetMergeModeToTransferSyntax() 
        """
        return _gdcmswig.PresentationContextGenerator_SetMergeModeToTransferSyntax(self)

    def GenerateFromUID(self, asname):
        r"""
        bool
        gdcm::PresentationContextGenerator::GenerateFromUID(UIDs::TSName
        asname)

        Generate the PresentationContext array from a UID (eg.
        VerificationSOPClass) 
        """
        return _gdcmswig.PresentationContextGenerator_GenerateFromUID(self, asname)

    def GenerateFromFilenames(self, files):
        r"""
        bool
        gdcm::PresentationContextGenerator::GenerateFromFilenames(const
        Directory::FilenamesType &files)

        Generate the PresentationContext array from a File-Set. File specified
        needs to be valid DICOM files. Used for C-STORE operations 
        """
        return _gdcmswig.PresentationContextGenerator_GenerateFromFilenames(self, files)

    def AddFromFile(self, file):
        r"""
        bool gdcm::PresentationContextGenerator::AddFromFile(const File
        &file)

        Add a single PresentationContext from a single File. Call multiple
        times when dealing with multiple files. 
        """
        return _gdcmswig.PresentationContextGenerator_AddFromFile(self, file)

    def GetPresentationContexts(self):
        r"""
        PresentationContextArrayType const&
        gdcm::PresentationContextGenerator::GetPresentationContexts() 
        """
        return _gdcmswig.PresentationContextGenerator_GetPresentationContexts(self)

    def SetDefaultTransferSyntax(self, ts):
        r"""
        void
        gdcm::PresentationContextGenerator::SetDefaultTransferSyntax(const
        TransferSyntax &ts)

        Not implemented for now. GDCM internally uses Implicit Little Endian.

        """
        return _gdcmswig.PresentationContextGenerator_SetDefaultTransferSyntax(self, ts)
    __swig_destroy__ = _gdcmswig.delete_PresentationContextGenerator

# Register PresentationContextGenerator in _gdcmswig:
_gdcmswig.PresentationContextGenerator_swigregister(PresentationContextGenerator)
class ServiceClassUser(Subject):
    r"""


    ServiceClassUser.

    C++ includes: gdcmServiceClassUser.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::ServiceClassUser::ServiceClassUser(const ServiceClassUser
        &)=delete 
        """
        _gdcmswig.ServiceClassUser_swiginit(self, _gdcmswig.new_ServiceClassUser())
    __swig_destroy__ = _gdcmswig.delete_ServiceClassUser

    def SetHostname(self, hostname):
        r"""
        void
        gdcm::ServiceClassUser::SetHostname(const char *hostname)

        Set the name of the called hostname (hostname or IP address) 
        """
        return _gdcmswig.ServiceClassUser_SetHostname(self, hostname)

    def SetPort(self, port):
        r"""
        void
        gdcm::ServiceClassUser::SetPort(uint16_t port)

        Set port of remote host (called application) 
        """
        return _gdcmswig.ServiceClassUser_SetPort(self, port)

    def SetPortSCP(self, portscp):
        r"""
        void
        gdcm::ServiceClassUser::SetPortSCP(uint16_t portscp)

        Set the port for any incoming C-STORE-SCP operation (typically in a
        return of C-MOVE) 
        """
        return _gdcmswig.ServiceClassUser_SetPortSCP(self, portscp)

    def SetAETitle(self, aetitle):
        r"""
        void
        gdcm::ServiceClassUser::SetAETitle(const char *aetitle)

        set calling ae title 
        """
        return _gdcmswig.ServiceClassUser_SetAETitle(self, aetitle)

    def GetAETitle(self):
        r"""
        const
        char* gdcm::ServiceClassUser::GetAETitle() const 
        """
        return _gdcmswig.ServiceClassUser_GetAETitle(self)

    def SetCalledAETitle(self, aetitle):
        r"""
        void
        gdcm::ServiceClassUser::SetCalledAETitle(const char *aetitle)

        set called ae title 
        """
        return _gdcmswig.ServiceClassUser_SetCalledAETitle(self, aetitle)

    def GetCalledAETitle(self):
        r"""const char* gdcm::ServiceClassUser::GetCalledAETitle() const"""
        return _gdcmswig.ServiceClassUser_GetCalledAETitle(self)

    def SetTimeout(self, t):
        r"""
        void
        gdcm::ServiceClassUser::SetTimeout(double t)

        set/get Timeout 
        """
        return _gdcmswig.ServiceClassUser_SetTimeout(self, t)

    def GetTimeout(self):
        r"""
        double
        gdcm::ServiceClassUser::GetTimeout() const 
        """
        return _gdcmswig.ServiceClassUser_GetTimeout(self)

    def InitializeConnection(self):
        r"""
        bool gdcm::ServiceClassUser::InitializeConnection()

        Will try to connect This will setup the actual timeout used during the
        whole connection time. Need to call SetTimeout first 
        """
        return _gdcmswig.ServiceClassUser_InitializeConnection(self)

    def SetPresentationContexts(self, pcs):
        r"""
        void gdcm::ServiceClassUser::SetPresentationContexts(std::vector<
        PresentationContext > const &pcs)

        Set the Presentation Context used for the Association. 
        """
        return _gdcmswig.ServiceClassUser_SetPresentationContexts(self, pcs)

    def IsPresentationContextAccepted(self, pc):
        r"""
        bool
        gdcm::ServiceClassUser::IsPresentationContextAccepted(const
        PresentationContext &pc) const

        Return if the passed in presentation was accepted during association
        negotiation. 
        """
        return _gdcmswig.ServiceClassUser_IsPresentationContextAccepted(self, pc)

    def StartAssociation(self):
        r"""
        bool
        gdcm::ServiceClassUser::StartAssociation()

        Start the association. Need to call SetPresentationContexts before. 
        """
        return _gdcmswig.ServiceClassUser_StartAssociation(self)

    def StopAssociation(self):
        r"""
        bool
        gdcm::ServiceClassUser::StopAssociation()

        Stop the running association. 
        """
        return _gdcmswig.ServiceClassUser_StopAssociation(self)

    def SendEcho(self):
        r"""
        bool
        gdcm::ServiceClassUser::SendEcho()

        C-ECHO. 
        """
        return _gdcmswig.ServiceClassUser_SendEcho(self)

    def SendStore(self, *args):
        r"""
        bool
        gdcm::ServiceClassUser::SendStore(File const &file)

        Execute a C-STORE on a File, the transfer syntax used for the query is
        based on the file. 
        """
        return _gdcmswig.ServiceClassUser_SendStore(self, *args)

    def SendFind(self, query, retDatasets):
        r"""
        bool
        gdcm::ServiceClassUser::SendFind(const BaseRootQuery *query,
        std::vector< DataSet > &retDatasets)

        C-FIND a query, return result are in retDatasets. 
        """
        return _gdcmswig.ServiceClassUser_SendFind(self, query, retDatasets)

    def SendMove(self, *args):
        r"""
        bool
        gdcm::ServiceClassUser::SendMove(const BaseRootQuery *query,
        std::vector< File > &retFile)

        Execute a C-MOVE, based on query, returned Files are stored in vector.

        """
        return _gdcmswig.ServiceClassUser_SendMove(self, *args)

    @staticmethod
    def New():
        return _gdcmswig.ServiceClassUser_New()

# Register ServiceClassUser in _gdcmswig:
_gdcmswig.ServiceClassUser_swigregister(ServiceClassUser)
class StreamImageReader(object):
    r"""


    StreamImageReader.

    its role is to convert the DICOM DataSet into a Image representation
    via an ITK streaming (ie, multithreaded) interface Image is different
    from Pixmap has it has a position and a direction in Space. Currently,
    this class is thread safe in that it can read a single extent in a
    single thread. Multiple versions can be used for multiple
    extents/threads.

    See:   Image

    C++ includes: gdcmStreamImageReader.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::StreamImageReader::StreamImageReader()"""
        _gdcmswig.StreamImageReader_swiginit(self, _gdcmswig.new_StreamImageReader())
    __swig_destroy__ = _gdcmswig.delete_StreamImageReader

    def SetFileName(self, inFileName):
        r"""
        void
        gdcm::StreamImageReader::SetFileName(const char *inFileName)

        One of either SetFileName or SetStream must be called prior to any
        other functions. These initialize an internal Reader class to be able
        to get non-pixel image information. 
        """
        return _gdcmswig.StreamImageReader_SetFileName(self, inFileName)

    def SetStream(self, inStream):
        r"""
        void
        gdcm::StreamImageReader::SetStream(std::istream &inStream) 
        """
        return _gdcmswig.StreamImageReader_SetStream(self, inStream)

    def GetDimensionsValueForResolution(self, arg2):
        r"""
        std::vector<unsigned int>
        gdcm::StreamImageReader::GetDimensionsValueForResolution(unsigned int)

        """
        return _gdcmswig.StreamImageReader_GetDimensionsValueForResolution(self, arg2)

    def DefinePixelExtent(self, inXMin, inXMax, inYMin, inYMax, inZMin=0, inZMax=1):
        r"""
        void gdcm::StreamImageReader::DefinePixelExtent(uint16_t inXMin,
        uint16_t inXMax, uint16_t inYMin, uint16_t inYMax, uint16_t inZMin=0,
        uint16_t inZMax=1)

        Defines an image extent for the Read function. DICOM states that an
        image can have no more than 2^16 pixels per edge (as of 2009) In this
        case, the pixel extents ignore the direction cosines entirely, and
        assumes that the origin of the image is at location 0,0 (regardless of
        the definition in space per the tags). So, if the first 100 pixels of
        the first row are to be read in, this function should be called with
        DefinePixelExtent(0, 100, 0, 1), regardless of pixel size or
        orientation. 
        """
        return _gdcmswig.StreamImageReader_DefinePixelExtent(self, inXMin, inXMax, inYMin, inYMax, inZMin, inZMax)

    def DefineProperBufferLength(self):
        r"""
        uint32_t
        gdcm::StreamImageReader::DefineProperBufferLength() const

        Paying attention to the pixel format and so forth, define the proper
        buffer length for the user. The return amount is in bytes. Call this
        function to determine the size of the char* buffer that will need to
        be passed in to ReadImageSubregion(). If the return is 0, then that
        means that the pixel extent was not defined prior 
        """
        return _gdcmswig.StreamImageReader_DefineProperBufferLength(self)

    def Read(self, inReadBuffer, inBufferLength):
        r"""
        bool
        gdcm::StreamImageReader::Read(char *inReadBuffer, const std::size_t
        &inBufferLength)

        Read the DICOM image. There are three reasons for failure: The extent
        is not set

        the conversion from char* to std::ostream (internally) fails

        the given buffer isn't large enough to accommodate the desired pixel
        extent. This method has been implemented to look similar to the
        metaimageio in itk MUST have an extent defined, or else Read will
        return false. If no particular extent is required, use ImageReader
        instead. 
        """
        return _gdcmswig.StreamImageReader_Read(self, inReadBuffer, inBufferLength)

    def CanReadImage(self):
        r"""
        bool
        gdcm::StreamImageReader::CanReadImage() const

        Only RAW images are currently readable by the stream reader. As more
        streaming codecs are added, then this function will be updated to
        reflect those changes. Calling this function prior to reading will
        ensure that only streamable files are streamed. Make sure to call
        ReadImageInformation prior to calling this function. 
        """
        return _gdcmswig.StreamImageReader_CanReadImage(self)

    def ReadImageInformation(self):
        r"""
        virtual bool gdcm::StreamImageReader::ReadImageInformation()

        Set the spacing and dimension information for the set filename.
        returns false if the file is not initialized or not an image, with the
        pixel (7fe0,0010) tag. 
        """
        return _gdcmswig.StreamImageReader_ReadImageInformation(self)

    def GetFile(self):
        r"""
        File const&
        gdcm::StreamImageReader::GetFile() const

        Returns the dataset read by ReadImageInformation Couple this with the
        ImageHelper to get statistics about the image, like pixel extent, to
        be able to initialize buffers for reading 
        """
        return _gdcmswig.StreamImageReader_GetFile(self)

# Register StreamImageReader in _gdcmswig:
_gdcmswig.StreamImageReader_swigregister(StreamImageReader)
class Region(object):
    r"""


    Class for manipulation region.

    C++ includes: gdcmRegion.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_Region

    def Print(self, *args):
        r"""
        virtual void
        gdcm::Region::Print(std::ostream &os=std::cout) const

        Print. 
        """
        return _gdcmswig.Region_Print(self, *args)

    def Empty(self):
        r"""
        virtual bool
        gdcm::Region::Empty() const =0

        return whether this domain is empty: 
        """
        return _gdcmswig.Region_Empty(self)

    def IsValid(self):
        r"""
        virtual bool
        gdcm::Region::IsValid() const =0

        return whether this is valid domain 
        """
        return _gdcmswig.Region_IsValid(self)

    def Area(self):
        r"""
        virtual size_t
        gdcm::Region::Area() const =0

        compute the area 
        """
        return _gdcmswig.Region_Area(self)

    def Clone(self):
        r"""
        virtual Region*
        gdcm::Region::Clone() const =0 
        """
        return _gdcmswig.Region_Clone(self)

    def ComputeBoundingBox(self):
        r"""
        virtual
        BoxRegion gdcm::Region::ComputeBoundingBox()=0

        Return the Axis-Aligned minimum bounding box for all regions. 
        """
        return _gdcmswig.Region_ComputeBoundingBox(self)

    def __str__(self):
        return _gdcmswig.Region___str__(self)

# Register Region in _gdcmswig:
_gdcmswig.Region_swigregister(Region)

def __lshift__(*args):
    return _gdcmswig.__lshift__(*args)
class BoxRegion(Region):
    r"""


    Class for manipulation box region.

    This is a very simple implementation of the Region class. It only
    support 3D box type region. It assumes the 3D Box does not have a tilt
    Origin is as (0,0,0)

    C++ includes: gdcmBoxRegion.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdcmswig.delete_BoxRegion

    def SetDomain(self, xmin, xmax, ymin, ymax, zmin, zmax):
        r"""
        void
        gdcm::BoxRegion::SetDomain(unsigned int xmin, unsigned int xmax,
        unsigned int ymin, unsigned int ymax, unsigned int zmin, unsigned int
        zmax)

        Set domain. 
        """
        return _gdcmswig.BoxRegion_SetDomain(self, xmin, xmax, ymin, ymax, zmin, zmax)

    def GetXMin(self):
        r"""
        unsigned int
        gdcm::BoxRegion::GetXMin() const

        Get domain. 
        """
        return _gdcmswig.BoxRegion_GetXMin(self)

    def GetXMax(self):
        r"""
        unsigned int
        gdcm::BoxRegion::GetXMax() const 
        """
        return _gdcmswig.BoxRegion_GetXMax(self)

    def GetYMin(self):
        r"""
        unsigned int
        gdcm::BoxRegion::GetYMin() const 
        """
        return _gdcmswig.BoxRegion_GetYMin(self)

    def GetYMax(self):
        r"""
        unsigned int
        gdcm::BoxRegion::GetYMax() const 
        """
        return _gdcmswig.BoxRegion_GetYMax(self)

    def GetZMin(self):
        r"""
        unsigned int
        gdcm::BoxRegion::GetZMin() const 
        """
        return _gdcmswig.BoxRegion_GetZMin(self)

    def GetZMax(self):
        r"""
        unsigned int
        gdcm::BoxRegion::GetZMax() const 
        """
        return _gdcmswig.BoxRegion_GetZMax(self)

    def Clone(self):
        r"""
        Region*
        gdcm::BoxRegion::Clone() const override 
        """
        return _gdcmswig.BoxRegion_Clone(self)

    def Empty(self):
        r"""
        bool
        gdcm::BoxRegion::Empty() const override

        return whether this domain is empty: 
        """
        return _gdcmswig.BoxRegion_Empty(self)

    def IsValid(self):
        r"""
        bool
        gdcm::BoxRegion::IsValid() const override

        return whether this is valid domain 
        """
        return _gdcmswig.BoxRegion_IsValid(self)

    def Area(self):
        r"""
        size_t
        gdcm::BoxRegion::Area() const override

        compute the area 
        """
        return _gdcmswig.BoxRegion_Area(self)

    def ComputeBoundingBox(self):
        r"""
        BoxRegion
        gdcm::BoxRegion::ComputeBoundingBox() override

        Return the Axis-Aligned minimum bounding box for all regions. 
        """
        return _gdcmswig.BoxRegion_ComputeBoundingBox(self)

    def Print(self, *args):
        r"""
        void
        gdcm::BoxRegion::Print(std::ostream &os=std::cout) const override

        Print. 
        """
        return _gdcmswig.BoxRegion_Print(self, *args)

    @staticmethod
    def BoundingBox(b1, b2):
        return _gdcmswig.BoxRegion_BoundingBox(b1, b2)

    def __init__(self, *args):
        r"""
        gdcm::BoxRegion::BoxRegion(const BoxRegion &)

        copy/cstor and al. 
        """
        _gdcmswig.BoxRegion_swiginit(self, _gdcmswig.new_BoxRegion(*args))

    def __str__(self):
        return _gdcmswig.BoxRegion___str__(self)

# Register BoxRegion in _gdcmswig:
_gdcmswig.BoxRegion_swigregister(BoxRegion)
class ImageRegionReader(ImageReader):
    r"""


    ImageRegionReader.

    This class is able to read a region from a DICOM file containing an
    image. This implementation requires that the information stored in the
    DICOM header are consistent with what is in the encapsulated Pixel
    Data. This is technically not required by DICOM standard, which makes
    this implementation illegal with regards to the famous JPEG
    note:http://dicom.nema.org/medical/dicom/current/output/chtml/part05/sect_8.2.html#para_4bcb841e-c6bf-4e26-82a5-3fad3c942da0
    See:   ImageReader

    C++ includes: gdcmImageRegionReader.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::ImageRegionReader::ImageRegionReader()"""
        _gdcmswig.ImageRegionReader_swiginit(self, _gdcmswig.new_ImageRegionReader())
    __swig_destroy__ = _gdcmswig.delete_ImageRegionReader

    def SetRegion(self, region):
        r"""
        void
        gdcm::ImageRegionReader::SetRegion(Region const &region)

        Set/Get Region to be read. 
        """
        return _gdcmswig.ImageRegionReader_SetRegion(self, region)

    def GetRegion(self):
        r"""
        Region
        const& gdcm::ImageRegionReader::GetRegion() const 
        """
        return _gdcmswig.ImageRegionReader_GetRegion(self)

    def ComputeBufferLength(self):
        r"""
        size_t gdcm::ImageRegionReader::ComputeBufferLength() const

        Explicit call which will compute the minimal buffer length that can
        hold the whole uncompressed image as defined by Region region. 0 upon
        error 
        """
        return _gdcmswig.ImageRegionReader_ComputeBufferLength(self)

    def ReadInformation(self):
        r"""
        bool
        gdcm::ImageRegionReader::ReadInformation()

        Read meta information (not Pixel Data) from the DICOM file. false upon
        error 
        """
        return _gdcmswig.ImageRegionReader_ReadInformation(self)

    def ReadIntoBuffer(self, inreadbuffer):
        r"""
        bool
        gdcm::ImageRegionReader::ReadIntoBuffer(char *inreadbuffer, size_t
        buflen)

        Read into buffer: For Python, the buflen param is deduced directly
        from the input bytearray passed as parameter (function only takes one
        param). false upon error 
        """
        return _gdcmswig.ImageRegionReader_ReadIntoBuffer(self, inreadbuffer)

# Register ImageRegionReader in _gdcmswig:
_gdcmswig.ImageRegionReader_swigregister(ImageRegionReader)
class JSON(object):
    r"""C++ includes: gdcmJSON.h"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::JSON::JSON()"""
        _gdcmswig.JSON_swiginit(self, _gdcmswig.new_JSON())
    __swig_destroy__ = _gdcmswig.delete_JSON

    def GetPrettyPrint(self):
        r"""
        bool
        gdcm::JSON::GetPrettyPrint() const 
        """
        return _gdcmswig.JSON_GetPrettyPrint(self)

    def SetPrettyPrint(self, onoff):
        r"""
        void
        gdcm::JSON::SetPrettyPrint(bool onoff) 
        """
        return _gdcmswig.JSON_SetPrettyPrint(self, onoff)

    def PrettyPrintOn(self):
        r"""
        void
        gdcm::JSON::PrettyPrintOn() 
        """
        return _gdcmswig.JSON_PrettyPrintOn(self)

    def PrettyPrintOff(self):
        r"""
        void
        gdcm::JSON::PrettyPrintOff() 
        """
        return _gdcmswig.JSON_PrettyPrintOff(self)

    def Code(self, _in, os):
        r"""
        bool
        gdcm::JSON::Code(DataSet const &in, std::ostream &os) 
        """
        return _gdcmswig.JSON_Code(self, _in, os)

    def Decode(self, _is, out):
        r"""
        bool
        gdcm::JSON::Decode(std::istream &is, DataSet &out) 
        """
        return _gdcmswig.JSON_Decode(self, _is, out)

# Register JSON in _gdcmswig:
_gdcmswig.JSON_swigregister(JSON)
class FileDecompressLookupTable(Subject):
    r"""


    FileDecompressLookupTable class.

    It decompress the segmented LUT into linearized one (only
    PALETTE_COLOR images) Output will be a PhotometricInterpretation=RGB
    image

    C++ includes: gdcmFileDecompressLookupTable.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""
        gdcm::FileDecompressLookupTable::FileDecompressLookupTable()=default

        """
        _gdcmswig.FileDecompressLookupTable_swiginit(self, _gdcmswig.new_FileDecompressLookupTable())
    __swig_destroy__ = _gdcmswig.delete_FileDecompressLookupTable

    def Change(self):
        r"""
        bool
        gdcm::FileDecompressLookupTable::Change()

        Decompress. 
        """
        return _gdcmswig.FileDecompressLookupTable_Change(self)

    def SetFile(self, f):
        r"""
        void
        gdcm::FileDecompressLookupTable::SetFile(const File &f)

        Set/Get File. 
        """
        return _gdcmswig.FileDecompressLookupTable_SetFile(self, f)

    def GetFile(self):
        r"""File& gdcm::FileDecompressLookupTable::GetFile()"""
        return _gdcmswig.FileDecompressLookupTable_GetFile(self)

    def GetPixmap(self, *args):
        r"""const Pixmap& gdcm::FileDecompressLookupTable::GetPixmap() const"""
        return _gdcmswig.FileDecompressLookupTable_GetPixmap(self, *args)

    def SetPixmap(self, img):
        r"""void gdcm::FileDecompressLookupTable::SetPixmap(Pixmap const &img)"""
        return _gdcmswig.FileDecompressLookupTable_SetPixmap(self, img)

# Register FileDecompressLookupTable in _gdcmswig:
_gdcmswig.FileDecompressLookupTable_swigregister(FileDecompressLookupTable)
class EmptyMaskGenerator(object):
    r"""


    EmptyMaskGenerator Main class to generate a Empty Mask Series from an
    input Series. This class takes an input folder and generates a series
    of DICOM files in the specified output directory. This class handles
    multiples DICOM Series within the same input directory.

    The class allow two mode of operations: UseOriginalSOPClassUID

    UseGrayscaleSecondaryImageStorage

    UseOriginalSOPClassUID is the mode where original attributes are
    copied from the original DICOM instance.

    UseGrayscaleSecondaryImageStorage is the mode where attributes are
    generated so as to create a
    MultiframeGrayscaleByteSecondaryCaptureImageStorage
    (MultiframeGrayscaleWordSecondaryCaptureImageStorage) instance.

    In both mode: the Study references (StudyInstanceUID and StudyID) are
    preserved.

    the PatientID reference is preserved.

    the Image Type attribute will be setup so that the fourth element is
    set to 'MASK'.

    a new Series Instance UID is generated. It is thus required to run the
    process over all files using the same input Series Instance UID so
    that a proper mapping from the old Series UID is done to the new one.
    Since a new Series Instance UID is generated, there is no sense to
    preserve the original Frame of Reference UID, although it would have
    made sense here.

    C++ includes: gdcmEmptyMaskGenerator.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""gdcm::EmptyMaskGenerator::EmptyMaskGenerator()"""
        _gdcmswig.EmptyMaskGenerator_swiginit(self, _gdcmswig.new_EmptyMaskGenerator())
    __swig_destroy__ = _gdcmswig.delete_EmptyMaskGenerator
    UseOriginalSOPClassUID = _gdcmswig.EmptyMaskGenerator_UseOriginalSOPClassUID
    UseGrayscaleSecondaryImageStorage = _gdcmswig.EmptyMaskGenerator_UseGrayscaleSecondaryImageStorage

    def SetSOPClassUIDMode(self, mode):
        r"""
        void gdcm::EmptyMaskGenerator::SetSOPClassUIDMode(SOPClassUIDMode
        mode)

        Select generation of SOP Class UID method: Default is
        UseOriginalSOPClassUID 
        """
        return _gdcmswig.EmptyMaskGenerator_SetSOPClassUIDMode(self, mode)

    def SetInputDirectory(self, dirname):
        r"""
        void gdcm::EmptyMaskGenerator::SetInputDirectory(const char *dirname)

        Specify input directory. 
        """
        return _gdcmswig.EmptyMaskGenerator_SetInputDirectory(self, dirname)

    def SetOutputDirectory(self, dirname):
        r"""
        void gdcm::EmptyMaskGenerator::SetOutputDirectory(const char *dirname)

        Specify output directory. 
        """
        return _gdcmswig.EmptyMaskGenerator_SetOutputDirectory(self, dirname)

    def Execute(self):
        r"""
        bool
        gdcm::EmptyMaskGenerator::Execute()

        Main loop. 
        """
        return _gdcmswig.EmptyMaskGenerator_Execute(self)

# Register EmptyMaskGenerator in _gdcmswig:
_gdcmswig.EmptyMaskGenerator_swigregister(EmptyMaskGenerator)
class EquipmentManufacturer(object):
    r"""


    The intent is for private tags handling. This class is not meant to
    handle all possible vendors in the world, simply those well known
    where we intend to read private tags afterwards (typically
    SIEMENS+CSA, GEMS+PDB ...)

    C++ includes: gdcmEquipmentManufacturer.h 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    UNKNOWN = _gdcmswig.EquipmentManufacturer_UNKNOWN
    AGFA = _gdcmswig.EquipmentManufacturer_AGFA
    FUJI = _gdcmswig.EquipmentManufacturer_FUJI
    GEMS = _gdcmswig.EquipmentManufacturer_GEMS
    HITACHI = _gdcmswig.EquipmentManufacturer_HITACHI
    KODAK = _gdcmswig.EquipmentManufacturer_KODAK
    MARCONI = _gdcmswig.EquipmentManufacturer_MARCONI
    PMS = _gdcmswig.EquipmentManufacturer_PMS
    SAMSUNG = _gdcmswig.EquipmentManufacturer_SAMSUNG
    SIEMENS = _gdcmswig.EquipmentManufacturer_SIEMENS
    TOSHIBA = _gdcmswig.EquipmentManufacturer_TOSHIBA
    UIH = _gdcmswig.EquipmentManufacturer_UIH

    @staticmethod
    def Compute(ds):
        return _gdcmswig.EquipmentManufacturer_Compute(ds)

    @staticmethod
    def TypeToString(type):
        return _gdcmswig.EquipmentManufacturer_TypeToString(type)

    def __init__(self):
        _gdcmswig.EquipmentManufacturer_swiginit(self, _gdcmswig.new_EquipmentManufacturer())
    __swig_destroy__ = _gdcmswig.delete_EquipmentManufacturer

# Register EquipmentManufacturer in _gdcmswig:
_gdcmswig.EquipmentManufacturer_swigregister(EquipmentManufacturer)

