/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Mask an image with a mask.


This class is templated over the types of the input image type, the
mask image type and the type of the output image. Numeric conversions
(castings) are done by the C++ defaults.

The pixel type of the input 2 image must have a valid definition of
the operator != with zero. This condition is required because
internally this filter will perform the operation


The pixel from the input 1 is cast to the pixel type of the output
image.

Note that the input and the mask images must be of the same size.


WARNING:
Any pixel value other than masking value (0 by default) will not be
masked out.

See:
 MaskNegatedImageFilter

 itk::simple::Mask for the procedural interface

 itk::MaskImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMaskImageFilter.h
*/
public class MaskImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MaskImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MaskImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MaskImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MaskImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MaskImageFilter::~MaskImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MaskImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MaskImageFilter::MaskImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MaskImageFilter() {
    this(SimpleITKJNI.new_MaskImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MaskImageFilter::SetOutsideValue(double OutsideValue)

Method to explicitly set the outside value of the mask. Defaults to 0

*/
public  void setOutsideValue(double OutsideValue) {
    SimpleITKJNI.MaskImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
double itk::simple::MaskImageFilter::GetOutsideValue() const
*/
public  double getOutsideValue() {
    return SimpleITKJNI.MaskImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MaskImageFilter::SetMaskingValue(double MaskingValue)

Method to explicitly set the masking value of the mask. Defaults to 0

*/
public  void setMaskingValue(double MaskingValue) {
    SimpleITKJNI.MaskImageFilter_setMaskingValue(swigCPtr, this, MaskingValue);
  }

  /**
double itk::simple::MaskImageFilter::GetMaskingValue() const

Method to get the masking value of the mask.

*/
public  double getMaskingValue() {
    return SimpleITKJNI.MaskImageFilter_getMaskingValue(swigCPtr, this);
  }

  /**
std::string itk::simple::MaskImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MaskImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MaskImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MaskImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MaskImageFilter::Execute(Image &amp;&amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.MaskImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

}
