/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarIdentifierWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalParserRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalZonedDateTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalZonedDateTimeNode() {
    }

    public abstract JSTemporalZonedDateTimeObject execute(Object var1, Object var2);

    @Specialization
    public JSTemporalZonedDateTimeObject toTemporalZonedDateTime(Object item, Object options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached IsObjectNode isObjectNode, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObject, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached GetTemporalCalendarIdentifierWithISODefaultNode getCalendarWithISODefault, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached TruffleString.ToJavaStringNode toJavaString, @Cached TruffleString.FromJavaStringNode fromJavaString) {
        JSTemporalDateTimeRecord result;
        TemporalUtil.OffsetOption offsetOption;
        TemporalUtil.Disambiguation disambiguation;
        TruffleString timeZone;
        TruffleString calendar;
        TruffleString offsetString = null;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        TemporalUtil.OffsetBehaviour offsetBehaviour = TemporalUtil.OffsetBehaviour.OPTION;
        TemporalUtil.MatchBehaviour matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            if (isZonedDateTimeProfile.profile((Node)this, TemporalUtil.isTemporalZonedDateTime(item))) {
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
                TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.REJECT, getOptionNode, equalNode);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                JSTemporalZonedDateTimeObject zdt = (JSTemporalZonedDateTimeObject)((Object)item);
                return JSTemporalZonedDateTime.create(ctx, realm, zdt.getNanoseconds(), zdt.getTimeZone(), zdt.getCalendar());
            }
            calendar = getCalendarWithISODefault.execute(item);
            JSObject fields = TemporalUtil.prepareCalendarFields(ctx, calendar, item, TemporalUtil.listDMMCY, TemporalUtil.listTimeUnitsOffsetTZ, TemporalUtil.listTimeZone);
            timeZone = (TruffleString)JSObject.get((JSDynamicObject)fields, TemporalConstants.TIME_ZONE);
            Object offsetStringObj = JSObject.get((JSDynamicObject)fields, TemporalConstants.OFFSET);
            if (offsetStringObj == Undefined.instance) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            } else {
                offsetString = (TruffleString)offsetStringObj;
            }
            resolvedOptions = getOptionsObject.execute(options);
            disambiguation = TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
            offsetOption = TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.REJECT, getOptionNode, equalNode);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, overflow, dateFromFieldsNode);
        } else if (item instanceof TruffleString) {
            JSTemporalParserRecord rec;
            TruffleString string = (TruffleString)item;
            ParseISODateTimeResult resultZDT = TemporalUtil.parseTemporalDateTimeString(true, string);
            result = resultZDT;
            TruffleString annotation = resultZDT.getTimeZoneResult().getName();
            assert (annotation != null);
            timeZone = toTimeZoneIdentifier.execute(annotation);
            offsetString = resultZDT.getTimeZoneResult().getOffsetString();
            if (resultZDT.getTimeZoneResult().isZ()) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.EXACT;
            } else if (offsetString == null) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            }
            calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            } else {
                String calendarJLS = toJavaString.execute((AbstractTruffleString)calendar);
                calendar = Strings.fromJavaString(fromJavaString, IntlUtil.canonicalizeCalendar(calendarJLS));
            }
            matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_MINUTES;
            if (offsetString != null && (rec = TemporalUtil.parseTimeZoneOffsetStringHelper(offsetString)).hasOffsetSecond()) {
                matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
            }
            resolvedOptions = getOptionsObject.execute(options);
            disambiguation = TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
            offsetOption = TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.REJECT, getOptionNode, equalNode);
            TemporalUtil.toTemporalOverflow(resolvedOptions, getOptionNode);
        } else {
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorNotAString(item);
        }
        long offsetNanoseconds = 0L;
        if (offsetBehaviour == TemporalUtil.OffsetBehaviour.OPTION) {
            offsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString(offsetString);
        }
        BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), offsetBehaviour, offsetNanoseconds, timeZone, disambiguation, offsetOption, matchBehaviour);
        return JSTemporalZonedDateTime.create(ctx, realm, epochNanoseconds, timeZone, calendar);
    }
}

