/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.yaml;

import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.SpecVersion;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.dataformat.yaml.YAMLFactory;
import tools.jackson.dataformat.yaml.YAMLReadFeature;
import tools.jackson.dataformat.yaml.YAMLWriteFeature;
import tools.jackson.dataformat.yaml.util.StringQuotingChecker;

public class YAMLFactoryBuilder
extends DecorableTSFactory.DecorableTSFBuilder<YAMLFactory, YAMLFactoryBuilder> {
    protected StringQuotingChecker _quotingChecker;
    protected SpecVersion _version;
    protected LoadSettings _loadSettings;
    protected DumpSettings _dumpSettings;

    protected YAMLFactoryBuilder() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), 0, YAMLFactory.DEFAULT_YAML_GENERATOR_FEATURE_FLAGS);
    }

    public YAMLFactoryBuilder(YAMLFactory base) {
        super((DecorableTSFactory)base);
        this._version = base._version;
        this._quotingChecker = base._quotingChecker;
        this._loadSettings = base._loadSettings;
        this._dumpSettings = base._dumpSettings;
    }

    public YAMLFactoryBuilder enable(YAMLWriteFeature f) {
        this._formatWriteFeatures |= f.getMask();
        return this;
    }

    public YAMLFactoryBuilder enable(YAMLWriteFeature first, YAMLWriteFeature ... other) {
        this._formatWriteFeatures |= first.getMask();
        for (YAMLWriteFeature f : other) {
            this._formatWriteFeatures |= f.getMask();
        }
        return this;
    }

    public YAMLFactoryBuilder disable(YAMLWriteFeature f) {
        this._formatWriteFeatures &= ~f.getMask();
        return this;
    }

    public YAMLFactoryBuilder disable(YAMLWriteFeature first, YAMLWriteFeature ... other) {
        this._formatWriteFeatures &= ~first.getMask();
        for (YAMLWriteFeature f : other) {
            this._formatWriteFeatures &= ~f.getMask();
        }
        return this;
    }

    public YAMLFactoryBuilder configure(YAMLWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public YAMLFactoryBuilder enable(YAMLReadFeature f) {
        this._formatReadFeatures |= f.getMask();
        return this;
    }

    public YAMLFactoryBuilder enable(YAMLReadFeature first, YAMLReadFeature ... other) {
        this._formatReadFeatures |= first.getMask();
        for (YAMLReadFeature f : other) {
            this._formatReadFeatures |= f.getMask();
        }
        return this;
    }

    public YAMLFactoryBuilder disable(YAMLReadFeature f) {
        this._formatReadFeatures &= ~f.getMask();
        return this;
    }

    public YAMLFactoryBuilder disable(YAMLReadFeature first, YAMLReadFeature ... other) {
        this._formatReadFeatures &= ~first.getMask();
        for (YAMLReadFeature f : other) {
            this._formatReadFeatures &= ~f.getMask();
        }
        return this;
    }

    public YAMLFactoryBuilder configure(YAMLReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public YAMLFactoryBuilder stringQuotingChecker(StringQuotingChecker sqc) {
        this._quotingChecker = sqc;
        return this;
    }

    public YAMLFactoryBuilder yamlVersionToWrite(SpecVersion v) {
        this._version = v;
        return this;
    }

    public YAMLFactoryBuilder loadSettings(LoadSettings settings) {
        this._loadSettings = settings;
        if (!this._loadSettings.getAllowDuplicateKeys()) {
            this.enable(StreamReadFeature.STRICT_DUPLICATE_DETECTION);
        }
        return this;
    }

    public YAMLFactoryBuilder dumperOptions(DumpSettings dumperOptions) {
        this._dumpSettings = dumperOptions;
        return this;
    }

    public SpecVersion yamlVersionToWrite() {
        return this._version;
    }

    public StringQuotingChecker stringQuotingChecker() {
        if (this._quotingChecker != null) {
            return this._quotingChecker;
        }
        return StringQuotingChecker.Default.instance();
    }

    public LoadSettings loadSettings() {
        return this._loadSettings;
    }

    public DumpSettings dumpSettings() {
        return this._dumpSettings;
    }

    public YAMLFactory build() {
        return new YAMLFactory(this);
    }
}

