/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.GrouperBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.GrouperBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PGroupBy;
import com.oracle.graal.python.builtins.objects.itertools.PGrouper;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGrouper})
public final class GrouperBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = GrouperBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GrouperBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"currValueIsSelf(self)"})
        static Object reduce(PGrouper self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = PFactory.createTuple(language, new Object[]{self.getParent(), self.getTgtKey()});
            return PFactory.createTuple(language, new Object[]{type, tuple});
        }

        @Specialization(guards={"!currValueIsSelf(self)"})
        Object reduceCurrNotSelf(VirtualFrame frame, PGrouper self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Bind PythonLanguage language) {
            PythonModule builtins = this.getContext().getCore().lookupBuiltinModule(BuiltinNames.T_BUILTINS);
            Object iterCallable = getAttrNode.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_ITER);
            return PFactory.createTuple(language, new Object[]{iterCallable, PFactory.createTuple(language, new Object[]{PFactory.createEmptyTuple(language)})});
        }

        protected boolean currValueIsSelf(PGrouper self) {
            return self.getParent().getCurrGrouper() == self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object next(VirtualFrame frame, PGrouper self, @Bind Node inliningTarget, @Cached PyIterNextNode nextNode, @Cached CallNode callNode, @Cached PyObjectRichCompareBool eqNode, @Cached InlinedBranchProfile currGrouperProfile, @Cached InlinedBranchProfile currValueMarkerProfile, @Cached InlinedBranchProfile currValueTgtProfile, @Cached InlinedConditionProfile hasFuncProfile) {
            PGroupBy gbo = self.getParent();
            if (gbo.getCurrGrouper() != self) {
                currGrouperProfile.enter(inliningTarget);
                throw NextNode.iteratorExhausted();
            }
            if (gbo.getCurrValue() == null) {
                currValueMarkerProfile.enter(inliningTarget);
                gbo.groupByStep(frame, inliningTarget, nextNode, callNode, hasFuncProfile);
            }
            if (!eqNode.executeEq((Frame)frame, inliningTarget, self.getTgtKey(), gbo.getCurrKey())) {
                currValueTgtProfile.enter(inliningTarget);
                throw NextNode.iteratorExhausted();
            }
            Object r = gbo.getCurrValue();
            gbo.setCurrValue(null);
            return r;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PGrouper self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="_grouper", minNumOfPositionalArgs=2, parameterNames={"$self", "parent", "tgtkey"})
    @GenerateNodeFactory
    public static abstract class GrouperNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static PGrouper construct(Object cls, Object parent, Object tgtKey, @Bind Node inliningTarget, @Cached InlinedConditionProfile wrongTypeProfile, @Cached InlinedConditionProfile isPGroupByProfile, @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            if (!wrongTypeProfile.profile(inliningTarget, isTypeNode.execute(inliningTarget, cls))) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            if (!isPGroupByProfile.profile(inliningTarget, parent instanceof PGroupBy)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INCORRECT_USAGE_OF_INTERNAL_GROUPER);
            }
            return PFactory.createGrouper(language, (PGroupBy)parent, tgtKey);
        }
    }
}

