/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.NonIncrementalCachingContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.UpToDateResult;

public class NeverUpToDateStep<C extends NonIncrementalCachingContext>
implements Step<C, UpToDateResult> {
    private static final ImmutableList<String> NO_HISTORY = ImmutableList.of((Object)"No history is available.");
    private final Step<? super NonIncrementalCachingContext, ? extends AfterExecutionResult> delegate;

    public NeverUpToDateStep(Step<? super NonIncrementalCachingContext, ? extends AfterExecutionResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public UpToDateResult execute(UnitOfWork work, C context) {
        AfterExecutionResult result = this.delegate.execute(work, (NonIncrementalCachingContext)context);
        return new UpToDateResult(result, NO_HISTORY);
    }
}

