/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.cli;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;

public class PropertiesArgs {
    public static void parse(Object target, Properties arguments) {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            PropertiesArgs.processField(target, field, arguments);
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                PropertiesArgs.processProperty(target, pd, arguments);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private static void processField(Object target, Field field, Properties arguments) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            String name = Args.getName(argument, field);
            String alias = Args.getAlias(argument);
            Class<?> type = field.getType();
            Object value = arguments.get(name);
            if (value == null && alias != null) {
                value = arguments.get(alias);
            }
            if (value != null) {
                if (type == Boolean.TYPE || type == Boolean.class) {
                    value = true;
                }
                Args.setField(type, field, target, value, argument.delimiter());
            } else if (argument.required()) {
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property, Properties arguments) {
        Argument argument;
        Method writeMethod = property.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            String name = Args.getName(argument, property);
            String alias = Args.getAlias(argument);
            Object value = arguments.get(name);
            if (value == null && alias != null) {
                value = arguments.get(alias);
            }
            if (value != null) {
                Class<?> type = property.getPropertyType();
                if (type == Boolean.TYPE || type == Boolean.class) {
                    value = true;
                }
                Args.setProperty(type, property, target, value, argument.delimiter());
            } else if (argument.required()) {
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }
}

