﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/states/SFN_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SFN {
namespace Model {
class CreateStateMachineAliasResult {
 public:
  AWS_SFN_API CreateStateMachineAliasResult() = default;
  AWS_SFN_API CreateStateMachineAliasResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SFN_API CreateStateMachineAliasResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that identifies the created state machine
   * alias.</p>
   */
  inline const Aws::String& GetStateMachineAliasArn() const { return m_stateMachineAliasArn; }
  template <typename StateMachineAliasArnT = Aws::String>
  void SetStateMachineAliasArn(StateMachineAliasArnT&& value) {
    m_stateMachineAliasArnHasBeenSet = true;
    m_stateMachineAliasArn = std::forward<StateMachineAliasArnT>(value);
  }
  template <typename StateMachineAliasArnT = Aws::String>
  CreateStateMachineAliasResult& WithStateMachineAliasArn(StateMachineAliasArnT&& value) {
    SetStateMachineAliasArn(std::forward<StateMachineAliasArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date the state machine alias was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  CreateStateMachineAliasResult& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateStateMachineAliasResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_stateMachineAliasArn;
  bool m_stateMachineAliasArnHasBeenSet = false;

  Aws::Utils::DateTime m_creationDate{};
  bool m_creationDateHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SFN
}  // namespace Aws
