﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/datazone/DataZone_EXPORTS.h>
#include <aws/datazone/model/DeploymentStatus.h>
#include <aws/datazone/model/DeploymentType.h>
#include <aws/datazone/model/EnvironmentError.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DataZone {
namespace Model {

/**
 * <p>The details of the last deployment of the environment.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Deployment">AWS
 * API Reference</a></p>
 */
class Deployment {
 public:
  AWS_DATAZONE_API Deployment() = default;
  AWS_DATAZONE_API Deployment(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API Deployment& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the last deployment of the environment.</p>
   */
  inline const Aws::String& GetDeploymentId() const { return m_deploymentId; }
  inline bool DeploymentIdHasBeenSet() const { return m_deploymentIdHasBeenSet; }
  template <typename DeploymentIdT = Aws::String>
  void SetDeploymentId(DeploymentIdT&& value) {
    m_deploymentIdHasBeenSet = true;
    m_deploymentId = std::forward<DeploymentIdT>(value);
  }
  template <typename DeploymentIdT = Aws::String>
  Deployment& WithDeploymentId(DeploymentIdT&& value) {
    SetDeploymentId(std::forward<DeploymentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the last deployment of the environment.</p>
   */
  inline DeploymentType GetDeploymentType() const { return m_deploymentType; }
  inline bool DeploymentTypeHasBeenSet() const { return m_deploymentTypeHasBeenSet; }
  inline void SetDeploymentType(DeploymentType value) {
    m_deploymentTypeHasBeenSet = true;
    m_deploymentType = value;
  }
  inline Deployment& WithDeploymentType(DeploymentType value) {
    SetDeploymentType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the last deployment of the environment.</p>
   */
  inline DeploymentStatus GetDeploymentStatus() const { return m_deploymentStatus; }
  inline bool DeploymentStatusHasBeenSet() const { return m_deploymentStatusHasBeenSet; }
  inline void SetDeploymentStatus(DeploymentStatus value) {
    m_deploymentStatusHasBeenSet = true;
    m_deploymentStatus = value;
  }
  inline Deployment& WithDeploymentStatus(DeploymentStatus value) {
    SetDeploymentStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The failure reason of the last deployment of the environment.</p>
   */
  inline const EnvironmentError& GetFailureReason() const { return m_failureReason; }
  inline bool FailureReasonHasBeenSet() const { return m_failureReasonHasBeenSet; }
  template <typename FailureReasonT = EnvironmentError>
  void SetFailureReason(FailureReasonT&& value) {
    m_failureReasonHasBeenSet = true;
    m_failureReason = std::forward<FailureReasonT>(value);
  }
  template <typename FailureReasonT = EnvironmentError>
  Deployment& WithFailureReason(FailureReasonT&& value) {
    SetFailureReason(std::forward<FailureReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The messages of the last deployment of the environment.</p>
   */
  inline const Aws::Vector<Aws::String>& GetMessages() const { return m_messages; }
  inline bool MessagesHasBeenSet() const { return m_messagesHasBeenSet; }
  template <typename MessagesT = Aws::Vector<Aws::String>>
  void SetMessages(MessagesT&& value) {
    m_messagesHasBeenSet = true;
    m_messages = std::forward<MessagesT>(value);
  }
  template <typename MessagesT = Aws::Vector<Aws::String>>
  Deployment& WithMessages(MessagesT&& value) {
    SetMessages(std::forward<MessagesT>(value));
    return *this;
  }
  template <typename MessagesT = Aws::String>
  Deployment& AddMessages(MessagesT&& value) {
    m_messagesHasBeenSet = true;
    m_messages.emplace_back(std::forward<MessagesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the last deployment of the environment is complete.</p>
   */
  inline bool GetIsDeploymentComplete() const { return m_isDeploymentComplete; }
  inline bool IsDeploymentCompleteHasBeenSet() const { return m_isDeploymentCompleteHasBeenSet; }
  inline void SetIsDeploymentComplete(bool value) {
    m_isDeploymentCompleteHasBeenSet = true;
    m_isDeploymentComplete = value;
  }
  inline Deployment& WithIsDeploymentComplete(bool value) {
    SetIsDeploymentComplete(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_deploymentId;

  DeploymentType m_deploymentType{DeploymentType::NOT_SET};

  DeploymentStatus m_deploymentStatus{DeploymentStatus::NOT_SET};

  EnvironmentError m_failureReason;

  Aws::Vector<Aws::String> m_messages;

  bool m_isDeploymentComplete{false};
  bool m_deploymentIdHasBeenSet = false;
  bool m_deploymentTypeHasBeenSet = false;
  bool m_deploymentStatusHasBeenSet = false;
  bool m_failureReasonHasBeenSet = false;
  bool m_messagesHasBeenSet = false;
  bool m_isDeploymentCompleteHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataZone
}  // namespace Aws
