/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDCellValue;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.DataTransferPageNodeSettings;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.forms.UIAlignX;
import org.jkiss.dbeaver.ui.forms.UIControlBuilder;
import org.jkiss.dbeaver.ui.forms.UIObservable;
import org.jkiss.dbeaver.ui.forms.UIObservables;
import org.jkiss.dbeaver.ui.forms.UIPanelBuilder;
import org.jkiss.dbeaver.ui.forms.UIRowBuilder;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DatabaseProducerPageExtractSettings
extends DataTransferPageNodeSettings {
    private final UIObservable<Strategy> strategy = UIObservable.of((Enum)Strategy.QUERY_DATABASE);
    private final UIObservable<Boolean> openNewConnections = UIObservable.of((boolean)false);
    private final UIObservable<Boolean> fetchRowCount = UIObservable.of((boolean)false);
    private final UIObservable<Boolean> selectedRowsOnly = UIObservable.of((boolean)false);
    private final UIObservable<Boolean> selectedColumnsOnly = UIObservable.of((boolean)false);
    private final UIObservable<Integer> fetchSize = UIObservable.of((int)10000);
    private final UIObservable<Integer> threadCount = UIObservable.of((int)1);
    private final UIObservable<Integer> segmentSize = UIObservable.of((int)10000);
    private final UIObservable<DatabaseProducerSettings.ExtractType> extractType = UIObservable.of((Enum)DatabaseProducerSettings.ExtractType.SINGLE_QUERY);

    public DatabaseProducerPageExtractSettings() {
        super(DTUIMessages.database_producer_page_extract_settings_name_and_title);
        this.setTitle(DTUIMessages.database_producer_page_extract_settings_name_and_title);
        this.setDescription(DTUIMessages.database_producer_page_extract_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(@NotNull Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        UIPanelBuilder.build((Composite)composite, pb -> {
            UIPanelBuilder uIPanelBuilder = pb.margins(0, 0).row(rb -> {
                UIRowBuilder uIRowBuilder = rb.group("Extraction", this.buildExtractionPanel());
            });
        });
        if (((DataTransferWizard)this.getWizard()).getCurrentTask() != null) {
            Composite buttonsPanel = UIUtils.createComposite((Composite)composite, (int)1);
            ((DataTransferWizard)this.getWizard()).createVariablesEditButton(buttonsPanel);
        }
        this.setControl((Control)composite);
    }

    @NotNull
    private Consumer<UIPanelBuilder> buildExtractionPanel() {
        boolean canExportFetchedOnly = this.canExportFetchedRows();
        if (canExportFetchedOnly) {
            return this.buildQueryDatabaseOrUseFetchedRowsPanel();
        }
        return this.buildQueryDatabaseOnlyPanel();
    }

    @NotNull
    private Consumer<UIPanelBuilder> buildQueryDatabaseOnlyPanel() {
        UIObservable useFetchedData = UIObservable.of((boolean)true);
        return pb -> {
            UIPanelBuilder uIPanelBuilder = pb.row(rb -> {
                UIRowBuilder uIRowBuilder = rb.panel(this.buildQueryDatabasePanel((UIObservable<Boolean>)useFetchedData));
            }).row(this.buildAdvancedRow((UIObservable<Boolean>)useFetchedData));
        };
    }

    @NotNull
    private Consumer<UIPanelBuilder> buildQueryDatabaseOrUseFetchedRowsPanel() {
        UIObservable queryDatabase = UIObservables.equals(this.strategy, (Object)((Object)Strategy.QUERY_DATABASE));
        UIObservable useFetchedData = UIObservables.equals(this.strategy, (Object)((Object)Strategy.USE_FETCHED_ROWS));
        return pb -> {
            UIPanelBuilder uIPanelBuilder = pb.row(rb -> {
                UIRowBuilder uIRowBuilder = rb.radioButton("Query the database", bb -> {
                    UIControlBuilder.ButtonBuilder buttonBuilder = bb.selected(queryDatabase);
                }).radioButton("Use fetched rows", bb -> {
                    UIControlBuilder.ButtonBuilder buttonBuilder = bb.selected(useFetchedData);
                });
            }).row(rb -> {
                UIRowBuilder uIRowBuilder = rb.panel(this.buildQueryDatabasePanel((UIObservable<Boolean>)queryDatabase)).panel(this.buildUseFetchedRowsPanel((UIObservable<Boolean>)useFetchedData));
            }).row(this.buildAdvancedRow((UIObservable<Boolean>)queryDatabase));
        };
    }

    @NotNull
    private Consumer<UIPanelBuilder> buildQueryDatabasePanel(@NotNull UIObservable<Boolean> enabled) {
        return pb -> {
            UIPanelBuilder uIPanelBuilder = pb.row(rb -> {
                UIRowBuilder uIRowBuilder = rb.enabled(enabled).checkBox(DTMessages.data_transfer_wizard_output_checkbox_new_connection, bb -> {
                    UIControlBuilder.ButtonBuilder buttonBuilder = ((UIControlBuilder.ButtonBuilder)bb.tooltip(DTUIMessages.database_producer_page_extract_settings_new_connection_checkbox_tooltip)).selected(this.openNewConnections);
                });
            }).row(rb -> {
                UIRowBuilder uIRowBuilder = rb.enabled(enabled).checkBox(DTMessages.data_transfer_wizard_output_checkbox_select_row_count, bb -> {
                    UIControlBuilder.ButtonBuilder buttonBuilder = ((UIControlBuilder.ButtonBuilder)bb.tooltip(DTUIMessages.database_producer_page_extract_settings_row_count_checkbox_tooltip)).selected(this.fetchRowCount);
                });
            });
        };
    }

    @NotNull
    private Consumer<UIPanelBuilder> buildUseFetchedRowsPanel(@NotNull UIObservable<Boolean> enabled) {
        UIObservable canExportSelection = UIObservable.of((this.hasSelection() && this.canExportColumns() ? 1 : 0) != 0);
        return pb -> {
            UIPanelBuilder uIPanelBuilder = pb.row(rb -> {
                UIRowBuilder uIRowBuilder = rb.enabled(UIObservables.and((UIObservable)enabled, (UIObservable)canExportSelection)).checkBox("Selected rows only", bb -> {
                    UIControlBuilder.ButtonBuilder buttonBuilder = bb.selected(this.selectedRowsOnly);
                });
            }).row(rb -> {
                UIRowBuilder uIRowBuilder = rb.enabled(UIObservables.and((UIObservable)enabled, (UIObservable)canExportSelection)).checkBox("Selected columns only", bb -> {
                    UIControlBuilder.ButtonBuilder buttonBuilder = bb.selected(this.selectedColumnsOnly);
                });
            });
        };
    }

    @NotNull
    private Consumer<UIRowBuilder> buildAdvancedRow(@NotNull UIObservable<Boolean> queryDatabase) {
        return rb -> {
            UIRowBuilder uIRowBuilder = rb.expandableGroup("Advanced", false, pb -> {
                UIControlBuilder uIControlBuilder = ((UIPanelBuilder)((UIPanelBuilder)pb.align(UIAlignX.FILL)).grow()).accept(this.buildAdvancedPanel(queryDatabase));
            });
        };
    }

    @NotNull
    private Consumer<UIPanelBuilder> buildAdvancedPanel(@NotNull UIObservable<Boolean> queryDatabase) {
        UIObservable canChangeThreads = UIObservable.predicate(() -> ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().size() > 2);
        UIObservable canChangeSegment = UIObservable.predicate(() -> this.extractType.get() == DatabaseProducerSettings.ExtractType.SEGMENTS);
        return pb -> {
            UIPanelBuilder uIPanelBuilder = pb.row(DTMessages.data_transfer_wizard_output_label_max_threads, rb -> {
                UIRowBuilder uIRowBuilder = rb.enabled(UIObservables.and((UIObservable)queryDatabase, (UIObservable)canChangeThreads)).intTextField(this.threadCount, tb -> {
                    UIControlBuilder uIControlBuilder = tb.tooltip(DTUIMessages.database_producer_page_extract_settings_threads_num_text_tooltip);
                });
            }).row(DTUIMessages.database_producer_page_extract_settings_text_fetch_size_label, rb -> {
                UIRowBuilder uIRowBuilder = rb.enabled(queryDatabase).intTextField(this.fetchSize, tb -> {
                    UIControlBuilder uIControlBuilder = tb.tooltip(DTUIMessages.database_producer_page_extract_settings_text_fetch_size_tooltip);
                });
            }).row(DTMessages.data_transfer_wizard_output_label_extract_type, rb -> {
                UIRowBuilder uIRowBuilder = rb.enabled(queryDatabase).comboBox(this.extractType, DatabaseProducerPageExtractSettings::getExtractTypeLabel);
            }).row(DTMessages.data_transfer_wizard_output_label_segment_size, rb -> {
                UIRowBuilder uIRowBuilder = rb.enabled(UIObservables.and((UIObservable)queryDatabase, (UIObservable)canChangeSegment)).intTextField(this.segmentSize);
            });
        };
    }

    public void activatePage() {
        ((DataTransferWizard)this.getWizard()).loadNodeSettings();
        DatabaseProducerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseProducerSettings.class);
        this.openNewConnections.set((Object)settings.isOpenNewConnections());
        this.fetchRowCount.set((Object)settings.isQueryRowCount());
        DatabaseProducerSettings.FetchedRowsPolicy useFetchedRows = settings.getFetchedRowsPolicy();
        this.strategy.set((Object)(useFetchedRows != null ? Strategy.USE_FETCHED_ROWS : Strategy.QUERY_DATABASE));
        this.selectedRowsOnly.set((Object)(useFetchedRows != null && useFetchedRows.selectedRowsOnly() ? 1 : 0));
        this.selectedColumnsOnly.set((Object)(useFetchedRows != null && useFetchedRows.selectedColumnsOnly() ? 1 : 0));
        this.fetchSize.set((Object)settings.getFetchSize());
        this.threadCount.set((Object)((DataTransferWizard)this.getWizard()).getSettings().getMaxJobCount());
        this.segmentSize.set((Object)settings.getSegmentSize());
        this.extractType.set((Object)settings.getExtractType());
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        DatabaseProducerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseProducerSettings.class);
        settings.setOpenNewConnections(((Boolean)this.openNewConnections.get()).booleanValue());
        settings.setQueryRowCount(((Boolean)this.fetchRowCount.get()).booleanValue());
        if (this.strategy.get() == Strategy.USE_FETCHED_ROWS && this.canExportFetchedRows()) {
            boolean canExportSelection = this.hasSelection() && this.canExportColumns();
            settings.setFetchedRowsPolicy(new DatabaseProducerSettings.FetchedRowsPolicy(canExportSelection && (Boolean)this.selectedRowsOnly.get() != false, canExportSelection && (Boolean)this.selectedColumnsOnly.get() != false));
        } else {
            settings.setFetchedRowsPolicy(null);
        }
        settings.setFetchSize(((Integer)this.fetchSize.get()).intValue());
        ((DataTransferWizard)this.getWizard()).getSettings().setMaxJobCount(((Integer)this.threadCount.get()).intValue());
        settings.setSegmentSize(((Integer)this.segmentSize.get()).intValue());
        settings.setExtractType((DatabaseProducerSettings.ExtractType)this.extractType.get());
    }

    public boolean isPageApplicable() {
        return this.isProducerOfType(DatabaseTransferProducer.class);
    }

    @NotNull
    private static String getExtractTypeLabel(@NotNull DatabaseProducerSettings.ExtractType type) {
        return switch (type) {
            case DatabaseProducerSettings.ExtractType.SINGLE_QUERY -> DTMessages.data_transfer_wizard_output_combo_extract_type_item_single_query;
            case DatabaseProducerSettings.ExtractType.SEGMENTS -> DTMessages.data_transfer_wizard_output_combo_extract_type_item_by_segments;
            default -> throw new MatchException(null, null);
        };
    }

    private boolean hasSelection() {
        IStructuredSelection selection = ((DataTransferWizard)this.getWizard()).getCurrentSelection();
        return selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof DBDCellValue;
    }

    private boolean canExportColumns() {
        List objects = ((DataTransferWizard)this.getWizard()).getSettings().getSourceObjects();
        for (DBSObject object : objects) {
            DBSDataContainer container = (DBSDataContainer)GeneralUtils.adapt((Object)object, DBSDataContainer.class);
            if (container instanceof DBSDocumentContainer) {
                return false;
            }
            if (container == null || !container.getDataSource().getInfo().isDynamicMetadata()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean canExportFetchedRows() {
        for (DBSObject object : ((DataTransferWizard)this.getWizard()).getSettings().getSourceObjects()) {
            void container;
            if (!(object instanceof DBSDataContainer)) {
                return false;
            }
            DBSDataContainer dBSDataContainer = (DBSDataContainer)object;
            if (container.isFeatureSupported("data.read.fetched")) continue;
            return false;
        }
        return true;
    }

    private static enum Strategy {
        QUERY_DATABASE,
        USE_FETCHED_ROWS;

    }
}

