/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.DeclarationCondition;
import io.sf.carte.doc.style.css.nsac.InputSource;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorFunction;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSCanvas;
import io.sf.carte.doc.style.css.om.AbstractStyleDatabase;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.Specificity;
import io.sf.carte.doc.style.css.parser.AttributeConditionVisitor;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.CSSSecurityException;
import io.sf.carte.echosvg.css.engine.CSSCircularityException;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngineEvent;
import io.sf.carte.echosvg.css.engine.CSSEngineListener;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSNavigableDocument;
import io.sf.carte.echosvg.css.engine.CSSNavigableDocumentListener;
import io.sf.carte.echosvg.css.engine.CSSNavigableNode;
import io.sf.carte.echosvg.css.engine.CSSResourceLimitException;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.CSSStyleSheetNode;
import io.sf.carte.echosvg.css.engine.CounterRef;
import io.sf.carte.echosvg.css.engine.DeclarationsRule;
import io.sf.carte.echosvg.css.engine.FontFaceRule;
import io.sf.carte.echosvg.css.engine.ImportRule;
import io.sf.carte.echosvg.css.engine.MediaGroup;
import io.sf.carte.echosvg.css.engine.MediaRule;
import io.sf.carte.echosvg.css.engine.Messages;
import io.sf.carte.echosvg.css.engine.NestedDeclarations;
import io.sf.carte.echosvg.css.engine.PropertyDefinitionImpl;
import io.sf.carte.echosvg.css.engine.Rule;
import io.sf.carte.echosvg.css.engine.RuleGroup;
import io.sf.carte.echosvg.css.engine.SVGSelectorMatcher;
import io.sf.carte.echosvg.css.engine.StringIntMap;
import io.sf.carte.echosvg.css.engine.StyleDeclaration;
import io.sf.carte.echosvg.css.engine.StyleDeclarationProvider;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.StyleRule;
import io.sf.carte.echosvg.css.engine.StyleSheet;
import io.sf.carte.echosvg.css.engine.SupportsRule;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.ComputedValue;
import io.sf.carte.echosvg.css.engine.value.InheritValue;
import io.sf.carte.echosvg.css.engine.value.LexicalValue;
import io.sf.carte.echosvg.css.engine.value.PendingValue;
import io.sf.carte.echosvg.css.engine.value.PropertyDefinition;
import io.sf.carte.echosvg.css.engine.value.ShorthandManager;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected CSSEngineUserAgent userAgent;
    protected CSSContext cssContext;
    private EngineStyleDatabase styleDb;
    private CSSCanvas csscanvas;
    protected Document document;
    protected ParsedURL documentURI;
    protected boolean isCSSNavigableDocument;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected Parser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    private String medium;
    protected List<Node> styleSheetNodes;
    protected List<FontFaceRule> fontFaces = new LinkedList<FontFaceRule>();
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set<String> nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected ParsedURL cssBaseURI;
    protected String alternateStyleSheet;
    protected CSSNavigableDocumentHandler cssNavigableDocumentListener;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List<CSSEngineListener> listeners = Collections.synchronizedList(new LinkedList());
    protected Set<String> selectorAttributes;
    private HashMap<String, PropertyDefinition> propertyDefinitionMap = null;
    private static final int INITIAL_CUSTOM_PTY_SET_SIZE = 1;
    protected final int[] ALL_PROPERTIES;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public static Node getCSSParentNode(Node n) {
        if (n instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)n)).getCSSParentNode();
        }
        return n.getParentNode();
    }

    protected static Node getCSSFirstChild(Node n) {
        if (n instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)n)).getCSSFirstChild();
        }
        return n.getFirstChild();
    }

    protected static Node getCSSNextSibling(Node n) {
        if (n instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)n)).getCSSNextSibling();
        }
        return n.getNextSibling();
    }

    protected static Node getCSSPreviousSibling(Node n) {
        if (n instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)n)).getCSSPreviousSibling();
        }
        return n.getPreviousSibling();
    }

    public static CSSStylableElement getParentCSSStylableElement(Element elt) {
        Node n = CSSEngine.getCSSParentNode(elt);
        while (n != null) {
            if (n instanceof CSSStylableElement) {
                return (CSSStylableElement)n;
            }
            n = CSSEngine.getCSSParentNode(n);
        }
        return null;
    }

    protected CSSEngine(Document doc, ParsedURL uri, Parser p, ValueManager[] vm, ShorthandManager[] sm, String[] pe, String sns, String sln, String cns, String cln, boolean hints, String hintsNS, CSSContext ctx) {
        String pn;
        int i;
        this.document = doc;
        this.documentURI = uri;
        this.parser = p;
        this.pseudoElementNames = pe;
        this.styleNamespaceURI = sns;
        this.styleLocalName = sln;
        this.classNamespaceURI = cns;
        this.classLocalName = cln;
        this.cssContext = ctx;
        this.styleDb = new EngineStyleDatabase();
        this.csscanvas = new EngineCSSCanvas();
        this.isCSSNavigableDocument = doc instanceof CSSNavigableDocument;
        int len = vm.length;
        this.indexes = new StringIntMap(len);
        this.valueManagers = vm;
        for (i = len - 1; i >= 0; --i) {
            pn = vm[i].getPropertyName();
            this.indexes.put(pn, i);
            if (this.fontSizeIndex == -1 && pn.equals("font-size")) {
                this.fontSizeIndex = i;
            }
            if (this.lineHeightIndex == -1 && pn.equals("line-height")) {
                this.lineHeightIndex = i;
            }
            if (this.colorIndex != -1 || !pn.equals("color")) continue;
            this.colorIndex = i;
        }
        len = sm.length;
        this.shorthandIndexes = new StringIntMap(len);
        this.shorthandManagers = sm;
        for (i = len - 1; i >= 0; --i) {
            this.shorthandIndexes.put(sm[i].getPropertyName(), i);
        }
        if (hints) {
            this.nonCSSPresentationalHints = new HashSet<String>(vm.length + sm.length);
            this.nonCSSPresentationalHintsNamespaceURI = hintsNS;
            len = vm.length;
            for (i = 0; i < len; ++i) {
                pn = vm[i].getPropertyName();
                this.nonCSSPresentationalHints.add(pn);
            }
            len = sm.length;
            for (i = 0; i < len; ++i) {
                pn = sm[i].getPropertyName();
                this.nonCSSPresentationalHints.add(pn);
            }
        }
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            this.addEventListeners((EventTarget)((Object)this.document));
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        for (i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            this.ALL_PROPERTIES[i] = i;
        }
    }

    protected void addEventListeners(EventTarget doc) {
        if (this.isCSSNavigableDocument) {
            this.cssNavigableDocumentListener = new CSSNavigableDocumentHandler();
            CSSNavigableDocument cnd = (CSSNavigableDocument)((Object)doc);
            cnd.addCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            doc.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            doc.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            doc.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            doc.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            doc.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    protected void removeEventListeners(EventTarget doc) {
        if (this.isCSSNavigableDocument) {
            CSSNavigableDocument cnd = (CSSNavigableDocument)((Object)doc);
            cnd.removeCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            doc.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            doc.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            doc.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            doc.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            doc.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    public void dispose() {
        this.setCSSEngineUserAgent(null);
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            this.removeEventListeners((EventTarget)((Object)this.document));
        }
    }

    protected void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        Node n = CSSEngine.getCSSFirstChild(node);
        while (n != null) {
            if (n.getNodeType() == 1) {
                this.disposeStyleMaps(n);
            }
            n = CSSEngine.getCSSNextSibling(n);
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String name) {
        return this.indexes.get(name);
    }

    public int getShorthandIndex(String name) {
        return this.shorthandIndexes.get(name);
    }

    public String getPropertyName(int idx) {
        return this.valueManagers[idx].getPropertyName();
    }

    public void setCSSEngineUserAgent(CSSEngineUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public CSSEngineUserAgent getCSSEngineUserAgent() {
        return this.userAgent;
    }

    public void setUserAgentStyleSheet(StyleSheet ss) {
        this.userAgentStyleSheet = ss;
    }

    public void setUserStyleSheet(StyleSheet ss) {
        this.userStyleSheet = ss;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public ShorthandManager[] getShorthandManagers() {
        return this.shorthandManagers;
    }

    public List<FontFaceRule> getFontFaces() {
        return this.fontFaces;
    }

    public void setMedia(String str) {
        this.medium = str != null ? str.toLowerCase(Locale.ROOT) : null;
    }

    public void setAlternateStyleSheet(String str) {
        this.alternateStyleSheet = str;
    }

    public void importCascadedStyleMaps(Element src, CSSEngine srceng, Element dest) {
        if (src instanceof CSSStylableElement) {
            CSSStylableElement csrc = (CSSStylableElement)src;
            CSSStylableElement cdest = (CSSStylableElement)dest;
            StyleMap sm = srceng.getCascadedStyleMap(csrc, null);
            sm.setFixedCascadedStyle(true);
            cdest.setComputedStyleMap(null, sm);
            if (this.pseudoElementNames != null) {
                for (String pe : this.pseudoElementNames) {
                    sm = srceng.getCascadedStyleMap(csrc, pe);
                    cdest.setComputedStyleMap(pe, sm);
                }
            }
        }
        Node dn = CSSEngine.getCSSFirstChild(dest);
        Node sn = CSSEngine.getCSSFirstChild(src);
        while (dn != null) {
            if (sn.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)sn, srceng, (Element)dn);
            }
            dn = CSSEngine.getCSSNextSibling(dn);
            sn = CSSEngine.getCSSNextSibling(sn);
        }
    }

    public ParsedURL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap getCascadedStyleMap(CSSStylableElement elt, String pseudo) {
        ArrayList<Rule> rules;
        int props = this.getNumberOfProperties();
        final StyleMap result = new StyleMap(props);
        SVGSelectorMatcher matcher = new SVGSelectorMatcher(elt);
        if (pseudo != null) {
            Parser parser = this.createCSSParser();
            Condition pseCond = parser.parsePseudoElement(pseudo);
            matcher.setPseudoElement(pseCond);
        }
        if (this.userAgentStyleSheet != null) {
            rules = new ArrayList<Rule>();
            this.addMatchingRules(rules, this.userAgentStyleSheet, (SelectorMatcher)matcher);
            this.addRules((SelectorMatcher)matcher, result, rules, 0);
        }
        if (this.userStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userStyleSheet, (SelectorMatcher)matcher);
            this.addRules((SelectorMatcher)matcher, result, rules, 0x20000000);
        }
        this.element = elt;
        try {
            StyleDeclaration over;
            StyleDeclarationProvider p;
            String style;
            CSSEngine eng;
            List<Node> snodes;
            int slen;
            if (this.nonCSSPresentationalHints != null) {
                ShorthandManager.PropertyHandler ph = new ShorthandManager.PropertyHandler(){

                    @Override
                    public void property(String pname, LexicalUnit lu, boolean important) {
                        int idx = CSSEngine.this.getPropertyIndex(pname);
                        if (idx != -1) {
                            Value v;
                            ValueManager vm = CSSEngine.this.valueManagers[idx];
                            try {
                                v = vm.createValue(lu, CSSEngine.this);
                            }
                            catch (CSSProxyValueException e) {
                                v = new LexicalValue(lu);
                            }
                            CSSEngine.this.putAuthorProperty(result, idx, v, important, 0x40000000);
                            return;
                        }
                        idx = CSSEngine.this.getShorthandIndex(pname);
                        if (idx == -1) {
                            return;
                        }
                        CSSEngine.this.shorthandManagers[idx].setValues(CSSEngine.this, this, lu, important);
                    }

                    @Override
                    public void pendingValue(String pname, PendingValue v, boolean important) {
                        int idx = CSSEngine.this.getPropertyIndex(pname);
                        if (idx != -1) {
                            CSSEngine.this.putAuthorProperty(result, idx, v, important, 0x40000000);
                        }
                    }
                };
                NamedNodeMap attrs = elt.getAttributes();
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    Node attr = attrs.item(i);
                    String an = attr.getNodeName();
                    if (!this.nonCSSPresentationalHints.contains(an)) continue;
                    String av = attr.getNodeValue();
                    if (!av.isEmpty()) {
                        try {
                            LexicalUnit lu = this.parser.parsePropertyValue((Reader)new StringReader(av));
                            ph.property(an, lu, false);
                        }
                        catch (Exception e) {
                            String m = e.getMessage();
                            if (m == null) {
                                m = "";
                            }
                            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, an, attr.getNodeValue(), m});
                            DOMException de = new DOMException(12, s);
                            de.initCause(e);
                            if (this.userAgent == null) {
                                throw de;
                            }
                            this.userAgent.displayError(de);
                        }
                        continue;
                    }
                    if (this.userAgent == null) continue;
                    this.userAgent.warn("Empty attribute: " + an);
                }
            }
            if ((slen = (snodes = (eng = this.cssContext.getCSSEngineForElement(elt)).getStyleSheetNodes()).size()) > 0) {
                ArrayList<Rule> rules2 = new ArrayList<Rule>();
                for (Node snode : snodes) {
                    CSSStyleSheetNode ssn = (CSSStyleSheetNode)((Object)snode);
                    StyleSheet ss = ssn.getCSSStyleSheet();
                    if (ss == null || ss.isAlternate() && ss.getTitle() != null && !ss.getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(ss.getMedia())) continue;
                    this.addMatchingRules(rules2, ss, (SelectorMatcher)matcher);
                }
                this.addRules((SelectorMatcher)matcher, result, rules2, 0x60000000);
            }
            if (this.styleLocalName != null && (style = elt.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
                try {
                    this.styleDeclarationDocumentHandler.styleMap = result;
                    this.parser.setDocumentHandler((CSSHandler)this.styleDeclarationDocumentHandler);
                    this.parser.parseStyleDeclaration((Reader)new StringReader(style));
                    this.styleDeclarationDocumentHandler.styleMap = null;
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m == null) {
                        m = e.getClass().getName();
                    }
                    String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String s = Messages.formatMessage("style.syntax.error.at", new Object[]{u, this.styleLocalName, style, m});
                    DOMException de = new DOMException(12, s);
                    de.initCause(e);
                    if (this.userAgent == null) {
                        throw de;
                    }
                    this.userAgent.displayError(de);
                }
            }
            if ((p = elt.getOverrideStyleDeclarationProvider()) != null && (over = p.getStyleDeclaration()) != null) {
                int ol = over.size();
                for (int i = 0; i < ol; ++i) {
                    int idx = over.getIndex(i);
                    Value value = over.getValue(i);
                    boolean important = over.getPriority(i);
                    if (result.isImportant(idx) && !important) continue;
                    result.putValue(idx, value);
                    result.putImportant(idx, important);
                    result.putOrigin(idx, -1610612736);
                }
                Map<String, LexicalUnit> customProp = over.getCustomProperties();
                if (customProp != null) {
                    for (Map.Entry<String, LexicalUnit> entry : customProp.entrySet()) {
                        result.putCustomProperty(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return result;
    }

    private Parser createCSSParser() {
        CSSOMParser parser = new CSSOMParser();
        parser.setFlag(Parser.Flag.VALUE_COMMENTS_IGNORE);
        return parser;
    }

    public Value getComputedStyle(CSSStylableElement elt, String pseudo, int propidx) throws CSSSecurityException {
        StyleMap sm = elt.getComputedStyleMap(pseudo);
        if (sm == null) {
            sm = this.getCascadedStyleMap(elt, pseudo);
            elt.setComputedStyleMap(pseudo, sm);
        }
        Value value = sm.getValue(propidx);
        if (sm.isComputed(propidx)) {
            return value;
        }
        Value result = value;
        ValueManager vm = this.valueManagers[propidx];
        CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
        if (value == null) {
            if (p == null || !vm.isInheritedProperty()) {
                result = vm.getDefaultValue();
            }
        } else if (value.getPrimitiveType() == CSSValue.Type.LEXICAL) {
            LexicalValue var = (LexicalValue)value;
            LexicalUnit lunit = this.replaceLexicalValue(sm, var.getLexicalUnit(), elt, p, propidx);
            if (lunit != null) {
                result = vm.createValue(lunit, this);
                if (result == null || result.getCssValueType() == CSSValue.CssType.KEYWORD) {
                    result = CSSEngine.initialOrNull(p != null, vm, result);
                }
            } else {
                result = CSSEngine.initialOrNull(p != null, vm, null);
            }
        } else if (value.getPrimitiveType() == CSSValue.Type.INTERNAL) {
            PendingValue pending = (PendingValue)value;
            result = this.substitutePendingShorthand(sm, pending, elt, p, propidx) ? sm.getValue(propidx) : CSSEngine.initialOrNull(p != null, vm, null);
        } else if (value.getCssValueType() == CSSValue.CssType.KEYWORD) {
            result = CSSEngine.initialOrNull(p != null, vm, value);
        }
        if (result != null && (result = vm.computeValue(elt, pseudo, this, propidx, sm, result)) == null) {
            result = CSSEngine.initialOrNull(p != null, vm, null);
        }
        if (result == null) {
            result = this.getComputedStyle(p, null, propidx);
            sm.putParentRelative(propidx, true);
            sm.putInherited(propidx, true);
        }
        if (value == null) {
            sm.putValue(propidx, result);
            sm.putNullCascaded(propidx, true);
        } else if (result != value) {
            ComputedValue cv = new ComputedValue(value);
            cv.setComputedValue(result);
            sm.putValue(propidx, cv);
            result = cv;
        }
        sm.putComputed(propidx, true);
        return result;
    }

    private static Value initialOrNull(boolean hasParent, ValueManager vm, Value value) {
        Value result = hasParent && (vm.isInheritedProperty() || value == InheritValue.getInstance()) ? null : vm.getDefaultValue();
        return result;
    }

    private LexicalUnit replaceLexicalValue(StyleMap sm, LexicalUnit lexicalUnit, CSSStylableElement elt, CSSStylableElement parent, int propIdx) throws CSSSecurityException {
        LexicalUnit replUnit;
        HashSet<String> customPropertySet = new HashSet<String>(1);
        CounterRef counter = new CounterRef();
        LexicalUnit lunit = lexicalUnit.clone();
        try {
            replUnit = this.replaceLexicalProxy(sm, lunit, elt, parent, counter, customPropertySet, propIdx);
        }
        catch (CSSSecurityException e) {
            throw e;
        }
        catch (DOMException e) {
            this.displayOrThrowError(e);
            return null;
        }
        if (replUnit != null && replUnit.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            replUnit = null;
        }
        return replUnit;
    }

    private LexicalUnit replaceLexicalProxy(StyleMap sm, LexicalUnit lexval, CSSStylableElement elt, CSSStylableElement parent, CounterRef counter, Set<String> customPtySet, int propIdx) throws DOMException, CSSSecurityException {
        int REPLACE_COUNT_LIMIT = 131072;
        LexicalUnit lu = lexval;
        block4: do {
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                boolean isLexval;
                sm.putCustomPtyRelative(propIdx, true);
                LexicalUnit param = lu.getParameters();
                String propertyName = param.getStringValue();
                param = param.getNextLexicalUnit();
                if (param != null) {
                    param = param.getNextLexicalUnit();
                }
                HashSet<String> ptySet = new HashSet<String>(customPtySet.size() + 1);
                ptySet.addAll(customPtySet);
                LexicalUnit newlu = this.getCustomPropertyValueOrFallback(sm, propertyName, param, parent, counter, ptySet);
                if (newlu != null) {
                    newlu = newlu.clone();
                    newlu = this.replaceLexicalProxy(sm, newlu, elt, parent, counter, ptySet, propIdx);
                }
                boolean bl = isLexval = lu == lexval;
                if (newlu == null) {
                    lu = lu.remove();
                    if (isLexval) {
                        lexval = lu;
                    }
                    ptySet.remove(propertyName);
                    continue;
                }
                if (newlu.getLexicalUnitType() != LexicalUnit.LexicalType.EMPTY) {
                    try {
                        counter.replaceCounter += lu.countReplaceBy(newlu);
                    }
                    catch (CSSBudgetException e) {
                        throw this.createVarResourceLimitException(propertyName, e);
                    }
                    if (counter.replaceCounter >= 131072) {
                        throw this.createVarResourceLimitException(propertyName);
                    }
                    lu = newlu;
                    if (!isLexval) continue;
                    lexval = newlu;
                    continue;
                }
                LexicalUnit nextlu = lu.remove();
                lu = nextlu != null ? nextlu : newlu;
                if (isLexval) {
                    lexval = lu;
                }
                ptySet.remove(propertyName);
                continue;
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.ATTR) {
                boolean isLexval = lu == lexval;
                HashSet<String> ptySet = new HashSet<String>(customPtySet.size() + 1);
                ptySet.addAll(customPtySet);
                LexicalUnit newlu = this.replacementAttrUnit(sm, lu, elt, parent, counter, ptySet, propIdx);
                if (newlu != null) {
                    newlu = this.replaceLexicalProxy(sm, newlu, elt, parent, counter, ptySet, propIdx);
                }
                if (newlu == null) {
                    lu = lu.remove();
                    if (!isLexval) continue;
                    lexval = lu;
                    continue;
                }
                sm.putAttrTainted(propIdx, true);
                while (newlu.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
                    LexicalUnit nextlu = newlu.remove();
                    if (nextlu == null) {
                        if ((lu = lu.remove()) == null) {
                            lu = newlu;
                        }
                        if (!isLexval) continue block4;
                        lexval = lu;
                        continue block4;
                    }
                    newlu = nextlu;
                }
                try {
                    counter.replaceCounter += lu.countReplaceBy(newlu);
                }
                catch (CSSBudgetException e) {
                    throw this.createAttrResourceLimitException(e);
                }
                if (counter.replaceCounter >= 131072) {
                    throw this.createAttrResourceLimitException();
                }
                lu = newlu;
                if (!isLexval) continue;
                lexval = newlu;
                continue;
            }
            LexicalUnit param = lu.getParameters();
            if (param != null || (param = lu.getSubValues()) != null) {
                this.replaceLexicalProxy(sm, param, elt, parent, counter, customPtySet, propIdx);
            }
            lu = lu.getNextLexicalUnit();
        } while (lu != null);
        return lexval;
    }

    private LexicalUnit replacementAttrUnit(StyleMap sm, LexicalUnit attr, CSSStylableElement elt, CSSStylableElement parent, CounterRef counter, Set<String> checkSet, int propIdx) {
        Attr attrNode;
        LexicalUnit lu = attr.getParameters();
        if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
            this.valueSyntaxError("Unexpected attribute name (" + lu.getCssText() + ") in " + attr.getCssText());
            return null;
        }
        String attrname = lu.getStringValue();
        if (!checkSet.add(attrname)) {
            throw new CSSCircularityException("Circularity evaluating attr() '" + attrname + "': " + checkSet.toString());
        }
        CSSValueSyntax syn = null;
        short unitConv = -1;
        if ((lu = lu.getNextLexicalUnit()) != null) {
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                switch (lu.getLexicalUnitType()) {
                    case IDENT: {
                        String attrtype = lu.getStringValue().toLowerCase(Locale.ROOT);
                        if ("raw-string".equals(attrtype) || (unitConv = (short)UnitStringToId.unitFromString((String)attrtype)) != 1) break;
                        this.valueSyntaxError("Unexpected attribute type (" + lu.getCssText() + ") in " + attr.getCssText());
                        return null;
                    }
                    case OPERATOR_MOD: {
                        unitConv = 2;
                        break;
                    }
                    case TYPE_FUNCTION: {
                        LexicalUnit param = lu.getParameters();
                        if (param.getLexicalUnitType() == LexicalUnit.LexicalType.SYNTAX) {
                            syn = param.getSyntax();
                            unitConv = 0;
                            break;
                        }
                    }
                    default: {
                        this.valueSyntaxError("Unexpected attribute type (" + lu.getCssText() + ") in " + attr.getCssText());
                        return lu == null ? null : lu.clone();
                    }
                }
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.valueSyntaxError("Expected comma, found: " + lu.getCssText() + " in " + attr.getCssText());
                        return null;
                    }
                    lu = lu.getNextLexicalUnit();
                }
            } else if ((lu = lu.getNextLexicalUnit()) == null) {
                this.valueSyntaxError("Unexpected end after comma in value " + attr.getCssText());
                return null;
            }
        }
        String attrvalue = (attrNode = elt.getAttributeNode(attrname)) != null ? attrNode.getValue() : "";
        Parser parser = this.createCSSParser();
        if (unitConv == -1) {
            LexicalUnit substValue;
            block39: {
                if (attrNode != null || lu == null) {
                    String s = ParseHelper.quote((String)attrvalue, (char)'\"');
                    try {
                        substValue = parser.parsePropertyValue((Reader)new StringReader(s));
                    }
                    catch (IOException e) {
                        substValue = null;
                    }
                    catch (CSSParseException e) {
                        this.valueSyntaxError("Unexpected error parsing: " + s.substring(0, Math.min(s.length(), 255)), e);
                        if (lu != null) {
                            substValue = lu.clone();
                            break block39;
                        }
                        try {
                            substValue = parser.parsePropertyValue((Reader)new StringReader("\"\""));
                        }
                        catch (CSSParseException | IOException e1) {
                            substValue = null;
                        }
                    }
                } else {
                    substValue = lu.clone();
                }
            }
            return substValue;
        }
        if (!(attrvalue = attrvalue.trim()).isEmpty()) {
            LexicalUnit substValue;
            try {
                substValue = parser.parsePropertyValue((Reader)new StringReader(attrvalue));
            }
            catch (IOException e) {
                substValue = null;
            }
            catch (CSSParseException e) {
                this.valueSyntaxError("Error parsing attribute '" + attrname + "', value: " + attrvalue, e);
                if (lu != null) {
                    return lu.clone();
                }
                return null;
            }
            substValue = this.replaceLexicalProxy(sm, substValue, elt, parent, counter, checkSet, propIdx);
            if (substValue != null) {
                if (syn != null) {
                    if (substValue.matches(syn) == CSSValueSyntax.Match.TRUE) {
                        return substValue;
                    }
                    String message = "Attribute " + attrname + " with value '" + substValue + "' does not match type '" + syn.toString() + "'.";
                    if (lu == null) {
                        throw new DOMException(17, message);
                    }
                    this.valueSyntaxError(message);
                } else {
                    float f;
                    LexicalUnit.LexicalType luType = substValue.getLexicalUnitType();
                    if (luType == LexicalUnit.LexicalType.INTEGER) {
                        f = substValue.getIntegerValue();
                    } else if (luType == LexicalUnit.LexicalType.REAL) {
                        f = substValue.getFloatValue();
                    } else {
                        String message = "Attribute unit is not a <number>, instead is: " + CSSUnit.dimensionUnitString((short)substValue.getCssUnit());
                        if (lu != null) {
                            this.valueSyntaxError(message);
                            return lu.clone();
                        }
                        throw new DOMException(17, message);
                    }
                    if (unitConv != 0) {
                        substValue = ParseHelper.createDimensionLexicalUnit((short)unitConv, (float)f);
                    }
                    return substValue;
                }
            }
        }
        return lu == null ? null : lu.clone();
    }

    private LexicalUnit getCustomPropertyValueOrFallback(StyleMap sm, String customProperty, LexicalUnit fallbackLU, CSSStylableElement parent, CounterRef counter, Set<String> customPtySet) throws DOMException, CSSSecurityException {
        if (customPtySet.contains(customProperty)) {
            throw new CSSCircularityException("Circularity evaluating custom property " + customProperty + ": " + customPtySet.toString());
        }
        if (!counter.increment()) {
            throw this.createVarResourceLimitException(customProperty);
        }
        LexicalUnit custom = this.getCustomProperty(sm, customProperty, parent);
        if (custom != null) {
            customPtySet.add(customProperty);
            return custom;
        }
        return fallbackLU;
    }

    private LexicalUnit getCustomProperty(StyleMap sm, String name, CSSStylableElement parent) {
        LexicalUnit custom;
        boolean inherits;
        PropertyDefinition definition = this.getPropertyDefinition(name);
        boolean bl = inherits = definition == null || definition.inherits();
        while ((custom = sm.getCustomProperty(name)) == null && inherits && parent != null) {
            sm = parent.getComputedStyleMap(null);
            if (sm == null) {
                sm = this.getCascadedStyleMap(parent, null);
                parent.setComputedStyleMap(null, sm);
            }
            parent = CSSEngine.getParentCSSStylableElement(parent);
        }
        if (definition != null) {
            if (custom == null) {
                custom = definition.getInitialValue();
            } else {
                CSSValueSyntax syntax = definition.getSyntax();
                if (custom.matches(syntax) == CSSValueSyntax.Match.FALSE) {
                    custom = definition.getInitialValue();
                }
            }
        }
        return custom;
    }

    private PropertyDefinition getPropertyDefinition(String name) {
        return this.propertyDefinitionMap == null ? null : this.propertyDefinitionMap.get(name);
    }

    private boolean substitutePendingShorthand(StyleMap sm, PendingValue pending, CSSStylableElement elt, CSSStylableElement parent, int propIdx) throws DOMException, CSSSecurityException {
        LexicalUnit lunit = this.replaceLexicalProxy(sm, pending.getLexicalUnit().clone(), elt, parent, new CounterRef(), new HashSet<String>(1), propIdx);
        boolean ret = lunit != null ? this.setShorthandLonghands(sm, pending.getShorthandName(), lunit, sm.isImportant(propIdx)) : false;
        return ret;
    }

    private boolean setShorthandLonghands(final StyleMap sm, String propertyName, LexicalUnit value, boolean important) throws DOMException {
        try {
            int idx = this.getShorthandIndex(propertyName);
            if (idx == -1) {
                return false;
            }
            this.shorthandManagers[idx].setValues(this, new ShorthandManager.PropertyHandler(){

                @Override
                public void property(String pname, LexicalUnit value, boolean important) {
                    int idx = CSSEngine.this.getPropertyIndex(pname);
                    if (idx != -1) {
                        Value oldv = sm.getValue(idx);
                        if (oldv == null || oldv.getPrimitiveType() == CSSValue.Type.INTERNAL) {
                            ValueManager vm = CSSEngine.this.valueManagers[idx];
                            Value v = vm.createValue(value, CSSEngine.this);
                            sm.putValue(idx, v);
                        }
                    } else {
                        throw new IllegalStateException("Unknown pending value.");
                    }
                }

                @Override
                public void pendingValue(String name, PendingValue value, boolean important) {
                    throw new IllegalStateException("Cannot set pending values after replacement.");
                }
            }, value, important);
            return true;
        }
        catch (DOMException e) {
            DOMException ex = new DOMException(e.code, "Error setting shorthand " + propertyName);
            ex.initCause(e);
            this.displayOrThrowError(ex);
            return false;
        }
    }

    private void valueSyntaxError(String message) {
        DOMException ex = new DOMException(12, message);
        this.displayOrThrowError(ex);
    }

    private void valueSyntaxError(String message, Throwable cause) {
        DOMException ex = new DOMException(12, message);
        ex.initCause(cause);
        this.displayOrThrowError(ex);
    }

    private CSSResourceLimitException createVarResourceLimitException(String propertyName) {
        return this.createResourceLimitException("Resource limit hit while replacing custom property: " + propertyName);
    }

    private CSSResourceLimitException createVarResourceLimitException(String propertyName, Throwable cause) {
        return this.createResourceLimitException("Resource limit hit while replacing custom property " + propertyName, cause);
    }

    private CSSResourceLimitException createAttrResourceLimitException() {
        return this.createResourceLimitException("Resource limit hit while replacing attr() property.");
    }

    private CSSResourceLimitException createAttrResourceLimitException(Throwable e) {
        return this.createResourceLimitException("Resource limit hit while replacing attr() property.", e);
    }

    private CSSResourceLimitException createResourceLimitException(String message) {
        return new CSSResourceLimitException(message);
    }

    private CSSResourceLimitException createResourceLimitException(String message, Throwable e) {
        return new CSSResourceLimitException(message, e);
    }

    private void displayOrThrowError(RuntimeException ex) {
        if (this.userAgent == null) {
            throw ex;
        }
        this.userAgent.displayError(ex);
    }

    public List<Node> getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList<Node>();
            this.selectorAttributes = new HashSet<String>();
            AttributeVisitor visitor = new AttributeVisitor();
            this.findStyleSheetNodes(this.document);
            for (Node styleSheetNode : this.styleSheetNodes) {
                CSSStyleSheetNode ssn = (CSSStyleSheetNode)((Object)styleSheetNode);
                StyleSheet ss = ssn.getCSSStyleSheet();
                if (ss == null) continue;
                this.findSelectorAttributes(visitor, ss);
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node n) {
        if (n instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(n);
        }
        Node nd = CSSEngine.getCSSFirstChild(n);
        while (nd != null) {
            this.findStyleSheetNodes(nd);
            nd = CSSEngine.getCSSNextSibling(nd);
        }
    }

    private void findSelectorAttributes(AttributeVisitor visitor, RuleGroup ss) {
        int len = ss.getSize();
        block4: for (int i = 0; i < len; ++i) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 1: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getSelectorList();
                    visitor.visit(sl);
                    continue block4;
                }
                case 3: 
                case 4: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMedia())) continue block4;
                    this.findSelectorAttributes(visitor, mr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainProperties(CSSStylableElement elt, final MainPropertyReceiver dst, String pname, String value, boolean important) {
        try {
            this.element = elt;
            LexicalUnit lu = this.parser.parsePropertyValue((Reader)new StringReader(value));
            ShorthandManager.PropertyHandler ph = new ShorthandManager.PropertyHandler(){

                @Override
                public void property(String pname, LexicalUnit lu, boolean important) {
                    int idx = CSSEngine.this.getPropertyIndex(pname);
                    if (idx != -1) {
                        ValueManager vm = CSSEngine.this.valueManagers[idx];
                        Value v = vm.createValue(lu, CSSEngine.this);
                        dst.setMainProperty(pname, v, important);
                        return;
                    }
                    idx = CSSEngine.this.getShorthandIndex(pname);
                    if (idx == -1) {
                        return;
                    }
                    CSSEngine.this.shorthandManagers[idx].setValues(CSSEngine.this, this, lu, important);
                }

                @Override
                public void pendingValue(String name, PendingValue value, boolean important) {
                    dst.setMainProperty(name, value, important);
                }
            };
            ph.property(pname, lu, important);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, pname, value, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value parsePropertyValue(CSSStylableElement elt, String prop, String value) {
        int idx = this.getPropertyIndex(prop);
        if (idx == -1) {
            return null;
        }
        ValueManager vm = this.valueManagers[idx];
        try {
            this.element = elt;
            LexicalUnit lu = this.parser.parsePropertyValue((Reader)new StringReader(value));
            Value value2 = vm.createValue(lu, this);
            return value2;
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, prop, value, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return vm.getDefaultValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleDeclaration parseStyleDeclaration(CSSStylableElement elt, String value) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
        try {
            this.element = elt;
            this.parser.setDocumentHandler((CSSHandler)this.styleDeclarationBuilder);
            this.parser.parseStyleDeclaration((Reader)new StringReader(value));
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        finally {
            this.element = null;
            this.cssBaseURI = null;
        }
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    public StyleSheet parseStyleSheet(ParsedURL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMediaQueryList(media, null));
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return ss;
        }
        this.parseStyleSheet(ss, uri);
        return ss;
    }

    public StyleSheet parseStyleSheet(InputSource is, ParsedURL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMediaQueryList(media, null));
            this.parseStyleSheet((MediaGroup)ss, is, uri);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        return ss;
    }

    public void parseStyleSheet(MediaGroup ss, ParsedURL uri) throws DOMException {
        if (uri == null) {
            String s = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            DOMException de = new DOMException(12, s);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return;
        }
        try {
            this.cssContext.checkLoadExternalResource(uri, this.documentURI);
            this.parseStyleSheet(ss, new InputSource(uri.toString()), uri);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = e.getClass().getName();
            }
            String s = Messages.formatMessage("syntax.error.at", new Object[]{uri.toString(), m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
    }

    public StyleSheet parseStyleSheet(String rules, ParsedURL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMediaQueryList(media, null));
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s = Messages.formatMessage("syntax.error.at", new Object[]{u, m});
            DOMException de = new DOMException(12, s);
            de.initCause(e);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return ss;
        }
        this.parseStyleSheet((MediaGroup)ss, rules, uri);
        return ss;
    }

    public void parseStyleSheet(MediaGroup ss, String rules, ParsedURL uri) throws DOMException {
        try {
            this.parseStyleSheet(ss, new InputSource((Reader)new StringReader(rules)), uri);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (CSSParseException e) {
            StringBuilder buf;
            String m = e.getMessage();
            if (m != null) {
                buf = new StringBuilder(m.length() + 16);
                buf.append(m);
                buf.append(": ");
            } else {
                buf = new StringBuilder(40);
            }
            buf.append("([line,column] is relative to style sheet origin, not the document) [");
            buf.append(e.getLineNumber()).append(',').append(e.getColumnNumber()).append(']');
            this.reportError(rules, uri, (Exception)((Object)e), buf.toString());
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "";
            }
            this.reportError(rules, uri, e, m);
        }
    }

    private void reportError(String rules, ParsedURL uri, Exception cause, String message) {
        String strUri = uri != null ? uri.toString() : "";
        String s = Messages.formatMessage("stylesheet.syntax.error", new Object[]{strUri, rules, message});
        DOMException de = new DOMException(12, s);
        de.initCause(cause);
        if (this.userAgent == null) {
            throw de;
        }
        this.userAgent.displayError(de);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseStyleSheet(MediaGroup ss, InputSource is, ParsedURL uri) throws IOException {
        try {
            this.cssBaseURI = uri;
            this.styleSheetDocumentHandler.ruleGroup = ss;
            this.parser.setDocumentHandler((CSSHandler)this.styleSheetDocumentHandler);
            this.parser.parseStyleSheet(is);
            int len = ss.getSize();
            for (int i = 0; i < len; ++i) {
                Rule r = ss.getRule(i);
                if (r.getType() != 3) {
                    break;
                }
                ImportRule ir = (ImportRule)r;
                this.parseStyleSheet(ir, ir.getURI());
            }
        }
        finally {
            this.cssBaseURI = null;
        }
    }

    protected void putAuthorProperty(StyleMap dest, int idx, Value sval, boolean imp, int origin) {
        boolean cond;
        Value dval = dest.getValue(idx);
        int dorg = dest.getOrigin(idx);
        boolean dimp = dest.isImportant(idx);
        boolean bl = cond = dval == null;
        if (!cond) {
            switch (dorg) {
                case 0x20000000: {
                    cond = !dimp;
                    break;
                }
                case 0x60000000: {
                    cond = !dimp || imp;
                    break;
                }
                case -1610612736: {
                    cond = false;
                    break;
                }
                default: {
                    cond = true;
                }
            }
        }
        if (cond) {
            dest.putValue(idx, sval);
            dest.putImportant(idx, imp);
            dest.putOrigin(idx, origin);
        }
    }

    protected void addMatchingRules(List<Rule> rules, RuleGroup ss, SelectorMatcher matcher) {
        this.addMatchingRules(rules, ss, matcher, false);
    }

    private void addMatchingRules(List<Rule> rules, RuleGroup ss, SelectorMatcher matcher, boolean parentMatch) {
        int len = ss.getSize();
        block6: for (int i = 0; i < len; ++i) {
            Rule r = ss.getRule(i);
            switch (r.getType()) {
                case 1: {
                    StyleRule style = (StyleRule)r;
                    SelectorList sl = style.getAbsoluteSelectorList();
                    boolean pMatches = false;
                    int slen = sl.getLength();
                    for (int j = 0; j < slen; ++j) {
                        Selector s = sl.item(j);
                        if (!matcher.matches(s)) continue;
                        rules.add(style);
                        pMatches = true;
                        break;
                    }
                    if (style.getSize() <= 0) continue block6;
                    this.addMatchingRules(rules, style, matcher, pMatches);
                    continue block6;
                }
                case 3: 
                case 4: {
                    MediaRule mr = (MediaRule)r;
                    if (!this.mediaMatch(mr.getMedia())) continue block6;
                    this.addMatchingRules(rules, mr, matcher, parentMatch);
                    continue block6;
                }
                case 12: {
                    SupportsRule sr = (SupportsRule)r;
                    if (!sr.supports) continue block6;
                    this.addMatchingRules(rules, sr, matcher, parentMatch);
                    continue block6;
                }
                case 19: {
                    if (!parentMatch) continue block6;
                    rules.add(r);
                }
            }
        }
    }

    protected boolean mediaMatch(MediaQueryList ml) {
        if (this.medium == null || ml == null || ml.isAllMedia()) {
            return true;
        }
        return ml.matches(this.medium, this.csscanvas);
    }

    private void setSupports(SupportsRule sr) {
        BooleanCondition condition = sr.getCondition();
        if (condition != null) {
            try {
                sr.supports = this.supports(condition);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sr.supports = false;
    }

    private boolean supports(BooleanCondition condition) {
        switch (condition.getType()) {
            case PREDICATE: {
                DeclarationCondition declCond = (DeclarationCondition)condition;
                return this.supports(declCond.getName(), declCond.getValue());
            }
            case AND: {
                List subcond = condition.getSubConditions();
                if (subcond == null) {
                    DOMException ex = new DOMException(12, "No conditions inside and().");
                    this.userAgent.displayError(ex);
                    return false;
                }
                Iterator it = subcond.iterator();
                while (it.hasNext()) {
                    if (this.supports((BooleanCondition)it.next())) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                BooleanCondition nested = condition.getNestedCondition();
                if (nested == null) {
                    DOMException ex = new DOMException(12, "No condition inside not().");
                    this.userAgent.displayError(ex);
                    return false;
                }
                return !this.supports(nested);
            }
            case OR: {
                List subcond = condition.getSubConditions();
                if (subcond == null) {
                    DOMException ex = new DOMException(12, "No conditions inside or().");
                    this.userAgent.displayError(ex);
                    return false;
                }
                Iterator it = subcond.iterator();
                while (it.hasNext()) {
                    if (!this.supports((BooleanCondition)it.next())) continue;
                    return true;
                }
                break;
            }
            case SELECTOR_FUNCTION: {
                SelectorFunction selCond = (SelectorFunction)condition;
                return this.styleDb.supports(selCond.getSelectors());
            }
        }
        return false;
    }

    private boolean supports(String property, LexicalUnit value) {
        int idx = this.getPropertyIndex(property);
        if (idx != -1) {
            try {
                this.valueManagers[idx].createValue(value, this);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        idx = this.getShorthandIndex(property);
        if (idx != -1) {
            try {
                this.shorthandManagers[idx].setValues(this, new ShorthandManager.PropertyHandler(){

                    @Override
                    public void property(String name, LexicalUnit value, boolean important) {
                    }

                    @Override
                    public void pendingValue(String name, PendingValue value, boolean important) {
                    }
                }, value, false);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected void addRules(SelectorMatcher matcher, StyleMap sm, ArrayList<Rule> rules, int origin) {
        this.sortRules(rules, matcher);
        if (origin == 0x60000000) {
            for (Rule rule : rules) {
                DeclarationsRule sr = (DeclarationsRule)rule;
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                for (int i = 0; i < len; ++i) {
                    this.putAuthorProperty(sm, sd.getIndex(i), sd.getValue(i), sd.getPriority(i), origin);
                }
                Map<String, LexicalUnit> customProp = sd.getCustomProperties();
                if (customProp == null) continue;
                for (Map.Entry<String, LexicalUnit> entry : customProp.entrySet()) {
                    sm.putCustomProperty(entry.getKey(), entry.getValue());
                }
            }
        } else {
            for (Rule rule : rules) {
                DeclarationsRule sr = (DeclarationsRule)rule;
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                for (int i = 0; i < len; ++i) {
                    int idx = sd.getIndex(i);
                    sm.putValue(idx, sd.getValue(i));
                    sm.putImportant(idx, sd.getPriority(i));
                    sm.putOrigin(idx, origin);
                }
            }
        }
    }

    protected void sortRules(ArrayList<Rule> rules, SelectorMatcher matcher) {
        int i;
        int len = rules.size();
        Specificity[] specificities = new Specificity[len];
        for (i = 0; i < len; ++i) {
            StyleRule sr;
            Rule r = rules.get(i);
            if (r.getType() == 1) {
                sr = (StyleRule)r;
            } else {
                RuleGroup p = r.getParent();
                while (true) {
                    if (p.getType() == 1) {
                        sr = (StyleRule)p;
                        break;
                    }
                    p = p.getParent();
                }
            }
            SelectorList sl = sr.getAbsoluteSelectorList();
            Specificity mostSpecific = null;
            int slen = sl.getLength();
            for (int k = 0; k < slen; ++k) {
                Selector s = sl.item(k);
                if (!matcher.matches(s)) continue;
                Specificity specificity = new Specificity(s, matcher);
                if (mostSpecific == null) {
                    mostSpecific = specificity;
                    continue;
                }
                int sp = Specificity.selectorCompare((Specificity)specificity, (Specificity)mostSpecific);
                if (sp <= 0) continue;
                mostSpecific = specificity;
            }
            specificities[i] = mostSpecific;
        }
        for (i = 1; i < len; ++i) {
            int j;
            Rule rule = rules.get(i);
            Specificity spec = specificities[i];
            for (j = i - 1; j >= 0 && Specificity.selectorCompare((Specificity)specificities[j], (Specificity)spec) > 0; --j) {
                rules.set(j + 1, rules.get(j));
                specificities[j + 1] = specificities[j];
            }
            rules.set(j + 1, rule);
            specificities[j + 1] = spec;
        }
    }

    public void addCSSEngineListener(CSSEngineListener l) {
        this.listeners.add(l);
    }

    public void removeCSSEngineListener(CSSEngineListener l) {
        this.listeners.remove(l);
    }

    protected void firePropertiesChangedEvent(Element target, int[] props) {
        CSSEngineListener[] ll = this.listeners.toArray(LISTENER_ARRAY);
        int len = ll.length;
        if (len > 0) {
            CSSEngineEvent evt = new CSSEngineEvent(this, target, props);
            for (CSSEngineListener aLl : ll) {
                aLl.propertiesChanged(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inlineStyleAttributeUpdated(CSSStylableElement elt, StyleMap style, short attrChange, String prevValue, String newValue) {
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            updated[i] = false;
        }
        switch (attrChange) {
            case 1: 
            case 2: {
                if (newValue.length() > 0) {
                    this.element = elt;
                    try {
                        this.styleDeclarationUpdateHandler.styleMap = style;
                        this.parser.setDocumentHandler((CSSHandler)this.styleDeclarationUpdateHandler);
                        this.parser.parseStyleDeclaration((Reader)new StringReader(newValue));
                        this.styleDeclarationUpdateHandler.styleMap = null;
                    }
                    catch (Exception e) {
                        String m = e.getMessage();
                        if (m == null) {
                            m = "";
                        }
                        String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String s = Messages.formatMessage("style.syntax.error.at", new Object[]{u, this.styleLocalName, newValue, m});
                        DOMException de = new DOMException(12, s);
                        de.initCause(e);
                        if (this.userAgent == null) {
                            throw de;
                        }
                        this.userAgent.displayError(de);
                    }
                    finally {
                        this.element = null;
                        this.cssBaseURI = null;
                    }
                }
            }
            case 3: {
                boolean removed = false;
                if (prevValue != null && prevValue.length() > 0) {
                    for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                        int origin;
                        if (!style.isComputed(i) || updated[i] || (origin = style.getOrigin(i)) < Integer.MIN_VALUE) continue;
                        removed = true;
                        updated[i] = true;
                    }
                }
                if (removed) {
                    this.invalidateProperties(elt, null, updated, true);
                    break;
                }
                int count = 0;
                boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
                boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
                boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
                boolean isRoot = elt.getOwnerDocument().getDocumentElement() == elt;
                boolean cp = this.styleDeclarationUpdateHandler.updatedCustomProperties;
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (updated[i]) {
                        ++count;
                        continue;
                    }
                    if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i) || cl && style.isColorRelative(i) || fs && isRoot && style.isRootFontSizeRelative(i) || lh && isRoot && style.isRootLineHeightRelative(i)) && (!cp || !style.isCustomPtyRelative(i))) continue;
                    updated[i] = true;
                    CSSEngine.clearComputedValue(style, i);
                    ++count;
                }
                if (count <= 0) break;
                int[] props = new int[count];
                count = 0;
                for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (!updated[i]) continue;
                    props[count++] = i;
                }
                this.invalidateProperties(elt, props, null, true);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap style, int n) {
        if (style.isNullCascaded(n)) {
            style.putValue(n, null);
        } else {
            Value v = style.getValue(n);
            if (v instanceof ComputedValue) {
                ComputedValue cv = (ComputedValue)v;
                v = cv.getCascadedValue();
                style.putValue(n, v);
            }
        }
        style.putComputed(n, false);
    }

    protected void invalidateProperties(Node node, int[] properties, boolean[] updated, boolean recascade) {
        int i;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement elt = (CSSStylableElement)node;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style == null) {
            return;
        }
        boolean[] diffs = new boolean[this.getNumberOfProperties()];
        if (updated != null) {
            System.arraycopy(updated, 0, diffs, 0, updated.length);
        }
        if (properties != null) {
            for (int property : properties) {
                diffs[property] = true;
            }
        }
        int count = 0;
        if (!recascade) {
            for (boolean diff : diffs) {
                if (!diff) continue;
                ++count;
            }
        } else {
            StyleMap newStyle = this.getCascadedStyleMap(elt, null);
            elt.setComputedStyleMap(null, newStyle);
            for (i = 0; i < diffs.length; ++i) {
                if (diffs[i]) {
                    ++count;
                    continue;
                }
                Value nv = newStyle.getValue(i);
                Value ov = null;
                if (!style.isNullCascaded(i) && (ov = style.getValue(i)) instanceof ComputedValue) {
                    ov = ((ComputedValue)ov).getCascadedValue();
                }
                if (nv == ov) continue;
                if (nv != null && ov != null) {
                    if (nv.equals(ov)) continue;
                    String ovCssText = ov.getCssText();
                    String nvCssText = nv.getCssText();
                    if (nvCssText == ovCssText || nvCssText != null && nvCssText.equals(ovCssText)) continue;
                }
                ++count;
                diffs[i] = true;
            }
        }
        int[] props = null;
        if (count != 0) {
            props = new int[count];
            count = 0;
            for (i = 0; i < diffs.length; ++i) {
                if (!diffs[i]) continue;
                props[count++] = i;
            }
        }
        this.propagateChanges(elt, props, recascade);
    }

    protected void propagateChanges(Node node, int[] props, boolean recascade) {
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement elt = (CSSStylableElement)node;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style != null) {
            int i;
            int i2;
            boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
            for (i2 = this.getNumberOfProperties() - 1; i2 >= 0; --i2) {
                updated[i2] = false;
            }
            if (props != null) {
                for (i2 = props.length - 1; i2 >= 0; --i2) {
                    int idx = props[i2];
                    updated[idx] = true;
                }
            }
            boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
            boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
            boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
            boolean isRootFs = fs && elt.getOwnerDocument().getDocumentElement() == elt;
            boolean cp = this.styleDeclarationUpdateHandler.updatedCustomProperties;
            int count = 0;
            for (i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                if (updated[i]) {
                    ++count;
                    continue;
                }
                if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i) || cl && style.isColorRelative(i) || isRootFs && style.isRootFontSizeRelative(i)) && (!cp || !style.isCustomPtyRelative(i))) continue;
                updated[i] = true;
                CSSEngine.clearComputedValue(style, i);
                ++count;
            }
            if (count == 0) {
                props = null;
            } else {
                props = new int[count];
                count = 0;
                for (i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                    if (!updated[i]) continue;
                    props[count++] = i;
                }
                this.firePropertiesChangedEvent(elt, props);
            }
        }
        int[] inherited = props;
        if (props != null) {
            int count = 0;
            for (int i = 0; i < props.length; ++i) {
                ValueManager vm = this.valueManagers[props[i]];
                if (vm.isInheritedProperty()) {
                    ++count;
                    continue;
                }
                props[i] = -1;
            }
            if (count == 0) {
                inherited = null;
            } else {
                inherited = new int[count];
                count = 0;
                for (int prop : props) {
                    if (prop == -1) continue;
                    inherited[count++] = prop;
                }
            }
        }
        Node n = CSSEngine.getCSSFirstChild(node);
        while (n != null) {
            if (n.getNodeType() == 1) {
                this.invalidateProperties(n, inherited, null, recascade);
            }
            n = CSSEngine.getCSSNextSibling(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nonCSSPresentationalHintUpdated(CSSStylableElement elt, StyleMap style, String property, short attrChange, String newValue) {
        int idx = this.getPropertyIndex(property);
        if (style.isImportant(idx)) {
            return;
        }
        if (style.getOrigin(idx) >= 0x60000000) {
            return;
        }
        switch (attrChange) {
            case 1: 
            case 2: {
                this.element = elt;
                try {
                    LexicalUnit lu = this.parser.parsePropertyValue((Reader)new StringReader(newValue));
                    ValueManager vm = this.valueManagers[idx];
                    Value v = vm.createValue(lu, this);
                    style.putMask(idx, 0);
                    style.putValue(idx, v);
                    style.putOrigin(idx, 0x40000000);
                    break;
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m == null) {
                        m = "";
                    }
                    String u = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String s = Messages.formatMessage("property.syntax.error.at", new Object[]{u, property, newValue, m});
                    DOMException de = new DOMException(12, s);
                    de.initCause(e);
                    if (this.userAgent == null) {
                        throw de;
                    }
                    this.userAgent.displayError(de);
                    break;
                }
                finally {
                    this.element = null;
                    this.cssBaseURI = null;
                }
            }
            case 3: {
                int[] invalid = new int[]{idx};
                this.invalidateProperties(elt, invalid, null, true);
                return;
            }
        }
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            updated[i] = false;
        }
        updated[idx] = true;
        boolean fs = idx == this.fontSizeIndex;
        boolean lh = idx == this.lineHeightIndex;
        boolean cl = idx == this.colorIndex;
        boolean isRootFs = fs && elt.getOwnerDocument().getDocumentElement() == elt;
        int count = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (updated[i]) {
                ++count;
                continue;
            }
            if (!(fs && style.isFontSizeRelative(i) || lh && style.isLineHeightRelative(i) || cl && style.isColorRelative(i)) && (!isRootFs || !style.isRootFontSizeRelative(i))) continue;
            updated[i] = true;
            CSSEngine.clearComputedValue(style, i);
            ++count;
        }
        int[] props = new int[count];
        count = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (!updated[i]) continue;
            props[count++] = i;
        }
        this.invalidateProperties(elt, props, null, true);
    }

    protected boolean hasStyleSheetNode(Node n) {
        if (n instanceof CSSStyleSheetNode) {
            return true;
        }
        n = CSSEngine.getCSSFirstChild(n);
        while (n != null) {
            if (this.hasStyleSheetNode(n)) {
                return true;
            }
            n = CSSEngine.getCSSNextSibling(n);
        }
        return false;
    }

    protected void handleAttrModified(Element e, Attr attr, short attrChange, String prevValue, String newValue) {
        if (!(e instanceof CSSStylableElement) || newValue.equals(prevValue)) {
            return;
        }
        String attrNS = attr.getNamespaceURI();
        String name = attrNS == null ? attr.getNodeName() : attr.getLocalName();
        CSSStylableElement elt = (CSSStylableElement)e;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style != null) {
            if ((attrNS == this.styleNamespaceURI || attrNS != null && attrNS.equals(this.styleNamespaceURI)) && name.equals(this.styleLocalName)) {
                this.inlineStyleAttributeUpdated(elt, style, attrChange, prevValue, newValue);
                return;
            }
            if (this.nonCSSPresentationalHints != null && (attrNS == this.nonCSSPresentationalHintsNamespaceURI || attrNS != null && attrNS.equals(this.nonCSSPresentationalHintsNamespaceURI)) && this.nonCSSPresentationalHints.contains(name)) {
                this.nonCSSPresentationalHintUpdated(elt, style, name, attrChange, newValue);
                return;
            }
        }
        if (this.selectorAttributes != null && this.selectorAttributes.contains(name)) {
            this.invalidateProperties(elt, null, null, true);
            Node n = CSSEngine.getCSSNextSibling(elt);
            while (n != null) {
                this.invalidateProperties(n, null, null, true);
                n = CSSEngine.getCSSNextSibling(n);
            }
        }
    }

    protected void handleNodeInserted(Node n) {
        if (this.hasStyleSheetNode(n)) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (n instanceof CSSStylableElement) {
            n = CSSEngine.getCSSNextSibling(n);
            while (n != null) {
                this.invalidateProperties(n, null, null, true);
                n = CSSEngine.getCSSNextSibling(n);
            }
        }
    }

    protected void handleNodeRemoved(Node n) {
        if (this.hasStyleSheetNode(n)) {
            this.styleSheetRemoved = true;
        } else if (n instanceof CSSStylableElement) {
            this.removedStylableElementSibling = CSSEngine.getCSSNextSibling(n);
        }
        this.disposeStyleMaps(n);
    }

    protected void handleSubtreeModified(Node ignored) {
        if (this.styleSheetRemoved) {
            this.styleSheetRemoved = false;
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (this.removedStylableElementSibling != null) {
            Node n = this.removedStylableElementSibling;
            while (n != null) {
                this.invalidateProperties(n, null, null, true);
                n = CSSEngine.getCSSNextSibling(n);
            }
            this.removedStylableElementSibling = null;
        }
    }

    protected void handleCharacterDataModified(Node n) {
        if (CSSEngine.getCSSParentNode(n) instanceof CSSStyleSheetNode) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        }
    }

    private class EngineStyleDatabase
    extends AbstractStyleDatabase {
        private static final long serialVersionUID = 1L;
        private final List<String> fonts = this.getAvailableFontList();

        private EngineStyleDatabase() {
        }

        private List<String> getAvailableFontList() {
            return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        }

        public String getDefaultGenericFontFamily() {
            return CSSEngine.this.cssContext.getDefaultFontFamily().getStringValue();
        }

        public String getDefaultGenericFontFamily(String genericFamily) {
            return genericFamily;
        }

        public boolean isFontFaceName(String requestedFamily) {
            for (FontFaceRule ffRule : CSSEngine.this.fontFaces) {
                int pidx;
                StyleMap sm = ffRule.getStyleMap();
                Value fontFamily = sm.getValue(pidx = CSSEngine.this.getPropertyIndex("font-family"));
                if (fontFamily == null || !fontFamily.getStringValue().equalsIgnoreCase(requestedFamily)) continue;
                return true;
            }
            return false;
        }

        public int getColorDepth() {
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration gConfiguration = genv.getDefaultScreenDevice().getDefaultConfiguration();
            int bpc = 255;
            if (gConfiguration != null) {
                int[] comp = gConfiguration.getColorModel().getComponentSize();
                for (int i = 0; i < 3; ++i) {
                    if (bpc <= comp[i]) continue;
                    bpc = comp[i];
                }
            }
            return bpc;
        }

        public float getDeviceHeight() {
            return CSSEngine.this.cssContext.getViewport(CSSEngine.this.element).getHeight();
        }

        public float getDeviceWidth() {
            return CSSEngine.this.cssContext.getViewport(CSSEngine.this.element).getWidth();
        }

        protected boolean isFontFamilyAvailable(String fontFamily) {
            return this.fonts.contains(fontFamily);
        }

        public CSSTypedValue getInitialColor() {
            String pcs = CSSEngine.this.cssContext.getPrefersColorScheme();
            return "dark".equals(pcs) ? this.darkmodeInitialColor() : super.getInitialColor();
        }

        private CSSTypedValue darkmodeInitialColor() {
            return (CSSTypedValue)new ValueFactory().parseProperty("#fff");
        }

        public boolean supports(SelectorList selectors) {
            for (Selector selector : selectors) {
                if (this.supports(selector)) continue;
                return false;
            }
            return true;
        }

        private boolean supports(Selector selector) {
            if (selector != null) {
                switch (selector.getSelectorType()) {
                    case CHILD: 
                    case DESCENDANT: 
                    case DIRECT_ADJACENT: 
                    case SUBSEQUENT_SIBLING: {
                        CombinatorSelector combSel = (CombinatorSelector)selector;
                        return this.supports(combSel.getSelector()) && this.supports((Selector)combSel.getSecondSelector());
                    }
                    case CONDITIONAL: {
                        ConditionalSelector condSel = (ConditionalSelector)selector;
                        return this.supports((Selector)condSel.getSimpleSelector()) && this.supports(condSel.getCondition());
                    }
                    case COLUMN_COMBINATOR: {
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean supports(Condition condition) {
            switch (condition.getConditionType()) {
                case AND: {
                    CombinatorCondition combCond = (CombinatorCondition)condition;
                    return this.supports(combCond.getFirstCondition()) && this.supports(combCond.getSecondCondition());
                }
                case SELECTOR_ARGUMENT: {
                    ArgumentCondition argCond = (ArgumentCondition)condition;
                    SelectorList selist = argCond.getSelectors();
                    return selist == null || this.supports(selist);
                }
                case PSEUDO_CLASS: 
                case PSEUDO_ELEMENT: {
                    break;
                }
                default: {
                    return true;
                }
            }
            return false;
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                try {
                    CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
                }
                catch (Exception e) {
                    if (CSSEngine.this.userAgent == null) {
                        throw e;
                    }
                    CSSEngine.this.userAgent.displayError(e);
                }
            } else {
                Value v;
                try {
                    v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                }
                catch (Exception e) {
                    if (CSSEngine.this.userAgent == null) {
                        throw e;
                    }
                    CSSEngine.this.userAgent.displayError(e);
                    return;
                }
                CSSEngine.this.putAuthorProperty(this.styleMap, i, v, important, Integer.MIN_VALUE);
            }
        }

        @Override
        public void lexicalProperty(String name, LexicalUnit value, boolean important) {
            this.styleMap.putCustomProperty(name, value);
        }

        @Override
        public void pendingValue(String name, PendingValue v, boolean important) {
            int idx = CSSEngine.this.getPropertyIndex(name);
            if (idx != -1) {
                CSSEngine.this.putAuthorProperty(this.styleMap, idx, v, important, Integer.MIN_VALUE);
            }
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public RuleGroup ruleGroup;
        private SelectorList absoluteSelector = null;
        protected StyleDeclaration styleDeclaration;
        private PropertyDefinitionImpl currentPropertyDefinition = null;
        private int ignoredForRule = 0;

        protected StyleSheetDocumentHandler() {
        }

        @Override
        public void parseStart(ParserControl parserctl) {
        }

        @Override
        public void endOfStream() {
        }

        @Override
        public void ignorableAtRule(String atRule) {
        }

        @Override
        public void namespaceDeclaration(String prefix, String uri) {
        }

        @Override
        public void startCounterStyle(String name) {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 11;
            }
        }

        @Override
        public void endCounterStyle() {
            if (this.ignoredForRule == 11) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void importStyle(String uri, String layerName, BooleanCondition supportsCondition, MediaQueryList media, String defaultNamespaceURI) {
            if (this.ignoredForRule > 0 || layerName != null || !CSSEngine.this.supports(supportsCondition)) {
                return;
            }
            ImportRule ir = new ImportRule();
            ir.setMedia(media);
            ir.setParent(this.ruleGroup);
            ParsedURL base = CSSEngine.this.getCSSBaseURI();
            ParsedURL url = base == null ? new ParsedURL(uri) : new ParsedURL(base, uri);
            ir.setURI(url);
            this.ruleGroup.append(ir);
        }

        @Override
        public void startMedia(MediaQueryList media) {
            if (this.ignoredForRule > 0) {
                return;
            }
            MediaRule mr = new MediaRule();
            mr.setMedia(media);
            mr.setParent(this.ruleGroup);
            this.ruleGroup.append(mr);
            this.ruleGroup = mr;
            this.styleDeclaration = null;
        }

        @Override
        public void endMedia(MediaQueryList media) {
            if (this.ignoredForRule > 0) {
                return;
            }
            this.ruleGroup = this.ruleGroup.getParent();
            this.styleDeclaration = null;
        }

        @Override
        public void startPage(PageSelectorList pageSelectorList) {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 6;
            }
        }

        @Override
        public void endPage(PageSelectorList pageSelectorList) {
            if (this.ignoredForRule == 6) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void startFontFace() {
            if (this.ignoredForRule > 0) {
                return;
            }
            this.styleDeclaration = new StyleDeclaration();
        }

        @Override
        public void endFontFace() {
            if (this.ignoredForRule > 0) {
                return;
            }
            StyleMap sm = new StyleMap(CSSEngine.this.getNumberOfProperties());
            int len = this.styleDeclaration.size();
            for (int i = 0; i < len; ++i) {
                int idx = this.styleDeclaration.getIndex(i);
                sm.putValue(idx, this.styleDeclaration.getValue(i));
                sm.putImportant(idx, this.styleDeclaration.getPriority(i));
                sm.putOrigin(idx, 0x60000000);
            }
            this.styleDeclaration = null;
            int pidx = CSSEngine.this.getPropertyIndex("font-family");
            Value fontFamily = sm.getValue(pidx);
            if (fontFamily == null) {
                return;
            }
            ParsedURL base = CSSEngine.this.getCSSBaseURI();
            CSSEngine.this.fontFaces.add(new FontFaceRule(sm, base));
        }

        @Override
        public void startMargin(String name) {
        }

        @Override
        public void endMargin() {
        }

        @Override
        public void startKeyframes(String name) {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 7;
            }
        }

        @Override
        public void endKeyframes() {
            if (this.ignoredForRule == 7) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void startKeyframe(LexicalUnit keyframeSelector) {
        }

        @Override
        public void endKeyframe() {
        }

        @Override
        public void startFontFeatures(String[] familyName) {
            if (this.ignoredForRule == 0) {
                this.ignoredForRule = 14;
            }
        }

        @Override
        public void endFontFeatures() {
            if (this.ignoredForRule == 14) {
                this.ignoredForRule = 0;
            }
        }

        @Override
        public void startFeatureMap(String mapName) {
        }

        @Override
        public void endFeatureMap() {
        }

        @Override
        public void startProperty(String name) {
            if (this.ignoredForRule != 0) {
                return;
            }
            this.ignoredForRule = 18;
            if (CSSEngine.this.propertyDefinitionMap == null) {
                CSSEngine.this.propertyDefinitionMap = new HashMap();
            }
            this.currentPropertyDefinition = new PropertyDefinitionImpl(name);
        }

        @Override
        public void endProperty(boolean discard) {
            if (this.ignoredForRule != 18) {
                return;
            }
            if (!discard) {
                CSSEngine.this.propertyDefinitionMap.put(this.currentPropertyDefinition.getName(), this.currentPropertyDefinition);
            }
            this.currentPropertyDefinition = null;
            this.ignoredForRule = 0;
        }

        @Override
        public void startSupports(BooleanCondition condition) {
            if (this.ignoredForRule > 0) {
                return;
            }
            SupportsRule sr = new SupportsRule(condition);
            CSSEngine.this.setSupports(sr);
            sr.setParent(this.ruleGroup);
            this.ruleGroup.append(sr);
            this.ruleGroup = sr;
            this.styleDeclaration = null;
        }

        @Override
        public void endSupports(BooleanCondition condition) {
            if (this.ignoredForRule > 0) {
                return;
            }
            this.ruleGroup = this.ruleGroup.getParent();
            this.styleDeclaration = null;
        }

        @Override
        public void startSelector(SelectorList selectors) {
            if (this.ignoredForRule > 0) {
                return;
            }
            StyleRule styleRule = new StyleRule();
            styleRule.setSelectorList(selectors);
            this.absoluteSelector = this.absoluteSelector != null ? selectors.replaceNested(this.absoluteSelector) : selectors;
            styleRule.setAbsoluteSelectorList(this.absoluteSelector);
            this.styleDeclaration = new StyleDeclaration();
            styleRule.setStyleDeclaration(this.styleDeclaration);
            styleRule.setParent(this.ruleGroup);
            this.ruleGroup.append(styleRule);
            this.ruleGroup = styleRule;
        }

        @Override
        public void endSelector(SelectorList selectors) {
            this.resetAbsoluteSelector();
            this.ruleGroup = this.ruleGroup.getParent();
            this.styleDeclaration = null;
        }

        private void resetAbsoluteSelector() {
            if (this.ruleGroup.getType() != -1) {
                RuleGroup nextParent;
                RuleGroup parent = this.ruleGroup.getParent();
                do {
                    nextParent = parent.getParent();
                    if (parent.getType() != 1) continue;
                    this.absoluteSelector = ((StyleRule)parent).getAbsoluteSelectorList();
                    return;
                } while ((parent = nextParent) != null);
            }
            this.absoluteSelector = null;
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            if (this.ignoredForRule > 0) {
                return;
            }
            this.checkNestedDeclarations();
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                try {
                    CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
                }
                catch (Exception e) {
                    if (CSSEngine.this.userAgent == null) {
                        throw e;
                    }
                    CSSEngine.this.userAgent.displayError(e);
                }
            } else {
                Value v;
                try {
                    v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                }
                catch (Exception e) {
                    if (CSSEngine.this.userAgent == null) {
                        throw e;
                    }
                    CSSEngine.this.userAgent.displayError(e);
                    return;
                }
                this.styleDeclaration.append(v, i, important);
            }
        }

        @Override
        public void lexicalProperty(String name, LexicalUnit value, boolean important) {
            if (this.ignoredForRule == 18) {
                this.propertyRuleDescriptor(name, value, important);
                return;
            }
            if (this.ignoredForRule > 0) {
                return;
            }
            this.checkNestedDeclarations();
            this.styleDeclaration.setCustomProperty(name, value, important);
        }

        private void checkNestedDeclarations() {
            if (this.styleDeclaration == null) {
                NestedDeclarations nested = new NestedDeclarations();
                this.styleDeclaration = new StyleDeclaration();
                nested.setStyleDeclaration(this.styleDeclaration);
                nested.setParent(this.ruleGroup);
                this.ruleGroup.append(nested);
            }
        }

        private void propertyRuleDescriptor(String name, LexicalUnit value, boolean important) {
            switch (name) {
                case "inherits": {
                    this.currentPropertyDefinition.setInherits(!"false".equalsIgnoreCase(value.getStringValue()));
                    break;
                }
                case "initial-value": {
                    this.currentPropertyDefinition.setInitialValue(value);
                    break;
                }
                case "syntax": {
                    CSSValueSyntax syn;
                    String s = value.getStringValue();
                    if (s == null) {
                        s = "*";
                    }
                    SyntaxParser synParser = new SyntaxParser();
                    try {
                        syn = synParser.parseSyntax(s);
                    }
                    catch (Exception e) {
                        syn = synParser.parseSyntax("*");
                    }
                    this.currentPropertyDefinition.setSyntax(syn);
                }
            }
        }

        @Override
        public void pendingValue(String name, PendingValue v, boolean important) {
            if (this.ignoredForRule > 0) {
                return;
            }
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i != -1) {
                this.styleDeclaration.append(v, i, important);
            }
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                this.styleDeclaration.append(v, i, important);
            }
        }

        @Override
        public void lexicalProperty(String name, LexicalUnit value, boolean important) {
            this.styleDeclaration.setCustomProperty(name, value, important);
        }

        @Override
        public void pendingValue(String name, PendingValue value, boolean important) {
            int idx = CSSEngine.this.getPropertyIndex(name);
            if (idx != -1) {
                this.styleDeclaration.append(value, idx, important);
            }
        }
    }

    private class EngineCSSCanvas
    extends AbstractCSSCanvas {
        private EngineCSSCanvas() {
        }

        public CSSDocument getDocument() {
            return null;
        }

        public StyleDatabase getStyleDatabase() {
            return CSSEngine.this.styleDb;
        }

        protected String getOverflowBlock() {
            return "none";
        }

        protected String getOverflowInline() {
            return "none";
        }

        protected String getPointerAccuracy() {
            return "none";
        }

        protected String getPrefersColorScheme() {
            return CSSEngine.this.cssContext.getPrefersColorScheme();
        }

        protected float getResolution() {
            return CSSEngine.this.cssContext.getResolution();
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;
        public boolean updatedCustomProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (i == -1) {
                i = CSSEngine.this.getShorthandIndex(name);
                if (i == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i].setValues(CSSEngine.this, this, value, important);
            } else {
                if (this.styleMap.isImportant(i)) {
                    return;
                }
                this.updatedProperties[i] = true;
                Value v = CSSEngine.this.valueManagers[i].createValue(value, CSSEngine.this);
                this.styleMap.putMask(i, 0);
                this.styleMap.putValue(i, v);
                this.styleMap.putOrigin(i, Integer.MIN_VALUE);
            }
        }

        @Override
        public void lexicalProperty(String name, LexicalUnit value, boolean important) {
            this.updatedCustomProperties = true;
        }

        @Override
        public void pendingValue(String name, PendingValue v, boolean important) {
            int i = CSSEngine.this.getPropertyIndex(name);
            if (this.styleMap.isImportant(i)) {
                return;
            }
            this.updatedProperties[i] = true;
            this.styleMap.putMask(i, 0);
            this.styleMap.putValue(i, v);
            this.styleMap.putOrigin(i, Integer.MIN_VALUE);
        }
    }

    protected class CSSNavigableDocumentHandler
    implements CSSNavigableDocumentListener,
    MainPropertyReceiver {
        protected boolean[] mainPropertiesChanged;
        protected StyleDeclaration declaration;

        protected CSSNavigableDocumentHandler() {
        }

        @Override
        public void nodeInserted(Node newNode) {
            CSSEngine.this.handleNodeInserted(newNode);
        }

        @Override
        public void nodeToBeRemoved(Node oldNode) {
            CSSEngine.this.handleNodeRemoved(oldNode);
        }

        @Override
        public void subtreeModified(Node rootOfModifications) {
            CSSEngine.this.handleSubtreeModified(rootOfModifications);
        }

        @Override
        public void characterDataModified(Node text) {
            CSSEngine.this.handleCharacterDataModified(text);
        }

        @Override
        public void attrModified(Element e, Attr attr, short attrChange, String prevValue, String newValue) {
            CSSEngine.this.handleAttrModified(e, attr, attrChange, prevValue, newValue);
        }

        @Override
        public void overrideStyleTextChanged(CSSStylableElement elt, String text) {
            int i;
            StyleDeclarationProvider p = elt.getOverrideStyleDeclarationProvider();
            StyleDeclaration declaration = p.getStyleDeclaration();
            int ds = declaration.size();
            boolean[] updated = new boolean[CSSEngine.this.getNumberOfProperties()];
            for (i = 0; i < ds; ++i) {
                updated[declaration.getIndex((int)i)] = true;
            }
            declaration = CSSEngine.this.parseStyleDeclaration(elt, text);
            p.setStyleDeclaration(declaration);
            ds = declaration.size();
            for (i = 0; i < ds; ++i) {
                updated[declaration.getIndex((int)i)] = true;
            }
            CSSEngine.this.invalidateProperties(elt, null, updated, true);
        }

        @Override
        public void overrideStylePropertyRemoved(CSSStylableElement elt, String name) {
            StyleDeclarationProvider p = elt.getOverrideStyleDeclarationProvider();
            StyleDeclaration declaration = p.getStyleDeclaration();
            int idx = CSSEngine.this.getPropertyIndex(name);
            int ds = declaration.size();
            for (int i = 0; i < ds; ++i) {
                if (idx != declaration.getIndex(i)) continue;
                declaration.remove(i);
                StyleMap style = elt.getComputedStyleMap(null);
                if (style == null || style.getOrigin(idx) != -1610612736) break;
                CSSEngine.this.invalidateProperties(elt, new int[]{idx}, null, true);
                break;
            }
        }

        @Override
        public void overrideStylePropertyChanged(CSSStylableElement elt, String name, String val, String prio) {
            boolean important = prio != null && prio.length() != 0;
            StyleDeclarationProvider p = elt.getOverrideStyleDeclarationProvider();
            this.declaration = p.getStyleDeclaration();
            CSSEngine.this.setMainProperties(elt, this, name, val, important);
            this.declaration = null;
            CSSEngine.this.invalidateProperties(elt, null, this.mainPropertiesChanged, true);
        }

        @Override
        public void setMainProperty(String name, Value v, boolean important) {
            int i;
            int idx = CSSEngine.this.getPropertyIndex(name);
            if (idx == -1) {
                return;
            }
            for (i = 0; i < this.declaration.size() && idx != this.declaration.getIndex(i); ++i) {
            }
            if (i < this.declaration.size()) {
                this.declaration.put(i, v, idx, important);
            } else {
                this.declaration.append(v, idx, important);
            }
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            MutationEvent mevt = (MutationEvent)evt;
            CSSEngine.this.handleAttrModified((Element)((Object)evt.getTarget()), (Attr)mevt.getRelatedNode(), mevt.getAttrChange(), mevt.getPrevValue(), mevt.getNewValue());
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            CSSEngine.this.handleNodeInserted((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            CSSEngine.this.handleNodeRemoved((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            CSSEngine.this.handleSubtreeModified((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            CSSEngine.this.handleCharacterDataModified((Node)((Object)evt.getTarget()));
        }
    }

    private class AttributeVisitor
    extends AttributeConditionVisitor {
        AttributeVisitor() {
        }

        public void visit(AttributeCondition condition) {
            switch (condition.getConditionType()) {
                case ATTRIBUTE: 
                case ONE_OF_ATTRIBUTE: 
                case BEGIN_HYPHEN_ATTRIBUTE: 
                case BEGINS_ATTRIBUTE: 
                case ENDS_ATTRIBUTE: 
                case SUBSTRING_ATTRIBUTE: {
                    CSSEngine.this.selectorAttributes.add(condition.getLocalName());
                    break;
                }
            }
        }
    }

    public static interface MainPropertyReceiver {
        public void setMainProperty(String var1, Value var2, boolean var3);
    }

    protected static class DocumentAdapter
    implements CSSHandler {
        protected DocumentAdapter() {
        }

        public void parseStart(ParserControl parserctl) {
        }

        public void endOfStream() {
        }

        public void comment(String text, boolean precededByLF) {
        }

        public void ignorableAtRule(String atRule) {
            this.throwUnsupportedEx();
        }

        public void namespaceDeclaration(String prefix, String uri) {
            this.throwUnsupportedEx();
        }

        public void importStyle(String uri, String layerName, BooleanCondition supportsCondition, MediaQueryList media, String defaultNamespaceURI) {
            this.throwUnsupportedEx();
        }

        public void startMedia(MediaQueryList media) {
            this.throwUnsupportedEx();
        }

        public void endMedia(MediaQueryList media) {
            this.throwUnsupportedEx();
        }

        public void startPage(PageSelectorList pageSelectorList) {
            this.throwUnsupportedEx();
        }

        public void endPage(PageSelectorList pageSelectorList) {
            this.throwUnsupportedEx();
        }

        public void startFontFace() {
            this.throwUnsupportedEx();
        }

        public void endFontFace() {
            this.throwUnsupportedEx();
        }

        public void startMargin(String name) {
            this.throwUnsupportedEx();
        }

        public void endMargin() {
            this.throwUnsupportedEx();
        }

        public void startCounterStyle(String name) {
            this.throwUnsupportedEx();
        }

        public void endCounterStyle() {
            this.throwUnsupportedEx();
        }

        public void startKeyframes(String name) {
            this.throwUnsupportedEx();
        }

        public void endKeyframes() {
            this.throwUnsupportedEx();
        }

        public void startKeyframe(LexicalUnit keyframeSelector) {
            this.throwUnsupportedEx();
        }

        public void endKeyframe() {
            this.throwUnsupportedEx();
        }

        public void startFontFeatures(String[] familyName) {
            this.throwUnsupportedEx();
        }

        public void endFontFeatures() {
            this.throwUnsupportedEx();
        }

        public void startFeatureMap(String mapName) {
            this.throwUnsupportedEx();
        }

        public void endFeatureMap() {
            this.throwUnsupportedEx();
        }

        public void startProperty(String name) {
            this.throwUnsupportedEx();
        }

        public void endProperty(boolean discard) {
            this.throwUnsupportedEx();
        }

        public void startSupports(BooleanCondition condition) {
            this.throwUnsupportedEx();
        }

        public void endSupports(BooleanCondition condition) {
            this.throwUnsupportedEx();
        }

        public void startSelector(SelectorList selectors) {
            this.throwUnsupportedEx();
        }

        public void endSelector(SelectorList selectors) {
            this.throwUnsupportedEx();
        }

        public void property(String name, LexicalUnit value, boolean important) {
            this.throwUnsupportedEx();
        }

        public void lexicalProperty(String name, LexicalUnit value, boolean important) {
        }

        private void throwUnsupportedEx() {
            throw new UnsupportedOperationException("you try to use an empty method in Adapter-class");
        }
    }
}

