/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class SrcManager
extends IdentifierManager {
    protected static final StringMap<Value> values = new StringMap(3);

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 38;
    }

    @Override
    public String getPropertyName() {
        return "src";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lunit);
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lunit.getLexicalUnitType());
            }
            case IDENT: 
            case STRING: 
            case URI: 
            case SRC: 
        }
        ListValue result = new ListValue();
        LexicalUnit lu = lunit;
        do {
            block8 : switch (lu.getLexicalUnitType()) {
                case STRING: {
                    result.append(new StringValue(lu.getStringValue()));
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                case URI: {
                    String sv = lu.getStringValue();
                    String uri = SrcManager.resolveURI(engine.getCSSBaseURI(), sv);
                    result.append(new URIValue(sv, uri));
                    lu = lu.getNextLexicalUnit();
                    if (lu == null) break;
                    switch (lu.getLexicalUnitType()) {
                        case FUNCTION: {
                            if (!lu.getFunctionName().equalsIgnoreCase("format")) break;
                            lu = lu.getNextLexicalUnit();
                            break;
                        }
                        case VAR: {
                            return this.createLexicalValue(lunit);
                        }
                    }
                    break;
                }
                case SRC: {
                    String uri;
                    block29: for (LexicalUnit param = lu.getParameters(); param != null; param = param.getNextLexicalUnit()) {
                        switch (param.getLexicalUnitType()) {
                            case STRING: {
                                String s = param.getStringValue();
                                uri = SrcManager.resolveURI(engine.getCSSBaseURI(), s);
                                result.append(new URIValue(s, uri));
                                break block29;
                            }
                            case VAR: {
                                return this.createLexicalValue(lunit);
                            }
                            case IDENT: 
                            case FUNCTION: {
                                continue block29;
                            }
                            default: {
                                throw this.createInvalidLexicalUnitDOMException(param.getLexicalUnitType());
                            }
                        }
                    }
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                case IDENT: {
                    StringBuilder sb = new StringBuilder(lu.getStringValue());
                    lu = lu.getNextLexicalUnit();
                    if (lu == null) break;
                    switch (lu.getLexicalUnitType()) {
                        case IDENT: {
                            do {
                                sb.append(' ');
                                sb.append(lu.getStringValue());
                            } while ((lu = lu.getNextLexicalUnit()) != null && lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT);
                            result.append(new StringValue(sb.toString()));
                            break block8;
                        }
                        case VAR: 
                        case ATTR: {
                            return this.createLexicalValue(lunit);
                        }
                    }
                    String id = sb.toString();
                    String s = id.toLowerCase(Locale.ROOT).intern();
                    Value v = values.get(s);
                    result.append(v != null ? v : new StringValue(id));
                    break;
                }
                case VAR: 
                case ATTR: {
                    return this.createLexicalValue(lunit);
                }
            }
            if (lu == null) {
                return result;
            }
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            if (type == LexicalUnit.LexicalType.VAR || type == LexicalUnit.LexicalType.ATTR) {
                return this.createLexicalValue(lunit);
            }
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        } while ((lu = lu.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (sm.isAttrTainted(idx) && value.getCssValueType() == CSSValue.CssType.LIST) {
            Iterator iterator = ((ListValue)value).iterator();
            while (iterator.hasNext()) {
                Value v = (Value)iterator.next();
                if (v.getPrimitiveType() != CSSValue.Type.URI) continue;
                CSSEngineUserAgent ua = engine.getCSSEngineUserAgent();
                if (ua != null) {
                    ua.warn("attr()-tainted value: " + value.getCssText());
                }
                return null;
            }
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    @Override
    public StringMap<Value> getIdentifiers() {
        return values;
    }

    static {
        values.put("none", ValueConstants.NONE_VALUE);
    }
}

