/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.NDTNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import io.sf.carte.doc.dom.ParentNode;
import java.util.BitSet;
import java.util.Iterator;

abstract class DOMParentNode
extends NDTNode
implements ParentNode {
    private static final long serialVersionUID = 1L;
    private final AbstractDOMNode.ChildCollections child = new NDTNode.DefaultChildNodeList(this);

    public DOMParentNode(short nodeType) {
        super(nodeType);
    }

    @Override
    AbstractDOMNode.ChildCollections getNodeList() {
        return this.child;
    }

    @Override
    public ElementList getChildren() {
        return this.child.getChildren();
    }

    public DOMElement querySelector(String selectors) {
        return DOMParentNode.querySelector(selectors, this.getFirstChild());
    }

    @Override
    public ElementList querySelectorAll(String selectors) {
        return DOMParentNode.querySelectorAll(selectors, this.getFirstChild());
    }

    @Override
    public Iterator<DOMNode> iterator() {
        return this.child.iterator();
    }

    @Override
    public Iterator<DOMNode> descendingIterator() {
        return this.child.createDescendingIterator();
    }

    @Override
    public Iterator<DOMNode> iterator(BitSet whatToShow) {
        return this.child.createIterator(whatToShow);
    }

    @Override
    public Iterator<DOMElement> elementIterator() {
        return this.child.elementIterator();
    }

    @Override
    public Iterator<DOMElement> elementIterator(String tagname) {
        return this.child.elementIterator(tagname);
    }

    @Override
    public Iterator<DOMElement> elementIteratorNS(String namespaceURI, String localName) {
        return this.child.elementIteratorNS(namespaceURI, localName);
    }

    @Override
    public Iterator<DOMNode> iterator(int whatToShow, NodeFilter filter) {
        return this.child.createIterator(whatToShow, filter);
    }

    @Override
    public Iterator<DOMNode> typeIterator(short typeToShow) {
        return this.iterator(NodeFilter.maskTable[typeToShow - 1], null);
    }

    @Override
    public Iterator<DOMNode> iterator(NodeFilter filter) {
        return this.child.createIterator(-1, filter);
    }

    @Override
    public NodeListIterator listIterator() {
        return this.child.createListIterator();
    }

    @Override
    public ElementList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.child.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public ElementList getElementsByTagName(String name) {
        DOMDocument doc = this.getOwnerDocument();
        boolean isHTML = doc != null ? doc.isHTML() : this.getNodeType() == 9 && ((DOMDocument)this).isHTML();
        return this.child.getElementsByTagName(name, isHTML);
    }

    @Override
    public ElementList getElementsByClassName(String names) {
        return this.child.getElementsByClassName(names, this.getOwnerDocument().getComplianceMode());
    }
}

