/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;

class CSSDocumentUtil {
    private CSSDocumentUtil() {
    }

    static URI validURI(String uri) throws MalformedURLException {
        URI u;
        try {
            u = new URI(uri);
        }
        catch (URISyntaxException e) {
            int colonIdx;
            int index = e.getIndex();
            if (index == -1 || (colonIdx = uri.indexOf(58)) != -1 && colonIdx + 3 > index) {
                throw new MalformedURLException(e.getMessage());
            }
            uri = CSSDocumentUtil.replaceInvalidChar(uri, index);
            u = CSSDocumentUtil.validURI(uri);
        }
        return u;
    }

    private static String replaceInvalidChar(String uri, int index) throws MalformedURLException {
        char invc = uri.charAt(index);
        if (invc == '\\' || invc == '\"') {
            StringBuilder buf = new StringBuilder(45);
            buf.append("Character '").append(invc).append("' invalid in URI at index: ");
            buf.append(index);
            throw new MalformedURLException(buf.toString());
        }
        String invalid = String.valueOf(invc);
        try {
            return uri.replace(invalid, URLEncoder.encode(invalid, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            return uri;
        }
    }
}

