/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;

class BorderRadiusShorthandSetter
extends ShorthandSetter {
    BorderRadiusShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "border-radius");
    }

    @Override
    public short assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return 0;
        }
        if (kwscan == 2) {
            return 2;
        }
        StyleValue topLeftValue = this.createBorderRadiusValue(null);
        StyleValue topRightValue = this.createBorderRadiusValue(topLeftValue);
        StyleValue bottomRightValue = this.createBorderRadiusValue(topLeftValue);
        StyleValue bottomLeftValue = this.createBorderRadiusValue(topRightValue);
        if (topRightValue == null || bottomRightValue == null || bottomLeftValue == null) {
            if (!this.hasPrefixedValue()) {
                return 2;
            }
            this.flush();
            return 1;
        }
        if (this.currentValue != null) {
            if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                this.nextCurrentValue();
                StyleValue topLeftValue2 = this.createBorderRadiusValue(null);
                StyleValue topRightValue2 = this.createBorderRadiusValue(topLeftValue2);
                StyleValue bottomRightValue2 = this.createBorderRadiusValue(topLeftValue2);
                StyleValue bottomLeftValue2 = this.createBorderRadiusValue(topRightValue2);
                if (topRightValue2 == null || bottomRightValue2 == null || bottomLeftValue2 == null) {
                    if (!this.hasPrefixedValue()) {
                        return 2;
                    }
                    this.flush();
                    return 1;
                }
                topLeftValue = this.valuesToList(topLeftValue, topLeftValue2);
                topRightValue = this.valuesToList(topRightValue, topRightValue2);
                bottomRightValue = this.valuesToList(bottomRightValue, bottomRightValue2);
                bottomLeftValue = this.valuesToList(bottomLeftValue, bottomLeftValue2);
            } else {
                return 2;
            }
        }
        this.setSubpropertyValue("border-top-left-radius", topLeftValue);
        this.setSubpropertyValue("border-top-right-radius", topRightValue);
        this.setSubpropertyValue("border-bottom-right-radius", bottomRightValue);
        this.setSubpropertyValue("border-bottom-left-radius", bottomLeftValue);
        this.flush();
        return 0;
    }

    private StyleValue valuesToList(StyleValue value, StyleValue value2) {
        ValueList list = ValueList.createWSValueList();
        list.add(value);
        list.add(value2);
        return list;
    }

    private StyleValue createBorderRadiusValue(StyleValue defval) {
        if (this.currentValue == null) {
            return defval;
        }
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH) {
            return defval;
        }
        if (ValueFactory.isPositiveSizeSACUnit(this.currentValue)) {
            StyleValue value = this.createCSSValue(this.getShorthandName(), this.currentValue);
            this.nextCurrentValue();
            return value;
        }
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.PREFIXED_FUNCTION) {
            this.setPrefixedValue(this.currentValue);
        } else {
            StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
            if (errHandler != null && !this.hasCompatValue()) {
                errHandler.shorthandError(this.getShorthandName(), "Wrong border-radius value: " + this.currentValue.toString());
            }
        }
        return null;
    }
}

