/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.parser.CSSTokenHandler;
import io.sf.carte.doc.style.css.parser.ControlTokenHandler;
import io.sf.carte.uparser.TokenProducer;

abstract class HandlerManager {
    private ControlTokenHandler controlHandler;
    private HandlerManager parentManager = null;

    public HandlerManager() {
        this.controlHandler = this.createControlTokenHandler();
    }

    protected HandlerManager(HandlerManager parent) {
        this.parentManager = parent;
        this.controlHandler = parent.getControlHandler();
    }

    protected abstract ControlTokenHandler createControlTokenHandler();

    public ControlTokenHandler getControlHandler() {
        return this.controlHandler;
    }

    protected HandlerManager getParentManager() {
        return this.parentManager;
    }

    public boolean isTopManager() {
        return this.getParentManager() == null;
    }

    public TokenProducer createTokenProducer() {
        throw new IllegalStateException("Must subclass the manager.");
    }

    public void restoreInitialHandler() {
        CSSTokenHandler ini = this.getInitialTokenHandler();
        this.controlHandler.yieldHandling(ini);
    }

    public abstract void parseStart();

    public void rightCurlyBracket(int index) {
        this.controlHandler.getCurrentHandler().unexpectedCharError(index, 125);
    }

    public void yieldManagement(HandlerManager manager) {
        manager.restoreInitialHandler();
        assert (this.checkYieldManagement(manager));
    }

    private boolean checkYieldManagement(HandlerManager manager) {
        HandlerManager mgr = this.parentManager;
        while (mgr != null) {
            if (mgr == manager) {
                return true;
            }
            mgr = mgr.parentManager;
        }
        if (manager.parentManager == null) {
            manager.parentManager = this;
        } else if (manager.parentManager != this && manager.parentManager != this.parentManager) {
            throw new IllegalStateException("Possible hierarchy inconsistency");
        }
        return true;
    }

    public void restoreManagement(HandlerManager manager) {
        manager.restoreInitialHandler();
        assert (this.checkRestoreManagement(manager));
    }

    private boolean checkRestoreManagement(HandlerManager manager) {
        HandlerManager mgr = this.parentManager;
        while (mgr != null) {
            if (mgr == manager) {
                return true;
            }
            mgr = mgr.parentManager;
        }
        throw new IllegalStateException("Possible hierarchy inconsistency");
    }

    public void endManagement(int index) {
        HandlerManager p = this.getParentManager();
        if (p != null) {
            this.yieldManagement(p);
        }
    }

    public void endOfStream(int len) {
        HandlerManager p = this.getParentManager();
        if (p != null) {
            p.endOfStream(len);
        }
    }

    protected abstract CSSTokenHandler getInitialTokenHandler();

    protected abstract CSSErrorHandler getErrorHandler();
}

