/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.flow;

import io.sf.carte.echosvg.gvt.font.GVTFont;
import io.sf.carte.echosvg.gvt.font.GVTLineMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BlockInfo {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_END = 2;
    public static final int ALIGN_FULL = 3;
    protected float top;
    protected float right;
    protected float bottom;
    protected float left;
    protected float indent;
    protected int alignment;
    protected float lineHeight;
    protected List<GVTFont> fontList;
    protected Map<AttributedCharacterIterator.Attribute, Object> fontAttrs;
    protected float ascent = -1.0f;
    protected float descent = -1.0f;
    protected boolean flowRegionBreak;

    public BlockInfo(float top, float right, float bottom, float left, float indent, int alignment, float lineHeight, List<GVTFont> fontList, Map<AttributedCharacterIterator.Attribute, Object> fontAttrs, boolean flowRegionBreak) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
        this.indent = indent;
        this.alignment = alignment;
        this.lineHeight = lineHeight;
        this.fontList = fontList;
        this.fontAttrs = fontAttrs;
        this.flowRegionBreak = flowRegionBreak;
    }

    public BlockInfo(float margin, int alignment) {
        this.setMargin(margin);
        this.indent = 0.0f;
        this.alignment = alignment;
        this.flowRegionBreak = false;
    }

    public void setMargin(float margin) {
        this.top = margin;
        this.right = margin;
        this.bottom = margin;
        this.left = margin;
    }

    public void initLineInfo(FontRenderContext frc) {
        Iterator<GVTFont> iterator;
        float fontSize = 12.0f;
        Float fsFloat = (Float)this.fontAttrs.get(TextAttribute.SIZE);
        if (fsFloat != null) {
            fontSize = fsFloat.floatValue();
        }
        if ((iterator = this.fontList.iterator()).hasNext()) {
            GVTFont font = iterator.next();
            GVTLineMetrics lm = font.getLineMetrics("", frc);
            this.ascent = lm.getAscent();
            this.descent = lm.getDescent();
        }
        if (this.ascent == -1.0f) {
            this.ascent = fontSize * 0.8f;
            this.descent = fontSize * 0.2f;
        }
    }

    public float getTopMargin() {
        return this.top;
    }

    public float getRightMargin() {
        return this.right;
    }

    public float getBottomMargin() {
        return this.bottom;
    }

    public float getLeftMargin() {
        return this.left;
    }

    public float getIndent() {
        return this.indent;
    }

    public int getTextAlignment() {
        return this.alignment;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public List<GVTFont> getFontList() {
        return this.fontList;
    }

    public Map<AttributedCharacterIterator.Attribute, Object> getFontAttrs() {
        return this.fontAttrs;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getDescent() {
        return this.descent;
    }

    public boolean isFlowRegionBreak() {
        return this.flowRegionBreak;
    }
}

