/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.av;

public class AudioFormat {
    public final int sampleRate;
    public final int sampleSize;
    public final int channelCount;
    public final boolean signed;
    public final boolean fixedP;
    public final boolean planar;
    public final boolean littleEndian;

    public AudioFormat(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.sampleRate = n;
        this.sampleSize = n2;
        this.channelCount = n3;
        this.signed = bl;
        this.fixedP = bl2;
        this.planar = bl3;
        this.littleEndian = bl4;
        if (!bl2) {
            if (n2 != 32 && n2 != 64) {
                throw new IllegalArgumentException("Floating point: sampleSize " + n2 + " bits");
            }
            if (!bl) {
                throw new IllegalArgumentException("Floating point: unsigned");
            }
        }
    }

    public final int getDurationsByteSize(float f) {
        float f2 = this.sampleSize >>> 3;
        return Math.round(f * (float)this.channelCount * f2 * (float)this.sampleRate);
    }

    public final float getBytesDuration(int n) {
        float f = this.sampleSize >>> 3;
        return (float)n / ((float)this.channelCount * f * (float)this.sampleRate);
    }

    public final float getSamplesDuration(int n) {
        return (float)n / (float)this.sampleRate;
    }

    public final int getFrameCount(float f, float f2) {
        return Math.max(1, Math.round(f / f2));
    }

    public final int getSamplesByteCount(int n) {
        return n * (this.sampleSize >>> 3);
    }

    public final int getBytesSampleCount(int n) {
        return (n << 3) / this.sampleSize;
    }

    public String toString() {
        return "AudioFormat[sampleRate " + this.sampleRate + ", sampleSize " + this.sampleSize + ", channelCount " + this.channelCount + ", signed " + this.signed + ", fixedP " + this.fixedP + ", " + (this.planar ? "planar" : "packed") + ", " + (this.littleEndian ? "little" : "big") + "-endian]";
    }
}

