/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.cff;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import jogamp.graph.font.typecast.cff.Charset;
import jogamp.graph.font.typecast.cff.CharsetFormat0;
import jogamp.graph.font.typecast.cff.CharsetFormat1;
import jogamp.graph.font.typecast.cff.CharsetFormat2;
import jogamp.graph.font.typecast.cff.Charstring;
import jogamp.graph.font.typecast.cff.CharstringType2;
import jogamp.graph.font.typecast.cff.Dict;
import jogamp.graph.font.typecast.cff.Index;
import jogamp.graph.font.typecast.ot.table.CffTable;

public class CffFont {
    private final CffTable _table;
    private final Dict _topDict;
    private final Index _charStringsIndex;
    private final Dict _privateDict;
    private final Index _localSubrIndex;
    private final Charset _charset;
    private final Charstring[] _charstrings;

    public CffFont(CffTable cffTable, int n, Dict dict) throws IOException {
        this._table = cffTable;
        this._topDict = dict;
        Integer n2 = (Integer)this._topDict.getValue(17);
        DataInput dataInput = this._table.getDataInputForOffset(n2);
        this._charStringsIndex = new Index(dataInput);
        int n3 = this._charStringsIndex.getCount();
        List list = (List)this._topDict.getValue(18);
        dataInput = this._table.getDataInputForOffset((Integer)list.get(1));
        this._privateDict = new Dict(dataInput, (Integer)list.get(0));
        Integer n4 = (Integer)this._privateDict.getValue(19);
        if (n4 != null) {
            dataInput = cffTable.getDataInputForOffset((Integer)list.get(1) + n4);
            this._localSubrIndex = new Index(dataInput);
        } else {
            this._localSubrIndex = null;
        }
        Integer n5 = (Integer)this._topDict.getValue(15);
        dataInput = cffTable.getDataInputForOffset(n5);
        int n6 = dataInput.readUnsignedByte();
        switch (n6) {
            case 0: {
                this._charset = new CharsetFormat0(dataInput, n3);
                break;
            }
            case 1: {
                this._charset = new CharsetFormat1(dataInput, n3);
                break;
            }
            case 2: {
                this._charset = new CharsetFormat2(dataInput, n3);
                break;
            }
            default: {
                this._charset = null;
            }
        }
        this._charstrings = new Charstring[n3];
        for (int i = 0; i < n3; ++i) {
            int n7 = this._charStringsIndex.getOffset(i) - 1;
            int n8 = this._charStringsIndex.getOffset(i + 1) - n7 - 1;
            this._charstrings[i] = new CharstringType2(this, n, cffTable.getStringIndex().getString(this._charset.getSID(i)), this._charStringsIndex.getData(), n7, n8);
        }
    }

    public CffTable getTable() {
        return this._table;
    }

    public Index getCharStringsIndex() {
        return this._charStringsIndex;
    }

    public Dict getPrivateDict() {
        return this._privateDict;
    }

    public Index getLocalSubrIndex() {
        return this._localSubrIndex;
    }

    public Charset getCharset() {
        return this._charset;
    }

    public Charstring getCharstring(int n) {
        return this._charstrings[n];
    }

    public int getCharstringCount() {
        return this._charstrings.length;
    }
}

