/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.spi;

import io.sf.carte.echosvg.ext.awt.image.URLImageCache;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.spi.BrokenLinkProvider;
import io.sf.carte.echosvg.ext.awt.image.spi.DefaultBrokenLinkProvider;
import io.sf.carte.echosvg.ext.awt.image.spi.ErrorConstants;
import io.sf.carte.echosvg.ext.awt.image.spi.JDKRegistryEntry;
import io.sf.carte.echosvg.ext.awt.image.spi.RegistryEntry;
import io.sf.carte.echosvg.ext.awt.image.spi.StreamRegistryEntry;
import io.sf.carte.echosvg.ext.awt.image.spi.URLRegistryEntry;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.color.ColorSpace;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

public class ImageTagRegistry
implements ErrorConstants {
    private List<RegistryEntry> entries = new LinkedList<RegistryEntry>();
    private List<String> extensions = null;
    private List<String> mimeTypes = null;
    private transient ReentrantLock regLock = new ReentrantLock();
    private final URLImageCache imgCache = new URLImageCache();
    private static final ImageTagRegistry registry = ImageTagRegistry.createImageTagRegistry();
    private static BrokenLinkProvider defaultProvider = new DefaultBrokenLinkProvider();
    private static BrokenLinkProvider brokenLinkProvider = null;

    ImageTagRegistry() {
    }

    public void flushCache() {
        this.imgCache.flush();
    }

    public void flushImage(ParsedURL purl) {
        this.imgCache.clear(purl);
    }

    public Filter checkCache(ParsedURL purl) {
        Filter ret = this.imgCache.request(purl);
        if (ret == null) {
            this.imgCache.clear(purl);
        }
        return ret;
    }

    public Filter readURL(ParsedURL purl) {
        return this.readURL(null, purl, null, true, true);
    }

    public Filter readURL(InputStream is, ParsedURL purl, ColorSpace colorSpace, boolean allowOpenStream, boolean returnBrokenLink) {
        if (is != null && !is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        Filter ret = null;
        if (purl != null && (ret = this.imgCache.request(purl)) != null) {
            return ret;
        }
        boolean openFailed = false;
        List<String> mimeTypes = this.getRegisteredMimeTypes();
        for (RegistryEntry re : this.entries) {
            if (re instanceof URLRegistryEntry) {
                URLRegistryEntry ure;
                if (purl == null || !allowOpenStream || !(ure = (URLRegistryEntry)re).isCompatibleURL(purl) || (ret = ure.handleURL(purl)) == null) continue;
                break;
            }
            if (!(re instanceof StreamRegistryEntry)) continue;
            StreamRegistryEntry sre = (StreamRegistryEntry)re;
            if (openFailed) continue;
            try {
                if (is == null) {
                    if (purl == null || !allowOpenStream) break;
                    try {
                        is = purl.openStream(mimeTypes.iterator());
                    }
                    catch (IOException ioe) {
                        openFailed = true;
                        continue;
                    }
                    if (!is.markSupported()) {
                        is = new BufferedInputStream(is);
                    }
                }
                if (!sre.isCompatibleStream(is) || (ret = sre.handleStream(is, purl, colorSpace)) == null) continue;
                break;
            }
            catch (StreamCorruptedException sce) {
                is = null;
            }
        }
        if (purl != null) {
            this.imgCache.put(purl, ret);
        }
        if (ret == null) {
            if (!returnBrokenLink) {
                return null;
            }
            if (openFailed) {
                return ImageTagRegistry.getBrokenLinkImage(this, "url.unreachable", null);
            }
            return ImageTagRegistry.getBrokenLinkImage(this, "url.uninterpretable", null);
        }
        if (!returnBrokenLink && BrokenLinkProvider.hasBrokenLinkProperty(ret)) {
            ret = null;
        }
        return ret;
    }

    public Filter readStream(InputStream is) {
        return this.readStream(is, null);
    }

    public Filter readStream(InputStream is, ColorSpace colorSpace) {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        Filter ret = null;
        for (RegistryEntry re : this.entries) {
            if (!(re instanceof StreamRegistryEntry)) continue;
            StreamRegistryEntry sre = (StreamRegistryEntry)re;
            try {
                if (!sre.isCompatibleStream(is) || (ret = sre.handleStream(is, null, colorSpace)) == null) continue;
            }
            catch (StreamCorruptedException sce) {}
            break;
        }
        if (ret == null) {
            ret = ImageTagRegistry.getBrokenLinkImage(this, "stream.unreadable", null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RegistryEntry newRE) {
        float priority = newRE.getPriority();
        this.regLock.lock();
        try {
            ListIterator<RegistryEntry> li = this.entries.listIterator();
            while (li.hasNext()) {
                RegistryEntry re = li.next();
                if (!(re.getPriority() > priority)) continue;
                li.previous();
                break;
            }
            li.add(newRE);
            this.extensions = null;
            this.mimeTypes = null;
        }
        finally {
            this.regLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRegisteredExtensions() {
        List<String> ext = this.extensions;
        if (ext != null) {
            return ext;
        }
        this.regLock.lock();
        try {
            if (this.extensions != null) {
                List<String> list = this.extensions;
                return list;
            }
            ext = new ArrayList<String>(this.entries.size() + 5);
            for (RegistryEntry re : this.entries) {
                ext.addAll(re.getStandardExtensions());
            }
            this.extensions = Collections.unmodifiableList(ext);
        }
        finally {
            this.regLock.unlock();
        }
        return this.extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRegisteredMimeTypes() {
        List<String> mt = this.mimeTypes;
        if (mt != null) {
            return mt;
        }
        this.regLock.lock();
        try {
            if (this.mimeTypes != null) {
                List<String> list = this.mimeTypes;
                return list;
            }
            mt = new ArrayList<String>(this.entries.size() + 5);
            for (RegistryEntry re : this.entries) {
                mt.addAll(re.getMimeTypes());
            }
            this.mimeTypes = Collections.unmodifiableList(mt);
        }
        finally {
            this.regLock.unlock();
        }
        return this.mimeTypes;
    }

    public static ImageTagRegistry getRegistry() {
        return registry;
    }

    private static ImageTagRegistry createImageTagRegistry() {
        ImageTagRegistry registry = new ImageTagRegistry();
        registry.register(new JDKRegistryEntry());
        ServiceLoader<RegistryEntry> loader = ServiceLoader.load(RegistryEntry.class);
        for (RegistryEntry re : loader) {
            registry.register(re);
        }
        return registry;
    }

    public static Filter getBrokenLinkImage(Object base, String code, Object[] params) {
        Filter ret = null;
        if (brokenLinkProvider != null) {
            ret = brokenLinkProvider.getBrokenLinkImage(base, code, params);
        }
        if (ret == null) {
            ret = defaultProvider.getBrokenLinkImage(base, code, params);
        }
        return ret;
    }

    public static void setBrokenLinkProvider(BrokenLinkProvider provider) {
        brokenLinkProvider = provider;
    }
}

