/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.breakpoint.DBTraceBreakpointLocation;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointSpec;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class DBTraceBreakpointSpec
implements TraceBreakpointSpec,
DBTraceObjectInterface {
    private static final Map<TraceObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TraceObjectSchema, Set<String>>();
    private final DBTraceObject object;
    private final Set<String> keys;
    private TraceBreakpointKind.TraceBreakpointKindSet kinds = TraceBreakpointKind.TraceBreakpointKindSet.of(new TraceBreakpointKind[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTraceBreakpointSpec(DBTraceObject object) {
        this.object = object;
        TraceObjectSchema schema = object.getSchema();
        Map<TraceObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
        synchronized (map) {
            this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(schema.checkAliasedAttribute("_kinds"), schema.checkAliasedAttribute("_enabled")));
        }
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(long snap, String name) {
        this.setName(Lifespan.nowOn(snap), name);
    }

    @Override
    public String getName(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_display", String.class, "");
    }

    @Override
    public void setEnabled(Lifespan lifespan, boolean enabled) {
        this.object.setValue(lifespan, "_enabled", enabled ? Boolean.valueOf(true) : null);
    }

    @Override
    public void setEnabled(long snap, boolean enabled) {
        this.setEnabled(Lifespan.nowOn(snap), enabled);
    }

    @Override
    public boolean isEnabled(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_enabled", Boolean.class, false);
    }

    @Override
    public void setKinds(Lifespan lifespan, Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_kinds", TraceBreakpointKind.TraceBreakpointKindSet.encode(kinds));
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.copyOf(kinds);
        }
    }

    @Override
    public void setKinds(long snap, Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setKinds(Lifespan.nowOn(snap), kinds);
        }
    }

    @Override
    public Set<TraceBreakpointKind> getKinds(long snap) {
        String kindsStr = TraceObjectInterfaceUtils.getValue(this.object, snap, "_kinds", String.class, null);
        if (kindsStr == null) {
            return this.kinds;
        }
        try {
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.decode(kindsStr, true);
            return this.kinds;
        }
        catch (IllegalArgumentException e) {
            Msg.warn((Object)this, (Object)("Unrecognized breakpoint kind(s) in trace database: " + String.valueOf(e)));
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.decode(kindsStr, false);
            return this.kinds;
        }
    }

    @Override
    public String getExpression(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_expression", String.class, null);
    }

    @Override
    public void setComment(Lifespan lifespan, String comment) {
        this.object.setValue(lifespan, "_comment", comment);
    }

    @Override
    public void setComment(long snap, String comment) {
        this.setComment(Lifespan.nowOn(snap), comment);
    }

    @Override
    public String getComment(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            String string = TraceObjectInterfaceUtils.getValue(this.object, snap, "_comment", String.class, "");
            return string;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.ALL);
        }
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.nowOn(snap));
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.isAlive(snap);
    }

    @Override
    public boolean isAlive(Lifespan span) {
        return this.object.isAlive(span);
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    protected Collection<? extends TraceBreakpointLocation> getLocations(Lifespan span) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Collection collection = this.object.querySuccessorsInterface(span, TraceBreakpointLocation.class, true).collect(Collectors.toSet());
            return collection;
        }
    }

    @Override
    public Collection<? extends TraceBreakpointLocation> getLocations(long snap) {
        return this.getLocations(Lifespan.at(snap));
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        if (rec.getEventType() == TraceEvents.VALUE_CREATED) {
            TraceChangeRecord cast = TraceEvents.VALUE_CREATED.cast(rec);
            TraceObjectValue affected = (TraceObjectValue)cast.getAffectedObject();
            String key = affected.getEntryKey();
            boolean applies = this.keys.contains(key);
            if (!applies) {
                return null;
            }
            assert (affected.getParent() == this.object);
            if (this.object.getCanonicalParent(affected.getMaxSnap()) == null) {
                return null;
            }
            for (TraceBreakpointLocation traceBreakpointLocation : this.getLocations(affected.getLifespan())) {
                DBTraceBreakpointLocation dbLoc = (DBTraceBreakpointLocation)traceBreakpointLocation;
                AddressSpace space = dbLoc.getAddressSpace(affected.getMinSnap());
                TraceChangeRecord<TraceBreakpointLocation, Object> evt = new TraceChangeRecord<TraceBreakpointLocation, Object>(TraceEvents.BREAKPOINT_CHANGED, space, traceBreakpointLocation, null, null);
                this.object.getTrace().setChanged(evt);
            }
            return null;
        }
        return null;
    }
}

