/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.LoaderOpinionException;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.Processor;
import ghidra.util.datastruct.Stack;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class QueryOpinionServiceHandler {
    public static void read(XmlPullParser parser) {
        Stack queryStack = new Stack();
        queryStack.add((Object)new FullQuery(null, null, null, new LanguageCompilerSpecQuery(null, null, null, null, null)));
        XmlElement root = parser.start(new String[]{"opinions"});
        while (parser.peek().getName().equals("constraint")) {
            XmlElement element = parser.next();
            if (element.isStart()) {
                FullQuery top = (FullQuery)queryStack.peek();
                String loader = element.getAttribute("loader");
                String primary = element.getAttribute("primary");
                String secondary = element.getAttribute("secondary");
                String processorString = element.getAttribute("processor");
                String endianString = element.getAttribute("endian");
                String sizeString = element.getAttribute("size");
                String variant = element.getAttribute("variant");
                String compilerSpecIDString = element.getAttribute("compilerSpecID");
                Processor processor = null;
                if (processorString != null) {
                    processor = Processor.findOrPossiblyCreateProcessor((String)processorString);
                }
                Endian endian = null;
                if (endianString != null && (endian = Endian.toEndian((String)endianString)) == null) {
                    throw new LoaderOpinionException("no such endian: " + endianString);
                }
                Integer size = null;
                if (sizeString != null) {
                    try {
                        size = Integer.parseInt(sizeString);
                    }
                    catch (NumberFormatException e) {
                        throw new LoaderOpinionException("invalid size integer: " + sizeString, e);
                    }
                }
                CompilerSpecID compilerSpecID = null;
                if (compilerSpecIDString != null) {
                    compilerSpecID = new CompilerSpecID(compilerSpecIDString);
                }
                FullQuery newFullQuery = new FullQuery(top, loader, primary, secondary, new LanguageCompilerSpecQuery(processor, endian, size, variant, compilerSpecID));
                queryStack.push((Object)newFullQuery);
                QueryOpinionService.addQuery(newFullQuery.loader, newFullQuery.primary, newFullQuery.secondary, newFullQuery.query);
                continue;
            }
            queryStack.pop();
        }
        parser.end(root);
    }

    private static class FullQuery {
        final String loader;
        final String primary;
        final String secondary;
        final LanguageCompilerSpecQuery query;

        FullQuery(String loader, String primary, String secondary, LanguageCompilerSpecQuery query) {
            this.loader = loader;
            this.primary = primary;
            this.secondary = secondary;
            this.query = query;
        }

        public FullQuery(FullQuery fullQuery, String loader, String primary, String secondary, LanguageCompilerSpecQuery query) {
            this.loader = loader == null ? fullQuery.loader : loader;
            this.primary = primary == null ? fullQuery.primary : primary;
            this.secondary = secondary == null ? fullQuery.secondary : secondary;
            this.query = new LanguageCompilerSpecQuery(query.processor == null ? fullQuery.query.processor : query.processor, query.endian == null ? fullQuery.query.endian : query.endian, query.size == null ? fullQuery.query.size : query.size, query.variant == null ? fullQuery.query.variant : query.variant, query.compilerSpecID == null ? fullQuery.query.compilerSpecID : query.compilerSpecID);
        }
    }
}

