/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class RowColumnLayout
implements LayoutManager {
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int TOP_TO_BOTTOM = 1;
    private int vgap;
    private int hgap;
    private int compWidth;
    private int compHeight;
    private int orientation;
    private int maxSize;
    private int fillOrder;

    public RowColumnLayout(int hgap, int vgap, int orientation, int maxSize) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.orientation = orientation;
        this.maxSize = maxSize;
        this.fillOrder = 0;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int height;
        Insets insets = parent.getInsets();
        int n = parent.getComponentCount();
        this.computeComponentSize(parent);
        int numRows = 1;
        int numCols = 1;
        if (this.orientation == 0) {
            int width = Math.max(this.maxSize - insets.left - insets.right, this.compWidth);
            numCols = (width + this.hgap) / (this.compWidth + this.hgap);
            numRows = (n + numCols - 1) / numCols;
            numCols = (n + numRows - 1) / numRows;
        } else {
            height = Math.max(this.maxSize - insets.top - insets.bottom, this.compHeight);
            numRows = (height + this.vgap) / (this.compHeight + this.vgap);
            numCols = (n + numRows - 1) / numRows;
            numRows = (n + numCols - 1) / numCols;
        }
        height = numRows * this.compHeight + (numRows - 1) * this.vgap;
        int width = numCols * this.compWidth + (numCols - 1) * this.hgap;
        Dimension d = new Dimension(width + insets.left + insets.right + 2, height + insets.top + insets.bottom + 2);
        return d;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        return new Dimension(this.compWidth + insets.left + insets.right, this.compHeight + insets.top + insets.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.computeComponentSize(parent);
        int n = parent.getComponentCount();
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int parentWidth = d.width - insets.left - insets.right;
        int parentHeight = d.height - insets.top - insets.bottom;
        int numRows = 1;
        int numCols = 1;
        if (this.orientation == 0) {
            numCols = (parentWidth + this.hgap) / (this.compWidth + this.hgap);
            if (numCols < 1) {
                numCols = 1;
            }
            numRows = (n + numCols - 1) / numCols;
            numCols = (n + numRows - 1) / numRows;
        } else {
            numRows = (parentHeight + this.vgap) / (this.compHeight + this.vgap);
            if (numRows < 1) {
                numRows = 1;
            }
            numCols = (n + numRows - 1) / numRows;
            numRows = (n + numCols - 1) / numCols;
        }
        int left = insets.left;
        int top = insets.top;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                int k;
                int x = left + j * (this.compWidth + this.hgap);
                int y = top + i * (this.compHeight + this.vgap);
                int n2 = k = this.fillOrder == 0 ? i * numCols + j : j * numRows + i;
                if (k >= n) continue;
                Component c = parent.getComponent(k);
                c.setBounds(x, y, this.compWidth, this.compHeight);
            }
        }
    }

    private void computeComponentSize(Container parent) {
        int n = parent.getComponentCount();
        this.compWidth = 0;
        this.compHeight = 0;
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            this.compWidth = Math.max(this.compWidth, d.width);
            this.compHeight = Math.max(this.compHeight, d.height);
        }
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

