/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import org.jmol.jvxl.readers.VolumeFileReader;

public abstract class PeriodicVolumeFileReader
extends VolumeFileReader {
    @Override
    protected void readSurfaceData(boolean isMapData) throws Exception {
        this.initializeSurfaceData();
        this.newVoxelDataCube();
        this.getPeriodicVoxels();
        if (this.params.extendGrid != 0.0f) {
            int[] n = new int[3];
            int nx = this.nPointsX - 1;
            int ny = this.nPointsY - 1;
            int nz = this.nPointsZ - 1;
            for (int i = 0; i < 3; ++i) {
                int vi = this.voxelCounts[i] - 1;
                n[i] = (int)((float)vi * this.params.extendGrid);
                this.volumetricOrigin.scaleAdd2(-n[i], this.volumetricVectors[i], this.volumetricOrigin);
                vi += 2 * n[i];
                while (n[i] > 0) {
                    int n2 = i;
                    n[n2] = n[n2] - (this.voxelCounts[i] - 1);
                }
                this.voxelCounts[i] = vi + 1;
            }
            this.nPointsX = this.voxelCounts[0];
            this.nPointsY = this.voxelCounts[1];
            this.nPointsZ = this.voxelCounts[2];
            float[][][] vd = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
            int i = this.nPointsX;
            while (--i >= 0) {
                int j = this.nPointsY;
                while (--j >= 0) {
                    int k = this.nPointsZ;
                    while (--k >= 0) {
                        vd[i][j][k] = this.voxelData[(i - n[0]) % nx][(j - n[1]) % ny][(k - n[2]) % nz];
                    }
                }
            }
            this.voxelData = vd;
        } else {
            int j;
            int i;
            int n = this.nPointsX - 1;
            for (i = 0; i < this.nPointsY; ++i) {
                for (j = 0; j < this.nPointsZ; ++j) {
                    this.voxelData[n][i][j] = this.voxelData[0][i][j];
                }
            }
            n = this.nPointsY - 1;
            for (i = 0; i < this.nPointsX; ++i) {
                for (j = 0; j < this.nPointsZ; ++j) {
                    this.voxelData[i][n][j] = this.voxelData[i][0][j];
                }
            }
            n = this.nPointsZ - 1;
            for (i = 0; i < this.nPointsX; ++i) {
                for (j = 0; j < this.nPointsY; ++j) {
                    this.voxelData[i][j][n] = this.voxelData[i][j][0];
                }
            }
        }
        if (isMapData && this.volumeData.hasPlane()) {
            this.volumeData.setVoxelMap();
            for (int x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        float f = this.volumeData.getToPlaneParameter();
                        if (!this.volumeData.isNearPlane(x, y, z, f)) continue;
                        this.volumeData.setVoxelMapValue(x, y, z, this.voxelData[x][y][z]);
                    }
                }
            }
            this.voxelData = null;
        }
        this.volumeData.setVoxelDataAsArray(this.voxelData);
        if (this.dataMin > this.params.cutoff) {
            this.params.cutoff = 2.0f * this.dataMin;
        }
    }

    protected abstract void getPeriodicVoxels() throws Exception;
}

