/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Text;
import org.jmol.util.Font;
import org.jmol.viewer.Viewer;

class TextRenderer {
    static final int MODE_IS_ANTIALIASED = 4;

    TextRenderer() {
    }

    static boolean render(Viewer vwr, Text text, JmolRendererInterface g3d, float scalePixelsPerMicron, float imageFontScaling, float[] boxXY, float[] temp, P3i pTemp, short pointerColix, int pointerWidth, int mode) {
        int barPixels;
        if (text == null || text.image == null && !text.doFormatText && text.lines == null) {
            return false;
        }
        boolean isAbsolute = (mode & 0x40) != 0;
        boolean doPointer = (mode & 1) != 0;
        boolean isAntialiased = (mode & 4) != 0;
        short colix = text.colix;
        boolean showText = g3d.setC(colix);
        if (!(showText || text.image != null || text.bgcolix != 0 && g3d.setC(text.bgcolix))) {
            return false;
        }
        if (text.isEcho && text.valign == 4) {
            TextRenderer.calcBarPixelsXYZ(vwr, text, pTemp, false);
        }
        text.setPosition(scalePixelsPerMicron, imageFontScaling, isAbsolute, boxXY);
        int n = barPixels = text.isEcho && text.valign == 4 ? TextRenderer.calcBarPixelsXYZ(vwr, text, pTemp, false) : text.barPixels;
        if (text.image == null) {
            if (text.bgcolix != 0) {
                if (g3d.setC(text.bgcolix)) {
                    TextRenderer.showBox(g3d, text.colix, (int)text.boxX - (barPixels == 0 ? 0 : barPixels + 4), (int)text.boxY + text.boxYoff2 * 2, text.z + 2, text.zSlab, (int)text.boxWidth + barPixels, (int)text.boxHeight, text.fontScale, !text.isEcho);
                }
                if (!showText) {
                    return false;
                }
            }
            for (int i = 0; i < text.lines.length; ++i) {
                text.setXYA(temp, i);
                if (text.xyz != null) {
                    temp[1] = temp[1] + 2.0f;
                }
                g3d.drawString(text.lines[i], text.font, (int)temp[0], (int)temp[1], text.z, text.zSlab, text.bgcolix);
            }
            if (text.barPixels > 0) {
                TextRenderer.renderScale(g3d, text, temp, barPixels, isAntialiased);
            }
        } else {
            g3d.drawImage(text.image, (int)text.boxX, (int)text.boxY, text.z, text.zSlab, text.bgcolix, (int)text.boxWidth, (int)text.boxHeight);
        }
        if (!doPointer) {
            return true;
        }
        TextRenderer.drawLineXYZ(g3d, text.atomX, text.atomY, text.atomZ, text.boxX, text.boxY, text.zSlab, text.boxWidth, text.boxHeight, pointerColix, pointerWidth * (isAntialiased ? 2 : 1));
        return true;
    }

    static int calcBarPixelsXYZ(Viewer vwr, Text t, P3i pTemp, boolean andSet) {
        int barPixels = t.barPixels;
        if (t.xyz != null) {
            vwr.tm.transformPtScr(t.xyz, pTemp);
            if (andSet) {
                t.setXYZs(pTemp.x, pTemp.y, pTemp.z, pTemp.z);
            }
            if (barPixels > 0 && vwr.tm.perspectiveDepth) {
                float d = vwr.tm.unscaleToScreen(pTemp.z, barPixels);
                barPixels = t.barPixelsXYZ = (int)((float)barPixels * t.barDistance / d);
            }
        }
        return barPixels;
    }

    private static void renderScale(JmolRendererInterface g3d, Text text, float[] temp, int barPixels, boolean isAntialiased) {
        int z = text.z;
        int xoff = text.xyz == null ? 0 : 2;
        int ia = isAntialiased ? 2 : 1;
        int i = 1;
        int x1 = xoff + (int)temp[0] - barPixels - i - ia * 2;
        int x2 = xoff + (int)temp[0] - i - ia * 2;
        int h = text.lineHeight / 2;
        int y = (int)temp[1] - i;
        g3d.fillTextRect(x1, y - h / 2 - ia, z, text.zSlab, x2 - x1, 2 * ia);
        g3d.fillTextRect(x1, y - h * 2 / 2, z, text.zSlab, 2 * ia, h * 2 / 2);
        g3d.fillTextRect(x2, y - h * 2 / 2, z, text.zSlab, 2 * ia, h * 2 / 2);
        for (int j = 1; j < 10; ++j) {
            int x1b = x1 + j * barPixels / 10;
            int len = j == 5 ? h : h / 2;
            g3d.fillTextRect(x1b, y - len, z, text.zSlab, 2 * ia, len);
        }
    }

    private static void drawLineXYZ(JmolRendererInterface g3d, int x0, int y0, int z0, float x1, float y1, int z1, float w, float h, short pointerColix, int pointerWidth) {
        boolean setY;
        float offsetX = x1 - (float)x0;
        float offsetY = y1 - (float)y0;
        if (offsetX <= 0.0f && -offsetX <= w && offsetY <= 0.0f && -offsetY <= h) {
            return;
        }
        boolean setX = offsetY > 0.0f || offsetY < -h;
        float pt = Float.NaN;
        x1 += setX ? (offsetX > w / 2.0f ? 0.0f : (offsetX < -w * 3.0f / 2.0f ? w : (pt = w / 2.0f))) : (offsetX > 0.0f ? 0.0f : w);
        boolean bl = setY = !Float.isNaN(pt);
        y1 += setY && offsetY > 0.0f ? 0.0f : (setY && offsetY < -h ? h : h / 2.0f);
        if (pointerWidth > 1) {
            g3d.fillCylinderXYZ(pointerColix, pointerColix, (byte)2, pointerWidth, x0, y0, z0, (int)x1, (int)y1, z1);
        } else {
            g3d.setC(pointerColix);
            g3d.drawLineXYZ(x0, y0, z0, (int)x1, (int)y1, z1);
        }
    }

    static void renderSimpleLabel(JmolRendererInterface g3d, Font font, String strLabel, short colix, short bgcolix, float[] boxXY, int z, int zSlab, int xOffset, int yOffset, float ascent, int descent, short pointerColix, int pointerWidth, int mode) {
        float w = font.stringWidth(strLabel) + 8;
        float h = ascent + (float)descent + 8.0f;
        int x0 = (int)boxXY[0];
        int y0 = (int)boxXY[1];
        boolean isAbsolute = (mode & 0x40) != 0;
        boolean doPointer = (mode & 1) != 0;
        boolean isAntialiased = (mode & 4) != 0;
        Text.setBoxXY(w, h, xOffset, yOffset, boxXY, isAbsolute);
        float x = boxXY[0];
        float y = boxXY[1];
        if (bgcolix != 0 && g3d.setC(bgcolix)) {
            TextRenderer.showBox(g3d, colix, (int)x, (int)y, z, zSlab, (int)w, (int)h, 1.0f, true);
        } else {
            g3d.setC(colix);
        }
        g3d.drawString(strLabel, font, (int)(x + 4.0f), (int)(y + 4.0f + ascent), z - 1, zSlab, bgcolix);
        if (doPointer && (xOffset != 0 || yOffset != 0)) {
            TextRenderer.drawLineXYZ(g3d, x0, y0, zSlab, x, y, zSlab, w, h, pointerColix, pointerWidth * (isAntialiased ? 2 : 1));
        }
    }

    private static void showBox(JmolRendererInterface g3d, short colix, int x, int y, int z, int zSlab, int boxWidth, int boxHeight, float imageFontScaling, boolean atomBased) {
        g3d.fillTextRect(x, y, z, zSlab, boxWidth, boxHeight);
        g3d.setC(colix);
        if (!atomBased) {
            return;
        }
        if (imageFontScaling >= 2.0f) {
            g3d.drawRect(x + 3, y + 3, z - 1, zSlab, boxWidth - 6, boxHeight - 6);
        } else {
            g3d.drawRect(x + 1, y + 1, z - 1, zSlab, boxWidth - 2, boxHeight - 2);
        }
    }
}

