/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.util.SimpleUnitCell;

public abstract class SpecialGroup
extends SpaceGroup {
    protected Symmetry embeddingSymmetry;

    SpecialGroup(Symmetry sym, Map<String, Object> info, int type) {
        super(-1, null, true);
        this.embeddingSymmetry = sym;
        this.groupType = type;
        if (info == null) {
            return;
        }
        this.initSpecial(info);
    }

    private void initSpecial(Map<String, Object> info) {
        Lst ops = (Lst)info.get("gp");
        for (int i = 0; i < ops.size(); ++i) {
            this.addOperation((String)ops.get(i), 0, false);
        }
        this.setTransform((String)info.get("trm"));
        this.itaNumber = "" + info.get("sg");
        this.itaIndex = "" + info.get("set");
        this.specialPrefix = SpecialGroup.getGroupTypePrefix(this.groupType);
        this.setHMSymbol((String)info.get("hm"));
        this.setITATableNames(null, this.itaNumber, this.itaIndex, this.itaTransform);
    }

    void setTransform(String transform) {
        this.itaTransform = transform;
    }

    public boolean checkCompatible(float[] params, float[] newParams, boolean allowSame, int monoclinic_oblique, int monoclinic_orthogonal, int orthorhombic, int tetragonal) {
        boolean isHex;
        int n = this.itaNumber == null ? 0 : PT.parseInt(this.itaNumber);
        boolean toHex = n != 0 && this.isHexagonalSG(n, null);
        boolean bl = isHex = toHex && this.isHexagonalSG(-1, params);
        if (toHex && isHex) {
            allowSame = true;
        }
        SpaceGroup.ParamCheck pc = new SpaceGroup.ParamCheck(params, allowSame, true);
        if (n > (allowSame ? 2 : 0)) {
            if (toHex) {
                pc.b = pc.a;
                pc.beta = 90.0f;
                pc.alpha = 90.0f;
                pc.gamma = 120.0f;
            } else if (n >= tetragonal) {
                pc.b = pc.a;
                if (pc.acsame && !allowSame) {
                    pc.c = pc.a * 1.5f;
                }
                pc.gamma = 90.0f;
                pc.beta = 90.0f;
                pc.alpha = 90.0f;
            } else if (n >= orthorhombic) {
                pc.gamma = 90.0f;
                pc.beta = 90.0f;
                pc.alpha = 90.0f;
            } else if (n >= monoclinic_orthogonal) {
                pc.beta = 90.0f;
                if (this.groupType == 400) {
                    pc.gamma = 90.0f;
                } else {
                    pc.alpha = 90.0f;
                }
            } else if (n >= monoclinic_oblique) {
                pc.beta = 90.0f;
                if (this.groupType == 400) {
                    pc.alpha = 90.0f;
                } else {
                    pc.gamma = 90.0f;
                }
            }
        }
        return pc.checkNew(params, newParams == null ? params : newParams);
    }

    static class FriezeGroup
    extends SpecialGroup {
        protected FriezeGroup(Symmetry sym, Map<String, Object> info) {
            super(sym, info, 600);
            this.nDim = 2;
            this.periodicity = 1;
        }

        @Override
        public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
            boolean isNew;
            float a = params[0];
            float b = params[0];
            float c = -1.0f;
            float alpha = 90.0f;
            float beta = 90.0f;
            float gamma = 90.0f;
            boolean bl = isNew = a != params[0] || b != params[1] || c != params[2] || alpha != params[3] || beta != params[4] || gamma != params[5];
            if (newParams == null) {
                newParams = params;
            }
            newParams[0] = a;
            newParams[1] = b;
            newParams[2] = c;
            newParams[3] = alpha;
            newParams[4] = beta;
            newParams[5] = gamma;
            return isNew;
        }
    }

    static class RodGroup
    extends SpecialGroup {
        protected RodGroup(Symmetry sym, Map<String, Object> info) {
            super(sym, info, 500);
            this.nDim = 3;
            if (info != null) {
                this.periodicity = this.setRodPeriodicityFromTrm(info);
            }
        }

        private int setRodPeriodicityFromTrm(Map<String, Object> info) {
            int sg = ((Number)info.get("sg")).intValue();
            if (sg < 3 || sg > 22) {
                return 4;
            }
            String trm = (String)info.get("trm");
            if (trm.endsWith("c")) {
                return 4;
            }
            return trm.indexOf(99) < trm.indexOf(44) ? 1 : 2;
        }

        @Override
        public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
            return this.checkCompatible(params, newParams, allowSame, 3, 8, 13, 23);
        }

        @Override
        public boolean isHexagonalSG(int n, float[] params) {
            return n < 1 ? SimpleUnitCell.isHexagonal(params) : n >= 42;
        }
    }

    static class LayerGroup
    extends SpecialGroup {
        protected LayerGroup(Symmetry sym, Map<String, Object> info) {
            super(sym, info, 400);
            this.nDim = 3;
            this.periodicity = 3;
        }

        @Override
        public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
            return this.checkCompatible(params, newParams, allowSame, 3, 8, 19, 49);
        }

        @Override
        public boolean isHexagonalSG(int n, float[] params) {
            return n < 1 ? SimpleUnitCell.isHexagonal(params) : n >= 65;
        }
    }

    static class PlaneGroup
    extends SpecialGroup {
        protected PlaneGroup(Symmetry sym, Map<String, Object> info) {
            super(sym, info, 300);
            this.nDim = 2;
            this.periodicity = 3;
        }

        @Override
        public boolean createCompatibleUnitCell(float[] params, float[] newParams, boolean allowSame) {
            int n = this.itaNumber == null ? 0 : PT.parseInt(this.itaNumber);
            boolean toHex = false;
            boolean isHex = false;
            toHex = n != 0 && this.isHexagonalSG(n, null);
            boolean bl = isHex = toHex && this.isHexagonalSG(-1, params);
            if (toHex && isHex) {
                allowSame = true;
            }
            SpaceGroup.ParamCheck pc = new SpaceGroup.ParamCheck(params, allowSame, false);
            pc.c = 0.5f;
            pc.beta = 90.0f;
            pc.alpha = 90.0f;
            if (n > (allowSame ? 2 : 0)) {
                if (toHex) {
                    pc.b = pc.a;
                    pc.gamma = 120.0f;
                } else if (n >= 10) {
                    pc.b = pc.a;
                    pc.gamma = 90.0f;
                } else if (n >= 3) {
                    pc.gamma = 90.0f;
                }
            }
            return pc.checkNew(params, newParams == null ? params : newParams);
        }

        @Override
        public boolean isHexagonalSG(int n, float[] params) {
            return n < 1 ? SimpleUnitCell.isHexagonal(params) : n >= 13;
        }
    }
}

