/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Map;
import javajs.util.BS;

public final class BSUtil {
    public static final BS emptySet = new BS();

    public static BS newAndSetBit(int i) {
        BS bs = BS.newN(i + 1);
        bs.set(i);
        return bs;
    }

    public static boolean areEqual(BS a, BS b) {
        return a == null || b == null ? a == null && b == null : a.equals(b);
    }

    public static boolean haveCommon(BS a, BS b) {
        return a == null || b == null ? false : a.intersects(b);
    }

    public static int cardinalityOf(BS bs) {
        return bs == null ? 0 : bs.cardinality();
    }

    public static BS newBitSet2(int i0, int i1) {
        BS bs = BS.newN(i1);
        bs.setBits(i0, i1);
        return bs;
    }

    public static BS setAll(int n) {
        BS bs = BS.newN(n);
        bs.setBits(0, n);
        return bs;
    }

    public static BS andNot(BS a, BS b) {
        if (b != null && a != null) {
            a.andNot(b);
        }
        return a;
    }

    public static BS copy(BS bs) {
        return bs == null ? null : (BS)bs.clone();
    }

    public static BS copy2(BS a, BS b) {
        if (a == null || b == null) {
            return null;
        }
        b.clearAll();
        b.or(a);
        return b;
    }

    public static BS copyInvert(BS bs, int n) {
        return bs == null ? null : BSUtil.andNot(BSUtil.setAll(n), bs);
    }

    public static BS invertInPlace(BS bs, int n) {
        return BSUtil.copy2(BSUtil.copyInvert(bs, n), bs);
    }

    public static BS toggleInPlace(BS a, BS b) {
        if (a.equals(b)) {
            a.clearAll();
        } else if (BSUtil.andNot(BSUtil.copy(b), a).length() == 0) {
            BSUtil.andNot(a, b);
        } else {
            a.or(b);
        }
        return a;
    }

    public static BS deleteBits(BS bs, BS bsDelete) {
        if (bs == null || bsDelete == null) {
            return bs;
        }
        int ipt = bsDelete.nextSetBit(0);
        if (ipt < 0) {
            return bs;
        }
        int len = bs.length();
        int lend = Math.min(len, bsDelete.length());
        int i = bsDelete.nextClearBit(ipt);
        while (i < lend && i >= 0) {
            bs.setBitTo(ipt++, bs.get(i));
            i = bsDelete.nextClearBit(i + 1);
        }
        for (i = lend; i < len; ++i) {
            bs.setBitTo(ipt++, bs.get(i));
        }
        if (ipt < len) {
            bs.clearBits(ipt, len);
        }
        return bs;
    }

    public static void shiftBits(BS bs, BS bsAdded, boolean setIfFound, int iLast) {
        if (bs == null || bsAdded == null) {
            return;
        }
        int n = bsAdded.length();
        BS bsNew = BS.newN(n);
        boolean isFound = false;
        boolean doSet = false;
        boolean checkFound = setIfFound;
        int i = 0;
        for (int j = 0; j < n && i < iLast; ++j) {
            if (bsAdded.get(j)) {
                if (doSet) {
                    bsNew.set(j);
                }
                checkFound = setIfFound;
                isFound = false;
                continue;
            }
            if (bs.get(i++)) {
                bsNew.set(j);
                if (!checkFound) continue;
                checkFound = false;
                isFound = true;
                doSet = true;
                continue;
            }
            if (!checkFound || isFound) continue;
            doSet = false;
        }
        bs.clearAll();
        bs.or(bsNew);
    }

    public static void offset(BS bs0, int pos, int offset) {
        if (bs0 == null) {
            return;
        }
        BS bsTemp = BS.newN(bs0.length() + offset);
        int i = bs0.nextSetBit(0);
        while (i >= pos) {
            bsTemp.set(i + offset);
            i = bs0.nextSetBit(i + 1);
        }
        BSUtil.copy2(bsTemp, bs0);
    }

    public static void setMapBitSet(Map<String, BS> ht, int i1, int i2, String key) {
        BS bs;
        if (ht.containsKey(key)) {
            bs = ht.get(key);
        } else {
            bs = new BS();
            ht.put(key, bs);
        }
        bs.setBits(i1, i2 + 1);
    }
}

