/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams.topics;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.coordinator.group.streams.topics.ConfiguredInternalTopic;

public record ConfiguredSubtopology(int numberOfTasks, Set<String> sourceTopics, Map<String, ConfiguredInternalTopic> repartitionSourceTopics, Set<String> repartitionSinkTopics, Map<String, ConfiguredInternalTopic> stateChangelogTopics) {
    public ConfiguredSubtopology {
        if (numberOfTasks <= 0) {
            throw new IllegalArgumentException("Number of tasks must be positive");
        }
        Objects.requireNonNull(sourceTopics, "sourceTopics can't be null");
        Objects.requireNonNull(repartitionSourceTopics, "repartitionSourceTopics can't be null");
        Objects.requireNonNull(repartitionSinkTopics, "repartitionSinkTopics can't be null");
        Objects.requireNonNull(stateChangelogTopics, "stateChangelogTopics can't be null");
    }

    public StreamsGroupDescribeResponseData.Subtopology asStreamsGroupDescribeSubtopology(String subtopologyId) {
        return new StreamsGroupDescribeResponseData.Subtopology().setSubtopologyId(subtopologyId).setSourceTopics(this.sourceTopics.stream().sorted().toList()).setRepartitionSinkTopics(this.repartitionSinkTopics.stream().sorted().toList()).setRepartitionSourceTopics(this.repartitionSourceTopics.values().stream().map(ConfiguredInternalTopic::asStreamsGroupDescribeTopicInfo).sorted(Comparator.comparing(StreamsGroupDescribeResponseData.TopicInfo::name)).toList()).setStateChangelogTopics(this.stateChangelogTopics.values().stream().map(ConfiguredInternalTopic::asStreamsGroupDescribeTopicInfo).sorted(Comparator.comparing(StreamsGroupDescribeResponseData.TopicInfo::name)).toList());
    }
}

