/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.server.share.persister.GroupTopicPartitionData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PartitionStateData;
import org.apache.kafka.server.share.persister.PersisterParameters;
import org.apache.kafka.server.share.persister.TopicData;

public class InitializeShareGroupStateParameters
implements PersisterParameters {
    private final GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData;

    private InitializeShareGroupStateParameters(GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData) {
        this.groupTopicPartitionData = groupTopicPartitionData;
    }

    public GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData() {
        return this.groupTopicPartitionData;
    }

    public static InitializeShareGroupStateParameters from(InitializeShareGroupStateRequestData data) {
        return new Builder().setGroupTopicPartitionData(new GroupTopicPartitionData<PartitionStateData>(data.groupId(), data.topics().stream().map(readStateData -> new TopicData<PartitionStateData>(readStateData.topicId(), readStateData.partitions().stream().map(partitionData -> PartitionFactory.newPartitionStateData(partitionData.partition(), partitionData.stateEpoch(), partitionData.startOffset())).toList())).toList())).build();
    }

    public String toString() {
        return "InitializeShareGroupStateParameters{groupTopicPartitionData=" + String.valueOf(this.groupTopicPartitionData) + "}";
    }

    public static class Builder {
        private GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData;

        public Builder setGroupTopicPartitionData(GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData) {
            this.groupTopicPartitionData = groupTopicPartitionData;
            return this;
        }

        public InitializeShareGroupStateParameters build() {
            return new InitializeShareGroupStateParameters(this.groupTopicPartitionData);
        }
    }
}

