/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.ShareGroupDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeShareGroupsResult {
    private final Map<String, KafkaFuture<ShareGroupDescription>> futures;

    public DescribeShareGroupsResult(Map<String, KafkaFuture<ShareGroupDescription>> futures) {
        this.futures = futures;
    }

    public Map<String, KafkaFuture<ShareGroupDescription>> describedGroups() {
        return new HashMap<String, KafkaFuture<ShareGroupDescription>>(this.futures);
    }

    public KafkaFuture<Map<String, ShareGroupDescription>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap descriptions = new HashMap(this.futures.size());
            this.futures.forEach((key, future) -> {
                try {
                    descriptions.put(key, (ShareGroupDescription)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return descriptions;
        });
    }
}

