/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.QueryResult;

@InterfaceStability.Evolving
public class StateQueryResult<R> {
    private final Map<Integer, QueryResult<R>> partitionResults = new HashMap<Integer, QueryResult<R>>();
    private QueryResult<R> globalResult = null;

    public void setGlobalResult(QueryResult<R> r) {
        this.globalResult = r;
    }

    public void addResult(int partition, QueryResult<R> r) {
        this.partitionResults.put(partition, r);
    }

    public Map<Integer, QueryResult<R>> getPartitionResults() {
        return this.partitionResults;
    }

    public QueryResult<R> getOnlyPartitionResult() {
        List nonempty = this.partitionResults.values().stream().filter(QueryResult::isSuccess).filter(r -> r.getResult() != null).collect(Collectors.toList());
        if (nonempty.size() > 1) {
            throw new IllegalArgumentException("The query did not return exactly one partition result: " + String.valueOf(this.partitionResults));
        }
        return nonempty.isEmpty() ? null : (QueryResult)nonempty.get(0);
    }

    public QueryResult<R> getGlobalResult() {
        return this.globalResult;
    }

    public Position getPosition() {
        if (this.globalResult != null) {
            return this.globalResult.getPosition();
        }
        Position position = Position.emptyPosition();
        for (QueryResult<R> r : this.partitionResults.values()) {
            position.merge(r.getPosition());
        }
        return position;
    }

    public String toString() {
        return "StateQueryResult{partitionResults=" + String.valueOf(this.partitionResults) + ", globalResult=" + String.valueOf(this.globalResult) + "}";
    }
}

