/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.coordinator.transaction.TransactionState;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.server.common.TransactionVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r}tA\u0002*T\u0011\u0003\u0019\u0016L\u0002\u0004\\'\"\u00051\u000b\u0018\u0005\u0006G\u0006!\t!\u001a\u0005\u0006M\u0006!\ta\u001a\u0005\ba\u0006\t\n\u0011\"\u0001r\r\u0015Y6\u000bA*\u0000\u0011)\ti!\u0002BC\u0002\u0013\u0005\u0011q\u0002\u0005\u000b\u0003O)!\u0011!Q\u0001\n\u0005E\u0001BCA\u0015\u000b\t\u0005\r\u0011\"\u0001\u0002,!Q\u0011QF\u0003\u0003\u0002\u0004%\t!a\f\t\u0013\u0005mRA!A!B\u0013\u0019\bBCA\u001f\u000b\t\u0005\r\u0011\"\u0001\u0002,!Q\u0011qH\u0003\u0003\u0002\u0004%\t!!\u0011\t\u0013\u0005\u0015SA!A!B\u0013\u0019\bBCA$\u000b\t\u0005\r\u0011\"\u0001\u0002,!Q\u0011\u0011J\u0003\u0003\u0002\u0004%\t!a\u0013\t\u0013\u0005=SA!A!B\u0013\u0019\b\"\u00037\u0006\u0005\u0003\u0007I\u0011AA)\u0011)\t\u0019&\u0002BA\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u00033*!\u0011!Q!\n5D!\"a\u0017\u0006\u0005\u0003\u0007I\u0011AA)\u0011)\ti&\u0002BA\u0002\u0013\u0005\u0011q\f\u0005\n\u0003G*!\u0011!Q!\n5D!\"!\u001a\u0006\u0005\u0003\u0007I\u0011AA4\u0011)\ty'\u0002BA\u0002\u0013\u0005\u0011\u0011\u000f\u0005\u000b\u0003k*!\u0011!Q!\n\u0005%\u0004BCA<\u000b\t\u0005\r\u0011\"\u0001\u0002z!Q\u0011\u0011S\u0003\u0003\u0002\u0004%\t!a%\t\u0015\u0005]UA!A!B\u0013\tY\b\u0003\u0006\u0002\u001a\u0016\u0011\t\u0019!C\u0001\u00037C!\"!/\u0006\u0005\u0003\u0007I\u0011AA^\u0011)\ty,\u0002B\u0001B\u0003&\u0011Q\u0014\u0005\u000b\u0003\u0003,!\u00111A\u0005\u0002\u0005-\u0002BCAb\u000b\t\u0005\r\u0011\"\u0001\u0002F\"I\u0011\u0011Z\u0003\u0003\u0002\u0003\u0006Ka\u001d\u0005\u000b\u0003',!\u00111A\u0005\u0002\u0005-\u0002BCAk\u000b\t\u0005\r\u0011\"\u0001\u0002X\"I\u00111\\\u0003\u0003\u0002\u0003\u0006Ka\u001d\u0005\u000b\u0003?,!\u00111A\u0005\u0002\u0005\u0005\bBCAy\u000b\t\u0005\r\u0011\"\u0001\u0002t\"Q\u0011q_\u0003\u0003\u0002\u0003\u0006K!a9\t\r\r,A\u0011AA}\u0011%\u0011)\"\u0002a\u0001\n\u0003\u00119\u0002C\u0005\u0003 \u0015\u0001\r\u0011\"\u0001\u0003\"!A!QE\u0003!B\u0013\u0011I\u0002C\u0005\u0003(\u0015\u0001\r\u0011\"\u0001\u0003*!I!1F\u0003A\u0002\u0013\u0005!Q\u0006\u0005\b\u0005c)\u0001\u0015)\u0003i\u0011)\u0011\u0019$\u0002b\u0001\n\u0003\u0019&Q\u0007\u0005\t\u0005\u001f*\u0001\u0015!\u0003\u00038!9!\u0011K\u0003\u0005\u0002\tM\u0003b\u0002B<\u000b\u0011\u0005!\u0011\u0010\u0005\b\u0005\u000b+A\u0011\u0001BD\u0011\u001d\u0011i)\u0002C\u0001\u0005\u001fCqAa&\u0006\t\u0003\u0011y\tC\u0004\u0003\u001a\u0016!\tAa'\t\u000f\t%W\u0001\"\u0001\u0003L\"9!\u0011\\\u0003\u0005\u0002\tm\u0007b\u0002Bx\u000b\u0011\u0005!\u0011\u001f\u0005\b\u0007\u0003)A\u0011AB\u0002\u0011\u001d\u00199!\u0002C\u0001\u0005\u001fCqa!\u0003\u0006\t\u0003\u0011I\u0003C\u0004\u0004\f\u0015!\tA!\u000b\t\u000f\r5Q\u0001\"\u0003\u0003*!91qB\u0003\u0005\n\rE\u0001\u0002CB\u0014\u000bE\u0005I\u0011B9\t\u0011\r%R!%A\u0005\nED\u0011ba\u000b\u0006#\u0003%Ia!\f\t\u0013\rER!%A\u0005\n\r5\u0002\"CB\u001a\u000bE\u0005I\u0011BB\u001b\u0011%\u0019I$BI\u0001\n\u0013\u0019Y\u0004\u0003\u0005\u0004@\u0015\t\n\u0011\"\u0003r\u0011!\u0019\t%BI\u0001\n\u0013\t\b\"CB\"\u000bE\u0005I\u0011BB#\u0011\u001d\u0019I%\u0002C\u0001\u0007\u0017Bqa!\u0015\u0006\t\u0013\u0019\u0019\u0006C\u0004\u0004X\u0015!Ia!\u0017\t\u000f\ruS\u0001\"\u0003\u0004`!91QM\u0003\u0005\u0002\t%\u0002bBB4\u000b\u0011\u00053\u0011\u000e\u0005\b\u0007W*A\u0011IB7\u0011\u001d\u0019\u0019(\u0002C!\u0007k\n1\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006T!\u0001V+\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003-^\u000b1bY8pe\u0012Lg.\u0019;pe*\t\u0001,A\u0003lC\u001a\\\u0017\r\u0005\u0002[\u00035\t1KA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018m\u0005\u0002\u0002;B\u0011a,Y\u0007\u0002?*\t\u0001-A\u0003tG\u0006d\u0017-\u0003\u0002c?\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u00023\u0006\u0001\u0012n]#q_\u000eDW\t\u001f5bkN$X\r\u001a\u000b\u0003Q.\u0004\"AX5\n\u0005)|&a\u0002\"p_2,\u0017M\u001c\u0005\u0006Y\u000e\u0001\r!\\\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0005ys\u0017BA8`\u0005\u0015\u0019\u0006n\u001c:u\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA*\u0012A\u001d\u0016\u0003gZ\u0004\"A\u0018;\n\u0005U|&\u0001\u0002'p]\u001e\\\u0013a\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005q|\u0016AC1o]>$\u0018\r^5p]&\u0011a0\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7\u0003B\u0003^\u0003\u0003\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f9\u0016!B;uS2\u001c\u0018\u0002BA\u0006\u0003\u000b\u0011q\u0001T8hO&tw-A\bue\u0006t7/Y2uS>t\u0017\r\\%e+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005\u0005b\u0002BA\u000b\u0003;\u00012!a\u0006`\u001b\t\tIBC\u0002\u0002\u001c\u0011\fa\u0001\u0010:p_Rt\u0014bAA\u0010?\u00061\u0001K]3eK\u001aLA!a\t\u0002&\t11\u000b\u001e:j]\u001eT1!a\b`\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007%\u0001\u0006qe>$WoY3s\u0013\u0012,\u0012a]\u0001\u000faJ|G-^2fe&#w\fJ3r)\u0011\t\t$a\u000e\u0011\u0007y\u000b\u0019$C\u0002\u00026}\u0013A!\u00168ji\"A\u0011\u0011H\u0005\u0002\u0002\u0003\u00071/A\u0002yIE\n1\u0002\u001d:pIV\u001cWM]%eA\u0005q\u0001O]3w!J|G-^2fe&#\u0017A\u00059sKZ\u0004&o\u001c3vG\u0016\u0014\u0018\nZ0%KF$B!!\r\u0002D!A\u0011\u0011\b\u0007\u0002\u0002\u0003\u00071/A\bqe\u00164\bK]8ek\u000e,'/\u00133!\u00039qW\r\u001f;Qe>$WoY3s\u0013\u0012\f!C\\3yiB\u0013x\u000eZ;dKJLEm\u0018\u0013fcR!\u0011\u0011GA'\u0011!\tIdDA\u0001\u0002\u0004\u0019\u0018a\u00048fqR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0016\u00035\f\u0011\u0003\u001d:pIV\u001cWM]#q_\u000eDw\fJ3r)\u0011\t\t$a\u0016\t\u0011\u0005e\"#!AA\u00025\fa\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007%A\tmCN$\bK]8ek\u000e,'/\u00129pG\"\fQ\u0003\\1tiB\u0013x\u000eZ;dKJ,\u0005o\\2i?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005\u0005\u0004\u0002CA\u001d+\u0005\u0005\t\u0019A7\u0002%1\f7\u000f\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eI\u0001\ribtG+[7f_V$Xj]\u000b\u0003\u0003S\u00022AXA6\u0013\r\tig\u0018\u0002\u0004\u0013:$\u0018\u0001\u0005;y]RKW.Z8vi6\u001bx\fJ3r)\u0011\t\t$a\u001d\t\u0013\u0005e\u0002$!AA\u0002\u0005%\u0014!\u0004;y]RKW.Z8vi6\u001b\b%A\u0003ti\u0006$X-\u0006\u0002\u0002|A!\u0011QPAG\u001b\t\tyHC\u0002U\u0003\u0003S1AVAB\u0015\rA\u0016Q\u0011\u0006\u0005\u0003\u000f\u000bI)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\u000b1a\u001c:h\u0013\u0011\ty)a \u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,\u0017!C:uCR,w\fJ3r)\u0011\t\t$!&\t\u0013\u0005e2$!AA\u0002\u0005m\u0014AB:uCR,\u0007%A\bu_BL7\rU1si&$\u0018n\u001c8t+\t\ti\n\u0005\u0004\u0002 \u0006%\u0016QV\u0007\u0003\u0003CSA!a)\u0002&\u00069Q.\u001e;bE2,'bAAT?\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u0004'\u0016$\b\u0003BAX\u0003kk!!!-\u000b\t\u0005M\u00161Q\u0001\u0007G>lWn\u001c8\n\t\u0005]\u0016\u0011\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003M!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\u0011\t\t$!0\t\u0013\u0005eb$!AA\u0002\u0005u\u0015\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003E!\bP\\*uCJ$H+[7fgR\fW\u000e]\u0001\u0016ibt7\u000b^1siRKW.Z:uC6\u0004x\fJ3r)\u0011\t\t$a2\t\u0011\u0005e\u0012%!AA\u0002M\f!\u0003\u001e=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7qA!\u001a!%!4\u0011\u0007y\u000by-C\u0002\u0002R~\u0013\u0001B^8mCRLG.Z\u0001\u0017ibtG*Y:u+B$\u0017\r^3US6,7\u000f^1na\u0006QB\u000f\u001f8MCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011\u0011GAm\u0011!\tI\u0004JA\u0001\u0002\u0004\u0019\u0018a\u0006;y]2\u000b7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9!Q\r)\u0013QZ\u0001\u0019G2LWM\u001c;Ue\u0006t7/Y2uS>tg+\u001a:tS>tWCAAr!\u0011\t)/!<\u000e\u0005\u0005\u001d(\u0002BAZ\u0003STA!a;\u0002\u0004\u000611/\u001a:wKJLA!a<\u0002h\n\u0011BK]1og\u0006\u001cG/[8o-\u0016\u00148/[8o\u0003q\u0019G.[3oiR\u0013\u0018M\\:bGRLwN\u001c,feNLwN\\0%KF$B!!\r\u0002v\"I\u0011\u0011H\u0014\u0002\u0002\u0003\u0007\u00111]\u0001\u001aG2LWM\u001c;Ue\u0006t7/Y2uS>tg+\u001a:tS>t\u0007\u0005\u0006\u000e\u0002|\u0006u\u0018q B\u0001\u0005\u0007\u0011)Aa\u0002\u0003\n\t-!Q\u0002B\b\u0005#\u0011\u0019\u0002\u0005\u0002[\u000b!9\u0011QB\u0015A\u0002\u0005E\u0001BBA\u0015S\u0001\u00071\u000f\u0003\u0004\u0002>%\u0002\ra\u001d\u0005\u0007\u0003\u000fJ\u0003\u0019A:\t\u000b1L\u0003\u0019A7\t\r\u0005m\u0013\u00061\u0001n\u0011\u001d\t)'\u000ba\u0001\u0003SBq!a\u001e*\u0001\u0004\tY\bC\u0004\u0002\u001a&\u0002\r!!(\t\u0011\u0005\u0005\u0017\u0006%AA\u0002MDa!a5*\u0001\u0004\u0019\bbBApS\u0001\u0007\u00111]\u0001\ra\u0016tG-\u001b8h'R\fG/Z\u000b\u0003\u00053\u0001RA\u0018B\u000e\u0003wJ1A!\b`\u0005\u0019y\u0005\u000f^5p]\u0006\u0001\u0002/\u001a8eS:<7\u000b^1uK~#S-\u001d\u000b\u0005\u0003c\u0011\u0019\u0003C\u0005\u0002:-\n\t\u00111\u0001\u0003\u001a\u0005i\u0001/\u001a8eS:<7\u000b^1uK\u0002\n1\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016,\u0012\u0001[\u0001\u0018Q\u0006\u001ch)Y5mK\u0012,\u0005o\\2i\r\u0016t7-Z0%KF$B!!\r\u00030!A\u0011\u0011\b\u0018\u0002\u0002\u0003\u0007\u0001.\u0001\u000biCN4\u0015-\u001b7fI\u0016\u0003xn\u00195GK:\u001cW\rI\u0001\u0005Y>\u001c7.\u0006\u0002\u00038A!!\u0011\bB&\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012!\u00027pG.\u001c(\u0002\u0002B!\u0005\u0007\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011)Ea\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005\u0013\nAA[1wC&!!Q\nB\u001e\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006)An\\2lA\u00051\u0011N\u001c'pG.,BA!\u0016\u0003\\Q!!q\u000bB7!\u0011\u0011IFa\u0017\r\u0001\u00119!Q\f\u001aC\u0002\t}#!\u0001+\u0012\t\t\u0005$q\r\t\u0004=\n\r\u0014b\u0001B3?\n9aj\u001c;iS:<\u0007c\u00010\u0003j%\u0019!1N0\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003pI\"\t\u0019\u0001B9\u0003\r1WO\u001c\t\u0006=\nM$qK\u0005\u0004\u0005kz&\u0001\u0003\u001fcs:\fW.\u001a \u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)\u0011\t\tDa\u001f\t\u000f\tu4\u00071\u0001\u0003\u0000\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\r\t\u0005%1QAW\u001b\t\t)+\u0003\u0003\u0002,\u0006\u0015\u0016a\u0004:f[>4X\rU1si&$\u0018n\u001c8\u0015\t\u0005E\"\u0011\u0012\u0005\b\u0005\u0017#\u0004\u0019AAW\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003\u001d:fa\u0006\u0014XMT8Ue\u0006t7/\u001b;\u0015\u0005\tE\u0005\u0003BA?\u0005'KAA!&\u0002\u0000\t\u0011B\u000b\u001f8Ue\u0006t7/\u001b;NKR\fG-\u0019;b\u0003e\u0001(/\u001a9be\u00164UM\\2f!J|G-^2fe\u0016\u0003xn\u00195\u0002;A\u0014X\r]1sK&s7M]3nK:$\bK]8ek\u000e,'/\u00129pG\"$\u0002B!(\u0003<\n}&Q\u0019\t\t\u0005?\u0013IKa,\u0003\u0012:!!\u0011\u0015BS\u001d\u0011\t9Ba)\n\u0003\u0001L1Aa*`\u0003\u001d\u0001\u0018mY6bO\u0016LAAa+\u0003.\n1Q)\u001b;iKJT1Aa*`!\u0011\u0011\tLa.\u000e\u0005\tM&\u0002\u0002B[\u0003c\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005s\u0013\u0019L\u0001\u0004FeJ|'o\u001d\u0005\b\u0005{;\u0004\u0019AA5\u0003=qWm\u001e+y]RKW.Z8vi6\u001b\bb\u0002Bao\u0001\u0007!1Y\u0001\u0016Kb\u0004Xm\u0019;fIB\u0013x\u000eZ;dKJ,\u0005o\\2i!\u0011q&1D7\t\r\t\u001dw\u00071\u0001t\u0003=)\b\u000fZ1uKRKW.Z:uC6\u0004\u0018!\u00079sKB\f'/\u001a)s_\u0012,8-\u001a:JIJ{G/\u0019;j_:$\"B!%\u0003N\nE'1\u001bBk\u0011\u0019\u0011y\r\u000fa\u0001g\u0006ia.Z<Qe>$WoY3s\u0013\u0012DqA!09\u0001\u0004\tI\u0007\u0003\u0004\u0003Hb\u0002\ra\u001d\u0005\u0007\u0005/D\u0004\u0019\u00015\u0002\u001fI,7m\u001c:e\u0019\u0006\u001cH/\u00129pG\"\fA\u0003\u001d:fa\u0006\u0014X-\u00113e!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0003BI\u0005;\u0014YO!<\t\u000f\t}\u0017\b1\u0001\u0003b\u0006!\u0012\r\u001a3fIR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bAa9\u0003j\u00065VB\u0001Bs\u0015\u0011\u00119/!*\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BAV\u0005KDaAa2:\u0001\u0004\u0019\bbBAps\u0001\u0007\u00111]\u0001\u0015aJ,\u0007/\u0019:f\u0003\n|'\u000f^(s\u0007>lW.\u001b;\u0015\u0019\tE%1\u001fB|\u0005s\u0014YP!@\t\u000f\tU(\b1\u0001\u0002|\u0005Aa.Z<Ti\u0006$X\rC\u0004\u0002`j\u0002\r!a9\t\r\u0005\u001d#\b1\u0001t\u0011\u0019\u00119M\u000fa\u0001g\"1!q \u001eA\u0002!\f\u0001C\\8QCJ$\u0018\u000e^5p]\u0006#G-\u001a3\u0002\u001fA\u0014X\r]1sK\u000e{W\u000e\u001d7fi\u0016$BA!%\u0004\u0006!1!qY\u001eA\u0002M\f1\u0002\u001d:fa\u0006\u0014X\rR3bI\u0006A\u0012n\u001d)s_\u0012,8-\u001a:Fa>\u001c\u0007.\u0012=iCV\u001cH/\u001a3\u0002=%\u001cH)[:ue&\u0014W\u000f^3e)^|\u0007\u000b[1tK\u000e{W.\\5u)bt\u0017!\u00065bgB+g\u000eZ5oOR\u0013\u0018M\\:bGRLwN\\\u0001\u0014aJ,\u0007/\u0019:f)J\fgn]5uS>tGk\u001c\u000b\u0017\u0005#\u001b\u0019b!\u0006\u0004\u0018\re11DB\u000f\u0007?\u0019\tca\t\u0004&!9\u0011q\u000f!A\u0002\u0005m\u0004\u0002CA\u0015\u0001B\u0005\t\u0019A:\t\u0011\u0005\u001d\u0003\t%AA\u0002MDq\u0001\u001c!\u0011\u0002\u0003\u0007Q\u000e\u0003\u0005\u0002\\\u0001\u0003\n\u00111\u0001n\u0011%\t)\u0007\u0011I\u0001\u0002\u0004\tI\u0007C\u0005\u0002\u001a\u0002\u0003\n\u00111\u0001\u0002\u001e\"A\u0011\u0011\u0019!\u0011\u0002\u0003\u00071\u000f\u0003\u0005\u0002T\u0002\u0003\n\u00111\u0001t\u0011%\ty\u000e\u0011I\u0001\u0002\u0004\t\u0019/A\u000fqe\u0016\u0004\u0018M]3Ue\u0006t7/\u001b;j_:$v\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003u\u0001(/\u001a9be\u0016$&/\u00198tSRLwN\u001c+pI\u0011,g-Y;mi\u0012\u001a\u0014!\b9sKB\f'/\u001a+sC:\u001c\u0018\u000e^5p]R{G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r=\"FA7w\u0003u\u0001(/\u001a9be\u0016$&/\u00198tSRLwN\u001c+pI\u0011,g-Y;mi\u0012*\u0014!\b9sKB\f'/\u001a+sC:\u001c\u0018\u000e^5p]R{G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\r]\"fAA5m\u0006i\u0002O]3qCJ,GK]1og&$\u0018n\u001c8U_\u0012\"WMZ1vYR$s'\u0006\u0002\u0004>)\u001a\u0011Q\u0014<\u0002;A\u0014X\r]1sKR\u0013\u0018M\\:ji&|g\u000eV8%I\u00164\u0017-\u001e7uIa\nQ\u0004\u001d:fa\u0006\u0014X\r\u0016:b]NLG/[8o)>$C-\u001a4bk2$H%O\u0001\u001faJ,\u0007/\u0019:f)J\fgn]5uS>tGk\u001c\u0013eK\u001a\fW\u000f\u001c;%cA*\"aa\u0012+\u0007\u0005\rh/\u0001\u000bd_6\u0004H.\u001a;f)J\fgn]5uS>tGk\u001c\u000b\u0005\u0003c\u0019i\u0005C\u0004\u0004P)\u0003\rA!%\u0002\u001fQ\u0014\u0018M\\:ji6+G/\u00193bi\u0006\f!C^1mS\u0012\u0004&o\u001c3vG\u0016\u0014X\t]8dQR\u0019\u0001n!\u0016\t\u000f\r=3\n1\u0001\u0003\u0012\u00061b/\u00197jIB\u0013x\u000eZ;dKJ,\u0005o\\2i\u0005Vl\u0007\u000fF\u0002i\u00077Bqaa\u0014M\u0001\u0004\u0011\t*A\u000euQJ|wo\u0015;bi\u0016$&/\u00198tSRLwN\u001c$bS2,(/\u001a\u000b\u0005\u0003c\u0019\t\u0007C\u0004\u0004d5\u0003\rA!%\u0002%QDh\u000e\u0016:b]NLG/T3uC\u0012\fG/Y\u0001\u001ca\u0016tG-\u001b8h)J\fgn]5uS>t\u0017J\u001c)s_\u001e\u0014Xm]:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0005\u0002\r\u0015\fX/\u00197t)\rA7q\u000e\u0005\b\u0007c\u0002\u0006\u0019\u0001B4\u0003\u0011!\b.\u0019;\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u001b)\u0007\u0015\u0019I\b\u0005\u0003\u0002\u0004\rm\u0014\u0002BB?\u0003\u000b\u0011QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long prevProducerId;
    private long nextProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private TransactionVersion clientTransactionVersion;
    private Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$10() {
        return -1L;
    }

    public static boolean isEpochExhausted(short producerEpoch) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(producerEpoch);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long prevProducerId() {
        return this.prevProducerId;
    }

    public void prevProducerId_$eq(long x$1) {
        this.prevProducerId = x$1;
    }

    public long nextProducerId() {
        return this.nextProducerId;
    }

    public void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public void topicPartitions_$eq(scala.collection.mutable.Set<TopicPartition> x$1) {
        this.topicPartitions = x$1;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public TransactionVersion clientTransactionVersion() {
        return this.clientTransactionVersion;
    }

    public void clientTransactionVersion_$eq(TransactionVersion x$1) {
        this.clientTransactionVersion = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        Object object;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        TransactionState transactionState2 = TransactionState.PREPARE_COMMIT;
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            TransactionState transactionState3 = this.state();
            TransactionState transactionState4 = TransactionState.PREPARE_ABORT;
            if (transactionState3 == null ? transactionState4 != null : !transactionState3.equals(transactionState4)) {
                throw new IllegalStateException("Transaction metadata's current state is " + this.state() + ", and its pending state is " + this.pendingState() + " while trying to remove partitions whose txn marker has been sent, this is not expected");
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.prevProducerId(), this.nextProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)this.topicPartitions().clone()).asJava(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp(), this.clientTransactionVersion());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        long x$4 = this.producerId();
        long x$5 = this.nextProducerId();
        int x$6 = this.txnTimeoutMs();
        scala.collection.mutable.Set<TopicPartition> x$7 = this.topicPartitions();
        long x$8 = this.txnStartTimestamp();
        long x$9 = this.txnLastUpdateTimestamp();
        TransactionVersion x$10 = this.clientTransactionVersion();
        return this.prepareTransitionTo(TransactionState.PREPARE_EPOCH_FENCE, x$4, x$5, bumpedEpoch, (short)-1, x$6, x$7, x$8, x$9, x$10);
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException("Cannot allocate any more producer epochs for producerId " + this.producerId());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = new Right((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right = new Right((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right = new Right((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Expected producer epoch " + expectedEpoch + " does not match current producer epoch " + this.producerEpoch() + " or previous producer epoch " + this.lastProducerEpoch());
                right = new Left((Object)Errors.PRODUCER_FENCED);
            }
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        Right epochBumpResult = right;
        if (epochBumpResult instanceof Right && (tuple2 = (Tuple2)epochBumpResult.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            scala.collection.mutable.Set x$5 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
            long x$8 = this.producerId();
            long x$9 = this.nextProducerId();
            TransactionVersion x$10 = this.clientTransactionVersion();
            return new Right((Object)this.prepareTransitionTo(TransactionState.EMPTY, x$8, x$9, nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.mutable.Set<TopicPartition>)x$5, -1L, updateTimestamp, x$10));
        }
        if (epochBumpResult instanceof Left) {
            Errors err = (Errors)((Left)epochBumpResult).value();
            return new Left((Object)err);
        }
        throw new MatchError((Object)epochBumpResult);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        short x$4 = recordLastEpoch ? (short)this.producerEpoch() : (short)-1;
        scala.collection.mutable.Set x$6 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$9 = this.nextProducerId();
        TransactionVersion x$10 = this.clientTransactionVersion();
        return this.prepareTransitionTo(TransactionState.EMPTY, newProducerId, x$9, (short)0, x$4, newTxnTimeoutMs, (scala.collection.mutable.Set<TopicPartition>)x$6, -1L, updateTimestamp, x$10);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp, TransactionVersion clientTransactionVersion) {
        TransactionState transactionState = this.state();
        long newTxnStartTimestamp = (TransactionState.EMPTY.equals(transactionState) ? true : (TransactionState.COMPLETE_ABORT.equals(transactionState) ? true : TransactionState.COMPLETE_COMMIT.equals(transactionState))) ? updateTimestamp : this.txnStartTimestamp();
        scala.collection.mutable.Set x$2 = (scala.collection.mutable.Set)this.topicPartitions().$plus$plus(addedTopicPartitions);
        long x$6 = this.producerId();
        long x$7 = this.nextProducerId();
        short x$8 = this.producerEpoch();
        short x$9 = this.lastProducerEpoch();
        int x$10 = this.txnTimeoutMs();
        return this.prepareTransitionTo(TransactionState.ONGOING, x$6, x$7, x$8, x$9, x$10, (scala.collection.mutable.Set<TopicPartition>)x$2, newTxnStartTimestamp, updateTimestamp, clientTransactionVersion);
    }

    /*
     * WARNING - void declaration
     */
    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, TransactionVersion clientTransactionVersion, long nextProducerId, long updateTimestamp, boolean noPartitionAdded) {
        void var8_7;
        short s;
        short s2;
        if (clientTransactionVersion.supportsEpochBump()) {
            s2 = (short)(this.producerEpoch() + 1);
            s = this.producerEpoch();
        } else {
            s2 = this.producerEpoch();
            s = this.lastProducerEpoch();
        }
        short s3 = s;
        short updatedProducerEpoch = s2;
        long newTxnStartTimestamp = noPartitionAdded ? updateTimestamp : this.txnStartTimestamp();
        long x$8 = this.producerId();
        int x$9 = this.txnTimeoutMs();
        scala.collection.mutable.Set<TopicPartition> x$10 = this.topicPartitions();
        return this.prepareTransitionTo(newState, x$8, nextProducerId, (short)var8_7, s3, x$9, x$10, newTxnStartTimestamp, updateTimestamp, clientTransactionVersion);
    }

    /*
     * WARNING - void declaration
     */
    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        void var5_5;
        short s;
        long l;
        TransactionState transactionState = this.state();
        TransactionState transactionState2 = TransactionState.PREPARE_COMMIT;
        TransactionState newState = !(transactionState != null ? !transactionState.equals(transactionState2) : transactionState2 != null) ? TransactionState.COMPLETE_COMMIT : TransactionState.COMPLETE_ABORT;
        this.hasFailedEpochFence_$eq(false);
        if (this.clientTransactionVersion().supportsEpochBump() && this.nextProducerId() != -1L) {
            l = this.nextProducerId();
            s = (short)0;
        } else {
            l = this.producerId();
            s = this.producerEpoch();
        }
        short s2 = s;
        long updatedProducerId = l;
        scala.collection.mutable.Set x$5 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        short x$7 = this.lastProducerEpoch();
        int x$8 = this.txnTimeoutMs();
        long x$9 = this.txnStartTimestamp();
        TransactionVersion x$10 = this.clientTransactionVersion();
        return this.prepareTransitionTo(newState, (long)var5_5, -1L, s2, x$7, x$8, (scala.collection.mutable.Set<TopicPartition>)x$5, x$9, updateTimestamp, x$10);
    }

    public TxnTransitMetadata prepareDead() {
        scala.collection.mutable.Set x$2 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$3 = this.producerId();
        long x$4 = this.nextProducerId();
        short x$5 = this.producerEpoch();
        short x$6 = this.lastProducerEpoch();
        int x$7 = this.txnTimeoutMs();
        long x$8 = this.txnStartTimestamp();
        long x$9 = this.txnLastUpdateTimestamp();
        TransactionVersion x$10 = this.clientTransactionVersion();
        return this.prepareTransitionTo(TransactionState.DEAD, x$3, x$4, x$5, x$6, x$7, (scala.collection.mutable.Set<TopicPartition>)x$2, x$8, x$9, x$10);
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    public boolean isDistributedTwoPhaseCommitTxn() {
        return this.txnTimeoutMs() == Integer.MAX_VALUE;
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        return TransactionState.ONGOING.equals(transactionState) ? true : (TransactionState.PREPARE_ABORT.equals(transactionState) ? true : TransactionState.PREPARE_COMMIT.equals(transactionState));
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState state, long producerId, long nextProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp, TransactionVersion clientTransactionVersion) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException("Preparing transaction state transition to " + state + " while it already a pending state " + this.pendingState().get());
        }
        if (producerId < 0L) {
            throw new IllegalArgumentException("Illegal new producer id " + producerId);
        }
        TransactionState transactionState = state;
        TransactionState transactionState2 = TransactionState.DEAD;
        if ((transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) && producerEpoch < 0) {
            throw new IllegalArgumentException("Illegal new producer epoch " + producerEpoch);
        }
        if (state.validPreviousStates().contains(this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(producerId, this.producerId(), nextProducerId, producerEpoch, lastProducerEpoch, txnTimeoutMs, state, CollectionConverters$.MODULE$.MutableSetHasAsJava(topicPartitions).asJava(), txnStartTimestamp, txnLastUpdateTimestamp, clientTransactionVersion);
            this.debug((Function0<String>)(Function0 & Serializable)() -> "TransactionalId " + this.transactionalId() + " prepare transition from " + this.state() + " to " + transitMetadata);
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)state));
            return transitMetadata;
        }
        throw new IllegalStateException("Preparing transaction state transition to " + state + " failed since the target state " + state + " is not a valid previous state of the current state " + this.state());
    }

    private long prepareTransitionTo$default$2() {
        return this.producerId();
    }

    private long prepareTransitionTo$default$3() {
        return this.nextProducerId();
    }

    private short prepareTransitionTo$default$4() {
        return this.producerEpoch();
    }

    private short prepareTransitionTo$default$5() {
        return this.lastProducerEpoch();
    }

    private int prepareTransitionTo$default$6() {
        return this.txnTimeoutMs();
    }

    private scala.collection.mutable.Set<TopicPartition> prepareTransitionTo$default$7() {
        return this.topicPartitions();
    }

    private long prepareTransitionTo$default$8() {
        return this.txnStartTimestamp();
    }

    private long prepareTransitionTo$default$9() {
        return this.txnLastUpdateTimestamp();
    }

    private TransactionVersion prepareTransitionTo$default$10() {
        return this.clientTransactionVersion();
    }

    /*
     * Unable to fully structure code
     */
    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        v0 = toState = (TransactionState)this.pendingState().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$completeTransitionTo$1(kafka.coordinator.transaction.TransactionMetadata org.apache.kafka.coordinator.transaction.TxnTransitMetadata ), ()Lscala/runtime/Nothing$;)((TransactionMetadata)this, (TxnTransitMetadata)transitMetadata));
                        var3_3 = transitMetadata.txnState();
                        if (v0 == null ? var3_3 != null : v0.equals(var3_3) == false) {
                            this.throwStateTransitionFailure(transitMetadata);
                            return;
                        }
                        if (!TransactionState.EMPTY.equals(toState)) break block12;
                        if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || !transitMetadata.topicPartitions().isEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                            this.throwStateTransitionFailure(transitMetadata);
                        }
                        break block13;
                    }
                    if (!TransactionState.ONGOING.equals(toState)) break block14;
                    if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf((Set)CollectionConverters$.MODULE$.SetHasAsScala(transitMetadata.topicPartitions()).asScala()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                        this.throwStateTransitionFailure(transitMetadata);
                    }
                    break block13;
                }
                if (!(TransactionState.PREPARE_ABORT.equals(toState) != false ? true : TransactionState.PREPARE_COMMIT.equals(toState) != false)) break block15;
                v1 = toState;
                var5_4 = TransactionState.PREPARE_ABORT;
                if ((v1 != null ? v1.equals(var5_4) == false : var5_4 != null) || !transitMetadata.clientTransactionVersion().supportsEpochBump()) ** GOTO lbl-1000
                v2 = this.state();
                var6_5 = TransactionState.EMPTY;
                if (!(v2 == null ? var6_5 != null : v2.equals(var6_5) == false)) ** GOTO lbl-1000
                v3 = this.state();
                var7_6 = TransactionState.COMPLETE_COMMIT;
                if (!(v3 == null ? var7_6 != null : v3.equals(var7_6) == false)) ** GOTO lbl-1000
                v4 = this.state();
                var8_7 = TransactionState.COMPLETE_ABORT;
                if (!(v4 != null ? v4.equals(var8_7) == false : var8_7 != null)) lbl-1000:
                // 3 sources

                {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                allowedEmptyAbort = v5;
                v6 = validTimestamp = this.txnStartTimestamp() == transitMetadata.txnStartTimestamp() || allowedEmptyAbort != false;
                if (!(this.validProducerEpoch(transitMetadata) && this.topicPartitions().equals((Object)CollectionConverters$.MODULE$.SetHasAsScala(transitMetadata.topicPartitions()).asScala()) && this.txnTimeoutMs() == transitMetadata.txnTimeoutMs() && validTimestamp)) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
                break block13;
            }
            if (TransactionState.COMPLETE_ABORT.equals(toState) != false ? true : TransactionState.COMPLETE_COMMIT.equals(toState) != false) {
                if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else if (TransactionState.PREPARE_EPOCH_FENCE.equals(toState)) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                if (TransactionState.DEAD.equals(toState)) {
                    throw new IllegalStateException("TransactionalId " + this.transactionalId() + " is trying to complete a transition to " + toState + ". This means that the transactionalId was being expired, and the only acceptable completion of this operation is to remove the transaction metadata from the cache, not to persist the " + toState + " in the log.");
                }
                throw new MatchError((Object)toState);
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$completeTransitionTo$3(kafka.coordinator.transaction.TransactionMetadata org.apache.kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((TransactionMetadata)this, (TxnTransitMetadata)transitMetadata));
        this.producerId_$eq(transitMetadata.producerId());
        this.prevProducerId_$eq(transitMetadata.prevProducerId());
        this.nextProducerId_$eq(transitMetadata.nextProducerId());
        this.producerEpoch_$eq(transitMetadata.producerEpoch());
        this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
        this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
        this.topicPartitions_$eq((scala.collection.mutable.Set<TopicPartition>)CollectionConverters$.MODULE$.SetHasAsScala(transitMetadata.topicPartitions()).asScala());
        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.clientTransactionVersion_$eq(transitMetadata.clientTransactionVersion());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        boolean isAtLeastTransactionsV2 = transitMetadata.clientTransactionVersion().supportsEpochBump();
        TransactionState txnState = transitMetadata.txnState();
        short transitProducerEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        short transitLastProducerEpoch = transitMetadata.lastProducerEpoch();
        if (isAtLeastTransactionsV2 && (TransactionState.COMPLETE_COMMIT.equals(txnState) ? true : TransactionState.COMPLETE_ABORT.equals(txnState)) && transitProducerEpoch == (short)0) {
            return transitLastProducerEpoch == this.lastProducerEpoch() && transitMetadata.prevProducerId() == this.producerId();
        }
        if (isAtLeastTransactionsV2 && (TransactionState.PREPARE_COMMIT.equals(txnState) ? true : TransactionState.PREPARE_ABORT.equals(txnState))) {
            return transitLastProducerEpoch == this.producerEpoch() && transitProducerId == this.producerId();
        }
        return transitProducerEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable)() -> this.toString() + "'s transition to " + txnTransitMetadata + " failed: this should not happen");
        throw new IllegalStateException("TransactionalId " + this.transactionalId() + " failed transition to state " + txnTransitMetadata + " due to unexpected metadata");
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return "TransactionMetadata(transactionalId=" + this.transactionalId() + ", producerId=" + this.producerId() + ", prevProducerId=" + this.prevProducerId() + ", nextProducerId=" + this.nextProducerId() + ", producerEpoch=" + this.producerEpoch() + ", lastProducerEpoch=" + this.lastProducerEpoch() + ", txnTimeoutMs=" + this.txnTimeoutMs() + ", state=" + this.state() + ", pendingState=" + this.pendingState() + ", topicPartitions=" + this.topicPartitions() + ", txnStartTimestamp=" + this.txnStartTimestamp() + ", txnLastUpdateTimestamp=" + this.txnLastUpdateTimestamp() + ", clientTransactionVersion=" + this.clientTransactionVersion() + ")";
    }

    public boolean equals(Object that) {
        if (that instanceof TransactionMetadata) {
            TransactionMetadata transactionMetadata = (TransactionMetadata)that;
            String string = this.transactionalId();
            String string2 = transactionMetadata.transactionalId();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (this.producerId() == transactionMetadata.producerId() && this.producerEpoch() == transactionMetadata.producerEpoch() && this.lastProducerEpoch() == transactionMetadata.lastProducerEpoch() && this.txnTimeoutMs() == transactionMetadata.txnTimeoutMs() && this.state().equals((Object)transactionMetadata.state()) && this.topicPartitions().equals(transactionMetadata.topicPartitions()) && this.txnStartTimestamp() == transactionMetadata.txnStartTimestamp() && this.txnLastUpdateTimestamp() == transactionMetadata.txnLastUpdateTimestamp()) {
                    TransactionVersion transactionVersion = this.clientTransactionVersion();
                    TransactionVersion transactionVersion2 = transactionMetadata.clientTransactionVersion();
                    if (!(transactionVersion != null ? !transactionVersion.equals(transactionVersion2) : transactionVersion2 != null)) {
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp()), this.clientTransactionVersion()}))).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ Nothing$ $anonfun$completeTransitionTo$1(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        $this.fatal((Function0<String>)(Function0 & Serializable)() -> $this + "'s transition to " + transitMetadata$2 + " failed since pendingState is not defined: this should not happen");
        throw new IllegalStateException("TransactionalId " + $this.transactionalId() + " completing transaction state transition while it does not have a pending state");
    }

    public static final /* synthetic */ String $anonfun$completeTransitionTo$3(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        return "TransactionalId " + $this.transactionalId() + " complete transition from " + $this.state() + " to " + transitMetadata$2;
    }

    public TransactionMetadata(String transactionalId, long producerId, long prevProducerId, long nextProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp, TransactionVersion clientTransactionVersion) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.prevProducerId = prevProducerId;
        this.nextProducerId = nextProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        this.clientTransactionVersion = clientTransactionVersion;
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

