/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.AlterPartitionItem;
import kafka.server.AlterPartitionManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001\u0002\r\u001a\u0001yA\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\t{\u0001\u0011\t\u0011)A\u0005c!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011)\u0019!C\u0001/\"Aa\f\u0001B\u0001B\u0003%\u0001\fC\u0003`\u0001\u0011\u0005\u0001\r\u0003\u0005h\u0001\t\u0007I\u0011A\ri\u0011\u0019A\b\u0001)A\u0005S\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bbBA\u0002\u0001\u0001\u0006Ia\u001f\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\ty\u0001\u0001C!\u0003\u000fAq!!\u0005\u0001\t\u0003\n\u0019\u0002\u0003\u0005\u00020\u0001!\t!GA\u0004\u0011!\t\t\u0004\u0001C\u00013\u0005\u001d\u0001bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\t\t\b\u0001C\u0005\u0003g\u0012A\u0004R3gCVdG/\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'O\u0003\u0002\u001b7\u000511/\u001a:wKJT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q$J\u0015\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u001a\u0013\tA\u0013DA\u000bBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0005)jS\"A\u0016\u000b\u00051Z\u0012!B;uS2\u001c\u0018B\u0001\u0018,\u0005\u001daunZ4j]\u001e\f\u0001dY8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s+\u0005\t\u0004C\u0001\u001a<\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0019\u0019w.\\7p]*\u0011!D\u000e\u0006\u00039]R!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO&\u0011Ah\r\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\f\u0011dY8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3sA\u0005I1o\u00195fIVdWM]\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111)N\u0001\u0005kRLG.\u0003\u0002F\u0005\nI1k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003Y1S!\u0001\u000e\u001c\n\u00059[%\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002%B\u0011\u0001eU\u0005\u0003)\u0006\u00121!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\nce>\\WM]#q_\u000eD7+\u001e9qY&,'/F\u0001Y!\r\u0001\u0013lW\u0005\u00035\u0006\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\u0001b\u0016BA/\"\u0005\u0011auN\\4\u0002)\t\u0014xn[3s\u000bB|7\r[*vaBd\u0017.\u001a:!\u0003\u0019a\u0014N\\5u}Q1\u0011MY2eK\u001a\u0004\"A\n\u0001\t\u000b=Z\u0001\u0019A\u0019\t\u000byZ\u0001\u0019\u0001!\t\u000b\u001d[\u0001\u0019A%\t\u000bA[\u0001\u0019\u0001*\t\u000bY[\u0001\u0019\u0001-\u0002!Ut7/\u001a8u\u0013N\u0014X\u000b\u001d3bi\u0016\u001cX#A5\u0011\t)\u0004(/^\u0007\u0002W*\u0011A.\\\u0001\u000bG>t7-\u001e:sK:$(BA\"o\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!]6\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u00023g&\u0011Ao\r\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"A\n<\n\u0005]L\"AE!mi\u0016\u0014\b+\u0019:uSRLwN\\%uK6\f\u0011#\u001e8tK:$\u0018j\u001d:Va\u0012\fG/Z:!\u0003=IgN\u001a7jO\"$(+Z9vKN$X#A>\u0011\u0005q|X\"A?\u000b\u0005y\\\u0017AB1u_6L7-C\u0002\u0002\u0002u\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001E5oM2Lw\r\u001b;SKF,Xm\u001d;!\u0003\u0015\u0019H/\u0019:u)\t\tI\u0001E\u0002!\u0003\u0017I1!!\u0004\"\u0005\u0011)f.\u001b;\u0002\u0011MDW\u000f\u001e3po:\faa];c[&$HCBA\u000b\u0003O\tY\u0003E\u0003k\u0003/\tY\"C\u0002\u0002\u001a-\u0014\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011m\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002&\u0005}!\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\bBBA\u0015%\u0001\u0007!/\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011Q\u0006\nA\u0002\u0005m\u0011\u0001\u00047fC\u0012,'/\u00118e\u0013N\u0014\u0018\u0001G7bs\n,\u0007K]8qC\u001e\fG/Z%te\u000eC\u0017M\\4fg\u0006!2\r\\3be&sg\t\\5hQR\u0014V-];fgR\f1b]3oIJ+\u0017/^3tiR!\u0011\u0011BA\u001c\u0011\u001d\tI$\u0006a\u0001\u0003w\t1$\u001b8gY&<\u0007\u000e^!mi\u0016\u0014\b+\u0019:uSRLwN\\%uK6\u001c\b#BA\u001f\u0003\u001b*h\u0002BA \u0003\u0013rA!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bj\u0012A\u0002\u001fs_>$h(C\u0001#\u0013\r\tY%I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty%!\u0015\u0003\u0007M+\u0017OC\u0002\u0002L\u0005\nABY;jY\u0012\u0014V-];fgR$b!a\u0016\u0002l\u00055\u0004\u0003BA-\u0003KrA!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?b\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005\r\u0014QL\u0001\u0016\u00032$XM\u001d)beRLG/[8o%\u0016\fX/Z:u\u0013\u0011\t9'!\u001b\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u00111MA/\u0011\u001d\tID\u0006a\u0001\u0003wAa!a\u001c\u0017\u0001\u0004Y\u0016a\u00032s_.,'/\u00129pG\"\fA\u0004[1oI2,\u0017\t\u001c;feB\u000b'\u000f^5uS>t'+Z:q_:\u001cX\r\u0006\u0005\u0002v\u0005\u0005\u00151RAH!\u0011\t9(! \u000e\u0005\u0005e$bAA>\u0019\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u0000\u0005e$AB#se>\u00148\u000fC\u0004\u0002\u0004^\u0001\r!!\"\u0002%\u0005dG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f\u001d\t\u0005\u00037\n9)\u0003\u0003\u0002\n\u0006u#AF!mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fgB|gn]3\t\r\u00055u\u00031\u0001\\\u0003=\u0019XM\u001c;Ce>\\WM]#q_\u000eD\u0007bBA\u001d/\u0001\u0007\u00111\b")
public class DefaultAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final NodeToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final ConcurrentHashMap<TopicIdPartition, AlterPartitionItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public NodeToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public ConcurrentHashMap<TopicIdPartition, AlterPartitionItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr) {
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterPartitionItem alterPartitionItem = new AlterPartitionItem(topicIdPartition, leaderAndIsr, future);
        if (this.unsentIsrUpdates().putIfAbsent(alterPartitionItem.topicIdPartition(), alterPartitionItem) == null) {
            this.maybePropagateIsrChanges();
        } else {
            future.completeExceptionally((Throwable)new OperationNotAttemptedException("Failed to enqueue ISR change state " + leaderAndIsr + " for partition " + topicIdPartition));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterPartitionItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterPartitionItems.append(item));
            this.sendRequest((Seq<AlterPartitionItem>)inflightAlterPartitionItems.toSeq());
            return;
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
            return;
        }
    }

    private void sendRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        long brokerEpoch = this.brokerEpochSupplier().apply$mcJ$sp();
        AlterPartitionRequest.Builder request = this.buildRequest(inflightAlterPartitionItems, brokerEpoch);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Sending AlterPartition to controller " + request);
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(this, brokerEpoch, inflightAlterPartitionItems){
            private final /* synthetic */ DefaultAlterPartitionManager $outer;
            private final long brokerEpoch$1;
            private final Seq inflightAlterPartitionItems$2;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Received AlterPartition response " + response);
                try {
                    errors = response.authenticationException() != null ? Errors.NETWORK_EXCEPTION : (response.versionMismatch() != null ? Errors.UNSUPPORTED_VERSION : this.$outer.kafka$server$DefaultAlterPartitionManager$$handleAlterPartitionResponse((AlterPartitionResponse)response.responseBody(), this.brokerEpoch$1, (Seq<AlterPartitionItem>)this.inflightAlterPartitionItems$2));
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().scheduleOnce("send-alter-partition", () -> $this.$outer.maybePropagateIsrChanges(), 50L);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerEpoch$1 = brokerEpoch$1;
                this.inflightAlterPartitionItems$2 = inflightAlterPartitionItems$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        });
    }

    private AlterPartitionRequest.Builder buildRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems, long brokerEpoch) {
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(brokerEpoch);
        inflightAlterPartitionItems.groupBy((Function1 & Serializable)x$1 -> x$1.topicIdPartition().topicId()).foreach((Function1 & Serializable)x0$1 -> {
            DefaultAlterPartitionManager.$anonfun$buildRequest$2(message, x0$1);
            return BoxedUnit.UNIT;
        });
        return new AlterPartitionRequest.Builder(message);
    }

    public Errors kafka$server$DefaultAlterPartitionManager$$handleAlterPartitionResponse(AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Broker had a stale broker epoch (" + sentBrokerEpoch + "), retrying.");
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0 & Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = new HashMap();
            data.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicIdPartition tp = new TopicIdPartition(topic.topicId(), partition.partitionIndex());
                Errors apiError = Errors.forCode((short)partition.errorCode());
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Controller successfully handled AlterPartition request for " + tp + ": " + partition);
                Errors errors = apiError;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(LeaderRecoveryState.optionalOf((byte)partition.leaderRecoveryState())));
                    if (option instanceof Some) {
                        LeaderRecoveryState leaderRecoveryState = (LeaderRecoveryState)((Some)option).value();
                        partitionResponses.update((Object)tp, (Object)new Right((Object)new LeaderAndIsr(partition.leaderId(), partition.leaderEpoch(), partition.isr(), leaderRecoveryState, partition.partitionEpoch())));
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Controller returned an invalid leader recovery state (" + partition.leaderRecoveryState() + ") for " + tp + ": " + partition);
                        partitionResponses.update((Object)tp, (Object)new Left((Object)Errors.UNKNOWN_SERVER_ERROR));
                        return;
                    }
                    throw new MatchError((Object)option);
                }
                partitionResponses.update((Object)tp, (Object)new Left((Object)apiError));
            }));
            inflightAlterPartitionItems.foreach((Function1 & Serializable)inflightAlterPartition -> {
                Option option = partitionResponses.get((Object)inflightAlterPartition.topicIdPartition());
                if (option instanceof Some) {
                    boolean bl;
                    Either leaderAndIsrOrError = (Either)((Some)option).value();
                    this.unsentIsrUpdates().remove(inflightAlterPartition.topicIdPartition());
                    if (leaderAndIsrOrError instanceof Left) {
                        Errors error = (Errors)((Left)leaderAndIsrOrError).value();
                        bl = inflightAlterPartition.future().completeExceptionally((Throwable)error.exception());
                    } else if (leaderAndIsrOrError instanceof Right) {
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Right)leaderAndIsrOrError).value();
                        bl = inflightAlterPartition.future().complete(leaderAndIsr);
                    } else {
                        throw new MatchError((Object)leaderAndIsrOrError);
                    }
                    return BoxesRunTime.boxToBoolean((boolean)bl);
                }
                if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Partition " + inflightAlterPartition.topicIdPartition() + " was sent but not included in the response");
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
        } else {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Controller returned an unexpected top-level error when handling AlterPartition request: " + errors);
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(AlterPartitionRequestData.TopicData topicData$1, AlterPartitionItem item) {
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicIdPartition().partitionId()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsrWithEpochs(item.leaderAndIsr().isrWithBrokerEpoch()).setPartitionEpoch(item.leaderAndIsr().partitionEpoch());
        partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(AlterPartitionRequestData message$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Uuid topicId = (Uuid)x0$1._1();
            Seq items = (Seq)x0$1._2();
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicId(topicId);
            message$1.topics().add(topicData);
            items.foreach((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterPartitionManager.$anonfun$buildRequest$3(topicData, item)));
            return;
        }
        throw new MatchError(null);
    }

    public DefaultAlterPartitionManager(NodeToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.unsentIsrUpdates = new ConcurrentHashMap();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

