/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.distinctcount;

import com.dynatrace.hash4j.distinctcount.StateChangeObserver;
import com.dynatrace.hash4j.internal.Preconditions;

public final class MartingaleEstimator
implements StateChangeObserver {
    private double distinctCountEstimate;
    private double stateChangeProbability;

    public MartingaleEstimator() {
        this.reset();
    }

    public void reset() {
        this.distinctCountEstimate = 0.0;
        this.stateChangeProbability = 1.0;
    }

    public MartingaleEstimator(double distinctCountEstimate, double stateChangeProbability) {
        this.set(distinctCountEstimate, stateChangeProbability);
    }

    public void set(double distinctCountEstimate, double stateChangeProbability) {
        Preconditions.checkArgument(distinctCountEstimate >= 0.0, "Distinct count estimate must be non-negative!");
        Preconditions.checkArgument(stateChangeProbability >= 0.0 && stateChangeProbability <= 1.0, "State change probability must be in the range [0,1]!");
        this.distinctCountEstimate = distinctCountEstimate;
        if (stateChangeProbability <= 0.0) {
            stateChangeProbability = 0.0;
        }
        this.stateChangeProbability = stateChangeProbability;
    }

    public double getDistinctCountEstimate() {
        return this.distinctCountEstimate;
    }

    double getStateChangeProbability() {
        return this.stateChangeProbability;
    }

    @Override
    public void stateChanged(double probabilityDecrement) {
        this.distinctCountEstimate += 1.0 / this.stateChangeProbability;
        this.stateChangeProbability -= probabilityDecrement;
        if (this.stateChangeProbability <= 0.0) {
            this.stateChangeProbability = 0.0;
        }
    }

    public String toString() {
        return MartingaleEstimator.class.getSimpleName() + "{distinctCountEstimate=" + this.distinctCountEstimate + ", stateChangeProbability=" + this.stateChangeProbability + "}";
    }
}

