/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crl.infinispan;

import java.security.cert.X509CRL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.crl.CrlStorageProvider;
import org.keycloak.crl.CrlStorageProviderFactory;
import org.keycloak.crl.infinispan.InfinispanCrlStorageProvider;
import org.keycloak.crl.infinispan.X509CRLEntry;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class InfinispanCrlStorageProviderFactory
implements CrlStorageProviderFactory,
InfinispanCrlStorageProvider.SharedData {
    public static final String PROVIDER_ID = "infinispan";
    private volatile Cache<String, X509CRLEntry> crlCache;
    private final Map<String, FutureTask<X509CRL>> tasksInProgress = new ConcurrentHashMap<String, FutureTask<X509CRL>>();
    private volatile long cacheTime;
    private volatile long minTimeBetweenRequests;

    public CrlStorageProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanCrlStorageProvider(this);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("cacheTime").type("int").helpText("Interval in seconds that the CRL is cached. The next update time of the CRL is always a minimum if present.\nZero or a negative value means CRL is cached until the next update time specified in the CRL (or infinite if the\nCRL does not contain the next update).\n").defaultValue((Object)-1).add().property().name("minTimeBetweenRequests").type("int").helpText("Minimum interval in seconds between two requests to retrieve the CRL. The CRL is not updated\nfrom the URL again until this minimum time has passed since the previous refresh. In theory\nthis option is never used if the CRL is refreshed correctly in the next update time.\nThe interval should be a positive number. Default 10 seconds.\n").defaultValue((Object)10).add().build();
    }

    public void init(Config.Scope config) {
        long tmpCacheTime = config.getLong("cacheTime", Long.valueOf(-1L));
        this.cacheTime = tmpCacheTime > 0L ? TimeUnit.SECONDS.toMillis(tmpCacheTime) : -1L;
        long tmpMinTimeBetweenRequests = config.getLong("minTimeBetweenRequests", Long.valueOf(10L));
        this.minTimeBetweenRequests = tmpMinTimeBetweenRequests > 0L ? TimeUnit.SECONDS.toMillis(tmpMinTimeBetweenRequests) : 10000L;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.crlCache == null) {
            InfinispanCrlStorageProviderFactory infinispanCrlStorageProviderFactory = this;
            synchronized (infinispanCrlStorageProviderFactory) {
                if (this.crlCache == null) {
                    this.crlCache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("crl");
                }
            }
        }
    }

    @Override
    public Cache<String, X509CRLEntry> cache() {
        return this.crlCache;
    }

    @Override
    public Map<String, FutureTask<X509CRL>> tasksInProgress() {
        return this.tasksInProgress;
    }

    @Override
    public long cacheTime() {
        return this.cacheTime;
    }

    @Override
    public long minTimeBetweenRequests() {
        return this.minTimeBetweenRequests;
    }
}

