/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.representations.JsonWebToken;

public abstract class AbstractBaseJWTValidator {
    private static final Logger logger = Logger.getLogger(AbstractBaseJWTValidator.class);
    protected final ClientAssertionState clientAssertionState;
    protected final KeycloakSession session;
    protected final int currentTime;

    public AbstractBaseJWTValidator(KeycloakSession session, ClientAssertionState clientAssertionState) {
        this.session = session;
        this.clientAssertionState = clientAssertionState;
        this.currentTime = Time.currentTime();
    }

    public ClientAssertionState getState() {
        return this.clientAssertionState;
    }

    public String getClientAssertion() {
        return this.clientAssertionState.getClientAssertion();
    }

    public JWSInput getJws() {
        return this.clientAssertionState.getJws();
    }

    public boolean validateTokenActive(int allowedClockSkew, int maxExp, boolean reusePermitted) {
        JsonWebToken token = this.clientAssertionState.getToken();
        if (token.getExp() == null) {
            return this.failure("Token exp claim is required");
        }
        if (!token.isActive(allowedClockSkew)) {
            return this.failure("Token is not active");
        }
        long lifespan = token.getExp() - (long)this.currentTime;
        if (token.getIat() == null) {
            if (lifespan > (long)maxExp) {
                return this.failure("Token expiration is too far in the future and iat claim not present in token");
            }
        } else {
            if (token.getIat() - (long)allowedClockSkew > (long)this.currentTime) {
                return this.failure("Token was issued in the future");
            }
            if ((lifespan = Math.min(lifespan, (long)maxExp)) <= 0L) {
                return this.failure("Token is not active");
            }
            if ((long)this.currentTime > token.getIat() + (long)maxExp) {
                return this.failure("Token was issued too far in the past to be used now");
            }
        }
        if (!reusePermitted) {
            if (token.getId() == null) {
                return this.failure("Token jti claim is required");
            }
            if (!this.validateTokenReuse(lifespan)) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateTokenReuse(long lifespanInSecs) {
        JsonWebToken token = this.clientAssertionState.getToken();
        String tokenId = token.getId();
        SingleUseObjectProvider singleUseCache = this.session.singleUseObjects();
        if (!singleUseCache.putIfAbsent(tokenId, lifespanInSecs)) {
            logger.warnf("Token '%s' already used when for issuedFor '%s'.", (Object)tokenId, (Object)token.getIssuedFor());
            return this.failure("Token reuse detected");
        }
        logger.tracef("Added token '%s' to single-use cache. Lifespan: %d seconds, issuedFor: %s", (Object)tokenId, (Object)lifespanInSecs, (Object)token.getIssuedFor());
        return true;
    }

    public boolean validateTokenAudience(List<String> expectedAudiences, boolean multipleAudienceAllowed) {
        JsonWebToken token = this.clientAssertionState.getToken();
        if (!token.hasAnyAudience(expectedAudiences)) {
            return this.failure("Invalid token audience");
        }
        if (!multipleAudienceAllowed && token.getAudience().length > 1) {
            return this.failure("Multiple audiences not allowed");
        }
        return true;
    }

    public boolean validateSignatureAlgorithm(String expectedSignatureAlg) {
        JWSInput jws = this.clientAssertionState.getJws();
        if (jws.getHeader().getAlgorithm() == null) {
            return this.failure("Invalid signature algorithm");
        }
        if (expectedSignatureAlg != null && !expectedSignatureAlg.equals(jws.getHeader().getAlgorithm().name())) {
            return this.failure("Invalid signature algorithm");
        }
        return true;
    }

    private boolean failure(String errorDescription) {
        this.failureCallback(errorDescription);
        return false;
    }

    protected abstract void failureCallback(String var1);
}

