"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PowerLevelAction = void 0;
/**
 * Actions that can be guarded by power levels.
 */
var PowerLevelAction;
(function (PowerLevelAction) {
    /**
     * Power level required to ban other users.
     */
    PowerLevelAction["Ban"] = "ban";
    /**
     * Power level required to kick other users.
     */
    PowerLevelAction["Kick"] = "kick";
    /**
     * Power level required to redact events sent by other users. Users can redact
     * their own messages regardless of this power level requirement, unless forbidden
     * by the `events` section of the power levels content.
     */
    PowerLevelAction["RedactEvents"] = "redact";
    /**
     * Power level required to invite other users.
     */
    PowerLevelAction["Invite"] = "invite";
    /**
     * Power level required to notify the whole room with "@room".
     */
    PowerLevelAction["NotifyRoom"] = "notifications.room";
})(PowerLevelAction || (exports.PowerLevelAction = PowerLevelAction = {}));
//# sourceMappingURL=PowerLevelAction.js.map