/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import com.plantuml.ubrex.UnicodeBracketedExpression;
import com.plantuml.ubrex.builder.UBrexConcat;
import com.plantuml.ubrex.builder.UBrexLeaf;
import com.plantuml.ubrex.builder.UBrexNamed;
import com.plantuml.ubrex.builder.UBrexOptional;
import com.plantuml.ubrex.builder.UBrexOr;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.activitydiagram.command.CommandLinkActivity;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.UBrexSingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;

public class UBrexCommandIf
extends UBrexSingleLineCommand2<ActivityDiagram> {
    public UBrexCommandIf() {
        super(UBrexCommandIf.getRegexConcat());
    }

    static UnicodeBracketedExpression getRegexConcat() {
        UBrexConcat simple = UBrexConcat.build(UBrexLeaf.spaceZeroOrMore(), new UBrexOptional(UBrexConcat.build(new UBrexNamed("ARROW_BODY1", new UBrexLeaf("\u3007+\u300c-.\u300d")), new UBrexLeaf("\u3007?\u3018 [ \u3036$ARROW_STYLE1=\u3018\u3010 #\u3007+\u3034w \u2507dotted\u2507dashed\u2507plain\u2507bold\u2507hidden\u2507norank\u2507single\u2507node\u2507thickness=\u3007+\u3034d\u3011 \u3007*\u3010 ,#\u3007+\u3034w \u2507,dotted\u2507,dashed\u2507,plain\u2507,bold\u2507,hidden\u2507,norank\u2507,single\u2507,node\u2507,thickness=\u3007+\u3034d\u3011\u3019] \u3019"), new UBrexNamed("ARROW_DIRECTION", new UBrexLeaf("\u3007?\u3010 *\u2507left\u2507right\u2507up\u2507down\u2507l\u3007?e\u2507r\u3007?i\u2507u\u3007?p\u2507d\u3007?o\u3011")), new UBrexLeaf("\u3007?\u3018 [  \u3036$ARROW_STYLE2=\u3018\u3010 #\u3007+\u3034w \u2507dotted\u2507dashed\u2507plain\u2507bold\u2507hidden\u2507norank\u2507single\u2507node\u2507thickness=\u3007+\u3034d\u3011 \u3007*\u3010 ,#\u3007+\u3034w \u2507,dotted\u2507,dashed\u2507,plain\u2507,bold\u2507,hidden\u2507,norank\u2507,single\u2507,node\u2507,thickness=\u3007+\u3034d\u3011\u3019] \u3019"), new UBrexNamed("ARROW_BODY2", new UBrexLeaf("\u3007*\u300c-.\u300d")), new UBrexLeaf(">"))), UBrexLeaf.spaceZeroOrMore(), new UBrexOptional(new UBrexLeaf("[ \u3036$BRACKET=\u3018\u3007+\u300c\u3024]*\u300d  \u3007*\u300c\u3024]\u300d\u3019 ]")), UBrexLeaf.spaceZeroOrMore(), new UBrexOr(new UBrexLeaf("if \u3007*\u3034s \u3034g  \u3036$IF1=\u3007*\u3034G \u3034g \u3007*\u3034s \u3007?\u3018as \u3007+\u3034s \u3036$ASIF1=\u3007+\u300c\u3034an_.\u300d \u3007+\u3034s \u3019\u3018then\u3019"), new UBrexLeaf("if \u3007+\u3034s \u3036$IF2=\u3007l+\u3034. \u3018then\u3019 "), new UBrexLeaf("if \u3007*\u3034s \u3034g  \u3036$IF1=\u3007*\u3034G \u3034g \u3007*\u3034s \u3007?\u3018as \u3007+\u3034s \u3036$ASIF1=\u3007+\u300c\u3034an_.\u300d \u3007+\u3034s \u3019"), new UBrexLeaf("if \u3007+\u3034s \u3036$IF2=\u3007+\u3034.")));
        return UBrexConcat.build(new UBrexOr(simple, UBrexConcat.build(new UBrexNamed("STAR", new UBrexLeaf("(* \u3007?\u3018top\u3019)")), simple), UBrexConcat.build(new UBrexNamed("BAR", new UBrexLeaf("=\u3007+= \u3007*\u3034s \u3007+\u300c\u3034an_.\u300d\u3007*\u3034s =\u3007+=")), simple), UBrexConcat.build(new UBrexLeaf("\u3034g \u3036$QUOTED1=\u3007*\u3034G \u3034g \u3007?\u3018\u3007+\u3034s as \u3007+\u3034s \u3036$QUOTED2=\u3007+\u300c\u3034an_.\u300d \u3019 "), simple), UBrexConcat.build(new UBrexNamed("CODE", new UBrexLeaf("\u3007+\u300c\u3034an_.\u300d")), simple)), UBrexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        Direction direction;
        String ifLabel;
        String ifCode;
        Entity entity1 = CommandLinkActivity.ubrexGetEntityForIfOnly(location, diagram, arg);
        if (entity1 == null) {
            return CommandExecutionResult.error("No if possible at this point");
        }
        if (arg.get("IF2", 0) == null) {
            ifCode = arg.get("ASIF1", 0);
            ifLabel = arg.get("IF1", 0);
        } else {
            ifCode = null;
            ifLabel = arg.get("IF2", 0);
        }
        diagram.startIf(location, ifCode);
        int lenght = 2;
        if (arg.get("ARROW_BODY1", 0) != null) {
            String arrowBody1 = CommandLinkClass.notNull(arg.get("ARROW_BODY1", 0));
            String arrowBody2 = CommandLinkClass.notNull(arg.get("ARROW_BODY2", 0));
            String arrowDirection = CommandLinkClass.notNull(arg.get("ARROW_DIRECTION", 0));
            String arrow = StringUtils.manageArrowForCuca(arrowBody1 + arrowDirection + arrowBody2 + ">");
            lenght = arrow.length() - 1;
        }
        Entity branch = diagram.getCurrentContext().getBranch();
        LinkArg linkArg = LinkArg.build(Display.getWithNewlines(diagram.getPragma(), arg.get("BRACKET", 0)), lenght);
        Link link = new Link(location, diagram, diagram.getSkinParam().getCurrentStyleBuilder(), entity1, branch, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), linkArg.withQuantifier(null, ifLabel).withDistanceAngle(diagram.getLabeldistance(), diagram.getLabelangle()));
        if (arg.get("ARROW", 0) != null && ((direction = StringUtils.getArrowDirection(arg.get("ARROW", 0))) == Direction.LEFT || direction == Direction.UP)) {
            link = link.getInv();
        }
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

