/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNotes;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.creole.SheetBlock2;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.Styleable;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.utils.Direction;

public class FtileWithNoteOpale
extends AbstractFtile
implements Stencil,
Styleable {
    private final Ftile tile;
    private final Opale opale;
    private final VerticalAlignment verticalAlignment;
    private final NotePosition notePosition;
    private final double suppSpace = 20.0;
    private final Swimlane swimlaneNote;

    @Override
    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlaneNote != null) {
            HashSet<Swimlane> result = new HashSet<Swimlane>(this.tile.getSwimlanes());
            result.add(this.swimlaneNote);
            return Collections.unmodifiableSet(result);
        }
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.singleton(this.tile);
    }

    public static Ftile create(Ftile tile, Collection<PositionedNote> notes, boolean withLink, VerticalAlignment verticalAlignment) {
        if (notes.size() > 1) {
            return new FtileWithNotes(tile, notes, verticalAlignment);
        }
        if (notes.size() == 0) {
            throw new IllegalArgumentException();
        }
        return new FtileWithNoteOpale(tile, notes.iterator().next(), withLink, verticalAlignment);
    }

    private FtileWithNoteOpale(Ftile tile, PositionedNote note, boolean withLink, VerticalAlignment verticalAlignment) {
        super(note.getColors() == null ? tile.skinParam() : note.getColors().mute(tile.skinParam()));
        this.verticalAlignment = verticalAlignment;
        this.swimlaneNote = note.getSwimlaneNote();
        this.tile = tile;
        this.notePosition = note.getNotePosition();
        if (note.getType() == NoteType.FLOATING_NOTE) {
            withLink = false;
        }
        Stereotype stereotype = note.getStereotype();
        Style style = this.getStyleSignature().withTOBECHANGED(stereotype).getMergedStyle(this.skinParam().getCurrentStyleBuilder()).eventuallyOverride(note.getColors());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(this.getIHtmlColorSet());
        double shadowing = style.getShadowing();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        UStroke stroke = style.getStroke();
        HorizontalAlignment align = this.skinParam().getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, null);
        Sheet sheet = this.skinParam().sheet(fc, align, CreoleMode.FULL).createSheet(note.getDisplay());
        SheetBlock2 text = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, this.skinParam().getPadding()), this, stroke);
        this.opale = new Opale(shadowing, borderColor, noteBackgroundColor, text, withLink, stroke);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        XDimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        XDimension2D dimNote = this.opale.calculateDimension(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double yForFtile = (dimTotal.getHeight() - dimTile.getHeight()) / 2.0;
        double marge = this.notePosition == NotePosition.LEFT ? dimNote.getWidth() + 20.0 : 0.0;
        return new UTranslate(marge, yForFtile);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile) {
            return UTranslate.none();
        }
        return super.getTranslateFor(child, stringBounder);
    }

    private UTranslate getTranslateForOpale(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimNote = this.opale.calculateDimension(stringBounder);
        double yForNote = this.verticalAlignment == VerticalAlignment.CENTER ? (dimTotal.getHeight() - dimNote.getHeight()) / 2.0 : 0.0;
        if (this.notePosition == NotePosition.LEFT) {
            return UTranslate.dy(yForNote);
        }
        double dx = dimTotal.getWidth() - dimNote.getWidth();
        return new UTranslate(dx, yForNote);
    }

    @Override
    public void drawU(UGraphic ug) {
        Swimlane intoSw = ug instanceof UGraphicInterceptorOneSwimlane ? ((UGraphicInterceptorOneSwimlane)ug).getSwimlane() : null;
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimNote = this.opale.calculateDimension(stringBounder);
        if (this.notePosition == NotePosition.LEFT) {
            Direction strategy = Direction.RIGHT;
            XPoint2D pp1 = new XPoint2D(dimNote.getWidth(), dimNote.getHeight() / 2.0);
            XPoint2D pp2 = new XPoint2D(dimNote.getWidth() + 20.0, dimNote.getHeight() / 2.0);
            this.opale.setOpale(strategy, pp1, pp2);
        } else {
            Direction strategy = Direction.LEFT;
            XPoint2D pp1 = new XPoint2D(0.0, dimNote.getHeight() / 2.0);
            XPoint2D pp2 = new XPoint2D(-20.0, dimNote.getHeight() / 2.0);
            this.opale.setOpale(strategy, pp1, pp2);
        }
        if (!(ug instanceof UGraphicInterceptorOneSwimlane) || this.swimlaneNote == null || intoSw == this.swimlaneNote) {
            this.opale.drawU(ug.apply(this.getTranslateForOpale(ug)));
        }
        ug.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        XDimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        UTranslate translate = this.getTranslate(stringBounder);
        if (orig.hasPointOut()) {
            return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy(), orig.getOutY() + translate.getDy());
        }
        return new FtileGeometry(dimTotal, orig.getLeft() + translate.getDx(), orig.getInY() + translate.getDy());
    }

    private XDimension2D calculateDimensionInternal(StringBounder stringBounder) {
        XDimension2D dimNote = this.opale.calculateDimension(stringBounder);
        FtileGeometry dimTile = this.tile.calculateDimension(stringBounder);
        double height = Math.max(dimNote.getHeight(), dimTile.getHeight());
        return new XDimension2D(dimTile.getWidth() + 1.0 * dimNote.getWidth() + 20.0, height);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }
}

