/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class HelpTable {
    private final List<String[]> lines = new ArrayList<String[]>();

    public void newLine(String ... cells) {
        if (this.lines.size() > 0 && cells.length != this.nbCols()) {
            throw new IllegalArgumentException();
        }
        this.lines.add(cells);
    }

    private int sizeFirstColumn() {
        int result = 0;
        for (String[] line : this.lines) {
            int idx = line[0].indexOf(10);
            if (idx == -1) {
                result = Math.max(result, line[0].length());
                continue;
            }
            result = Math.max(result, idx);
        }
        return result;
    }

    public int nbCols() {
        if (this.lines.size() == 0) {
            throw new IllegalStateException();
        }
        return this.lines.get(0).length;
    }

    private static String format(String s, int size, char format) {
        if (s.length() == size - 1) {
            return s + " ";
        }
        StringBuilder result = new StringBuilder(s);
        while (result.length() < size) {
            result.append(format);
        }
        return result.toString();
    }

    public void printMe(PrintStream out) {
        int size0 = this.sizeFirstColumn();
        for (String[] line : this.lines) {
            if (line[0].length() == 0) {
                out.println();
                out.println(line[1] + ":");
                continue;
            }
            String[] firstCol = line[0].split("\n");
            String[] secondCol = line[1].split("\n");
            if (firstCol.length == 2) {
                out.println(firstCol[0]);
                out.println("     " + HelpTable.format(firstCol[1] + " ", size0 + 2 - 5, '.') + " " + secondCol[0]);
                continue;
            }
            out.println(HelpTable.format(line[0] + " ", size0 + 2, '.') + " " + secondCol[0]);
            for (int i = 1; i < secondCol.length; ++i) {
                out.println(HelpTable.format(" ", size0 + 2, ' ') + " " + secondCol[i]);
            }
        }
    }
}

