/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.crash.CrashReportHandler;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.text.BackSlash;
import net.sourceforge.plantuml.utils.BlocLines;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class PSystemDitaa
extends AbstractPSystem {
    private final ConversionOptions options = new ConversionOptions();
    private final List<String> data = new ArrayList<String>();
    private int nbStartingSpace = Integer.MAX_VALUE;

    public PSystemDitaa(UmlSource source, boolean performSeparationOfCommonEdges, boolean dropShadows, boolean allCornersAreRound, boolean transparentBackground, float scale, PreprocessingArtifact preprocessing) {
        super(source, preprocessing);
        this.options.setDropShadows(dropShadows);
        this.options.renderingOptions.setBackgroundColor(transparentBackground ? new Color(0, 0, 0, 0) : Color.WHITE);
        this.options.renderingOptions.setScale(scale);
        this.options.processingOptions.setPerformSeparationOfCommonEdges(performSeparationOfCommonEdges);
        this.options.processingOptions.setAllCornersAreRound(allCornersAreRound);
    }

    void add(String line) {
        this.data.add(line);
        this.nbStartingSpace = Math.min(this.nbStartingSpace, BlocLines.nbStartingSpace(line));
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Ditaa)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        try {
            TextGrid grid = new TextGrid();
            ArrayList<StringBuilder> lines = new ArrayList<StringBuilder>();
            for (String s : this.data) {
                lines.add(new StringBuilder(s.substring(this.nbStartingSpace)));
            }
            grid.initialiseWithLines(lines, null);
            Diagram diagram = new Diagram(grid, this.options);
            BitmapRenderer bitmapRenderer = new BitmapRenderer();
            BufferedImage image = (BufferedImage)bitmapRenderer.renderToImage(diagram, this.options.renderingOptions);
            if (fileFormat.getFileFormat() == FileFormat.ATXT) {
                os.write(this.getSource().getPlainString(BackSlash.lineSeparator()).getBytes());
                return ImageDataSimple.ok();
            }
            SImageIO.write((RenderedImage)image, "png", os);
            return new ImageDataSimple(image.getWidth(), image.getHeight());
        }
        catch (Throwable e) {
            CrashReportHandler report = new CrashReportHandler(e, null, null);
            report.add("DITAA has crashed");
            report.addEmptyLine();
            report.youShouldSendThisDiagram();
            report.addEmptyLine();
            report.exportDiagramError(fileFormat, this.seed(), os);
            return ImageDataSimple.error();
        }
    }
}

