/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandGanttArrow2
extends SingleLineCommand2<GanttDiagram> {
    public CommandGanttArrow2() {
        super(CommandGanttArrow2.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandGanttArrow2.class.getName(), RegexLeaf.start(), new RegexLeaf("\\["), new RegexLeaf(1, "TASK1", "([^\\[\\]]+?)"), new RegexLeaf("\\]"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "(-+)"), new RegexLeaf(1, "ARROW_STYLE", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|node|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,node|,thickness=\\d+)*)\\])?"), new RegexLeaf(1, "(-*)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\["), new RegexLeaf(1, "TASK2", "([^\\[\\]]+?)"), new RegexLeaf("\\]"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String name1 = arg.get("TASK1", 0);
        String name2 = arg.get("TASK2", 0);
        Task task1 = diagram.getOrCreateTask(TaskCode.fromId(name1), false);
        Task task2 = diagram.getOrCreateTask(TaskCode.fromId(name2), false);
        GanttConstraint link = diagram.forceTaskOrder(task1, task2);
        link.applyStyle(arg.get("ARROW_STYLE", 0));
        return CommandExecutionResult.ok();
    }
}

