/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.lang.ComplementEmpty;
import net.sourceforge.plantuml.project.lang.Sentence;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public abstract class SentenceSimple<D extends Diagram>
implements Sentence<D> {
    private final Subject<D> subject;
    private final IRegex verb;
    private final IRegex adverbialOrPropositon;
    private final Something<D> complement;

    public SentenceSimple(Subject<D> subject, IRegex verb, Something<D> complement) {
        this(subject, verb, new RegexLeaf(""), complement);
    }

    public SentenceSimple(Subject<D> subject, IRegex verb, IRegex adverbialOrPropositon, Something<D> complement) {
        this.subject = subject;
        this.verb = verb;
        this.adverbialOrPropositon = adverbialOrPropositon;
        this.complement = complement;
    }

    public String getSignature() {
        return this.subject.getClass() + "/" + this.verb.getPatternAsString() + "/" + this.complement.getClass();
    }

    @Override
    public final IRegex toRegex() {
        if (this.complement instanceof ComplementEmpty) {
            return new RegexConcat(RegexLeaf.start(), this.subject.toRegex(), RegexLeaf.spaceOneOrMore(), this.verb, this.adverbialOrPropositon, OPTIONAL_FINAL_DOT);
        }
        return new RegexConcat(RegexLeaf.start(), this.subject.toRegex(), RegexLeaf.spaceOneOrMore(), this.verb, this.adverbialOrPropositon, RegexLeaf.spaceOneOrMore(), this.complement.toRegex("0"), OPTIONAL_FINAL_DOT);
    }

    @Override
    public final CommandExecutionResult execute(D project, RegexResult arg) {
        Failable<Object> currentSubject = this.subject.getMe(project, arg);
        if (currentSubject.isFail()) {
            return CommandExecutionResult.error(currentSubject.getError());
        }
        Failable<Object> currentComplement = this.complement.getMe(project, arg, "0");
        if (currentComplement.isFail()) {
            return CommandExecutionResult.error(currentComplement.getError());
        }
        return this.execute(project, currentSubject.get(), currentComplement.get());
    }

    public abstract CommandExecutionResult execute(D var1, Object var2, Object var3);

    public IRegex getVerbRegex() {
        return this.verb;
    }

    protected final IRegex getAdverbialOrPropositon() {
        return this.adverbialOrPropositon;
    }

    protected final Subject<D> getSubject() {
        return this.subject;
    }

    protected final Something<D> getComplement() {
        return this.complement;
    }
}

