/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;

public class EaterForeach
extends Eater {
    private String varname;
    private JsonValue jsonValue;

    public EaterForeach(StringLocated s) {
        super(s);
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException {
        this.skipSpaces();
        this.checkAndEatChar("!foreach");
        this.skipSpaces();
        this.varname = this.eatAndGetVarname();
        this.skipSpaces();
        this.checkAndEatChar("in");
        this.skipSpaces();
        TValue value = this.eatExpression(context, memory);
        this.jsonValue = value.toJson();
    }

    public boolean isSkip() {
        if (this.jsonValue == null) {
            return true;
        }
        return EaterForeach.size(this.jsonValue) == 0;
    }

    public static int size(JsonValue value) {
        if (value instanceof JsonArray) {
            return ((JsonArray)value).size();
        }
        if (value instanceof JsonObject) {
            return ((JsonObject)value).size();
        }
        throw new IllegalArgumentException();
    }

    public final String getVarname() {
        return this.varname;
    }

    public final JsonValue getJsonValue() {
        return this.jsonValue;
    }
}

