/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.timingdiagram.DeduceFormat;
import net.sourceforge.plantuml.timingdiagram.TimeTick;

public class TimeSeries {
    private final SortedMap<TimeTick, Double> values = new TreeMap<TimeTick, Double>();
    private Double minOverride;
    private Double maxOverride;
    private DecimalFormat format;

    public Collection<Double> values() {
        return this.values.values();
    }

    public Double get(TimeTick tick) {
        return (Double)this.values.get(tick);
    }

    public Set<Map.Entry<TimeTick, Double>> entrySet() {
        return this.values.entrySet();
    }

    public void put(TimeTick now, double value) {
        this.values.put(now, value);
    }

    public double getMin() {
        if (this.minOverride != null) {
            return this.minOverride;
        }
        double min = 0.0;
        for (Double val : this.values()) {
            min = Math.min(min, val);
        }
        return min;
    }

    public double getMax() {
        if (this.maxOverride != null) {
            return this.maxOverride;
        }
        double max = 0.0;
        for (Double val : this.values()) {
            max = Math.max(max, val);
        }
        if (max == 0.0) {
            return 10.0;
        }
        return max;
    }

    public void setBounds(String min, String max) {
        this.minOverride = Double.parseDouble(min);
        this.maxOverride = Double.parseDouble(max);
        DeduceFormat format1 = DeduceFormat.from(min);
        DeduceFormat format2 = DeduceFormat.from(max);
        this.format = format1.mergeWith(format2).getDecimalFormat();
    }

    public String getDisplayValue(double value) {
        if (this.format != null) {
            return this.format.format(value);
        }
        return "" + value;
    }

    public double getValueAt(TimeTick tick) {
        Double result = this.get(tick);
        if (result != null) {
            return result;
        }
        Map.Entry<TimeTick, Double> last = null;
        for (Map.Entry<TimeTick, Double> ent : this.entrySet()) {
            if (ent.getKey().compareTo(tick) > 0) {
                double v2 = ent.getValue();
                if (last == null) {
                    return v2;
                }
                double t2 = ent.getKey().getTime().doubleValue();
                double v1 = last.getValue();
                double t1 = last.getKey().getTime().doubleValue();
                double p = (tick.getTime().doubleValue() - t1) / (t2 - t1);
                return v1 + (v2 - v1) * p;
            }
            last = ent;
        }
        return (Double)last.getValue();
    }
}

