/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.UnsupportedGraphException;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class DepthFirstModelOrderLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBefore(LayeredPhases.P2_LAYERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_PREPROCESSOR).addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_POSTPROCESSOR);
    private LGraph layeredGraph;
    private Layer currentLayer;
    private int currentLayerId;
    private Layer currentDummyLayer;
    private List<LNode> nodesToPlace;
    private int maxToPlace = 0;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return BASELINE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph thelayeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Depth first model order layering", 1.0f);
        this.layeredGraph = thelayeredGraph;
        ArrayList<LNode> realNodes = new ArrayList<LNode>();
        for (LNode node : this.layeredGraph.getLayerlessNodes()) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            realNodes.add(node);
        }
        Collections.sort(realNodes, (n1, n2) -> {
            if (n1.hasProperty(InternalProperties.MODEL_ORDER) && n2.hasProperty(InternalProperties.MODEL_ORDER)) {
                return Integer.compare(n1.getProperty(InternalProperties.MODEL_ORDER), n2.getProperty(InternalProperties.MODEL_ORDER));
            }
            throw new UnsupportedGraphException("The DF model order layer assigner requires all real nodes to have a model order.");
        });
        boolean firstNode = true;
        this.currentLayer = new Layer(this.layeredGraph);
        this.currentDummyLayer = null;
        this.layeredGraph.getLayers().add(this.currentLayer);
        this.currentLayer.id = 0;
        this.currentLayerId = 0;
        this.nodesToPlace = new LinkedList<LNode>();
        for (LNode node : realNodes) {
            if (firstNode) {
                node.setLayer(this.currentLayer);
                firstNode = false;
                continue;
            }
            if (this.isConnectedToCurrentLayer(node)) {
                int maxLayer = this.currentLayerId;
                maxLayer = this.getMaxConnectedLayer(maxLayer, node);
                int desiredLayer = maxLayer + 2;
                int layerDiff = maxLayer - this.currentLayerId;
                if (!this.nodesToPlace.isEmpty()) {
                    if (layerDiff > 0) {
                        for (LNode toPlace : this.nodesToPlace) {
                            toPlace.id += maxLayer - this.maxToPlace;
                        }
                        this.placeNodesToPlace();
                        this.nodesToPlace.clear();
                        this.addNodeToLayer(desiredLayer, node);
                        continue;
                    }
                    this.nodesToPlace.add(node);
                    node.id = desiredLayer;
                    this.maxToPlace = Math.max(this.maxToPlace, desiredLayer);
                    for (LEdge edge : node.getIncomingEdges()) {
                        if (edge.getSource().getNode().getLayer() != null || edge.getSource().getNode().getType() != LNode.NodeType.LABEL) continue;
                        this.nodesToPlace.add(edge.getSource().getNode());
                        edge.getSource().getNode().id = desiredLayer - 1;
                    }
                    this.currentLayerId = desiredLayer;
                    continue;
                }
                this.addNodeToLayer(desiredLayer, node);
                continue;
            }
            this.placeNodesToPlace();
            this.nodesToPlace.clear();
            int desiredLayer = 0;
            if (!node.getIncomingEdges().iterator().hasNext()) {
                this.nodesToPlace.add(node);
                node.id = 0;
                this.maxToPlace = Math.max(this.maxToPlace, 0);
                this.currentLayer = this.layeredGraph.getLayers().get(0);
                this.currentLayerId = 0;
                continue;
            }
            int maxLayer = 0;
            maxLayer = this.getMaxConnectedLayer(maxLayer, node);
            desiredLayer = maxLayer + 2;
            this.addNodeToLayer(desiredLayer, node);
        }
        if (!this.nodesToPlace.isEmpty()) {
            this.placeNodesToPlace();
        }
        this.layeredGraph.getLayerlessNodes().clear();
        ArrayList<Layer> toDelete = new ArrayList<Layer>();
        for (Layer layer : this.layeredGraph.getLayers()) {
            if (!layer.getNodes().isEmpty()) continue;
            toDelete.add(layer);
        }
        this.layeredGraph.getLayers().removeAll(toDelete);
        int layerId = 0;
        for (Layer layer : this.layeredGraph.getLayers()) {
            layer.id = layerId++;
        }
        monitor.done();
    }

    private boolean isConnectedToCurrentLayer(LNode node) {
        for (LEdge edge : node.getIncomingEdges()) {
            boolean connectedViaLabelDummy;
            boolean directlyConnected;
            if (this.nodesToPlace.isEmpty()) {
                boolean bl = directlyConnected = edge.getSource().getNode().getType() == LNode.NodeType.NORMAL && edge.getSource().getNode().getLayer() != null && edge.getSource().getNode().getLayer().id == this.currentLayerId;
                if (edge.getSource().getNode().getIncomingEdges().iterator().hasNext()) {
                    Layer connectedLayerViaDummy = edge.getSource().getNode().getIncomingEdges().iterator().next().getSource().getNode().getLayer();
                    connectedViaLabelDummy = edge.getSource().getNode().getType() == LNode.NodeType.LABEL && connectedLayerViaDummy != null && connectedLayerViaDummy.id == this.currentLayerId;
                } else {
                    connectedViaLabelDummy = false;
                }
            } else {
                directlyConnected = edge.getSource().getNode().getType() == LNode.NodeType.NORMAL && edge.getSource().getNode().id == this.currentLayerId;
                boolean bl = connectedViaLabelDummy = edge.getSource().getNode().getType() == LNode.NodeType.LABEL && edge.getSource().getNode().getIncomingEdges().iterator().next().getSource().getNode().id == this.currentLayerId;
            }
            if (!directlyConnected && !connectedViaLabelDummy) continue;
            return true;
        }
        return false;
    }

    private void addNodeToLayer(int layerId, LNode node) {
        if (layerId < this.layeredGraph.getLayers().size()) {
            this.currentLayer = this.layeredGraph.getLayers().get(layerId);
            this.currentDummyLayer = this.layeredGraph.getLayers().get(layerId - 1);
            this.currentLayerId = layerId;
        } else {
            this.currentDummyLayer = new Layer(this.layeredGraph);
            this.currentDummyLayer.id = layerId - 1;
            this.layeredGraph.getLayers().add(this.currentDummyLayer);
            this.currentLayer = new Layer(this.layeredGraph);
            this.currentLayer.id = layerId;
            this.layeredGraph.getLayers().add(this.currentLayer);
            this.currentLayerId = layerId;
        }
        node.setLayer(this.currentLayer);
        for (LEdge edge : node.getIncomingEdges()) {
            if (edge.getSource().getNode().getLayer() != null || edge.getSource().getNode().getType() != LNode.NodeType.LABEL) continue;
            edge.getSource().getNode().setLayer(this.currentDummyLayer);
        }
    }

    private int getMaxConnectedLayer(int layerId, LNode node) {
        int maxLayer = layerId;
        for (LEdge edge : node.getIncomingEdges()) {
            if (edge.getSource().getNode().getLayer() == null) continue;
            maxLayer = Math.max(maxLayer, edge.getSource().getNode().getLayer().id);
        }
        return maxLayer;
    }

    public void placeNodesToPlace() {
        this.maxToPlace = 0;
        for (LNode nodeToPlace : this.nodesToPlace) {
            if (nodeToPlace.id >= this.layeredGraph.getLayers().size()) {
                Layer dummyLayer = new Layer(this.layeredGraph);
                dummyLayer.id = nodeToPlace.id - 1;
                this.layeredGraph.getLayers().add(dummyLayer);
                Layer newLayer = new Layer(this.layeredGraph);
                newLayer.id = nodeToPlace.id;
                this.layeredGraph.getLayers().add(newLayer);
            }
            nodeToPlace.setLayer(this.layeredGraph.getLayers().get(nodeToPlace.id));
        }
    }
}

