/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;

public final class TreeUtil {
    private TreeUtil() {
    }

    public static TNode getRoot(TGraph tGraph) {
        return tGraph.getNodes().stream().filter(x -> x.getProperty(InternalProperties.ROOT)).findFirst().get();
    }

    public static int depth(TNode root) {
        List<TNode> childs = TreeUtil.getChildren(root);
        if (childs.size() == 0) {
            return 1;
        }
        return childs.stream().map(x -> TreeUtil.depth(x)).max(Integer::compare).get() + 1;
    }

    public static List<TNode> getChildren(TNode n) {
        ArrayList<TNode> re = new ArrayList<TNode>();
        for (TEdge out : n.getOutgoingEdges()) {
            re.add(out.getTarget());
        }
        re = re.stream().distinct().collect(Collectors.toList());
        return re;
    }

    public static int rootDistance(TNode n, TNode root) {
        if (n == root) {
            return 0;
        }
        TNode p = n.getIncomingEdges().get(0).getSource();
        return TreeUtil.rootDistance(p, root) + 1;
    }

    public static List<TEdge> getAllIncomingEdges(TNode n, TGraph graph) {
        ArrayList<TEdge> re = new ArrayList<TEdge>();
        for (TEdge e : graph.getEdges()) {
            if (e.getTarget().id != n.id || e.getSource().getProperty(MrTreeOptions.TREE_LEVEL) == e.getTarget().getProperty(MrTreeOptions.TREE_LEVEL) || re.stream().anyMatch(x -> x.toString().equals(e.toString()))) continue;
            re.add(e);
        }
        re.sort((x, y) -> Double.compare(x.getSource().getPosition().x, y.getSource().getPosition().x));
        return re;
    }

    public static List<TNode> getSubtree(TNode n) {
        if (TreeUtil.getChildren(n).size() == 0) {
            ArrayList<TNode> re = new ArrayList<TNode>();
            re.add(n);
            return re;
        }
        List re = TreeUtil.getChildren(n).stream().map(x -> TreeUtil.getSubtree(x)).reduce((x, y) -> {
            ArrayList ree = new ArrayList();
            ree.addAll(x);
            ree.addAll(y);
            return ree;
        }).get();
        re.add(n);
        return re;
    }

    public static List<TEdge> getAllOutgoingEdges(TNode n, TGraph graph) {
        ArrayList<TEdge> re = new ArrayList<TEdge>();
        for (TEdge e : graph.getEdges()) {
            if (e.getSource().id != n.id || e.getSource().getLabel().equals("SUPER_ROOT") || e.getSource().getProperty(MrTreeOptions.TREE_LEVEL) == e.getTarget().getProperty(MrTreeOptions.TREE_LEVEL) || re.stream().anyMatch(x -> x.toString().equals(e.toString()))) continue;
            re.add(e);
        }
        re.sort((x, y) -> Double.compare(x.getTarget().getPosition().x, y.getTarget().getPosition().x));
        return re;
    }

    public static KVector getFirstPoint(TEdge e) {
        if (e.getBendPoints().size() == 0) {
            return new KVector(e.getTarget().getPosition().x, e.getTarget().getPosition().y);
        }
        return (KVector)e.getBendPoints().getFirst();
    }

    public static KVector getLastPoint(TEdge e) {
        if (e.getBendPoints().size() == 0) {
            return new KVector(e.getSource().getPosition().x, e.getSource().getPosition().y);
        }
        return (KVector)e.getBendPoints().getLast();
    }

    public static Direction getDirection(TGraph g) {
        return g.getProperty(MrTreeOptions.DIRECTION);
    }

    public static KVector getDirectionVector(Direction d) {
        switch (d) {
            case UP: {
                return new KVector(0.0, -1.0);
            }
            case RIGHT: {
                return new KVector(1.0, 0.0);
            }
            case LEFT: {
                return new KVector(-1.0, 0.0);
            }
        }
        return new KVector(0.0, 1.0);
    }

    public static double getNodeSizeInDirection(TNode n, Direction d) {
        if (d == Direction.LEFT) {
            return -n.getSize().x / 2.0;
        }
        if (d == Direction.UP) {
            return -n.getSize().y / 2.0;
        }
        if (d == Direction.RIGHT) {
            return n.getSize().x / 2.0;
        }
        return n.getSize().y / 2.0;
    }

    public static KVector getNodeSizeVectorInDirection(TNode n, Direction d) {
        if (d == Direction.LEFT) {
            return new KVector(-n.getSize().x / 2.0, 0.0);
        }
        if (d == Direction.UP) {
            return new KVector(0.0, -n.getSize().y / 2.0);
        }
        if (d == Direction.RIGHT) {
            return new KVector(n.getSize().x / 2.0, 0.0);
        }
        return new KVector(0.0, n.getSize().y / 2.0);
    }

    public static Direction turnRight(Direction d) {
        if (d == Direction.LEFT) {
            return Direction.UP;
        }
        if (d == Direction.UP) {
            return Direction.RIGHT;
        }
        if (d == Direction.RIGHT) {
            return Direction.DOWN;
        }
        return Direction.LEFT;
    }

    public static Direction turnLeft(Direction d) {
        if (d == Direction.RIGHT) {
            return Direction.UP;
        }
        if (d == Direction.UP) {
            return Direction.LEFT;
        }
        if (d == Direction.LEFT) {
            return Direction.DOWN;
        }
        return Direction.RIGHT;
    }

    public static void toNodeBorder(KVector center, KVector next, KVector size) {
        double wh = size.x / 2.0;
        double hh = size.y / 2.0;
        double absx = Math.abs(next.x - center.x);
        double absy = Math.abs(next.y - center.y);
        double xscale = 1.0;
        double yscale = 1.0;
        if (absx > wh) {
            xscale = wh / absx;
        }
        if (absy > hh) {
            yscale = hh / absy;
        }
        double scale = Math.min(xscale, yscale);
        center.x += scale * (next.x - center.x);
        center.y += scale * (next.y - center.y);
    }

    public static boolean isCycleInducing(TEdge e, TGraph g) {
        return TreeUtil.getDirectionVector(TreeUtil.getDirection(g)).dotProduct(new KVector(e.getTarget().getPosition().x - e.getSource().getPosition().x, e.getTarget().getPosition().y - e.getSource().getPosition().y)) <= 0.0;
    }

    public static long getUniqueLong(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    public static TNode getLowestParent(TNode n, TGraph g) {
        KVector dirVec = TreeUtil.getDirectionVector(TreeUtil.getDirection(g));
        if (n.getIncomingEdges().size() == 0) {
            return null;
        }
        List sources = n.getIncomingEdges().stream().map(x -> x.getSource()).collect(Collectors.toList());
        List parents = g.getNodes().stream().filter(x -> sources.contains(x)).collect(Collectors.toList());
        Double lowestParentPos = parents.stream().map(x -> new KVector(x.getPosition().x + x.getSize().x / 2.0, x.getPosition().y + x.getSize().y / 2.0).dotProduct(dirVec)).max(Comparator.naturalOrder()).get();
        TNode lowestParent = parents.stream().filter(x -> new KVector(x.getPosition().x + x.getSize().x / 2.0, x.getPosition().y + x.getSize().y / 2.0).dotProduct(dirVec) == lowestParentPos.doubleValue()).findFirst().get();
        return lowestParent;
    }

    public static TNode getLeftMost(Iterable<TNode> currentlevel) {
        return TreeUtil.getLeftMost(currentlevel, -1);
    }

    public static TNode getLeftMost(Iterable<TNode> currentlevel, int depth) {
        if (Iterables.size(currentlevel) > 0) {
            int d = depth;
            if (1 < d) {
                --d;
                Iterable<TNode> nextLevel = new Iterable<TNode>(){

                    @Override
                    public Iterator<TNode> iterator() {
                        return Collections.emptyIterator();
                    }
                };
                for (TNode cN : currentlevel) {
                    nextLevel = Iterables.concat(nextLevel, cN.getChildren());
                }
                return TreeUtil.getLeftMost(nextLevel, d);
            }
            if (d < 0) {
                Iterable<TNode> nextLevel = new Iterable<TNode>(){

                    @Override
                    public Iterator<TNode> iterator() {
                        return Collections.emptyIterator();
                    }
                };
                for (TNode cN : currentlevel) {
                    nextLevel = Iterables.concat(nextLevel, cN.getChildren());
                }
                if (Iterables.size(nextLevel) > 0) {
                    return TreeUtil.getLeftMost(nextLevel, d);
                }
            }
        }
        return Iterables.getFirst(currentlevel, null);
    }
}

