/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import org.assertj.core.api.Fail;
import org.assertj.core.util.Lists;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.ComponentFinder;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.Formatting;

class UnexpectedJOptionPaneFinder {
    static final ComponentMatcher OPTION_PANE_MATCHER = new TypeMatcher(JOptionPane.class, true);
    private final ComponentFinder finder;

    UnexpectedJOptionPaneFinder(@Nonnull ComponentFinder finder) {
        this.finder = finder;
    }

    @RunsInEDT
    void requireNoJOptionPaneIsShowing() {
        List<Component> found = this.findAll(OPTION_PANE_MATCHER);
        if (!found.isEmpty()) {
            this.unexpectedJOptionPanesFound(found);
        }
    }

    private List<Component> findAll(@Nonnull ComponentMatcher m) {
        return Lists.newArrayList(this.finder.findAll(m));
    }

    private void unexpectedJOptionPanesFound(@Nonnull List<Component> found) {
        StringBuilder message = new StringBuilder();
        message.append("Expecting no JOptionPane to be showing, but found:<[");
        int size = found.size();
        for (int i = 0; i < size; ++i) {
            message.append(Formatting.format(found.get(i)));
            if (i == size - 1) continue;
            message.append(", ");
        }
        message.append("]>");
        Fail.fail((String)message.toString());
    }
}

