"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
LINT: LEGACY_NAMES"""

import builtins
import collections.abc
import sys
import typing

import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DataType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DataTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DataType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    kFloat: _DataType.ValueType  # 0
    kDouble: _DataType.ValueType  # 1
    kHalf: _DataType.ValueType  # 2
    kInt8: _DataType.ValueType  # 3
    kInt32: _DataType.ValueType  # 4
    kComplexFloat: _DataType.ValueType  # 5
    kComplexDouble: _DataType.ValueType  # 6
    kBF16: _DataType.ValueType  # 7
    kF8E5M2: _DataType.ValueType  # 8
    kF8E4M3FN: _DataType.ValueType  # 9
    kF8E5M2FNUZ: _DataType.ValueType  # 10
    kF8E4M3FNUZ: _DataType.ValueType  # 11
    kInt64: _DataType.ValueType  # 12

class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper):
    """Specifies the data type used by an operation."""

kFloat: DataType.ValueType  # 0
kDouble: DataType.ValueType  # 1
kHalf: DataType.ValueType  # 2
kInt8: DataType.ValueType  # 3
kInt32: DataType.ValueType  # 4
kComplexFloat: DataType.ValueType  # 5
kComplexDouble: DataType.ValueType  # 6
kBF16: DataType.ValueType  # 7
kF8E5M2: DataType.ValueType  # 8
kF8E4M3FN: DataType.ValueType  # 9
kF8E5M2FNUZ: DataType.ValueType  # 10
kF8E4M3FNUZ: DataType.ValueType  # 11
kInt64: DataType.ValueType  # 12
global___DataType = DataType

class _DataLayout:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DataLayoutEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DataLayout.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    kYXDepthBatch: _DataLayout.ValueType  # 0
    """Naming convention:
    Y <-> row or height
    X <-> column or width
    Batch <-> batch, or N
    Depth <-> feature, or channel
    TODO(timshen): turn them into cuDNN names, e.g. kNCHW.

    Note: In cudnn, kBatchDepthYX4 and kBatchDepthYX32 are the same layout
    (namely, NCHW_VECT_C).  It differentiates between these two by using a
    different data type (int8x4 vs int8x32).  In StreamExecutor we use
    different layouts for these, because we don't usually pass an explicit data
    type to StreamExecutor functions.
    """
    kYXBatchDepth: _DataLayout.ValueType  # 1
    kBatchYXDepth: _DataLayout.ValueType  # 2
    """cuDNN's NHWC layout"""
    kBatchDepthYX: _DataLayout.ValueType  # 3
    """cuDNN's NCHW layout"""
    kBatchDepthYX4: _DataLayout.ValueType  # 4
    """cuDNN's NCHW_VECT_C with 4-elem vectors (e.g. int8x4)"""
    kBatchDepthYX32: _DataLayout.ValueType  # 5
    """cuDNN's NCHW_VECT_C with 32-elem vects (e.g. int8x32)"""

class DataLayout(_DataLayout, metaclass=_DataLayoutEnumTypeWrapper):
    """Describes how a convolution input or output layer's data is formatted."""

kYXDepthBatch: DataLayout.ValueType  # 0
"""Naming convention:
Y <-> row or height
X <-> column or width
Batch <-> batch, or N
Depth <-> feature, or channel
TODO(timshen): turn them into cuDNN names, e.g. kNCHW.

Note: In cudnn, kBatchDepthYX4 and kBatchDepthYX32 are the same layout
(namely, NCHW_VECT_C).  It differentiates between these two by using a
different data type (int8x4 vs int8x32).  In StreamExecutor we use
different layouts for these, because we don't usually pass an explicit data
type to StreamExecutor functions.
"""
kYXBatchDepth: DataLayout.ValueType  # 1
kBatchYXDepth: DataLayout.ValueType  # 2
"""cuDNN's NHWC layout"""
kBatchDepthYX: DataLayout.ValueType  # 3
"""cuDNN's NCHW layout"""
kBatchDepthYX4: DataLayout.ValueType  # 4
"""cuDNN's NCHW_VECT_C with 4-elem vectors (e.g. int8x4)"""
kBatchDepthYX32: DataLayout.ValueType  # 5
"""cuDNN's NCHW_VECT_C with 32-elem vects (e.g. int8x32)"""
global___DataLayout = DataLayout

class _FilterLayout:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FilterLayoutEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FilterLayout.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    kOutputInputYX: _FilterLayout.ValueType  # 0
    """Naming convention:
    Y <-> row or height
    X <-> column or width
    Output <-> output feature, or N
    Input <-> input feature, or N
    TODO(timshen): turn them into cuDNN names, e.g. kNCHW.
    cuDNN's NCHW layout
    """
    kOutputYXInput: _FilterLayout.ValueType  # 1
    """cuDNN's NHWC layout"""
    kOutputInputYX4: _FilterLayout.ValueType  # 2
    """cuDNN's NCHW_VECT_C layout with 4-elem vectors"""
    kOutputInputYX32: _FilterLayout.ValueType  # 5
    """cuDNN's NCHW_VECT_C layout with 32-elem vectors"""
    kOutputInputYX32_CudnnReordered: _FilterLayout.ValueType  # 6
    """cuDNN-specific filter reordering (using `cudnnReorderFilterAndBias`)
    When the filter is reordered, so is the bias (if present).
    """
    kInputYXOutput: _FilterLayout.ValueType  # 3
    kYXInputOutput: _FilterLayout.ValueType  # 4

class FilterLayout(_FilterLayout, metaclass=_FilterLayoutEnumTypeWrapper):
    """Describes how a convolution filter is laid out in the memory."""

kOutputInputYX: FilterLayout.ValueType  # 0
"""Naming convention:
Y <-> row or height
X <-> column or width
Output <-> output feature, or N
Input <-> input feature, or N
TODO(timshen): turn them into cuDNN names, e.g. kNCHW.
cuDNN's NCHW layout
"""
kOutputYXInput: FilterLayout.ValueType  # 1
"""cuDNN's NHWC layout"""
kOutputInputYX4: FilterLayout.ValueType  # 2
"""cuDNN's NCHW_VECT_C layout with 4-elem vectors"""
kOutputInputYX32: FilterLayout.ValueType  # 5
"""cuDNN's NCHW_VECT_C layout with 32-elem vectors"""
kOutputInputYX32_CudnnReordered: FilterLayout.ValueType  # 6
"""cuDNN-specific filter reordering (using `cudnnReorderFilterAndBias`)
When the filter is reordered, so is the bias (if present).
"""
kInputYXOutput: FilterLayout.ValueType  # 3
kYXInputOutput: FilterLayout.ValueType  # 4
global___FilterLayout = FilterLayout

class _ActivationMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ActivationModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ActivationMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    kNone: _ActivationMode.ValueType  # 0
    kSigmoid: _ActivationMode.ValueType  # 1
    kRelu: _ActivationMode.ValueType  # 2
    """Rectified linear activation: f(x) = x < 0 ? 0 : x"""
    kRelu6: _ActivationMode.ValueType  # 3
    """Rectified linear activation; where upper maximum is 6.0."""
    kReluX: _ActivationMode.ValueType  # 4
    """Rectified linear activation; where upper maximum specified by
    BatchDescriptor::value_max().
    """
    kTanh: _ActivationMode.ValueType  # 5
    kBandPass: _ActivationMode.ValueType  # 6
    """Like ReluX; but passes all values in the range [-X,X]."""
    kElu: _ActivationMode.ValueType  # 7
    """Exponential linear activation: f(x) = x < 0 ? e^x - 1 : x"""
    kLeakyRelu: _ActivationMode.ValueType  # 8
    """Leaky Rectified linear activation: f(x) = x < 0 ? alpha * x : x"""
    kGeluExact: _ActivationMode.ValueType  # 9
    """Gaussian Error linear unit activation:
      x * P(X <= x) = 0.5 * x * (1 + erf(x / sqrt(2))), where P(X) ~ N(0, 1).
    """

class ActivationMode(_ActivationMode, metaclass=_ActivationModeEnumTypeWrapper):
    """Describes a kind of non-linearity (threshold-like mathematical function)."""

kNone: ActivationMode.ValueType  # 0
kSigmoid: ActivationMode.ValueType  # 1
kRelu: ActivationMode.ValueType  # 2
"""Rectified linear activation: f(x) = x < 0 ? 0 : x"""
kRelu6: ActivationMode.ValueType  # 3
"""Rectified linear activation; where upper maximum is 6.0."""
kReluX: ActivationMode.ValueType  # 4
"""Rectified linear activation; where upper maximum specified by
BatchDescriptor::value_max().
"""
kTanh: ActivationMode.ValueType  # 5
kBandPass: ActivationMode.ValueType  # 6
"""Like ReluX; but passes all values in the range [-X,X]."""
kElu: ActivationMode.ValueType  # 7
"""Exponential linear activation: f(x) = x < 0 ? e^x - 1 : x"""
kLeakyRelu: ActivationMode.ValueType  # 8
"""Leaky Rectified linear activation: f(x) = x < 0 ? alpha * x : x"""
kGeluExact: ActivationMode.ValueType  # 9
"""Gaussian Error linear unit activation:
  x * P(X <= x) = 0.5 * x * (1 + erf(x / sqrt(2))), where P(X) ~ N(0, 1).
"""
global___ActivationMode = ActivationMode

class _ConvolutionMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ConvolutionModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ConvolutionMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CROSS_CORRELATION: _ConvolutionMode.ValueType  # 0
    CONVOLUTION: _ConvolutionMode.ValueType  # 1

class ConvolutionMode(_ConvolutionMode, metaclass=_ConvolutionModeEnumTypeWrapper):
    """Describe the math definition for the conv op. The popular behavior is
    actually called cross-correlation in math, despite the operation is often
    referred as convolution. See cuDNN cudnnConvolutionMode_t.
    """

CROSS_CORRELATION: ConvolutionMode.ValueType  # 0
CONVOLUTION: ConvolutionMode.ValueType  # 1
global___ConvolutionMode = ConvolutionMode

class _ConvolutionKind:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ConvolutionKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ConvolutionKind.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INVALID: _ConvolutionKind.ValueType  # 0
    FORWARD: _ConvolutionKind.ValueType  # 1
    BACKWARD_FILTER: _ConvolutionKind.ValueType  # 2
    BACKWARD_DATA: _ConvolutionKind.ValueType  # 3
    FORWARD_BIAS_ACTIVATION: _ConvolutionKind.ValueType  # 4
    FORWARD_GRAPH: _ConvolutionKind.ValueType  # 5

class ConvolutionKind(_ConvolutionKind, metaclass=_ConvolutionKindEnumTypeWrapper): ...

INVALID: ConvolutionKind.ValueType  # 0
FORWARD: ConvolutionKind.ValueType  # 1
BACKWARD_FILTER: ConvolutionKind.ValueType  # 2
BACKWARD_DATA: ConvolutionKind.ValueType  # 3
FORWARD_BIAS_ACTIVATION: ConvolutionKind.ValueType  # 4
FORWARD_GRAPH: ConvolutionKind.ValueType  # 5
global___ConvolutionKind = ConvolutionKind

class _NormKind:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _NormKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_NormKind.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LAYER_FWD_INFER: _NormKind.ValueType  # 0
    LAYER_FWD_TRAIN: _NormKind.ValueType  # 1
    LAYER_BWD: _NormKind.ValueType  # 2

class NormKind(_NormKind, metaclass=_NormKindEnumTypeWrapper):
    """NormKind kind"""

LAYER_FWD_INFER: NormKind.ValueType  # 0
LAYER_FWD_TRAIN: NormKind.ValueType  # 1
LAYER_BWD: NormKind.ValueType  # 2
global___NormKind = NormKind

class _FusedMHAKind:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FusedMHAKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FusedMHAKind.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BMM1_OUTPUT_UNKNOWN: _FusedMHAKind.ValueType  # 0
    BMM1_OUTPUT_INPUT_TYPE: _FusedMHAKind.ValueType  # 1
    BMM1_OUTPUT_FLOAT: _FusedMHAKind.ValueType  # 2

class FusedMHAKind(_FusedMHAKind, metaclass=_FusedMHAKindEnumTypeWrapper):
    """FusedMHAKind kind"""

BMM1_OUTPUT_UNKNOWN: FusedMHAKind.ValueType  # 0
BMM1_OUTPUT_INPUT_TYPE: FusedMHAKind.ValueType  # 1
BMM1_OUTPUT_FLOAT: FusedMHAKind.ValueType  # 2
global___FusedMHAKind = FusedMHAKind

class _FMHAMaskKind:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FMHAMaskKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FMHAMaskKind.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NO_MASK: _FMHAMaskKind.ValueType  # 0
    PADDING: _FMHAMaskKind.ValueType  # 1
    CAUSAL: _FMHAMaskKind.ValueType  # 2
    PADDING_CAUSAL: _FMHAMaskKind.ValueType  # 3
    ALIBI: _FMHAMaskKind.ValueType  # 4

class FMHAMaskKind(_FMHAMaskKind, metaclass=_FMHAMaskKindEnumTypeWrapper):
    """FusedMHAMaskKind kind"""

NO_MASK: FMHAMaskKind.ValueType  # 0
PADDING: FMHAMaskKind.ValueType  # 1
CAUSAL: FMHAMaskKind.ValueType  # 2
PADDING_CAUSAL: FMHAMaskKind.ValueType  # 3
ALIBI: FMHAMaskKind.ValueType  # 4
global___FMHAMaskKind = FMHAMaskKind

@typing.final
class TensorDescriptorProto(google.protobuf.message.Message):
    """Generic tensor representation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIMENSIONS_FIELD_NUMBER: builtins.int
    DATA_TYPE_FIELD_NUMBER: builtins.int
    DATA_LAYOUT_FIELD_NUMBER: builtins.int
    FILTER_LAYOUT_FIELD_NUMBER: builtins.int
    data_type: global___DataType.ValueType
    data_layout: global___DataLayout.ValueType
    filter_layout: global___FilterLayout.ValueType
    @property
    def dimensions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        dimensions: collections.abc.Iterable[builtins.int] | None = ...,
        data_type: global___DataType.ValueType | None = ...,
        data_layout: global___DataLayout.ValueType | None = ...,
        filter_layout: global___FilterLayout.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data_layout", b"data_layout", "filter_layout", b"filter_layout", "layout_oneof", b"layout_oneof"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data_layout", b"data_layout", "data_type", b"data_type", "dimensions", b"dimensions", "filter_layout", b"filter_layout", "layout_oneof", b"layout_oneof"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["layout_oneof", b"layout_oneof"]) -> typing.Literal["data_layout", "filter_layout"] | None: ...

global___TensorDescriptorProto = TensorDescriptorProto

@typing.final
class AlgorithmProto(google.protobuf.message.Message):
    """Generic algorithm representation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MathType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MathTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AlgorithmProto._MathType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DEFAULT_MATH: AlgorithmProto._MathType.ValueType  # 0
        TENSOR_OP_MATH: AlgorithmProto._MathType.ValueType  # 1
        """The GPU may operate 4x4 matrix FMA.
        See cuDNN's documentation for CUDNN_TENSOR_OP_MATH.
        """

    class MathType(_MathType, metaclass=_MathTypeEnumTypeWrapper): ...
    DEFAULT_MATH: AlgorithmProto.MathType.ValueType  # 0
    TENSOR_OP_MATH: AlgorithmProto.MathType.ValueType  # 1
    """The GPU may operate 4x4 matrix FMA.
    See cuDNN's documentation for CUDNN_TENSOR_OP_MATH.
    """

    @typing.final
    class TuningKnobsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.int | None = ...,
            value: builtins.int | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ALGO_ID_FIELD_NUMBER: builtins.int
    MATH_TYPE_FIELD_NUMBER: builtins.int
    TUNING_KNOBS_FIELD_NUMBER: builtins.int
    IS_CUDNN_FRONTEND_FIELD_NUMBER: builtins.int
    WORKSPACE_SIZE_FIELD_NUMBER: builtins.int
    algo_id: builtins.int
    math_type: global___AlgorithmProto.MathType.ValueType
    is_cudnn_frontend: builtins.bool
    """Legacy algorithm enums and cuDNN Frontend engine numbers need to coexist in
    the same proto medium-term, until we can be confident of no longer needing
    the legacy cuDNN convolution API.  Once the migration is complete, we can
    stop producing legacy algorithm enums and remove this field.
    """
    @property
    def tuning_knobs(self) -> google.protobuf.internal.containers.ScalarMap[builtins.int, builtins.int]: ...
    @property
    def workspace_size(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """For ROCm only, it's impossible to re-query the required workspace size
        after running the algorithm search, so we must store the workspace size
        along with the choice of algorithm.  For consistency and convenience,
        cuDNN uses this field in the same way, even though it would be possible to
        re-query the workspace size from cuDNN at each use.

        Since this message is persisted in files, we need to be able to distinguish
        0 workspace size from unknown workspace size in an old message, so this is
        a message field.
        """

    def __init__(
        self,
        *,
        algo_id: builtins.int | None = ...,
        math_type: global___AlgorithmProto.MathType.ValueType | None = ...,
        tuning_knobs: collections.abc.Mapping[builtins.int, builtins.int] | None = ...,
        is_cudnn_frontend: builtins.bool | None = ...,
        workspace_size: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["workspace_size", b"workspace_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["algo_id", b"algo_id", "is_cudnn_frontend", b"is_cudnn_frontend", "math_type", b"math_type", "tuning_knobs", b"tuning_knobs", "workspace_size", b"workspace_size"]) -> None: ...

global___AlgorithmProto = AlgorithmProto

@typing.final
class AlgorithmConfigProto(google.protobuf.message.Message):
    """Proto definition of AlgorithmConfig in "dnn.h".
    TODO(ruochengw): After cl/380702564 is submitted, add support for algorithm
    configs with cuDNN Frontend APIs.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALGORITHM_FIELD_NUMBER: builtins.int
    ALGORITHM_NO_SCRATCH_FIELD_NUMBER: builtins.int
    SCRATCH_SIZE_FIELD_NUMBER: builtins.int
    scratch_size: builtins.int
    @property
    def algorithm(self) -> global___AlgorithmProto: ...
    @property
    def algorithm_no_scratch(self) -> global___AlgorithmProto: ...
    def __init__(
        self,
        *,
        algorithm: global___AlgorithmProto | None = ...,
        algorithm_no_scratch: global___AlgorithmProto | None = ...,
        scratch_size: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["algorithm", b"algorithm", "algorithm_no_scratch", b"algorithm_no_scratch", "optional_algorithm", b"optional_algorithm", "optional_algorithm_no_scratch", b"optional_algorithm_no_scratch", "optional_scratch_size", b"optional_scratch_size", "scratch_size", b"scratch_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "algorithm_no_scratch", b"algorithm_no_scratch", "optional_algorithm", b"optional_algorithm", "optional_algorithm_no_scratch", b"optional_algorithm_no_scratch", "optional_scratch_size", b"optional_scratch_size", "scratch_size", b"scratch_size"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["optional_algorithm", b"optional_algorithm"]) -> typing.Literal["algorithm"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["optional_algorithm_no_scratch", b"optional_algorithm_no_scratch"]) -> typing.Literal["algorithm_no_scratch"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["optional_scratch_size", b"optional_scratch_size"]) -> typing.Literal["scratch_size"] | None: ...

global___AlgorithmConfigProto = AlgorithmConfigProto

@typing.final
class ConvolutionDescriptorProto(google.protobuf.message.Message):
    """Convolution-specific parameters."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PADDINGS_FIELD_NUMBER: builtins.int
    STRIDES_FIELD_NUMBER: builtins.int
    DILATIONS_FIELD_NUMBER: builtins.int
    COMPUTE_MODE_FIELD_NUMBER: builtins.int
    GROUP_COUNT_FIELD_NUMBER: builtins.int
    CONVOLUTION_MODE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    compute_mode: global___DataType.ValueType
    """The "accumulator" type. For example, use F32 as an accumulator for F16
    convolutions.
    See cuDNN's cudnnConvolutionMode_t.
    """
    group_count: builtins.int
    """See cuDNN's group count."""
    convolution_mode: global___ConvolutionMode.ValueType
    name: builtins.str
    """Tensorflow node name, same as in NodeDef, for debugging purposes."""
    @property
    def paddings(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def strides(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def dilations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        paddings: collections.abc.Iterable[builtins.int] | None = ...,
        strides: collections.abc.Iterable[builtins.int] | None = ...,
        dilations: collections.abc.Iterable[builtins.int] | None = ...,
        compute_mode: global___DataType.ValueType | None = ...,
        group_count: builtins.int | None = ...,
        convolution_mode: global___ConvolutionMode.ValueType | None = ...,
        name: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["compute_mode", b"compute_mode", "convolution_mode", b"convolution_mode", "dilations", b"dilations", "group_count", b"group_count", "name", b"name", "paddings", b"paddings", "strides", b"strides"]) -> None: ...

global___ConvolutionDescriptorProto = ConvolutionDescriptorProto
