/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

abstract class AbstractResourcesOperation
extends AbstractWorkspaceOperation {
    protected IResourceSnapshot<? extends IResource>[] resourceDescriptions;

    private static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals((Object)superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    AbstractResourcesOperation(IResource[] resources, String label) {
        super(label);
        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
        this.setTargetResources(resources);
    }

    AbstractResourcesOperation(IResourceSnapshot<? extends IResource>[] resourceDescriptions, String label) {
        super(label);
        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
        this.setResourceDescriptions(resourceDescriptions);
    }

    protected void delete(IProgressMonitor monitor, IAdaptable uiInfo, boolean deleteContent) throws CoreException {
        this.setResourceDescriptions(WorkspaceUndoUtil.delete(this.resources, monitor, uiInfo, deleteContent));
        this.setTargetResources(new IResource[0]);
    }

    protected void recreate(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.setTargetResources(WorkspaceUndoUtil.recreate(this.resourceDescriptions, monitor, uiInfo));
        this.setResourceDescriptions(new IResourceSnapshot[0]);
    }

    protected IStatus computeCreateStatus(boolean allowOverwrite) {
        if (this.resourceDescriptions == null || this.resourceDescriptions.length == 0) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        IResourceSnapshot<? extends IResource>[] iResourceSnapshotArray = this.resourceDescriptions;
        int n = this.resourceDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceSnapshot<? extends IResource> resourceDescription = iResourceSnapshotArray[n2];
            if (resourceDescription == null || !resourceDescription.isValid()) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_InvalidRestoreInfo);
            }
            if (!allowOverwrite && resourceDescription.verifyExistence(false)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_ResourcesAlreadyExist);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected IStatus computeDeleteStatus() {
        if (this.resources == null || this.resources.length == 0) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        if (!this.resourcesExist()) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_ResourcesDoNotExist);
        }
        return this.checkReadOnlyResources(this.resources);
    }

    IStatus checkReadOnlyResources(IResource[] resourcesToCheck) {
        if (!this.quietCompute) {
            ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(null), IDEWorkbenchMessages.DeleteResourceAction_title1, IDEWorkbenchMessages.DeleteResourceAction_readOnlyQuestion);
            checker.setIgnoreLinkedResources(true);
            IResource[] approvedResources = checker.checkReadOnlyResources(resourcesToCheck);
            if (approvedResources.length == 0) {
                return Status.CANCEL_STATUS;
            }
            this.setTargetResources(approvedResources);
        }
        return Status.OK_STATUS;
    }

    protected void setResourceDescriptions(IResourceSnapshot<? extends IResource>[] descriptions) {
        this.resourceDescriptions = descriptions == null ? new IResourceSnapshot[0] : descriptions;
    }

    @Override
    protected void appendDescriptiveText(StringBuffer text) {
        super.appendDescriptiveText(text);
        text.append(" resourceDescriptions: ");
        text.append(this.resourceDescriptions);
        text.append('\'');
    }

    protected ISchedulingRule computeCreateSchedulingRule() {
        ISchedulingRule[] ruleArray = new ISchedulingRule[this.resourceDescriptions.length * 3];
        int i = 0;
        while (i < this.resourceDescriptions.length) {
            if (this.resourceDescriptions[i] != null) {
                IResource resource = this.resourceDescriptions[i].createResourceHandle();
                ruleArray[i * 3] = this.getWorkspaceRuleFactory().createRule(resource);
                ruleArray[i * 3 + 1] = this.getWorkspaceRuleFactory().modifyRule(resource);
                ruleArray[i * 3 + 2] = this.getWorkspaceRuleFactory().charsetRule(resource);
            }
            ++i;
        }
        return MultiRule.combine((ISchedulingRule[])ruleArray);
    }

    protected ISchedulingRule computeDeleteSchedulingRule() {
        ISchedulingRule[] ruleArray = new ISchedulingRule[this.resources.length * 2];
        int i = 0;
        while (i < this.resources.length) {
            ruleArray[i * 2] = this.getWorkspaceRuleFactory().deleteRule(this.resources[i]);
            ruleArray[i * 2 + 1] = this.getWorkspaceRuleFactory().modifyRule(this.resources[i]);
            ++i;
        }
        return MultiRule.combine((ISchedulingRule[])ruleArray);
    }

    @Override
    protected void setTargetResources(IResource[] targetResources) {
        HashSet<IResource> subResources = new HashSet<IResource>();
        IResource[] iResourceArray = targetResources;
        int n = targetResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource subResource = iResourceArray[n2];
            IResource[] iResourceArray2 = targetResources;
            int n3 = targetResources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource superResource = iResourceArray2[n4];
                if (AbstractResourcesOperation.isDescendantOf(subResource, superResource) && !subResources.contains(subResource)) {
                    subResources.add(subResource);
                }
                ++n4;
            }
            ++n2;
        }
        IResource[] nestedResourcesRemoved = new IResource[targetResources.length - subResources.size()];
        int j = 0;
        IResource[] iResourceArray3 = targetResources;
        int n5 = targetResources.length;
        int n6 = 0;
        while (n6 < n5) {
            IResource targetResource = iResourceArray3[n6];
            if (!subResources.contains(targetResource)) {
                nestedResourcesRemoved[j] = targetResource;
                ++j;
            }
            ++n6;
        }
        super.setTargetResources(nestedResourcesRemoved);
    }
}

